import { createVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { Component } from 'inferno';
import { inject } from 'table-js/lib/components';
import { closest as domClosest } from 'min-dom';
import { is, getBusinessObject } from 'dmn-js-shared/lib/util/ModelUtil';

var ResizeColumn =
/*#__PURE__*/
function (_Component) {
  _inherits(ResizeColumn, _Component);

  function ResizeColumn(props, context) {
    var _this;

    _classCallCheck(this, ResizeColumn);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ResizeColumn).call(this, props, context));

    _defineProperty(_assertThisInitialized(_this), "onElementsChanged", function () {
      _this.forceUpdate();
    });

    _defineProperty(_assertThisInitialized(_this), "handleMouseDown", function (event) {
      var cell = domClosest(event.target, 'th', false);
      startResize({
        node: cell,
        event: event,
        minWidth: _this.props.minWidth || 150,
        onEnd: _this.saveWidth
      });
    });

    _defineProperty(_assertThisInitialized(_this), "saveWidth", function (newWidth) {
      var col = _this.props.col;
      var update = {};

      if (is(col, 'dmn:DecisionTable')) {
        update.annotationsWidth = newWidth;
      } else {
        update.width = newWidth;
      }

      _this.modeling.updateProperties(col, update);
    });

    inject(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(ResizeColumn, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var root = this.getRoot();
      this.changeSupport.onElementsChanged(root, this.onElementsChanged);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var root = this.getRoot();
      this.changeSupport.offElementsChanged(root, this.onElementsChanged);
    }
  }, {
    key: "getRoot",
    value: function getRoot() {
      return this.sheet.getRoot();
    }
  }, {
    key: "isLastInputOrOutput",
    value: function isLastInputOrOutput() {
      var col = this.props.col,
          root = this.getRoot(),
          bo = getBusinessObject(root);

      if (is(col, 'dmn:InputClause')) {
        var inputs = bo.get('input');
        return inputs.indexOf(col) === inputs.length - 1;
      } else if (is(col, 'dmn:OutputClause')) {
        var outputs = bo.get('output');
        return outputs.indexOf(col) === outputs.length - 1;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var style = this.isLastInputOrOutput() ? {
        right: '-7px',
        width: '27px'
      } : null;
      return createVNode(1, "div", "resize-column-handle", null, 1, {
        "onMouseDown": this.handleMouseDown,
        "title": this.translate('Resize'),
        "style": style
      });
    }
  }]);

  return ResizeColumn;
}(Component);

export { ResizeColumn as default };
ResizeColumn.$inject = ['sheet', 'changeSupport', 'translate', 'modeling']; // helper

function startResize(_ref) {
  var node = _ref.node,
      event = _ref.event,
      minWidth = _ref.minWidth,
      _ref$onEnd = _ref.onEnd,
      onEnd = _ref$onEnd === void 0 ? noop : _ref$onEnd;
  event.preventDefault();
  var initialWidth = node.getBoundingClientRect().width;
  var initialX = event.clientX;
  var currentUpdate;
  document.addEventListener('mousemove', handleMouseMove);
  document.addEventListener('mouseup', handleMouseUp);

  function handleMouseMove(event) {
    event.preventDefault();
    var currentWidth = getResizedWidth(event.clientX);

    if (currentUpdate) {
      cancelAnimationFrame(currentUpdate);
    }

    currentUpdate = requestAnimationFrame(function () {
      node.style.width = currentWidth + 'px';
    });
  }

  function handleMouseUp(event) {
    event.preventDefault();
    document.removeEventListener('mousemove', handleMouseMove);
    document.removeEventListener('mouseup', handleMouseUp);
    var currentWidth = getResizedWidth(event.clientX);
    onEnd(currentWidth);
  }

  function getResizedWidth(currentX) {
    var delta = currentX - initialX;
    return Math.max(initialWidth + delta, minWidth);
  }
}

function noop() {}
//# sourceMappingURL=ResizeColumn.js.map