import { createVNode } from "inferno";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/* eslint-disable max-len */
import { is } from 'dmn-js-shared/lib/util/ModelUtil';
import { Cell } from 'table-js/lib/model';

var ContextMenu =
/*#__PURE__*/
function () {
  function ContextMenu(components, contextMenu, clipboard, editorActions, eventBus, elementRegistry, modeling, sheet, rules, translate) {
    var _this = this;

    _classCallCheck(this, ContextMenu);

    this._contextMenu = contextMenu;
    this._clipboard = clipboard;
    this._editorActions = editorActions;
    this._elementRegistry = elementRegistry;
    this._eventBus = eventBus;
    this._modeling = modeling;
    this._sheet = sheet;
    this._rules = rules;
    this._translate = translate;
    this._getEntries = this._getEntries.bind(this);
    components.onGetComponent('context-menu', function () {
      var context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      if (context.contextMenuType && context.contextMenuType === 'context-menu') {
        var entries = _this._getEntries(context);

        var element = _this._elementRegistry.get(context.id);

        var additionalCellEntries = isCell(element) && components.getComponents('context-menu-cell-additional', context);

        if (additionalCellEntries && additionalCellEntries.length) {
          var cellEntriesGroup = createVNode(1, "div", "context-menu-group context-menu-group-cell", additionalCellEntries, 0);
          return function () {
            return createVNode(1, "div", "context-menu-flex", (entries || []).concat(cellEntriesGroup), 0);
          };
        } else {
          return function () {
            return createVNode(1, "div", "context-menu-flex", entries || [], 0);
          };
        }
      }
    });
    eventBus.on('cell.contextmenu', function (_ref) {
      var event = _ref.event,
          id = _ref.id,
          node = _ref.node;
      event.preventDefault();
      contextMenu.open({
        x: event.pageX,
        y: event.pageY
      }, {
        contextMenuType: 'context-menu',
        event: event,
        id: id
      });
    });
  }

  _createClass(ContextMenu, [{
    key: "_getEntries",
    value: function _getEntries(context) {
      var _this2 = this;

      var handlers = {
        addRuleAbove: function addRuleAbove(rule) {
          _this2._editorActions.trigger('addRuleAbove', {
            rule: rule
          });

          _this2._contextMenu.close();
        },
        addRuleBelow: function addRuleBelow(rule) {
          _this2._editorActions.trigger('addRuleBelow', {
            rule: rule
          });

          _this2._contextMenu.close();
        },
        removeRule: function removeRule(rule) {
          _this2._editorActions.trigger('removeRule', {
            rule: rule
          });

          _this2._contextMenu.close();
        },
        addInputLeft: function addInputLeft(input) {
          _this2._editorActions.trigger('addInputLeft', {
            input: input
          });

          _this2._contextMenu.close();
        },
        addInputRight: function addInputRight(input) {
          _this2._editorActions.trigger('addInputRight', {
            input: input
          });

          _this2._contextMenu.close();
        },
        removeInput: function removeInput(input) {
          _this2._editorActions.trigger('removeInput', {
            input: input
          });

          _this2._contextMenu.close();
        },
        addOutputLeft: function addOutputLeft(output) {
          _this2._editorActions.trigger('addOutputLeft', {
            output: output
          });

          _this2._contextMenu.close();
        },
        addOutputRight: function addOutputRight(output) {
          _this2._editorActions.trigger('addOutputRight', {
            output: output
          });

          _this2._contextMenu.close();
        },
        removeOutput: function removeOutput(output) {
          _this2._editorActions.trigger('removeOutput', {
            output: output
          });

          _this2._contextMenu.close();
        },
        copy: function copy(element) {
          _this2._editorActions.trigger('copy', {
            element: element
          });

          _this2._contextMenu.close();
        },
        cut: function cut(element) {
          _this2._editorActions.trigger('cut', {
            element: element
          });

          _this2._contextMenu.close();
        },
        pasteBefore: function pasteBefore(element) {
          _this2._editorActions.trigger('pasteBefore', {
            element: element
          });

          _this2._contextMenu.close();
        },
        pasteAfter: function pasteAfter(element) {
          _this2._editorActions.trigger('pasteAfter', {
            element: element
          });

          _this2._contextMenu.close();
        }
      };
      var id = context && context.id;

      if (!id) {
        return null;
      }

      var element = this._elementRegistry.get(id);

      if (!element) {
        return null;
      }

      var clipboardData = this._clipboard.get() || {};
      var entries = [];
      var row = element.row || element;

      if (is(row, 'dmn:DecisionRule')) {
        var canPaste = this._rules.allowed('paste', {
          data: clipboardData.elements,
          target: row
        });

        entries.push(createVNode(1, "div", "context-menu-group", [createVNode(1, "div", "context-menu-group-entry context-menu-entry-copy-rule", this._translate('Copy Rule'), 0, {
          "onClick": function onClick() {
            return handlers.copy(row);
          }
        }), createVNode(1, "div", "context-menu-group-entry context-menu-entry-cut-rule", this._translate('Cut Rule'), 0, {
          "onClick": function onClick() {
            return handlers.cut(row);
          }
        }), createVNode(1, "div", "context-menu-group-entry ".concat(canPaste ? '' : 'disabled', " context-menu-entry-paste-rule-above"), this._translate('Paste Rule Above'), 0, {
          "onClick": function onClick() {
            return handlers.pasteBefore(row);
          }
        }), createVNode(1, "div", "context-menu-group-entry ".concat(canPaste ? '' : 'disabled', " context-menu-entry-paste-rule-below"), this._translate('Paste Rule Below'), 0, {
          "onClick": function onClick() {
            return handlers.pasteAfter(row);
          }
        })], 4), createVNode(1, "div", "context-menu-group", [createVNode(1, "div", "context-menu-group-entry context-menu-entry-add-rule-above", this._translate('Add Rule Above'), 0, {
          "onClick": function onClick() {
            return handlers.addRuleAbove(row);
          }
        }), createVNode(1, "div", "context-menu-group-entry context-menu-entry-add-rule-below", this._translate('Add Rule Below'), 0, {
          "onClick": function onClick() {
            return handlers.addRuleBelow(row);
          }
        }), createVNode(1, "div", "context-menu-group-entry context-menu-entry-remove-rule", this._translate('Remove Rule'), 0, {
          "onClick": function onClick() {
            return handlers.removeRule(row);
          }
        })], 4));
      } else if (is(element, 'dmn:InputClause')) {
        var actualElement = is(element, 'dmn:InputClause') ? element : element.col;

        var canRemove = this._rules.allowed('col.remove', {
          col: element.col || element
        });

        var _canPaste = this._rules.allowed('paste', {
          data: clipboardData.elements,
          target: element.col || element
        });

        entries.push(createVNode(1, "div", "context-menu-group", [createVNode(1, "div", "context-menu-group-entry context-menu-entry-copy-input", this._translate('Copy Input Column'), 0, {
          "onClick": function onClick() {
            return handlers.copy(actualElement);
          }
        }), createVNode(1, "div", "context-menu-group-entry ".concat(canRemove ? '' : 'disabled', " context-menu-entry-cut-input"), this._translate('Cut Input Column'), 0, {
          "onClick": function onClick() {
            return handlers.cut(actualElement);
          }
        }), createVNode(1, "div", "context-menu-group-entry ".concat(_canPaste ? '' : 'disabled', " context-menu-entry-paste-input-left"), this._translate('Paste Input Column Left'), 0, {
          "onClick": function onClick() {
            return handlers.pasteBefore(actualElement);
          }
        }), createVNode(1, "div", "context-menu-group-entry ".concat(_canPaste ? '' : 'disabled', " context-menu-entry-paste-input-right"), this._translate('Paste Input Column Right'), 0, {
          "onClick": function onClick() {
            return handlers.pasteAfter(actualElement);
          }
        })], 4), createVNode(1, "div", "context-menu-group", [createVNode(1, "div", "context-menu-group-entry context-menu-entry-add-input-left", this._translate('Add Input Column Left'), 0, {
          "onClick": function onClick() {
            return handlers.addInputLeft(actualElement);
          }
        }), createVNode(1, "div", "context-menu-group-entry context-menu-entry-add-input-right", this._translate('Add Input Column Right'), 0, {
          "onClick": function onClick() {
            return handlers.addInputRight(actualElement);
          }
        }), createVNode(1, "div", "context-menu-group-entry ".concat(canRemove ? '' : 'disabled', " context-menu-entry-remove-input"), this._translate('Remove Input Column'), 0, {
          "onClick": function onClick() {
            return handlers.removeInput(actualElement);
          }
        })], 4));
      } else if (is(element, 'dmn:OutputClause') || is(element.col, 'dmn:OutputClause')) {
        var _actualElement = is(element, 'dmn:OutputClause') ? element : element.col;

        var _canRemove = this._rules.allowed('col.remove', {
          col: element.col || element
        });

        var _canPaste2 = this._rules.allowed('paste', {
          data: clipboardData.elements,
          target: element.col || element
        });

        entries.push(createVNode(1, "div", "context-menu-group", [createVNode(1, "div", "context-menu-group-entry context-menu-entry-copy-output", this._translate('Copy Output Column'), 0, {
          "onClick": function onClick() {
            return handlers.copy(_actualElement);
          }
        }), createVNode(1, "div", "context-menu-group-entry ".concat(_canRemove ? '' : 'disabled', " context-menu-entry-cut-output"), this._translate('Cut Output Column'), 0, {
          "onClick": function onClick() {
            return handlers.cut(_actualElement);
          }
        }), createVNode(1, "div", "context-menu-group-entry ".concat(_canPaste2 ? '' : 'disabled', " context-menu-entry-paste-output-left"), this._translate('Paste Output Column Left'), 0, {
          "onClick": function onClick() {
            return handlers.pasteBefore(_actualElement);
          }
        }), createVNode(1, "div", "context-menu-group-entry ".concat(_canPaste2 ? '' : 'disabled', " context-menu-entry-paste-output-right"), this._translate('Paste Output Column Right'), 0, {
          "onClick": function onClick() {
            return handlers.pasteAfter(_actualElement);
          }
        })], 4), createVNode(1, "div", "context-menu-group", [createVNode(1, "div", "context-menu-group-entry context-menu-entry-add-output-left", this._translate('Add Output Column Left'), 0, {
          "onClick": function onClick() {
            return handlers.addOutputLeft(_actualElement);
          }
        }), createVNode(1, "div", "context-menu-group-entry context-menu-entry-add-output-right", this._translate('Add Output Column Right'), 0, {
          "onClick": function onClick() {
            return handlers.addOutputRight(_actualElement);
          }
        }), createVNode(1, "div", "context-menu-group-entry ".concat(_canRemove ? '' : 'disabled', " context-menu-entry-remove-output"), this._translate('Remove Output Column'), 0, {
          "onClick": function onClick() {
            return handlers.removeOutput(_actualElement);
          }
        })], 4));
      }

      return entries;
    }
  }]);

  return ContextMenu;
}();

export { ContextMenu as default };
ContextMenu.$inject = ['components', 'contextMenu', 'clipboard', 'editorActions', 'eventBus', 'elementRegistry', 'modeling', 'sheet', 'rules', 'translate']; // helpers ///////////

function isCell(element) {
  return element instanceof Cell;
}
//# sourceMappingURL=ContextMenu.js.map