function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var COMMANDS = ['row.add', 'row.remove', 'col.add', 'col.remove'];

var ContextMenuCloseBehavior = function ContextMenuCloseBehavior(contextMenu, eventBus) {
  _classCallCheck(this, ContextMenuCloseBehavior);

  eventBus.on('commandStack.executed', function (_ref) {
    var command = _ref.command;

    // close on certain modeling operations
    if (COMMANDS.indexOf(command) !== -1) {
      contextMenu.close();
    }
  }); // always close on undo

  eventBus.on('commandStack.reverted', function () {
    contextMenu.close();
  });
};

export { ContextMenuCloseBehavior as default };
ContextMenuCloseBehavior.$inject = ['contextMenu', 'eventBus'];
//# sourceMappingURL=ContextMenuCloseBehavior.js.map