function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import { isArray } from 'min-dash';
import CutHandler from './cmd/CutHandler';
import PasteHandler from './cmd/PasteHandler';
import { createDescriptor } from './DescriptorUtil';

var CutPaste =
/*#__PURE__*/
function () {
  function CutPaste(clipboard, commandStack, eventBus, modeling, sheet, rules) {
    _classCallCheck(this, CutPaste);

    this._clipboard = clipboard;
    this._commandStack = commandStack;
    this._eventBus = eventBus;
    this._modeling = modeling;
    this._sheet = sheet;
    this._rules = rules;
    commandStack.registerHandler('cut', CutHandler);
    commandStack.registerHandler('paste', PasteHandler);
  }
  /**
   * Copy elements.
   *
   * @param {Array} elements - Elements to be copied.
   */


  _createClass(CutPaste, [{
    key: "copy",
    value: function copy(elements) {
      if (!isArray(elements)) {
        elements = [elements];
      }

      var data = {
        elements: createDescriptor(elements)
      };

      this._eventBus.fire('copyCutPaste.copy', {
        data: data
      });

      this._clipboard.set(data);
    }
    /**
     * Cut elements thereby removing them temporarily.
     *
     * @param {Array} elements - Elements to be cut.
     */

  }, {
    key: "cut",
    value: function cut(elements) {
      if (!isArray(elements)) {
        elements = [elements];
      }

      var data = {
        elements: createDescriptor(elements),
        keepIds: true
      };
      var context = {
        elements: elements,
        data: data
      };

      this._eventBus.fire('copyCutPaste.cut', {
        data: data
      });

      this._commandStack.execute('cut', context);
    }
    /**
     * Paste rows or cols before row or col.
     *
     * @param {Row|Col} element - Row or col to paste elements before.
     */

  }, {
    key: "pasteBefore",
    value: function pasteBefore(element) {
      return this._paste(element, {
        before: true
      });
    }
    /**
     * Paste rows or cols after row or col.
     *
     * @param {Row|Col} element - Row or col to paste elements after.
     */

  }, {
    key: "pasteAfter",
    value: function pasteAfter(element) {
      return this._paste(element, {
        after: true
      });
    }
    /**
     * Basic paste onto given target element.
     */

  }, {
    key: "_paste",
    value: function _paste(target, position) {
      var clipboardData = this._clipboard.get();

      if (!clipboardData) {
        return undefined;
      }

      var allowed = this._rules.allowed('paste', {
        data: clipboardData.elements,
        target: target
      });

      if (!allowed) {
        return false;
      }

      this._commandStack.execute('paste', _objectSpread({
        element: target
      }, position)); // @bpmn-io: Clear clipboard to work around
      // https://github.com/camunda/camunda-modeler/issues/1246 which breaks native copy &
      // paste when row or column is copied or cut


      this._clipboard.clear(); // Return true to stop propagation and prevent native paste


      return true;
    }
    /**
     * Paste elements at.
     */

  }, {
    key: "pasteAt",
    value: function pasteAt(element) {// TODO: implement for pasting cells
    }
  }]);

  return CutPaste;
}();

export { CutPaste as default };
CutPaste.$inject = ['clipboard', 'commandStack', 'eventBus', 'modeling', 'sheet', 'rules'];
//# sourceMappingURL=CopyCutPaste.js.map