function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

import { isArray, forEach, keys, reduce } from 'min-dash'; // creating descriptors //////////

var createHooks = [copyTableProperties, copyBusinessObjectProperties];
var reviveHooks = [reviveBusinessObject, reviveTableElement];
/**
 * Return a serializable snapshot of the given elements.
 *
 * @param {Array<Base>} elements list of table elements
 *
 * @return {Tree} descriptor tree
 */

export function createDescriptor(element, cache, hooks) {
  hooks = hooks || createHooks;
  cache = cache || {};

  if (isArray(element)) {
    return createDescriptors0(element, cache, hooks);
  } else {
    return createDescriptor0(element, cache, hooks);
  }
}
/**
 * Create descriptors of elements, returning { descriptors: [], descriptorCache }.
 *
 * @param {Array<Base>} elements list of table elements
 * @param {Object} cache the create cache
 *
 * @return {Object} new descriptors + updated cache
 */

function createDescriptors0(elements, cache, hooks) {
  return reduce(elements, function (result, element) {
    var currentCache = result.descriptorCache,
        currentDescriptors = result.root;

    var _createDescriptor = createDescriptor0(element, currentCache, hooks),
        root = _createDescriptor.root,
        descriptorCache = _createDescriptor.descriptorCache;

    return {
      root: [].concat(_toConsumableArray(currentDescriptors), [root]),
      descriptorCache: _objectSpread({}, currentCache, {}, descriptorCache)
    };
  }, {
    root: [],
    descriptorCache: cache
  });
}

function createDescriptor0(element, cache, hooks) {
  var id = element.id;
  var descriptor = {
    id: id
  };
  var elements = cache.elements || {};
  var existingDescriptor = elements[id]; // element already created; nothing to do

  if (existingDescriptor) {
    return {
      root: existingDescriptor,
      descriptorCache: cache
    };
  } // we're new; need to initialize element via hooks
  // we assume we're not handling recursive data structures
  // here. Otherwise we'd need to pre-populate the cache
  // with the given element


  var element0 = evaluateHooks(element, descriptor, hooks, _objectSpread({}, cache, {
    elements: elements
  }));
  return {
    root: element0.root,
    descriptorCache: _objectSpread({}, element0.descriptorCache, {
      elements: _objectSpread({}, element0.descriptorCache.elements, _defineProperty({}, id, element0.root))
    })
  };
}

function evaluateHooks(element, descriptor, hooks, cache) {
  function create(element, descriptorCache) {
    return createDescriptor(element, descriptorCache, hooks);
  }

  return reduce(hooks, function (result, hook) {
    return hook(element, result.root, result.descriptorCache, create);
  }, {
    root: descriptor,
    descriptorCache: cache
  });
}

import { Row, Col, Cell } from 'table-js/lib/model';

function copyTableProperties(element, descriptor, cache, create) {
  var descriptorCache = cache;

  var newDesc = _objectSpread({}, descriptor, {
    type: getType(element)
  });

  if (element instanceof Row || element instanceof Col) {
    var cells0 = create(element.cells, descriptorCache);
    newDesc.cells = cells0.root;
    descriptorCache = cells0.descriptorCache;
  }

  return {
    root: newDesc,
    descriptorCache: descriptorCache
  };
}

function copyBusinessObjectProperties(element, descriptor, cache) {
  var businessObject = element.businessObject;

  if (!businessObject) {
    return {
      root: descriptor,
      descriptorCache: cache
    };
  } // need to clone businessObject


  var bo0 = createBoDescriptor(businessObject, cache);
  return {
    root: _objectSpread({}, descriptor, {
      businessObject: bo0.root
    }),
    descriptorCache: bo0.descriptorCache
  };
}

function getType(element) {
  if (element instanceof Row) {
    return 'row';
  }

  if (element instanceof Col) {
    return 'col';
  }

  if (element instanceof Cell) {
    return 'cell';
  }

  throw new Error('cannot deduce element type: #' + element.id);
}

function createBoDescriptor(bo, cache) {
  var boCache, existingBoDesc;
  var id = bo.id;

  if (id) {
    boCache = cache.boCache || {};
    existingBoDesc = boCache[id]; // businessObject already created; nothing to do

    if (existingBoDesc) {
      return {
        root: existingBoDesc,
        descriptorCache: cache
      };
    }
  }

  var descriptor = {
    $type: bo.$type
  };

  if (id) {
    descriptor.id = id;
    boCache = _objectSpread({}, boCache, _defineProperty({}, id, descriptor));
    cache = _objectSpread({}, cache, {
      boCache: boCache
    });
  } // TODO(nikku): distinguish relations and containment
  // Need to build up the whole tree and revive relations afterwards
  // ITERATE OVER ALL SET PROPERTIES
  // (Object.keys(bo) or via bo.$descriptor....)


  bo.$descriptor.properties.forEach(function (property) {
    var value = bo[property.name]; // const propertyDescriptor = bo.$model.getPropertyDescriptor(bo, property.name),
    //       isId = propertyDescriptor.isId,
    //       isReference = propertyDescriptor.isReference;
    // not set

    if (!value) {
      return;
    } // arrays of moddle elements


    if (isArray(value)) {
      value = value.map(function (b) {
        var value0 = createBoDescriptor(b, cache);
        cache = value0.descriptorCache;
        return value0.root;
      });
    } // moddle elements


    if (value.$type) {
      var value0 = createBoDescriptor(value, cache);
      cache = value0.descriptorCache;
      value = value0.root;
    } // other values


    descriptor[property.name] = value;
  });
  return {
    root: descriptor,
    descriptorCache: cache
  };
} // reviving //////////


export function reviveDescriptor(entry, reviveCache, hooks) {
  hooks = hooks || reviveHooks;
  reviveCache = reviveCache || {};

  if (isArray(entry.root)) {
    return reviveDescriptors0(entry, reviveCache, hooks);
  } else {
    return reviveDescriptor0(entry, reviveCache, hooks);
  }
}
/**
 * TBD: document this!
 *
 * @param  {[type]} entry       [description]
 * @param  {[type]} reviveCache [description]
 * @param  {[type]} hooks       [description]
 * @return {[type]}             [description]
 */

function reviveDescriptors0(entry, reviveCache, hooks) {
  var descriptors = entry.root;
  var descriptorCache = entry.descriptorCache;
  return reduce(descriptors, function (result, element) {
    var currentCache = result.reviveCache,
        currentDescriptors = result.root;

    var _reviveDescriptor = reviveDescriptor0({
      root: element,
      descriptorCache: descriptorCache
    }, currentCache, hooks),
        root = _reviveDescriptor.root,
        reviveCache = _reviveDescriptor.reviveCache;

    return {
      root: [].concat(_toConsumableArray(currentDescriptors), [root]),
      reviveCache: reviveCache
    };
  }, {
    root: [],
    reviveCache: reviveCache
  });
}
/**
 * TBD: document this!
 *
 * @param  {[type]} entry [description]
 * @param  {[type]} cache [description]
 * @param  {[type]} hooks [description]
 * @return {[type]}       [description]
 */


function reviveDescriptor0(entry, reviveCache, hooks) {
  var descriptor = entry.root;
  var id = descriptor.id;
  var elements = reviveCache.elements || {};
  var existingElement = elements[id]; // element already created; nothing to do

  if (existingElement) {
    return {
      root: existingElement,
      reviveCache: reviveCache
    };
  } // start with a fake element; haha <3


  var element = {
    id: id
  }; // we're new; need to initialize element via hooks

  var element0 = evaluateReviveHooks(entry, element, hooks, _objectSpread({}, reviveCache, {
    elements: elements
  }));
  return {
    root: element0.root,
    reviveCache: _objectSpread({}, element0.reviveCache, {
      elements: _objectSpread({}, element0.reviveCache.elements, _defineProperty({}, id, element0.root))
    })
  };
} // entry = { root, descriptorCache }
// element = { id: foo }
// hooks = [ ... ]
// reviveCache = { ... }


function evaluateReviveHooks(entry, element, hooks, reviveCache) {
  function revive(entry, reviveCache) {
    return reviveDescriptor(entry, reviveCache, hooks);
  }

  return reduce(hooks, function (result, hook) {
    return hook(entry, result.root, result.reviveCache, revive);
  }, {
    root: element,
    reviveCache: reviveCache
  });
}

function reviveTableElement(entry, element, reviveCache, revive) {
  var descriptor = entry.root;
  var createCache = entry.descriptorCache;

  var elementAttrs = _objectSpread({}, element); // make sure table element ID is same as moddle element ID


  if (element.businessObject && element.businessObject.id) {
    elementAttrs.id = element.businessObject.id;
  }

  if (descriptor.type === 'row' || descriptor.type === 'col') {
    var cells0 = revive({
      root: descriptor.cells,
      descriptorCache: createCache
    }, reviveCache);
    elementAttrs.cells = cells0.root;
    reviveCache = cells0.reviveCache;
  }

  var Constructor = getConstructor(descriptor);
  var newElement = new Constructor(elementAttrs); // set parent row or col

  if (newElement instanceof Row) {
    newElement.cells.forEach(function (cell) {
      cell.row = newElement;
    });
  } else if (newElement instanceof Col) {
    newElement.cells.forEach(function (cell) {
      cell.col = newElement;
    });
  }

  return {
    root: newElement,
    reviveCache: reviveCache
  };
}

function reviveBusinessObject(entry, element, reviveCache) {
  var businessObject = entry.root.businessObject;

  if (!businessObject) {
    return {
      root: element,
      reviveCache: reviveCache
    };
  } // need to clone businessObject


  var bo0 = createBo({
    root: businessObject,
    descriptorCache: entry.descriptorCache
  }, reviveCache);
  return {
    root: _objectSpread({}, element, {
      businessObject: bo0.root
    }),
    reviveCache: bo0.reviveCache
  };
}

function getConstructor(descriptor) {
  switch (descriptor.type) {
    case 'row':
      return Row;

    case 'cell':
      return Cell;

    case 'col':
      return Col;

    default:
      throw new Error('unknown element type: #' + descriptor.type);
  }
}

function createBo(entry, reviveCache) {
  var boDescriptor = entry.root;
  var id = boDescriptor.id;
  var boCache, existingBo;

  if (id) {
    boCache = reviveCache.boCache || {};
    existingBo = boCache[id]; // businessObject already created; nothing to do

    if (existingBo) {
      return {
        root: existingBo,
        reviveCache: reviveCache
      };
    }
  }

  var newBoAttrs = {}; // set attrs for new business object (might include creating other business objects)

  keys(boDescriptor).forEach(function (key) {
    var val, val0;

    if (boDescriptor[key].$type) {
      val0 = createBo({
        root: boDescriptor[key]
      }, reviveCache);
      val = val0.root;
      reviveCache = val0.reviveCache;
      boCache = reviveCache.boCache || {};
    } else if (isArray(boDescriptor[key])) {
      val = boDescriptor[key].map(function (b) {
        val0 = createBo({
          root: b
        }, reviveCache);
        reviveCache = val0.reviveCache;
        boCache = reviveCache.boCache || {};
        return val0.root;
      });
    } else {
      val = boDescriptor[key];
    }

    newBoAttrs[key] = val;
  });
  var type = newBoAttrs.$type;
  delete newBoAttrs.$type; // generate new ID if not supposed to be kept or already assigned

  if (!reviveCache._keepIds || reviveCache._model.ids.assigned(newBoAttrs.id)) {
    delete newBoAttrs.id;
  }

  var newBo = reviveCache._dmnFactory.create(type, newBoAttrs); // set up $parent relationships for moddle elements


  forEach(newBoAttrs, function (newBoAttr) {
    if (newBoAttr.$type) {
      newBoAttr.$parent = newBo;
    }

    if (isArray(newBoAttr)) {
      newBoAttr.forEach(function (a) {
        return a.$parent = newBo;
      });
    }
  });

  if (id) {
    boCache = _objectSpread({}, boCache, _defineProperty({}, id, newBo));
    reviveCache = _objectSpread({}, reviveCache, {
      boCache: boCache
    });
  }

  return {
    root: newBo,
    reviveCache: reviveCache
  };
}
//# sourceMappingURL=DescriptorUtil.js.map