function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import { Row, Col } from 'table-js/lib/model';
/**
 * A handler that implements cutting a row or col.
 * Cutting of cells doesn't make sense.
 */

var CutHandler =
/*#__PURE__*/
function () {
  function CutHandler(clipboard, modeling, sheet) {
    _classCallCheck(this, CutHandler);

    this._clipboard = clipboard;
    this._modeling = modeling;
    this._sheet = sheet;
  }
  /**
   * <do>
   */


  _createClass(CutHandler, [{
    key: "execute",
    value: function execute(context) {
      var data = context.data;
      context.oldData = this._clipboard.get();

      this._clipboard.set(data);

      return this._sheet.getRoot();
    }
  }, {
    key: "postExecute",
    value: function postExecute(context) {
      var _this = this;

      var elements = context.elements;
      elements.forEach(function (element) {
        if (element instanceof Row) {
          _this._modeling.removeRow(element);
        } else if (element instanceof Col) {
          _this._modeling.removeCol(element);
        }
      });
    }
    /**
     * <undo>
     */

  }, {
    key: "revert",
    value: function revert(context) {
      var oldData = context.oldData;

      this._clipboard.set(oldData);

      return this._sheet.getRoot();
    }
  }]);

  return CutHandler;
}();

export { CutHandler as default };
CutHandler.$inject = ['clipboard', 'modeling', 'sheet'];
//# sourceMappingURL=CutHandler.js.map