function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import { Row, Col } from 'table-js/lib/model';
import { reviveDescriptor } from '../DescriptorUtil';
/**
 * A handler that implements pasting elements.
 */

var PasteHandler =
/*#__PURE__*/
function () {
  function PasteHandler(clipboard, dmnFactory, elementFactory, elementRegistry, eventBus, moddle, modeling, sheet) {
    _classCallCheck(this, PasteHandler);

    this._clipboard = clipboard;
    this._dmnFactory = dmnFactory;
    this._elementFactory = elementFactory;
    this._elementRegistry = elementRegistry;
    this._eventBus = eventBus;
    this._model = moddle;
    this._modeling = modeling;
    this._sheet = sheet;
  }
  /**
   * <do>
   */


  _createClass(PasteHandler, [{
    key: "postExecute",
    value: function postExecute(context) {
      var _this = this;

      var element = context.element,
          after = context.after;

      var data = this._clipboard.get();

      if (!data) {
        throw new Error('missing clipboard data');
      }

      var root = this._sheet.getRoot(); // (1) create elements from descriptors


      var elements = reviveDescriptor(data.elements, {
        _dmnFactory: this._dmnFactory,
        _keepIds: data.keepIds,
        _model: this._model
      }).root; // (2) add elements to sheet

      if (element instanceof Row) {
        var index = root.rows.indexOf(element);

        if (index === -1) {
          return;
        }

        elements.forEach(function (element) {
          if (after) {
            index++;
          }

          _this._modeling.addRow(element, index);
        });
      } else if (element instanceof Col) {
        var _index = root.cols.indexOf(element);

        if (_index === -1) {
          return;
        }

        elements.forEach(function (element) {
          if (after) {
            _index++;
          }

          _this._modeling.addCol(element, _index);
        });
      }

      context.oldElements = this._clipboard.get();
      return this._sheet.getRoot();
    }
    /**
     * <undo>
     */

  }, {
    key: "revert",
    value: function revert(context) {}
  }]);

  return PasteHandler;
}();

export { PasteHandler as default };
PasteHandler.$inject = ['clipboard', 'dmnFactory', 'elementFactory', 'elementRegistry', 'eventBus', 'moddle', 'modeling', 'sheet'];
//# sourceMappingURL=PasteHandler.js.map