function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { getRange } from 'selection-ranges';
import { event as domEvent } from 'min-dom';
import { getFocusableNode, getNodeById } from '../../cell-selection/CellSelectionUtil';
import { isCmd, isShift } from '../../keyboard/KeyboardUtil';
/**
 * Keybindings for Copy + Paste
 */

var CopyPasteKeyBindings =
/*#__PURE__*/
function () {
  function CopyPasteKeyBindings(injector, eventBus, clipboard, cellSelection, elementRegistry, editorActions, renderer) {
    var _this = this;

    _classCallCheck(this, CopyPasteKeyBindings);

    _defineProperty(this, "_clearClipboard", function () {
      _this._clipboard.clear();
    });

    _defineProperty(this, "_registerBindings", function () {
      // copy
      // CTRL/CMD + C
      var copy = function copy(key, modifiers) {
        if (isCmd(modifiers) && key === 67) {
          var cell = _this._getSelectedCell();

          if (!cell) {
            return;
          }

          if (isShift(modifiers)) {
            _this._editorActions.trigger('copy', {
              element: cell.col
            });
          } else {
            _this._editorActions.trigger('copy', {
              element: cell.row
            });
          }

          return true;
        }
      }; // cut
      // CTRL/CMD + X


      var cut = function cut(key, modifiers) {
        if (isCmd(modifiers) && key === 88) {
          var cell = _this._getSelectedCell();

          if (!cell) {
            return;
          }

          if (isShift(modifiers)) {
            _this._editorActions.trigger('cut', {
              element: cell.col
            });
          } else {
            _this._editorActions.trigger('cut', {
              element: cell.row
            });
          }

          return true;
        }
      }; // paste
      // CTRL/CMD + V


      var paste = function paste(key, modifiers) {
        var pasted;

        if (isCmd(modifiers) && key === 86) {
          var cell = _this._getSelectedCell();

          if (!cell) {
            return;
          }

          if (isShift(modifiers)) {
            pasted = _this._editorActions.trigger('pasteAfter', {
              element: cell.col
            });

            if (pasted) {
              _this._cellSelection.selectCell('right');
            }
          } else {
            pasted = _this._editorActions.trigger('pasteAfter', {
              element: cell.row
            });

            if (pasted) {
              _this._cellSelection.selectCell('below');
            }
          }
        } // indicate, whether we could paste


        return typeof pasted !== 'undefined';
      }; // register listeners


      [copy, cut, paste].forEach(function (l) {
        _this._keyboard.addListener(l);
      });
    });

    this._clipboard = clipboard;
    this._cellSelection = cellSelection;
    this._elementRegistry = elementRegistry;
    this._editorActions = editorActions;
    this._keyboard = injector.get('keyboard', false);
    this._renderer = renderer;

    if (!this._keyboard) {
      return;
    }

    eventBus.on('keyboard.init', this._registerBindings);
    eventBus.on('keyboard.bind', function () {
      domEvent.bind(document, 'copy', _this._clearClipboard, true);
      domEvent.bind(document, 'cut', _this._clearClipboard, true);
    });
    eventBus.on('keyboard.unbind', function () {
      domEvent.unbind(document, 'copy', _this._clearClipboard, true);
      domEvent.unbind(document, 'cut', _this._clearClipboard, true);
    });
  }

  _createClass(CopyPasteKeyBindings, [{
    key: "_getSelectedCell",

    /**
     * Return the selected cell within the decision table.
     *
     * This verifies that a cell ready for copy-or-paste is
     * actual selected by the user, in the Browser UI.
     *
     * @return {Cell}
     */
    value: function _getSelectedCell() {
      var elementId = this._cellSelection.getCellSelection(); // we may have no selection


      if (!elementId) {
        return;
      }

      var cell = this._elementRegistry.get(elementId); // selection may not be a cell


      if (!cell) {
        return;
      }

      var container = this._renderer.getContainer();

      var node = getNodeById(elementId, container);
      var focusableNode = getFocusableNode(node); // focusable element in selection may not be actual
      // browser focus, i.e. when a menu is open

      if (document.activeElement !== focusableNode) {
        return;
      }

      var range = getRange(node); // user may attempt native copy-paste operation right now
      // don't interfere with normal text copying

      if (range && range.start !== range.end) {
        return;
      }

      return cell;
    }
  }]);

  return CopyPasteKeyBindings;
}();

export { CopyPasteKeyBindings as default };
CopyPasteKeyBindings.$inject = ['injector', 'eventBus', 'clipboard', 'cellSelection', 'elementRegistry', 'editorActions', 'renderer'];
//# sourceMappingURL=CopyCutPasteKeyBindings.js.map