function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import CreateInputsHeaderCell from './components/CreateInputHeaderCell';
import CreateInputsCell from './components/CreateInputCell';
var LOW_PRIORITY = 500;

var CreateInputsProvider = function CreateInputsProvider(components, sheet) {
  _classCallCheck(this, CreateInputsProvider);

  components.onGetComponent('cell', LOW_PRIORITY, function (_ref) {
    var cellType = _ref.cellType;

    var _sheet$getRoot = sheet.getRoot(),
        businessObject = _sheet$getRoot.businessObject;

    if (businessObject.input && businessObject.input.length) {
      return;
    }

    if (cellType === 'before-label-cells') {
      return CreateInputsHeaderCell;
    } else if (cellType === 'before-rule-cells') {
      return CreateInputsCell;
    }
  });
};

export { CreateInputsProvider as default };
CreateInputsProvider.$inject = ['components', 'sheet'];
//# sourceMappingURL=CreateInputsProvider.js.map