import { createVNode, createComponentVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

import { Component } from 'inferno';
import { isString } from 'min-dash';
import { is } from 'dmn-js-shared/lib/util/ModelUtil';
import EditableComponent from 'dmn-js-shared/lib/components/EditableComponent';
import { Cell } from 'table-js/lib/components';

var DecisionRulesEditorCellComponent =
/*#__PURE__*/
function (_Component) {
  _inherits(DecisionRulesEditorCellComponent, _Component);

  function DecisionRulesEditorCellComponent(props, context) {
    var _this;

    _classCallCheck(this, DecisionRulesEditorCellComponent);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DecisionRulesEditorCellComponent).call(this, props, context));
    _this.state = {
      isFocussed: false
    };
    _this.changeCellValue = _this.changeCellValue.bind(_assertThisInitialized(_this));
    _this.onFocus = _this.onFocus.bind(_assertThisInitialized(_this));
    _this.onBlur = _this.onBlur.bind(_assertThisInitialized(_this));
    _this.onElementsChanged = _this.onElementsChanged.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(DecisionRulesEditorCellComponent, [{
    key: "onElementsChanged",
    value: function onElementsChanged() {
      this.forceUpdate();
    }
  }, {
    key: "componentWillMount",
    value: function componentWillMount() {
      var injector = this.context.injector;
      var cell = this.props.cell;
      var changeSupport = this._changeSupport = this.context.changeSupport;
      this._modeling = injector.get('modeling');
      changeSupport.onElementsChanged(cell.id, this.onElementsChanged);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var cell = this.props.cell;

      this._changeSupport.offElementsChanged(cell.id, this.onElementsChanged);
    }
  }, {
    key: "changeCellValue",
    value: function changeCellValue(value) {
      var cell = this.props.cell;

      this._modeling.editCell(cell.businessObject, value);
    }
  }, {
    key: "onFocus",
    value: function onFocus() {
      this.setState({
        isFocussed: true
      });
    }
  }, {
    key: "onBlur",
    value: function onBlur() {
      this.setState({
        isFocussed: false
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          cell = _this$props.cell,
          rowIndex = _this$props.rowIndex,
          row = _this$props.row,
          col = _this$props.col,
          colIndex = _this$props.colIndex;
      var isFocussed = this.state.isFocussed;
      var isUnaryTest = is(cell, 'dmn:UnaryTests');
      var businessObject = cell.businessObject;
      return createComponentVNode(2, Cell, {
        "className": isUnaryTest ? 'input-cell' : 'output-cell',
        "elementId": cell.id,
        "coords": "".concat(rowIndex, ":").concat(colIndex),
        "data-row-id": row.id,
        "data-col-id": col.id,
        children: createComponentVNode(2, TableCellEditor, {
          "className": "cell-editor",
          "placeholder": isUnaryTest ? '-' : '',
          "ctrlForNewline": true,
          "onFocus": this.onFocus,
          "onBlur": this.onBlur,
          "isFocussed": isFocussed,
          "onChange": this.changeCellValue,
          "value": businessObject.text,
          "businessObject": businessObject
        })
      });
    }
  }]);

  return DecisionRulesEditorCellComponent;
}(Component);

export { DecisionRulesEditorCellComponent as default };

var TableCellEditor =
/*#__PURE__*/
function (_EditableComponent) {
  _inherits(TableCellEditor, _EditableComponent);

  function TableCellEditor(props, context) {
    var _this2;

    _classCallCheck(this, TableCellEditor);

    _this2 = _possibleConstructorReturn(this, _getPrototypeOf(TableCellEditor).call(this, props, context));
    _this2._expressionLanguages = context.injector.get('expressionLanguages');
    _this2._translate = context.injector.get('translate');
    return _this2;
  }

  _createClass(TableCellEditor, [{
    key: "isDefaultExpressionLanguage",
    value: function isDefaultExpressionLanguage(businessObject) {
      var expressionLanguage = businessObject.expressionLanguage;
      var defaultExpressionLanguage = this.getDefaultExpressionLanguage(businessObject).value;
      return !expressionLanguage || expressionLanguage === defaultExpressionLanguage;
    }
  }, {
    key: "getDescription",
    value: function getDescription(businessObject) {
      return businessObject.description;
    }
  }, {
    key: "getExpressionLanguageLabel",
    value: function getExpressionLanguageLabel(businessObject) {
      var expressionLanguage = businessObject.expressionLanguage;
      var defaultExpressionLanguage = this.getDefaultExpressionLanguage(businessObject);
      return this._expressionLanguages.getLabel(expressionLanguage) || defaultExpressionLanguage.label;
    }
  }, {
    key: "isScript",
    value: function isScript(businessObject) {
      var defaultExpressionLanguage = this.getDefaultExpressionLanguage(businessObject);
      var isInputCell = is(businessObject, 'dmn:UnaryTests');

      if (!isInputCell) {
        return false;
      }

      if (businessObject.text.indexOf('\n') !== -1) {
        return true;
      }

      return businessObject.expressionLanguage && businessObject.expressionLanguage !== defaultExpressionLanguage;
    }
  }, {
    key: "getDefaultExpressionLanguage",
    value: function getDefaultExpressionLanguage(businessObject) {
      var elementType = is(businessObject, 'dmn:UnaryTests') ? 'inputCell' : 'outputCell';
      return this._expressionLanguages.getDefault(elementType);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          businessObject = _this$props2.businessObject,
          isFocussed = _this$props2.isFocussed;
      var description = this.getDescription(businessObject);
      var isDefaultExpressionLanguage = this.isDefaultExpressionLanguage(businessObject);
      var expressionLanguageLabel = this.getExpressionLanguageLabel(businessObject);
      var isScript = this.isScript(businessObject);
      return createVNode(1, "div", this.getClassName(), [isString(description) && !isFocussed && createVNode(1, "div", "description-indicator"), this.getEditor({
        className: isScript ? 'script-editor' : null
      }), !isDefaultExpressionLanguage && !isFocussed && createVNode(1, "span", "dms-badge dmn-expression-language", [createVNode(1, "span", "dms-badge-icon dmn-icon-file-code"), createVNode(1, "span", "dms-badge-label", expressionLanguageLabel, 0)], 4, {
        "title": this._translate('Expression Language = {expressionLanguageLabel}', {
          expressionLanguageLabel: expressionLanguageLabel
        })
      })], 0);
    }
  }]);

  return TableCellEditor;
}(EditableComponent);
//# sourceMappingURL=DecisionRulesCellEditorComponent.js.map