import { createVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { is, getBusinessObject } from 'dmn-js-shared/lib/util/ModelUtil';
import { Component } from 'inferno';
import { mixin } from 'table-js/lib/components';
import { ComponentWithSlots } from 'dmn-js-shared/lib/components/mixins';

var DecisionTableHead =
/*#__PURE__*/
function (_Component) {
  _inherits(DecisionTableHead, _Component);

  function DecisionTableHead(props, context) {
    var _this;

    _classCallCheck(this, DecisionTableHead);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DecisionTableHead).call(this, props, context));

    _defineProperty(_assertThisInitialized(_this), "onElementsChanged", function () {
      _this.forceUpdate();
    });

    mixin(_assertThisInitialized(_this), ComponentWithSlots);
    _this._sheet = context.injector.get('sheet');
    _this._changeSupport = context.changeSupport;
    return _this;
  }

  _createClass(DecisionTableHead, [{
    key: "componentWillMount",
    value: function componentWillMount() {
      var root = this._sheet.getRoot();

      this._changeSupport.onElementsChanged(root.id, this.onElementsChanged);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var root = this._sheet.getRoot();

      this._changeSupport.offElementsChanged(root.id, this.onElementsChanged);
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var root = this._sheet.getRoot();

      if (!is(root, 'dmn:DMNElement')) {
        return null;
      }

      var businessObject = getBusinessObject(root);
      var inputs = businessObject.input,
          outputs = businessObject.output;
      return createVNode(1, "thead", null, createVNode(1, "tr", null, [createVNode(1, "th", "index-column"), this.slotFills({
        type: 'cell',
        context: {
          cellType: 'before-label-cells'
        }
      }), inputs && inputs.map(function (input, index) {
        var width = input.width || '192px';
        return _this2.slotFill({
          type: 'cell',
          context: {
            cellType: 'input-header',
            input: input,
            index: index,
            inputsLength: inputs.length,
            width: width
          },
          key: input.id
        }, DefaultInputHeaderCell);
      }), outputs.map(function (output, index) {
        return _this2.slotFill({
          type: 'cell',
          context: {
            cellType: 'output-header',
            output: output,
            index: index,
            outputsLength: outputs.length
          },
          key: output.id
        }, DefaultOutputHeaderCell);
      }), this.slotFills({
        type: 'cell',
        context: {
          cellType: 'after-label-cells'
        }
      })], 0), 2);
    }
  }]);

  return DecisionTableHead;
}(Component); // default components ///////////////////////


export { DecisionTableHead as default };

function DefaultInputHeaderCell(props, context) {
  var input = props.input,
      className = props.className,
      index = props.index;
  var label = input.label,
      inputExpression = input.inputExpression,
      inputValues = input.inputValues;
  var translate = context.injector.get('translate');
  var actualClassName = (className || '') + ' input-cell';
  return createVNode(1, "th", actualClassName, [createVNode(1, "div", "clause", index === 0 ? translate('When') : translate('And'), 0), label ? createVNode(1, "div", "input-label", label, 0, {
    "title": translate('Input Label')
  }) : createVNode(1, "div", "input-expression", inputExpression.text, 0, {
    "title": translate('Input Expression')
  }), createVNode(1, "div", "input-variable", inputValues && inputValues.text || inputExpression.typeRef, 0, {
    "title": inputValues && inputValues.text ? translate('Input Values') : translate('Input Type')
  })], 0, {
    "data-col-id": input.id
  }, input.id);
}

function DefaultOutputHeaderCell(props, context) {
  var output = props.output,
      className = props.className,
      index = props.index;
  var label = output.label,
      name = output.name,
      outputValues = output.outputValues,
      typeRef = output.typeRef;
  var translate = context.injector.get('translate');
  var actualClassName = (className || '') + ' output-cell';
  return createVNode(1, "th", actualClassName, [createVNode(1, "div", "clause", index === 0 ? translate('Then') : translate('And'), 0), label ? createVNode(1, "div", "output-label", label, 0, {
    "title": translate('Output Label')
  }) : createVNode(1, "div", "output-name", name, 0, {
    "title": translate('Output Name')
  }), createVNode(1, "div", "output-variable", outputValues && outputValues.text || typeRef, 0, {
    "title": outputValues && outputValues.text ? translate('Output Values') : translate('Output Type')
  })], 0, null, output.id);
}
//# sourceMappingURL=DecisionTableHead.js.map