import { createVNode, createComponentVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { Component } from 'inferno';
import EditableComponent from 'dmn-js-shared/lib/components/EditableComponent';
import { inject, mixin, classNames, SelectionAware } from 'table-js/lib/components';

var DecisionTablePropertiesComponent =
/*#__PURE__*/
function (_Component) {
  _inherits(DecisionTablePropertiesComponent, _Component);

  function DecisionTablePropertiesComponent(props, context) {
    var _this;

    _classCallCheck(this, DecisionTablePropertiesComponent);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DecisionTablePropertiesComponent).call(this, props, context));

    _defineProperty(_assertThisInitialized(_this), "onElementsChanged", function () {
      _this.forceUpdate();
    });

    _defineProperty(_assertThisInitialized(_this), "setDecisionTableName", function (name) {
      _this.modeling.editDecisionTableName(name);
    });

    inject(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(DecisionTablePropertiesComponent, [{
    key: "componentWillMount",
    value: function componentWillMount() {
      this.setupChangeListeners({
        bind: this.getBusinessObject().id
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.setupChangeListeners({
        unbind: this.getBusinessObject().id
      });
    }
  }, {
    key: "setupChangeListeners",
    value: function setupChangeListeners(_ref) {
      var bind = _ref.bind,
          unbind = _ref.unbind;

      if (typeof unbind === 'string') {
        this.changeSupport.offElementsChanged(unbind, this.onElementsChanged);
      }

      if (typeof bind === 'string') {
        this.changeSupport.onElementsChanged(bind, this.onElementsChanged);
      }
    }
  }, {
    key: "getBusinessObject",
    value: function getBusinessObject() {
      return this.sheet.getRoot().businessObject.$parent;
    }
  }, {
    key: "render",
    value: function render() {
      var bo = this.getBusinessObject();
      var name = bo.name;
      var HitPolicy = this.components.getComponent('hit-policy') || NullComponent;
      return createVNode(1, "div", "decision-table-properties", [createComponentVNode(2, DecisionTableName, {
        "className": "decision-table-name",
        "value": name,
        "ctrlForNewline": true,
        "onBlur": resetScroll,
        "onChange": this.setDecisionTableName,
        "elementId": '__decisionProperties_name',
        "coords": '0:__decisionProperties'
      }), createVNode(1, "div", "decision-table-header-separator"), createComponentVNode(2, HitPolicy)], 4);
    }
  }]);

  return DecisionTablePropertiesComponent;
}(Component);

export { DecisionTablePropertiesComponent as default };
DecisionTablePropertiesComponent.$inject = ['sheet', 'modeling', 'changeSupport', 'components'];

var DecisionTableName =
/*#__PURE__*/
function (_EditableComponent) {
  _inherits(DecisionTableName, _EditableComponent);

  function DecisionTableName(props, context) {
    var _this2;

    _classCallCheck(this, DecisionTableName);

    _this2 = _possibleConstructorReturn(this, _getPrototypeOf(DecisionTableName).call(this, props, context));
    mixin(_assertThisInitialized(_this2), SelectionAware);
    return _this2;
  }

  _createClass(DecisionTableName, [{
    key: "render",
    value: function render() {
      var name = this.props.value;
      var className = classNames(this.getSelectionClasses(), this.getClassName());
      return createVNode(1, "div", className, this.getEditor(), 0, {
        "data-element-id": this.props.elementId,
        "data-coords": this.props.coords,
        "title": 'Decision Name: ' + name
      });
    }
  }]);

  return DecisionTableName;
}(EditableComponent);

function NullComponent() {
  return null;
}

function resetScroll(event) {
  event.target.scroll(0, 0);
}
//# sourceMappingURL=DecisionTablePropertiesEditorComponent.js.map