import { createVNode } from "inferno";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { isString } from 'min-dash';
import { isAny } from 'dmn-js-shared/lib/util/ModelUtil';
import { getNodeById } from '../cell-selection/CellSelectionUtil';
import DescriptionEditor from './components/DescriptionEditor';
var LOW_PRIORITY = 500;
var LOWER_PRIORITY = 750;
var OFFSET_X = 26;

var Description = function Description(components, contextMenu, elementRegistry, eventBus, modeling, renderer, translate) {
  var _this = this;

  _classCallCheck(this, Description);

  _defineProperty(this, "addDescription", function (cell) {
    _this._modeling.updateProperties(cell, {
      description: ''
    });

    var container = _this._renderer.getContainer();

    var node = getNodeById(cell.id, container);
    var bounds = node.getBoundingClientRect();
    var position = getPosition(container, bounds);

    _this._contextMenu.open(position, {
      contextMenuType: 'cell-description',
      id: cell.id,
      autoFocus: true,
      offset: {
        x: 4,
        y: 4
      }
    });
  });

  _defineProperty(this, "removeDescription", function (cell) {
    _this._modeling.updateProperties(cell, {
      description: null
    });

    _this._contextMenu.close();
  });

  this._contextMenu = contextMenu;
  this._modeling = modeling;
  this._renderer = renderer;
  this._translate = translate;
  eventBus.on('cell.click', LOWER_PRIORITY, function (event) {
    if (event.defaultPrevented) {
      return;
    }

    var target = event.target,
        id = event.id;
    var element = elementRegistry.get(id);

    if (!isAny(element, ['dmn:UnaryTests', 'dmn:LiteralExpression'])) {
      return;
    }

    var description = getDescription(element);

    if (!description) {
      // prevent focus
      event.preventDefault();
    }

    var container = renderer.getContainer(),
        bounds = target.getBoundingClientRect();
    var position = getPosition(container, bounds);
    contextMenu.open(position, {
      contextMenuType: 'cell-description',
      autoFocus: false,
      id: id,
      offset: {
        x: 4,
        y: 4
      }
    });
  });
  components.onGetComponent('context-menu', function () {
    var context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    if (context.contextMenuType && context.contextMenuType === 'cell-description') {
      var element = elementRegistry.get(context.id);
      var description = getDescription(element);

      if (isString(description)) {
        return DescriptionEditor;
      }
    }
  });
  components.onGetComponent('context-menu-cell-additional', LOW_PRIORITY, function () {
    var context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    if (context.contextMenuType && context.contextMenuType === 'context-menu') {
      var id = context.id;

      if (!id) {
        return;
      }

      var element = elementRegistry.get(id); // element might not be in element registry (e.g. cut)

      if (!element) {
        return;
      }

      var businessObject = element.businessObject;
      var description = businessObject.description;
      var existingDescription = isString(description);
      var className = existingDescription ? 'remove-description' : 'add-description';
      var onClick = existingDescription ? function () {
        return _this.removeDescription(element);
      } : function () {
        return _this.addDescription(element);
      };
      return createVNode(1, "div", "context-menu-group-entry ".concat(className), isString(description) ? _this._translate('Remove Cell Description') : _this._translate('Add Cell Description'), 0, {
        "onClick": onClick
      });
    }
  });
};

export { Description as default };
Description.$inject = ['components', 'contextMenu', 'elementRegistry', 'eventBus', 'modeling', 'renderer', 'translate']; // helpers //////////

function getPosition(container, bounds) {
  var top = bounds.top,
      left = bounds.left,
      width = bounds.width,
      height = bounds.height;
  return {
    x: left + container.parentNode.scrollLeft - OFFSET_X,
    y: top + container.parentNode.scrollTop,
    width: width + 2 * OFFSET_X,
    height: height
  };
}

function getDescription(element) {
  return element && element.businessObject && element.businessObject.description;
}
//# sourceMappingURL=Description.js.map