import { createVNode, createComponentVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { Component } from 'inferno';
import { isString } from 'min-dash';
import { query as domQuery } from 'min-dom';
import EditableComponent from 'dmn-js-shared/lib/components/EditableComponent';

var DescriptionEditor =
/*#__PURE__*/
function (_Component) {
  _inherits(DescriptionEditor, _Component);

  function DescriptionEditor(props, context) {
    var _this;

    _classCallCheck(this, DescriptionEditor);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DescriptionEditor).call(this, props, context));

    _defineProperty(_assertThisInitialized(_this), "onElementsChanged", function () {
      _this.forceUpdate();
    });

    _defineProperty(_assertThisInitialized(_this), "changeDescription", function (value) {
      _this._modeling.updateProperties(_this._element, {
        description: value
      });
    });

    _this._elementRegistry = context.injector.get('elementRegistry');
    _this._modeling = context.injector.get('modeling');
    _this._changeSupport = _this.context.changeSupport;
    var id = _this.props.context.id;
    _this._element = _this._elementRegistry.get(id);
    return _this;
  }

  _createClass(DescriptionEditor, [{
    key: "componentWillMount",
    value: function componentWillMount() {
      if (this._element) {
        this._changeSupport.onElementsChanged(this._element.id, this.onElementsChanged);
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var autoFocus = this.props.context.autoFocus;

      if (autoFocus && this.node) {
        var editor = getEditor(this.node);
        editor.focus();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this._element) {
        this._changeSupport.offElementsChanged(this._element.id, this.onElementsChanged);

        var businessObject = this._element.businessObject;
        var description = businessObject.description; // if empty description remove description

        if (isString(description) && !description.length) {
          this.changeDescription(null);
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      if (!this._element) {
        return;
      }

      var businessObject = this._element.businessObject;
      var description = businessObject.description;

      if (!isString(description)) {
        return;
      }

      return createVNode(1, "div", "context-menu-container description-editor", createComponentVNode(2, Editor, {
        "className": "dms-input",
        "onChange": this.changeDescription,
        "value": description
      }), 2, null, null, function (node) {
        return _this2.node = node;
      });
    }
  }]);

  return DescriptionEditor;
}(Component);

export { DescriptionEditor as default };

var Editor =
/*#__PURE__*/
function (_EditableComponent) {
  _inherits(Editor, _EditableComponent);

  function Editor() {
    _classCallCheck(this, Editor);

    return _possibleConstructorReturn(this, _getPrototypeOf(Editor).apply(this, arguments));
  }

  _createClass(Editor, [{
    key: "render",
    value: function render() {
      return createVNode(1, "div", this.getClassName(), this.getEditor(), 0);
    }
  }]);

  return Editor;
}(EditableComponent); // helpers //////////


function getEditor(container) {
  return domQuery('.content-editable', container);
}
//# sourceMappingURL=DescriptionEditor.js.map