function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import { is } from 'dmn-js-shared/lib/util/ModelUtil';

var DecisionTableEditorActions = function DecisionTableEditorActions(copyCutPaste, editorActions, modeling, selection, cellSelection, sheet) {
  _classCallCheck(this, DecisionTableEditorActions);

  var actions = {
    addRule: function addRule() {
      return modeling.addRow({
        type: 'dmn:DecisionRule'
      });
    },
    addRuleAbove: function addRuleAbove(context) {
      var rule = context && context.rule;

      if (!rule && !selection.hasSelection()) {
        return;
      }

      rule = rule || selection.get().row;
      var root = sheet.getRoot(),
          index = root.rows.indexOf(rule);

      if (index === -1) {
        return;
      }

      return modeling.addRow({
        type: 'dmn:DecisionRule'
      }, index);
    },
    addRuleBelow: function addRuleBelow(context) {
      var rule = context && context.rule;

      if (!rule && !selection.hasSelection()) {
        return;
      }

      rule = rule || selection.get().row;
      var root = sheet.getRoot(),
          index = root.rows.indexOf(rule);

      if (index === -1) {
        return;
      }

      return modeling.addRow({
        type: 'dmn:DecisionRule'
      }, index + 1);
    },
    removeRule: function removeRule(context) {
      var rule = context && context.rule;

      if (!rule && !selection.hasSelection()) {
        return;
      }

      rule = rule || selection.get().row;
      modeling.removeRow(rule);
    },
    addInput: function addInput() {
      var root = sheet.getRoot(),
          businessObject = root.businessObject;
      var input = businessObject.input;
      return modeling.addCol({
        type: 'dmn:InputClause'
      }, input ? input.length : 0);
    },
    addInputLeft: function addInputLeft(context) {
      var input = context && context.input;

      if (!input && !selection.hasSelection()) {
        return;
      }

      input = input || selection.get().col;
      var root = sheet.getRoot(),
          index = root.cols.indexOf(input);

      if (index === -1) {
        return;
      }

      return modeling.addCol({
        type: 'dmn:InputClause'
      }, index);
    },
    addInputRight: function addInputRight(context) {
      var input = context && context.input;

      if (!input && !selection.hasSelection()) {
        return;
      }

      input = input || selection.get().col;
      var root = sheet.getRoot(),
          index = root.cols.indexOf(input);

      if (index === -1) {
        return;
      }

      return modeling.addCol({
        type: 'dmn:InputClause'
      }, index + 1);
    },
    removeInput: function removeInput(context) {
      var input = context && context.input;

      if (!input && !selection.hasSelection()) {
        return;
      }

      input = input || selection.get().col;
      modeling.removeCol(input);
    },
    addOutput: function addOutput() {
      var root = sheet.getRoot(),
          businessObject = root.businessObject;
      var input = businessObject.input,
          output = businessObject.output;
      return modeling.addCol({
        type: 'dmn:OutputClause'
      }, input.length + output.length);
    },
    addOutputLeft: function addOutputLeft(context) {
      var output = context && context.output;

      if (!output && !selection.hasSelection()) {
        return;
      }

      output = output || selection.get().col;
      var root = sheet.getRoot(),
          index = root.cols.indexOf(output);

      if (index === -1) {
        return;
      }

      return modeling.addCol({
        type: 'dmn:OutputClause'
      }, index);
    },
    addOutputRight: function addOutputRight(context) {
      var output = context && context.output;

      if (!output && !selection.hasSelection()) {
        return;
      }

      output = output || selection.get().col;
      var root = sheet.getRoot(),
          index = root.cols.indexOf(output);

      if (index === -1) {
        return;
      }

      return modeling.addCol({
        type: 'dmn:OutputClause'
      }, index + 1);
    },
    removeOutput: function removeOutput(context) {
      var output = context && context.output;

      if (!output && !selection.hasSelection()) {
        return;
      }

      output = output || selection.get().col;
      modeling.removeCol(output);
    },
    addClause: function addClause() {
      if (!selection.hasSelection()) {
        return;
      }

      var clause = selection.get().col;

      if (is(clause, 'dmn:InputClause')) {
        return actions.addInput({
          input: clause
        });
      } else if (is(clause, 'dmn:OutputClause')) {
        return actions.addOutput({
          output: clause
        });
      }
    },
    addClauseLeft: function addClauseLeft() {
      if (!selection.hasSelection()) {
        return;
      }

      var clause = selection.get().col;

      if (is(clause, 'dmn:InputClause')) {
        return actions.addInputLeft({
          input: clause
        });
      } else if (is(clause, 'dmn:OutputClause')) {
        return actions.addOutputLeft({
          output: clause
        });
      }
    },
    addClauseRight: function addClauseRight() {
      if (!selection.hasSelection()) {
        return;
      }

      var clause = selection.get().col;

      if (is(clause, 'dmn:InputClause')) {
        return actions.addInputRight({
          input: clause
        });
      } else if (is(clause, 'dmn:OutputClause')) {
        return actions.addOutputRight({
          output: clause
        });
      }
    },
    removeClause: function removeClause() {
      if (!selection.hasSelection()) {
        return;
      }

      var clause = selection.get().col;

      if (is(clause, 'dmn:InputClause')) {
        return actions.removeInput({
          input: clause
        });
      } else if (is(clause, 'dmn:OutputClause')) {
        return actions.removeOutput({
          output: clause
        });
      }
    },
    selectCellAbove: function selectCellAbove() {
      return cellSelection.selectCell('above');
    },
    selectCellBelow: function selectCellBelow() {
      return cellSelection.selectCell('below');
    },
    copy: function copy(_ref) {
      var element = _ref.element;
      copyCutPaste.copy(element);
    },
    cut: function cut(_ref2) {
      var element = _ref2.element;
      copyCutPaste.cut(element);
    },
    pasteBefore: function pasteBefore(_ref3) {
      var element = _ref3.element;
      return copyCutPaste.pasteBefore(element);
    },
    pasteAfter: function pasteAfter(_ref4) {
      var element = _ref4.element;
      return copyCutPaste.pasteAfter(element);
    }
  };
  editorActions.register(actions);
};

export { DecisionTableEditorActions as default };
DecisionTableEditorActions.$inject = ['copyCutPaste', 'editorActions', 'modeling', 'selection', 'cellSelection', 'sheet'];
//# sourceMappingURL=DecisionTableEditorActions.js.map