import { createVNode, createComponentVNode } from "inferno";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/* eslint-disable max-len */
import InputSelect from 'dmn-js-shared/lib/components/InputSelect';
import { isInput } from 'dmn-js-shared/lib/util/ModelUtil';

var ExpressionLanguage =
/*#__PURE__*/
function () {
  function ExpressionLanguage(components, elementRegistry, modeling, expressionLanguages, translate, contextMenu) {
    var _this = this;

    _classCallCheck(this, ExpressionLanguage);

    this._modeling = modeling;
    this._translate = translate;
    components.onGetComponent('context-menu-cell-additional', function () {
      var context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      if (context.contextMenuType && context.contextMenuType === 'context-menu') {
        var event = context.event,
            id = context.id;

        if (!id) {
          return;
        }

        var element = elementRegistry.get(id); // element might not be in element registry (e.g. cut)

        if (!element) {
          return;
        }

        var openMenu = function openMenu(clickEvent) {
          contextMenu.open({
            x: (event || clickEvent).pageX,
            y: (event || clickEvent).pageY
          }, {
            contextMenuType: 'expression-language',
            id: id
          });
        };

        return createVNode(1, "div", "context-menu-group-entry", _this._translate('Change Cell Expression Language'), 0, {
          "onClick": openMenu
        });
      }
    });
    components.onGetComponent('context-menu', function () {
      var context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      if (context.contextMenuType && context.contextMenuType === 'expression-language') {
        var id = context.id;

        if (!id) {
          return;
        }

        var element = elementRegistry.get(id); // element might not be in element registry (e.g. cut)

        if (!element) {
          return;
        }

        var expressionLanguage = element.businessObject.expressionLanguage || expressionLanguages.getDefault(isInput(element.col) ? 'inputCell' : 'outputCell').value;
        var options = expressionLanguages.getAll();
        return function () {
          return createVNode(1, "div", "context-menu-flex", createVNode(1, "div", "context-menu-group", createVNode(1, "div", "context-menu-group-entry context-menu-entry-set-expression-language", [createVNode(1, "div", null, _this._translate('Expression Language'), 0), createComponentVNode(2, InputSelect, {
            "className": "expression-language",
            "onChange": function onChange(value) {
              return _this.onChange(element, value);
            },
            "options": options,
            "value": expressionLanguage
          })], 4), 2), 2);
        };
      }
    });
  }

  _createClass(ExpressionLanguage, [{
    key: "onChange",
    value: function onChange(cell, expressionLanguage) {
      this._modeling.editExpressionLanguage(cell.businessObject, expressionLanguage);
    }
  }]);

  return ExpressionLanguage;
}();

export { ExpressionLanguage as default };
ExpressionLanguage.$inject = ['components', 'elementRegistry', 'modeling', 'expressionLanguages', 'translate', 'contextMenu'];
//# sourceMappingURL=ExpressionLanguage.js.map