function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import { is } from 'dmn-js-shared/lib/util/ModelUtil';

var DmnFactory =
/*#__PURE__*/
function () {
  function DmnFactory(moddle) {
    _classCallCheck(this, DmnFactory);

    this._model = moddle;
  }

  _createClass(DmnFactory, [{
    key: "create",
    value: function create(type) {
      var attrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var element = this._model.create(type, attrs || {});

      if (is(element, 'dmn:InputClause')) {
        if (attrs.inputExpression) {
          element.inputExpression = attrs.inputExpression;
        } else {
          element.inputExpression = this.create('dmn:LiteralExpression', {
            typeRef: 'string'
          });
          element.inputExpression.$parent = element;
        }
      }

      if (is(element, 'dmn:OutputClause')) {
        element.typeRef = attrs.typeRef || 'string';
      }

      if (is(element, 'dmn:UnaryTests') || is(element, 'dmn:LiteralExpression')) {
        element.text = attrs.text || '';
      }

      this._ensureId(element);

      return element;
    }
  }, {
    key: "_needsId",
    value: function _needsId(element) {
      return is(element, 'dmn:DMNElement');
    }
  }, {
    key: "_ensureId",
    value: function _ensureId(element) {
      // generate semantic ids for elements
      // dmn:UnaryTests -> UnaryTests_ID
      var prefix = (element.$type || '').replace(/^[^:]*:/g, '') + '_';

      if (!element.id && this._needsId(element)) {
        element.id = this._model.ids.nextPrefixed(prefix, element);
      }
    }
  }]);

  return DmnFactory;
}();

export { DmnFactory as default };
DmnFactory.$inject = ['moddle'];
//# sourceMappingURL=DmnFactory.js.map