function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

import { is } from 'dmn-js-shared/lib/util/ModelUtil';
import CommandInterceptor from 'diagram-js/lib/command/CommandInterceptor';
/**
 * A handler responsible for updating the underlying DMN
 * once changes on the table happen.
 */

var DmnUpdater =
/*#__PURE__*/
function (_CommandInterceptor) {
  _inherits(DmnUpdater, _CommandInterceptor);

  function DmnUpdater(eventBus, sheet) {
    var _this;

    _classCallCheck(this, DmnUpdater);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DmnUpdater).call(this, eventBus));

    _this.executed(['row.add', 'row.remove', 'col.add', 'col.remove'], ifDmn(function (e) {
      var context = e.context;
      var element = context.row || context.col;

      _this.updateRoot(element, context.oldRoot);
    }));

    _this.reverted(['row.add', 'row.remove', 'col.add', 'col.remove'], ifDmn(function (e) {
      var context = e.context;
      var element = context.row || context.col;

      _this.updateRoot(element, context.newRoot);
    }));

    return _this;
  }

  _createClass(DmnUpdater, [{
    key: "updateRoot",
    value: function updateRoot(element, oldRoot) {
      var _this2 = this;

      var newRoot = element.root;
      var businessObject = element.businessObject;

      if (is(element, 'dmn:DecisionRule')) {
        // we're removing
        if (oldRoot) {
          var oldTable = oldRoot.businessObject;
          var oldRules = oldTable.get('rule');
          var oldIdx = oldRules.indexOf(businessObject); // unwire Row <-> Table

          oldRules.splice(oldIdx, 1);
          businessObject.$parent = null;
        } // we're adding


        if (newRoot) {
          var newTable = newRoot.businessObject;
          var newIdx = newRoot.rows.indexOf(element); // wire Row <-> Table

          newTable.get('rule').splice(newIdx, 0, businessObject);
          businessObject.$parent = newTable;
          element.cells.forEach(function (cell, idx) {
            // wire Cell <-> Row
            _this2.wireCell(cell, element, idx);
          });
        }
      }

      if (is(element, 'dmn:InputClause') || is(element, 'dmn:OutputClause')) {
        var collection, collectionIdx; // we're removing

        if (oldRoot) {
          var _oldTable = oldRoot.businessObject;

          var inputs = _oldTable.get('input');

          var outputs = _oldTable.get('output');

          if (is(element, 'dmn:InputClause')) {
            collection = inputs;
            collectionIdx = inputs.indexOf(businessObject);
          }

          if (is(element, 'dmn:OutputClause')) {
            collection = outputs;
            collectionIdx = outputs.indexOf(businessObject);
          }

          if (collectionIdx === -1) {
            throw new Error('inconsistent model: clause not in table');
          } // unwire Col <-> Table


          collection.splice(collectionIdx, 1);
          businessObject.$parent = null;
          element.cells.forEach(function (cel, rowIdx) {
            // unwire Cell <-> Row
            _this2.unwireCell(cel, oldRoot.rows[rowIdx]);
          });
        }

        if (newRoot) {
          var _newTable = newRoot.businessObject;

          var _inputs = _newTable.get('input');

          var _outputs = _newTable.get('output');

          var colIdx = newRoot.cols.indexOf(element);

          var _collectionIdx, _collection;

          if (is(element, 'dmn:InputClause')) {
            _collection = _inputs;
            _collectionIdx = colIdx;
          }

          if (is(element, 'dmn:OutputClause')) {
            _collection = _outputs;
            _collectionIdx = colIdx - _inputs.length;
          } // wire Col <-> Table


          _collection.splice(_collectionIdx, 0, businessObject);

          businessObject.$parent = _newTable;
          element.cells.forEach(function (cell, rowIdx) {
            // wire Cell <-> Row
            _this2.wireCell(cell, newRoot.rows[rowIdx], colIdx);
          });
        }
      }
    }
  }, {
    key: "unwireCell",
    value: function unwireCell(cell, oldRow) {
      var cellBo = cell.businessObject;
      var oldRowBo = oldRow.businessObject;
      var inputEntries = oldRowBo.get('inputEntry');
      var outputEntries = oldRowBo.get('outputEntry');
      var collection, collectionIdx; // remove from inputEntries

      if (is(cell, 'dmn:UnaryTests')) {
        collection = inputEntries;
      } // remove from outputEntries


      if (is(cell, 'dmn:LiteralExpression')) {
        collection = outputEntries;
      }

      collectionIdx = collection.indexOf(cellBo);

      if (collectionIdx === -1) {
        throw new Error('cell not in row');
      } // unwire Cell <-> Row relationship


      collection.splice(collectionIdx, 1);
      cellBo.$parent = null;
    }
  }, {
    key: "wireCell",
    value: function wireCell(cell, row, colIdx) {
      var cellBo = cell.businessObject;
      var rowBo = row.businessObject;
      var inputEntries = rowBo.get('inputEntry');
      var outputEntries = rowBo.get('outputEntry');
      var collection, collectionIdx; // ensure we handle already wired cells

      if (cellBo.$parent === rowBo) {
        return;
      } // add to inputEntries


      if (is(cell, 'dmn:UnaryTests')) {
        collection = inputEntries;
        collectionIdx = colIdx;
      } // add to outputEntries


      if (is(cell, 'dmn:LiteralExpression')) {
        collection = outputEntries;
        collectionIdx = colIdx - inputEntries.length;
      } // wire Cell <-> Row relationship


      collection.splice(collectionIdx, 0, cellBo);
      cellBo.$parent = rowBo;
    }
  }]);

  return DmnUpdater;
}(CommandInterceptor);

export { DmnUpdater as default };
DmnUpdater.$inject = ['eventBus', 'sheet']; // helpers //////////////////////

/**
 * Make sure the event listener is only called
 * if the touched element is a DMN element.
 *
 * @param  {Function} fn
 * @return {Function} guarded function
 */

function ifDmn(fn) {
  return function (event) {
    var context = event.context,
        element = context.row || context.col;

    if (is(element, 'dmn:DMNElement')) {
      fn(event);
    }
  };
}
//# sourceMappingURL=DmnUpdater.js.map