function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import { is } from 'dmn-js-shared/lib/util/ModelUtil';
/**
 * A handler that implements adding/removing allowed values.
 */

var UpdateAllowedValuesHandler =
/*#__PURE__*/
function () {
  function UpdateAllowedValuesHandler(dmnFactory, moddle, modeling) {
    _classCallCheck(this, UpdateAllowedValuesHandler);

    this._dmnFactory = dmnFactory;
    this._moddle = moddle;
    this._modeling = modeling;
  }
  /**
   * <do>
   */


  _createClass(UpdateAllowedValuesHandler, [{
    key: "execute",
    value: function execute(context) {
      var element = context.element,
          allowedValues = context.allowedValues;
      var isInput = is(element, 'dmn:InputClause');

      if (isInput) {
        if (element.inputValues) {
          context.oldAllowedValues = element.inputValues.text;
        } else {
          if (!isNull(allowedValues)) {
            element.inputValues = this._dmnFactory.create('dmn:UnaryTests', {
              text: ''
            });
          }
        }

        if (isNull(allowedValues)) {
          if (element.inputValues) {
            delete element.inputValues;
          }
        } else {
          element.inputValues.text = allowedValues.join(',');
        }
      } else {
        if (element.outputValues && element) {
          context.oldAllowedValues = element.outputValues.text;
        } else {
          if (!isNull(allowedValues)) {
            element.outputValues = this._dmnFactory.create('dmn:UnaryTests', {
              text: ''
            });
          }
        }

        if (isNull(allowedValues)) {
          if (element.outputValues) {
            delete element.outputValues;
          }
        } else {
          element.outputValues.text = allowedValues.join(',');
        }
      }

      return element;
    }
    /**
     * <undo>
     */

  }, {
    key: "revert",
    value: function revert(context) {
      var element = context.element,
          oldAllowedValues = context.oldAllowedValues;
      var isInput = is(element, 'dmn:InputClause');

      if (isInput) {
        if (oldAllowedValues) {
          if (!element.inputValues) {
            element.inputValues = this._dmnFactory.create('dmn:UnaryTests', {
              text: ''
            });
          }

          element.inputValues.text = oldAllowedValues;
        } else {
          delete element.inputValues;
        }
      } else {
        if (oldAllowedValues) {
          if (!element.outputValues) {
            element.outputValues = this._dmnFactory.create('dmn:UnaryTests', {
              text: ''
            });
          }

          element.outputValues.text = oldAllowedValues;
        } else {
          delete element.outputValues;
        }
      }

      return element;
    }
  }]);

  return UpdateAllowedValuesHandler;
}();

export { UpdateAllowedValuesHandler as default };
UpdateAllowedValuesHandler.$inject = ['dmnFactory', 'moddle', 'modeling']; // helpers //////////////////////

function isNull(value) {
  return value === null;
}
//# sourceMappingURL=UpdateAllowedValuesHandler.js.map