function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

import { every } from 'min-dash';
import { Row, Col } from 'table-js/lib/model';
import { isInput, isOutput } from 'dmn-js-shared/lib/util/ModelUtil';
import RuleProvider from 'diagram-js/lib/features/rules/RuleProvider';
var HIGH_PRIORITY = 2000;

var DecisionTableModelingRules =
/*#__PURE__*/
function (_RuleProvider) {
  _inherits(DecisionTableModelingRules, _RuleProvider);

  function DecisionTableModelingRules(eventBus, sheet) {
    var _this;

    _classCallCheck(this, DecisionTableModelingRules);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DecisionTableModelingRules).call(this, eventBus));
    _this._sheet = sheet;
    return _this;
  }

  _createClass(DecisionTableModelingRules, [{
    key: "init",
    value: function init() {
      var _this2 = this;

      this.addRule('col.move', HIGH_PRIORITY, function (_ref) {
        var col = _ref.col,
            index = _ref.index;

        var _this2$_sheet$getRoot = _this2._sheet.getRoot(),
            businessObject = _this2$_sheet$getRoot.businessObject,
            input = businessObject.input;

        if (isInput(col)) {
          return index < input.length;
        } else {
          return index >= input.length;
        }
      });
      this.addRule('col.remove', HIGH_PRIORITY, function (_ref2) {
        var col = _ref2.col;

        var _this2$_sheet$getRoot2 = _this2._sheet.getRoot(),
            cols = _this2$_sheet$getRoot2.cols;

        if (isOutput(col)) {
          return cols.filter(function (c) {
            return isOutput(c);
          }).length > 1;
        }

        return true;
      }); // a rule that is aware of the data structure coming from copy and paste

      this.addRule('paste', HIGH_PRIORITY, function (_ref3) {
        var data = _ref3.data,
            target = _ref3.target;

        if (!data || !target) {
          return false;
        }

        var root = data.root;

        if (target instanceof Row) {
          return _this2.canPasteRows(root);
        }

        if (target instanceof Col) {
          return _this2.canPasteCols(root, target);
        }

        return false;
      });
    }
  }, {
    key: "canPasteRows",
    value: function canPasteRows(root) {
      var _this$_sheet$getRoot = this._sheet.getRoot(),
          cols = _this$_sheet$getRoot.cols;

      return every(root, function (descriptor) {
        if (descriptor.type !== 'row') {
          return false;
        }

        if (descriptor.cells.length !== cols.length) {
          return false;
        }

        return every(descriptor.cells, function (cellDescriptor, index) {
          if (isInput(cols[index])) {
            return cellDescriptor.businessObject.$type === 'dmn:UnaryTests';
          } else {
            return cellDescriptor.businessObject.$type === 'dmn:LiteralExpression';
          }
        });
      });
    }
  }, {
    key: "canPasteCols",
    value: function canPasteCols(root, targetCol) {
      var _this$_sheet$getRoot2 = this._sheet.getRoot(),
          rows = _this$_sheet$getRoot2.rows;

      return every(root, function (descriptor) {
        if (descriptor.type !== 'col') {
          return false;
        }

        if (descriptor.cells.length !== rows.length) {
          return false;
        }

        if (isInput(targetCol)) {
          return descriptor.businessObject.$type === 'dmn:InputClause';
        } else {
          return descriptor.businessObject.$type === 'dmn:OutputClause';
        }
      });
    }
  }]);

  return DecisionTableModelingRules;
}(RuleProvider);

export { DecisionTableModelingRules as default };
DecisionTableModelingRules.$inject = ['eventBus', 'sheet'];
//# sourceMappingURL=DecisionTableModelingRules.js.map