function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import BooleanEdit from './components/BooleanEdit';
import { isInput, isOutput } from 'dmn-js-shared/lib/util/ModelUtil';

var SimpleBooleanEdit = function SimpleBooleanEdit(components, simpleMode) {
  _classCallCheck(this, SimpleBooleanEdit);

  simpleMode.registerProvider(function (element) {
    return (isInput(element.col) || isOutput(element.col)) && getTypeRef(element) === 'boolean';
  });
  components.onGetComponent('context-menu', function () {
    var context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    if (context.contextMenuType && context.contextMenuType === 'simple-mode-edit') {
      if (!context.element) {
        return;
      }

      var typeRef = getTypeRef(context.element);

      if (typeRef === 'boolean') {
        return BooleanEdit;
      }
    }
  });
};

export { SimpleBooleanEdit as default };
SimpleBooleanEdit.$inject = ['components', 'simpleMode']; // helpers //////////////////////

function getTypeRef(element) {
  if (isInput(element.col)) {
    return element.col && element.col.businessObject.inputExpression.typeRef;
  } else {
    return element.col && element.col.businessObject.typeRef;
  }
}
//# sourceMappingURL=SimpleBooleanEdit.js.map