function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import InputDateEdit from './components/InputDateEdit';
import OutputDateEdit from './components/OutputDateEdit';
import { isInput, isOutput } from 'dmn-js-shared/lib/util/ModelUtil';

var SimpleDateEdit = function SimpleDateEdit(components, simpleMode) {
  _classCallCheck(this, SimpleDateEdit);

  simpleMode.registerProvider(function (element) {
    var typeRef = getTypeRef(element);
    return (isInput(element.col) || isOutput(element.col)) && isDate(typeRef);
  });
  components.onGetComponent('context-menu', function () {
    var context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    if (context.contextMenuType && context.contextMenuType === 'simple-mode-edit') {
      if (!context.element) {
        return;
      }

      var typeRef = getTypeRef(context.element);

      if (isDate(typeRef)) {
        if (isInput(context.element.col)) {
          return InputDateEdit;
        } else if (isOutput(context.element.col)) {
          return OutputDateEdit;
        }
      }
    }
  });
};

export { SimpleDateEdit as default };
SimpleDateEdit.$inject = ['components', 'simpleMode']; // helpers //////////////////////

function getTypeRef(element) {
  if (isInput(element.col)) {
    return element.col && element.col.businessObject.inputExpression.typeRef;
  } else {
    return element.col && element.col.businessObject.typeRef;
  }
}

function isDate(typeRef) {
  return typeRef === 'date';
}
//# sourceMappingURL=SimpleDateEdit.js.map