import { createVNode, createComponentVNode, createTextVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

import { Component } from 'inferno';
import ValidatedInput from 'dmn-js-shared/lib/components/ValidatedInput';
import InputSelect from 'dmn-js-shared/lib/components/InputSelect';
import { getDateString, getSampleDate, validateISOString, parseString } from '../Utils';
var EXACT = 'exact',
    BEFORE = 'before',
    AFTER = 'after',
    BETWEEN = 'between';

var InputDateEdit =
/*#__PURE__*/
function (_Component) {
  _inherits(InputDateEdit, _Component);

  function InputDateEdit(props, context) {
    var _this;

    _classCallCheck(this, InputDateEdit);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(InputDateEdit).call(this, props, context));
    _this._modeling = context.injector.get('modeling');
    var element = _this.props.context.element;
    var parsedString = parseString(element.businessObject.text);

    if (parsedString) {
      var dates;

      if (parsedString.date) {
        dates = [parsedString.date, ''];
      } else if (parsedString.dates) {
        dates = parsedString.dates;
      } else {
        dates = ['', ''];
      }

      _this.state = {
        type: parsedString.type,
        dates: dates
      };
    } else {
      _this.state = {
        type: EXACT,
        dates: ['', '']
      };
    }

    var debounceInput = context.injector.get('debounceInput');
    _this.debouncedEditCell = debounceInput(_this.editCell.bind(_assertThisInitialized(_this)));
    _this.editCell = _this.editCell.bind(_assertThisInitialized(_this));
    _this.onTypeChange = _this.onTypeChange.bind(_assertThisInitialized(_this));
    _this.onSetStartDateTodayClick = _this.onSetStartDateTodayClick.bind(_assertThisInitialized(_this));
    _this.onSetEndDateTodayClick = _this.onSetEndDateTodayClick.bind(_assertThisInitialized(_this));
    _this.onStartDateInput = _this.onStartDateInput.bind(_assertThisInitialized(_this));
    _this.onEndDateInput = _this.onEndDateInput.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(InputDateEdit, [{
    key: "editCell",
    value: function editCell(cell, text) {
      this._modeling.editCell(cell, text);
    }
  }, {
    key: "onTypeChange",
    value: function onTypeChange(value) {
      var element = this.props.context.element;
      var dates = this.state.dates;
      this.setState({
        type: value
      });

      if (parseString(getDateString(value, dates))) {
        this.editCell(element.businessObject, getDateString(value, dates));
      }
    }
  }, {
    key: "onSetStartDateTodayClick",
    value: function onSetStartDateTodayClick() {
      var element = this.props.context.element;
      var _this$state = this.state,
          dates = _this$state.dates,
          type = _this$state.type;
      var date = getSampleDate();
      this.setState({
        dates: [date, dates[1]]
      });

      if (parseString(getDateString(type, [date, dates[1]]))) {
        this.editCell(element.businessObject, getDateString(type, [date, dates[1]]));
      }
    }
  }, {
    key: "onSetEndDateTodayClick",
    value: function onSetEndDateTodayClick() {
      var element = this.props.context.element;
      var _this$state2 = this.state,
          dates = _this$state2.dates,
          type = _this$state2.type;
      var date = getSampleDate();
      this.setState({
        dates: [dates[0], date]
      });

      if (parseString(getDateString(type, [dates[0], date]))) {
        this.editCell(element.businessObject, getDateString(type, [dates[0], date]));
      }
    }
  }, {
    key: "onStartDateInput",
    value: function onStartDateInput(_ref) {
      var isValid = _ref.isValid,
          value = _ref.value;

      if (isValid) {
        var element = this.props.context.element;
        var _this$state3 = this.state,
            dates = _this$state3.dates,
            type = _this$state3.type;
        this.setState({
          dates: [value, dates[1]]
        });
        this.debouncedEditCell(element.businessObject, getDateString(type, [value, dates[1]]));
      }
    }
  }, {
    key: "onEndDateInput",
    value: function onEndDateInput(_ref2) {
      var isValid = _ref2.isValid,
          value = _ref2.value;

      if (isValid) {
        var element = this.props.context.element;
        var _this$state4 = this.state,
            dates = _this$state4.dates,
            type = _this$state4.type;
        this.setState({
          dates: [dates[0], value]
        });
        this.debouncedEditCell(element.businessObject, getDateString(type, [dates[0], value]));
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state5 = this.state,
          dates = _this$state5.dates,
          type = _this$state5.type;
      var options = [{
        label: 'Exactly',
        value: EXACT
      }, {
        label: 'Before',
        value: BEFORE
      }, {
        label: 'After',
        value: AFTER
      }, {
        label: 'Between',
        value: BETWEEN
      }];
      return createVNode(1, "div", "context-menu-container simple-date-edit", [createVNode(1, "h3", "dms-heading", createTextVNode("Edit Date"), 2), createVNode(1, "div", "dms-fill-row", createComponentVNode(2, InputSelect, {
        "noInput": true,
        "onChange": this.onTypeChange,
        "options": options,
        "value": type
      }), 2), createVNode(1, "h4", "dms-heading", type === BETWEEN ? 'Edit Start Date' : 'Set Date', 0), createVNode(1, "div", null, [createComponentVNode(2, ValidatedInput, {
        "className": "start-date-input dms-block",
        "onInput": this.onStartDateInput,
        "placeholder": "e.g. ".concat(getSampleDate()),
        "validate": validateISOString,
        "value": dates[0]
      }), createVNode(1, "p", "dms-hint", [createVNode(1, "button", "use-today", createTextVNode("Use today"), 2, {
        "type": "button",
        "onClick": this.onSetStartDateTodayClick
      }), createTextVNode(".")], 4)], 4), type === BETWEEN && createVNode(1, "h4", "dms-heading", createTextVNode("Edit End Date"), 2), type === BETWEEN && createVNode(1, "div", null, [createComponentVNode(2, ValidatedInput, {
        "className": "end-date-input dms-block",
        "onInput": this.onEndDateInput,
        "placeholder": "e.g. ".concat(getSampleDate()),
        "validate": validateISOString,
        "value": dates[1]
      }), createVNode(1, "p", "dms-hint", [createVNode(1, "button", "use-today", createTextVNode("Use today"), 2, {
        "type": "button",
        "onClick": this.onSetEndDateTodayClick
      }), createTextVNode(".")], 4)], 4)], 0);
    }
  }]);

  return InputDateEdit;
}(Component);

export { InputDateEdit as default };
//# sourceMappingURL=InputDateEdit.js.map