function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import InputNumberEdit from './components/InputNumberEdit';
import OutputNumberEdit from './components/OutputNumberEdit';
import { isInput, isOutput } from 'dmn-js-shared/lib/util/ModelUtil';

var SimpleNumberEdit = function SimpleNumberEdit(components, simpleMode) {
  _classCallCheck(this, SimpleNumberEdit);

  simpleMode.registerProvider(function (element) {
    var typeRef = getTypeRef(element);
    return (isInput(element.col) || isOutput(element.col)) && (typeRef === 'integer' || typeRef === 'long' || typeRef === 'double');
  });
  components.onGetComponent('context-menu', function () {
    var context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    if (context.contextMenuType && context.contextMenuType === 'simple-mode-edit') {
      if (!context.element) {
        return;
      }

      var typeRef = getTypeRef(context.element);

      if (isNumber(typeRef)) {
        if (isInput(context.element.col)) {
          return InputNumberEdit;
        } else if (isOutput(context.element.col)) {
          return OutputNumberEdit;
        }
      }
    }
  });
};

export { SimpleNumberEdit as default };
SimpleNumberEdit.$inject = ['components', 'simpleMode']; // helpers //////////////////////

function getTypeRef(element) {
  if (isInput(element.col)) {
    return element.col && element.col.businessObject.inputExpression.typeRef;
  } else {
    return element.col && element.col.businessObject.typeRef;
  }
}

function isNumber(typeRef) {
  return typeRef === 'integer' || typeRef === 'long' || typeRef === 'double';
}
//# sourceMappingURL=SimpleNumberEdit.js.map