import { createVNode, createComponentVNode, createTextVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

import { Component } from 'inferno';
import Input from 'dmn-js-shared/lib/components/Input';
import InputSelect from 'dmn-js-shared/lib/components/InputSelect';
import { getComparisonString, getRangeString, parseString } from '../Utils';
var COMPARISON = 'comparison',
    RANGE = 'range';

var InputNumberEdit =
/*#__PURE__*/
function (_Component) {
  _inherits(InputNumberEdit, _Component);

  function InputNumberEdit(props, context) {
    var _this;

    _classCallCheck(this, InputNumberEdit);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(InputNumberEdit).call(this, props, context));
    _this._modeling = context.injector.get('modeling');
    var element = _this.props.context.element;
    var parsedString = parseString(element.businessObject.text);

    if (parsedString) {
      _this.state = {
        type: parsedString.type,
        comparisonOperator: parsedString.operator || 'equals',
        comparisonValue: parsedString.value || 0,
        rangeStartValue: parsedString.values ? parsedString.values[0] : 0,
        rangeEndValue: parsedString.values ? parsedString.values[1] : 0,
        rangeStartType: parsedString.start || 'include',
        rangeEndType: parsedString.end || 'include'
      };
    } else {
      _this.state = {
        type: COMPARISON,
        comparisonOperator: 'equals',
        comparisonValue: 0,
        rangeStartValue: 0,
        rangeEndValue: 0,
        rangeStartType: 'include',
        rangeEndType: 'include'
      };
    }

    var debounceInput = context.injector.get('debounceInput');
    _this.debouncedEditCell = debounceInput(_this.editCell.bind(_assertThisInitialized(_this)));
    _this.editCell = _this.editCell.bind(_assertThisInitialized(_this));
    _this.onComparisonOperatorChange = _this.onComparisonOperatorChange.bind(_assertThisInitialized(_this));
    _this.onComparisonValueChange = _this.onComparisonValueChange.bind(_assertThisInitialized(_this));
    _this.onTypeChange = _this.onTypeChange.bind(_assertThisInitialized(_this));
    _this.onRangeStartTypeChange = _this.onRangeStartTypeChange.bind(_assertThisInitialized(_this));
    _this.onRangeStartValueChange = _this.onRangeStartValueChange.bind(_assertThisInitialized(_this));
    _this.onRangeEndTypeChange = _this.onRangeEndTypeChange.bind(_assertThisInitialized(_this));
    _this.onRangeEndValueChange = _this.onRangeEndValueChange.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(InputNumberEdit, [{
    key: "editCell",
    value: function editCell(cell, text) {
      this._modeling.editCell(cell, text);
    }
  }, {
    key: "onTypeChange",
    value: function onTypeChange(value) {
      var element = this.props.context.element;
      var _this$state = this.state,
          comparisonOperator = _this$state.comparisonOperator,
          comparisonValue = _this$state.comparisonValue,
          rangeStartValue = _this$state.rangeStartValue,
          rangeEndValue = _this$state.rangeEndValue,
          rangeStartType = _this$state.rangeStartType,
          rangeEndType = _this$state.rangeEndType;

      if (value === COMPARISON) {
        this.editCell(element.businessObject, getComparisonString(comparisonOperator, comparisonValue));
      } else {
        this.editCell(element.businessObject, getRangeString(rangeStartValue, rangeEndValue, rangeStartType, rangeEndType));
      }

      this.setState({
        type: value
      });
    }
  }, {
    key: "onComparisonOperatorChange",
    value: function onComparisonOperatorChange(value) {
      var element = this.props.context.element;
      var _this$state2 = this.state,
          type = _this$state2.type,
          comparisonValue = _this$state2.comparisonValue;

      if (type === COMPARISON) {
        this.editCell(element.businessObject, getComparisonString(value, comparisonValue));
        this.setState({
          comparisonOperator: value
        });
      }
    }
  }, {
    key: "onComparisonValueChange",
    value: function onComparisonValueChange(comparisonValue) {
      var element = this.props.context.element;
      var _this$state3 = this.state,
          type = _this$state3.type,
          comparisonOperator = _this$state3.comparisonOperator;

      if (type === COMPARISON) {
        this.debouncedEditCell(element.businessObject, getComparisonString(comparisonOperator, comparisonValue));
        this.setState({
          comparisonValue: comparisonValue
        });
      }
    }
  }, {
    key: "onRangeStartTypeChange",
    value: function onRangeStartTypeChange(value) {
      var element = this.props.context.element;
      var _this$state4 = this.state,
          type = _this$state4.type,
          rangeStartValue = _this$state4.rangeStartValue,
          rangeEndValue = _this$state4.rangeEndValue,
          rangeEndType = _this$state4.rangeEndType;

      if (type === RANGE) {
        this.editCell(element.businessObject, getRangeString(rangeStartValue, rangeEndValue, value, rangeEndType));
        this.setState({
          rangeStartType: value
        });
      }
    }
  }, {
    key: "onRangeStartValueChange",
    value: function onRangeStartValueChange(value) {
      var element = this.props.context.element;
      var _this$state5 = this.state,
          type = _this$state5.type,
          rangeEndValue = _this$state5.rangeEndValue,
          rangeStartType = _this$state5.rangeStartType,
          rangeEndType = _this$state5.rangeEndType;

      if (type === RANGE) {
        this.editCell(element.businessObject, getRangeString(value, rangeEndValue, rangeStartType, rangeEndType));
        this.setState({
          rangeStartValue: value
        });
      }
    }
  }, {
    key: "onRangeEndTypeChange",
    value: function onRangeEndTypeChange(value) {
      var element = this.props.context.element;
      var _this$state6 = this.state,
          type = _this$state6.type,
          rangeStartValue = _this$state6.rangeStartValue,
          rangeEndValue = _this$state6.rangeEndValue,
          rangeStartType = _this$state6.rangeStartType;

      if (type === RANGE) {
        this.editCell(element.businessObject, getRangeString(rangeStartValue, rangeEndValue, rangeStartType, value));
        this.setState({
          rangeEndType: value
        });
      }
    }
  }, {
    key: "onRangeEndValueChange",
    value: function onRangeEndValueChange(value) {
      var element = this.props.context.element;
      var _this$state7 = this.state,
          type = _this$state7.type,
          rangeStartValue = _this$state7.rangeStartValue,
          rangeStartType = _this$state7.rangeStartType,
          rangeEndType = _this$state7.rangeEndType;

      if (type === RANGE) {
        this.editCell(element.businessObject, getRangeString(rangeStartValue, value, rangeStartType, rangeEndType));
        this.setState({
          rangeEndValue: value
        });
      }
    }
  }, {
    key: "renderComparison",
    value: function renderComparison(comparisonOperator, comparisonValue) {
      var comparisonOperatorOptions = [{
        label: 'Equals',
        value: 'equals'
      }, {
        label: 'Less',
        value: 'less'
      }, {
        label: 'Less or equals',
        value: 'lessEquals'
      }, {
        label: 'Greater',
        value: 'greater'
      }, {
        label: 'Greater or equals',
        value: 'greaterEquals'
      }];
      return createVNode(1, "div", "comparison", [createVNode(1, "h4", "dms-heading", createTextVNode("Value"), 2), createVNode(1, "div", "dms-fill-row", [createComponentVNode(2, InputSelect, {
        "noInput": true,
        "onChange": this.onComparisonOperatorChange,
        "options": comparisonOperatorOptions,
        "value": comparisonOperator
      }), createTextVNode("\xA0"), createComponentVNode(2, Input, {
        "className": "comparison-number-input",
        "onInput": this.onComparisonValueChange,
        "type": "number",
        "value": comparisonValue
      })], 4)], 4);
    }
  }, {
    key: "renderRange",
    value: function renderRange(rangeStartValue, rangeEndValue, rangeStartType, rangeEndType) {
      var rangeTypeOptions = [{
        label: 'Include',
        value: 'include'
      }, {
        label: 'Exclude',
        value: 'exclude'
      }];
      return createVNode(1, "div", "range", [createVNode(1, "h4", "dms-heading", createTextVNode("Start Value"), 2), createVNode(1, "div", "dms-fill-row", [createComponentVNode(2, InputSelect, {
        "noInput": true,
        "onChange": this.onRangeStartTypeChange,
        "options": rangeTypeOptions,
        "value": rangeStartType
      }), createTextVNode("\xA0"), createComponentVNode(2, Input, {
        "className": "range-start-number-input",
        "onInput": this.onRangeStartValueChange,
        "type": "number",
        "value": rangeStartValue
      })], 4), createVNode(1, "h4", "dms-heading", createTextVNode("End Value"), 2), createVNode(1, "div", "dms-fill-row", [createComponentVNode(2, InputSelect, {
        "noInput": true,
        "onChange": this.onRangeEndTypeChange,
        "options": rangeTypeOptions,
        "value": rangeEndType
      }), createTextVNode("\xA0"), createComponentVNode(2, Input, {
        "className": "range-end-number-input",
        "onInput": this.onRangeEndValueChange,
        "type": "number",
        "value": rangeEndValue
      })], 4)], 4);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state8 = this.state,
          type = _this$state8.type,
          comparisonOperator = _this$state8.comparisonOperator,
          comparisonValue = _this$state8.comparisonValue,
          rangeStartValue = _this$state8.rangeStartValue,
          rangeEndValue = _this$state8.rangeEndValue,
          rangeStartType = _this$state8.rangeStartType,
          rangeEndType = _this$state8.rangeEndType;
      var typeOptions = [{
        label: 'Comparison',
        value: COMPARISON
      }, {
        label: 'Range',
        value: RANGE
      }];
      return createVNode(1, "div", "context-menu-container simple-number-edit", [createVNode(1, "h3", "dms-heading", createTextVNode("Edit Number"), 2), createVNode(1, "div", "dms-fill-row", createComponentVNode(2, InputSelect, {
        "noInput": true,
        "onChange": this.onTypeChange,
        "options": typeOptions,
        "value": type
      }), 2), type === COMPARISON && this.renderComparison(comparisonOperator, comparisonValue), type === RANGE && this.renderRange(rangeStartValue, rangeEndValue, rangeStartType, rangeEndType)], 0);
    }
  }]);

  return InputNumberEdit;
}(Component);

export { InputNumberEdit as default };
//# sourceMappingURL=InputNumberEdit.js.map