function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import ContextMenuComponent from './components/SimpleStringEditContextMenuComponent';
import { isInput, isOutput } from 'dmn-js-shared/lib/util/ModelUtil';

var SimpleStringEdit = function SimpleStringEdit(components, simpleMode) {
  _classCallCheck(this, SimpleStringEdit);

  simpleMode.registerProvider(function (element) {
    return (isInput(element.col) || isOutput(element.col)) && getTypeRef(element) === 'string';
  });
  components.onGetComponent('context-menu', function () {
    var context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    if (context.contextMenuType && context.contextMenuType === 'simple-mode-edit') {
      if (!context.element) {
        return;
      }

      var typeRef = getTypeRef(context.element);

      if (typeRef === 'string') {
        return ContextMenuComponent;
      }
    }
  });
};

export { SimpleStringEdit as default };
SimpleStringEdit.$inject = ['components', 'simpleMode']; // helpers //////////////////////

function getTypeRef(element) {
  if (isInput(element.col)) {
    return element.col && element.col.businessObject.inputExpression.typeRef;
  } else {
    return element.col && element.col.businessObject.typeRef;
  }
}
//# sourceMappingURL=SimpleStringEdit.js.map