import { createVNode, createComponentVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

import { Component } from 'inferno';
import InputSelect from 'dmn-js-shared/lib/components/InputSelect';
import List from 'dmn-js-shared/lib/components/List';
import ValidatedInput from 'dmn-js-shared/lib/components/ValidatedInput';
import { isInput } from 'dmn-js-shared/lib/util/ModelUtil';
import { getInputOrOutputValues, parseString } from '../Utils';
var DISJUNCTION = 'disjunction',
    NEGATION = 'negation';
var INPUT_VALUES_LABEL = 'Predefined Values',
    OUTPUT_VALUES_LABEL = 'Predefined Values',
    INPUT_ENTRY_VALUES_LABEL = 'Custom Values';

var SimpleStringEditContextMenuComponent =
/*#__PURE__*/
function (_Component) {
  _inherits(SimpleStringEditContextMenuComponent, _Component);

  function SimpleStringEditContextMenuComponent(props, context) {
    var _this;

    _classCallCheck(this, SimpleStringEditContextMenuComponent);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(SimpleStringEditContextMenuComponent).call(this, props, context));
    _this._translate = context.injector.get('translate');
    _this._modeling = context.injector.get('modeling');
    var parsedString = parseString(props.context.element.businessObject.text); // could not parse

    if (!parsedString) {
      parsedString = {
        values: [],
        type: DISJUNCTION
      };
    }

    var inputOrOutputValues = getInputOrOutputValues(props.context.element.col.businessObject);
    var filteredValues = parsedString.values.filter(function (value) {
      return !includes(inputOrOutputValues, value);
    });
    var isInputClause = isInput(props.context.element.col);
    var items = inputOrOutputValues.map(function (value) {
      return {
        value: value,
        isChecked: includes(parsedString.values, value),
        isRemovable: false,
        group: isInputClause ? INPUT_VALUES_LABEL : OUTPUT_VALUES_LABEL
      };
    });

    if (isInputClause) {
      items = items.concat(filteredValues.map(function (value) {
        return {
          value: value,
          isChecked: true,
          isRemovable: true,
          group: INPUT_ENTRY_VALUES_LABEL
        };
      }));
    }

    var inputValue = '';

    if (!isInputClause && parsedString.values.length && !includes(inputOrOutputValues, parsedString.values[0])) {
      inputValue = parsedString.values[0];
    }

    _this.state = {
      items: items,
      unaryTestsType: parsedString.type,
      inputValue: inputValue,
      isOutputValueInputChecked: inputValue !== ''
    };
    var debounceInput = context.injector.get('debounceInput');
    _this.debouncedEditCell = debounceInput(_this.editCell.bind(_assertThisInitialized(_this)));
    _this.editCell = _this.editCell.bind(_assertThisInitialized(_this));
    _this.addUnaryTestsListItem = _this.addUnaryTestsListItem.bind(_assertThisInitialized(_this));
    _this.onInput = _this.onInput.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    _this.onOutputValueInputClick = _this.onOutputValueInputClick.bind(_assertThisInitialized(_this));
    _this.onUnaryTestsListChanged = _this.onUnaryTestsListChanged.bind(_assertThisInitialized(_this));
    _this.onUnaryTestsTypeChange = _this.onUnaryTestsTypeChange.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(SimpleStringEditContextMenuComponent, [{
    key: "editCell",
    value: function editCell(cell, text) {
      this._modeling.editCell(cell, text);
    }
    /**
     * Change type of unary tests.
     */

  }, {
    key: "onUnaryTestsTypeChange",
    value: function onUnaryTestsTypeChange(value) {
      var items = this.state.items;
      var values = getValues(items);
      var element = this.props.context.element;

      if (value === DISJUNCTION) {
        this.editCell(element.businessObject, values.join(','));
        this.setState({
          unaryTestsType: DISJUNCTION
        });
      } else {
        this.editCell(element.businessObject, "not(".concat(values.join(','), ")"));
        this.setState({
          unaryTestsType: NEGATION
        });
      }
    }
    /**
     * Change list of unary tests.
     */

  }, {
    key: "onUnaryTestsListChanged",
    value: function onUnaryTestsListChanged(items) {
      // get checked items
      var values = getValues(items);
      var element = this.props.context.element;
      var unaryTestsType = this.state.unaryTestsType;

      if (unaryTestsType === DISJUNCTION) {
        this.editCell(element.businessObject, values.join(','));
      } else {
        this.editCell(element.businessObject, "not(".concat(values.join(','), ")"));
      }

      this.setState({
        items: items,
        isOutputValueInputChecked: false
      });
    }
    /**
     * Set output value to input value.
     */

  }, {
    key: "onOutputValueInputClick",
    value: function onOutputValueInputClick() {
      var element = this.props.context.element;
      var _this$state = this.state,
          inputValue = _this$state.inputValue,
          items = _this$state.items;
      var parsedString = parseString(inputValue);

      if (!parsedString || parsedString.values.length > 1) {
        return;
      }

      this.editCell(element.businessObject, "".concat(parsedString.values.join(''))); // uncheck all other values

      this.setState({
        items: items.map(function (item) {
          item.isChecked = false;
          return item;
        }),
        isOutputValueInputChecked: true
      });
    }
    /**
     * Set output value if valid.
     */

  }, {
    key: "onInput",
    value: function onInput(_ref) {
      var isValid = _ref.isValid,
          value = _ref.value;
      var isOutputValueInputChecked = this.state.isOutputValueInputChecked;
      this.setState({
        inputValue: value
      });
      var element = this.props.context.element;

      if (!isInput(element) && isValid && isOutputValueInputChecked) {
        this.debouncedEditCell(element.businessObject, value);
      }
    }
    /**
     * Add new value on ENTER.
     */

  }, {
    key: "onKeyDown",
    value: function onKeyDown(_ref2) {
      var isValid = _ref2.isValid,
          event = _ref2.event;

      if (!isEnter(event.keyCode)) {
        return;
      }

      var element = this.props.context.element;
      var isInputClause = isInput(element.col); // stop ENTER propagation (and ContextMenu close)

      if (isInputClause || !isValid) {
        event.stopPropagation();
        event.preventDefault();
      }

      if (isValid) {
        if (isInputClause) {
          this.addUnaryTestsListItem();
        } else {
          this.onOutputValueInputClick();
        }
      }
    }
    /**
     * Add unary tests to list.
     */

  }, {
    key: "addUnaryTestsListItem",
    value: function addUnaryTestsListItem() {
      var _this$state2 = this.state,
          inputValue = _this$state2.inputValue,
          items = _this$state2.items,
          unaryTestsType = _this$state2.unaryTestsType;
      var parsedInput = parseString(inputValue);

      if (!parsedInput) {
        return;
      }

      var element = this.props.context.element;
      var values = getValues(items);
      var newValues = [].concat(values, parsedInput.values);

      if (unaryTestsType === DISJUNCTION) {
        this.editCell(element.businessObject, newValues.join(','));
      } else {
        this.editCell(element.businessObject, "not(".concat(newValues.join(','), ")"));
      }

      var newItems = items.concat(parsedInput.values.map(function (value) {
        return {
          value: value,
          isChecked: true,
          isRemovable: true,
          group: 'Custom Values'
        };
      }));
      this.setState({
        items: newItems,
        inputValue: ''
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var element = this.props.context.element;
      var _this$state3 = this.state,
          inputValue = _this$state3.inputValue,
          isOutputValueInputChecked = _this$state3.isOutputValueInputChecked,
          items = _this$state3.items,
          unaryTestsType = _this$state3.unaryTestsType;
      var options = [{
        label: 'Match one',
        value: DISJUNCTION
      }, {
        label: 'Match none',
        value: NEGATION
      }];
      var isInputClause = isInput(element.col);
      var isNegation = unaryTestsType === NEGATION;
      var showRadio = !isInputClause && items.length > 0;
      return createVNode(1, "div", "simple-string-edit context-menu-container", [createVNode(1, "h3", "dms-heading", this._translate('Edit String'), 0), isInputClause && createVNode(1, "p", null, createComponentVNode(2, InputSelect, {
        "noInput": true,
        "onChange": this.onUnaryTestsTypeChange,
        "options": options,
        "value": isNegation ? NEGATION : DISJUNCTION
      }, null, function (node) {
        return _this2.selectNode = node;
      }), 2), createComponentVNode(2, List, {
        "onChange": this.onUnaryTestsListChanged,
        "items": items,
        "type": isInputClause ? 'checkbox' : 'radio'
      }), isInputClause ? createVNode(1, "h4", "dms-heading", this._translate('Add Values'), 0) : createVNode(1, "h4", "dms-heading", this._translate('Set Value'), 0), createVNode(1, "div", "dms-fill-row", [showRadio && createVNode(64, "input", "cursor-pointer", null, 1, {
        "checked": isOutputValueInputChecked,
        "onClick": this.onOutputValueInputClick,
        "type": "radio",
        "style": {
          marginRight: '8px'
        }
      }), createComponentVNode(2, ValidatedInput, {
        "className": "dms-block",
        "onKeyDown": this.onKeyDown,
        "onInput": this.onInput,
        "placeholder": isInputClause ? '"value", "value", ...' : '"value"',
        "type": "text",
        "validate": function validate(value) {
          if (!parseString(value)) {
            return _this2._translate('Strings must be in double quotes.');
          }
        },
        "value": inputValue
      })], 0)], 0);
    }
  }]);

  return SimpleStringEditContextMenuComponent;
}(Component); // helpers //////////////////////


export { SimpleStringEditContextMenuComponent as default };

function isEnter(keyCode) {
  return keyCode === 13;
}
/**
 * Get array of actual values from array of items.
 *
 * @param {Array} items - Array of items.
 */


function getValues(items) {
  return items.filter(function (item) {
    return item.isChecked;
  }).map(function (item) {
    return item.value;
  });
}

function includes(array, value) {
  return array.indexOf(value) !== -1;
}
//# sourceMappingURL=SimpleStringEditContextMenuComponent.js.map