function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import ViewDrdComponent from './components/ViewDrdComponent';

var ViewDrd =
/*#__PURE__*/
function () {
  function ViewDrd(components, eventBus, injector, sheet) {
    var _this = this;

    _classCallCheck(this, ViewDrd);

    this._injector = injector;
    this._sheet = sheet;
    components.onGetComponent('table.before', function () {
      if (_this.canViewDrd()) {
        return ViewDrdComponent;
      }
    });
    eventBus.on('showDrd', function () {
      var parent = injector.get('_parent', false);
      var root = sheet.getRoot();
      var definitions = getDefinitions(root);

      if (!definitions) {
        return;
      } // open definitions


      var view = parent.getView(definitions);
      parent.open(view);
    });
  }

  _createClass(ViewDrd, [{
    key: "canViewDrd",
    value: function canViewDrd() {
      var parent = this._injector.get('_parent', false);

      if (!parent) {
        return false;
      }

      var root = this._sheet.getRoot();

      var definitions = getDefinitions(root);
      return !!parent.getView(definitions);
    }
  }]);

  return ViewDrd;
}();

export { ViewDrd as default };
ViewDrd.$inject = ['components', 'eventBus', 'injector', 'sheet']; // helpers //////////////////////

function getDefinitions(root) {
  var businessObject = root.businessObject; // root might not have business object

  if (!businessObject) {
    return;
  }

  var decision = businessObject.$parent;
  var definitions = decision.$parent;
  return definitions;
}
//# sourceMappingURL=ViewDrd.js.map