function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import { assign } from 'min-dash';
import { is } from 'dmn-js-shared/lib/util/ModelUtil';

function elementData(semantic, attrs) {
  return assign({
    id: semantic.id,
    type: semantic.$type,
    businessObject: semantic
  }, attrs);
}

var TableImporter =
/*#__PURE__*/
function () {
  function TableImporter(elementFactory, eventBus, sheet) {
    _classCallCheck(this, TableImporter);

    this._elementFactory = elementFactory;
    this._eventBus = eventBus;
    this._sheet = sheet;
  }
  /**
   * Add DMN element.
   */


  _createClass(TableImporter, [{
    key: "add",
    value: function add(semantic) {
      var _this = this;

      var element; // decision table

      if (is(semantic, 'dmn:DecisionTable')) {
        element = this._elementFactory.createRoot(elementData(semantic));

        this._sheet.setRoot(element);
      } // input clause
      else if (is(semantic, 'dmn:InputClause')) {
          element = this._elementFactory.createCol(elementData(semantic));

          this._sheet.addCol(element);
        } // output clause
        else if (is(semantic, 'dmn:OutputClause')) {
            element = this._elementFactory.createCol(elementData(semantic));

            this._sheet.addCol(element);
          } // rule
          else if (is(semantic, 'dmn:DecisionRule')) {
              if (!semantic.inputEntry) {
                semantic.inputEntry = [];
              }

              if (!semantic.outputEntry) {
                semantic.outputEntry = [];
              }

              var cells = [].concat(_toConsumableArray(semantic.inputEntry), _toConsumableArray(semantic.outputEntry)).map(function (entry) {
                return _this._elementFactory.createCell(elementData(entry));
              });
              element = this._elementFactory.createRow(assign(elementData(semantic), {
                cells: cells
              }));

              this._sheet.addRow(element);
            }

      this._eventBus.fire('dmnElement.added', {
        element: element
      });

      return element;
    }
  }]);

  return TableImporter;
}();

export { TableImporter as default };
TableImporter.$inject = ['elementFactory', 'eventBus', 'sheet'];
//# sourceMappingURL=TableImporter.js.map