function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import EventBus from 'diagram-js/lib/core/EventBus';
import DmnModdle from 'dmn-moddle';
import CamundaModdle from 'camunda-dmn-moddle/resources/camunda.json';
import { domify, query as domQuery, remove as domRemove } from 'min-dom';
import { assign, debounce, every, find, isDefined, isFunction, isNumber } from 'min-dash';
var DEFAULT_CONTAINER_OPTIONS = {
  width: '100%',
  height: '100%',
  position: 'relative'
};
/**
 * The base class for DMN viewers and editors.
 *
 * @abstract
 */

var Manager =
/*#__PURE__*/
function () {
  /**
   * Create a new instance with the given options.
   *
   * @param  {Object} options
   *
   * @return {Manager}
   */
  function Manager() {
    var _this = this;

    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Manager);

    _defineProperty(this, "_viewsChanged", function () {
      _this._emit('views.changed', {
        views: _this._views,
        activeView: _this._activeView
      });
    });

    this._eventBus = new EventBus();
    this._viewsChanged = debounce(this._viewsChanged, 0);
    this._views = [];
    this._viewers = {};

    this._init(options);
  }
  /**
   * Parse and render a DMN diagram.
   *
   * Once finished the viewer reports back the result to the
   * provided callback function with (err, warnings).
   *
   * ## Life-Cycle Events
   *
   * During import the viewer will fire life-cycle events:
   *
   *   * import.parse.start (about to read model from xml)
   *   * import.parse.complete (model read; may have worked or not)
   *   * import.render.start (graphical import start)
   *   * import.render.complete (graphical import finished)
   *   * import.done (everything done)
   *
   * You can use these events to hook into the life-cycle.
   *
   * @param {string} xml the DMN xml
   * @param {Object} [options]
   * @param {boolean} [options.open=true]
   * @param {Function} [done] invoked with (err, warnings=[])
   */


  _createClass(Manager, [{
    key: "importXML",
    value: function importXML(xml, options, done) {
      var _this2 = this;

      if (_typeof(options) !== 'object') {
        done = options;
        options = {
          open: true
        };
      }

      if (typeof done !== 'function') {
        done = noop;
      } // hook in pre-parse listeners +
      // allow xml manipulation


      xml = this._emit('import.parse.start', {
        xml: xml
      }) || xml;

      this._moddle.fromXML(xml, 'dmn:Definitions', function (err, definitions, context) {
        // hook in post parse listeners +
        // allow definitions manipulation
        definitions = _this2._emit('import.parse.complete', {
          error: err,
          definitions: definitions,
          context: context
        }) || definitions;
        var parseWarnings = context.warnings;

        _this2._setDefinitions(definitions);

        if (err) {
          err = checkDMNCompatibilityError(err, xml) || checkValidationError(err) || err;
        }

        if (err || !options.open) {
          _this2._emit('import.done', {
            error: err,
            warmings: parseWarnings
          });

          return done(err, parseWarnings);
        }

        var view = _this2._activeView || _this2._getInitialView(_this2._views);

        if (!view) {
          return done(new Error('no displayable contents'));
        }

        _this2.open(view, function (err, warnings) {
          var allWarnings = [].concat(parseWarnings, warnings || []);

          _this2._emit('import.done', {
            error: err,
            warnings: allWarnings
          });

          done(err, allWarnings);
        });
      });
    }
  }, {
    key: "getDefinitions",
    value: function getDefinitions() {
      return this._definitions;
    }
    /**
     * Return active view.
     *
     * @return {View}
     */

  }, {
    key: "getActiveView",
    value: function getActiveView() {
      return this._activeView;
    }
    /**
     * Get the currently active viewer instance.
     *
     * @return {View}
     */

  }, {
    key: "getActiveViewer",
    value: function getActiveViewer() {
      var activeView = this.getActiveView();
      return activeView && this._getViewer(activeView);
    }
  }, {
    key: "getView",
    value: function getView(element) {
      return this._views.filter(function (v) {
        return v.element === element;
      })[0];
    }
  }, {
    key: "getViews",
    value: function getViews() {
      return this._views;
    }
    /**
     * Export the currently displayed DMN diagram as
     * a DMN XML document.
     *
     * ## Life-Cycle Events
     *
     * During XML saving the viewer will fire life-cycle events:
     *
     *   * saveXML.start (before serialization)
     *   * saveXML.serialized (after xml generation)
     *   * saveXML.done (everything done)
     *
     * You can use these events to hook into the life-cycle.
     *
     * @param {Object} [options] export options
     * @param {boolean} [options.format=false] output formated XML
     * @param {boolean} [options.preamble=true] output preamble
     * @param {Function} done invoked with (err, xml)
     */

  }, {
    key: "saveXML",
    value: function saveXML(options, done) {
      var _this3 = this;

      if (typeof options === 'function') {
        done = options;
        options = {};
      }

      var definitions = this._definitions;

      if (!definitions) {
        return done(new Error('no definitions loaded'));
      } // allow to fiddle around with definitions


      definitions = this._emit('saveXML.start', {
        definitions: definitions
      }) || definitions;

      this._moddle.toXML(definitions, options, function (err, xml) {
        try {
          xml = _this3._emit('saveXML.serialized', {
            error: err,
            xml: xml
          }) || xml;

          _this3._emit('saveXML.done', {
            error: err,
            xml: xml
          });
        } catch (e) {
          console.error('error in saveXML life-cycle listener', e);
        }

        done(err, xml);
      });
    }
    /**
     * Register an event listener
     *
     * Remove a previously added listener via {@link #off(event, callback)}.
     *
     * @param {string} event
     * @param {number} [priority]
     * @param {Function} callback
     * @param {Object} [that]
     */

  }, {
    key: "on",
    value: function on() {
      var _this$_eventBus;

      (_this$_eventBus = this._eventBus).on.apply(_this$_eventBus, arguments);
    }
    /**
     * De-register an event listener
     *
     * @param {string} event
     * @param {Function} callback
     */

  }, {
    key: "off",
    value: function off() {
      var _this$_eventBus2;

      (_this$_eventBus2 = this._eventBus).off.apply(_this$_eventBus2, arguments);
    }
    /**
     * Register a listener to be invoked once only.
     *
     * @param {string} event
     * @param {number} [priority]
     * @param {Function} callback
     * @param {Object} [that]
     */

  }, {
    key: "once",
    value: function once() {
      var _this$_eventBus3;

      (_this$_eventBus3 = this._eventBus).once.apply(_this$_eventBus3, arguments);
    }
  }, {
    key: "attachTo",
    value: function attachTo(parentNode) {
      // unwrap jQuery if provided
      if (parentNode.get && parentNode.constructor.prototype.jquery) {
        parentNode = parentNode.get(0);
      }

      if (typeof parentNode === 'string') {
        parentNode = domQuery(parentNode);
      }

      parentNode.appendChild(this._container);

      this._emit('attach', {});
    }
  }, {
    key: "detach",
    value: function detach() {
      this._emit('detach', {});

      domRemove(this._container);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      var _this4 = this;

      Object.keys(this._viewers).forEach(function (viewerId) {
        var viewer = _this4._viewers[viewerId];
        safeExecute(viewer, 'destroy');
      });
      domRemove(this._container);
    }
  }, {
    key: "_init",
    value: function _init(options) {
      this._options = options;
      this._moddle = this._createModdle(options);
      this._viewers = {};
      this._views = [];
      var container = domify('<div class="dmn-js-parent"></div>');
      var containerOptions = assign({}, DEFAULT_CONTAINER_OPTIONS, options);
      assign(container.style, {
        width: ensureUnit(containerOptions.width),
        height: ensureUnit(containerOptions.height),
        position: containerOptions.position
      });
      this._container = container;

      if (options.container) {
        this.attachTo(options.container);
      }
    }
    /**
     * Open diagram element.
     *
     * @param  {ModdleElement}   element
     * @param  {Function} [done]
     */

  }, {
    key: "open",
    value: function open(view) {
      var done = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;

      this._switchView(view, done);
    }
  }, {
    key: "_setDefinitions",
    value: function _setDefinitions(definitions) {
      this._definitions = definitions;

      this._updateViews();
    }
  }, {
    key: "_updateViews",

    /**
     * Recompute changed views after elements in
     * the DMN diagram have changed.
     */
    value: function _updateViews() {
      var definitions = this._definitions;

      if (!definitions) {
        this._views = [];

        this._switchView(null);

        return;
      }

      var viewProviders = this._getViewProviders();

      var displayableElements = [definitions].concat(_toConsumableArray(definitions.drgElement || [])); // compute list of available views

      var views = this._views,
          newViews = [];
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = displayableElements[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var element = _step.value;
          var provider = find(viewProviders, function (provider) {
            if (typeof provider.opens === 'string') {
              return provider.opens === element.$type;
            } else {
              return provider.opens(element);
            }
          });

          if (!provider) {
            continue;
          }

          var view = {
            element: element,
            id: element.id,
            name: element.name,
            type: provider.id
          };
          newViews.push(view);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      var activeView = this._activeView,
          newActiveView;

      if (activeView) {
        // check the new active view
        newActiveView = find(newViews, function (view) {
          return viewsEqual(activeView, view);
        }) || this._getInitialView(newViews);

        if (!newActiveView) {
          return this._switchView(null);
        }
      } // Views have changed if
      // active view has changed OR
      // number of views has changed OR
      // not all views equal


      var activeViewChanged = !viewsEqual(activeView, newActiveView) || viewNameChanged(activeView, newActiveView);
      var viewsChanged = views.length !== newViews.length || !every(newViews, function (newView) {
        return find(views, function (view) {
          return viewsEqual(view, newView) && !viewNameChanged(view, newView);
        });
      });
      this._activeView = newActiveView;
      this._views = newViews;

      if (activeViewChanged || viewsChanged) {
        this._viewsChanged();
      }
    }
  }, {
    key: "_getInitialView",
    value: function _getInitialView(views) {
      return views[0];
    }
    /**
     * Switch to another view.
     *
     * @param  {View} newView
     * @param  {Function} [done]
     */

  }, {
    key: "_switchView",
    value: function _switchView(newView) {
      var _this5 = this;

      var done = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;

      var complete = function complete(err, warnings) {
        _this5._viewsChanged();

        done(err, warnings);
      };

      var activeView = this.getActiveView(),
          activeViewer;

      var newViewer = newView && this._getViewer(newView),
          element = newView && newView.element;

      if (activeView) {
        activeViewer = this._getViewer(activeView);

        if (activeViewer !== newViewer) {
          safeExecute(activeViewer, 'clear');
          activeViewer.detach();
        }
      }

      this._activeView = newView;

      if (newViewer) {
        if (activeViewer !== newViewer) {
          newViewer.attachTo(this._container);
        }

        this._emit('import.render.start', {
          view: newView,
          element: element
        });

        return newViewer.open(element, function (err, warnings) {
          _this5._emit('import.render.complete', {
            view: newView,
            error: err,
            warnings: warnings
          });

          complete(err, warnings);
        });
      } // no active view


      complete();
    }
  }, {
    key: "_getViewer",
    value: function _getViewer(view) {
      var type = view.type;
      var viewer = this._viewers[type];

      if (!viewer) {
        viewer = this._viewers[type] = this._createViewer(view.type);

        this._emit('viewer.created', {
          type: type,
          viewer: viewer
        });
      }

      return viewer;
    }
  }, {
    key: "_createViewer",
    value: function _createViewer(id) {
      var provider = find(this._getViewProviders(), function (provider) {
        return provider.id === id;
      });

      if (!provider) {
        throw new Error('no provider for view type <' + id + '>');
      }

      var Viewer = provider.constructor;
      var providerOptions = this._options[id] || {};
      var commonOptions = this._options.common || {};
      return new Viewer(_objectSpread({}, commonOptions, {}, providerOptions, {
        additionalModules: [].concat(_toConsumableArray(providerOptions.additionalModules || []), [{
          _parent: ['value', this],
          moddle: ['value', this._moddle]
        }])
      }));
    }
    /**
     * Emit an event.
     */

  }, {
    key: "_emit",
    value: function _emit() {
      var _this$_eventBus4;

      return (_this$_eventBus4 = this._eventBus).fire.apply(_this$_eventBus4, arguments);
    }
  }, {
    key: "_createModdle",
    value: function _createModdle(options) {
      return new DmnModdle(assign({
        camunda: CamundaModdle
      }, options.moddleExtensions));
    }
    /**
     * Return the list of available view providers.
     *
     * @abstract
     *
     * @return {Array<ViewProvider>}
     */

  }, {
    key: "_getViewProviders",
    value: function _getViewProviders() {
      return [];
    }
  }]);

  return Manager;
}(); // helpers //////////////////////


export { Manager as default };

function noop() {}
/**
 * Ensure the passed argument is a proper unit (defaulting to px)
 */


function ensureUnit(val) {
  return val + (isNumber(val) ? 'px' : '');
}

function checkDMNCompatibilityError(err, xml) {
  // check if we can indicate opening of old DMN 1.1 or DMN 1.2 diagrams
  if (err.message !== 'failed to parse document as <dmn:Definitions>') {
    return null;
  }

  var olderDMNVersion = xml.indexOf('"http://www.omg.org/spec/DMN/20151101/dmn.xsd"') !== -1 && '1.1' || xml.indexOf('"http://www.omg.org/spec/DMN/20180521/MODEL/"') !== -1 && '1.2';

  if (!olderDMNVersion) {
    return null;
  }

  err = new Error('unsupported DMN ' + olderDMNVersion + ' file detected; ' + 'only DMN 1.3 files can be opened');
  console.error('Cannot open what looks like a DMN ' + olderDMNVersion + ' diagram. ' + 'Please refer to https://bpmn.io/l/dmn-compatibility.html ' + 'to learn how to make the toolkit compatible with older DMN files', err);
  return err;
}

function checkValidationError(err) {
  // check if we can help the user by indicating wrong DMN 1.3 xml
  // (in case he or the exporting tool did not get that right)
  var pattern = /unparsable content <([^>]+)> detected([\s\S]*)$/,
      match = pattern.exec(err.message);

  if (!match) {
    return null;
  }

  err.message = 'unparsable content <' + match[1] + '> detected; ' + 'this may indicate an invalid DMN 1.3 diagram file' + match[2];
  return err;
}

function viewsEqual(a, b) {
  if (!isDefined(a)) {
    if (!isDefined(b)) {
      return true;
    } else {
      return false;
    }
  }

  if (!isDefined(b)) {
    return false;
  } // compare by element OR element ID equality


  return a.element === b.element || a.id === b.id;
}

function viewNameChanged(a, b) {
  return !a || !b || a.name !== b.name;
}

function safeExecute(viewer, method) {
  if (isFunction(viewer[method])) {
    viewer[method]();
  }
}
//# sourceMappingURL=Manager.js.map