function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * Base view API to be implemented by viewer editors.
 */
var View =
/*#__PURE__*/
function () {
  function View() {
    _classCallCheck(this, View);
  }

  _createClass(View, [{
    key: "attachTo",

    /**
     * Attach view to parentNode.
     *
     * @param  {Element} parentNode
     */
    value: function attachTo(parentNode) {}
    /**
     * Detach view.
     */

  }, {
    key: "detach",
    value: function detach() {}
    /**
     * Open view on the given element.
     *
     * @param  {View}   view
     * @param  {Function} [done]
     */

  }, {
    key: "open",
    value: function open(view) {
      var done = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;
      done();
    }
    /**
     * Subscribe to the given event.
     *
     * @param  {string}         event
     * @param  {Array<Object>}  args
     */

  }, {
    key: "on",
    value: function on(event) {}
    /**
     * Unsubscribe from given event.
     *
     * @param  {string}         event
     * @param  {Array<Object>}  args
     */

  }, {
    key: "off",
    value: function off(event) {}
    /**
     * Clear view (optional method).
     */

  }, {
    key: "clear",
    value: function clear() {}
    /**
     * Destroy view (optional method).
     */

  }, {
    key: "destroy",
    value: function destroy() {}
  }]);

  return View;
}(); // helpers //////////////////////


export { View as default };

function noop() {}
//# sourceMappingURL=View.js.map