function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import { Injector } from 'didi';
import core from './core';
/**
 * A base for React-style viewers.
 */

var Viewer =
/*#__PURE__*/
function () {
  function Viewer() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Viewer);

    var injector = options.injector;

    if (!injector) {
      var _this$_init = this._init(options),
          modules = _this$_init.modules,
          config = _this$_init.config;

      injector = createInjector(config, modules);
    }

    this.get = injector.get;
    this.invoke = injector.invoke;
    this.get('eventBus').fire('viewer.init');
  }
  /**
   * Intialize and return modules and config used for creation.
   *
   * @param  {Object} options
   *
   * @return {Object} { modules=[], config }
   */


  _createClass(Viewer, [{
    key: "_init",
    value: function _init(options) {
      var modules = options.modules,
          config = _objectWithoutProperties(options, ["modules"]);

      return {
        modules: modules,
        config: config
      };
    }
    /**
     * Destroy. This results in removing the attachment from the container.
     */

  }, {
    key: "destroy",
    value: function destroy() {
      var eventBus = this.get('eventBus');
      eventBus.fire('viewer.destroy');
    }
    /**
     * Clear. Should be used to reset the state of any stateful services.
     */

  }, {
    key: "clear",
    value: function clear() {
      var eventBus = this.get('eventBus');
      eventBus.fire('viewer.clear');
    }
  }]);

  return Viewer;
}(); // helpers //////////////////////


export { Viewer as default };

function bootstrap(bootstrapModules) {
  var modules = [],
      components = [];

  function hasModule(m) {
    return modules.indexOf(m) >= 0;
  }

  function addModule(m) {
    modules.push(m);
  }

  function visit(m) {
    if (hasModule(m)) {
      return;
    }

    (m.__depends__ || []).forEach(visit);

    if (hasModule(m)) {
      return;
    }

    addModule(m);
    (m.__init__ || []).forEach(function (c) {
      components.push(c);
    });
  }

  bootstrapModules.forEach(visit);
  var injector = new Injector(modules);
  components.forEach(function (c) {
    try {
      // eagerly resolve component (fn or string)
      injector[typeof c === 'string' ? 'get' : 'invoke'](c);
    } catch (e) {
      console.error('Failed to instantiate component');
      console.error(e.stack);
      throw e;
    }
  });
  return injector;
}

function createInjector(config, modules) {
  var bootstrapModules = [{
    config: ['value', config]
  }, core].concat(modules || []);
  return bootstrap(bootstrapModules);
}
//# sourceMappingURL=Viewer.js.map