function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ChangeSupport =
/*#__PURE__*/
function () {
  function ChangeSupport(eventBus) {
    var _this = this;

    _classCallCheck(this, ChangeSupport);

    this._listeners = {};
    eventBus.on('elements.changed', function (_ref) {
      var elements = _ref.elements;

      _this.elementsChanged(elements);
    });
    eventBus.on('element.updateId', function (_ref2) {
      var element = _ref2.element,
          newId = _ref2.newId;

      _this.updateId(element.id, newId);
    });
  }

  _createClass(ChangeSupport, [{
    key: "elementsChanged",
    value: function elementsChanged(elements) {
      var invoked = {};
      var elementsLength = elements.length;

      for (var i = 0; i < elementsLength; i++) {
        var id = elements[i].id;

        if (invoked[id]) {
          return;
        }

        invoked[id] = true;
        var listenersLength = this._listeners[id] && this._listeners[id].length;

        if (listenersLength) {
          for (var j = 0; j < listenersLength; j++) {
            // listeners might remove themselves before they get called
            this._listeners[id][j] && this._listeners[id][j]();
          }
        }
      }
    }
  }, {
    key: "onElementsChanged",
    value: function onElementsChanged(id, listener) {
      if (!this._listeners[id]) {
        this._listeners[id] = [];
      } // avoid push for better performance


      this._listeners[id][this._listeners[id].length] = listener;
    }
  }, {
    key: "offElementsChanged",
    value: function offElementsChanged(id, listener) {
      if (!this._listeners[id]) {
        return;
      }

      if (listener) {
        var idx = this._listeners[id].indexOf(listener);

        if (idx !== -1) {
          this._listeners[id].splice(idx, 1);
        }
      } else {
        this._listeners[id].length = 0;
      }
    }
  }, {
    key: "updateId",
    value: function updateId(oldId, newId) {
      if (this._listeners[oldId]) {
        this._listeners[newId] = this._listeners[oldId];
        delete this._listeners[oldId];
      }
    }
  }]);

  return ChangeSupport;
}();

export { ChangeSupport as default };
ChangeSupport.$inject = ['eventBus'];
//# sourceMappingURL=ChangeSupport.js.map