function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import { isFunction, isNumber } from 'min-dash';
var DEFAULT_PRIORITY = 1000;

var Components =
/*#__PURE__*/
function () {
  function Components() {
    _classCallCheck(this, Components);

    this._listeners = {};
  }

  _createClass(Components, [{
    key: "getComponent",
    value: function getComponent(type, context) {
      var listeners = this._listeners[type];

      if (!listeners) {
        return;
      }

      var component;

      for (var i = 0; i < listeners.length; i++) {
        component = listeners[i].callback(context);

        if (component) {
          break;
        }
      }

      return component;
    }
  }, {
    key: "getComponents",
    value: function getComponents(type, context) {
      var listeners = this._listeners[type];

      if (!listeners) {
        return;
      }

      var components = [];

      for (var i = 0; i < listeners.length; i++) {
        var component = listeners[i].callback(context);

        if (component) {
          components.push(component);
        }
      }

      if (!components.length) {
        return;
      }

      return components;
    }
  }, {
    key: "onGetComponent",
    value: function onGetComponent(type, priority, callback) {
      if (isFunction(priority)) {
        callback = priority;
        priority = DEFAULT_PRIORITY;
      }

      if (!isNumber(priority)) {
        throw new Error('priority must be a number');
      }

      var listeners = this._getListeners(type);

      var existingListener, idx;
      var newListener = {
        priority: priority,
        callback: callback
      };

      for (idx = 0; existingListener = listeners[idx]; idx++) {
        if (existingListener.priority < priority) {
          // prepend newListener at before existingListener
          listeners.splice(idx, 0, newListener);
          return;
        }
      }

      listeners.push(newListener);
    }
  }, {
    key: "offGetComponent",
    value: function offGetComponent(type, callback) {
      var listeners = this._getListeners(type);

      var listener, listenerCallback, idx;

      if (callback) {
        // move through listeners from back to front
        // and remove matching listeners
        for (idx = listeners.length - 1; listener = listeners[idx]; idx--) {
          listenerCallback = listener.callback;

          if (listenerCallback === callback) {
            listeners.splice(idx, 1);
          }
        }
      } else {
        // clear listeners
        listeners.length = 0;
      }
    }
  }, {
    key: "_getListeners",
    value: function _getListeners(type) {
      var listeners = this._listeners[type];

      if (!listeners) {
        this._listeners[type] = listeners = [];
      }

      return listeners;
    }
  }]);

  return Components;
}();

export { Components as default };
//# sourceMappingURL=Components.js.map