import { createComponentVNode } from "inferno";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import { render } from 'inferno';
import ViewerComponent from './components/ViewerComponent';

var Renderer =
/*#__PURE__*/
function () {
  function Renderer(changeSupport, components, config, eventBus, injector) {
    _classCallCheck(this, Renderer);

    var container = config.container;
    this._container = container;
    eventBus.on('renderer.mount', function () {
      render(createComponentVNode(2, ViewerComponent, {
        "injector": injector
      }), container);
    });
    eventBus.on('renderer.unmount', function () {
      render(null, container);
    });
  }

  _createClass(Renderer, [{
    key: "getContainer",
    value: function getContainer() {
      return this._container;
    }
  }]);

  return Renderer;
}();

export { Renderer as default };
Renderer.$inject = ['changeSupport', 'components', 'config.renderer', 'eventBus', 'injector'];
//# sourceMappingURL=Renderer.js.map