import { createVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { Component } from 'inferno';
import escapeHtml from 'escape-html';
import { getRange, setRange, applyRange, getWindowSelection } from 'selection-ranges';
import selectionUpdate from 'selection-update';
/**
 * A content ediable that performs proper selection updates on
 * editable changes. It normalizes editor operations by allowing
 * only <br/> and plain text to be inserted.
 *
 * The callback `onInput(text)` recieves text (including line breaks)
 * only. Updating the value via props will update the selection
 * if needed, too.
 *
 * @example
 *
 * class SomeComponent extends Component {
 *
 *   render() {
 *     return (
 *       <ContentEditable
 *         className="some classes"
 *         value={ this.state.text }
 *         onInput={ this.handleInput }
 *         onFocus={ ... }
 *         onBlur={ ... } />
 *     );
 *   }
 *
 * }
 *
 */

var ContentEditable =
/*#__PURE__*/
function (_Component) {
  _inherits(ContentEditable, _Component);

  function ContentEditable(props, context) {
    var _this;

    _classCallCheck(this, ContentEditable);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ContentEditable).call(this, props, context));

    _defineProperty(_assertThisInitialized(_this), "onFocus", function (event) {
      var propsFocus = _this.props.onFocus;

      _this.setState({
        focussed: true
      });

      if (typeof propsFocus === 'function') {
        propsFocus(event);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onBlur", function (event) {
      var propsBlur = _this.props.onBlur;

      _this.setState({
        focussed: false
      });

      if (typeof propsBlur === 'function') {
        propsBlur(event);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onKeydown", function (event) {
      // enter
      if (event.which === 13) {
        // prevent default action (<br/> insert)
        event.preventDefault();

        if (_this.props.ctrlForNewline && !isCmd(event)) {
          return;
        }

        if (_this.props.singleLine) {
          return;
        }

        event.stopPropagation();
        insertLineBreak();

        _this.onInput(event);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onInput", function (event) {
      var propsInput = _this.props.onInput;

      if (typeof propsInput !== 'function') {
        return;
      }

      var text = innerText(_this.node);
      propsInput(text);
    });

    _defineProperty(_assertThisInitialized(_this), "onKeyPress", function (event) {
      if (_this.onInputIEPolyfill) {
        _this.onInputIEPolyfill(event);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onPaste", function (event) {
      // TODO(barmac): remove once we drop IE 11 support
      if (_this.onInputIEPolyfill) {
        _this.onInputIEPolyfill(event);
      }

      if (_this.props.singleLine) {
        var text = (event.clipboardData || window.clipboardData).getData('text'); // replace newline with space

        document.execCommand('insertText', false, text.replace(/\n/g, ' '));
        event.preventDefault();
      }
    });

    _this.state = {}; // TODO(nikku): remove once we drop IE 11 support

    if (isIE()) {
      // onInput shim for IE <= 11
      _this.onInputIEPolyfill = function (event) {
        var oldText = _this.node.innerHTML;
        setTimeout(function () {
          var text = _this.node.innerHTML;

          if (oldText !== text) {
            _this.onInput(event);
          }
        }, 0);
      };
    }

    return _this;
  }

  _createClass(ContentEditable, [{
    key: "componentWillUpdate",
    value: function componentWillUpdate(newProps, newState) {
      // save old selection + text for later
      var node = this.node;
      var range = newState.focussed && getRange(node);
      this.selected = range && {
        range: range,
        text: innerText(node)
      };
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var selected = this.selected;

      if (!selected) {
        return;
      } // compute and restore selection based on
      // (possibly new) text


      var range = selected.range;
      var text = selected.text;
      var node = this.node;
      var newText = innerText(node);
      var newRange = newText !== text ? selectionUpdate(range, text, newText) : range;
      setRange(node, newRange);
    }
  }, {
    key: "getClassName",
    value: function getClassName() {
      var _this$props = this.props,
          className = _this$props.className,
          placeholder = _this$props.placeholder,
          value = _this$props.value;
      return [className || '', 'content-editable', !value && placeholder ? 'content-editable--with-placeholder' : ''].join(' ');
    }
  }, {
    key: "render",
    value: function render(props) {
      var _this2 = this;

      var value = props.value,
          placeholder = props.placeholder; // QUIRK: must add trailing <br/> for line
      // breaks to properly work

      value = escapeHtml(value).replace(/\r?\n/g, '<br/>') + '<br/>';
      return createVNode(1, "div", this.getClassName(), null, 1, {
        "contentEditable": "true",
        "spellcheck": "false",
        "data-placeholder": placeholder || '',
        "onInput": this.onInput,
        "onKeypress": this.onKeypress,
        "onPaste": this.onPaste,
        "onFocus": this.onFocus,
        "onBlur": this.onBlur,
        "onKeydown": this.onKeydown,
        "dangerouslySetInnerHTML": {
          __html: value
        }
      }, null, function (node) {
        return _this2.node = node;
      });
    }
  }]);

  return ContentEditable;
}(Component);

export { ContentEditable as default };

function brTag() {
  return document.createElement('br');
}

function innerText(node) {
  // QUIRK: we must remove the last trailing <br/>, if any
  return node.innerText.replace(/\n$/, '');
}

function insertLineBreak() {
  // insert line break at current insertation
  // point; this assumes that the correct element, i.e.
  // a <ContentEditable /> is currently focussed
  var selection = getWindowSelection();
  var range = selection.getRangeAt(0);

  if (!range) {
    return;
  }

  var newRange = range.cloneRange();
  var br = brTag();
  newRange.deleteContents();
  newRange.insertNode(br);
  newRange.setStartAfter(br);
  newRange.setEndAfter(br);
  applyRange(newRange);
}

function isIE() {
  var ua = window.navigator.userAgent;
  return (// IE 10 or older
    ua.indexOf('MSIE ') > 0 || // IE 11
    ua.indexOf('Trident/') > 0
  );
}

function isCmd(event) {
  return event.metaKey || event.ctrlKey;
}
//# sourceMappingURL=ContentEditable.js.map