import { createComponentVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { Component } from 'inferno';
import ContentEditable from './ContentEditable';
/**
 * A base component for interactivity.
 *
 * @example
 *
 * class Foo extends EditableComponent {
 *
 *   render() {
 *     return (
 *       <div>{ this.getEditor() }</div>
 *     );
 *   }
 * }
 *
 * And in use:
 *
 * <Foo value={ blub }
 *      onChange={ (newValue) => { ... }
 *      onFocus={ () => { ... } }
 *      onBlur={ () => { ... } }
 *      validate={ (newValue) => { return 'some-error'; } }
 *      className="..." } />
 *
 * Special classes added:
 *
 * * focused
 * * invalid
 *
 */

var EditableComponent =
/*#__PURE__*/
function (_Component) {
  _inherits(EditableComponent, _Component);

  function EditableComponent(props, context) {
    var _this;

    _classCallCheck(this, EditableComponent);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(EditableComponent).call(this, props, context));

    _defineProperty(_assertThisInitialized(_this), "onFocus", function (event) {
      _this.setState({
        focussed: true
      });

      var onFocus = _this.props.onFocus;

      if (typeof onFocus === 'function') {
        onFocus(event);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onBlur", function (event) {
      _this.setState({
        focussed: false
      });

      var invalid = _this.state.invalid;

      if (invalid) {
        _this.setState({
          changing: false,
          invalid: false
        });
      }

      var onBlur = _this.props.onBlur;

      if (typeof onBlur === 'function') {
        onBlur(event);
      }
    });

    _this.state = {
      changing: false,
      focussed: false
    };
    var injector = context.injector;
    var debounceInput = injector.get('debounceInput');
    _this.inputChanged = debounceInput(function (value) {
      var onChange = _this.props.onChange;

      if (typeof onChange === 'function') {
        onChange(value);
      } // only unset changed if user input and
      // committed changed value equal. This prevents the
      // input jumping back to the saved, good value.


      var currentValue = _this.state.changing;

      _this.setState({
        changing: currentValue === value ? false : currentValue
      });
    });

    _this.onInput = function (value) {
      var validate = _this.props.validate || function () {};

      var invalid = validate(value);

      _this.setState({
        changing: value,
        invalid: invalid
      });

      if (!invalid) {
        _this.inputChanged(value);
      }
    };

    return _this;
  }

  _createClass(EditableComponent, [{
    key: "getClassName",
    value: function getClassName() {
      var _this$props = this.props,
          className = _this$props.className,
          value = _this$props.value;
      var _this$state = this.state,
          changing = _this$state.changing,
          focussed = _this$state.focussed,
          invalid = _this$state.invalid;
      className += ' editable';

      if (focussed) {
        className += ' focussed';
      }

      if (invalid) {
        className += ' invalid';
      }

      if (!value && !changing) {
        className += ' empty';
      }

      return className;
    }
  }, {
    key: "getDisplayValue",
    value: function getDisplayValue() {
      var _this$props2 = this.props,
          value = _this$props2.value,
          placeholder = _this$props2.placeholder;
      var _this$state2 = this.state,
          focussed = _this$state2.focussed,
          changing = _this$state2.changing;

      if (typeof changing === 'string') {
        value = changing;
      }

      if (!value) {
        value = focussed ? '' : placeholder || '';
      }

      return value;
    }
  }, {
    key: "getEditor",
    value: function getEditor() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      return createComponentVNode(2, ContentEditable, {
        "className": props.className,
        "ctrlForNewline": props.ctrlForNewline,
        "onFocus": this.onFocus,
        "onBlur": this.onBlur,
        "onInput": this.onInput,
        "value": this.getDisplayValue()
      });
    }
  }]);

  return EditableComponent;
}(Component);

export { EditableComponent as default };
//# sourceMappingURL=EditableComponent.js.map