import { createVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { Component, createPortal } from 'inferno';
import { inject } from 'table-js/lib/components';
import { assign } from 'min-dash';
import { domify, remove as domRemove } from 'min-dom';

var InputSelect =
/*#__PURE__*/
function (_Component) {
  _inherits(InputSelect, _Component);

  function InputSelect(props, context) {
    var _this;

    _classCallCheck(this, InputSelect);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(InputSelect).call(this, props, context));

    _defineProperty(_assertThisInitialized(_this), "onChange", function (value) {
      _this.setState({
        value: value
      });

      var onChange = _this.props.onChange;

      if (typeof onChange !== 'function') {
        return;
      }

      onChange(value);
    });

    _defineProperty(_assertThisInitialized(_this), "onInputClick", function (event) {
      event.preventDefault();
      event.stopPropagation();

      _this.setOptionsVisible(!_this.state.optionsVisible);

      _this.focusInput();
    });

    _defineProperty(_assertThisInitialized(_this), "onInput", function (event) {
      var value = event.target.value;

      _this.onChange(value);
    });

    _defineProperty(_assertThisInitialized(_this), "onOptionClick", function (value, event) {
      event.preventDefault();
      event.stopPropagation();

      _this.setOptionsVisible(false);

      _this.onChange(value);

      _this.focusInput();
    });

    _defineProperty(_assertThisInitialized(_this), "onFocusChanged", function (evt) {
      _this.checkClose(evt.target);
    });

    _defineProperty(_assertThisInitialized(_this), "onGlobalClick", function (evt) {
      _this.checkClose(evt.target);
    });

    _defineProperty(_assertThisInitialized(_this), "onKeyDown", function (evt) {
      var optionsVisible = _this.state.optionsVisible;
      var code = evt.which; // DOWN or UP

      if (code === 40 || code === 38) {
        evt.stopPropagation();
        evt.preventDefault();

        if (!optionsVisible) {
          _this.setOptionsVisible(true);
        } else {
          _this.select(code === 40 ? 1 : -1);
        }
      }

      if (optionsVisible) {
        // ENTER
        // ESC
        if (code === 13 || code === 27) {
          evt.stopPropagation();
          evt.preventDefault();

          _this.setOptionsVisible(false);
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onKeyboard", function (keycode) {
      var optionsVisible = _this.state.optionsVisible;

      if (!optionsVisible) {
        return;
      } // close on ESC


      if (keycode === 27) {
        _this.setOptionsVisible(false);

        return true;
      }
    });

    inject(_assertThisInitialized(_this));
    var _value = props.value;
    _this.state = {
      value: _value,
      optionsVisible: false
    };
    _this._portalEl = null;
    return _this;
  }

  _createClass(InputSelect, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      document.addEventListener('mousedown', this.onGlobalClick);
      document.addEventListener('focusin', this.onFocusChanged);
      this.keyboard.addListener(this.onKeyboard);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.removeEventListener('focusin', this.onFocusChanged);
      document.removeEventListener('mousedown', this.onGlobalClick);
      this.keyboard.removeListener(this.onKeyboard);
      this.removePortalEl();
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(props) {
      var value = props.value;
      this.setState({
        value: value
      });
    }
  }, {
    key: "componentWillUpdate",
    value: function componentWillUpdate(nextProps, nextState) {
      var optionsVisible = nextState.optionsVisible;

      if (optionsVisible) {
        if (!this._portalEl) {
          this.addPortalEl();
        }
      } else {
        if (this._portalEl) {
          this.removePortalEl();
        }
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var optionsVisible = this.state.optionsVisible;

      if (!optionsVisible || !this.inputNode) {
        return;
      }

      var optionsBounds = this.getOptionsBounds();
      assign(this._portalEl.style, optionsBounds);
    }
  }, {
    key: "getOptionsBounds",
    value: function getOptionsBounds() {
      var container = this.renderer.getContainer();

      var _container$getBoundin = container.getBoundingClientRect(),
          containerTop = _container$getBoundin.top,
          containerLeft = _container$getBoundin.left;

      var _this$inputNode$getBo = this.inputNode.getBoundingClientRect(),
          inputTop = _this$inputNode$getBo.top,
          inputLeft = _this$inputNode$getBo.left,
          width = _this$inputNode$getBo.width,
          height = _this$inputNode$getBo.height;

      var top = inputTop + height - containerTop + container.scrollTop;
      var left = inputLeft - containerLeft + container.scrollLeft;
      return {
        top: "".concat(top, "px"),
        left: "".concat(left, "px"),
        width: "".concat(width, "px")
      };
    }
  }, {
    key: "addPortalEl",
    value: function addPortalEl() {
      this._portalEl = domify('<div class="dms-select-options"></div>');
      var container = this.renderer.getContainer();
      container.appendChild(this._portalEl); // suppress mousedown event propagation to handle click events inside the component

      this._portalEl.addEventListener('mousedown', stopPropagation);
    }
  }, {
    key: "removePortalEl",
    value: function removePortalEl() {
      if (this._portalEl) {
        this._portalEl.removeEventListener('mousedown', stopPropagation);

        domRemove(this._portalEl);
        this._portalEl = null;
      }
    }
  }, {
    key: "focusInput",

    /**
     * Focus input node
     */
    value: function focusInput() {
      var node = this.inputNode;
      node.focus(); // move cursor to end of input

      if ('selectionStart' in node) {
        node.selectionStart = 100000;
      }
    }
  }, {
    key: "checkClose",
    value: function checkClose(focusTarget) {
      if (this._portalEl && !this._portalEl.contains(focusTarget) && !this.parentNode.contains(focusTarget)) {
        this.setOptionsVisible(false);
      }
    }
  }, {
    key: "select",
    value: function select(direction) {
      var options = this.props.options;
      var value = this.state.value;

      if (!options) {
        return;
      }

      var option = options.filter(function (o) {
        return o.value === value;
      })[0];
      var idx = option ? options.indexOf(option) : -1;
      var nextIdx = idx === -1 ? direction === 1 ? 0 : options.length - 1 : (idx + direction) % options.length;
      var nextOption = options[nextIdx < 0 ? options.length + nextIdx : nextIdx];
      this.onChange(nextOption.value);
    }
  }, {
    key: "setOptionsVisible",
    value: function setOptionsVisible(optionsVisible) {
      this.setState({
        optionsVisible: optionsVisible
      });
    }
  }, {
    key: "renderOptions",
    value: function renderOptions(options, activeOption) {
      var _this2 = this;

      return createVNode(1, "div", "options", options.map(function (option) {
        return createVNode(1, "div", ['option', activeOption === option ? 'active' : ''].join(' '), option.label, 0, {
          "data-value": option.value,
          "onClick": function onClick(e) {
            return _this2.onOptionClick(option.value, e);
          }
        });
      }), 0);
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _this$props = this.props,
          className = _this$props.className,
          options = _this$props.options,
          noInput = _this$props.noInput,
          title = _this$props.title;
      var _this$state = this.state,
          optionsVisible = _this$state.optionsVisible,
          value = _this$state.value;
      var option = options ? options.filter(function (o) {
        return o.value === value;
      })[0] : false;
      var label = option ? option.label : value;
      return createVNode(1, "div", [className || '', 'dms-input-select'].join(' '), [noInput ? createVNode(1, "div", "dms-input", label, 0, {
        "tabindex": "0",
        "onKeyDown": this.onKeyDown
      }, null, function (node) {
        return _this3.inputNode = node;
      }) : createVNode(64, "input", "dms-input", null, 1, {
        "onInput": this.onInput,
        "onKeyDown": this.onKeyDown,
        "spellcheck": "false",
        "type": "text",
        "value": value
      }, null, function (node) {
        return _this3.inputNode = node;
      }), createVNode(1, "span", ['dms-input-select-icon', optionsVisible ? 'dmn-icon-up' : 'dmn-icon-down'].join(' ')), optionsVisible && createPortal(this.renderOptions(options, option), this._portalEl)], 0, {
        "title": title,
        "onClick": this.onInputClick
      }, null, function (node) {
        return _this3.parentNode = node;
      });
    }
  }]);

  return InputSelect;
}(Component);

export { InputSelect as default };
InputSelect.$inject = ['keyboard', 'renderer']; // helper ////

function stopPropagation(event) {
  event.stopPropagation();
}
//# sourceMappingURL=InputSelect.js.map