import { createVNode, createTextVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { Component } from 'inferno';
import { groupBy } from 'min-dash';
var RADIO = 'radio';
var REMOVE_BTN_CLS = 'remove dmn-icon-clear';
/**
 * Shows a list of grouped items that can be checked
 * (checkboxes or radio buttons), removed.
 *
 * Example list of items:
 *
 * [
 *   { value: 'foo', isChecked: true, isRemovable: false, group: 'foo' },
 *   { value: 'bar', isChecked: false, isRemovable: true, group: 'bar' },
 *   { value: 'baz', isCheckable: false, group: 'baz' }
 * ]
 */

var List =
/*#__PURE__*/
function (_Component) {
  _inherits(List, _Component);

  function List(props, context) {
    var _this;

    _classCallCheck(this, List);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(List).call(this, props, context));

    _defineProperty(_assertThisInitialized(_this), "getRemoveClickHandler", function (item) {
      return function (e) {
        e.stopPropagation();

        _this.removeItem(item);
      };
    });

    _defineProperty(_assertThisInitialized(_this), "getToggleClickHandler", function (item) {
      return function (e) {
        e.stopPropagation();

        _this.toggleItem(item);
      };
    });

    _defineProperty(_assertThisInitialized(_this), "removeItem", function (item) {
      var onChange = _this.props.onChange; // remove item

      var newItems = _this.state.items.filter(function (i) {
        return i !== item;
      });

      _this.setState({
        items: newItems
      });

      onChange && onChange(newItems);
    });

    _defineProperty(_assertThisInitialized(_this), "toggleItem", function (item) {
      var _this$props = _this.props,
          onChange = _this$props.onChange,
          type = _this$props.type; // toggle item

      var newItems = _this.state.items.map(function (i) {
        if (i === item) {
          i.isChecked = !i.isChecked;
        } else {
          if (type === RADIO) {
            i.isChecked = false;
          }
        }

        return i;
      });

      _this.setState({
        items: newItems
      });

      onChange && onChange(newItems);
    });

    var items = props.items;
    _this.state = {
      items: items
    };
    return _this;
  }

  _createClass(List, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(props) {
      var items = props.items;
      this.setState({
        items: items
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          className = _this$props2.className,
          items = _this$props2.items,
          type = _this$props2.type,
          labelComponent = _this$props2.labelComponent;
      var classes = ['dms-list-component'];

      if (className) {
        classes.push(className);
      } // group items by group title


      var groupedItems = groupBy(items, 'group');
      var asPairs = toPairs(groupedItems);
      return createVNode(1, "div", classes.join(' '), asPairs.map(function (pair) {
        var groupTitle = pair[0],
            groupItems = pair[1];
        return createVNode(1, "div", "group", [labelComponent && labelComponent(groupTitle) || createVNode(1, "h4", "dms-heading", groupTitle, 0), createVNode(1, "ul", "items no-wrap", groupItems.map(function (item) {
          return createVNode(1, "li", "item", [type && createVNode(64, "input", "item-toggle", null, 1, {
            "type": type,
            "checked": item.isChecked,
            "onClick": _this2.getToggleClickHandler(item)
          }), createTextVNode("\xA0"), item.value, item.isRemovable && createVNode(1, "span", REMOVE_BTN_CLS, null, 1, {
            "title": "Remove item",
            "onClick": _this2.getRemoveClickHandler(item)
          })], 0);
        }), 0)], 0);
      }), 0);
    }
  }]);

  return List;
}(Component); // helpers ////////////


export { List as default };

function toPairs(object) {
  var entrys = [];

  for (var key in object) {
    entrys.push([key, object[key]]);
  }

  return entrys;
}
//# sourceMappingURL=List.js.map