import { createVNode, createComponentVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

import { Component } from 'inferno'; // eslint-disable-next-line

import Input from './Input';
/**
 * Input with optional validation.
 */

var ValidatedInput =
/*#__PURE__*/
function (_Component) {
  _inherits(ValidatedInput, _Component);

  function ValidatedInput(props, context) {
    var _this;

    _classCallCheck(this, ValidatedInput);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ValidatedInput).call(this, props, context));
    var validate = props.validate,
        value = props.value;
    var validationWarning = validate ? validate(value || '') : undefined;
    _this.state = {
      validationWarning: validationWarning,
      value: value
    };
    _this.onInput = _this.onInput.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    _this.onKeyUp = _this.onKeyUp.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(ValidatedInput, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(props) {
      var validate = props.validate,
          value = props.value;
      var validationWarning = validate ? validate(value || '') : undefined;
      this.setState({
        validationWarning: validationWarning,
        value: value
      });
    }
  }, {
    key: "onInput",
    value: function onInput(value) {
      var _this$props = this.props,
          onInput = _this$props.onInput,
          validate = _this$props.validate;
      var validationWarning = validate ? validate(value) : undefined;
      this.setState({
        validationWarning: validationWarning,
        value: value
      });

      if (typeof onInput !== 'function') {
        return;
      }

      onInput && onInput({
        isValid: !validationWarning,
        value: value
      });
    }
  }, {
    key: "onKeyDown",
    value: function onKeyDown(event) {
      var target = event.target,
          value = target.value;
      var _this$props2 = this.props,
          onKeyDown = _this$props2.onKeyDown,
          validate = _this$props2.validate;
      var validationWarning = validate ? validate(value) : undefined;

      if (typeof onKeyDown !== 'function') {
        return;
      }

      onKeyDown({
        isValid: !validationWarning,
        value: value,
        event: event
      });
    }
  }, {
    key: "onKeyUp",
    value: function onKeyUp(event) {
      var target = event.target,
          value = target.value;
      var _this$props3 = this.props,
          onKeyUp = _this$props3.onKeyUp,
          validate = _this$props3.validate;
      var validationWarning = validate ? validate(value) : undefined;

      if (typeof onKeyUp !== 'function') {
        return;
      }

      onKeyUp({
        isValid: !validationWarning,
        value: value,
        event: event
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
          placeholder = _this$props4.placeholder,
          type = _this$props4.type,
          className = _this$props4.className;
      var _this$state = this.state,
          validationWarning = _this$state.validationWarning,
          value = _this$state.value;
      var parentClasses = ['dms-validated-input', className].join(' ');
      var inputClasses = [];

      if (validationWarning) {
        inputClasses.push('invalid');
      }

      return createVNode(1, "div", parentClasses, [createComponentVNode(2, Input, {
        "className": inputClasses,
        "onInput": this.onInput,
        "onKeyDown": this.onKeyDown,
        "onKeyUp": this.onKeyUp,
        "placeholder": placeholder || '',
        "type": type,
        "value": value || ''
      }), validationWarning && createVNode(1, "p", "dms-hint dms-validation-warning", validationWarning, 0)], 0);
    }
  }]);

  return ValidatedInput;
}(Component);

export { ValidatedInput as default };
//# sourceMappingURL=ValidatedInput.js.map