import { createComponentVNode, normalizeProps } from "inferno";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * A simple slot extension, built upon the components service.
 *
 * @type {Object}
 */
var ComponentWithSlots = {
  slotFill: function slotFill(slotProps, DefaultFill) {
    var type = slotProps.type,
        context = slotProps.context,
        props = _objectWithoutProperties(slotProps, ["type", "context"]);

    var Fill = this.components.getComponent(type, context) || DefaultFill;

    if (Fill) {
      return normalizeProps(createComponentVNode(2, Fill, _objectSpread({}, context, {}, props)));
    }

    return null;
  },
  slotFills: function slotFills(slotProps) {
    var type = slotProps.type,
        context = slotProps.context,
        props = _objectWithoutProperties(slotProps, ["type", "context"]);

    var fills = this.components.getComponents(type, context);
    return fills.map(function (Fill) {
      return normalizeProps(createComponentVNode(2, Fill, _objectSpread({}, context, {}, props)));
    });
  }
};
export default ComponentWithSlots;
ComponentWithSlots.$inject = ['components'];
//# sourceMappingURL=ComponentWithSlots.js.map