function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import { assign, find } from 'min-dash';
var EXPRESSION_LANGUAGE_OPTIONS = [{
  label: 'FEEL',
  value: 'feel'
}, {
  label: 'JUEL',
  value: 'juel'
}, {
  label: 'JavaScript',
  value: 'javascript'
}, {
  label: 'Groovy',
  value: 'groovy'
}, {
  label: 'Python',
  value: 'python'
}, {
  label: 'JRuby',
  value: 'jruby'
}];
/**
 * @typedef ExpressionLanguageDescriptor
 * @property {string} value - value inserted into XML
 * @property {string} label - human-readable label
 */

/**
 * Provide options and defaults of expression languages via config.
 *
 * @example
 *
 * // there will be two languages available with FEEL as default
 * const editor = new DmnJS({
 *   expressionLanguages: {
 *     options: [{
 *       value: 'feel',
 *       label: 'FEEL'
 *     }, {
 *       value: 'juel',
 *       label: 'JUEL'
 *     }],
 *     defaults: {
 *       editor: 'feel'
 *     }
 *   }
 * })
 */

var ExpressionLanguages =
/*#__PURE__*/
function () {
  function ExpressionLanguages(injector) {
    _classCallCheck(this, ExpressionLanguages);

    this._injector = injector;
    var config = injector.get('config.expressionLanguages') || {};
    this._config = {
      options: EXPRESSION_LANGUAGE_OPTIONS,
      defaults: {
        editor: 'feel'
      }
    }; // first assign the list of languages as it might be required for the legacy defaults

    if (config.options) {
      this._config.options = config.options;
    }

    var legacyDefaults = this._getLegacyDefaults();

    assign(this._config.defaults, legacyDefaults, config.defaults);
  }
  /**
   * Get default expression language for a component or the editor if `componentName`
   * is not provided.
   *
   * @param {string} [componentName]
   * @returns {ExpressionLanguageDescriptor}
   */


  _createClass(ExpressionLanguages, [{
    key: "getDefault",
    value: function getDefault(componentName) {
      var defaults = this._config.defaults;
      var defaultFromConfig = defaults[componentName] || defaults.editor;
      return this._getLanguageByValue(defaultFromConfig) || this.getAll()[0];
    }
    /**
     * Get label for provided expression language.
     *
     * @param {string} expressionLanguageValue - value from XML
     * @returns {string}
     */

  }, {
    key: "getLabel",
    value: function getLabel(expressionLanguageValue) {
      var langauge = this._getLanguageByValue(expressionLanguageValue);

      return langauge ? langauge.label : expressionLanguageValue;
    }
    /**
     * Get list of configured expression languages.
     *
     * @returns {ExpressionLanguageDescriptor[]}
     */

  }, {
    key: "getAll",
    value: function getAll() {
      return this._config.options;
    }
  }, {
    key: "_getLegacyDefaults",
    value: function _getLegacyDefaults() {
      var defaults = {},
          injector = this._injector;
      var inputCellValue = injector.get('config.defaultInputExpressionLanguage');
      var outputCellValue = injector.get('config.defaultOutputExpressionLanguage');

      if (inputCellValue) {
        defaults.inputCell = inputCellValue;
      }

      if (outputCellValue) {
        defaults.outputCell = outputCellValue;
      }

      return defaults;
    }
  }, {
    key: "_getLanguageByValue",
    value: function _getLanguageByValue(value) {
      return find(this.getAll(), function (language) {
        return value === language.value;
      });
    }
  }]);

  return ExpressionLanguages;
}();

export { ExpressionLanguages as default };
ExpressionLanguages.$inject = ['injector'];
//# sourceMappingURL=ExpressionLanguages.js.map