function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

import { forEach } from 'min-dash';
import CommandInterceptor from 'diagram-js/lib/command/CommandInterceptor';
import { is, getBusinessObject } from '../../../util/ModelUtil';
var ID = 'id';

var IdChangeBehavior =
/*#__PURE__*/
function (_CommandInterceptor) {
  _inherits(IdChangeBehavior, _CommandInterceptor);

  function IdChangeBehavior(eventBus) {
    var _this;

    _classCallCheck(this, IdChangeBehavior);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(IdChangeBehavior).call(this, eventBus));

    _this.executed('element.updateProperties', _this.updateIds.bind(_assertThisInitialized(_this)));

    return _this;
  }

  _createClass(IdChangeBehavior, [{
    key: "updateIds",
    value: function updateIds(_ref) {
      var context = _ref.context;
      var element = context.element,
          oldProperties = context.oldProperties,
          properties = context.properties;
      var bo = getBusinessObject(element);

      if (this.shouldSkipUpdate(bo, oldProperties, properties)) {
        return;
      }

      var definitions = getDefinitions(bo);
      var drgElements = definitions.get('drgElement');
      drgElements.forEach(function (drgElement) {
        updateElementReferences(drgElement, oldProperties.id, properties.id);
      });
      var artifacts = definitions.get('artifact');
      artifacts.forEach(function (artifact) {
        updateAssociationReferences(artifact, oldProperties.id, properties.id);
      });
    }
  }, {
    key: "shouldSkipUpdate",
    value: function shouldSkipUpdate(bo, oldProperties, newProperties) {
      return !isIdChange(oldProperties, newProperties) || !is(bo, 'dmn:DRGElement') && !is(bo, 'dmn:TextAnnotation');
    }
  }]);

  return IdChangeBehavior;
}(CommandInterceptor);

export { IdChangeBehavior as default };
IdChangeBehavior.$inject = ['eventBus']; // helpers //////////////////////

function isIdChange(oldProperties, properties) {
  return ID in oldProperties && ID in properties;
}
/**
 * Walk up the tree until at the root to get to dmn:Definitions.
 *
 * @param {ModdleElement} element
 */


function getDefinitions(element) {
  var definitions = element;

  while (!is(definitions, 'dmn:Definitions')) {
    definitions = definitions.$parent;
  }

  return definitions;
}

function updateElementReferences(element, oldId, id) {
  var handlers = {
    authorityRequirement: function authorityRequirement() {
      element.authorityRequirement.forEach(function (authorityRequirement) {
        var requiredAuthority = authorityRequirement.requiredAuthority,
            requiredDecision = authorityRequirement.requiredDecision,
            requiredInput = authorityRequirement.requiredInput;

        if (requiredAuthority && requiredAuthority.href === "#".concat(oldId)) {
          requiredAuthority.href = "#".concat(id);
        }

        if (requiredDecision && requiredDecision.href === "#".concat(oldId)) {
          requiredDecision.href = "#".concat(id);
        }

        if (requiredInput && requiredInput.href === "#".concat(oldId)) {
          requiredInput.href = "#".concat(id);
        }
      });
    },
    informationRequirement: function informationRequirement() {
      element.informationRequirement.forEach(function (informationRequirement) {
        var requiredDecision = informationRequirement.requiredDecision,
            requiredInput = informationRequirement.requiredInput;

        if (requiredDecision && requiredDecision.href === "#".concat(oldId)) {
          requiredDecision.href = "#".concat(id);
        }

        if (requiredInput && requiredInput.href === "#".concat(oldId)) {
          requiredInput.href = "#".concat(id);
        }
      });
    },
    knowledgeRequirement: function knowledgeRequirement() {
      element.knowledgeRequirement.forEach(function (knowledgeRequirement) {
        var requiredKnowledge = knowledgeRequirement.requiredKnowledge;

        if (requiredKnowledge && requiredKnowledge.href === "#".concat(oldId)) {
          requiredKnowledge.href = "#".concat(id);
        }
      });
    }
  };
  forEach(handlers, function (handler, key) {
    if (element[key]) {
      handler();
    }
  });
}

function updateAssociationReferences(element, oldId, id) {
  var handlers = {
    sourceRef: function sourceRef() {
      var sourceRef = element.sourceRef;

      if (sourceRef.href === "#".concat(oldId)) {
        sourceRef.href = "#".concat(id);
      }
    },
    targetRef: function targetRef() {
      var targetRef = element.targetRef;

      if (targetRef.href === "#".concat(oldId)) {
        targetRef.href = "#".concat(id);
      }
    }
  };
  forEach(handlers, function (handler, key) {
    if (element[key]) {
      handler();
    }
  });
}
//# sourceMappingURL=IdChangeBehavior.js.map