function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import { isObject, isDefined, reduce } from 'min-dash';
import { getBusinessObject } from '../../../util/ModelUtil';
var ID = 'id';
/**
 * A generic handler that implements property editing.
 */

var EditPropertiesHandler =
/*#__PURE__*/
function () {
  function EditPropertiesHandler(elementRegistry, moddle) {
    _classCallCheck(this, EditPropertiesHandler);

    this._elementRegistry = elementRegistry;
    this._moddle = moddle;
  }
  /**
   * <do>
   */


  _createClass(EditPropertiesHandler, [{
    key: "execute",
    value: function execute(context) {
      var element = context.element,
          properties = context.properties;
      var bo = getBusinessObject(element);

      var _this$updatePropertie = this.updateProperties(bo, properties),
          changed = _this$updatePropertie.changed,
          oldProperties = _this$updatePropertie.oldProperties;

      context.oldProperties = oldProperties;
      return [].concat(_toConsumableArray(changed), [element]);
    }
    /**
     * <undo>
     */

  }, {
    key: "revert",
    value: function revert(context) {
      var element = context.element,
          oldProperties = context.oldProperties;
      var bo = getBusinessObject(element);

      var _this$updatePropertie2 = this.updateProperties(bo, oldProperties),
          changed = _this$updatePropertie2.changed;

      return [].concat(_toConsumableArray(changed), [element]);
    }
    /**
     * Update properties of the given business object
     * and return { changed, oldProperties }.
     */

  }, {
    key: "updateProperties",
    value: function updateProperties(bo, newProps) {
      var _this = this;

      var ids = this._moddle.ids; // Reduce over all new properties and return
      //
      // {
      //  changed,
      //  oldProperties
      // }

      return reduce(newProps, function (result, value, key) {
        var propertyValue = bo.get(key); // handle nested update

        if (isContainer(value)) {
          if (!isContainer(propertyValue)) {
            throw new Error("non-existing property <".concat(key, ">: cannot update values"));
          }

          var _this$updatePropertie3 = _this.updateProperties(propertyValue, value),
              changed = _this$updatePropertie3.changed,
              oldProperties = _this$updatePropertie3.oldProperties;

          return {
            changed: [].concat(_toConsumableArray(result.changed), _toConsumableArray(changed), [propertyValue]),
            oldProperties: _objectSpread({}, result.oldProperties, _defineProperty({}, key, oldProperties))
          };
        } // handle ID change


        if (key === ID && isIdChange(bo, value)) {
          ids.unclaim(bo[ID]);

          _this._elementRegistry.updateId(bo, value);

          ids.claim(value, bo);
        } // handle plain update


        bo.set(key, value);
        return {
          changed: result.changed,
          oldProperties: _objectSpread({}, result.oldProperties, _defineProperty({}, key, propertyValue))
        };
      }, {
        changed: [],
        oldProperties: {}
      });
    }
  }]);

  return EditPropertiesHandler;
}();

export { EditPropertiesHandler as default };
EditPropertiesHandler.$inject = ['elementRegistry', 'moddle']; // helpers //////////////////////

function isIdChange(element, newId) {
  return element[ID] !== newId;
}

function isContainer(o) {
  return isDefined(o) && isObject(o);
}
//# sourceMappingURL=UpdatePropertiesHandler.js.map