import { createVNode, createComponentVNode } from "inferno";
import { Component } from 'inferno';
import Input from './Input';

/**
 * Input with optional validation.
 */
export default class ValidatedInput extends Component {
  constructor(props, context) {
    super(props, context);
    const {
      validate,
      value
    } = props;
    const validationWarning = validate ? validate(value || '') : undefined;
    this.state = {
      validationWarning,
      value
    };
    this.onInput = this.onInput.bind(this);
    this.onKeyDown = this.onKeyDown.bind(this);
    this.onKeyUp = this.onKeyUp.bind(this);
  }
  componentWillReceiveProps(props) {
    const {
      validate,
      value
    } = props;
    const validationWarning = validate ? validate(value || '') : undefined;
    this.setState({
      validationWarning,
      value
    });
  }
  onInput(value) {
    const {
      onInput,
      validate
    } = this.props;
    const validationWarning = validate ? validate(value) : undefined;
    this.setState({
      validationWarning,
      value
    });
    if (typeof onInput !== 'function') {
      return;
    }
    onInput && onInput({
      isValid: !validationWarning,
      value
    });
  }
  onKeyDown(event) {
    const {
        target
      } = event,
      {
        value
      } = target;
    const {
      onKeyDown,
      validate
    } = this.props;
    const validationWarning = validate ? validate(value) : undefined;
    if (typeof onKeyDown !== 'function') {
      return;
    }
    onKeyDown({
      isValid: !validationWarning,
      value,
      event
    });
  }
  onKeyUp(event) {
    const {
        target
      } = event,
      {
        value
      } = target;
    const {
      onKeyUp,
      validate
    } = this.props;
    const validationWarning = validate ? validate(value) : undefined;
    if (typeof onKeyUp !== 'function') {
      return;
    }
    onKeyUp({
      isValid: !validationWarning,
      value,
      event
    });
  }
  render() {
    const {
      placeholder,
      type,
      className,
      label
    } = this.props;
    const {
      validationWarning,
      value
    } = this.state;
    const parentClasses = ['dms-validated-input', className].join(' ');
    const inputClasses = [];
    if (validationWarning) {
      inputClasses.push('invalid');
    }
    return createVNode(1, "div", parentClasses, [createComponentVNode(2, Input, {
      "className": inputClasses,
      "label": label,
      "onInput": this.onInput,
      "onKeyDown": this.onKeyDown,
      "onKeyUp": this.onKeyUp,
      "placeholder": placeholder || '',
      "type": type,
      "value": value || ''
    }), validationWarning && createVNode(1, "p", "dms-hint dms-validation-warning", validationWarning, 0)], 0);
  }
}
//# sourceMappingURL=ValidatedInput.js.map