/*!
 * dmn-js - dmn-modeler v10.0.0
 *
 * Copyright (c) 2014-present, camunda Services GmbH
 *
 * Released under the bpmn.io license
 * http://bpmn.io/license
 *
 * Source Code: https://github.com/bpmn-io/dmn-js
 *
 * Date: 2020-12-18
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
  typeof define === 'function' && define.amd ? define(factory) :
  (global = global || self, global.DmnJS = factory());
}(this, (function () { 'use strict';

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function (obj) {
        return typeof obj;
      };
    } else {
      _typeof = function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (typeof call === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized(self);
  }

  /**
   * Flatten array, one level deep.
   *
   * @param {Array<?>} arr
   *
   * @return {Array<?>}
   */
  function flatten(arr) {
    return Array.prototype.concat.apply([], arr);
  }

  var nativeToString = Object.prototype.toString;
  var nativeHasOwnProperty = Object.prototype.hasOwnProperty;

  function isUndefined(obj) {
    return obj === undefined;
  }

  function isDefined(obj) {
    return obj !== undefined;
  }

  function isNil(obj) {
    return obj == null;
  }

  function isArray(obj) {
    return nativeToString.call(obj) === '[object Array]';
  }

  function isObject(obj) {
    return nativeToString.call(obj) === '[object Object]';
  }

  function isNumber(obj) {
    return nativeToString.call(obj) === '[object Number]';
  }

  function isFunction(obj) {
    var tag = nativeToString.call(obj);
    return tag === '[object Function]' || tag === '[object AsyncFunction]' || tag === '[object GeneratorFunction]' || tag === '[object AsyncGeneratorFunction]' || tag === '[object Proxy]';
  }

  function isString(obj) {
    return nativeToString.call(obj) === '[object String]';
  }
  /**
   * Return true, if target owns a property with the given key.
   *
   * @param {Object} target
   * @param {String} key
   *
   * @return {Boolean}
   */


  function has(target, key) {
    return nativeHasOwnProperty.call(target, key);
  }
  /**
   * Find element in collection.
   *
   * @param  {Array|Object} collection
   * @param  {Function|Object} matcher
   *
   * @return {Object}
   */


  function find(collection, matcher) {
    matcher = toMatcher(matcher);
    var match;
    forEach(collection, function (val, key) {
      if (matcher(val, key)) {
        match = val;
        return false;
      }
    });
    return match;
  }
  /**
   * Find element in collection.
   *
   * @param  {Array|Object} collection
   * @param  {Function} matcher
   *
   * @return {Array} result
   */


  function filter(collection, matcher) {
    var result = [];
    forEach(collection, function (val, key) {
      if (matcher(val, key)) {
        result.push(val);
      }
    });
    return result;
  }
  /**
   * Iterate over collection; returning something
   * (non-undefined) will stop iteration.
   *
   * @param  {Array|Object} collection
   * @param  {Function} iterator
   *
   * @return {Object} return result that stopped the iteration
   */


  function forEach(collection, iterator) {
    var val, result;

    if (isUndefined(collection)) {
      return;
    }

    var convertKey = isArray(collection) ? toNum : identity;

    for (var key in collection) {
      if (has(collection, key)) {
        val = collection[key];
        result = iterator(val, convertKey(key));

        if (result === false) {
          return val;
        }
      }
    }
  }
  /**
   * Reduce collection, returning a single result.
   *
   * @param  {Object|Array} collection
   * @param  {Function} iterator
   * @param  {Any} result
   *
   * @return {Any} result returned from last iterator
   */


  function reduce(collection, iterator, result) {
    forEach(collection, function (value, idx) {
      result = iterator(result, value, idx);
    });
    return result;
  }
  /**
   * Return true if every element in the collection
   * matches the criteria.
   *
   * @param  {Object|Array} collection
   * @param  {Function} matcher
   *
   * @return {Boolean}
   */


  function every(collection, matcher) {
    return !!reduce(collection, function (matches, val, key) {
      return matches && matcher(val, key);
    }, true);
  }
  /**
   * Return true if some elements in the collection
   * match the criteria.
   *
   * @param  {Object|Array} collection
   * @param  {Function} matcher
   *
   * @return {Boolean}
   */


  function some(collection, matcher) {
    return !!find(collection, matcher);
  }
  /**
   * Transform a collection into another collection
   * by piping each member through the given fn.
   *
   * @param  {Object|Array}   collection
   * @param  {Function} fn
   *
   * @return {Array} transformed collection
   */


  function map(collection, fn) {
    var result = [];
    forEach(collection, function (val, key) {
      result.push(fn(val, key));
    });
    return result;
  }
  /**
   * Get the collections keys.
   *
   * @param  {Object|Array} collection
   *
   * @return {Array}
   */


  function keys(collection) {
    return collection && Object.keys(collection) || [];
  }
  /**
   * Shorthand for `keys(o).length`.
   *
   * @param  {Object|Array} collection
   *
   * @return {Number}
   */


  function size(collection) {
    return keys(collection).length;
  }
  /**
   * Get the values in the collection.
   *
   * @param  {Object|Array} collection
   *
   * @return {Array}
   */


  function values(collection) {
    return map(collection, function (val) {
      return val;
    });
  }
  /**
   * Group collection members by attribute.
   *
   * @param  {Object|Array} collection
   * @param  {Function} extractor
   *
   * @return {Object} map with { attrValue => [ a, b, c ] }
   */


  function groupBy(collection, extractor) {
    var grouped = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    extractor = toExtractor(extractor);
    forEach(collection, function (val) {
      var discriminator = extractor(val) || '_';
      var group = grouped[discriminator];

      if (!group) {
        group = grouped[discriminator] = [];
      }

      group.push(val);
    });
    return grouped;
  }

  function uniqueBy(extractor) {
    extractor = toExtractor(extractor);
    var grouped = {};

    for (var _len = arguments.length, collections = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      collections[_key - 1] = arguments[_key];
    }

    forEach(collections, function (c) {
      return groupBy(c, extractor, grouped);
    });
    var result = map(grouped, function (val, key) {
      return val[0];
    });
    return result;
  }
  /**
   * Sort collection by criteria.
   *
   * @param  {Object|Array} collection
   * @param  {String|Function} extractor
   *
   * @return {Array}
   */

  function sortBy(collection, extractor) {
    extractor = toExtractor(extractor);
    var sorted = [];
    forEach(collection, function (value, key) {
      var disc = extractor(value, key);
      var entry = {
        d: disc,
        v: value
      };

      for (var idx = 0; idx < sorted.length; idx++) {
        var d = sorted[idx].d;

        if (disc < d) {
          sorted.splice(idx, 0, entry);
          return;
        }
      } // not inserted, append (!)


      sorted.push(entry);
    });
    return map(sorted, function (e) {
      return e.v;
    });
  }
  /**
   * Create an object pattern matcher.
   *
   * @example
   *
   * const matcher = matchPattern({ id: 1 });
   *
   * var element = find(elements, matcher);
   *
   * @param  {Object} pattern
   *
   * @return {Function} matcherFn
   */


  function matchPattern(pattern) {
    return function (el) {
      return every(pattern, function (val, key) {
        return el[key] === val;
      });
    };
  }

  function toExtractor(extractor) {
    return isFunction(extractor) ? extractor : function (e) {
      return e[extractor];
    };
  }

  function toMatcher(matcher) {
    return isFunction(matcher) ? matcher : function (e) {
      return e === matcher;
    };
  }

  function identity(arg) {
    return arg;
  }

  function toNum(arg) {
    return Number(arg);
  }
  /**
   * Debounce fn, calling it only once if
   * the given time elapsed between calls.
   *
   * @param  {Function} fn
   * @param  {Number} timeout
   *
   * @return {Function} debounced function
   */


  function debounce(fn, timeout) {
    var timer;
    var lastArgs;
    var lastThis;
    var lastNow;

    function fire() {
      var now = Date.now();
      var scheduledDiff = lastNow + timeout - now;

      if (scheduledDiff > 0) {
        return schedule(scheduledDiff);
      }

      fn.apply(lastThis, lastArgs);
      timer = lastNow = lastArgs = lastThis = undefined;
    }

    function schedule(timeout) {
      timer = setTimeout(fire, timeout);
    }

    return function () {
      lastNow = Date.now();

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      lastArgs = args;
      lastThis = this; // ensure an execution is scheduled

      if (!timer) {
        schedule(timeout);
      }
    };
  }
  /**
   * Bind function against target <this>.
   *
   * @param  {Function} fn
   * @param  {Object}   target
   *
   * @return {Function} bound function
   */


  function bind(fn, target) {
    return fn.bind(target);
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }
  /**
   * Convenience wrapper for `Object.assign`.
   *
   * @param {Object} target
   * @param {...Object} others
   *
   * @return {Object} the target
   */


  function assign(target) {
    for (var _len = arguments.length, others = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      others[_key - 1] = arguments[_key];
    }

    return _extends.apply(void 0, [target].concat(others));
  }
  /**
   * Pick given properties from the target object.
   *
   * @param {Object} target
   * @param {Array} properties
   *
   * @return {Object} target
   */


  function pick(target, properties) {
    var result = {};
    var obj = Object(target);
    forEach(properties, function (prop) {
      if (prop in obj) {
        result[prop] = target[prop];
      }
    });
    return result;
  }
  /**
   * Pick all target properties, excluding the given ones.
   *
   * @param {Object} target
   * @param {Array} properties
   *
   * @return {Object} target
   */


  function omit(target, properties) {
    var result = {};
    var obj = Object(target);
    forEach(obj, function (prop, key) {
      if (properties.indexOf(key) === -1) {
        result[key] = prop;
      }
    });
    return result;
  }

  var FN_REF = '__fn';
  var DEFAULT_PRIORITY = 1000;
  var slice = Array.prototype.slice;
  /**
   * A general purpose event bus.
   *
   * This component is used to communicate across a diagram instance.
   * Other parts of a diagram can use it to listen to and broadcast events.
   *
   *
   * ## Registering for Events
   *
   * The event bus provides the {@link EventBus#on} and {@link EventBus#once}
   * methods to register for events. {@link EventBus#off} can be used to
   * remove event registrations. Listeners receive an instance of {@link Event}
   * as the first argument. It allows them to hook into the event execution.
   *
   * ```javascript
   *
   * // listen for event
   * eventBus.on('foo', function(event) {
   *
   *   // access event type
   *   event.type; // 'foo'
   *
   *   // stop propagation to other listeners
   *   event.stopPropagation();
   *
   *   // prevent event default
   *   event.preventDefault();
   * });
   *
   * // listen for event with custom payload
   * eventBus.on('bar', function(event, payload) {
   *   console.log(payload);
   * });
   *
   * // listen for event returning value
   * eventBus.on('foobar', function(event) {
   *
   *   // stop event propagation + prevent default
   *   return false;
   *
   *   // stop event propagation + return custom result
   *   return {
   *     complex: 'listening result'
   *   };
   * });
   *
   *
   * // listen with custom priority (default=1000, higher is better)
   * eventBus.on('priorityfoo', 1500, function(event) {
   *   console.log('invoked first!');
   * });
   *
   *
   * // listen for event and pass the context (`this`)
   * eventBus.on('foobar', function(event) {
   *   this.foo();
   * }, this);
   * ```
   *
   *
   * ## Emitting Events
   *
   * Events can be emitted via the event bus using {@link EventBus#fire}.
   *
   * ```javascript
   *
   * // false indicates that the default action
   * // was prevented by listeners
   * if (eventBus.fire('foo') === false) {
   *   console.log('default has been prevented!');
   * };
   *
   *
   * // custom args + return value listener
   * eventBus.on('sum', function(event, a, b) {
   *   return a + b;
   * });
   *
   * // you can pass custom arguments + retrieve result values.
   * var sum = eventBus.fire('sum', 1, 2);
   * console.log(sum); // 3
   * ```
   */

  function EventBus() {
    this._listeners = {}; // cleanup on destroy on lowest priority to allow
    // message passing until the bitter end

    this.on('diagram.destroy', 1, this._destroy, this);
  }
  /**
   * Register an event listener for events with the given name.
   *
   * The callback will be invoked with `event, ...additionalArguments`
   * that have been passed to {@link EventBus#fire}.
   *
   * Returning false from a listener will prevent the events default action
   * (if any is specified). To stop an event from being processed further in
   * other listeners execute {@link Event#stopPropagation}.
   *
   * Returning anything but `undefined` from a listener will stop the listener propagation.
   *
   * @param {string|Array<string>} events
   * @param {number} [priority=1000] the priority in which this listener is called, larger is higher
   * @param {Function} callback
   * @param {Object} [that] Pass context (`this`) to the callback
   */

  EventBus.prototype.on = function (events, priority, callback, that) {
    events = isArray(events) ? events : [events];

    if (isFunction(priority)) {
      that = callback;
      callback = priority;
      priority = DEFAULT_PRIORITY;
    }

    if (!isNumber(priority)) {
      throw new Error('priority must be a number');
    }

    var actualCallback = callback;

    if (that) {
      actualCallback = bind(callback, that); // make sure we remember and are able to remove
      // bound callbacks via {@link #off} using the original
      // callback

      actualCallback[FN_REF] = callback[FN_REF] || callback;
    }

    var self = this;
    events.forEach(function (e) {
      self._addListener(e, {
        priority: priority,
        callback: actualCallback,
        next: null
      });
    });
  };
  /**
   * Register an event listener that is executed only once.
   *
   * @param {string} event the event name to register for
   * @param {number} [priority=1000] the priority in which this listener is called, larger is higher
   * @param {Function} callback the callback to execute
   * @param {Object} [that] Pass context (`this`) to the callback
   */


  EventBus.prototype.once = function (event, priority, callback, that) {
    var self = this;

    if (isFunction(priority)) {
      that = callback;
      callback = priority;
      priority = DEFAULT_PRIORITY;
    }

    if (!isNumber(priority)) {
      throw new Error('priority must be a number');
    }

    function wrappedCallback() {
      var result = callback.apply(that, arguments);
      self.off(event, wrappedCallback);
      return result;
    } // make sure we remember and are able to remove
    // bound callbacks via {@link #off} using the original
    // callback


    wrappedCallback[FN_REF] = callback;
    this.on(event, priority, wrappedCallback);
  };
  /**
   * Removes event listeners by event and callback.
   *
   * If no callback is given, all listeners for a given event name are being removed.
   *
   * @param {string|Array<string>} events
   * @param {Function} [callback]
   */


  EventBus.prototype.off = function (events, callback) {
    events = isArray(events) ? events : [events];
    var self = this;
    events.forEach(function (event) {
      self._removeListener(event, callback);
    });
  };
  /**
   * Create an EventBus event.
   *
   * @param {Object} data
   *
   * @return {Object} event, recognized by the eventBus
   */


  EventBus.prototype.createEvent = function (data) {
    var event = new InternalEvent();
    event.init(data);
    return event;
  };
  /**
   * Fires a named event.
   *
   * @example
   *
   * // fire event by name
   * events.fire('foo');
   *
   * // fire event object with nested type
   * var event = { type: 'foo' };
   * events.fire(event);
   *
   * // fire event with explicit type
   * var event = { x: 10, y: 20 };
   * events.fire('element.moved', event);
   *
   * // pass additional arguments to the event
   * events.on('foo', function(event, bar) {
   *   alert(bar);
   * });
   *
   * events.fire({ type: 'foo' }, 'I am bar!');
   *
   * @param {string} [name] the optional event name
   * @param {Object} [event] the event object
   * @param {...Object} additional arguments to be passed to the callback functions
   *
   * @return {boolean} the events return value, if specified or false if the
   *                   default action was prevented by listeners
   */


  EventBus.prototype.fire = function (type, data) {
    var event, firstListener, returnValue, args;
    args = slice.call(arguments);

    if (_typeof(type) === 'object') {
      data = type;
      type = data.type;
    }

    if (!type) {
      throw new Error('no event type specified');
    }

    firstListener = this._listeners[type];

    if (!firstListener) {
      return;
    } // we make sure we fire instances of our home made
    // events here. We wrap them only once, though


    if (data instanceof InternalEvent) {
      // we are fine, we alread have an event
      event = data;
    } else {
      event = this.createEvent(data);
    } // ensure we pass the event as the first parameter


    args[0] = event; // original event type (in case we delegate)

    var originalType = event.type; // update event type before delegation

    if (type !== originalType) {
      event.type = type;
    }

    try {
      returnValue = this._invokeListeners(event, args, firstListener);
    } finally {
      // reset event type after delegation
      if (type !== originalType) {
        event.type = originalType;
      }
    } // set the return value to false if the event default
    // got prevented and no other return value exists


    if (returnValue === undefined && event.defaultPrevented) {
      returnValue = false;
    }

    return returnValue;
  };

  EventBus.prototype.handleError = function (error) {
    return this.fire('error', {
      error: error
    }) === false;
  };

  EventBus.prototype._destroy = function () {
    this._listeners = {};
  };

  EventBus.prototype._invokeListeners = function (event, args, listener) {
    var returnValue;

    while (listener) {
      // handle stopped propagation
      if (event.cancelBubble) {
        break;
      }

      returnValue = this._invokeListener(event, args, listener);
      listener = listener.next;
    }

    return returnValue;
  };

  EventBus.prototype._invokeListener = function (event, args, listener) {
    var returnValue;

    try {
      // returning false prevents the default action
      returnValue = invokeFunction(listener.callback, args); // stop propagation on return value

      if (returnValue !== undefined) {
        event.returnValue = returnValue;
        event.stopPropagation();
      } // prevent default on return false


      if (returnValue === false) {
        event.preventDefault();
      }
    } catch (e) {
      if (!this.handleError(e)) {
        console.error('unhandled error in event listener');
        console.error(e.stack);
        throw e;
      }
    }

    return returnValue;
  };
  /*
   * Add new listener with a certain priority to the list
   * of listeners (for the given event).
   *
   * The semantics of listener registration / listener execution are
   * first register, first serve: New listeners will always be inserted
   * after existing listeners with the same priority.
   *
   * Example: Inserting two listeners with priority 1000 and 1300
   *
   *    * before: [ 1500, 1500, 1000, 1000 ]
   *    * after: [ 1500, 1500, (new=1300), 1000, 1000, (new=1000) ]
   *
   * @param {string} event
   * @param {Object} listener { priority, callback }
   */


  EventBus.prototype._addListener = function (event, newListener) {
    var listener = this._getListeners(event),
        previousListener; // no prior listeners


    if (!listener) {
      this._setListeners(event, newListener);

      return;
    } // ensure we order listeners by priority from
    // 0 (high) to n > 0 (low)


    while (listener) {
      if (listener.priority < newListener.priority) {
        newListener.next = listener;

        if (previousListener) {
          previousListener.next = newListener;
        } else {
          this._setListeners(event, newListener);
        }

        return;
      }

      previousListener = listener;
      listener = listener.next;
    } // add new listener to back


    previousListener.next = newListener;
  };

  EventBus.prototype._getListeners = function (name) {
    return this._listeners[name];
  };

  EventBus.prototype._setListeners = function (name, listener) {
    this._listeners[name] = listener;
  };

  EventBus.prototype._removeListener = function (event, callback) {
    var listener = this._getListeners(event),
        nextListener,
        previousListener,
        listenerCallback;

    if (!callback) {
      // clear listeners
      this._setListeners(event, null);

      return;
    }

    while (listener) {
      nextListener = listener.next;
      listenerCallback = listener.callback;

      if (listenerCallback === callback || listenerCallback[FN_REF] === callback) {
        if (previousListener) {
          previousListener.next = nextListener;
        } else {
          // new first listener
          this._setListeners(event, nextListener);
        }
      }

      previousListener = listener;
      listener = nextListener;
    }
  };
  /**
   * A event that is emitted via the event bus.
   */


  function InternalEvent() {}

  InternalEvent.prototype.stopPropagation = function () {
    this.cancelBubble = true;
  };

  InternalEvent.prototype.preventDefault = function () {
    this.defaultPrevented = true;
  };

  InternalEvent.prototype.init = function (data) {
    assign(this, data || {});
  };
  /**
   * Invoke function. Be fast...
   *
   * @param {Function} fn
   * @param {Array<Object>} args
   *
   * @return {Any}
   */


  function invokeFunction(fn, args) {
    return fn.apply(null, args);
  }

  /**
   * Moddle base element.
   */

  function Base() {}

  Base.prototype.get = function (name) {
    return this.$model.properties.get(this, name);
  };

  Base.prototype.set = function (name, value) {
    this.$model.properties.set(this, name, value);
  };
  /**
   * A model element factory.
   *
   * @param {Moddle} model
   * @param {Properties} properties
   */


  function Factory(model, properties) {
    this.model = model;
    this.properties = properties;
  }

  Factory.prototype.createType = function (descriptor) {
    var model = this.model;
    var props = this.properties,
        prototype = Object.create(Base.prototype); // initialize default values

    forEach(descriptor.properties, function (p) {
      if (!p.isMany && p["default"] !== undefined) {
        prototype[p.name] = p["default"];
      }
    });
    props.defineModel(prototype, model);
    props.defineDescriptor(prototype, descriptor);
    var name = descriptor.ns.name;
    /**
     * The new type constructor
     */

    function ModdleElement(attrs) {
      props.define(this, '$type', {
        value: name,
        enumerable: true
      });
      props.define(this, '$attrs', {
        value: {}
      });
      props.define(this, '$parent', {
        writable: true
      });
      forEach(attrs, bind(function (val, key) {
        this.set(key, val);
      }, this));
    }

    ModdleElement.prototype = prototype;
    ModdleElement.hasType = prototype.$instanceOf = this.model.hasType; // static links

    props.defineModel(ModdleElement, model);
    props.defineDescriptor(ModdleElement, descriptor);
    return ModdleElement;
  };
  /**
   * Built-in moddle types
   */


  var BUILTINS = {
    String: true,
    Boolean: true,
    Integer: true,
    Real: true,
    Element: true
  };
  /**
   * Converters for built in types from string representations
   */

  var TYPE_CONVERTERS = {
    String: function String(s) {
      return s;
    },
    Boolean: function Boolean(s) {
      return s === 'true';
    },
    Integer: function Integer(s) {
      return parseInt(s, 10);
    },
    Real: function Real(s) {
      return parseFloat(s, 10);
    }
  };
  /**
   * Convert a type to its real representation
   */

  function coerceType(type, value) {
    var converter = TYPE_CONVERTERS[type];

    if (converter) {
      return converter(value);
    } else {
      return value;
    }
  }
  /**
   * Return whether the given type is built-in
   */


  function isBuiltIn(type) {
    return !!BUILTINS[type];
  }
  /**
   * Return whether the given type is simple
   */


  function isSimple(type) {
    return !!TYPE_CONVERTERS[type];
  }
  /**
   * Parses a namespaced attribute name of the form (ns:)localName to an object,
   * given a default prefix to assume in case no explicit namespace is given.
   *
   * @param {String} name
   * @param {String} [defaultPrefix] the default prefix to take, if none is present.
   *
   * @return {Object} the parsed name
   */


  function parseName(name, defaultPrefix) {
    var parts = name.split(/:/),
        localName,
        prefix; // no prefix (i.e. only local name)

    if (parts.length === 1) {
      localName = name;
      prefix = defaultPrefix;
    } else // prefix + local name
      if (parts.length === 2) {
        localName = parts[1];
        prefix = parts[0];
      } else {
        throw new Error('expected <prefix:localName> or <localName>, got ' + name);
      }

    name = (prefix ? prefix + ':' : '') + localName;
    return {
      name: name,
      prefix: prefix,
      localName: localName
    };
  }
  /**
   * A utility to build element descriptors.
   */


  function DescriptorBuilder(nameNs) {
    this.ns = nameNs;
    this.name = nameNs.name;
    this.allTypes = [];
    this.allTypesByName = {};
    this.properties = [];
    this.propertiesByName = {};
  }

  DescriptorBuilder.prototype.build = function () {
    return pick(this, ['ns', 'name', 'allTypes', 'allTypesByName', 'properties', 'propertiesByName', 'bodyProperty', 'idProperty']);
  };
  /**
   * Add property at given index.
   *
   * @param {Object} p
   * @param {Number} [idx]
   * @param {Boolean} [validate=true]
   */


  DescriptorBuilder.prototype.addProperty = function (p, idx, validate) {
    if (typeof idx === 'boolean') {
      validate = idx;
      idx = undefined;
    }

    this.addNamedProperty(p, validate !== false);
    var properties = this.properties;

    if (idx !== undefined) {
      properties.splice(idx, 0, p);
    } else {
      properties.push(p);
    }
  };

  DescriptorBuilder.prototype.replaceProperty = function (oldProperty, newProperty, replace) {
    var oldNameNs = oldProperty.ns;
    var props = this.properties,
        propertiesByName = this.propertiesByName,
        rename = oldProperty.name !== newProperty.name;

    if (oldProperty.isId) {
      if (!newProperty.isId) {
        throw new Error('property <' + newProperty.ns.name + '> must be id property ' + 'to refine <' + oldProperty.ns.name + '>');
      }

      this.setIdProperty(newProperty, false);
    }

    if (oldProperty.isBody) {
      if (!newProperty.isBody) {
        throw new Error('property <' + newProperty.ns.name + '> must be body property ' + 'to refine <' + oldProperty.ns.name + '>');
      } // TODO: Check compatibility


      this.setBodyProperty(newProperty, false);
    } // validate existence and get location of old property


    var idx = props.indexOf(oldProperty);

    if (idx === -1) {
      throw new Error('property <' + oldNameNs.name + '> not found in property list');
    } // remove old property


    props.splice(idx, 1); // replacing the named property is intentional
    //
    //  * validate only if this is a "rename" operation
    //  * add at specific index unless we "replace"
    //

    this.addProperty(newProperty, replace ? undefined : idx, rename); // make new property available under old name

    propertiesByName[oldNameNs.name] = propertiesByName[oldNameNs.localName] = newProperty;
  };

  DescriptorBuilder.prototype.redefineProperty = function (p, targetPropertyName, replace) {
    var nsPrefix = p.ns.prefix;
    var parts = targetPropertyName.split('#');
    var name = parseName(parts[0], nsPrefix);
    var attrName = parseName(parts[1], name.prefix).name;
    var redefinedProperty = this.propertiesByName[attrName];

    if (!redefinedProperty) {
      throw new Error('refined property <' + attrName + '> not found');
    } else {
      this.replaceProperty(redefinedProperty, p, replace);
    }

    delete p.redefines;
  };

  DescriptorBuilder.prototype.addNamedProperty = function (p, validate) {
    var ns = p.ns,
        propsByName = this.propertiesByName;

    if (validate) {
      this.assertNotDefined(p, ns.name);
      this.assertNotDefined(p, ns.localName);
    }

    propsByName[ns.name] = propsByName[ns.localName] = p;
  };

  DescriptorBuilder.prototype.removeNamedProperty = function (p) {
    var ns = p.ns,
        propsByName = this.propertiesByName;
    delete propsByName[ns.name];
    delete propsByName[ns.localName];
  };

  DescriptorBuilder.prototype.setBodyProperty = function (p, validate) {
    if (validate && this.bodyProperty) {
      throw new Error('body property defined multiple times ' + '(<' + this.bodyProperty.ns.name + '>, <' + p.ns.name + '>)');
    }

    this.bodyProperty = p;
  };

  DescriptorBuilder.prototype.setIdProperty = function (p, validate) {
    if (validate && this.idProperty) {
      throw new Error('id property defined multiple times ' + '(<' + this.idProperty.ns.name + '>, <' + p.ns.name + '>)');
    }

    this.idProperty = p;
  };

  DescriptorBuilder.prototype.assertNotDefined = function (p, name) {
    var propertyName = p.name,
        definedProperty = this.propertiesByName[propertyName];

    if (definedProperty) {
      throw new Error('property <' + propertyName + '> already defined; ' + 'override of <' + definedProperty.definedBy.ns.name + '#' + definedProperty.ns.name + '> by ' + '<' + p.definedBy.ns.name + '#' + p.ns.name + '> not allowed without redefines');
    }
  };

  DescriptorBuilder.prototype.hasProperty = function (name) {
    return this.propertiesByName[name];
  };

  DescriptorBuilder.prototype.addTrait = function (t, inherited) {
    var typesByName = this.allTypesByName,
        types = this.allTypes;
    var typeName = t.name;

    if (typeName in typesByName) {
      return;
    }

    forEach(t.properties, bind(function (p) {
      // clone property to allow extensions
      p = assign({}, p, {
        name: p.ns.localName,
        inherited: inherited
      });
      Object.defineProperty(p, 'definedBy', {
        value: t
      });
      var replaces = p.replaces,
          redefines = p.redefines; // add replace/redefine support

      if (replaces || redefines) {
        this.redefineProperty(p, replaces || redefines, replaces);
      } else {
        if (p.isBody) {
          this.setBodyProperty(p);
        }

        if (p.isId) {
          this.setIdProperty(p);
        }

        this.addProperty(p);
      }
    }, this));
    types.push(t);
    typesByName[typeName] = t;
  };
  /**
   * A registry of Moddle packages.
   *
   * @param {Array<Package>} packages
   * @param {Properties} properties
   */


  function Registry(packages, properties) {
    this.packageMap = {};
    this.typeMap = {};
    this.packages = [];
    this.properties = properties;
    forEach(packages, bind(this.registerPackage, this));
  }

  Registry.prototype.getPackage = function (uriOrPrefix) {
    return this.packageMap[uriOrPrefix];
  };

  Registry.prototype.getPackages = function () {
    return this.packages;
  };

  Registry.prototype.registerPackage = function (pkg) {
    // copy package
    pkg = assign({}, pkg);
    var pkgMap = this.packageMap;
    ensureAvailable(pkgMap, pkg, 'prefix');
    ensureAvailable(pkgMap, pkg, 'uri'); // register types

    forEach(pkg.types, bind(function (descriptor) {
      this.registerType(descriptor, pkg);
    }, this));
    pkgMap[pkg.uri] = pkgMap[pkg.prefix] = pkg;
    this.packages.push(pkg);
  };
  /**
   * Register a type from a specific package with us
   */


  Registry.prototype.registerType = function (type, pkg) {
    type = assign({}, type, {
      superClass: (type.superClass || []).slice(),
      "extends": (type["extends"] || []).slice(),
      properties: (type.properties || []).slice(),
      meta: assign(type.meta || {})
    });
    var ns = parseName(type.name, pkg.prefix),
        name = ns.name,
        propertiesByName = {}; // parse properties

    forEach(type.properties, bind(function (p) {
      // namespace property names
      var propertyNs = parseName(p.name, ns.prefix),
          propertyName = propertyNs.name; // namespace property types

      if (!isBuiltIn(p.type)) {
        p.type = parseName(p.type, propertyNs.prefix).name;
      }

      assign(p, {
        ns: propertyNs,
        name: propertyName
      });
      propertiesByName[propertyName] = p;
    }, this)); // update ns + name

    assign(type, {
      ns: ns,
      name: name,
      propertiesByName: propertiesByName
    });
    forEach(type["extends"], bind(function (extendsName) {
      var extended = this.typeMap[extendsName];
      extended.traits = extended.traits || [];
      extended.traits.push(name);
    }, this)); // link to package

    this.definePackage(type, pkg); // register

    this.typeMap[name] = type;
  };
  /**
   * Traverse the type hierarchy from bottom to top,
   * calling iterator with (type, inherited) for all elements in
   * the inheritance chain.
   *
   * @param {Object} nsName
   * @param {Function} iterator
   * @param {Boolean} [trait=false]
   */


  Registry.prototype.mapTypes = function (nsName, iterator, trait) {
    var type = isBuiltIn(nsName.name) ? {
      name: nsName.name
    } : this.typeMap[nsName.name];
    var self = this;
    /**
     * Traverse the selected trait.
     *
     * @param {String} cls
     */

    function traverseTrait(cls) {
      return traverseSuper(cls, true);
    }
    /**
     * Traverse the selected super type or trait
     *
     * @param {String} cls
     * @param {Boolean} [trait=false]
     */


    function traverseSuper(cls, trait) {
      var parentNs = parseName(cls, isBuiltIn(cls) ? '' : nsName.prefix);
      self.mapTypes(parentNs, iterator, trait);
    }

    if (!type) {
      throw new Error('unknown type <' + nsName.name + '>');
    }

    forEach(type.superClass, trait ? traverseTrait : traverseSuper); // call iterator with (type, inherited=!trait)

    iterator(type, !trait);
    forEach(type.traits, traverseTrait);
  };
  /**
   * Returns the effective descriptor for a type.
   *
   * @param  {String} type the namespaced name (ns:localName) of the type
   *
   * @return {Descriptor} the resulting effective descriptor
   */


  Registry.prototype.getEffectiveDescriptor = function (name) {
    var nsName = parseName(name);
    var builder = new DescriptorBuilder(nsName);
    this.mapTypes(nsName, function (type, inherited) {
      builder.addTrait(type, inherited);
    });
    var descriptor = builder.build(); // define package link

    this.definePackage(descriptor, descriptor.allTypes[descriptor.allTypes.length - 1].$pkg);
    return descriptor;
  };

  Registry.prototype.definePackage = function (target, pkg) {
    this.properties.define(target, '$pkg', {
      value: pkg
    });
  }; ///////// helpers ////////////////////////////


  function ensureAvailable(packageMap, pkg, identifierKey) {
    var value = pkg[identifierKey];

    if (value in packageMap) {
      throw new Error('package with ' + identifierKey + ' <' + value + '> already defined');
    }
  }
  /**
   * A utility that gets and sets properties of model elements.
   *
   * @param {Model} model
   */


  function Properties(model) {
    this.model = model;
  }
  /**
   * Sets a named property on the target element.
   * If the value is undefined, the property gets deleted.
   *
   * @param {Object} target
   * @param {String} name
   * @param {Object} value
   */


  Properties.prototype.set = function (target, name, value) {
    var property = this.model.getPropertyDescriptor(target, name);
    var propertyName = property && property.name;

    if (isUndefined$1(value)) {
      // unset the property, if the specified value is undefined;
      // delete from $attrs (for extensions) or the target itself
      if (property) {
        delete target[propertyName];
      } else {
        delete target.$attrs[name];
      }
    } else {
      // set the property, defining well defined properties on the fly
      // or simply updating them in target.$attrs (for extensions)
      if (property) {
        if (propertyName in target) {
          target[propertyName] = value;
        } else {
          defineProperty(target, property, value);
        }
      } else {
        target.$attrs[name] = value;
      }
    }
  };
  /**
   * Returns the named property of the given element
   *
   * @param  {Object} target
   * @param  {String} name
   *
   * @return {Object}
   */


  Properties.prototype.get = function (target, name) {
    var property = this.model.getPropertyDescriptor(target, name);

    if (!property) {
      return target.$attrs[name];
    }

    var propertyName = property.name; // check if access to collection property and lazily initialize it

    if (!target[propertyName] && property.isMany) {
      defineProperty(target, property, []);
    }

    return target[propertyName];
  };
  /**
   * Define a property on the target element
   *
   * @param  {Object} target
   * @param  {String} name
   * @param  {Object} options
   */


  Properties.prototype.define = function (target, name, options) {
    Object.defineProperty(target, name, options);
  };
  /**
   * Define the descriptor for an element
   */


  Properties.prototype.defineDescriptor = function (target, descriptor) {
    this.define(target, '$descriptor', {
      value: descriptor
    });
  };
  /**
   * Define the model for an element
   */


  Properties.prototype.defineModel = function (target, model) {
    this.define(target, '$model', {
      value: model
    });
  };

  function isUndefined$1(val) {
    return typeof val === 'undefined';
  }

  function defineProperty(target, property, value) {
    Object.defineProperty(target, property.name, {
      enumerable: !property.isReference,
      writable: true,
      value: value,
      configurable: true
    });
  } //// Moddle implementation /////////////////////////////////////////////////

  /**
   * @class Moddle
   *
   * A model that can be used to create elements of a specific type.
   *
   * @example
   *
   * var Moddle = require('moddle');
   *
   * var pkg = {
   *   name: 'mypackage',
   *   prefix: 'my',
   *   types: [
   *     { name: 'Root' }
   *   ]
   * };
   *
   * var moddle = new Moddle([pkg]);
   *
   * @param {Array<Package>} packages the packages to contain
   */


  function Moddle(packages) {
    this.properties = new Properties(this);
    this.factory = new Factory(this, this.properties);
    this.registry = new Registry(packages, this.properties);
    this.typeCache = {};
  }
  /**
   * Create an instance of the specified type.
   *
   * @method Moddle#create
   *
   * @example
   *
   * var foo = moddle.create('my:Foo');
   * var bar = moddle.create('my:Bar', { id: 'BAR_1' });
   *
   * @param  {String|Object} descriptor the type descriptor or name know to the model
   * @param  {Object} attrs   a number of attributes to initialize the model instance with
   * @return {Object}         model instance
   */


  Moddle.prototype.create = function (descriptor, attrs) {
    var Type = this.getType(descriptor);

    if (!Type) {
      throw new Error('unknown type <' + descriptor + '>');
    }

    return new Type(attrs);
  };
  /**
   * Returns the type representing a given descriptor
   *
   * @method Moddle#getType
   *
   * @example
   *
   * var Foo = moddle.getType('my:Foo');
   * var foo = new Foo({ 'id' : 'FOO_1' });
   *
   * @param  {String|Object} descriptor the type descriptor or name know to the model
   * @return {Object}         the type representing the descriptor
   */


  Moddle.prototype.getType = function (descriptor) {
    var cache = this.typeCache;
    var name = isString(descriptor) ? descriptor : descriptor.ns.name;
    var type = cache[name];

    if (!type) {
      descriptor = this.registry.getEffectiveDescriptor(name);
      type = cache[name] = this.factory.createType(descriptor);
    }

    return type;
  };
  /**
   * Creates an any-element type to be used within model instances.
   *
   * This can be used to create custom elements that lie outside the meta-model.
   * The created element contains all the meta-data required to serialize it
   * as part of meta-model elements.
   *
   * @method Moddle#createAny
   *
   * @example
   *
   * var foo = moddle.createAny('vendor:Foo', 'http://vendor', {
   *   value: 'bar'
   * });
   *
   * var container = moddle.create('my:Container', 'http://my', {
   *   any: [ foo ]
   * });
   *
   * // go ahead and serialize the stuff
   *
   *
   * @param  {String} name  the name of the element
   * @param  {String} nsUri the namespace uri of the element
   * @param  {Object} [properties] a map of properties to initialize the instance with
   * @return {Object} the any type instance
   */


  Moddle.prototype.createAny = function (name, nsUri, properties) {
    var nameNs = parseName(name);
    var element = {
      $type: name,
      $instanceOf: function $instanceOf(type) {
        return type === this.$type;
      }
    };
    var descriptor = {
      name: name,
      isGeneric: true,
      ns: {
        prefix: nameNs.prefix,
        localName: nameNs.localName,
        uri: nsUri
      }
    };
    this.properties.defineDescriptor(element, descriptor);
    this.properties.defineModel(element, this);
    this.properties.define(element, '$parent', {
      enumerable: false,
      writable: true
    });
    forEach(properties, function (a, key) {
      if (isObject(a) && a.value !== undefined) {
        element[a.name] = a.value;
      } else {
        element[key] = a;
      }
    });
    return element;
  };
  /**
   * Returns a registered package by uri or prefix
   *
   * @return {Object} the package
   */


  Moddle.prototype.getPackage = function (uriOrPrefix) {
    return this.registry.getPackage(uriOrPrefix);
  };
  /**
   * Returns a snapshot of all known packages
   *
   * @return {Object} the package
   */


  Moddle.prototype.getPackages = function () {
    return this.registry.getPackages();
  };
  /**
   * Returns the descriptor for an element
   */


  Moddle.prototype.getElementDescriptor = function (element) {
    return element.$descriptor;
  };
  /**
   * Returns true if the given descriptor or instance
   * represents the given type.
   *
   * May be applied to this, if element is omitted.
   */


  Moddle.prototype.hasType = function (element, type) {
    if (type === undefined) {
      type = element;
      element = this;
    }

    var descriptor = element.$model.getElementDescriptor(element);
    return type in descriptor.allTypesByName;
  };
  /**
   * Returns the descriptor of an elements named property
   */


  Moddle.prototype.getPropertyDescriptor = function (element, property) {
    return this.getElementDescriptor(element).propertiesByName[property];
  };
  /**
   * Returns a mapped type's descriptor
   */


  Moddle.prototype.getTypeDescriptor = function (type) {
    return this.registry.typeMap[type];
  };

  var fromCharCode = String.fromCharCode;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var ENTITY_PATTERN = /&#(\d+);|&#x([0-9a-f]+);|&(\w+);/ig;
  var ENTITY_MAPPING = {
    'amp': '&',
    'apos': '\'',
    'gt': '>',
    'lt': '<',
    'quot': '"'
  }; // map UPPERCASE variants of supported special chars

  Object.keys(ENTITY_MAPPING).forEach(function (k) {
    ENTITY_MAPPING[k.toUpperCase()] = ENTITY_MAPPING[k];
  });

  function replaceEntities(_, d, x, z) {
    // reserved names, i.e. &nbsp;
    if (z) {
      if (hasOwnProperty.call(ENTITY_MAPPING, z)) {
        return ENTITY_MAPPING[z];
      } else {
        // fall back to original value
        return '&' + z + ';';
      }
    } // decimal encoded char


    if (d) {
      return fromCharCode(d);
    } // hex encoded char


    return fromCharCode(parseInt(x, 16));
  }
  /**
   * A basic entity decoder that can decode a minimal
   * sub-set of reserved names (&amp;) as well as
   * hex (&#xaaf;) and decimal (&#1231;) encoded characters.
   *
   * @param {string} str
   *
   * @return {string} decoded string
   */


  function decodeEntities(s) {
    if (s.length > 3 && s.indexOf('&') !== -1) {
      return s.replace(ENTITY_PATTERN, replaceEntities);
    }

    return s;
  }

  var XSI_URI = 'http://www.w3.org/2001/XMLSchema-instance';
  var XSI_PREFIX = 'xsi';
  var XSI_TYPE = 'xsi:type';
  var NON_WHITESPACE_OUTSIDE_ROOT_NODE = 'non-whitespace outside of root node';

  function error(msg) {
    return new Error(msg);
  }

  function missingNamespaceForPrefix(prefix) {
    return 'missing namespace for prefix <' + prefix + '>';
  }

  function getter(getFn) {
    return {
      'get': getFn,
      'enumerable': true
    };
  }

  function cloneNsMatrix(nsMatrix) {
    var clone = {},
        key;

    for (key in nsMatrix) {
      clone[key] = nsMatrix[key];
    }

    return clone;
  }

  function uriPrefix(prefix) {
    return prefix + '$uri';
  }

  function buildNsMatrix(nsUriToPrefix) {
    var nsMatrix = {},
        uri,
        prefix;

    for (uri in nsUriToPrefix) {
      prefix = nsUriToPrefix[uri];
      nsMatrix[prefix] = prefix;
      nsMatrix[uriPrefix(prefix)] = uri;
    }

    return nsMatrix;
  }

  function noopGetContext() {
    return {
      'line': 0,
      'column': 0
    };
  }

  function throwFunc(err) {
    throw err;
  }
  /**
   * Creates a new parser with the given options.
   *
   * @constructor
   *
   * @param  {!Object<string, ?>=} options
   */


  function Parser(options) {
    if (!this) {
      return new Parser(options);
    }

    var proxy = options && options['proxy'];
    var onText,
        onOpenTag,
        onCloseTag,
        onCDATA,
        onError = throwFunc,
        onWarning,
        onComment,
        onQuestion,
        onAttention;
    var getContext = noopGetContext;
    /**
     * Do we need to parse the current elements attributes for namespaces?
     *
     * @type {boolean}
     */

    var maybeNS = false;
    /**
     * Do we process namespaces at all?
     *
     * @type {boolean}
     */

    var isNamespace = false;
    /**
     * The caught error returned on parse end
     *
     * @type {Error}
     */

    var returnError = null;
    /**
     * Should we stop parsing?
     *
     * @type {boolean}
     */

    var parseStop = false;
    /**
     * A map of { uri: prefix } used by the parser.
     *
     * This map will ensure we can normalize prefixes during processing;
     * for each uri, only one prefix will be exposed to the handlers.
     *
     * @type {!Object<string, string>}}
     */

    var nsUriToPrefix;
    /**
     * Handle parse error.
     *
     * @param  {string|Error} err
     */

    function handleError(err) {
      if (!(err instanceof Error)) {
        err = error(err);
      }

      returnError = err;
      onError(err, getContext);
    }
    /**
     * Handle parse error.
     *
     * @param  {string|Error} err
     */


    function handleWarning(err) {
      if (!onWarning) {
        return;
      }

      if (!(err instanceof Error)) {
        err = error(err);
      }

      onWarning(err, getContext);
    }
    /**
     * Register parse listener.
     *
     * @param  {string}   name
     * @param  {Function} cb
     *
     * @return {Parser}
     */


    this['on'] = function (name, cb) {
      if (typeof cb !== 'function') {
        throw error('required args <name, cb>');
      }

      switch (name) {
        case 'openTag':
          onOpenTag = cb;
          break;

        case 'text':
          onText = cb;
          break;

        case 'closeTag':
          onCloseTag = cb;
          break;

        case 'error':
          onError = cb;
          break;

        case 'warn':
          onWarning = cb;
          break;

        case 'cdata':
          onCDATA = cb;
          break;

        case 'attention':
          onAttention = cb;
          break;
        // <!XXXXX zzzz="eeee">

        case 'question':
          onQuestion = cb;
          break;
        // <? ....  ?>

        case 'comment':
          onComment = cb;
          break;

        default:
          throw error('unsupported event: ' + name);
      }

      return this;
    };
    /**
     * Set the namespace to prefix mapping.
     *
     * @example
     *
     * parser.ns({
     *   'http://foo': 'foo',
     *   'http://bar': 'bar'
     * });
     *
     * @param  {!Object<string, string>} nsMap
     *
     * @return {Parser}
     */


    this['ns'] = function (nsMap) {
      if (typeof nsMap === 'undefined') {
        nsMap = {};
      }

      if (_typeof(nsMap) !== 'object') {
        throw error('required args <nsMap={}>');
      }

      var _nsUriToPrefix = {},
          k;

      for (k in nsMap) {
        _nsUriToPrefix[k] = nsMap[k];
      } // FORCE default mapping for schema instance


      _nsUriToPrefix[XSI_URI] = XSI_PREFIX;
      isNamespace = true;
      nsUriToPrefix = _nsUriToPrefix;
      return this;
    };
    /**
     * Parse xml string.
     *
     * @param  {string} xml
     *
     * @return {Error} returnError, if not thrown
     */


    this['parse'] = function (xml) {
      if (typeof xml !== 'string') {
        throw error('required args <xml=string>');
      }

      returnError = null;
      parse(xml);
      getContext = noopGetContext;
      parseStop = false;
      return returnError;
    };
    /**
     * Stop parsing.
     */


    this['stop'] = function () {
      parseStop = true;
    };
    /**
     * Parse string, invoking configured listeners on element.
     *
     * @param  {string} xml
     */


    function parse(xml) {
      var nsMatrixStack = isNamespace ? [] : null,
          nsMatrix = isNamespace ? buildNsMatrix(nsUriToPrefix) : null,
          _nsMatrix,
          nodeStack = [],
          anonymousNsCount = 0,
          tagStart = false,
          tagEnd = false,
          i = 0,
          j = 0,
          x,
          y,
          q,
          w,
          v,
          xmlns,
          elementName,
          _elementName,
          elementProxy;

      var attrsString = '',
          attrsStart = 0,
          cachedAttrs // false = parsed with errors, null = needs parsing
      ;
      /**
       * Parse attributes on demand and returns the parsed attributes.
       *
       * Return semantics: (1) `false` on attribute parse error,
       * (2) object hash on extracted attrs.
       *
       * @return {boolean|Object}
       */

      function getAttrs() {
        if (cachedAttrs !== null) {
          return cachedAttrs;
        }

        var nsUri,
            nsUriPrefix,
            nsName,
            defaultAlias = isNamespace && nsMatrix['xmlns'],
            attrList = isNamespace && maybeNS ? [] : null,
            i = attrsStart,
            s = attrsString,
            l = s.length,
            hasNewMatrix,
            newalias,
            value,
            alias,
            name,
            attrs = {},
            seenAttrs = {},
            skipAttr,
            w,
            j;

        parseAttr: for (; i < l; i++) {
          skipAttr = false;
          w = s.charCodeAt(i);

          if (w === 32 || w < 14 && w > 8) {
            // WHITESPACE={ \f\n\r\t\v}
            continue;
          } // wait for non whitespace character


          if (w < 65 || w > 122 || w > 90 && w < 97) {
            if (w !== 95 && w !== 58) {
              // char 95"_" 58":"
              handleWarning('illegal first char attribute name');
              skipAttr = true;
            }
          } // parse attribute name


          for (j = i + 1; j < l; j++) {
            w = s.charCodeAt(j);

            if (w > 96 && w < 123 || w > 64 && w < 91 || w > 47 && w < 59 || w === 46 || // '.'
            w === 45 || // '-'
            w === 95 // '_'
            ) {
                continue;
              } // unexpected whitespace


            if (w === 32 || w < 14 && w > 8) {
              // WHITESPACE
              handleWarning('missing attribute value');
              i = j;
              continue parseAttr;
            } // expected "="


            if (w === 61) {
              // "=" == 61
              break;
            }

            handleWarning('illegal attribute name char');
            skipAttr = true;
          }

          name = s.substring(i, j);

          if (name === 'xmlns:xmlns') {
            handleWarning('illegal declaration of xmlns');
            skipAttr = true;
          }

          w = s.charCodeAt(j + 1);

          if (w === 34) {
            // '"'
            j = s.indexOf('"', i = j + 2);

            if (j === -1) {
              j = s.indexOf('\'', i);

              if (j !== -1) {
                handleWarning('attribute value quote missmatch');
                skipAttr = true;
              }
            }
          } else if (w === 39) {
            // "'"
            j = s.indexOf('\'', i = j + 2);

            if (j === -1) {
              j = s.indexOf('"', i);

              if (j !== -1) {
                handleWarning('attribute value quote missmatch');
                skipAttr = true;
              }
            }
          } else {
            handleWarning('missing attribute value quotes');
            skipAttr = true; // skip to next space

            for (j = j + 1; j < l; j++) {
              w = s.charCodeAt(j + 1);

              if (w === 32 || w < 14 && w > 8) {
                // WHITESPACE
                break;
              }
            }
          }

          if (j === -1) {
            handleWarning('missing closing quotes');
            j = l;
            skipAttr = true;
          }

          if (!skipAttr) {
            value = s.substring(i, j);
          }

          i = j; // ensure SPACE follows attribute
          // skip illegal content otherwise
          // example a="b"c

          for (; j + 1 < l; j++) {
            w = s.charCodeAt(j + 1);

            if (w === 32 || w < 14 && w > 8) {
              // WHITESPACE
              break;
            } // FIRST ILLEGAL CHAR


            if (i === j) {
              handleWarning('illegal character after attribute end');
              skipAttr = true;
            }
          } // advance cursor to next attribute


          i = j + 1;

          if (skipAttr) {
            continue parseAttr;
          } // check attribute re-declaration


          if (name in seenAttrs) {
            handleWarning('attribute <' + name + '> already defined');
            continue;
          }

          seenAttrs[name] = true;

          if (!isNamespace) {
            attrs[name] = value;
            continue;
          } // try to extract namespace information


          if (maybeNS) {
            newalias = name === 'xmlns' ? 'xmlns' : name.charCodeAt(0) === 120 && name.substr(0, 6) === 'xmlns:' ? name.substr(6) : null; // handle xmlns(:alias) assignment

            if (newalias !== null) {
              nsUri = decodeEntities(value);
              nsUriPrefix = uriPrefix(newalias);
              alias = nsUriToPrefix[nsUri];

              if (!alias) {
                // no prefix defined or prefix collision
                if (newalias === 'xmlns' || nsUriPrefix in nsMatrix && nsMatrix[nsUriPrefix] !== nsUri) {
                  // alocate free ns prefix
                  do {
                    alias = 'ns' + anonymousNsCount++;
                  } while (typeof nsMatrix[alias] !== 'undefined');
                } else {
                  alias = newalias;
                }

                nsUriToPrefix[nsUri] = alias;
              }

              if (nsMatrix[newalias] !== alias) {
                if (!hasNewMatrix) {
                  nsMatrix = cloneNsMatrix(nsMatrix);
                  hasNewMatrix = true;
                }

                nsMatrix[newalias] = alias;

                if (newalias === 'xmlns') {
                  nsMatrix[uriPrefix(alias)] = nsUri;
                  defaultAlias = alias;
                }

                nsMatrix[nsUriPrefix] = nsUri;
              } // expose xmlns(:asd)="..." in attributes


              attrs[name] = value;
              continue;
            } // collect attributes until all namespace
            // declarations are processed


            attrList.push(name, value);
            continue;
          }
          /** end if (maybeNs) */
          // handle attributes on element without
          // namespace declarations


          w = name.indexOf(':');

          if (w === -1) {
            attrs[name] = value;
            continue;
          } // normalize ns attribute name


          if (!(nsName = nsMatrix[name.substring(0, w)])) {
            handleWarning(missingNamespaceForPrefix(name.substring(0, w)));
            continue;
          }

          name = defaultAlias === nsName ? name.substr(w + 1) : nsName + name.substr(w); // end: normalize ns attribute name
          // normalize xsi:type ns attribute value

          if (name === XSI_TYPE) {
            w = value.indexOf(':');

            if (w !== -1) {
              nsName = value.substring(0, w); // handle default prefixes, i.e. xs:String gracefully

              nsName = nsMatrix[nsName] || nsName;
              value = nsName + value.substring(w);
            } else {
              value = defaultAlias + ':' + value;
            }
          } // end: normalize xsi:type ns attribute value


          attrs[name] = value;
        } // handle deferred, possibly namespaced attributes


        if (maybeNS) {
          // normalize captured attributes
          for (i = 0, l = attrList.length; i < l; i++) {
            name = attrList[i++];
            value = attrList[i];
            w = name.indexOf(':');

            if (w !== -1) {
              // normalize ns attribute name
              if (!(nsName = nsMatrix[name.substring(0, w)])) {
                handleWarning(missingNamespaceForPrefix(name.substring(0, w)));
                continue;
              }

              name = defaultAlias === nsName ? name.substr(w + 1) : nsName + name.substr(w); // end: normalize ns attribute name
              // normalize xsi:type ns attribute value

              if (name === XSI_TYPE) {
                w = value.indexOf(':');

                if (w !== -1) {
                  nsName = value.substring(0, w); // handle default prefixes, i.e. xs:String gracefully

                  nsName = nsMatrix[nsName] || nsName;
                  value = nsName + value.substring(w);
                } else {
                  value = defaultAlias + ':' + value;
                }
              } // end: normalize xsi:type ns attribute value

            }

            attrs[name] = value;
          } // end: normalize captured attributes

        }

        return cachedAttrs = attrs;
      }
      /**
       * Extract the parse context { line, column, part }
       * from the current parser position.
       *
       * @return {Object} parse context
       */


      function getParseContext() {
        var splitsRe = /(\r\n|\r|\n)/g;
        var line = 0;
        var column = 0;
        var startOfLine = 0;
        var endOfLine = j;
        var match;
        var data;

        while (i >= startOfLine) {
          match = splitsRe.exec(xml);

          if (!match) {
            break;
          } // end of line = (break idx + break chars)


          endOfLine = match[0].length + match.index;

          if (endOfLine > i) {
            break;
          } // advance to next line


          line += 1;
          startOfLine = endOfLine;
        } // EOF errors


        if (i == -1) {
          column = endOfLine;
          data = xml.substring(j);
        } else // start errors
          if (j === 0) {
            data = xml.substring(j, i);
          } // other errors
          else {
              column = i - startOfLine;
              data = j == -1 ? xml.substring(i) : xml.substring(i, j + 1);
            }

        return {
          'data': data,
          'line': line,
          'column': column
        };
      }

      getContext = getParseContext;

      if (proxy) {
        elementProxy = Object.create({}, {
          'name': getter(function () {
            return elementName;
          }),
          'originalName': getter(function () {
            return _elementName;
          }),
          'attrs': getter(getAttrs),
          'ns': getter(function () {
            return nsMatrix;
          })
        });
      } // actual parse logic


      while (j !== -1) {
        if (xml.charCodeAt(j) === 60) {
          // "<"
          i = j;
        } else {
          i = xml.indexOf('<', j);
        } // parse end


        if (i === -1) {
          if (nodeStack.length) {
            return handleError('unexpected end of file');
          }

          if (j === 0) {
            return handleError('missing start tag');
          }

          if (j < xml.length) {
            if (xml.substring(j).trim()) {
              handleWarning(NON_WHITESPACE_OUTSIDE_ROOT_NODE);
            }
          }

          return;
        } // parse text


        if (j !== i) {
          if (nodeStack.length) {
            if (onText) {
              onText(xml.substring(j, i), decodeEntities, getContext);

              if (parseStop) {
                return;
              }
            }
          } else {
            if (xml.substring(j, i).trim()) {
              handleWarning(NON_WHITESPACE_OUTSIDE_ROOT_NODE);

              if (parseStop) {
                return;
              }
            }
          }
        }

        w = xml.charCodeAt(i + 1); // parse comments + CDATA

        if (w === 33) {
          // "!"
          q = xml.charCodeAt(i + 2); // CDATA section

          if (q === 91 && xml.substr(i + 3, 6) === 'CDATA[') {
            // 91 == "["
            j = xml.indexOf(']]>', i);

            if (j === -1) {
              return handleError('unclosed cdata');
            }

            if (onCDATA) {
              onCDATA(xml.substring(i + 9, j), getContext);

              if (parseStop) {
                return;
              }
            }

            j += 3;
            continue;
          } // comment


          if (q === 45 && xml.charCodeAt(i + 3) === 45) {
            // 45 == "-"
            j = xml.indexOf('-->', i);

            if (j === -1) {
              return handleError('unclosed comment');
            }

            if (onComment) {
              onComment(xml.substring(i + 4, j), decodeEntities, getContext);

              if (parseStop) {
                return;
              }
            }

            j += 3;
            continue;
          }
        } // parse question <? ... ?>


        if (w === 63) {
          // "?"
          j = xml.indexOf('?>', i);

          if (j === -1) {
            return handleError('unclosed question');
          }

          if (onQuestion) {
            onQuestion(xml.substring(i, j + 2), getContext);

            if (parseStop) {
              return;
            }
          }

          j += 2;
          continue;
        } // find matching closing tag for attention or standard tags
        // for that we must skip through attribute values
        // (enclosed in single or double quotes)


        for (x = i + 1;; x++) {
          v = xml.charCodeAt(x);

          if (isNaN(v)) {
            j = -1;
            return handleError('unclosed tag');
          } // [10] AttValue ::= '"' ([^<&"] | Reference)* '"' | "'" ([^<&'] | Reference)* "'"
          // skips the quoted string
          // (double quotes) does not appear in a literal enclosed by (double quotes)
          // (single quote) does not appear in a literal enclosed by (single quote)


          if (v === 34) {
            //  '"'
            q = xml.indexOf('"', x + 1);
            x = q !== -1 ? q : x;
          } else if (v === 39) {
            // "'"
            q = xml.indexOf("'", x + 1);
            x = q !== -1 ? q : x;
          } else if (v === 62) {
            // '>'
            j = x;
            break;
          }
        } // parse attention <! ...>
        // previously comment and CDATA have already been parsed


        if (w === 33) {
          // "!"
          if (onAttention) {
            onAttention(xml.substring(i, j + 1), decodeEntities, getContext);

            if (parseStop) {
              return;
            }
          }

          j += 1;
          continue;
        } // don't process attributes;
        // there are none


        cachedAttrs = {}; // if (xml.charCodeAt(i+1) === 47) { // </...

        if (w === 47) {
          // </...
          tagStart = false;
          tagEnd = true;

          if (!nodeStack.length) {
            return handleError('missing open tag');
          } // verify open <-> close tag match


          x = elementName = nodeStack.pop();
          q = i + 2 + x.length;

          if (xml.substring(i + 2, q) !== x) {
            return handleError('closing tag mismatch');
          } // verify chars in close tag


          for (; q < j; q++) {
            w = xml.charCodeAt(q);

            if (w === 32 || w > 8 && w < 14) {
              // \f\n\r\t\v space
              continue;
            }

            return handleError('close tag');
          }
        } else {
          if (xml.charCodeAt(j - 1) === 47) {
            // .../>
            x = elementName = xml.substring(i + 1, j - 1);
            tagStart = true;
            tagEnd = true;
          } else {
            x = elementName = xml.substring(i + 1, j);
            tagStart = true;
            tagEnd = false;
          }

          if (!(w > 96 && w < 123 || w > 64 && w < 91 || w === 95 || w === 58)) {
            // char 95"_" 58":"
            return handleError('illegal first char nodeName');
          }

          for (q = 1, y = x.length; q < y; q++) {
            w = x.charCodeAt(q);

            if (w > 96 && w < 123 || w > 64 && w < 91 || w > 47 && w < 59 || w === 45 || w === 95 || w == 46) {
              continue;
            }

            if (w === 32 || w < 14 && w > 8) {
              // \f\n\r\t\v space
              elementName = x.substring(0, q); // maybe there are attributes

              cachedAttrs = null;
              break;
            }

            return handleError('invalid nodeName');
          }

          if (!tagEnd) {
            nodeStack.push(elementName);
          }
        }

        if (isNamespace) {
          _nsMatrix = nsMatrix;

          if (tagStart) {
            // remember old namespace
            // unless we're self-closing
            if (!tagEnd) {
              nsMatrixStack.push(_nsMatrix);
            }

            if (cachedAttrs === null) {
              // quick check, whether there may be namespace
              // declarations on the node; if that is the case
              // we need to eagerly parse the node attributes
              if (maybeNS = x.indexOf('xmlns', q) !== -1) {
                attrsStart = q;
                attrsString = x;
                getAttrs();
                maybeNS = false;
              }
            }
          }

          _elementName = elementName;
          w = elementName.indexOf(':');

          if (w !== -1) {
            xmlns = nsMatrix[elementName.substring(0, w)]; // prefix given; namespace must exist

            if (!xmlns) {
              return handleError('missing namespace on <' + _elementName + '>');
            }

            elementName = elementName.substr(w + 1);
          } else {
            xmlns = nsMatrix['xmlns']; // if no default namespace is defined,
            // we'll import the element as anonymous.
            //
            // it is up to users to correct that to the document defined
            // targetNamespace, or whatever their undersanding of the
            // XML spec mandates.
          } // adjust namespace prefixs as configured


          if (xmlns) {
            elementName = xmlns + ':' + elementName;
          }
        }

        if (tagStart) {
          attrsStart = q;
          attrsString = x;

          if (onOpenTag) {
            if (proxy) {
              onOpenTag(elementProxy, decodeEntities, tagEnd, getContext);
            } else {
              onOpenTag(elementName, getAttrs, decodeEntities, tagEnd, getContext);
            }

            if (parseStop) {
              return;
            }
          }
        }

        if (tagEnd) {
          if (onCloseTag) {
            onCloseTag(proxy ? elementProxy : elementName, decodeEntities, tagStart, getContext);

            if (parseStop) {
              return;
            }
          } // restore old namespace


          if (isNamespace) {
            if (!tagStart) {
              nsMatrix = nsMatrixStack.pop();
            } else {
              nsMatrix = _nsMatrix;
            }
          }
        }

        j += 1;
      }
    }
    /** end parse */

  }

  function hasLowerCaseAlias(pkg) {
    return pkg.xml && pkg.xml.tagAlias === 'lowerCase';
  }

  var DEFAULT_NS_MAP = {
    'xsi': 'http://www.w3.org/2001/XMLSchema-instance',
    'xml': 'http://www.w3.org/XML/1998/namespace'
  };
  var XSI_TYPE$1 = 'xsi:type';

  function serializeFormat(element) {
    return element.xml && element.xml.serialize;
  }

  function serializeAsType(element) {
    return serializeFormat(element) === XSI_TYPE$1;
  }

  function serializeAsProperty(element) {
    return serializeFormat(element) === 'property';
  }

  function capitalize(str) {
    return str.charAt(0).toUpperCase() + str.slice(1);
  }

  function aliasToName(aliasNs, pkg) {
    if (!hasLowerCaseAlias(pkg)) {
      return aliasNs.name;
    }

    return aliasNs.prefix + ':' + capitalize(aliasNs.localName);
  }

  function prefixedToName(nameNs, pkg) {
    var name = nameNs.name,
        localName = nameNs.localName;
    var typePrefix = pkg.xml && pkg.xml.typePrefix;

    if (typePrefix && localName.indexOf(typePrefix) === 0) {
      return nameNs.prefix + ':' + localName.slice(typePrefix.length);
    } else {
      return name;
    }
  }

  function normalizeXsiTypeName(name, model) {
    var nameNs = parseName(name);
    var pkg = model.getPackage(nameNs.prefix);
    return prefixedToName(nameNs, pkg);
  }

  function error$1(message) {
    return new Error(message);
  }
  /**
   * Get the moddle descriptor for a given instance or type.
   *
   * @param  {ModdleElement|Function} element
   *
   * @return {Object} the moddle descriptor
   */


  function getModdleDescriptor(element) {
    return element.$descriptor;
  }

  function defer(fn) {
    setTimeout(fn, 0);
  }
  /**
   * A parse context.
   *
   * @class
   *
   * @param {Object} options
   * @param {ElementHandler} options.rootHandler the root handler for parsing a document
   * @param {boolean} [options.lax=false] whether or not to ignore invalid elements
   */


  function Context(options) {
    /**
     * @property {ElementHandler} rootHandler
     */

    /**
     * @property {Boolean} lax
     */
    assign(this, options);
    this.elementsById = {};
    this.references = [];
    this.warnings = [];
    /**
     * Add an unresolved reference.
     *
     * @param {Object} reference
     */

    this.addReference = function (reference) {
      this.references.push(reference);
    };
    /**
     * Add a processed element.
     *
     * @param {ModdleElement} element
     */


    this.addElement = function (element) {
      if (!element) {
        throw error$1('expected element');
      }

      var elementsById = this.elementsById;
      var descriptor = getModdleDescriptor(element);
      var idProperty = descriptor.idProperty,
          id;

      if (idProperty) {
        id = element.get(idProperty.name);

        if (id) {
          // for QName validation as per http://www.w3.org/TR/REC-xml/#NT-NameChar
          if (!/^([a-z][\w-.]*:)?[a-z_][\w-.]*$/i.test(id)) {
            throw new Error('illegal ID <' + id + '>');
          }

          if (elementsById[id]) {
            throw error$1('duplicate ID <' + id + '>');
          }

          elementsById[id] = element;
        }
      }
    };
    /**
     * Add an import warning.
     *
     * @param {Object} warning
     * @param {String} warning.message
     * @param {Error} [warning.error]
     */


    this.addWarning = function (warning) {
      this.warnings.push(warning);
    };
  }

  function BaseHandler() {}

  BaseHandler.prototype.handleEnd = function () {};

  BaseHandler.prototype.handleText = function () {};

  BaseHandler.prototype.handleNode = function () {};
  /**
   * A simple pass through handler that does nothing except for
   * ignoring all input it receives.
   *
   * This is used to ignore unknown elements and
   * attributes.
   */


  function NoopHandler() {}

  NoopHandler.prototype = Object.create(BaseHandler.prototype);

  NoopHandler.prototype.handleNode = function () {
    return this;
  };

  function BodyHandler() {}

  BodyHandler.prototype = Object.create(BaseHandler.prototype);

  BodyHandler.prototype.handleText = function (text) {
    this.body = (this.body || '') + text;
  };

  function ReferenceHandler(property, context) {
    this.property = property;
    this.context = context;
  }

  ReferenceHandler.prototype = Object.create(BodyHandler.prototype);

  ReferenceHandler.prototype.handleNode = function (node) {
    if (this.element) {
      throw error$1('expected no sub nodes');
    } else {
      this.element = this.createReference(node);
    }

    return this;
  };

  ReferenceHandler.prototype.handleEnd = function () {
    this.element.id = this.body;
  };

  ReferenceHandler.prototype.createReference = function (node) {
    return {
      property: this.property.ns.name,
      id: ''
    };
  };

  function ValueHandler(propertyDesc, element) {
    this.element = element;
    this.propertyDesc = propertyDesc;
  }

  ValueHandler.prototype = Object.create(BodyHandler.prototype);

  ValueHandler.prototype.handleEnd = function () {
    var value = this.body || '',
        element = this.element,
        propertyDesc = this.propertyDesc;
    value = coerceType(propertyDesc.type, value);

    if (propertyDesc.isMany) {
      element.get(propertyDesc.name).push(value);
    } else {
      element.set(propertyDesc.name, value);
    }
  };

  function BaseElementHandler() {}

  BaseElementHandler.prototype = Object.create(BodyHandler.prototype);

  BaseElementHandler.prototype.handleNode = function (node) {
    var parser = this,
        element = this.element;

    if (!element) {
      element = this.element = this.createElement(node);
      this.context.addElement(element);
    } else {
      parser = this.handleChild(node);
    }

    return parser;
  };
  /**
   * @class Reader.ElementHandler
   *
   */


  function ElementHandler(model, typeName, context) {
    this.model = model;
    this.type = model.getType(typeName);
    this.context = context;
  }

  ElementHandler.prototype = Object.create(BaseElementHandler.prototype);

  ElementHandler.prototype.addReference = function (reference) {
    this.context.addReference(reference);
  };

  ElementHandler.prototype.handleText = function (text) {
    var element = this.element,
        descriptor = getModdleDescriptor(element),
        bodyProperty = descriptor.bodyProperty;

    if (!bodyProperty) {
      throw error$1('unexpected body text <' + text + '>');
    }

    BodyHandler.prototype.handleText.call(this, text);
  };

  ElementHandler.prototype.handleEnd = function () {
    var value = this.body,
        element = this.element,
        descriptor = getModdleDescriptor(element),
        bodyProperty = descriptor.bodyProperty;

    if (bodyProperty && value !== undefined) {
      value = coerceType(bodyProperty.type, value);
      element.set(bodyProperty.name, value);
    }
  };
  /**
   * Create an instance of the model from the given node.
   *
   * @param  {Element} node the xml node
   */


  ElementHandler.prototype.createElement = function (node) {
    var attributes = node.attributes,
        Type = this.type,
        descriptor = getModdleDescriptor(Type),
        context = this.context,
        instance = new Type({}),
        model = this.model,
        propNameNs;
    forEach(attributes, function (value, name) {
      var prop = descriptor.propertiesByName[name],
          values;

      if (prop && prop.isReference) {
        if (!prop.isMany) {
          context.addReference({
            element: instance,
            property: prop.ns.name,
            id: value
          });
        } else {
          // IDREFS: parse references as whitespace-separated list
          values = value.split(' ');
          forEach(values, function (v) {
            context.addReference({
              element: instance,
              property: prop.ns.name,
              id: v
            });
          });
        }
      } else {
        if (prop) {
          value = coerceType(prop.type, value);
        } else if (name !== 'xmlns') {
          propNameNs = parseName(name, descriptor.ns.prefix); // check whether attribute is defined in a well-known namespace
          // if that is the case we emit a warning to indicate potential misuse

          if (model.getPackage(propNameNs.prefix)) {
            context.addWarning({
              message: 'unknown attribute <' + name + '>',
              element: instance,
              property: name,
              value: value
            });
          }
        }

        instance.set(name, value);
      }
    });
    return instance;
  };

  ElementHandler.prototype.getPropertyForNode = function (node) {
    var name = node.name;
    var nameNs = parseName(name);
    var type = this.type,
        model = this.model,
        descriptor = getModdleDescriptor(type);
    var propertyName = nameNs.name,
        property = descriptor.propertiesByName[propertyName],
        elementTypeName,
        elementType; // search for properties by name first

    if (property && !property.isAttr) {
      if (serializeAsType(property)) {
        elementTypeName = node.attributes[XSI_TYPE$1]; // xsi type is optional, if it does not exists the
        // default type is assumed

        if (elementTypeName) {
          // take possible type prefixes from XML
          // into account, i.e.: xsi:type="t{ActualType}"
          elementTypeName = normalizeXsiTypeName(elementTypeName, model);
          elementType = model.getType(elementTypeName);
          return assign({}, property, {
            effectiveType: getModdleDescriptor(elementType).name
          });
        }
      } // search for properties by name first


      return property;
    }

    var pkg = model.getPackage(nameNs.prefix);

    if (pkg) {
      elementTypeName = aliasToName(nameNs, pkg);
      elementType = model.getType(elementTypeName); // search for collection members later

      property = find(descriptor.properties, function (p) {
        return !p.isVirtual && !p.isReference && !p.isAttribute && elementType.hasType(p.type);
      });

      if (property) {
        return assign({}, property, {
          effectiveType: getModdleDescriptor(elementType).name
        });
      }
    } else {
      // parse unknown element (maybe extension)
      property = find(descriptor.properties, function (p) {
        return !p.isReference && !p.isAttribute && p.type === 'Element';
      });

      if (property) {
        return property;
      }
    }

    throw error$1('unrecognized element <' + nameNs.name + '>');
  };

  ElementHandler.prototype.toString = function () {
    return 'ElementDescriptor[' + getModdleDescriptor(this.type).name + ']';
  };

  ElementHandler.prototype.valueHandler = function (propertyDesc, element) {
    return new ValueHandler(propertyDesc, element);
  };

  ElementHandler.prototype.referenceHandler = function (propertyDesc) {
    return new ReferenceHandler(propertyDesc, this.context);
  };

  ElementHandler.prototype.handler = function (type) {
    if (type === 'Element') {
      return new GenericElementHandler(this.model, type, this.context);
    } else {
      return new ElementHandler(this.model, type, this.context);
    }
  };
  /**
   * Handle the child element parsing
   *
   * @param  {Element} node the xml node
   */


  ElementHandler.prototype.handleChild = function (node) {
    var propertyDesc, type, element, childHandler;
    propertyDesc = this.getPropertyForNode(node);
    element = this.element;
    type = propertyDesc.effectiveType || propertyDesc.type;

    if (isSimple(type)) {
      return this.valueHandler(propertyDesc, element);
    }

    if (propertyDesc.isReference) {
      childHandler = this.referenceHandler(propertyDesc).handleNode(node);
    } else {
      childHandler = this.handler(type).handleNode(node);
    }

    var newElement = childHandler.element; // child handles may decide to skip elements
    // by not returning anything

    if (newElement !== undefined) {
      if (propertyDesc.isMany) {
        element.get(propertyDesc.name).push(newElement);
      } else {
        element.set(propertyDesc.name, newElement);
      }

      if (propertyDesc.isReference) {
        assign(newElement, {
          element: element
        });
        this.context.addReference(newElement);
      } else {
        // establish child -> parent relationship
        newElement.$parent = element;
      }
    }

    return childHandler;
  };
  /**
   * An element handler that performs special validation
   * to ensure the node it gets initialized with matches
   * the handlers type (namespace wise).
   *
   * @param {Moddle} model
   * @param {String} typeName
   * @param {Context} context
   */


  function RootElementHandler(model, typeName, context) {
    ElementHandler.call(this, model, typeName, context);
  }

  RootElementHandler.prototype = Object.create(ElementHandler.prototype);

  RootElementHandler.prototype.createElement = function (node) {
    var name = node.name,
        nameNs = parseName(name),
        model = this.model,
        type = this.type,
        pkg = model.getPackage(nameNs.prefix),
        typeName = pkg && aliasToName(nameNs, pkg) || name; // verify the correct namespace if we parse
    // the first element in the handler tree
    //
    // this ensures we don't mistakenly import wrong namespace elements

    if (!type.hasType(typeName)) {
      throw error$1('unexpected element <' + node.originalName + '>');
    }

    return ElementHandler.prototype.createElement.call(this, node);
  };

  function GenericElementHandler(model, typeName, context) {
    this.model = model;
    this.context = context;
  }

  GenericElementHandler.prototype = Object.create(BaseElementHandler.prototype);

  GenericElementHandler.prototype.createElement = function (node) {
    var name = node.name,
        ns = parseName(name),
        prefix = ns.prefix,
        uri = node.ns[prefix + '$uri'],
        attributes = node.attributes;
    return this.model.createAny(name, uri, attributes);
  };

  GenericElementHandler.prototype.handleChild = function (node) {
    var handler = new GenericElementHandler(this.model, 'Element', this.context).handleNode(node),
        element = this.element;
    var newElement = handler.element,
        children;

    if (newElement !== undefined) {
      children = element.$children = element.$children || [];
      children.push(newElement); // establish child -> parent relationship

      newElement.$parent = element;
    }

    return handler;
  };

  GenericElementHandler.prototype.handleEnd = function () {
    if (this.body) {
      this.element.$body = this.body;
    }
  };
  /**
   * A reader for a meta-model
   *
   * @param {Object} options
   * @param {Model} options.model used to read xml files
   * @param {Boolean} options.lax whether to make parse errors warnings
   */


  function Reader(options) {
    if (options instanceof Moddle) {
      options = {
        model: options
      };
    }

    assign(this, {
      lax: false
    }, options);
  }
  /**
   * Parse the given XML into a moddle document tree.
   *
   * @param {String} xml
   * @param {ElementHandler|Object} options or rootHandler
   * @param  {Function} done
   */


  Reader.prototype.fromXML = function (xml, options, done) {
    var rootHandler = options.rootHandler;

    if (options instanceof ElementHandler) {
      // root handler passed via (xml, { rootHandler: ElementHandler }, ...)
      rootHandler = options;
      options = {};
    } else {
      if (typeof options === 'string') {
        // rootHandler passed via (xml, 'someString', ...)
        rootHandler = this.handler(options);
        options = {};
      } else if (typeof rootHandler === 'string') {
        // rootHandler passed via (xml, { rootHandler: 'someString' }, ...)
        rootHandler = this.handler(rootHandler);
      }
    }

    var model = this.model,
        lax = this.lax;
    var context = new Context(assign({}, options, {
      rootHandler: rootHandler
    })),
        parser = new Parser({
      proxy: true
    }),
        stack = createStack();
    rootHandler.context = context; // push root handler

    stack.push(rootHandler);
    /**
     * Handle error.
     *
     * @param  {Error} err
     * @param  {Function} getContext
     * @param  {boolean} lax
     *
     * @return {boolean} true if handled
     */

    function handleError(err, getContext, lax) {
      var ctx = getContext();
      var line = ctx.line,
          column = ctx.column,
          data = ctx.data; // we receive the full context data here,
      // for elements trim down the information
      // to the tag name, only

      if (data.charAt(0) === '<' && data.indexOf(' ') !== -1) {
        data = data.slice(0, data.indexOf(' ')) + '>';
      }

      var message = 'unparsable content ' + (data ? data + ' ' : '') + 'detected\n\t' + 'line: ' + line + '\n\t' + 'column: ' + column + '\n\t' + 'nested error: ' + err.message;

      if (lax) {
        context.addWarning({
          message: message,
          error: err
        });
        return true;
      } else {
        throw error$1(message);
      }
    }

    function handleWarning(err, getContext) {
      // just like handling errors in <lax=true> mode
      return handleError(err, getContext, true);
    }
    /**
     * Resolve collected references on parse end.
     */


    function resolveReferences() {
      var elementsById = context.elementsById;
      var references = context.references;
      var i, r;

      for (i = 0; r = references[i]; i++) {
        var element = r.element;
        var reference = elementsById[r.id];
        var property = getModdleDescriptor(element).propertiesByName[r.property];

        if (!reference) {
          context.addWarning({
            message: 'unresolved reference <' + r.id + '>',
            element: r.element,
            property: r.property,
            value: r.id
          });
        }

        if (property.isMany) {
          var collection = element.get(property.name),
              idx = collection.indexOf(r); // we replace an existing place holder (idx != -1) or
          // append to the collection instead

          if (idx === -1) {
            idx = collection.length;
          }

          if (!reference) {
            // remove unresolvable reference
            collection.splice(idx, 1);
          } else {
            // add or update reference in collection
            collection[idx] = reference;
          }
        } else {
          element.set(property.name, reference);
        }
      }
    }

    function handleClose() {
      stack.pop().handleEnd();
    }

    var PREAMBLE_START_PATTERN = /^<\?xml /i;
    var ENCODING_PATTERN = / encoding="([^"]+)"/i;
    var UTF_8_PATTERN = /^utf-8$/i;

    function handleQuestion(question) {
      if (!PREAMBLE_START_PATTERN.test(question)) {
        return;
      }

      var match = ENCODING_PATTERN.exec(question);
      var encoding = match && match[1];

      if (!encoding || UTF_8_PATTERN.test(encoding)) {
        return;
      }

      context.addWarning({
        message: 'unsupported document encoding <' + encoding + '>, ' + 'falling back to UTF-8'
      });
    }

    function handleOpen(node, getContext) {
      var handler = stack.peek();

      try {
        stack.push(handler.handleNode(node));
      } catch (err) {
        if (handleError(err, getContext, lax)) {
          stack.push(new NoopHandler());
        }
      }
    }

    function handleCData(text, getContext) {
      try {
        stack.peek().handleText(text);
      } catch (err) {
        handleWarning(err, getContext);
      }
    }

    function handleText(text, getContext) {
      // strip whitespace only nodes, i.e. before
      // <!CDATA[ ... ]> sections and in between tags
      text = text.trim();

      if (!text) {
        return;
      }

      handleCData(text, getContext);
    }

    var uriMap = model.getPackages().reduce(function (uriMap, p) {
      uriMap[p.uri] = p.prefix;
      return uriMap;
    }, {
      'http://www.w3.org/XML/1998/namespace': 'xml' // add default xml ns

    });
    parser.ns(uriMap).on('openTag', function (obj, decodeStr, selfClosing, getContext) {
      // gracefully handle unparsable attributes (attrs=false)
      var attrs = obj.attrs || {};
      var decodedAttrs = Object.keys(attrs).reduce(function (d, key) {
        var value = decodeStr(attrs[key]);
        d[key] = value;
        return d;
      }, {});
      var node = {
        name: obj.name,
        originalName: obj.originalName,
        attributes: decodedAttrs,
        ns: obj.ns
      };
      handleOpen(node, getContext);
    }).on('question', handleQuestion).on('closeTag', handleClose).on('cdata', handleCData).on('text', function (text, decodeEntities, getContext) {
      handleText(decodeEntities(text), getContext);
    }).on('error', handleError).on('warn', handleWarning); // deferred parse XML to make loading really ascnchronous
    // this ensures the execution environment (node or browser)
    // is kept responsive and that certain optimization strategies
    // can kick in

    defer(function () {
      var err;

      try {
        parser.parse(xml);
        resolveReferences();
      } catch (e) {
        err = e;
      }

      var element = rootHandler.element; // handle the situation that we could not extract
      // the desired root element from the document

      if (!err && !element) {
        err = error$1('failed to parse document as <' + rootHandler.type.$descriptor.name + '>');
      }

      done(err, err ? undefined : element, context);
    });
  };

  Reader.prototype.handler = function (name) {
    return new RootElementHandler(this.model, name);
  }; // helpers //////////////////////////


  function createStack() {
    var stack = [];
    Object.defineProperty(stack, 'peek', {
      value: function value() {
        return this[this.length - 1];
      }
    });
    return stack;
  }

  var XML_PREAMBLE = '<?xml version="1.0" encoding="UTF-8"?>\n';
  var ESCAPE_ATTR_CHARS = /<|>|'|"|&|\n\r|\n/g;
  var ESCAPE_CHARS = /<|>|&/g;

  function Namespaces(parent) {
    var prefixMap = {};
    var uriMap = {};
    var used = {};
    var wellknown = [];
    var custom = []; // API

    this.byUri = function (uri) {
      return uriMap[uri] || parent && parent.byUri(uri);
    };

    this.add = function (ns, isWellknown) {
      uriMap[ns.uri] = ns;

      if (isWellknown) {
        wellknown.push(ns);
      } else {
        custom.push(ns);
      }

      this.mapPrefix(ns.prefix, ns.uri);
    };

    this.uriByPrefix = function (prefix) {
      return prefixMap[prefix || 'xmlns'];
    };

    this.mapPrefix = function (prefix, uri) {
      prefixMap[prefix || 'xmlns'] = uri;
    };

    this.getNSKey = function (ns) {
      return ns.prefix !== undefined ? ns.uri + '|' + ns.prefix : ns.uri;
    };

    this.logUsed = function (ns) {
      var uri = ns.uri;
      var nsKey = this.getNSKey(ns);
      used[nsKey] = this.byUri(uri); // Inform parent recursively about the usage of this NS

      if (parent) {
        parent.logUsed(ns);
      }
    };

    this.getUsed = function (ns) {
      function isUsed(ns) {
        var nsKey = self.getNSKey(ns);
        return used[nsKey];
      }

      var self = this;
      var allNs = [].concat(wellknown, custom);
      return allNs.filter(isUsed);
    };
  }

  function lower(string) {
    return string.charAt(0).toLowerCase() + string.slice(1);
  }

  function nameToAlias(name, pkg) {
    if (hasLowerCaseAlias(pkg)) {
      return lower(name);
    } else {
      return name;
    }
  }

  function inherits(ctor, superCtor) {
    ctor.super_ = superCtor;
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  }

  function nsName(ns) {
    if (isString(ns)) {
      return ns;
    } else {
      return (ns.prefix ? ns.prefix + ':' : '') + ns.localName;
    }
  }

  function getNsAttrs(namespaces) {
    return map(namespaces.getUsed(), function (ns) {
      var name = 'xmlns' + (ns.prefix ? ':' + ns.prefix : '');
      return {
        name: name,
        value: ns.uri
      };
    });
  }

  function getElementNs(ns, descriptor) {
    if (descriptor.isGeneric) {
      return assign({
        localName: descriptor.ns.localName
      }, ns);
    } else {
      return assign({
        localName: nameToAlias(descriptor.ns.localName, descriptor.$pkg)
      }, ns);
    }
  }

  function getPropertyNs(ns, descriptor) {
    return assign({
      localName: descriptor.ns.localName
    }, ns);
  }

  function getSerializableProperties(element) {
    var descriptor = element.$descriptor;
    return filter(descriptor.properties, function (p) {
      var name = p.name;

      if (p.isVirtual) {
        return false;
      } // do not serialize defaults


      if (!element.hasOwnProperty(name)) {
        return false;
      }

      var value = element[name]; // do not serialize default equals

      if (value === p["default"]) {
        return false;
      } // do not serialize null properties


      if (value === null) {
        return false;
      }

      return p.isMany ? value.length : true;
    });
  }

  var ESCAPE_ATTR_MAP = {
    '\n': '#10',
    '\n\r': '#10',
    '"': '#34',
    '\'': '#39',
    '<': '#60',
    '>': '#62',
    '&': '#38'
  };
  var ESCAPE_MAP = {
    '<': 'lt',
    '>': 'gt',
    '&': 'amp'
  };

  function escape(str, charPattern, replaceMap) {
    // ensure we are handling strings here
    str = isString(str) ? str : '' + str;
    return str.replace(charPattern, function (s) {
      return '&' + replaceMap[s] + ';';
    });
  }
  /**
   * Escape a string attribute to not contain any bad values (line breaks, '"', ...)
   *
   * @param {String} str the string to escape
   * @return {String} the escaped string
   */


  function escapeAttr(str) {
    return escape(str, ESCAPE_ATTR_CHARS, ESCAPE_ATTR_MAP);
  }

  function escapeBody(str) {
    return escape(str, ESCAPE_CHARS, ESCAPE_MAP);
  }

  function filterAttributes(props) {
    return filter(props, function (p) {
      return p.isAttr;
    });
  }

  function filterContained(props) {
    return filter(props, function (p) {
      return !p.isAttr;
    });
  }

  function ReferenceSerializer(tagName) {
    this.tagName = tagName;
  }

  ReferenceSerializer.prototype.build = function (element) {
    this.element = element;
    return this;
  };

  ReferenceSerializer.prototype.serializeTo = function (writer) {
    writer.appendIndent().append('<' + this.tagName + '>' + this.element.id + '</' + this.tagName + '>').appendNewLine();
  };

  function BodySerializer() {}

  BodySerializer.prototype.serializeValue = BodySerializer.prototype.serializeTo = function (writer) {
    writer.append(this.escape ? escapeBody(this.value) : this.value);
  };

  BodySerializer.prototype.build = function (prop, value) {
    this.value = value;

    if (prop.type === 'String' && value.search(ESCAPE_CHARS) !== -1) {
      this.escape = true;
    }

    return this;
  };

  function ValueSerializer(tagName) {
    this.tagName = tagName;
  }

  inherits(ValueSerializer, BodySerializer);

  ValueSerializer.prototype.serializeTo = function (writer) {
    writer.appendIndent().append('<' + this.tagName + '>');
    this.serializeValue(writer);
    writer.append('</' + this.tagName + '>').appendNewLine();
  };

  function ElementSerializer(parent, propertyDescriptor) {
    this.body = [];
    this.attrs = [];
    this.parent = parent;
    this.propertyDescriptor = propertyDescriptor;
  }

  ElementSerializer.prototype.build = function (element) {
    this.element = element;
    var elementDescriptor = element.$descriptor,
        propertyDescriptor = this.propertyDescriptor;
    var otherAttrs, properties;
    var isGeneric = elementDescriptor.isGeneric;

    if (isGeneric) {
      otherAttrs = this.parseGeneric(element);
    } else {
      otherAttrs = this.parseNsAttributes(element);
    }

    if (propertyDescriptor) {
      this.ns = this.nsPropertyTagName(propertyDescriptor);
    } else {
      this.ns = this.nsTagName(elementDescriptor);
    } // compute tag name


    this.tagName = this.addTagName(this.ns);

    if (!isGeneric) {
      properties = getSerializableProperties(element);
      this.parseAttributes(filterAttributes(properties));
      this.parseContainments(filterContained(properties));
    }

    this.parseGenericAttributes(element, otherAttrs);
    return this;
  };

  ElementSerializer.prototype.nsTagName = function (descriptor) {
    var effectiveNs = this.logNamespaceUsed(descriptor.ns);
    return getElementNs(effectiveNs, descriptor);
  };

  ElementSerializer.prototype.nsPropertyTagName = function (descriptor) {
    var effectiveNs = this.logNamespaceUsed(descriptor.ns);
    return getPropertyNs(effectiveNs, descriptor);
  };

  ElementSerializer.prototype.isLocalNs = function (ns) {
    return ns.uri === this.ns.uri;
  };
  /**
   * Get the actual ns attribute name for the given element.
   *
   * @param {Object} element
   * @param {Boolean} [element.inherited=false]
   *
   * @return {Object} nsName
   */


  ElementSerializer.prototype.nsAttributeName = function (element) {
    var ns;

    if (isString(element)) {
      ns = parseName(element);
    } else {
      ns = element.ns;
    } // return just local name for inherited attributes


    if (element.inherited) {
      return {
        localName: ns.localName
      };
    } // parse + log effective ns


    var effectiveNs = this.logNamespaceUsed(ns); // LOG ACTUAL namespace use

    this.getNamespaces().logUsed(effectiveNs); // strip prefix if same namespace like parent

    if (this.isLocalNs(effectiveNs)) {
      return {
        localName: ns.localName
      };
    } else {
      return assign({
        localName: ns.localName
      }, effectiveNs);
    }
  };

  ElementSerializer.prototype.parseGeneric = function (element) {
    var self = this,
        body = this.body;
    var attributes = [];
    forEach(element, function (val, key) {
      var nonNsAttr;

      if (key === '$body') {
        body.push(new BodySerializer().build({
          type: 'String'
        }, val));
      } else if (key === '$children') {
        forEach(val, function (child) {
          body.push(new ElementSerializer(self).build(child));
        });
      } else if (key.indexOf('$') !== 0) {
        nonNsAttr = self.parseNsAttribute(element, key, val);

        if (nonNsAttr) {
          attributes.push({
            name: key,
            value: val
          });
        }
      }
    });
    return attributes;
  };

  ElementSerializer.prototype.parseNsAttribute = function (element, name, value) {
    var model = element.$model;
    var nameNs = parseName(name);
    var ns; // parse xmlns:foo="http://foo.bar"

    if (nameNs.prefix === 'xmlns') {
      ns = {
        prefix: nameNs.localName,
        uri: value
      };
    } // parse xmlns="http://foo.bar"


    if (!nameNs.prefix && nameNs.localName === 'xmlns') {
      ns = {
        uri: value
      };
    }

    if (!ns) {
      return {
        name: name,
        value: value
      };
    }

    if (model && model.getPackage(value)) {
      // register well known namespace
      this.logNamespace(ns, true, true);
    } else {
      // log custom namespace directly as used
      var actualNs = this.logNamespaceUsed(ns, true);
      this.getNamespaces().logUsed(actualNs);
    }
  };
  /**
   * Parse namespaces and return a list of left over generic attributes
   *
   * @param  {Object} element
   * @return {Array<Object>}
   */


  ElementSerializer.prototype.parseNsAttributes = function (element, attrs) {
    var self = this;
    var genericAttrs = element.$attrs;
    var attributes = []; // parse namespace attributes first
    // and log them. push non namespace attributes to a list
    // and process them later

    forEach(genericAttrs, function (value, name) {
      var nonNsAttr = self.parseNsAttribute(element, name, value);

      if (nonNsAttr) {
        attributes.push(nonNsAttr);
      }
    });
    return attributes;
  };

  ElementSerializer.prototype.parseGenericAttributes = function (element, attributes) {
    var self = this;
    forEach(attributes, function (attr) {
      // do not serialize xsi:type attribute
      // it is set manually based on the actual implementation type
      if (attr.name === XSI_TYPE$1) {
        return;
      }

      try {
        self.addAttribute(self.nsAttributeName(attr.name), attr.value);
      } catch (e) {
        console.warn('missing namespace information for ', attr.name, '=', attr.value, 'on', element, e);
      }
    });
  };

  ElementSerializer.prototype.parseContainments = function (properties) {
    var self = this,
        body = this.body,
        element = this.element;
    forEach(properties, function (p) {
      var value = element.get(p.name),
          isReference = p.isReference,
          isMany = p.isMany;

      if (!isMany) {
        value = [value];
      }

      if (p.isBody) {
        body.push(new BodySerializer().build(p, value[0]));
      } else if (isSimple(p.type)) {
        forEach(value, function (v) {
          body.push(new ValueSerializer(self.addTagName(self.nsPropertyTagName(p))).build(p, v));
        });
      } else if (isReference) {
        forEach(value, function (v) {
          body.push(new ReferenceSerializer(self.addTagName(self.nsPropertyTagName(p))).build(v));
        });
      } else {
        // allow serialization via type
        // rather than element name
        var asType = serializeAsType(p),
            asProperty = serializeAsProperty(p);
        forEach(value, function (v) {
          var serializer;

          if (asType) {
            serializer = new TypeSerializer(self, p);
          } else if (asProperty) {
            serializer = new ElementSerializer(self, p);
          } else {
            serializer = new ElementSerializer(self);
          }

          body.push(serializer.build(v));
        });
      }
    });
  };

  ElementSerializer.prototype.getNamespaces = function (local) {
    var namespaces = this.namespaces,
        parent = this.parent,
        parentNamespaces;

    if (!namespaces) {
      parentNamespaces = parent && parent.getNamespaces();

      if (local || !parentNamespaces) {
        this.namespaces = namespaces = new Namespaces(parentNamespaces);
      } else {
        namespaces = parentNamespaces;
      }
    }

    return namespaces;
  };

  ElementSerializer.prototype.logNamespace = function (ns, wellknown, local) {
    var namespaces = this.getNamespaces(local);
    var nsUri = ns.uri,
        nsPrefix = ns.prefix;
    var existing = namespaces.byUri(nsUri);

    if (nsPrefix !== 'xml' && (!existing || local)) {
      namespaces.add(ns, wellknown);
    }

    namespaces.mapPrefix(nsPrefix, nsUri);
    return ns;
  };

  ElementSerializer.prototype.logNamespaceUsed = function (ns, local) {
    var element = this.element,
        model = element.$model,
        namespaces = this.getNamespaces(local); // ns may be
    //
    //   * prefix only
    //   * prefix:uri
    //   * localName only

    var prefix = ns.prefix,
        uri = ns.uri,
        newPrefix,
        idx,
        wellknownUri; // handle anonymous namespaces (elementForm=unqualified), cf. #23

    if (!prefix && !uri) {
      return {
        localName: ns.localName
      };
    }

    wellknownUri = DEFAULT_NS_MAP[prefix] || model && (model.getPackage(prefix) || {}).uri;
    uri = uri || wellknownUri || namespaces.uriByPrefix(prefix);

    if (!uri) {
      throw new Error('no namespace uri given for prefix <' + prefix + '>');
    }

    ns = namespaces.byUri(uri);

    if (!ns) {
      newPrefix = prefix;
      idx = 1; // find a prefix that is not mapped yet

      while (namespaces.uriByPrefix(newPrefix)) {
        newPrefix = prefix + '_' + idx++;
      }

      ns = this.logNamespace({
        prefix: newPrefix,
        uri: uri
      }, wellknownUri === uri);
    }

    if (prefix) {
      namespaces.mapPrefix(prefix, uri);
    }

    return ns;
  };

  ElementSerializer.prototype.parseAttributes = function (properties) {
    var self = this,
        element = this.element;
    forEach(properties, function (p) {
      var value = element.get(p.name);

      if (p.isReference) {
        if (!p.isMany) {
          value = value.id;
        } else {
          var values = [];
          forEach(value, function (v) {
            values.push(v.id);
          }); // IDREFS is a whitespace-separated list of references.

          value = values.join(' ');
        }
      }

      self.addAttribute(self.nsAttributeName(p), value);
    });
  };

  ElementSerializer.prototype.addTagName = function (nsTagName) {
    var actualNs = this.logNamespaceUsed(nsTagName);
    this.getNamespaces().logUsed(actualNs);
    return nsName(nsTagName);
  };

  ElementSerializer.prototype.addAttribute = function (name, value) {
    var attrs = this.attrs;

    if (isString(value)) {
      value = escapeAttr(value);
    }

    attrs.push({
      name: name,
      value: value
    });
  };

  ElementSerializer.prototype.serializeAttributes = function (writer) {
    var attrs = this.attrs,
        namespaces = this.namespaces;

    if (namespaces) {
      attrs = getNsAttrs(namespaces).concat(attrs);
    }

    forEach(attrs, function (a) {
      writer.append(' ').append(nsName(a.name)).append('="').append(a.value).append('"');
    });
  };

  ElementSerializer.prototype.serializeTo = function (writer) {
    var firstBody = this.body[0],
        indent = firstBody && firstBody.constructor !== BodySerializer;
    writer.appendIndent().append('<' + this.tagName);
    this.serializeAttributes(writer);
    writer.append(firstBody ? '>' : ' />');

    if (firstBody) {
      if (indent) {
        writer.appendNewLine().indent();
      }

      forEach(this.body, function (b) {
        b.serializeTo(writer);
      });

      if (indent) {
        writer.unindent().appendIndent();
      }

      writer.append('</' + this.tagName + '>');
    }

    writer.appendNewLine();
  };
  /**
   * A serializer for types that handles serialization of data types
   */


  function TypeSerializer(parent, propertyDescriptor) {
    ElementSerializer.call(this, parent, propertyDescriptor);
  }

  inherits(TypeSerializer, ElementSerializer);

  TypeSerializer.prototype.parseNsAttributes = function (element) {
    // extracted attributes
    var attributes = ElementSerializer.prototype.parseNsAttributes.call(this, element);
    var descriptor = element.$descriptor; // only serialize xsi:type if necessary

    if (descriptor.name === this.propertyDescriptor.type) {
      return attributes;
    }

    var typeNs = this.typeNs = this.nsTagName(descriptor);
    this.getNamespaces().logUsed(this.typeNs); // add xsi:type attribute to represent the elements
    // actual type

    var pkg = element.$model.getPackage(typeNs.uri),
        typePrefix = pkg.xml && pkg.xml.typePrefix || '';
    this.addAttribute(this.nsAttributeName(XSI_TYPE$1), (typeNs.prefix ? typeNs.prefix + ':' : '') + typePrefix + descriptor.ns.localName);
    return attributes;
  };

  TypeSerializer.prototype.isLocalNs = function (ns) {
    return ns.uri === (this.typeNs || this.ns).uri;
  };

  function SavingWriter() {
    this.value = '';

    this.write = function (str) {
      this.value += str;
    };
  }

  function FormatingWriter(out, format) {
    var indent = [''];

    this.append = function (str) {
      out.write(str);
      return this;
    };

    this.appendNewLine = function () {
      if (format) {
        out.write('\n');
      }

      return this;
    };

    this.appendIndent = function () {
      if (format) {
        out.write(indent.join('  '));
      }

      return this;
    };

    this.indent = function () {
      indent.push('');
      return this;
    };

    this.unindent = function () {
      indent.pop();
      return this;
    };
  }
  /**
   * A writer for meta-model backed document trees
   *
   * @param {Object} options output options to pass into the writer
   */


  function Writer(options) {
    options = assign({
      format: false,
      preamble: true
    }, options || {});

    function toXML(tree, writer) {
      var internalWriter = writer || new SavingWriter();
      var formatingWriter = new FormatingWriter(internalWriter, options.format);

      if (options.preamble) {
        formatingWriter.append(XML_PREAMBLE);
      }

      new ElementSerializer().build(tree).serializeTo(formatingWriter);

      if (!writer) {
        return internalWriter.value;
      }
    }

    return {
      toXML: toXML
    };
  }

  /**
   * A sub class of {@link Moddle} with support for import and export of DMN xml files.
   *
   * @class DmnModdle
   * @extends Moddle
   *
   * @param {Object|Array} packages to use for instantiating the model
   * @param {Object} [options] additional options to pass over
   */

  function DmnModdle(packages, options) {
    Moddle.call(this, packages, options);
  }

  DmnModdle.prototype = Object.create(Moddle.prototype);
  /**
   * Instantiates a DMN model tree from a given xml string.
   *
   * @param {String}   xmlStr
   * @param {String}   [typeName='dmn:Definitions'] name of the root element
   * @param {Object}   [options]  options to pass to the underlying reader
   * @param {Function} done       callback that is invoked with (err, result, parseContext)
   *                              once the import completes
   */

  DmnModdle.prototype.fromXML = function (xmlStr, typeName, options, done) {
    if (!isString(typeName)) {
      done = options;
      options = typeName;
      typeName = 'dmn:Definitions';
    }

    if (isFunction(options)) {
      done = options;
      options = {};
    }

    var reader = new Reader(assign({
      model: this,
      lax: true
    }, options));
    var rootHandler = reader.handler(typeName);
    reader.fromXML(xmlStr, rootHandler, done);
  };
  /**
   * Serializes a DMN object tree to XML.
   *
   * @param {String}   element    the root element, typically an instance of `Definitions`
   * @param {Object}   [options]  to pass to the underlying writer
   * @param {Function} done       callback invoked with (err, xmlStr) once the import completes
   */


  DmnModdle.prototype.toXML = function (element, options, done) {
    if (isFunction(options)) {
      done = options;
      options = {};
    }

    var writer = new Writer(options);
    var result;
    var err;

    try {
      result = writer.toXML(element);
    } catch (e) {
      err = e;
    }

    return done(err, result);
  };

  var name = "DC";
  var prefix = "dc";
  var uri = "http://www.omg.org/spec/DMN/20180521/DC/";
  var types = [{
    name: "Dimension",
    properties: [{
      name: "width",
      isAttr: true,
      type: "Real"
    }, {
      name: "height",
      isAttr: true,
      type: "Real"
    }]
  }, {
    name: "Bounds",
    properties: [{
      name: "height",
      isAttr: true,
      type: "Real"
    }, {
      name: "width",
      isAttr: true,
      type: "Real"
    }, {
      name: "x",
      isAttr: true,
      type: "Real"
    }, {
      name: "y",
      isAttr: true,
      type: "Real"
    }]
  }, {
    name: "Point",
    properties: [{
      name: "x",
      isAttr: true,
      type: "Real"
    }, {
      name: "y",
      isAttr: true,
      type: "Real"
    }]
  }, {
    name: "Color",
    properties: [{
      name: "red",
      type: "UML_Standard_Profile.mdzip:eee_1045467100323_917313_65"
    }, {
      name: "green",
      type: "UML_Standard_Profile.mdzip:eee_1045467100323_917313_65"
    }, {
      name: "blue",
      type: "UML_Standard_Profile.mdzip:eee_1045467100323_917313_65"
    }]
  }];
  var associations = [];
  var enumerations = [{
    name: "AlignmentKind",
    literalValues: [{
      name: "start"
    }, {
      name: "center"
    }, {
      name: "end"
    }]
  }];
  var DcPackage = {
    name: name,
    prefix: prefix,
    uri: uri,
    types: types,
    associations: associations,
    enumerations: enumerations
  };
  var name$1 = "DI";
  var prefix$1 = "di";
  var uri$1 = "http://www.omg.org/spec/DMN/20180521/DI/";
  var types$1 = [{
    name: "DiagramElement",
    isAbstract: true,
    properties: [{
      name: "id",
      isAttr: true,
      isId: true,
      type: "String"
    }, {
      name: "style",
      isReference: true,
      type: "Style",
      xml: {
        serialize: "property"
      }
    }, {
      name: "sharedStyle",
      isReference: true,
      isVirtual: true,
      type: "Style"
    }]
  }, {
    name: "Diagram",
    superClass: ["DiagramElement"],
    properties: [{
      name: "name",
      isAttr: true,
      type: "String"
    }, {
      name: "documentation",
      isAttr: true,
      type: "String"
    }, {
      name: "resolution",
      isAttr: true,
      type: "Real"
    }]
  }, {
    name: "Shape",
    isAbstract: true,
    properties: [{
      name: "bounds",
      type: "dc:Bounds"
    }],
    superClass: ["DiagramElement"]
  }, {
    name: "Edge",
    isAbstract: true,
    properties: [{
      name: "waypoint",
      type: "dc:Point",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }],
    superClass: ["DiagramElement"]
  }, {
    name: "Style",
    isAbstract: true,
    properties: [{
      name: "id",
      isAttr: true,
      isId: true,
      type: "String"
    }]
  }];
  var associations$1 = [];
  var enumerations$1 = [];
  var xml = {
    tagAlias: "lowerCase"
  };
  var DiPackage = {
    name: name$1,
    prefix: prefix$1,
    uri: uri$1,
    types: types$1,
    associations: associations$1,
    enumerations: enumerations$1,
    xml: xml
  };
  var name$2 = "DMN";
  var prefix$2 = "dmn";
  var uri$2 = "https://www.omg.org/spec/DMN/20191111/MODEL/";
  var types$2 = [{
    name: "AuthorityRequirement",
    superClass: ["DMNElement"],
    properties: [{
      name: "requiredAuthority",
      type: "DMNElementReference",
      xml: {
        serialize: "property"
      }
    }, {
      name: "requiredDecision",
      type: "DMNElementReference",
      xml: {
        serialize: "property"
      }
    }, {
      name: "requiredInput",
      type: "DMNElementReference",
      xml: {
        serialize: "property"
      }
    }]
  }, {
    name: "ItemDefinition",
    superClass: ["NamedElement"],
    properties: [{
      name: "typeRef",
      type: "String"
    }, {
      name: "allowedValues",
      type: "UnaryTests",
      xml: {
        serialize: "property"
      }
    }, {
      name: "typeLanguage",
      type: "String",
      isAttr: true
    }, {
      name: "itemComponent",
      type: "ItemDefinition",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "functionItem",
      type: "FunctionItem"
    }, {
      name: "isCollection",
      isAttr: true,
      type: "Boolean"
    }]
  }, {
    name: "Definitions",
    superClass: ["NamedElement"],
    properties: [{
      name: "import",
      type: "Import",
      isMany: true
    }, {
      name: "itemDefinition",
      type: "ItemDefinition",
      isMany: true
    }, {
      name: "drgElement",
      type: "DRGElement",
      isMany: true
    }, {
      name: "artifact",
      type: "Artifact",
      isMany: true
    }, {
      name: "elementCollection",
      type: "ElementCollection",
      isMany: true
    }, {
      name: "businessContextElement",
      type: "BusinessContextElement",
      isMany: true
    }, {
      name: "namespace",
      type: "String",
      isAttr: true
    }, {
      name: "expressionLanguage",
      type: "String",
      isAttr: true
    }, {
      name: "typeLanguage",
      type: "String",
      isAttr: true
    }, {
      name: "exporter",
      isAttr: true,
      type: "String"
    }, {
      name: "exporterVersion",
      isAttr: true,
      type: "String"
    }, {
      name: "dmnDI",
      type: "dmndi:DMNDI"
    }]
  }, {
    name: "KnowledgeSource",
    superClass: ["DRGElement"],
    properties: [{
      name: "authorityRequirement",
      type: "AuthorityRequirement",
      isMany: true
    }, {
      name: "type",
      type: "String"
    }, {
      name: "owner",
      type: "DMNElementReference",
      xml: {
        serialize: "property"
      }
    }, {
      name: "locationURI",
      type: "String",
      isAttr: true
    }]
  }, {
    name: "DecisionRule",
    superClass: ["DMNElement"],
    properties: [{
      name: "inputEntry",
      type: "UnaryTests",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "outputEntry",
      type: "LiteralExpression",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "annotationEntry",
      type: "RuleAnnotation",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }]
  }, {
    name: "Expression",
    isAbstract: true,
    superClass: ["DMNElement"],
    properties: [{
      name: "typeRef",
      isAttr: true,
      type: "String"
    }]
  }, {
    name: "InformationItem",
    superClass: ["NamedElement"],
    properties: [{
      name: "typeRef",
      isAttr: true,
      type: "String"
    }]
  }, {
    name: "Decision",
    superClass: ["DRGElement"],
    properties: [{
      name: "question",
      type: "String",
      xml: {
        serialize: "property"
      }
    }, {
      name: "allowedAnswers",
      type: "String",
      xml: {
        serialize: "property"
      }
    }, {
      name: "variable",
      type: "InformationItem",
      xml: {
        serialize: "property"
      }
    }, {
      name: "informationRequirement",
      type: "InformationRequirement",
      isMany: true
    }, {
      name: "knowledgeRequirement",
      type: "KnowledgeRequirement",
      isMany: true
    }, {
      name: "authorityRequirement",
      type: "AuthorityRequirement",
      isMany: true
    }, {
      name: "supportedObjective",
      isMany: true,
      type: "DMNElementReference",
      xml: {
        serialize: "property"
      }
    }, {
      name: "impactedPerformanceIndicator",
      type: "DMNElementReference",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "decisionMaker",
      type: "DMNElementReference",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "decisionOwner",
      type: "DMNElementReference",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "usingProcess",
      isMany: true,
      type: "DMNElementReference",
      xml: {
        serialize: "property"
      }
    }, {
      name: "usingTask",
      isMany: true,
      type: "DMNElementReference",
      xml: {
        serialize: "property"
      }
    }, {
      name: "decisionLogic",
      type: "Expression"
    }]
  }, {
    name: "Invocation",
    superClass: ["Expression"],
    properties: [{
      name: "calledFunction",
      type: "Expression"
    }, {
      name: "binding",
      type: "Binding",
      isMany: true
    }]
  }, {
    name: "OrganisationalUnit",
    superClass: ["BusinessContextElement"],
    properties: [{
      name: "decisionMade",
      type: "Decision",
      isReference: true,
      isMany: true
    }, {
      name: "decisionOwned",
      type: "Decision",
      isReference: true,
      isMany: true
    }]
  }, {
    name: "Import",
    superClass: ["NamedElement"],
    properties: [{
      name: "importType",
      type: "String",
      isAttr: true
    }, {
      name: "locationURI",
      type: "String",
      isAttr: true
    }, {
      name: "namespace",
      type: "String",
      isAttr: true
    }]
  }, {
    name: "InformationRequirement",
    superClass: ["DMNElement"],
    properties: [{
      name: "requiredDecision",
      type: "DMNElementReference",
      xml: {
        serialize: "property"
      }
    }, {
      name: "requiredInput",
      type: "DMNElementReference",
      xml: {
        serialize: "property"
      }
    }]
  }, {
    name: "ElementCollection",
    superClass: ["NamedElement"],
    properties: [{
      name: "drgElement",
      type: "DMNElementReference",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }]
  }, {
    name: "DRGElement",
    isAbstract: true,
    superClass: ["NamedElement"],
    properties: []
  }, {
    name: "InputData",
    superClass: ["DRGElement"],
    properties: [{
      name: "variable",
      type: "InformationItem",
      xml: {
        serialize: "property"
      }
    }]
  }, {
    name: "DMNElement",
    isAbstract: true,
    properties: [{
      name: "description",
      type: "String"
    }, {
      name: "extensionElements",
      type: "ExtensionElements"
    }, {
      name: "id",
      type: "String",
      isAttr: true,
      isId: true
    }, {
      name: "extensionAttribute",
      type: "ExtensionAttribute",
      isMany: true
    }, {
      name: "label",
      isAttr: true,
      type: "String"
    }]
  }, {
    name: "InputClause",
    superClass: ["DMNElement"],
    properties: [{
      name: "inputExpression",
      type: "LiteralExpression",
      xml: {
        serialize: "property"
      }
    }, {
      name: "inputValues",
      type: "UnaryTests",
      xml: {
        serialize: "property"
      }
    }]
  }, {
    name: "DecisionTable",
    superClass: ["Expression"],
    properties: [{
      name: "input",
      type: "InputClause",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "output",
      type: "OutputClause",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "annotation",
      type: "RuleAnnotationClause",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "rule",
      type: "DecisionRule",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "hitPolicy",
      type: "HitPolicy",
      isAttr: true,
      "default": "UNIQUE"
    }, {
      name: "aggregation",
      type: "BuiltinAggregator",
      isAttr: true
    }, {
      name: "preferredOrientation",
      type: "DecisionTableOrientation",
      isAttr: true
    }, {
      name: "outputLabel",
      isAttr: true,
      type: "String"
    }]
  }, {
    name: "LiteralExpression",
    superClass: ["Expression"],
    properties: [{
      name: "expressionLanguage",
      type: "String",
      isAttr: true
    }, {
      name: "text",
      type: "String"
    }, {
      name: "importedValues",
      type: "ImportedValues"
    }]
  }, {
    name: "Binding",
    properties: [{
      name: "parameter",
      type: "InformationItem",
      xml: {
        serialize: "property"
      }
    }, {
      name: "bindingFormula",
      type: "Expression"
    }]
  }, {
    name: "KnowledgeRequirement",
    superClass: ["DMNElement"],
    properties: [{
      name: "requiredKnowledge",
      type: "DMNElementReference",
      xml: {
        serialize: "property"
      }
    }]
  }, {
    name: "BusinessKnowledgeModel",
    superClass: ["Invocable"],
    properties: [{
      name: "encapsulatedLogic",
      type: "FunctionDefinition",
      xml: {
        serialize: "property"
      }
    }, {
      name: "knowledgeRequirement",
      type: "KnowledgeRequirement",
      isMany: true
    }, {
      name: "authorityRequirement",
      type: "AuthorityRequirement",
      isMany: true
    }]
  }, {
    name: "BusinessContextElement",
    isAbstract: true,
    superClass: ["NamedElement"],
    properties: [{
      name: "URI",
      type: "String",
      isAttr: true
    }]
  }, {
    name: "PerformanceIndicator",
    superClass: ["BusinessContextElement"],
    properties: [{
      name: "impactingDecision",
      type: "DMNElementReference",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }]
  }, {
    name: "FunctionDefinition",
    superClass: ["Expression"],
    properties: [{
      name: "formalParameter",
      type: "InformationItem",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "body",
      type: "Expression"
    }, {
      name: "kind",
      type: "FunctionKind",
      isAttr: true
    }]
  }, {
    name: "Context",
    superClass: ["Expression"],
    properties: [{
      name: "contextEntry",
      type: "ContextEntry",
      isMany: true
    }]
  }, {
    name: "ContextEntry",
    superClass: ["DMNElement"],
    properties: [{
      name: "variable",
      type: "InformationItem",
      xml: {
        serialize: "property"
      }
    }, {
      name: "value",
      type: "Expression"
    }]
  }, {
    name: "List",
    superClass: ["Expression"],
    properties: [{
      name: "elements",
      isMany: true,
      type: "Expression"
    }]
  }, {
    name: "Relation",
    superClass: ["Expression"],
    properties: [{
      name: "column",
      type: "InformationItem",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "row",
      type: "List",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }]
  }, {
    name: "OutputClause",
    superClass: ["DMNElement"],
    properties: [{
      name: "outputValues",
      type: "UnaryTests",
      xml: {
        serialize: "property"
      }
    }, {
      name: "defaultOutputEntry",
      type: "LiteralExpression",
      xml: {
        serialize: "property"
      }
    }, {
      name: "name",
      isAttr: true,
      type: "String"
    }, {
      name: "typeRef",
      isAttr: true,
      type: "String"
    }]
  }, {
    name: "UnaryTests",
    superClass: ["Expression"],
    properties: [{
      name: "text",
      type: "String"
    }, {
      name: "expressionLanguage",
      type: "String",
      isAttr: true
    }]
  }, {
    name: "NamedElement",
    isAbstract: true,
    superClass: ["DMNElement"],
    properties: [{
      name: "name",
      isAttr: true,
      type: "String"
    }]
  }, {
    name: "ImportedValues",
    superClass: ["Import"],
    properties: [{
      name: "importedElement",
      type: "String"
    }, {
      name: "expressionLanguage",
      type: "String",
      isAttr: true
    }]
  }, {
    name: "DecisionService",
    superClass: ["Invocable"],
    properties: [{
      name: "outputDecision",
      type: "DMNElementReference",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "encapsulatedDecision",
      type: "DMNElementReference",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "inputDecision",
      type: "DMNElementReference",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }, {
      name: "inputData",
      type: "DMNElementReference",
      isMany: true,
      xml: {
        serialize: "property"
      }
    }]
  }, {
    name: "ExtensionElements",
    properties: [{
      name: "values",
      type: "Element",
      isMany: true
    }]
  }, {
    name: "ExtensionAttribute",
    properties: [{
      name: "value",
      type: "Element"
    }, {
      name: "valueRef",
      type: "Element",
      isAttr: true,
      isReference: true
    }, {
      name: "name",
      isAttr: true,
      type: "String"
    }]
  }, {
    name: "Element",
    isAbstract: true,
    properties: [{
      name: "extensionAttribute",
      type: "ExtensionAttribute",
      isAttr: true,
      isReference: true
    }, {
      name: "elements",
      type: "ExtensionElements",
      isAttr: true,
      isReference: true
    }]
  }, {
    name: "Artifact",
    isAbstract: true,
    superClass: ["DMNElement"],
    properties: []
  }, {
    name: "Association",
    superClass: ["Artifact"],
    properties: [{
      name: "sourceRef",
      type: "DMNElementReference",
      xml: {
        serialize: "property"
      }
    }, {
      name: "targetRef",
      type: "DMNElementReference",
      xml: {
        serialize: "property"
      }
    }, {
      name: "associationDirection",
      type: "AssociationDirection",
      isAttr: true
    }]
  }, {
    name: "TextAnnotation",
    superClass: ["Artifact"],
    properties: [{
      name: "text",
      type: "String"
    }, {
      name: "textFormat",
      isAttr: true,
      type: "String",
      "default": "text/plain"
    }]
  }, {
    name: "RuleAnnotationClause",
    properties: [{
      name: "name",
      isAttr: true,
      type: "String"
    }]
  }, {
    name: "RuleAnnotation",
    properties: [{
      name: "text",
      type: "String"
    }]
  }, {
    name: "Invocable",
    isAbstract: true,
    superClass: ["DRGElement"],
    properties: [{
      name: "variable",
      type: "InformationItem",
      xml: {
        serialize: "property"
      }
    }]
  }, {
    name: "Group",
    superClass: ["Artifact"],
    properties: [{
      name: "name",
      isAttr: true,
      type: "String"
    }]
  }, {
    name: "FunctionItem",
    superClass: ["DMNElement"],
    properties: [{
      name: "parameters",
      isMany: true,
      type: "InformationItem",
      xml: {
        serialize: "property"
      }
    }, {
      name: "outputTypeRef",
      isAttr: true,
      type: "String"
    }]
  }, {
    name: "DMNElementReference",
    properties: [{
      isAttr: true,
      name: "href",
      type: "String"
    }]
  }];
  var enumerations$2 = [{
    name: "HitPolicy",
    literalValues: [{
      name: "UNIQUE"
    }, {
      name: "FIRST"
    }, {
      name: "PRIORITY"
    }, {
      name: "ANY"
    }, {
      name: "COLLECT"
    }, {
      name: "RULE ORDER"
    }, {
      name: "OUTPUT ORDER"
    }]
  }, {
    name: "BuiltinAggregator",
    literalValues: [{
      name: "SUM"
    }, {
      name: "COUNT"
    }, {
      name: "MIN"
    }, {
      name: "MAX"
    }]
  }, {
    name: "DecisionTableOrientation",
    literalValues: [{
      name: "Rule-as-Row"
    }, {
      name: "Rule-as-Column"
    }, {
      name: "CrossTable"
    }]
  }, {
    name: "AssociationDirection",
    literalValues: [{
      name: "None"
    }, {
      name: "One"
    }, {
      name: "Both"
    }]
  }, {
    name: "FunctionKind",
    literalValues: [{
      name: "FEEL"
    }, {
      name: "Java"
    }, {
      name: "PMML"
    }]
  }];
  var associations$2 = [];
  var xml$1 = {
    tagAlias: "lowerCase"
  };
  var DmnPackage = {
    name: name$2,
    prefix: prefix$2,
    uri: uri$2,
    types: types$2,
    enumerations: enumerations$2,
    associations: associations$2,
    xml: xml$1
  };
  var name$3 = "DMNDI";
  var prefix$3 = "dmndi";
  var uri$3 = "https://www.omg.org/spec/DMN/20191111/DMNDI/";
  var types$3 = [{
    name: "DMNDI",
    properties: [{
      name: "diagrams",
      type: "DMNDiagram",
      isMany: true
    }, {
      name: "styles",
      type: "DMNStyle",
      isMany: true
    }]
  }, {
    name: "DMNStyle",
    superClass: ["di:Style"],
    properties: [{
      name: "fillColor",
      type: "dc:Color",
      isAttr: true
    }, {
      name: "strokeColor",
      type: "dc:Color",
      isAttr: true
    }, {
      name: "fontColor",
      type: "dc:Color",
      isAttr: true
    }, {
      name: "fontSize",
      isAttr: true,
      type: "Real"
    }, {
      name: "fontFamily",
      isAttr: true,
      type: "String"
    }, {
      name: "fontItalic",
      isAttr: true,
      type: "Boolean"
    }, {
      name: "fontBold",
      isAttr: true,
      type: "Boolean"
    }, {
      name: "fontUnderline",
      isAttr: true,
      type: "Boolean"
    }, {
      name: "fontStrikeThrough",
      isAttr: true,
      type: "Boolean"
    }, {
      name: "labelHorizontalAlignment",
      type: "dc:AlignmentKind",
      isAttr: true
    }, {
      name: "labelVerticalAlignment",
      type: "dc:AlignmentKind",
      isAttr: true
    }]
  }, {
    name: "DMNDiagram",
    superClass: ["di:Diagram"],
    properties: [{
      name: "dmnElementRef",
      type: "dmn:DMNElement",
      isAttr: true,
      isReference: true
    }, {
      name: "size",
      type: "Size"
    }, {
      name: "localStyle",
      type: "DMNStyle",
      isVirtual: true
    }, {
      name: "sharedStyle",
      type: "DMNStyle",
      isVirtual: true,
      isReference: true,
      redefines: "di:DiagramElement#sharedStyle"
    }, {
      name: "diagramElements",
      type: "DMNDiagramElement",
      isMany: true
    }]
  }, {
    name: "DMNDiagramElement",
    isAbstract: true,
    superClass: ["di:DiagramElement"],
    properties: [{
      name: "dmnElementRef",
      type: "dmn:DMNElement",
      isAttr: true,
      isReference: true
    }, {
      name: "sharedStyle",
      type: "DMNStyle",
      isVirtual: true,
      isReference: true,
      redefines: "di:DiagramElement#sharedStyle"
    }, {
      name: "localStyle",
      type: "DMNStyle",
      isVirtual: true
    }, {
      name: "label",
      type: "DMNLabel"
    }]
  }, {
    name: "DMNLabel",
    superClass: ["di:Shape"],
    properties: [{
      name: "text",
      type: "Text"
    }]
  }, {
    name: "DMNShape",
    superClass: ["di:Shape", "DMNDiagramElement"],
    properties: [{
      name: "isListedInputData",
      isAttr: true,
      type: "Boolean"
    }, {
      name: "decisionServiceDividerLine",
      type: "DMNDecisionServiceDividerLine"
    }, {
      name: "isCollapsed",
      isAttr: true,
      type: "Boolean"
    }]
  }, {
    name: "DMNEdge",
    superClass: ["di:Edge", "DMNDiagramElement"],
    properties: [{
      name: "sourceElement",
      type: "DMNDiagramElement",
      isAttr: true,
      isReference: true
    }, {
      name: "targetElement",
      type: "DMNDiagramElement",
      isAttr: true,
      isReference: true
    }]
  }, {
    name: "DMNDecisionServiceDividerLine",
    superClass: ["di:Edge"]
  }, {
    name: "Text",
    properties: [{
      name: "text",
      isBody: true,
      type: "String"
    }]
  }, {
    name: "Size",
    superClass: ["dc:Dimension"]
  }];
  var associations$3 = [];
  var enumerations$3 = [];
  var DmnDiPackage = {
    name: name$3,
    prefix: prefix$3,
    uri: uri$3,
    types: types$3,
    associations: associations$3,
    enumerations: enumerations$3
  };
  var name$4 = "bpmn.io DI for DMN";
  var uri$4 = "http://bpmn.io/schema/dmn/biodi/2.0";
  var prefix$4 = "biodi";
  var xml$2 = {
    tagAlias: "lowerCase"
  };
  var types$4 = [{
    name: "DecisionTable",
    isAbstract: true,
    "extends": ["dmn:DecisionTable"],
    properties: [{
      name: "annotationsWidth",
      isAttr: true,
      type: "Integer"
    }]
  }, {
    name: "OutputClause",
    isAbstract: true,
    "extends": ["dmn:OutputClause"],
    properties: [{
      name: "width",
      isAttr: true,
      type: "Integer"
    }]
  }, {
    name: "InputClause",
    isAbstract: true,
    "extends": ["dmn:InputClause"],
    properties: [{
      name: "width",
      isAttr: true,
      type: "Integer"
    }]
  }];
  var BioDiPackage = {
    name: name$4,
    uri: uri$4,
    prefix: prefix$4,
    xml: xml$2,
    types: types$4
  };
  var packages = {
    dc: DcPackage,
    di: DiPackage,
    dmn: DmnPackage,
    dmndi: DmnDiPackage,
    biodi: BioDiPackage
  };

  function simple(additionalPackages, options) {
    var pks = assign({}, packages, additionalPackages);
    return new DmnModdle(pks, options);
  }

  var name$5 = "Camunda";
  var uri$5 = "http://camunda.org/schema/1.0/dmn";
  var prefix$5 = "camunda";
  var xml$3 = {
  	tagAlias: "lowerCase"
  };
  var associations$4 = [
  ];
  var types$5 = [
  	{
  		name: "Definitions",
  		isAbstract: true,
  		"extends": [
  			"dmn:Definitions"
  		],
  		properties: [
  			{
  				name: "diagramRelationId",
  				isAttr: true,
  				type: "String"
  			}
  		]
  	},
  	{
  		name: "Decision",
  		isAbstract: true,
  		"extends": [
  			"dmn:Decision"
  		],
  		properties: [
  			{
  				name: "versionTag",
  				isAttr: true,
  				type: "String"
  			},
  			{
  				name: "historyTimeToLive",
  				isAttr: true,
  				type: "String"
  			}
  		]
  	},
  	{
  		name: "InputClause",
  		"extends": [
  			"dmn:InputClause"
  		],
  		properties: [
  			{
  				name: "inputVariable",
  				isAttr: true,
  				type: "String"
  			}
  		]
  	}
  ];
  var emumerations = [
  ];
  var CamundaModdle = {
  	name: name$5,
  	uri: uri$5,
  	prefix: prefix$5,
  	xml: xml$3,
  	associations: associations$4,
  	types: types$5,
  	emumerations: emumerations
  };

  /**
   * Set attribute `name` to `val`, or get attr `name`.
   *
   * @param {Element} el
   * @param {String} name
   * @param {String} [val]
   * @api public
   */
  function attr(el, name, val) {
    // get
    if (arguments.length == 2) {
      return el.getAttribute(name);
    } // remove


    if (val === null) {
      return el.removeAttribute(name);
    } // set


    el.setAttribute(name, val);
    return el;
  }

  var indexOf = [].indexOf;

  var indexof = function indexof(arr, obj) {
    if (indexOf) return arr.indexOf(obj);

    for (var i = 0; i < arr.length; ++i) {
      if (arr[i] === obj) return i;
    }

    return -1;
  };
  /**
   * Taken from https://github.com/component/classes
   *
   * Without the component bits.
   */

  /**
   * Whitespace regexp.
   */


  var re = /\s+/;
  /**
   * toString reference.
   */

  var toString = Object.prototype.toString;
  /**
   * Wrap `el` in a `ClassList`.
   *
   * @param {Element} el
   * @return {ClassList}
   * @api public
   */

  function classes(el) {
    return new ClassList(el);
  }
  /**
   * Initialize a new ClassList for `el`.
   *
   * @param {Element} el
   * @api private
   */


  function ClassList(el) {
    if (!el || !el.nodeType) {
      throw new Error('A DOM element reference is required');
    }

    this.el = el;
    this.list = el.classList;
  }
  /**
   * Add class `name` if not already present.
   *
   * @param {String} name
   * @return {ClassList}
   * @api public
   */


  ClassList.prototype.add = function (name) {
    // classList
    if (this.list) {
      this.list.add(name);
      return this;
    } // fallback


    var arr = this.array();
    var i = indexof(arr, name);
    if (!~i) arr.push(name);
    this.el.className = arr.join(' ');
    return this;
  };
  /**
   * Remove class `name` when present, or
   * pass a regular expression to remove
   * any which match.
   *
   * @param {String|RegExp} name
   * @return {ClassList}
   * @api public
   */


  ClassList.prototype.remove = function (name) {
    if ('[object RegExp]' == toString.call(name)) {
      return this.removeMatching(name);
    } // classList


    if (this.list) {
      this.list.remove(name);
      return this;
    } // fallback


    var arr = this.array();
    var i = indexof(arr, name);
    if (~i) arr.splice(i, 1);
    this.el.className = arr.join(' ');
    return this;
  };
  /**
   * Remove all classes matching `re`.
   *
   * @param {RegExp} re
   * @return {ClassList}
   * @api private
   */


  ClassList.prototype.removeMatching = function (re) {
    var arr = this.array();

    for (var i = 0; i < arr.length; i++) {
      if (re.test(arr[i])) {
        this.remove(arr[i]);
      }
    }

    return this;
  };
  /**
   * Toggle class `name`, can force state via `force`.
   *
   * For browsers that support classList, but do not support `force` yet,
   * the mistake will be detected and corrected.
   *
   * @param {String} name
   * @param {Boolean} force
   * @return {ClassList}
   * @api public
   */


  ClassList.prototype.toggle = function (name, force) {
    // classList
    if (this.list) {
      if ('undefined' !== typeof force) {
        if (force !== this.list.toggle(name, force)) {
          this.list.toggle(name); // toggle again to correct
        }
      } else {
        this.list.toggle(name);
      }

      return this;
    } // fallback


    if ('undefined' !== typeof force) {
      if (!force) {
        this.remove(name);
      } else {
        this.add(name);
      }
    } else {
      if (this.has(name)) {
        this.remove(name);
      } else {
        this.add(name);
      }
    }

    return this;
  };
  /**
   * Return an array of classes.
   *
   * @return {Array}
   * @api public
   */


  ClassList.prototype.array = function () {
    var className = this.el.getAttribute('class') || '';
    var str = className.replace(/^\s+|\s+$/g, '');
    var arr = str.split(re);
    if ('' === arr[0]) arr.shift();
    return arr;
  };
  /**
   * Check if class `name` is present.
   *
   * @param {String} name
   * @return {ClassList}
   * @api public
   */


  ClassList.prototype.has = ClassList.prototype.contains = function (name) {
    return this.list ? this.list.contains(name) : !!~indexof(this.array(), name);
  };
  /**
   * Remove all children from the given element.
   */


  function clear(el) {
    var c;

    while (el.childNodes.length) {
      c = el.childNodes[0];
      el.removeChild(c);
    }

    return el;
  }

  var proto = typeof Element !== 'undefined' ? Element.prototype : {};
  var vendor = proto.matches || proto.matchesSelector || proto.webkitMatchesSelector || proto.mozMatchesSelector || proto.msMatchesSelector || proto.oMatchesSelector;
  var matchesSelector = match;
  /**
   * Match `el` to `selector`.
   *
   * @param {Element} el
   * @param {String} selector
   * @return {Boolean}
   * @api public
   */

  function match(el, selector) {
    if (!el || el.nodeType !== 1) return false;
    if (vendor) return vendor.call(el, selector);
    var nodes = el.parentNode.querySelectorAll(selector);

    for (var i = 0; i < nodes.length; i++) {
      if (nodes[i] == el) return true;
    }

    return false;
  }
  /**
   * Closest
   *
   * @param {Element} el
   * @param {String} selector
   * @param {Boolean} checkYourSelf (optional)
   */


  function closest(element, selector, checkYourSelf) {
    var currentElem = checkYourSelf ? element : element.parentNode;

    while (currentElem && currentElem.nodeType !== document.DOCUMENT_NODE && currentElem.nodeType !== document.DOCUMENT_FRAGMENT_NODE) {
      if (matchesSelector(currentElem, selector)) {
        return currentElem;
      }

      currentElem = currentElem.parentNode;
    }

    return matchesSelector(currentElem, selector) ? currentElem : null;
  }

  var bind$1 = window.addEventListener ? 'addEventListener' : 'attachEvent',
      unbind = window.removeEventListener ? 'removeEventListener' : 'detachEvent',
      prefix$6 = bind$1 !== 'addEventListener' ? 'on' : '';
  /**
   * Bind `el` event `type` to `fn`.
   *
   * @param {Element} el
   * @param {String} type
   * @param {Function} fn
   * @param {Boolean} capture
   * @return {Function}
   * @api public
   */

  var bind_1 = function bind_1(el, type, fn, capture) {
    el[bind$1](prefix$6 + type, fn, capture || false);
    return fn;
  };
  /**
   * Unbind `el` event `type`'s callback `fn`.
   *
   * @param {Element} el
   * @param {String} type
   * @param {Function} fn
   * @param {Boolean} capture
   * @return {Function}
   * @api public
   */


  var unbind_1 = function unbind_1(el, type, fn, capture) {
    el[unbind](prefix$6 + type, fn, capture || false);
    return fn;
  };

  var componentEvent = {
    bind: bind_1,
    unbind: unbind_1
  };
  /**
   * Module dependencies.
   */

  /**
   * Delegate event `type` to `selector`
   * and invoke `fn(e)`. A callback function
   * is returned which may be passed to `.unbind()`.
   *
   * @param {Element} el
   * @param {String} selector
   * @param {String} type
   * @param {Function} fn
   * @param {Boolean} capture
   * @return {Function}
   * @api public
   */
  // Some events don't bubble, so we want to bind to the capture phase instead
  // when delegating.

  var forceCaptureEvents = ['focus', 'blur'];

  function bind$1$1(el, selector, type, fn, capture) {
    if (forceCaptureEvents.indexOf(type) !== -1) {
      capture = true;
    }

    return componentEvent.bind(el, type, function (e) {
      var target = e.target || e.srcElement;
      e.delegateTarget = closest(target, selector, true);

      if (e.delegateTarget) {
        fn.call(el, e);
      }
    }, capture);
  }
  /**
   * Unbind event `type`'s callback `fn`.
   *
   * @param {Element} el
   * @param {String} type
   * @param {Function} fn
   * @param {Boolean} capture
   * @api public
   */


  function unbind$1(el, type, fn, capture) {
    if (forceCaptureEvents.indexOf(type) !== -1) {
      capture = true;
    }

    return componentEvent.unbind(el, type, fn, capture);
  }

  var delegate = {
    bind: bind$1$1,
    unbind: unbind$1
  };
  /**
   * Expose `parse`.
   */

  var domify = parse;
  /**
   * Tests for browser support.
   */

  var innerHTMLBug = false;
  var bugTestDiv;

  if (typeof document !== 'undefined') {
    bugTestDiv = document.createElement('div'); // Setup

    bugTestDiv.innerHTML = '  <link/><table></table><a href="/a">a</a><input type="checkbox"/>'; // Make sure that link elements get serialized correctly by innerHTML
    // This requires a wrapper element in IE

    innerHTMLBug = !bugTestDiv.getElementsByTagName('link').length;
    bugTestDiv = undefined;
  }
  /**
   * Wrap map from jquery.
   */


  var map$1 = {
    legend: [1, '<fieldset>', '</fieldset>'],
    tr: [2, '<table><tbody>', '</tbody></table>'],
    col: [2, '<table><tbody></tbody><colgroup>', '</colgroup></table>'],
    // for script/link/style tags to work in IE6-8, you have to wrap
    // in a div with a non-whitespace character in front, ha!
    _default: innerHTMLBug ? [1, 'X<div>', '</div>'] : [0, '', '']
  };
  map$1.td = map$1.th = [3, '<table><tbody><tr>', '</tr></tbody></table>'];
  map$1.option = map$1.optgroup = [1, '<select multiple="multiple">', '</select>'];
  map$1.thead = map$1.tbody = map$1.colgroup = map$1.caption = map$1.tfoot = [1, '<table>', '</table>'];
  map$1.polyline = map$1.ellipse = map$1.polygon = map$1.circle = map$1.text = map$1.line = map$1.path = map$1.rect = map$1.g = [1, '<svg xmlns="http://www.w3.org/2000/svg" version="1.1">', '</svg>'];
  /**
   * Parse `html` and return a DOM Node instance, which could be a TextNode,
   * HTML DOM Node of some kind (<div> for example), or a DocumentFragment
   * instance, depending on the contents of the `html` string.
   *
   * @param {String} html - HTML string to "domify"
   * @param {Document} doc - The `document` instance to create the Node for
   * @return {DOMNode} the TextNode, DOM Node, or DocumentFragment instance
   * @api private
   */

  function parse(html, doc) {
    if ('string' != typeof html) throw new TypeError('String expected'); // default to the global `document` object

    if (!doc) doc = document; // tag name

    var m = /<([\w:]+)/.exec(html);
    if (!m) return doc.createTextNode(html);
    html = html.replace(/^\s+|\s+$/g, ''); // Remove leading/trailing whitespace

    var tag = m[1]; // body support

    if (tag == 'body') {
      var el = doc.createElement('html');
      el.innerHTML = html;
      return el.removeChild(el.lastChild);
    } // wrap map


    var wrap = map$1[tag] || map$1._default;
    var depth = wrap[0];
    var prefix = wrap[1];
    var suffix = wrap[2];
    var el = doc.createElement('div');
    el.innerHTML = prefix + html + suffix;

    while (depth--) {
      el = el.lastChild;
    } // one element


    if (el.firstChild == el.lastChild) {
      return el.removeChild(el.firstChild);
    } // several elements


    var fragment = doc.createDocumentFragment();

    while (el.firstChild) {
      fragment.appendChild(el.removeChild(el.firstChild));
    }

    return fragment;
  }

  function query(selector, el) {
    el = el || document;
    return el.querySelector(selector);
  }

  function all(selector, el) {
    el = el || document;
    return el.querySelectorAll(selector);
  }

  function remove(el) {
    el.parentNode && el.parentNode.removeChild(el);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    }
  }

  function _typeof$1(obj) {
    if (typeof Symbol === "function" && _typeof(Symbol.iterator) === "symbol") {
      _typeof$1 = function _typeof$1(obj) {
        return _typeof(obj);
      };
    } else {
      _typeof$1 = function _typeof$1(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof(obj);
      };
    }

    return _typeof$1(obj);
  }

  function _classCallCheck$1(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$1(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$1(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$1(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$1(Constructor, staticProps);
    return Constructor;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }
  var DEFAULT_CONTAINER_OPTIONS = {
    width: '100%',
    height: '100%',
    position: 'relative'
  };
  /**
   * The base class for DMN viewers and editors.
   *
   * @abstract
   */

  var Manager =
  /*#__PURE__*/
  function () {
    /**
     * Create a new instance with the given options.
     *
     * @param  {Object} options
     *
     * @return {Manager}
     */
    function Manager() {
      var _this = this;

      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _classCallCheck$1(this, Manager);

      _defineProperty(this, "_viewsChanged", function () {
        _this._emit('views.changed', {
          views: _this._views,
          activeView: _this._activeView
        });
      });

      this._eventBus = new EventBus();
      this._viewsChanged = debounce(this._viewsChanged, 0);
      this._views = [];
      this._viewers = {};

      this._init(options);
    }
    /**
     * Parse and render a DMN diagram.
     *
     * Once finished the viewer reports back the result to the
     * provided callback function with (err, warnings).
     *
     * ## Life-Cycle Events
     *
     * During import the viewer will fire life-cycle events:
     *
     *   * import.parse.start (about to read model from xml)
     *   * import.parse.complete (model read; may have worked or not)
     *   * import.render.start (graphical import start)
     *   * import.render.complete (graphical import finished)
     *   * import.done (everything done)
     *
     * You can use these events to hook into the life-cycle.
     *
     * @param {string} xml the DMN xml
     * @param {Object} [options]
     * @param {boolean} [options.open=true]
     * @param {Function} [done] invoked with (err, warnings=[])
     */


    _createClass$1(Manager, [{
      key: "importXML",
      value: function importXML(xml, options, done) {
        var _this2 = this;

        if (_typeof$1(options) !== 'object') {
          done = options;
          options = {
            open: true
          };
        }

        if (typeof done !== 'function') {
          done = noop;
        } // hook in pre-parse listeners +
        // allow xml manipulation


        xml = this._emit('import.parse.start', {
          xml: xml
        }) || xml;

        this._moddle.fromXML(xml, 'dmn:Definitions', function (err, definitions, context) {
          // hook in post parse listeners +
          // allow definitions manipulation
          definitions = _this2._emit('import.parse.complete', {
            error: err,
            definitions: definitions,
            context: context
          }) || definitions;
          var parseWarnings = context.warnings;

          _this2._setDefinitions(definitions);

          if (err) {
            err = checkDMNCompatibilityError(err, xml) || checkValidationError(err) || err;
          }

          if (err || !options.open) {
            _this2._emit('import.done', {
              error: err,
              warmings: parseWarnings
            });

            return done(err, parseWarnings);
          }

          var view = _this2._activeView || _this2._getInitialView(_this2._views);

          if (!view) {
            return done(new Error('no displayable contents'));
          }

          _this2.open(view, function (err, warnings) {
            var allWarnings = [].concat(parseWarnings, warnings || []);

            _this2._emit('import.done', {
              error: err,
              warnings: allWarnings
            });

            done(err, allWarnings);
          });
        });
      }
    }, {
      key: "getDefinitions",
      value: function getDefinitions() {
        return this._definitions;
      }
      /**
       * Return active view.
       *
       * @return {View}
       */

    }, {
      key: "getActiveView",
      value: function getActiveView() {
        return this._activeView;
      }
      /**
       * Get the currently active viewer instance.
       *
       * @return {View}
       */

    }, {
      key: "getActiveViewer",
      value: function getActiveViewer() {
        var activeView = this.getActiveView();
        return activeView && this._getViewer(activeView);
      }
    }, {
      key: "getView",
      value: function getView(element) {
        return this._views.filter(function (v) {
          return v.element === element;
        })[0];
      }
    }, {
      key: "getViews",
      value: function getViews() {
        return this._views;
      }
      /**
       * Export the currently displayed DMN diagram as
       * a DMN XML document.
       *
       * ## Life-Cycle Events
       *
       * During XML saving the viewer will fire life-cycle events:
       *
       *   * saveXML.start (before serialization)
       *   * saveXML.serialized (after xml generation)
       *   * saveXML.done (everything done)
       *
       * You can use these events to hook into the life-cycle.
       *
       * @param {Object} [options] export options
       * @param {boolean} [options.format=false] output formated XML
       * @param {boolean} [options.preamble=true] output preamble
       * @param {Function} done invoked with (err, xml)
       */

    }, {
      key: "saveXML",
      value: function saveXML(options, done) {
        var _this3 = this;

        if (typeof options === 'function') {
          done = options;
          options = {};
        }

        var definitions = this._definitions;

        if (!definitions) {
          return done(new Error('no definitions loaded'));
        } // allow to fiddle around with definitions


        definitions = this._emit('saveXML.start', {
          definitions: definitions
        }) || definitions;

        this._moddle.toXML(definitions, options, function (err, xml) {
          try {
            xml = _this3._emit('saveXML.serialized', {
              error: err,
              xml: xml
            }) || xml;

            _this3._emit('saveXML.done', {
              error: err,
              xml: xml
            });
          } catch (e) {
            console.error('error in saveXML life-cycle listener', e);
          }

          done(err, xml);
        });
      }
      /**
       * Register an event listener
       *
       * Remove a previously added listener via {@link #off(event, callback)}.
       *
       * @param {string} event
       * @param {number} [priority]
       * @param {Function} callback
       * @param {Object} [that]
       */

    }, {
      key: "on",
      value: function on() {
        var _this$_eventBus;

        (_this$_eventBus = this._eventBus).on.apply(_this$_eventBus, arguments);
      }
      /**
       * De-register an event listener
       *
       * @param {string} event
       * @param {Function} callback
       */

    }, {
      key: "off",
      value: function off() {
        var _this$_eventBus2;

        (_this$_eventBus2 = this._eventBus).off.apply(_this$_eventBus2, arguments);
      }
      /**
       * Register a listener to be invoked once only.
       *
       * @param {string} event
       * @param {number} [priority]
       * @param {Function} callback
       * @param {Object} [that]
       */

    }, {
      key: "once",
      value: function once() {
        var _this$_eventBus3;

        (_this$_eventBus3 = this._eventBus).once.apply(_this$_eventBus3, arguments);
      }
    }, {
      key: "attachTo",
      value: function attachTo(parentNode) {
        // unwrap jQuery if provided
        if (parentNode.get && parentNode.constructor.prototype.jquery) {
          parentNode = parentNode.get(0);
        }

        if (typeof parentNode === 'string') {
          parentNode = query(parentNode);
        }

        parentNode.appendChild(this._container);

        this._emit('attach', {});
      }
    }, {
      key: "detach",
      value: function detach() {
        this._emit('detach', {});

        remove(this._container);
      }
    }, {
      key: "destroy",
      value: function destroy() {
        var _this4 = this;

        Object.keys(this._viewers).forEach(function (viewerId) {
          var viewer = _this4._viewers[viewerId];
          safeExecute(viewer, 'destroy');
        });
        remove(this._container);
      }
    }, {
      key: "_init",
      value: function _init(options) {
        this._options = options;
        this._moddle = this._createModdle(options);
        this._viewers = {};
        this._views = [];
        var container = domify('<div class="dmn-js-parent"></div>');
        var containerOptions = assign({}, DEFAULT_CONTAINER_OPTIONS, options);
        assign(container.style, {
          width: ensureUnit(containerOptions.width),
          height: ensureUnit(containerOptions.height),
          position: containerOptions.position
        });
        this._container = container;

        if (options.container) {
          this.attachTo(options.container);
        }
      }
      /**
       * Open diagram element.
       *
       * @param  {ModdleElement}   element
       * @param  {Function} [done]
       */

    }, {
      key: "open",
      value: function open(view) {
        var done = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;

        this._switchView(view, done);
      }
    }, {
      key: "_setDefinitions",
      value: function _setDefinitions(definitions) {
        this._definitions = definitions;

        this._updateViews();
      }
    }, {
      key: "_updateViews",

      /**
       * Recompute changed views after elements in
       * the DMN diagram have changed.
       */
      value: function _updateViews() {
        var definitions = this._definitions;

        if (!definitions) {
          this._views = [];

          this._switchView(null);

          return;
        }

        var viewProviders = this._getViewProviders();

        var displayableElements = [definitions].concat(_toConsumableArray(definitions.drgElement || [])); // compute list of available views

        var views = this._views,
            newViews = [];
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = displayableElements[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var element = _step.value;
            var provider = find(viewProviders, function (provider) {
              if (typeof provider.opens === 'string') {
                return provider.opens === element.$type;
              } else {
                return provider.opens(element);
              }
            });

            if (!provider) {
              continue;
            }

            var view = {
              element: element,
              id: element.id,
              name: element.name,
              type: provider.id
            };
            newViews.push(view);
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator["return"] != null) {
              _iterator["return"]();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }

        var activeView = this._activeView,
            newActiveView;

        if (activeView) {
          // check the new active view
          newActiveView = find(newViews, function (view) {
            return viewsEqual(activeView, view);
          }) || this._getInitialView(newViews);

          if (!newActiveView) {
            return this._switchView(null);
          }
        } // Views have changed if
        // active view has changed OR
        // number of views has changed OR
        // not all views equal


        var activeViewChanged = !viewsEqual(activeView, newActiveView) || viewNameChanged(activeView, newActiveView);
        var viewsChanged = views.length !== newViews.length || !every(newViews, function (newView) {
          return find(views, function (view) {
            return viewsEqual(view, newView) && !viewNameChanged(view, newView);
          });
        });
        this._activeView = newActiveView;
        this._views = newViews;

        if (activeViewChanged || viewsChanged) {
          this._viewsChanged();
        }
      }
    }, {
      key: "_getInitialView",
      value: function _getInitialView(views) {
        return views[0];
      }
      /**
       * Switch to another view.
       *
       * @param  {View} newView
       * @param  {Function} [done]
       */

    }, {
      key: "_switchView",
      value: function _switchView(newView) {
        var _this5 = this;

        var done = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;

        var complete = function complete(err, warnings) {
          _this5._viewsChanged();

          done(err, warnings);
        };

        var activeView = this.getActiveView(),
            activeViewer;

        var newViewer = newView && this._getViewer(newView),
            element = newView && newView.element;

        if (activeView) {
          activeViewer = this._getViewer(activeView);

          if (activeViewer !== newViewer) {
            safeExecute(activeViewer, 'clear');
            activeViewer.detach();
          }
        }

        this._activeView = newView;

        if (newViewer) {
          if (activeViewer !== newViewer) {
            newViewer.attachTo(this._container);
          }

          this._emit('import.render.start', {
            view: newView,
            element: element
          });

          return newViewer.open(element, function (err, warnings) {
            _this5._emit('import.render.complete', {
              view: newView,
              error: err,
              warnings: warnings
            });

            complete(err, warnings);
          });
        } // no active view


        complete();
      }
    }, {
      key: "_getViewer",
      value: function _getViewer(view) {
        var type = view.type;
        var viewer = this._viewers[type];

        if (!viewer) {
          viewer = this._viewers[type] = this._createViewer(view.type);

          this._emit('viewer.created', {
            type: type,
            viewer: viewer
          });
        }

        return viewer;
      }
    }, {
      key: "_createViewer",
      value: function _createViewer(id) {
        var provider = find(this._getViewProviders(), function (provider) {
          return provider.id === id;
        });

        if (!provider) {
          throw new Error('no provider for view type <' + id + '>');
        }

        var Viewer = provider.constructor;
        var providerOptions = this._options[id] || {};
        var commonOptions = this._options.common || {};
        return new Viewer(_objectSpread({}, commonOptions, {}, providerOptions, {
          additionalModules: [].concat(_toConsumableArray(providerOptions.additionalModules || []), [{
            _parent: ['value', this],
            moddle: ['value', this._moddle]
          }])
        }));
      }
      /**
       * Emit an event.
       */

    }, {
      key: "_emit",
      value: function _emit() {
        var _this$_eventBus4;

        return (_this$_eventBus4 = this._eventBus).fire.apply(_this$_eventBus4, arguments);
      }
    }, {
      key: "_createModdle",
      value: function _createModdle(options) {
        return new simple(assign({
          camunda: CamundaModdle
        }, options.moddleExtensions));
      }
      /**
       * Return the list of available view providers.
       *
       * @abstract
       *
       * @return {Array<ViewProvider>}
       */

    }, {
      key: "_getViewProviders",
      value: function _getViewProviders() {
        return [];
      }
    }]);

    return Manager;
  }(); // helpers //////////////////////

  function noop() {}
  /**
   * Ensure the passed argument is a proper unit (defaulting to px)
   */


  function ensureUnit(val) {
    return val + (isNumber(val) ? 'px' : '');
  }

  function checkDMNCompatibilityError(err, xml) {
    // check if we can indicate opening of old DMN 1.1 or DMN 1.2 diagrams
    if (err.message !== 'failed to parse document as <dmn:Definitions>') {
      return null;
    }

    var olderDMNVersion = xml.indexOf('"http://www.omg.org/spec/DMN/20151101/dmn.xsd"') !== -1 && '1.1' || xml.indexOf('"http://www.omg.org/spec/DMN/20180521/MODEL/"') !== -1 && '1.2';

    if (!olderDMNVersion) {
      return null;
    }

    err = new Error('unsupported DMN ' + olderDMNVersion + ' file detected; ' + 'only DMN 1.3 files can be opened');
    console.error('Cannot open what looks like a DMN ' + olderDMNVersion + ' diagram. ' + 'Please refer to https://bpmn.io/l/dmn-compatibility.html ' + 'to learn how to make the toolkit compatible with older DMN files', err);
    return err;
  }

  function checkValidationError(err) {
    // check if we can help the user by indicating wrong DMN 1.3 xml
    // (in case he or the exporting tool did not get that right)
    var pattern = /unparsable content <([^>]+)> detected([\s\S]*)$/,
        match = pattern.exec(err.message);

    if (!match) {
      return null;
    }

    err.message = 'unparsable content <' + match[1] + '> detected; ' + 'this may indicate an invalid DMN 1.3 diagram file' + match[2];
    return err;
  }

  function viewsEqual(a, b) {
    if (!isDefined(a)) {
      if (!isDefined(b)) {
        return true;
      } else {
        return false;
      }
    }

    if (!isDefined(b)) {
      return false;
    } // compare by element OR element ID equality


    return a.element === b.element || a.id === b.id;
  }

  function viewNameChanged(a, b) {
    return !a || !b || a.name !== b.name;
  }

  function safeExecute(viewer, method) {
    if (isFunction(viewer[method])) {
      viewer[method]();
    }
  }

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var hat_1 = createCommonjsModule(function (module) {
    var hat = module.exports = function (bits, base) {
      if (!base) base = 16;
      if (bits === undefined) bits = 128;
      if (bits <= 0) return '0';
      var digits = Math.log(Math.pow(2, bits)) / Math.log(base);

      for (var i = 2; digits === Infinity; i *= 2) {
        digits = Math.log(Math.pow(2, bits / i)) / Math.log(base) * i;
      }

      var rem = digits - Math.floor(digits);
      var res = '';

      for (var i = 0; i < Math.floor(digits); i++) {
        var x = Math.floor(Math.random() * base).toString(base);
        res = x + res;
      }

      if (rem) {
        var b = Math.pow(base, rem);
        var x = Math.floor(Math.random() * b).toString(base);
        res = x + res;
      }

      var parsed = parseInt(res, base);

      if (parsed !== Infinity && parsed >= Math.pow(2, bits)) {
        return hat(bits, base);
      } else return res;
    };

    hat.rack = function (bits, base, expandBy) {
      var fn = function fn(data) {
        var iters = 0;

        do {
          if (iters++ > 10) {
            if (expandBy) bits += expandBy;else throw new Error('too many ID collisions, use more bits');
          }

          var id = hat(bits, base);
        } while (Object.hasOwnProperty.call(hats, id));

        hats[id] = data;
        return id;
      };

      var hats = fn.hats = {};

      fn.get = function (id) {
        return fn.hats[id];
      };

      fn.set = function (id, value) {
        fn.hats[id] = value;
        return fn;
      };

      fn.bits = bits || 128;
      fn.base = base || 16;
      return fn;
    };
  });

  /**
   * Create a new id generator / cache instance.
   *
   * You may optionally provide a seed that is used internally.
   *
   * @param {Seed} seed
   */


  function Ids(seed) {
    if (!(this instanceof Ids)) {
      return new Ids(seed);
    }

    seed = seed || [128, 36, 1];
    this._seed = seed.length ? hat_1.rack(seed[0], seed[1], seed[2]) : seed;
  }

  var ids = Ids;
  /**
   * Generate a next id.
   *
   * @param {Object} [element] element to bind the id to
   *
   * @return {String} id
   */

  Ids.prototype.next = function (element) {
    return this._seed(element || true);
  };
  /**
   * Generate a next id with a given prefix.
   *
   * @param {Object} [element] element to bind the id to
   *
   * @return {String} id
   */


  Ids.prototype.nextPrefixed = function (prefix, element) {
    var id;

    do {
      id = prefix + this.next(true);
    } while (this.assigned(id)); // claim {prefix}{random}


    this.claim(id, element); // return

    return id;
  };
  /**
   * Manually claim an existing id.
   *
   * @param {String} id
   * @param {String} [element] element the id is claimed by
   */


  Ids.prototype.claim = function (id, element) {
    this._seed.set(id, element || true);
  };
  /**
   * Returns true if the given id has already been assigned.
   *
   * @param  {String} id
   * @return {Boolean}
   */


  Ids.prototype.assigned = function (id) {
    return this._seed.get(id) || false;
  };
  /**
   * Unclaim an id.
   *
   * @param  {String} id the id to unclaim
   */


  Ids.prototype.unclaim = function (id) {
    delete this._seed.hats[id];
  };
  /**
   * Clear all claimed ids.
   */


  Ids.prototype.clear = function () {
    var hats = this._seed.hats,
        id;

    for (id in hats) {
      this.unclaim(id);
    }
  };

  /**
   * Is an element of the given DMN type?
   *
   * @param  {tjs.model.Base|ModdleElement} element
   * @param  {string} type
   *
   * @return {boolean}
   */

  function is(element, type) {
    var bo = getBusinessObject(element);
    return bo && typeof bo.$instanceOf === 'function' && bo.$instanceOf(type);
  }
  function isInput(element) {
    return is(element, 'dmn:InputClause');
  }
  function isOutput(element) {
    return is(element, 'dmn:OutputClause');
  }
  /**
   * Return the business object for a given element.
   *
   * @param  {tjs.model.Base|ModdleElement} element
   *
   * @return {ModdleElement}
   */

  function getBusinessObject(element) {
    return element && element.businessObject || element;
  }
  function getName(element) {
    return getBusinessObject(element).name;
  }
  /**
   * Return true if element has any of the given types.
   *
   * @param {djs.model.Base} element
   * @param {Array<string>} types
   *
   * @return {boolean}
   */

  function isAny(element, types) {
    return some(types, function (t) {
      return is(element, t);
    });
  }

  function _typeof$2(obj) {
    if (typeof Symbol === "function" && _typeof(Symbol.iterator) === "symbol") {
      _typeof$2 = function _typeof$1(obj) {
        return _typeof(obj);
      };
    } else {
      _typeof$2 = function _typeof$1(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof(obj);
      };
    }

    return _typeof$2(obj);
  }

  function _classCallCheck$2(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$2(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$2(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$2(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$2(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$1(self, call) {
    if (call && (_typeof$2(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$1(self);
  }

  function _assertThisInitialized$1(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);

        if (!base) return;
        var desc = Object.getOwnPropertyDescriptor(base, property);

        if (desc.get) {
          return desc.get.call(receiver);
        }

        return desc.value;
      };
    }

    return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf$1(object);
      if (object === null) break;
    }

    return object;
  }

  function _getPrototypeOf$1(o) {
    _getPrototypeOf$1 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$1(o);
  }

  function _inherits$1(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$1(subClass, superClass);
  }

  function _setPrototypeOf$1(o, p) {
    _setPrototypeOf$1 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$1(o, p);
  }

  var EditingManager =
  /*#__PURE__*/
  function (_Manager) {
    _inherits$1(EditingManager, _Manager);

    function EditingManager() {
      _classCallCheck$2(this, EditingManager);

      return _possibleConstructorReturn$1(this, _getPrototypeOf$1(EditingManager).apply(this, arguments));
    }

    _createClass$2(EditingManager, [{
      key: "_init",
      value: function _init(options) {
        var _this = this;

        _get(_getPrototypeOf$1(EditingManager.prototype), "_init", this).call(this, options); // hook ID collection into the modeler


        this.on('import.parse.complete', function (event) {
          if (!event.error) {
            _this._collectIds(event.definitions, event.context);
          }
        });
        this.on('destroy', function () {
          _this._moddle.ids.clear();
        });
        this.on('viewer.created', function (_ref) {
          var viewer = _ref.viewer;
          viewer.on('elements.changed', function (_ref2) {
            var elements = _ref2.elements;
            var viewsChanged = elements.some(function (e) {
              return isAny(e, ['dmn:Decision', 'dmn:Definitions']);
            });

            if (viewsChanged) {
              _this._updateViews();
            }
          });
        });
      }
      /**
       * Collect ids processed during parsing of the
       * definitions object.
       *
       * @param {ModdleElement} definitions
       * @param {Context} context
       */

    }, {
      key: "_collectIds",
      value: function _collectIds(definitions, context) {
        var moddle = definitions.$model,
            ids = moddle.ids,
            id; // remove references from previous import

        ids.clear();

        for (id in context.elementsById) {
          ids.claim(id, context.elementsById[id]);
        }
      }
    }, {
      key: "_createModdle",
      value: function _createModdle(options) {
        var moddle = _get(_getPrototypeOf$1(EditingManager.prototype), "_createModdle", this).call(this, options); // attach ids to moddle to be able to track
        // and validated ids in the DMN XML document
        // tree


        moddle.ids = new ids([32, 36, 1]);
        return moddle;
      }
    }]);

    return EditingManager;
  }(Manager);

  var inherits_browser = createCommonjsModule(function (module) {
    if (typeof Object.create === 'function') {
      // implementation from standard node.js 'util' module
      module.exports = function inherits(ctor, superCtor) {
        ctor.super_ = superCtor;
        ctor.prototype = Object.create(superCtor.prototype, {
          constructor: {
            value: ctor,
            enumerable: false,
            writable: true,
            configurable: true
          }
        });
      };
    } else {
      // old school shim for old browsers
      module.exports = function inherits(ctor, superCtor) {
        ctor.super_ = superCtor;

        var TempCtor = function TempCtor() {};

        TempCtor.prototype = superCtor.prototype;
        ctor.prototype = new TempCtor();
        ctor.prototype.constructor = ctor;
      };
    }
  });

  var CLASS_PATTERN = /^class /;

  function isClass(fn) {
    return CLASS_PATTERN.test(fn.toString());
  }

  function isArray$1(obj) {
    return Object.prototype.toString.call(obj) === '[object Array]';
  }

  function hasOwnProp(obj, prop) {
    return Object.prototype.hasOwnProperty.call(obj, prop);
  }

  function annotate() {
    var args = Array.prototype.slice.call(arguments);

    if (args.length === 1 && isArray$1(args[0])) {
      args = args[0];
    }

    var fn = args.pop();
    fn.$inject = args;
    return fn;
  } // Current limitations:
  // - can't put into "function arg" comments
  // function /* (no parenthesis like this) */ (){}
  // function abc( /* xx (no parenthesis like this) */ a, b) {}
  //
  // Just put the comment before function or inside:
  // /* (((this is fine))) */ function(a, b) {}
  // function abc(a) { /* (((this is fine))) */}
  //
  // - can't reliably auto-annotate constructor; we'll match the
  // first constructor(...) pattern found which may be the one
  // of a nested class, too.


  var CONSTRUCTOR_ARGS = /constructor\s*[^(]*\(\s*([^)]*)\)/m;
  var FN_ARGS = /^(?:async )?(?:function\s*)?[^(]*\(\s*([^)]*)\)/m;
  var FN_ARG = /\/\*([^*]*)\*\//m;

  function parseAnnotations(fn) {
    if (typeof fn !== 'function') {
      throw new Error('Cannot annotate "' + fn + '". Expected a function!');
    }

    var match = fn.toString().match(isClass(fn) ? CONSTRUCTOR_ARGS : FN_ARGS); // may parse class without constructor

    if (!match) {
      return [];
    }

    return match[1] && match[1].split(',').map(function (arg) {
      match = arg.match(FN_ARG);
      return match ? match[1].trim() : arg.trim();
    }) || [];
  }

  function Module() {
    var providers = [];

    this.factory = function (name, factory) {
      providers.push([name, 'factory', factory]);
      return this;
    };

    this.value = function (name, value) {
      providers.push([name, 'value', value]);
      return this;
    };

    this.type = function (name, type) {
      providers.push([name, 'type', type]);
      return this;
    };

    this.forEach = function (iterator) {
      providers.forEach(iterator);
    };
  }

  function Injector(modules, parent) {
    parent = parent || {
      get: function get(name, strict) {
        currentlyResolving.push(name);

        if (strict === false) {
          return null;
        } else {
          throw error('No provider for "' + name + '"!');
        }
      }
    };
    var currentlyResolving = [];
    var providers = this._providers = Object.create(parent._providers || null);
    var instances = this._instances = Object.create(null);
    var self = instances.injector = this;

    var error = function error(msg) {
      var stack = currentlyResolving.join(' -> ');
      currentlyResolving.length = 0;
      return new Error(stack ? msg + ' (Resolving: ' + stack + ')' : msg);
    };
    /**
     * Return a named service.
     *
     * @param {String} name
     * @param {Boolean} [strict=true] if false, resolve missing services to null
     *
     * @return {Object}
     */


    var get = function get(name, strict) {
      if (!providers[name] && name.indexOf('.') !== -1) {
        var parts = name.split('.');
        var pivot = get(parts.shift());

        while (parts.length) {
          pivot = pivot[parts.shift()];
        }

        return pivot;
      }

      if (hasOwnProp(instances, name)) {
        return instances[name];
      }

      if (hasOwnProp(providers, name)) {
        if (currentlyResolving.indexOf(name) !== -1) {
          currentlyResolving.push(name);
          throw error('Cannot resolve circular dependency!');
        }

        currentlyResolving.push(name);
        instances[name] = providers[name][0](providers[name][1]);
        currentlyResolving.pop();
        return instances[name];
      }

      return parent.get(name, strict);
    };

    var fnDef = function fnDef(fn, locals) {
      if (typeof locals === 'undefined') {
        locals = {};
      }

      if (typeof fn !== 'function') {
        if (isArray$1(fn)) {
          fn = annotate(fn.slice());
        } else {
          throw new Error('Cannot invoke "' + fn + '". Expected a function!');
        }
      }

      var inject = fn.$inject || parseAnnotations(fn);
      var dependencies = inject.map(function (dep) {
        if (hasOwnProp(locals, dep)) {
          return locals[dep];
        } else {
          return get(dep);
        }
      });
      return {
        fn: fn,
        dependencies: dependencies
      };
    };

    var instantiate = function instantiate(Type) {
      var def = fnDef(Type);
      var fn = def.fn,
          dependencies = def.dependencies; // instantiate var args constructor

      var Constructor = Function.prototype.bind.apply(fn, [null].concat(dependencies));
      return new Constructor();
    };

    var invoke = function invoke(func, context, locals) {
      var def = fnDef(func, locals);
      var fn = def.fn,
          dependencies = def.dependencies;
      return fn.apply(context, dependencies);
    };

    var createPrivateInjectorFactory = function createPrivateInjectorFactory(privateChildInjector) {
      return annotate(function (key) {
        return privateChildInjector.get(key);
      });
    };

    var createChild = function createChild(modules, forceNewInstances) {
      if (forceNewInstances && forceNewInstances.length) {
        var fromParentModule = Object.create(null);
        var matchedScopes = Object.create(null);
        var privateInjectorsCache = [];
        var privateChildInjectors = [];
        var privateChildFactories = [];
        var provider;
        var cacheIdx;
        var privateChildInjector;
        var privateChildInjectorFactory;

        for (var name in providers) {
          provider = providers[name];

          if (forceNewInstances.indexOf(name) !== -1) {
            if (provider[2] === 'private') {
              cacheIdx = privateInjectorsCache.indexOf(provider[3]);

              if (cacheIdx === -1) {
                privateChildInjector = provider[3].createChild([], forceNewInstances);
                privateChildInjectorFactory = createPrivateInjectorFactory(privateChildInjector);
                privateInjectorsCache.push(provider[3]);
                privateChildInjectors.push(privateChildInjector);
                privateChildFactories.push(privateChildInjectorFactory);
                fromParentModule[name] = [privateChildInjectorFactory, name, 'private', privateChildInjector];
              } else {
                fromParentModule[name] = [privateChildFactories[cacheIdx], name, 'private', privateChildInjectors[cacheIdx]];
              }
            } else {
              fromParentModule[name] = [provider[2], provider[1]];
            }

            matchedScopes[name] = true;
          }

          if ((provider[2] === 'factory' || provider[2] === 'type') && provider[1].$scope) {
            /* jshint -W083 */
            forceNewInstances.forEach(function (scope) {
              if (provider[1].$scope.indexOf(scope) !== -1) {
                fromParentModule[name] = [provider[2], provider[1]];
                matchedScopes[scope] = true;
              }
            });
          }
        }

        forceNewInstances.forEach(function (scope) {
          if (!matchedScopes[scope]) {
            throw new Error('No provider for "' + scope + '". Cannot use provider from the parent!');
          }
        });
        modules.unshift(fromParentModule);
      }

      return new Injector(modules, self);
    };

    var factoryMap = {
      factory: invoke,
      type: instantiate,
      value: function value(_value) {
        return _value;
      }
    };
    modules.forEach(function (module) {
      function arrayUnwrap(type, value) {
        if (type !== 'value' && isArray$1(value)) {
          value = annotate(value.slice());
        }

        return value;
      } // TODO(vojta): handle wrong inputs (modules)


      if (module instanceof Module) {
        module.forEach(function (provider) {
          var name = provider[0];
          var type = provider[1];
          var value = provider[2];
          providers[name] = [factoryMap[type], arrayUnwrap(type, value), type];
        });
      } else if (_typeof(module) === 'object') {
        if (module.__exports__) {
          var clonedModule = Object.keys(module).reduce(function (m, key) {
            if (key.substring(0, 2) !== '__') {
              m[key] = module[key];
            }

            return m;
          }, Object.create(null));
          var privateInjector = new Injector((module.__modules__ || []).concat([clonedModule]), self);
          var getFromPrivateInjector = annotate(function (key) {
            return privateInjector.get(key);
          });

          module.__exports__.forEach(function (key) {
            providers[key] = [getFromPrivateInjector, key, 'private', privateInjector];
          });
        } else {
          Object.keys(module).forEach(function (name) {
            if (module[name][2] === 'private') {
              providers[name] = module[name];
              return;
            }

            var type = module[name][0];
            var value = module[name][1];
            providers[name] = [factoryMap[type], arrayUnwrap(type, value), type];
          });
        }
      }
    }); // public API

    this.get = get;
    this.invoke = invoke;
    this.instantiate = instantiate;
    this.createChild = createChild;
  }

  var inherits_browser$1 = createCommonjsModule(function (module) {
    if (typeof Object.create === 'function') {
      // implementation from standard node.js 'util' module
      module.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          ctor.prototype = Object.create(superCtor.prototype, {
            constructor: {
              value: ctor,
              enumerable: false,
              writable: true,
              configurable: true
            }
          });
        }
      };
    } else {
      // old school shim for old browsers
      module.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;

          var TempCtor = function TempCtor() {};

          TempCtor.prototype = superCtor.prototype;
          ctor.prototype = new TempCtor();
          ctor.prototype.constructor = ctor;
        }
      };
    }
  });

  var DEFAULT_RENDER_PRIORITY = 1000;
  /**
   * The base implementation of shape and connection renderers.
   *
   * @param {EventBus} eventBus
   * @param {number} [renderPriority=1000]
   */

  function BaseRenderer(eventBus, renderPriority) {
    var self = this;
    renderPriority = renderPriority || DEFAULT_RENDER_PRIORITY;
    eventBus.on(['render.shape', 'render.connection'], renderPriority, function (evt, context) {
      var type = evt.type,
          element = context.element,
          visuals = context.gfx;

      if (self.canRender(element)) {
        if (type === 'render.shape') {
          return self.drawShape(visuals, element);
        } else {
          return self.drawConnection(visuals, element);
        }
      }
    });
    eventBus.on(['render.getShapePath', 'render.getConnectionPath'], renderPriority, function (evt, element) {
      if (self.canRender(element)) {
        if (evt.type === 'render.getShapePath') {
          return self.getShapePath(element);
        } else {
          return self.getConnectionPath(element);
        }
      }
    });
  }
  /**
   * Should check whether *this* renderer can render
   * the element/connection.
   *
   * @param {element} element
   *
   * @returns {boolean}
   */

  BaseRenderer.prototype.canRender = function () {};
  /**
   * Provides the shape's snap svg element to be drawn on the `canvas`.
   *
   * @param {djs.Graphics} visuals
   * @param {Shape} shape
   *
   * @returns {Snap.svg} [returns a Snap.svg paper element ]
   */


  BaseRenderer.prototype.drawShape = function () {};
  /**
   * Provides the shape's snap svg element to be drawn on the `canvas`.
   *
   * @param {djs.Graphics} visuals
   * @param {Connection} connection
   *
   * @returns {Snap.svg} [returns a Snap.svg paper element ]
   */


  BaseRenderer.prototype.drawConnection = function () {};
  /**
   * Gets the SVG path of a shape that represents it's visual bounds.
   *
   * @param {Shape} shape
   *
   * @return {string} svg path
   */


  BaseRenderer.prototype.getShapePath = function () {};
  /**
   * Gets the SVG path of a connection that represents it's visual bounds.
   *
   * @param {Connection} connection
   *
   * @return {string} svg path
   */


  BaseRenderer.prototype.getConnectionPath = function () {};

  function ensureImported(element, target) {
    if (element.ownerDocument !== target.ownerDocument) {
      try {
        // may fail on webkit
        return target.ownerDocument.importNode(element, true);
      } catch (e) {// ignore
      }
    }

    return element;
  }
  /**
   * appendTo utility
   */

  /**
   * Append a node to a target element and return the appended node.
   *
   * @param  {SVGElement} element
   * @param  {SVGElement} target
   *
   * @return {SVGElement} the appended node
   */


  function appendTo(element, target) {
    return target.appendChild(ensureImported(element, target));
  }
  /**
   * append utility
   */

  /**
   * Append a node to an element
   *
   * @param  {SVGElement} element
   * @param  {SVGElement} node
   *
   * @return {SVGElement} the element
   */


  function append(target, node) {
    appendTo(node, target);
    return target;
  }
  /**
   * attribute accessor utility
   */


  var LENGTH_ATTR = 2;
  var CSS_PROPERTIES = {
    'alignment-baseline': 1,
    'baseline-shift': 1,
    'clip': 1,
    'clip-path': 1,
    'clip-rule': 1,
    'color': 1,
    'color-interpolation': 1,
    'color-interpolation-filters': 1,
    'color-profile': 1,
    'color-rendering': 1,
    'cursor': 1,
    'direction': 1,
    'display': 1,
    'dominant-baseline': 1,
    'enable-background': 1,
    'fill': 1,
    'fill-opacity': 1,
    'fill-rule': 1,
    'filter': 1,
    'flood-color': 1,
    'flood-opacity': 1,
    'font': 1,
    'font-family': 1,
    'font-size': LENGTH_ATTR,
    'font-size-adjust': 1,
    'font-stretch': 1,
    'font-style': 1,
    'font-variant': 1,
    'font-weight': 1,
    'glyph-orientation-horizontal': 1,
    'glyph-orientation-vertical': 1,
    'image-rendering': 1,
    'kerning': 1,
    'letter-spacing': 1,
    'lighting-color': 1,
    'marker': 1,
    'marker-end': 1,
    'marker-mid': 1,
    'marker-start': 1,
    'mask': 1,
    'opacity': 1,
    'overflow': 1,
    'pointer-events': 1,
    'shape-rendering': 1,
    'stop-color': 1,
    'stop-opacity': 1,
    'stroke': 1,
    'stroke-dasharray': 1,
    'stroke-dashoffset': 1,
    'stroke-linecap': 1,
    'stroke-linejoin': 1,
    'stroke-miterlimit': 1,
    'stroke-opacity': 1,
    'stroke-width': LENGTH_ATTR,
    'text-anchor': 1,
    'text-decoration': 1,
    'text-rendering': 1,
    'unicode-bidi': 1,
    'visibility': 1,
    'word-spacing': 1,
    'writing-mode': 1
  };

  function getAttribute(node, name) {
    if (CSS_PROPERTIES[name]) {
      return node.style[name];
    } else {
      return node.getAttributeNS(null, name);
    }
  }

  function setAttribute(node, name, value) {
    var hyphenated = name.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();
    var type = CSS_PROPERTIES[hyphenated];

    if (type) {
      // append pixel unit, unless present
      if (type === LENGTH_ATTR && typeof value === 'number') {
        value = String(value) + 'px';
      }

      node.style[hyphenated] = value;
    } else {
      node.setAttributeNS(null, name, value);
    }
  }

  function setAttributes(node, attrs) {
    var names = Object.keys(attrs),
        i,
        name;

    for (i = 0, name; name = names[i]; i++) {
      setAttribute(node, name, attrs[name]);
    }
  }
  /**
   * Gets or sets raw attributes on a node.
   *
   * @param  {SVGElement} node
   * @param  {Object} [attrs]
   * @param  {String} [name]
   * @param  {String} [value]
   *
   * @return {String}
   */


  function attr$1(node, name, value) {
    if (typeof name === 'string') {
      if (value !== undefined) {
        setAttribute(node, name, value);
      } else {
        return getAttribute(node, name);
      }
    } else {
      setAttributes(node, name);
    }

    return node;
  }
  /**
   * Clear utility
   */


  function index(arr, obj) {
    if (arr.indexOf) {
      return arr.indexOf(obj);
    }

    for (var i = 0; i < arr.length; ++i) {
      if (arr[i] === obj) {
        return i;
      }
    }

    return -1;
  }

  var re$1 = /\s+/;
  var toString$1 = Object.prototype.toString;

  function defined(o) {
    return typeof o !== 'undefined';
  }
  /**
   * Wrap `el` in a `ClassList`.
   *
   * @param {Element} el
   * @return {ClassList}
   * @api public
   */


  function classes$1(el) {
    return new ClassList$1(el);
  }

  function ClassList$1(el) {
    if (!el || !el.nodeType) {
      throw new Error('A DOM element reference is required');
    }

    this.el = el;
    this.list = el.classList;
  }
  /**
   * Add class `name` if not already present.
   *
   * @param {String} name
   * @return {ClassList}
   * @api public
   */


  ClassList$1.prototype.add = function (name) {
    // classList
    if (this.list) {
      this.list.add(name);
      return this;
    } // fallback


    var arr = this.array();
    var i = index(arr, name);

    if (!~i) {
      arr.push(name);
    }

    if (defined(this.el.className.baseVal)) {
      this.el.className.baseVal = arr.join(' ');
    } else {
      this.el.className = arr.join(' ');
    }

    return this;
  };
  /**
   * Remove class `name` when present, or
   * pass a regular expression to remove
   * any which match.
   *
   * @param {String|RegExp} name
   * @return {ClassList}
   * @api public
   */


  ClassList$1.prototype.remove = function (name) {
    if ('[object RegExp]' === toString$1.call(name)) {
      return this.removeMatching(name);
    } // classList


    if (this.list) {
      this.list.remove(name);
      return this;
    } // fallback


    var arr = this.array();
    var i = index(arr, name);

    if (~i) {
      arr.splice(i, 1);
    }

    this.el.className.baseVal = arr.join(' ');
    return this;
  };
  /**
   * Remove all classes matching `re`.
   *
   * @param {RegExp} re
   * @return {ClassList}
   * @api private
   */


  ClassList$1.prototype.removeMatching = function (re) {
    var arr = this.array();

    for (var i = 0; i < arr.length; i++) {
      if (re.test(arr[i])) {
        this.remove(arr[i]);
      }
    }

    return this;
  };
  /**
   * Toggle class `name`, can force state via `force`.
   *
   * For browsers that support classList, but do not support `force` yet,
   * the mistake will be detected and corrected.
   *
   * @param {String} name
   * @param {Boolean} force
   * @return {ClassList}
   * @api public
   */


  ClassList$1.prototype.toggle = function (name, force) {
    // classList
    if (this.list) {
      if (defined(force)) {
        if (force !== this.list.toggle(name, force)) {
          this.list.toggle(name); // toggle again to correct
        }
      } else {
        this.list.toggle(name);
      }

      return this;
    } // fallback


    if (defined(force)) {
      if (!force) {
        this.remove(name);
      } else {
        this.add(name);
      }
    } else {
      if (this.has(name)) {
        this.remove(name);
      } else {
        this.add(name);
      }
    }

    return this;
  };
  /**
   * Return an array of classes.
   *
   * @return {Array}
   * @api public
   */


  ClassList$1.prototype.array = function () {
    var className = this.el.getAttribute('class') || '';
    var str = className.replace(/^\s+|\s+$/g, '');
    var arr = str.split(re$1);

    if ('' === arr[0]) {
      arr.shift();
    }

    return arr;
  };
  /**
   * Check if class `name` is present.
   *
   * @param {String} name
   * @return {ClassList}
   * @api public
   */


  ClassList$1.prototype.has = ClassList$1.prototype.contains = function (name) {
    return this.list ? this.list.contains(name) : !!~index(this.array(), name);
  };

  function remove$1(element) {
    var parent = element.parentNode;

    if (parent) {
      parent.removeChild(element);
    }

    return element;
  }
  /**
   * Clear utility
   */

  /**
   * Removes all children from the given element
   *
   * @param  {DOMElement} element
   * @return {DOMElement} the element (for chaining)
   */


  function clear$1(element) {
    var child;

    while (child = element.firstChild) {
      remove$1(child);
    }

    return element;
  }

  function clone(element) {
    return element.cloneNode(true);
  }

  var ns = {
    svg: 'http://www.w3.org/2000/svg'
  };
  /**
   * DOM parsing utility
   */

  var SVG_START = '<svg xmlns="' + ns.svg + '"';

  function parse$1(svg) {
    var unwrap = false; // ensure we import a valid svg document

    if (svg.substring(0, 4) === '<svg') {
      if (svg.indexOf(ns.svg) === -1) {
        svg = SVG_START + svg.substring(4);
      }
    } else {
      // namespace svg
      svg = SVG_START + '>' + svg + '</svg>';
      unwrap = true;
    }

    var parsed = parseDocument(svg);

    if (!unwrap) {
      return parsed;
    }

    var fragment = document.createDocumentFragment();
    var parent = parsed.firstChild;

    while (parent.firstChild) {
      fragment.appendChild(parent.firstChild);
    }

    return fragment;
  }

  function parseDocument(svg) {
    var parser; // parse

    parser = new DOMParser();
    parser.async = false;
    return parser.parseFromString(svg, 'text/xml');
  }
  /**
   * Create utility for SVG elements
   */

  /**
   * Create a specific type from name or SVG markup.
   *
   * @param {String} name the name or markup of the element
   * @param {Object} [attrs] attributes to set on the element
   *
   * @returns {SVGElement}
   */


  function create(name, attrs) {
    var element;

    if (name.charAt(0) === '<') {
      element = parse$1(name).firstChild;
      element = document.importNode(element, true);
    } else {
      element = document.createElementNS(ns.svg, name);
    }

    if (attrs) {
      attr$1(element, attrs);
    }

    return element;
  }
  /**
   * Geometry helpers
   */
  // fake node used to instantiate svg geometry elements


  var node = create('svg');

  function extend(object, props) {
    var i,
        k,
        keys = Object.keys(props);

    for (i = 0; k = keys[i]; i++) {
      object[k] = props[k];
    }

    return object;
  }
  /**
   * Create matrix via args.
   *
   * @example
   *
   * createMatrix({ a: 1, b: 1 });
   * createMatrix();
   * createMatrix(1, 2, 0, 0, 30, 20);
   *
   * @return {SVGMatrix}
   */


  function createMatrix(a, b, c, d, e, f) {
    var matrix = node.createSVGMatrix();

    switch (arguments.length) {
      case 0:
        return matrix;

      case 1:
        return extend(matrix, a);

      case 6:
        return extend(matrix, {
          a: a,
          b: b,
          c: c,
          d: d,
          e: e,
          f: f
        });
    }
  }

  function createTransform(matrix) {
    if (matrix) {
      return node.createSVGTransformFromMatrix(matrix);
    } else {
      return node.createSVGTransform();
    }
  }
  /**
   * Serialization util
   */


  var TEXT_ENTITIES = /([&<>]{1})/g;
  var ATTR_ENTITIES = /([\n\r"]{1})/g;
  var ENTITY_REPLACEMENT = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '\''
  };

  function escape$1(str, pattern) {
    function replaceFn(match, entity) {
      return ENTITY_REPLACEMENT[entity] || entity;
    }

    return str.replace(pattern, replaceFn);
  }

  function serialize(node, output) {
    var i, len, attrMap, attrNode, childNodes;

    switch (node.nodeType) {
      // TEXT
      case 3:
        // replace special XML characters
        output.push(escape$1(node.textContent, TEXT_ENTITIES));
        break;
      // ELEMENT

      case 1:
        output.push('<', node.tagName);

        if (node.hasAttributes()) {
          attrMap = node.attributes;

          for (i = 0, len = attrMap.length; i < len; ++i) {
            attrNode = attrMap.item(i);
            output.push(' ', attrNode.name, '="', escape$1(attrNode.value, ATTR_ENTITIES), '"');
          }
        }

        if (node.hasChildNodes()) {
          output.push('>');
          childNodes = node.childNodes;

          for (i = 0, len = childNodes.length; i < len; ++i) {
            serialize(childNodes.item(i), output);
          }

          output.push('</', node.tagName, '>');
        } else {
          output.push('/>');
        }

        break;
      // COMMENT

      case 8:
        output.push('<!--', escape$1(node.nodeValue, TEXT_ENTITIES), '-->');
        break;
      // CDATA

      case 4:
        output.push('<![CDATA[', node.nodeValue, ']]>');
        break;

      default:
        throw new Error('unable to handle node ' + node.nodeType);
    }

    return output;
  }
  /**
   * innerHTML like functionality for SVG elements.
   * based on innerSVG (https://code.google.com/p/innersvg)
   */


  function set(element, svg) {
    var parsed = parse$1(svg); // clear element contents

    clear$1(element);

    if (!svg) {
      return;
    }

    if (!isFragment(parsed)) {
      // extract <svg> from parsed document
      parsed = parsed.documentElement;
    }

    var nodes = slice$1(parsed.childNodes); // import + append each node

    for (var i = 0; i < nodes.length; i++) {
      appendTo(nodes[i], element);
    }
  }

  function get(element) {
    var child = element.firstChild,
        output = [];

    while (child) {
      serialize(child, output);
      child = child.nextSibling;
    }

    return output.join('');
  }

  function isFragment(node) {
    return node.nodeName === '#document-fragment';
  }

  function innerSVG(element, svg) {
    if (svg !== undefined) {
      try {
        set(element, svg);
      } catch (e) {
        throw new Error('error parsing SVG: ' + e.message);
      }

      return element;
    } else {
      return get(element);
    }
  }

  function slice$1(arr) {
    return Array.prototype.slice.call(arr);
  }
  /**
   * transform accessor utility
   */


  function wrapMatrix(transformList, transform) {
    if (transform instanceof SVGMatrix) {
      return transformList.createSVGTransformFromMatrix(transform);
    }

    return transform;
  }

  function setTransforms(transformList, transforms) {
    var i, t;
    transformList.clear();

    for (i = 0; t = transforms[i]; i++) {
      transformList.appendItem(wrapMatrix(transformList, t));
    }
  }
  /**
   * Get or set the transforms on the given node.
   *
   * @param {SVGElement} node
   * @param  {SVGTransform|SVGMatrix|Array<SVGTransform|SVGMatrix>} [transforms]
   *
   * @return {SVGTransform} the consolidated transform
   */


  function transform(node, transforms) {
    var transformList = node.transform.baseVal;

    if (transforms) {
      if (!Array.isArray(transforms)) {
        transforms = [transforms];
      }

      setTransforms(transformList, transforms);
    }

    return transformList.consolidate();
  }

  function componentsToPath(elements) {
    return elements.join(',').replace(/,?([A-z]),?/g, '$1');
  }
  function toSVGPoints(points) {
    var result = '';

    for (var i = 0, p; p = points[i]; i++) {
      result += p.x + ',' + p.y + ' ';
    }

    return result;
  }
  function createLine(points, attrs) {
    var line = create('polyline');
    attr$1(line, {
      points: toSVGPoints(points)
    });

    if (attrs) {
      attr$1(line, attrs);
    }

    return line;
  }
  function updateLine(gfx, points) {
    attr$1(gfx, {
      points: toSVGPoints(points)
    });
    return gfx;
  }

  /**
   * Get parent elements.
   *
   * @param {Array<djs.model.base>} elements
   *
   * @returns {Array<djs.model.Base>}
   */

  function getParents(elements) {
    // find elements that are not children of any other elements
    return filter(elements, function (element) {
      return !find(elements, function (e) {
        return e !== element && getParent(element, e);
      });
    });
  }

  function getParent(element, parent) {
    if (!parent) {
      return;
    }

    if (element === parent) {
      return parent;
    }

    if (!element.parent) {
      return;
    }

    return getParent(element.parent, parent);
  }
  /**
   * Adds an element to a collection and returns true if the
   * element was added.
   *
   * @param {Array<Object>} elements
   * @param {Object} e
   * @param {boolean} unique
   */


  function add(elements, e, unique) {
    var canAdd = !unique || elements.indexOf(e) === -1;

    if (canAdd) {
      elements.push(e);
    }

    return canAdd;
  }
  /**
   * Iterate over each element in a collection, calling the iterator function `fn`
   * with (element, index, recursionDepth).
   *
   * Recurse into all elements that are returned by `fn`.
   *
   * @param  {Object|Array<Object>} elements
   * @param  {Function} fn iterator function called with (element, index, recursionDepth)
   * @param  {number} [depth] maximum recursion depth
   */

  function eachElement(elements, fn, depth) {
    depth = depth || 0;

    if (!isArray(elements)) {
      elements = [elements];
    }

    forEach(elements, function (s, i) {
      var filter = fn(s, i, depth);

      if (isArray(filter) && filter.length) {
        eachElement(filter, fn, depth + 1);
      }
    });
  }
  /**
   * Collects self + child elements up to a given depth from a list of elements.
   *
   * @param  {djs.model.Base|Array<djs.model.Base>} elements the elements to select the children from
   * @param  {boolean} unique whether to return a unique result set (no duplicates)
   * @param  {number} maxDepth the depth to search through or -1 for infinite
   *
   * @return {Array<djs.model.Base>} found elements
   */

  function selfAndChildren(elements, unique, maxDepth) {
    var result = [],
        processedChildren = [];
    eachElement(elements, function (element, i, depth) {
      add(result, element, unique);
      var children = element.children; // max traversal depth not reached yet

      if (maxDepth === -1 || depth < maxDepth) {
        // children exist && children not yet processed
        if (children && add(processedChildren, children, unique)) {
          return children;
        }
      }
    });
    return result;
  }
  /**
   * Return self + ALL children for a number of elements
   *
   * @param  {Array<djs.model.Base>} elements to query
   * @param  {boolean} allowDuplicates to allow duplicates in the result set
   *
   * @return {Array<djs.model.Base>} the collected elements
   */

  function selfAndAllChildren(elements, allowDuplicates) {
    return selfAndChildren(elements, !allowDuplicates, -1);
  }
  /**
   * Gets the the closure for all selected elements,
   * their enclosed children and connections.
   *
   * @param {Array<djs.model.Base>} elements
   * @param {boolean} [isTopLevel=true]
   * @param {Object} [existingClosure]
   *
   * @return {Object} newClosure
   */

  function getClosure(elements, isTopLevel, closure) {
    if (isUndefined(isTopLevel)) {
      isTopLevel = true;
    }

    if (isObject(isTopLevel)) {
      closure = isTopLevel;
      isTopLevel = true;
    }

    closure = closure || {};
    var allShapes = copyObject(closure.allShapes),
        allConnections = copyObject(closure.allConnections),
        enclosedElements = copyObject(closure.enclosedElements),
        enclosedConnections = copyObject(closure.enclosedConnections);
    var topLevel = copyObject(closure.topLevel, isTopLevel && groupBy(elements, function (e) {
      return e.id;
    }));

    function handleConnection(c) {
      if (topLevel[c.source.id] && topLevel[c.target.id]) {
        topLevel[c.id] = [c];
      } // not enclosed as a child, but maybe logically
      // (connecting two moved elements?)


      if (allShapes[c.source.id] && allShapes[c.target.id]) {
        enclosedConnections[c.id] = enclosedElements[c.id] = c;
      }

      allConnections[c.id] = c;
    }

    function handleElement(element) {
      enclosedElements[element.id] = element;

      if (element.waypoints) {
        // remember connection
        enclosedConnections[element.id] = allConnections[element.id] = element;
      } else {
        // remember shape
        allShapes[element.id] = element; // remember all connections

        forEach(element.incoming, handleConnection);
        forEach(element.outgoing, handleConnection); // recurse into children

        return element.children;
      }
    }

    eachElement(elements, handleElement);
    return {
      allShapes: allShapes,
      allConnections: allConnections,
      topLevel: topLevel,
      enclosedConnections: enclosedConnections,
      enclosedElements: enclosedElements
    };
  }
  /**
   * Returns the surrounding bbox for all elements in
   * the array or the element primitive.
   *
   * @param {Array<djs.model.Shape>|djs.model.Shape} elements
   * @param {boolean} stopRecursion
   */

  function getBBox(elements, stopRecursion) {
    stopRecursion = !!stopRecursion;

    if (!isArray(elements)) {
      elements = [elements];
    }

    var minX, minY, maxX, maxY;
    forEach(elements, function (element) {
      // If element is a connection the bbox must be computed first
      var bbox = element;

      if (element.waypoints && !stopRecursion) {
        bbox = getBBox(element.waypoints, true);
      }

      var x = bbox.x,
          y = bbox.y,
          height = bbox.height || 0,
          width = bbox.width || 0;

      if (x < minX || minX === undefined) {
        minX = x;
      }

      if (y < minY || minY === undefined) {
        minY = y;
      }

      if (x + width > maxX || maxX === undefined) {
        maxX = x + width;
      }

      if (y + height > maxY || maxY === undefined) {
        maxY = y + height;
      }
    });
    return {
      x: minX,
      y: minY,
      height: maxY - minY,
      width: maxX - minX
    };
  }
  /**
   * Returns all elements that are enclosed from the bounding box.
   *
   *   * If bbox.(width|height) is not specified the method returns
   *     all elements with element.x/y > bbox.x/y
   *   * If only bbox.x or bbox.y is specified, method return all elements with
   *     e.x > bbox.x or e.y > bbox.y
   *
   * @param {Array<djs.model.Shape>} elements List of Elements to search through
   * @param {djs.model.Shape} bbox the enclosing bbox.
   *
   * @return {Array<djs.model.Shape>} enclosed elements
   */

  function getEnclosedElements(elements, bbox) {
    var filteredElements = {};
    forEach(elements, function (element) {
      var e = element;

      if (e.waypoints) {
        e = getBBox(e);
      }

      if (!isNumber(bbox.y) && e.x > bbox.x) {
        filteredElements[element.id] = element;
      }

      if (!isNumber(bbox.x) && e.y > bbox.y) {
        filteredElements[element.id] = element;
      }

      if (e.x > bbox.x && e.y > bbox.y) {
        if (isNumber(bbox.width) && isNumber(bbox.height) && e.width + e.x < bbox.width + bbox.x && e.height + e.y < bbox.height + bbox.y) {
          filteredElements[element.id] = element;
        } else if (!isNumber(bbox.width) || !isNumber(bbox.height)) {
          filteredElements[element.id] = element;
        }
      }
    });
    return filteredElements;
  }
  function getType(element) {
    if ('waypoints' in element) {
      return 'connection';
    }

    if ('x' in element) {
      return 'shape';
    }

    return 'root';
  }
  function isFrameElement(element) {
    return !!(element && element.isFrame);
  } // helpers ///////////////////////////////

  function copyObject(src1, src2) {
    return assign({}, src1 || {}, src2 || {});
  }

  // so that it only kicks in if noone else could render

  var DEFAULT_RENDER_PRIORITY$1 = 1;
  /**
   * The default renderer used for shapes and connections.
   *
   * @param {EventBus} eventBus
   * @param {Styles} styles
   */

  function DefaultRenderer(eventBus, styles) {
    //
    BaseRenderer.call(this, eventBus, DEFAULT_RENDER_PRIORITY$1);
    this.CONNECTION_STYLE = styles.style(['no-fill'], {
      strokeWidth: 5,
      stroke: 'fuchsia'
    });
    this.SHAPE_STYLE = styles.style({
      fill: 'white',
      stroke: 'fuchsia',
      strokeWidth: 2
    });
    this.FRAME_STYLE = styles.style(['no-fill'], {
      stroke: 'fuchsia',
      strokeDasharray: 4,
      strokeWidth: 2
    });
  }
  inherits_browser$1(DefaultRenderer, BaseRenderer);

  DefaultRenderer.prototype.canRender = function () {
    return true;
  };

  DefaultRenderer.prototype.drawShape = function drawShape(visuals, element) {
    var rect = create('rect');
    attr$1(rect, {
      x: 0,
      y: 0,
      width: element.width || 0,
      height: element.height || 0
    });

    if (isFrameElement(element)) {
      attr$1(rect, this.FRAME_STYLE);
    } else {
      attr$1(rect, this.SHAPE_STYLE);
    }

    append(visuals, rect);
    return rect;
  };

  DefaultRenderer.prototype.drawConnection = function drawConnection(visuals, connection) {
    var line = createLine(connection.waypoints, this.CONNECTION_STYLE);
    append(visuals, line);
    return line;
  };

  DefaultRenderer.prototype.getShapePath = function getShapePath(shape) {
    var x = shape.x,
        y = shape.y,
        width = shape.width,
        height = shape.height;
    var shapePath = [['M', x, y], ['l', width, 0], ['l', 0, height], ['l', -width, 0], ['z']];
    return componentsToPath(shapePath);
  };

  DefaultRenderer.prototype.getConnectionPath = function getConnectionPath(connection) {
    var waypoints = connection.waypoints;
    var idx,
        point,
        connectionPath = [];

    for (idx = 0; point = waypoints[idx]; idx++) {
      // take invisible docking into account
      // when creating the path
      point = point.original || point;
      connectionPath.push([idx === 0 ? 'M' : 'L', point.x, point.y]);
    }

    return componentsToPath(connectionPath);
  };

  DefaultRenderer.$inject = ['eventBus', 'styles'];

  /**
   * A component that manages shape styles
   */

  function Styles() {
    var defaultTraits = {
      'no-fill': {
        fill: 'none'
      },
      'no-border': {
        strokeOpacity: 0.0
      },
      'no-events': {
        pointerEvents: 'none'
      }
    };
    var self = this;
    /**
     * Builds a style definition from a className, a list of traits and an object of additional attributes.
     *
     * @param  {string} className
     * @param  {Array<string>} traits
     * @param  {Object} additionalAttrs
     *
     * @return {Object} the style defintion
     */

    this.cls = function (className, traits, additionalAttrs) {
      var attrs = this.style(traits, additionalAttrs);
      return assign(attrs, {
        'class': className
      });
    };
    /**
     * Builds a style definition from a list of traits and an object of additional attributes.
     *
     * @param  {Array<string>} traits
     * @param  {Object} additionalAttrs
     *
     * @return {Object} the style defintion
     */


    this.style = function (traits, additionalAttrs) {
      if (!isArray(traits) && !additionalAttrs) {
        additionalAttrs = traits;
        traits = [];
      }

      var attrs = reduce(traits, function (attrs, t) {
        return assign(attrs, defaultTraits[t] || {});
      }, {});
      return additionalAttrs ? assign(attrs, additionalAttrs) : attrs;
    };

    this.computeStyle = function (custom, traits, defaultStyles) {
      if (!isArray(traits)) {
        defaultStyles = traits;
        traits = [];
      }

      return self.style(traits || [], assign({}, defaultStyles, custom || {}));
    };
  }

  var DrawModule = {
    __init__: ['defaultRenderer'],
    defaultRenderer: ['type', DefaultRenderer],
    styles: ['type', Styles]
  };

  /**
   * Failsafe remove an element from a collection
   *
   * @param  {Array<Object>} [collection]
   * @param  {Object} [element]
   *
   * @return {number} the previous index of the element
   */
  function remove$2(collection, element) {
    if (!collection || !element) {
      return -1;
    }

    var idx = collection.indexOf(element);

    if (idx !== -1) {
      collection.splice(idx, 1);
    }

    return idx;
  }
  /**
   * Fail save add an element to the given connection, ensuring
   * it does not yet exist.
   *
   * @param {Array<Object>} collection
   * @param {Object} element
   * @param {number} idx
   */

  function add$1(collection, element, idx) {
    if (!collection || !element) {
      return;
    }

    if (typeof idx !== 'number') {
      idx = -1;
    }

    var currentIdx = collection.indexOf(element);

    if (currentIdx !== -1) {
      if (currentIdx === idx) {
        // nothing to do, position has not changed
        return;
      } else {
        if (idx !== -1) {
          // remove from current position
          collection.splice(currentIdx, 1);
        } else {
          // already exists in collection
          return;
        }
      }
    }

    if (idx !== -1) {
      // insert at specified position
      collection.splice(idx, 0, element);
    } else {
      // push to end
      collection.push(element);
    }
  }
  /**
   * Fail save get the index of an element in a collection.
   *
   * @param {Array<Object>} collection
   * @param {Object} element
   *
   * @return {number} the index or -1 if collection or element do
   *                  not exist or the element is not contained.
   */

  function indexOf$1(collection, element) {
    if (!collection || !element) {
      return -1;
    }

    return collection.indexOf(element);
  }

  function round(number, resolution) {
    return Math.round(number * resolution) / resolution;
  }

  function ensurePx(number) {
    return isNumber(number) ? number + 'px' : number;
  }
  /**
   * Creates a HTML container element for a SVG element with
   * the given configuration
   *
   * @param  {Object} options
   * @return {HTMLElement} the container element
   */


  function createContainer(options) {
    options = assign({}, {
      width: '100%',
      height: '100%'
    }, options);
    var container = options.container || document.body; // create a <div> around the svg element with the respective size
    // this way we can always get the correct container size
    // (this is impossible for <svg> elements at the moment)

    var parent = document.createElement('div');
    parent.setAttribute('class', 'djs-container');
    assign(parent.style, {
      position: 'relative',
      overflow: 'hidden',
      width: ensurePx(options.width),
      height: ensurePx(options.height)
    });
    container.appendChild(parent);
    return parent;
  }

  function createGroup(parent, cls, childIndex) {
    var group = create('g');
    classes$1(group).add(cls);
    var index = childIndex !== undefined ? childIndex : parent.childNodes.length - 1; // must ensure second argument is node or _null_
    // cf. https://developer.mozilla.org/en-US/docs/Web/API/Node/insertBefore

    parent.insertBefore(group, parent.childNodes[index] || null);
    return group;
  }

  var BASE_LAYER = 'base';
  var REQUIRED_MODEL_ATTRS = {
    shape: ['x', 'y', 'width', 'height'],
    connection: ['waypoints']
  };
  /**
   * The main drawing canvas.
   *
   * @class
   * @constructor
   *
   * @emits Canvas#canvas.init
   *
   * @param {Object} config
   * @param {EventBus} eventBus
   * @param {GraphicsFactory} graphicsFactory
   * @param {ElementRegistry} elementRegistry
   */

  function Canvas(config, eventBus, graphicsFactory, elementRegistry) {
    this._eventBus = eventBus;
    this._elementRegistry = elementRegistry;
    this._graphicsFactory = graphicsFactory;

    this._init(config || {});
  }
  Canvas.$inject = ['config.canvas', 'eventBus', 'graphicsFactory', 'elementRegistry'];

  Canvas.prototype._init = function (config) {
    var eventBus = this._eventBus; // Creates a <svg> element that is wrapped into a <div>.
    // This way we are always able to correctly figure out the size of the svg element
    // by querying the parent node.
    //
    // (It is not possible to get the size of a svg element cross browser @ 2014-04-01)
    //
    // <div class="djs-container" style="width: {desired-width}, height: {desired-height}">
    //   <svg width="100%" height="100%">
    //    ...
    //   </svg>
    // </div>
    // html container

    var container = this._container = createContainer(config);
    var svg = this._svg = create('svg');
    attr$1(svg, {
      width: '100%',
      height: '100%'
    });
    append(container, svg);
    var viewport = this._viewport = createGroup(svg, 'viewport');
    this._layers = {}; // debounce canvas.viewbox.changed events
    // for smoother diagram interaction

    if (config.deferUpdate !== false) {
      this._viewboxChanged = debounce(bind(this._viewboxChanged, this), 300);
    }

    eventBus.on('diagram.init', function () {
      /**
       * An event indicating that the canvas is ready to be drawn on.
       *
       * @memberOf Canvas
       *
       * @event canvas.init
       *
       * @type {Object}
       * @property {SVGElement} svg the created svg element
       * @property {SVGElement} viewport the direct parent of diagram elements and shapes
       */
      eventBus.fire('canvas.init', {
        svg: svg,
        viewport: viewport
      });
    }, this); // reset viewbox on shape changes to
    // recompute the viewbox

    eventBus.on(['shape.added', 'connection.added', 'shape.removed', 'connection.removed', 'elements.changed'], function () {
      delete this._cachedViewbox;
    }, this);
    eventBus.on('diagram.destroy', 500, this._destroy, this);
    eventBus.on('diagram.clear', 500, this._clear, this);
  };

  Canvas.prototype._destroy = function (emit) {
    this._eventBus.fire('canvas.destroy', {
      svg: this._svg,
      viewport: this._viewport
    });

    var parent = this._container.parentNode;

    if (parent) {
      parent.removeChild(this._container);
    }

    delete this._svg;
    delete this._container;
    delete this._layers;
    delete this._rootElement;
    delete this._viewport;
  };

  Canvas.prototype._clear = function () {
    var self = this;

    var allElements = this._elementRegistry.getAll(); // remove all elements


    allElements.forEach(function (element) {
      var type = getType(element);

      if (type === 'root') {
        self.setRootElement(null, true);
      } else {
        self._removeElement(element, type);
      }
    }); // force recomputation of view box

    delete this._cachedViewbox;
  };
  /**
   * Returns the default layer on which
   * all elements are drawn.
   *
   * @returns {SVGElement}
   */


  Canvas.prototype.getDefaultLayer = function () {
    return this.getLayer(BASE_LAYER, 0);
  };
  /**
   * Returns a layer that is used to draw elements
   * or annotations on it.
   *
   * Non-existing layers retrieved through this method
   * will be created. During creation, the optional index
   * may be used to create layers below or above existing layers.
   * A layer with a certain index is always created above all
   * existing layers with the same index.
   *
   * @param {string} name
   * @param {number} index
   *
   * @returns {SVGElement}
   */


  Canvas.prototype.getLayer = function (name, index) {
    if (!name) {
      throw new Error('must specify a name');
    }

    var layer = this._layers[name];

    if (!layer) {
      layer = this._layers[name] = this._createLayer(name, index);
    } // throw an error if layer creation / retrival is
    // requested on different index


    if (typeof index !== 'undefined' && layer.index !== index) {
      throw new Error('layer <' + name + '> already created at index <' + index + '>');
    }

    return layer.group;
  };
  /**
   * Creates a given layer and returns it.
   *
   * @param {string} name
   * @param {number} [index=0]
   *
   * @return {Object} layer descriptor with { index, group: SVGGroup }
   */


  Canvas.prototype._createLayer = function (name, index) {
    if (!index) {
      index = 0;
    }

    var childIndex = reduce(this._layers, function (childIndex, layer) {
      if (index >= layer.index) {
        childIndex++;
      }

      return childIndex;
    }, 0);
    return {
      group: createGroup(this._viewport, 'layer-' + name, childIndex),
      index: index
    };
  };
  /**
   * Returns the html element that encloses the
   * drawing canvas.
   *
   * @return {DOMNode}
   */


  Canvas.prototype.getContainer = function () {
    return this._container;
  }; // markers //////////////////////


  Canvas.prototype._updateMarker = function (element, marker, add) {
    var container;

    if (!element.id) {
      element = this._elementRegistry.get(element);
    } // we need to access all


    container = this._elementRegistry._elements[element.id];

    if (!container) {
      return;
    }

    forEach([container.gfx, container.secondaryGfx], function (gfx) {
      if (gfx) {
        // invoke either addClass or removeClass based on mode
        if (add) {
          classes$1(gfx).add(marker);
        } else {
          classes$1(gfx).remove(marker);
        }
      }
    });
    /**
     * An event indicating that a marker has been updated for an element
     *
     * @event element.marker.update
     * @type {Object}
     * @property {djs.model.Element} element the shape
     * @property {Object} gfx the graphical representation of the shape
     * @property {string} marker
     * @property {boolean} add true if the marker was added, false if it got removed
     */

    this._eventBus.fire('element.marker.update', {
      element: element,
      gfx: container.gfx,
      marker: marker,
      add: !!add
    });
  };
  /**
   * Adds a marker to an element (basically a css class).
   *
   * Fires the element.marker.update event, making it possible to
   * integrate extension into the marker life-cycle, too.
   *
   * @example
   * canvas.addMarker('foo', 'some-marker');
   *
   * var fooGfx = canvas.getGraphics('foo');
   *
   * fooGfx; // <g class="... some-marker"> ... </g>
   *
   * @param {string|djs.model.Base} element
   * @param {string} marker
   */


  Canvas.prototype.addMarker = function (element, marker) {
    this._updateMarker(element, marker, true);
  };
  /**
   * Remove a marker from an element.
   *
   * Fires the element.marker.update event, making it possible to
   * integrate extension into the marker life-cycle, too.
   *
   * @param  {string|djs.model.Base} element
   * @param  {string} marker
   */


  Canvas.prototype.removeMarker = function (element, marker) {
    this._updateMarker(element, marker, false);
  };
  /**
   * Check the existence of a marker on element.
   *
   * @param  {string|djs.model.Base} element
   * @param  {string} marker
   */


  Canvas.prototype.hasMarker = function (element, marker) {
    if (!element.id) {
      element = this._elementRegistry.get(element);
    }

    var gfx = this.getGraphics(element);
    return classes$1(gfx).has(marker);
  };
  /**
   * Toggles a marker on an element.
   *
   * Fires the element.marker.update event, making it possible to
   * integrate extension into the marker life-cycle, too.
   *
   * @param  {string|djs.model.Base} element
   * @param  {string} marker
   */


  Canvas.prototype.toggleMarker = function (element, marker) {
    if (this.hasMarker(element, marker)) {
      this.removeMarker(element, marker);
    } else {
      this.addMarker(element, marker);
    }
  };

  Canvas.prototype.getRootElement = function () {
    if (!this._rootElement) {
      this.setRootElement({
        id: '__implicitroot',
        children: []
      });
    }

    return this._rootElement;
  }; // root element handling //////////////////////

  /**
   * Sets a given element as the new root element for the canvas
   * and returns the new root element.
   *
   * @param {Object|djs.model.Root} element
   * @param {boolean} [override] whether to override the current root element, if any
   *
   * @return {Object|djs.model.Root} new root element
   */


  Canvas.prototype.setRootElement = function (element, override) {
    if (element) {
      this._ensureValid('root', element);
    }

    var currentRoot = this._rootElement,
        elementRegistry = this._elementRegistry,
        eventBus = this._eventBus;

    if (currentRoot) {
      if (!override) {
        throw new Error('rootElement already set, need to specify override');
      } // simulate element remove event sequence


      eventBus.fire('root.remove', {
        element: currentRoot
      });
      eventBus.fire('root.removed', {
        element: currentRoot
      });
      elementRegistry.remove(currentRoot);
    }

    if (element) {
      var gfx = this.getDefaultLayer(); // resemble element add event sequence

      eventBus.fire('root.add', {
        element: element
      });
      elementRegistry.add(element, gfx, this._svg);
      eventBus.fire('root.added', {
        element: element,
        gfx: gfx
      });
    }

    this._rootElement = element;
    return element;
  }; // add functionality //////////////////////


  Canvas.prototype._ensureValid = function (type, element) {
    if (!element.id) {
      throw new Error('element must have an id');
    }

    if (this._elementRegistry.get(element.id)) {
      throw new Error('element with id ' + element.id + ' already exists');
    }

    var requiredAttrs = REQUIRED_MODEL_ATTRS[type];
    var valid = every(requiredAttrs, function (attr) {
      return typeof element[attr] !== 'undefined';
    });

    if (!valid) {
      throw new Error('must supply { ' + requiredAttrs.join(', ') + ' } with ' + type);
    }
  };

  Canvas.prototype._setParent = function (element, parent, parentIndex) {
    add$1(parent.children, element, parentIndex);
    element.parent = parent;
  };
  /**
   * Adds an element to the canvas.
   *
   * This wires the parent <-> child relationship between the element and
   * a explicitly specified parent or an implicit root element.
   *
   * During add it emits the events
   *
   *  * <{type}.add> (element, parent)
   *  * <{type}.added> (element, gfx)
   *
   * Extensions may hook into these events to perform their magic.
   *
   * @param {string} type
   * @param {Object|djs.model.Base} element
   * @param {Object|djs.model.Base} [parent]
   * @param {number} [parentIndex]
   *
   * @return {Object|djs.model.Base} the added element
   */


  Canvas.prototype._addElement = function (type, element, parent, parentIndex) {
    parent = parent || this.getRootElement();
    var eventBus = this._eventBus,
        graphicsFactory = this._graphicsFactory;

    this._ensureValid(type, element);

    eventBus.fire(type + '.add', {
      element: element,
      parent: parent
    });

    this._setParent(element, parent, parentIndex); // create graphics


    var gfx = graphicsFactory.create(type, element, parentIndex);

    this._elementRegistry.add(element, gfx); // update its visual


    graphicsFactory.update(type, element, gfx);
    eventBus.fire(type + '.added', {
      element: element,
      gfx: gfx
    });
    return element;
  };
  /**
   * Adds a shape to the canvas
   *
   * @param {Object|djs.model.Shape} shape to add to the diagram
   * @param {djs.model.Base} [parent]
   * @param {number} [parentIndex]
   *
   * @return {djs.model.Shape} the added shape
   */


  Canvas.prototype.addShape = function (shape, parent, parentIndex) {
    return this._addElement('shape', shape, parent, parentIndex);
  };
  /**
   * Adds a connection to the canvas
   *
   * @param {Object|djs.model.Connection} connection to add to the diagram
   * @param {djs.model.Base} [parent]
   * @param {number} [parentIndex]
   *
   * @return {djs.model.Connection} the added connection
   */


  Canvas.prototype.addConnection = function (connection, parent, parentIndex) {
    return this._addElement('connection', connection, parent, parentIndex);
  };
  /**
   * Internal remove element
   */


  Canvas.prototype._removeElement = function (element, type) {
    var elementRegistry = this._elementRegistry,
        graphicsFactory = this._graphicsFactory,
        eventBus = this._eventBus;
    element = elementRegistry.get(element.id || element);

    if (!element) {
      // element was removed already
      return;
    }

    eventBus.fire(type + '.remove', {
      element: element
    });
    graphicsFactory.remove(element); // unset parent <-> child relationship

    remove$2(element.parent && element.parent.children, element);
    element.parent = null;
    eventBus.fire(type + '.removed', {
      element: element
    });
    elementRegistry.remove(element);
    return element;
  };
  /**
   * Removes a shape from the canvas
   *
   * @param {string|djs.model.Shape} shape or shape id to be removed
   *
   * @return {djs.model.Shape} the removed shape
   */


  Canvas.prototype.removeShape = function (shape) {
    /**
     * An event indicating that a shape is about to be removed from the canvas.
     *
     * @memberOf Canvas
     *
     * @event shape.remove
     * @type {Object}
     * @property {djs.model.Shape} element the shape descriptor
     * @property {Object} gfx the graphical representation of the shape
     */

    /**
     * An event indicating that a shape has been removed from the canvas.
     *
     * @memberOf Canvas
     *
     * @event shape.removed
     * @type {Object}
     * @property {djs.model.Shape} element the shape descriptor
     * @property {Object} gfx the graphical representation of the shape
     */
    return this._removeElement(shape, 'shape');
  };
  /**
   * Removes a connection from the canvas
   *
   * @param {string|djs.model.Connection} connection or connection id to be removed
   *
   * @return {djs.model.Connection} the removed connection
   */


  Canvas.prototype.removeConnection = function (connection) {
    /**
     * An event indicating that a connection is about to be removed from the canvas.
     *
     * @memberOf Canvas
     *
     * @event connection.remove
     * @type {Object}
     * @property {djs.model.Connection} element the connection descriptor
     * @property {Object} gfx the graphical representation of the connection
     */

    /**
     * An event indicating that a connection has been removed from the canvas.
     *
     * @memberOf Canvas
     *
     * @event connection.removed
     * @type {Object}
     * @property {djs.model.Connection} element the connection descriptor
     * @property {Object} gfx the graphical representation of the connection
     */
    return this._removeElement(connection, 'connection');
  };
  /**
   * Return the graphical object underlaying a certain diagram element
   *
   * @param {string|djs.model.Base} element descriptor of the element
   * @param {boolean} [secondary=false] whether to return the secondary connected element
   *
   * @return {SVGElement}
   */


  Canvas.prototype.getGraphics = function (element, secondary) {
    return this._elementRegistry.getGraphics(element, secondary);
  };
  /**
   * Perform a viewbox update via a given change function.
   *
   * @param {Function} changeFn
   */


  Canvas.prototype._changeViewbox = function (changeFn) {
    // notify others of the upcoming viewbox change
    this._eventBus.fire('canvas.viewbox.changing'); // perform actual change


    changeFn.apply(this); // reset the cached viewbox so that
    // a new get operation on viewbox or zoom
    // triggers a viewbox re-computation

    this._cachedViewbox = null; // notify others of the change; this step
    // may or may not be debounced

    this._viewboxChanged();
  };

  Canvas.prototype._viewboxChanged = function () {
    this._eventBus.fire('canvas.viewbox.changed', {
      viewbox: this.viewbox()
    });
  };
  /**
   * Gets or sets the view box of the canvas, i.e. the
   * area that is currently displayed.
   *
   * The getter may return a cached viewbox (if it is currently
   * changing). To force a recomputation, pass `false` as the first argument.
   *
   * @example
   *
   * canvas.viewbox({ x: 100, y: 100, width: 500, height: 500 })
   *
   * // sets the visible area of the diagram to (100|100) -> (600|100)
   * // and and scales it according to the diagram width
   *
   * var viewbox = canvas.viewbox(); // pass `false` to force recomputing the box.
   *
   * console.log(viewbox);
   * // {
   * //   inner: Dimensions,
   * //   outer: Dimensions,
   * //   scale,
   * //   x, y,
   * //   width, height
   * // }
   *
   * // if the current diagram is zoomed and scrolled, you may reset it to the
   * // default zoom via this method, too:
   *
   * var zoomedAndScrolledViewbox = canvas.viewbox();
   *
   * canvas.viewbox({
   *   x: 0,
   *   y: 0,
   *   width: zoomedAndScrolledViewbox.outer.width,
   *   height: zoomedAndScrolledViewbox.outer.height
   * });
   *
   * @param  {Object} [box] the new view box to set
   * @param  {number} box.x the top left X coordinate of the canvas visible in view box
   * @param  {number} box.y the top left Y coordinate of the canvas visible in view box
   * @param  {number} box.width the visible width
   * @param  {number} box.height
   *
   * @return {Object} the current view box
   */


  Canvas.prototype.viewbox = function (box) {
    if (box === undefined && this._cachedViewbox) {
      return this._cachedViewbox;
    }

    var viewport = this._viewport,
        innerBox,
        outerBox = this.getSize(),
        matrix,
        transform$1,
        scale,
        x,
        y;

    if (!box) {
      // compute the inner box based on the
      // diagrams default layer. This allows us to exclude
      // external components, such as overlays
      innerBox = this.getDefaultLayer().getBBox();
      transform$1 = transform(viewport);
      matrix = transform$1 ? transform$1.matrix : createMatrix();
      scale = round(matrix.a, 1000);
      x = round(-matrix.e || 0, 1000);
      y = round(-matrix.f || 0, 1000);
      box = this._cachedViewbox = {
        x: x ? x / scale : 0,
        y: y ? y / scale : 0,
        width: outerBox.width / scale,
        height: outerBox.height / scale,
        scale: scale,
        inner: {
          width: innerBox.width,
          height: innerBox.height,
          x: innerBox.x,
          y: innerBox.y
        },
        outer: outerBox
      };
      return box;
    } else {
      this._changeViewbox(function () {
        scale = Math.min(outerBox.width / box.width, outerBox.height / box.height);

        var matrix = this._svg.createSVGMatrix().scale(scale).translate(-box.x, -box.y);

        transform(viewport, matrix);
      });
    }

    return box;
  };
  /**
   * Gets or sets the scroll of the canvas.
   *
   * @param {Object} [delta] the new scroll to apply.
   *
   * @param {number} [delta.dx]
   * @param {number} [delta.dy]
   */


  Canvas.prototype.scroll = function (delta) {
    var node = this._viewport;
    var matrix = node.getCTM();

    if (delta) {
      this._changeViewbox(function () {
        delta = assign({
          dx: 0,
          dy: 0
        }, delta || {});
        matrix = this._svg.createSVGMatrix().translate(delta.dx, delta.dy).multiply(matrix);
        setCTM(node, matrix);
      });
    }

    return {
      x: matrix.e,
      y: matrix.f
    };
  };
  /**
   * Gets or sets the current zoom of the canvas, optionally zooming
   * to the specified position.
   *
   * The getter may return a cached zoom level. Call it with `false` as
   * the first argument to force recomputation of the current level.
   *
   * @param {string|number} [newScale] the new zoom level, either a number, i.e. 0.9,
   *                                   or `fit-viewport` to adjust the size to fit the current viewport
   * @param {string|Point} [center] the reference point { x: .., y: ..} to zoom to, 'auto' to zoom into mid or null
   *
   * @return {number} the current scale
   */


  Canvas.prototype.zoom = function (newScale, center) {
    if (!newScale) {
      return this.viewbox(newScale).scale;
    }

    if (newScale === 'fit-viewport') {
      return this._fitViewport(center);
    }

    var outer, matrix;

    this._changeViewbox(function () {
      if (_typeof(center) !== 'object') {
        outer = this.viewbox().outer;
        center = {
          x: outer.width / 2,
          y: outer.height / 2
        };
      }

      matrix = this._setZoom(newScale, center);
    });

    return round(matrix.a, 1000);
  };

  function setCTM(node, m) {
    var mstr = 'matrix(' + m.a + ',' + m.b + ',' + m.c + ',' + m.d + ',' + m.e + ',' + m.f + ')';
    node.setAttribute('transform', mstr);
  }

  Canvas.prototype._fitViewport = function (center) {
    var vbox = this.viewbox(),
        outer = vbox.outer,
        inner = vbox.inner,
        newScale,
        newViewbox; // display the complete diagram without zooming in.
    // instead of relying on internal zoom, we perform a
    // hard reset on the canvas viewbox to realize this
    //
    // if diagram does not need to be zoomed in, we focus it around
    // the diagram origin instead

    if (inner.x >= 0 && inner.y >= 0 && inner.x + inner.width <= outer.width && inner.y + inner.height <= outer.height && !center) {
      newViewbox = {
        x: 0,
        y: 0,
        width: Math.max(inner.width + inner.x, outer.width),
        height: Math.max(inner.height + inner.y, outer.height)
      };
    } else {
      newScale = Math.min(1, outer.width / inner.width, outer.height / inner.height);
      newViewbox = {
        x: inner.x + (center ? inner.width / 2 - outer.width / newScale / 2 : 0),
        y: inner.y + (center ? inner.height / 2 - outer.height / newScale / 2 : 0),
        width: outer.width / newScale,
        height: outer.height / newScale
      };
    }

    this.viewbox(newViewbox);
    return this.viewbox(false).scale;
  };

  Canvas.prototype._setZoom = function (scale, center) {
    var svg = this._svg,
        viewport = this._viewport;
    var matrix = svg.createSVGMatrix();
    var point = svg.createSVGPoint();
    var centerPoint, originalPoint, currentMatrix, scaleMatrix, newMatrix;
    currentMatrix = viewport.getCTM();
    var currentScale = currentMatrix.a;

    if (center) {
      centerPoint = assign(point, center); // revert applied viewport transformations

      originalPoint = centerPoint.matrixTransform(currentMatrix.inverse()); // create scale matrix

      scaleMatrix = matrix.translate(originalPoint.x, originalPoint.y).scale(1 / currentScale * scale).translate(-originalPoint.x, -originalPoint.y);
      newMatrix = currentMatrix.multiply(scaleMatrix);
    } else {
      newMatrix = matrix.scale(scale);
    }

    setCTM(this._viewport, newMatrix);
    return newMatrix;
  };
  /**
   * Returns the size of the canvas
   *
   * @return {Dimensions}
   */


  Canvas.prototype.getSize = function () {
    return {
      width: this._container.clientWidth,
      height: this._container.clientHeight
    };
  };
  /**
   * Return the absolute bounding box for the given element
   *
   * The absolute bounding box may be used to display overlays in the
   * callers (browser) coordinate system rather than the zoomed in/out
   * canvas coordinates.
   *
   * @param  {ElementDescriptor} element
   * @return {Bounds} the absolute bounding box
   */


  Canvas.prototype.getAbsoluteBBox = function (element) {
    var vbox = this.viewbox();
    var bbox; // connection
    // use svg bbox

    if (element.waypoints) {
      var gfx = this.getGraphics(element);
      bbox = gfx.getBBox();
    } // shapes
    // use data
    else {
        bbox = element;
      }

    var x = bbox.x * vbox.scale - vbox.x * vbox.scale;
    var y = bbox.y * vbox.scale - vbox.y * vbox.scale;
    var width = bbox.width * vbox.scale;
    var height = bbox.height * vbox.scale;
    return {
      x: x,
      y: y,
      width: width,
      height: height
    };
  };
  /**
   * Fires an event in order other modules can react to the
   * canvas resizing
   */


  Canvas.prototype.resized = function () {
    // force recomputation of view box
    delete this._cachedViewbox;

    this._eventBus.fire('canvas.resized');
  };

  var ELEMENT_ID = 'data-element-id';
  /**
   * @class
   *
   * A registry that keeps track of all shapes in the diagram.
   */

  function ElementRegistry(eventBus) {
    this._elements = {};
    this._eventBus = eventBus;
  }
  ElementRegistry.$inject = ['eventBus'];
  /**
   * Register a pair of (element, gfx, (secondaryGfx)).
   *
   * @param {djs.model.Base} element
   * @param {SVGElement} gfx
   * @param {SVGElement} [secondaryGfx] optional other element to register, too
   */

  ElementRegistry.prototype.add = function (element, gfx, secondaryGfx) {
    var id = element.id;

    this._validateId(id); // associate dom node with element


    attr$1(gfx, ELEMENT_ID, id);

    if (secondaryGfx) {
      attr$1(secondaryGfx, ELEMENT_ID, id);
    }

    this._elements[id] = {
      element: element,
      gfx: gfx,
      secondaryGfx: secondaryGfx
    };
  };
  /**
   * Removes an element from the registry.
   *
   * @param {djs.model.Base} element
   */


  ElementRegistry.prototype.remove = function (element) {
    var elements = this._elements,
        id = element.id || element,
        container = id && elements[id];

    if (container) {
      // unset element id on gfx
      attr$1(container.gfx, ELEMENT_ID, '');

      if (container.secondaryGfx) {
        attr$1(container.secondaryGfx, ELEMENT_ID, '');
      }

      delete elements[id];
    }
  };
  /**
   * Update the id of an element
   *
   * @param {djs.model.Base} element
   * @param {string} newId
   */


  ElementRegistry.prototype.updateId = function (element, newId) {
    this._validateId(newId);

    if (typeof element === 'string') {
      element = this.get(element);
    }

    this._eventBus.fire('element.updateId', {
      element: element,
      newId: newId
    });

    var gfx = this.getGraphics(element),
        secondaryGfx = this.getGraphics(element, true);
    this.remove(element);
    element.id = newId;
    this.add(element, gfx, secondaryGfx);
  };
  /**
   * Return the model element for a given id or graphics.
   *
   * @example
   *
   * elementRegistry.get('SomeElementId_1');
   * elementRegistry.get(gfx);
   *
   *
   * @param {string|SVGElement} filter for selecting the element
   *
   * @return {djs.model.Base}
   */


  ElementRegistry.prototype.get = function (filter) {
    var id;

    if (typeof filter === 'string') {
      id = filter;
    } else {
      id = filter && attr$1(filter, ELEMENT_ID);
    }

    var container = this._elements[id];
    return container && container.element;
  };
  /**
   * Return all elements that match a given filter function.
   *
   * @param {Function} fn
   *
   * @return {Array<djs.model.Base>}
   */


  ElementRegistry.prototype.filter = function (fn) {
    var filtered = [];
    this.forEach(function (element, gfx) {
      if (fn(element, gfx)) {
        filtered.push(element);
      }
    });
    return filtered;
  };
  /**
   * Return the first element that satisfies the provided testing function.
   *
   * @param {Function} fn
   *
   * @return {djs.model.Base}
   */


  ElementRegistry.prototype.find = function (fn) {
    var map = this._elements,
        keys = Object.keys(map);

    for (var i = 0; i < keys.length; i++) {
      var id = keys[i],
          container = map[id],
          element = container.element,
          gfx = container.gfx;

      if (fn(element, gfx)) {
        return element;
      }
    }
  };
  /**
   * Return all rendered model elements.
   *
   * @return {Array<djs.model.Base>}
   */


  ElementRegistry.prototype.getAll = function () {
    return this.filter(function (e) {
      return e;
    });
  };
  /**
   * Iterate over all diagram elements.
   *
   * @param {Function} fn
   */


  ElementRegistry.prototype.forEach = function (fn) {
    var map = this._elements;
    Object.keys(map).forEach(function (id) {
      var container = map[id],
          element = container.element,
          gfx = container.gfx;
      return fn(element, gfx);
    });
  };
  /**
   * Return the graphical representation of an element or its id.
   *
   * @example
   * elementRegistry.getGraphics('SomeElementId_1');
   * elementRegistry.getGraphics(rootElement); // <g ...>
   *
   * elementRegistry.getGraphics(rootElement, true); // <svg ...>
   *
   *
   * @param {string|djs.model.Base} filter
   * @param {boolean} [secondary=false] whether to return the secondary connected element
   *
   * @return {SVGElement}
   */


  ElementRegistry.prototype.getGraphics = function (filter, secondary) {
    var id = filter.id || filter;
    var container = this._elements[id];
    return container && (secondary ? container.secondaryGfx : container.gfx);
  };
  /**
   * Validate the suitability of the given id and signals a problem
   * with an exception.
   *
   * @param {string} id
   *
   * @throws {Error} if id is empty or already assigned
   */


  ElementRegistry.prototype._validateId = function (id) {
    if (!id) {
      throw new Error('element must have an id');
    }

    if (this._elements[id]) {
      throw new Error('element with id ' + id + ' already added');
    }
  };

  /**
   * An empty collection stub. Use {@link RefsCollection.extend} to extend a
   * collection with ref semantics.
   *
   * @class RefsCollection
   */

  /**
   * Extends a collection with {@link Refs} aware methods
   *
   * @memberof RefsCollection
   * @static
   *
   * @param  {Array<Object>} collection
   * @param  {Refs} refs instance
   * @param  {Object} property represented by the collection
   * @param  {Object} target object the collection is attached to
   *
   * @return {RefsCollection<Object>} the extended array
   */

  function extend$1(collection, refs, property, target) {
    var inverseProperty = property.inverse;
    /**
     * Removes the given element from the array and returns it.
     *
     * @method RefsCollection#remove
     *
     * @param {Object} element the element to remove
     */

    Object.defineProperty(collection, 'remove', {
      value: function value(element) {
        var idx = this.indexOf(element);

        if (idx !== -1) {
          this.splice(idx, 1); // unset inverse

          refs.unset(element, inverseProperty, target);
        }

        return element;
      }
    });
    /**
     * Returns true if the collection contains the given element
     *
     * @method RefsCollection#contains
     *
     * @param {Object} element the element to check for
     */

    Object.defineProperty(collection, 'contains', {
      value: function value(element) {
        return this.indexOf(element) !== -1;
      }
    });
    /**
     * Adds an element to the array, unless it exists already (set semantics).
     *
     * @method RefsCollection#add
     *
     * @param {Object} element the element to add
     * @param {Number} optional index to add element to
     *                 (possibly moving other elements around)
     */

    Object.defineProperty(collection, 'add', {
      value: function value(element, idx) {
        var currentIdx = this.indexOf(element);

        if (typeof idx === 'undefined') {
          if (currentIdx !== -1) {
            // element already in collection (!)
            return;
          } // add to end of array, as no idx is specified


          idx = this.length;
        } // handle already in collection


        if (currentIdx !== -1) {
          // remove element from currentIdx
          this.splice(currentIdx, 1);
        } // add element at idx


        this.splice(idx, 0, element);

        if (currentIdx === -1) {
          // set inverse, unless element was
          // in collection already
          refs.set(element, inverseProperty, target);
        }
      }
    }); // a simple marker, identifying this element
    // as being a refs collection

    Object.defineProperty(collection, '__refs_collection', {
      value: true
    });
    return collection;
  }

  function isExtended(collection) {
    return collection.__refs_collection === true;
  }

  var extend_1 = extend$1;
  var isExtended_1 = isExtended;
  var collection = {
    extend: extend_1,
    isExtended: isExtended_1
  };

  function hasOwnProperty$1(e, property) {
    return Object.prototype.hasOwnProperty.call(e, property.name || property);
  }

  function defineCollectionProperty(ref, property, target) {
    var collection$1 = collection.extend(target[property.name] || [], ref, property, target);
    Object.defineProperty(target, property.name, {
      enumerable: property.enumerable,
      value: collection$1
    });

    if (collection$1.length) {
      collection$1.forEach(function (o) {
        ref.set(o, property.inverse, target);
      });
    }
  }

  function defineProperty$1(ref, property, target) {
    var inverseProperty = property.inverse;
    var _value = target[property.name];
    Object.defineProperty(target, property.name, {
      configurable: property.configurable,
      enumerable: property.enumerable,
      get: function get() {
        return _value;
      },
      set: function set(value) {
        // return if we already performed all changes
        if (value === _value) {
          return;
        }

        var old = _value; // temporary set null

        _value = null;

        if (old) {
          ref.unset(old, inverseProperty, target);
        } // set new value


        _value = value; // set inverse value

        ref.set(_value, inverseProperty, target);
      }
    });
  }
  /**
   * Creates a new references object defining two inversly related
   * attribute descriptors a and b.
   *
   * <p>
   *   When bound to an object using {@link Refs#bind} the references
   *   get activated and ensure that add and remove operations are applied
   *   reversely, too.
   * </p>
   *
   * <p>
   *   For attributes represented as collections {@link Refs} provides the
   *   {@link RefsCollection#add}, {@link RefsCollection#remove} and {@link RefsCollection#contains} extensions
   *   that must be used to properly hook into the inverse change mechanism.
   * </p>
   *
   * @class Refs
   *
   * @classdesc A bi-directional reference between two attributes.
   *
   * @param {Refs.AttributeDescriptor} a property descriptor
   * @param {Refs.AttributeDescriptor} b property descriptor
   *
   * @example
   *
   * var refs = Refs({ name: 'wheels', collection: true, enumerable: true }, { name: 'car' });
   *
   * var car = { name: 'toyota' };
   * var wheels = [{ pos: 'front-left' }, { pos: 'front-right' }];
   *
   * refs.bind(car, 'wheels');
   *
   * car.wheels // []
   * car.wheels.add(wheels[0]);
   * car.wheels.add(wheels[1]);
   *
   * car.wheels // [{ pos: 'front-left' }, { pos: 'front-right' }]
   *
   * wheels[0].car // { name: 'toyota' };
   * car.wheels.remove(wheels[0]);
   *
   * wheels[0].car // undefined
   */


  function Refs(a, b) {
    if (!(this instanceof Refs)) {
      return new Refs(a, b);
    } // link


    a.inverse = b;
    b.inverse = a;
    this.props = {};
    this.props[a.name] = a;
    this.props[b.name] = b;
  }
  /**
   * Binds one side of a bi-directional reference to a
   * target object.
   *
   * @memberOf Refs
   *
   * @param  {Object} target
   * @param  {String} property
   */


  Refs.prototype.bind = function (target, property) {
    if (typeof property === 'string') {
      if (!this.props[property]) {
        throw new Error('no property <' + property + '> in ref');
      }

      property = this.props[property];
    }

    if (property.collection) {
      defineCollectionProperty(this, property, target);
    } else {
      defineProperty$1(this, property, target);
    }
  };

  Refs.prototype.ensureRefsCollection = function (target, property) {
    var collection$1 = target[property.name];

    if (!collection.isExtended(collection$1)) {
      defineCollectionProperty(this, property, target);
    }

    return collection$1;
  };

  Refs.prototype.ensureBound = function (target, property) {
    if (!hasOwnProperty$1(target, property)) {
      this.bind(target, property);
    }
  };

  Refs.prototype.unset = function (target, property, value) {
    if (target) {
      this.ensureBound(target, property);

      if (property.collection) {
        this.ensureRefsCollection(target, property).remove(value);
      } else {
        target[property.name] = undefined;
      }
    }
  };

  Refs.prototype.set = function (target, property, value) {
    if (target) {
      this.ensureBound(target, property);

      if (property.collection) {
        this.ensureRefsCollection(target, property).add(value);
      } else {
        target[property.name] = value;
      }
    }
  };

  var refs = Refs;

  var objectRefs = refs;
  var Collection = collection;
  objectRefs.Collection = Collection;

  var parentRefs = new objectRefs({
    name: 'children',
    enumerable: true,
    collection: true
  }, {
    name: 'parent'
  }),
      labelRefs = new objectRefs({
    name: 'labels',
    enumerable: true,
    collection: true
  }, {
    name: 'labelTarget'
  }),
      attacherRefs = new objectRefs({
    name: 'attachers',
    collection: true
  }, {
    name: 'host'
  }),
      outgoingRefs = new objectRefs({
    name: 'outgoing',
    collection: true
  }, {
    name: 'source'
  }),
      incomingRefs = new objectRefs({
    name: 'incoming',
    collection: true
  }, {
    name: 'target'
  });
  /**
   * @namespace djs.model
   */

  /**
   * @memberOf djs.model
   */

  /**
   * The basic graphical representation
   *
   * @class
   *
   * @abstract
   */

  function Base$1() {
    /**
     * The object that backs up the shape
     *
     * @name Base#businessObject
     * @type Object
     */
    Object.defineProperty(this, 'businessObject', {
      writable: true
    });
    /**
     * Single label support, will mapped to multi label array
     *
     * @name Base#label
     * @type Object
     */

    Object.defineProperty(this, 'label', {
      get: function get() {
        return this.labels[0];
      },
      set: function set(newLabel) {
        var label = this.label,
            labels = this.labels;

        if (!newLabel && label) {
          labels.remove(label);
        } else {
          labels.add(newLabel, 0);
        }
      }
    });
    /**
     * The parent shape
     *
     * @name Base#parent
     * @type Shape
     */

    parentRefs.bind(this, 'parent');
    /**
     * The list of labels
     *
     * @name Base#labels
     * @type Label
     */

    labelRefs.bind(this, 'labels');
    /**
     * The list of outgoing connections
     *
     * @name Base#outgoing
     * @type Array<Connection>
     */

    outgoingRefs.bind(this, 'outgoing');
    /**
     * The list of incoming connections
     *
     * @name Base#incoming
     * @type Array<Connection>
     */

    incomingRefs.bind(this, 'incoming');
  }
  /**
   * A graphical object
   *
   * @class
   * @constructor
   *
   * @extends Base
   */

  function Shape() {
    Base$1.call(this);
    /**
     * Indicates frame shapes
     *
     * @name Shape#isFrame
     * @type boolean
     */

    /**
     * The list of children
     *
     * @name Shape#children
     * @type Array<Base>
     */

    parentRefs.bind(this, 'children');
    /**
     * @name Shape#host
     * @type Shape
     */

    attacherRefs.bind(this, 'host');
    /**
     * @name Shape#attachers
     * @type Shape
     */

    attacherRefs.bind(this, 'attachers');
  }
  inherits_browser$1(Shape, Base$1);
  /**
   * A root graphical object
   *
   * @class
   * @constructor
   *
   * @extends Shape
   */

  function Root() {
    Shape.call(this);
  }
  inherits_browser$1(Root, Shape);
  /**
   * A label for an element
   *
   * @class
   * @constructor
   *
   * @extends Shape
   */

  function Label() {
    Shape.call(this);
    /**
     * The labeled element
     *
     * @name Label#labelTarget
     * @type Base
     */

    labelRefs.bind(this, 'labelTarget');
  }
  inherits_browser$1(Label, Shape);
  /**
   * A connection between two elements
   *
   * @class
   * @constructor
   *
   * @extends Base
   */

  function Connection() {
    Base$1.call(this);
    /**
     * The element this connection originates from
     *
     * @name Connection#source
     * @type Base
     */

    outgoingRefs.bind(this, 'source');
    /**
     * The element this connection points to
     *
     * @name Connection#target
     * @type Base
     */

    incomingRefs.bind(this, 'target');
  }
  inherits_browser$1(Connection, Base$1);
  var types$6 = {
    connection: Connection,
    shape: Shape,
    label: Label,
    root: Root
  };
  /**
   * Creates a new model element of the specified type
   *
   * @method create
   *
   * @example
   *
   * var shape1 = Model.create('shape', { x: 10, y: 10, width: 100, height: 100 });
   * var shape2 = Model.create('shape', { x: 210, y: 210, width: 100, height: 100 });
   *
   * var connection = Model.create('connection', { waypoints: [ { x: 110, y: 55 }, {x: 210, y: 55 } ] });
   *
   * @param  {string} type lower-cased model name
   * @param  {Object} attrs attributes to initialize the new model instance with
   *
   * @return {Base} the new model instance
   */

  function create$1(type, attrs) {
    var Type = types$6[type];

    if (!Type) {
      throw new Error('unknown type: <' + type + '>');
    }

    return assign(new Type(), attrs);
  }

  /**
   * A factory for diagram-js shapes
   */

  function ElementFactory() {
    this._uid = 12;
  }

  ElementFactory.prototype.createRoot = function (attrs) {
    return this.create('root', attrs);
  };

  ElementFactory.prototype.createLabel = function (attrs) {
    return this.create('label', attrs);
  };

  ElementFactory.prototype.createShape = function (attrs) {
    return this.create('shape', attrs);
  };

  ElementFactory.prototype.createConnection = function (attrs) {
    return this.create('connection', attrs);
  };
  /**
   * Create a model element with the given type and
   * a number of pre-set attributes.
   *
   * @param  {string} type
   * @param  {Object} attrs
   * @return {djs.model.Base} the newly created model instance
   */


  ElementFactory.prototype.create = function (type, attrs) {
    attrs = assign({}, attrs || {});

    if (!attrs.id) {
      attrs.id = type + '_' + this._uid++;
    }

    return create$1(type, attrs);
  };

  /**
   * SVGs for elements are generated by the {@link GraphicsFactory}.
   *
   * This utility gives quick access to the important semantic
   * parts of an element.
   */

  /**
   * Returns the visual part of a diagram element
   *
   * @param {Snap<SVGElement>} gfx
   *
   * @return {Snap<SVGElement>}
   */
  function getVisual(gfx) {
    return gfx.childNodes[0];
  }
  /**
   * Returns the children for a given diagram element.
   *
   * @param {Snap<SVGElement>} gfx
   * @return {Snap<SVGElement>}
   */

  function getChildren(gfx) {
    return gfx.parentNode.childNodes[1];
  }

  /**
   * @param {<SVGElement>} element
   * @param {number} x
   * @param {number} y
   * @param {number} angle
   * @param {number} amount
   */

  function transform$1(gfx, x, y, angle, amount) {
    var translate = createTransform();
    translate.setTranslate(x, y);
    var rotate = createTransform();
    rotate.setRotate(angle || 0, 0, 0);
    var scale = createTransform();
    scale.setScale(amount || 1, amount || 1);
    transform(gfx, [translate, rotate, scale]);
  }
  /**
   * @param {SVGElement} element
   * @param {number} x
   * @param {number} y
   */

  function translate(gfx, x, y) {
    var translate = createTransform();
    translate.setTranslate(x, y);
    transform(gfx, translate);
  }
  /**
   * @param {SVGElement} element
   * @param {number} angle
   */

  function rotate(gfx, angle) {
    var rotate = createTransform();
    rotate.setRotate(angle, 0, 0);
    transform(gfx, rotate);
  }

  /**
   * A factory that creates graphical elements
   *
   * @param {EventBus} eventBus
   * @param {ElementRegistry} elementRegistry
   */

  function GraphicsFactory(eventBus, elementRegistry) {
    this._eventBus = eventBus;
    this._elementRegistry = elementRegistry;
  }
  GraphicsFactory.$inject = ['eventBus', 'elementRegistry'];

  GraphicsFactory.prototype._getChildrenContainer = function (element) {
    var gfx = this._elementRegistry.getGraphics(element);

    var childrenGfx; // root element

    if (!element.parent) {
      childrenGfx = gfx;
    } else {
      childrenGfx = getChildren(gfx);

      if (!childrenGfx) {
        childrenGfx = create('g');
        classes$1(childrenGfx).add('djs-children');
        append(gfx.parentNode, childrenGfx);
      }
    }

    return childrenGfx;
  };
  /**
   * Clears the graphical representation of the element and returns the
   * cleared visual (the <g class="djs-visual" /> element).
   */


  GraphicsFactory.prototype._clear = function (gfx) {
    var visual = getVisual(gfx);
    clear(visual);
    return visual;
  };
  /**
   * Creates a gfx container for shapes and connections
   *
   * The layout is as follows:
   *
   * <g class="djs-group">
   *
   *   <!-- the gfx -->
   *   <g class="djs-element djs-(shape|connection|frame)">
   *     <g class="djs-visual">
   *       <!-- the renderer draws in here -->
   *     </g>
   *
   *     <!-- extensions (overlays, click box, ...) goes here
   *   </g>
   *
   *   <!-- the gfx child nodes -->
   *   <g class="djs-children"></g>
   * </g>
   *
   * @param {string} type the type of the element, i.e. shape | connection
   * @param {SVGElement} [childrenGfx]
   * @param {number} [parentIndex] position to create container in parent
   * @param {boolean} [isFrame] is frame element
   *
   * @return {SVGElement}
   */


  GraphicsFactory.prototype._createContainer = function (type, childrenGfx, parentIndex, isFrame) {
    var outerGfx = create('g');
    classes$1(outerGfx).add('djs-group'); // insert node at position

    if (typeof parentIndex !== 'undefined') {
      prependTo(outerGfx, childrenGfx, childrenGfx.childNodes[parentIndex]);
    } else {
      append(childrenGfx, outerGfx);
    }

    var gfx = create('g');
    classes$1(gfx).add('djs-element');
    classes$1(gfx).add('djs-' + type);

    if (isFrame) {
      classes$1(gfx).add('djs-frame');
    }

    append(outerGfx, gfx); // create visual

    var visual = create('g');
    classes$1(visual).add('djs-visual');
    append(gfx, visual);
    return gfx;
  };

  GraphicsFactory.prototype.create = function (type, element, parentIndex) {
    var childrenGfx = this._getChildrenContainer(element.parent);

    return this._createContainer(type, childrenGfx, parentIndex, isFrameElement(element));
  };

  GraphicsFactory.prototype.updateContainments = function (elements) {
    var self = this,
        elementRegistry = this._elementRegistry,
        parents;
    parents = reduce(elements, function (map, e) {
      if (e.parent) {
        map[e.parent.id] = e.parent;
      }

      return map;
    }, {}); // update all parents of changed and reorganized their children
    // in the correct order (as indicated in our model)

    forEach(parents, function (parent) {
      var children = parent.children;

      if (!children) {
        return;
      }

      var childrenGfx = self._getChildrenContainer(parent);

      forEach(children.slice().reverse(), function (child) {
        var childGfx = elementRegistry.getGraphics(child);
        prependTo(childGfx.parentNode, childrenGfx);
      });
    });
  };

  GraphicsFactory.prototype.drawShape = function (visual, element) {
    var eventBus = this._eventBus;
    return eventBus.fire('render.shape', {
      gfx: visual,
      element: element
    });
  };

  GraphicsFactory.prototype.getShapePath = function (element) {
    var eventBus = this._eventBus;
    return eventBus.fire('render.getShapePath', element);
  };

  GraphicsFactory.prototype.drawConnection = function (visual, element) {
    var eventBus = this._eventBus;
    return eventBus.fire('render.connection', {
      gfx: visual,
      element: element
    });
  };

  GraphicsFactory.prototype.getConnectionPath = function (waypoints) {
    var eventBus = this._eventBus;
    return eventBus.fire('render.getConnectionPath', waypoints);
  };

  GraphicsFactory.prototype.update = function (type, element, gfx) {
    // do NOT update root element
    if (!element.parent) {
      return;
    }

    var visual = this._clear(gfx); // redraw


    if (type === 'shape') {
      this.drawShape(visual, element); // update positioning

      translate(gfx, element.x, element.y);
    } else if (type === 'connection') {
      this.drawConnection(visual, element);
    } else {
      throw new Error('unknown type: ' + type);
    }

    if (element.hidden) {
      attr$1(gfx, 'display', 'none');
    } else {
      attr$1(gfx, 'display', 'block');
    }
  };

  GraphicsFactory.prototype.remove = function (element) {
    var gfx = this._elementRegistry.getGraphics(element); // remove


    remove$1(gfx.parentNode);
  }; // helpers //////////


  function prependTo(newNode, parentNode, siblingNode) {
    var node = siblingNode || parentNode.firstChild; // do not prepend node to itself to prevent IE from crashing
    // https://github.com/bpmn-io/bpmn-js/issues/746

    if (newNode === node) {
      return;
    }

    parentNode.insertBefore(newNode, node);
  }

  var CoreModule = {
    __depends__: [DrawModule],
    __init__: ['canvas'],
    canvas: ['type', Canvas],
    elementRegistry: ['type', ElementRegistry],
    elementFactory: ['type', ElementFactory],
    eventBus: ['type', EventBus],
    graphicsFactory: ['type', GraphicsFactory]
  };

  /**
   * Bootstrap an injector from a list of modules, instantiating a number of default components
   *
   * @ignore
   * @param {Array<didi.Module>} bootstrapModules
   *
   * @return {didi.Injector} a injector to use to access the components
   */

  function bootstrap(bootstrapModules) {
    var modules = [],
        components = [];

    function hasModule(m) {
      return modules.indexOf(m) >= 0;
    }

    function addModule(m) {
      modules.push(m);
    }

    function visit(m) {
      if (hasModule(m)) {
        return;
      }

      (m.__depends__ || []).forEach(visit);

      if (hasModule(m)) {
        return;
      }

      addModule(m);
      (m.__init__ || []).forEach(function (c) {
        components.push(c);
      });
    }

    bootstrapModules.forEach(visit);
    var injector = new Injector(modules);
    components.forEach(function (c) {
      try {
        // eagerly resolve component (fn or string)
        injector[typeof c === 'string' ? 'get' : 'invoke'](c);
      } catch (e) {
        console.error('Failed to instantiate component');
        console.error(e.stack);
        throw e;
      }
    });
    return injector;
  }
  /**
   * Creates an injector from passed options.
   *
   * @ignore
   * @param  {Object} options
   * @return {didi.Injector}
   */


  function createInjector(options) {
    options = options || {};
    var configModule = {
      'config': ['value', options]
    };
    var modules = [configModule, CoreModule].concat(options.modules || []);
    return bootstrap(modules);
  }
  /**
   * The main diagram-js entry point that bootstraps the diagram with the given
   * configuration.
   *
   * To register extensions with the diagram, pass them as Array<didi.Module> to the constructor.
   *
   * @class djs.Diagram
   * @memberOf djs
   * @constructor
   *
   * @example
   *
   * <caption>Creating a plug-in that logs whenever a shape is added to the canvas.</caption>
   *
   * // plug-in implemenentation
   * function MyLoggingPlugin(eventBus) {
   *   eventBus.on('shape.added', function(event) {
   *     console.log('shape ', event.shape, ' was added to the diagram');
   *   });
   * }
   *
   * // export as module
   * export default {
   *   __init__: [ 'myLoggingPlugin' ],
   *     myLoggingPlugin: [ 'type', MyLoggingPlugin ]
   * };
   *
   *
   * // instantiate the diagram with the new plug-in
   *
   * import MyLoggingModule from 'path-to-my-logging-plugin';
   *
   * var diagram = new Diagram({
   *   modules: [
   *     MyLoggingModule
   *   ]
   * });
   *
   * diagram.invoke([ 'canvas', function(canvas) {
   *   // add shape to drawing canvas
   *   canvas.addShape({ x: 10, y: 10 });
   * });
   *
   * // 'shape ... was added to the diagram' logged to console
   *
   * @param {Object} options
   * @param {Array<didi.Module>} [options.modules] external modules to instantiate with the diagram
   * @param {didi.Injector} [injector] an (optional) injector to bootstrap the diagram with
   */


  function Diagram(options, injector) {
    // create injector unless explicitly specified
    this.injector = injector = injector || createInjector(options); // API

    /**
     * Resolves a diagram service
     *
     * @method Diagram#get
     *
     * @param {string} name the name of the diagram service to be retrieved
     * @param {boolean} [strict=true] if false, resolve missing services to null
     */

    this.get = injector.get;
    /**
     * Executes a function into which diagram services are injected
     *
     * @method Diagram#invoke
     *
     * @param {Function|Object[]} fn the function to resolve
     * @param {Object} locals a number of locals to use to resolve certain dependencies
     */

    this.invoke = injector.invoke; // init
    // indicate via event

    /**
     * An event indicating that all plug-ins are loaded.
     *
     * Use this event to fire other events to interested plug-ins
     *
     * @memberOf Diagram
     *
     * @event diagram.init
     *
     * @example
     *
     * eventBus.on('diagram.init', function() {
     *   eventBus.fire('my-custom-event', { foo: 'BAR' });
     * });
     *
     * @type {Object}
     */

    this.get('eventBus').fire('diagram.init');
  }
  /**
   * Destroys the diagram
   *
   * @method  Diagram#destroy
   */

  Diagram.prototype.destroy = function () {
    this.get('eventBus').fire('diagram.destroy');
  };
  /**
   * Clear the diagram, removing all contents.
   */


  Diagram.prototype.clear = function () {
    this.get('eventBus').fire('diagram.clear');
  };

  var diRefs = new objectRefs({
    name: 'dmnElementRef',
    enumerable: true
  }, {
    name: 'di',
    configurable: true
  });
  function DRDTreeWalker(handler, options) {
    // list of elements to handle deferred to ensure
    // prerequisites are drawn
    var deferred = [];

    function visit(element) {
      var gfx = element.gfx; // avoid multiple rendering of elements

      if (gfx) {
        throw new Error('already rendered ' + element.id);
      } // call handler


      return handler.element(element);
    }

    function visitRoot(element) {
      return handler.root(element);
    }

    function visitIfDi(element) {
      try {
        var gfx = element.di && visit(element);
        return gfx;
      } catch (e) {
        logError(e.message, {
          element: element,
          error: e
        });
      }
    } // Semantic handling //////////////////////

    /**
     * Handle definitions and return the rendered diagram (if any)
     *
     * @param {ModdleElement} definitions to walk and import
     * @param {ModdleElement} [diagram] specific diagram to import and display
     *
     * @throws {Error} if no diagram to display could be found
     */


    function handleDefinitions(definitions, diagram) {
      // make sure we walk the correct dmnElement
      var dmnDI = definitions.dmnDI;

      if (!dmnDI) {
        throw new Error('no dmndi:DMNDI');
      }

      var diagrams = dmnDI.diagrams || [];

      if (diagram && diagrams.indexOf(diagram) === -1) {
        throw new Error('diagram not part of dmndi:DMNDI');
      }

      if (!diagram && diagrams && diagrams.length) {
        diagram = diagrams[0];
      } // no diagram -> nothing to import


      if (!diagram) {
        throw new Error('no diagram to display');
      } // assign current diagram to definitions so that it can accessed later


      definitions.di = diagram; // load DI from selected diagram only

      handleDiagram(diagram);
      visitRoot(definitions);
      handleDrgElements(definitions.get('drgElement'));
      handleArtifacts(definitions.get('artifact'));
      handleDeferred();
    }

    function handleDrgElements(elements) {
      forEach(elements, function (element) {
        visitIfDi(element);
        handleRequirements(element);
      });
    }

    function handleArtifacts(elements) {
      forEach(elements, function (element) {
        if (is(element, 'dmn:Association')) {
          handleAssociation(element);
        } else {
          visitIfDi(element);
        }
      });
    }
    /**
     * Defer association visit until all shapes are visited.
     *
     * @param {ModdleElement} element
     */


    function handleAssociation(element) {
      defer(function () {
        visitIfDi(element);
      });
    }
    /**
     * Defer requirements visiting until all shapes are visited.
     *
     * @param {ModdleElement} element
     */


    function handleRequirements(element) {
      forEach(['informationRequirement', 'knowledgeRequirement', 'authorityRequirement'], function (requirements) {
        forEach(element[requirements], function (requirement) {
          defer(function () {
            visitIfDi(requirement);
          });
        });
      });
    } // DI handling //////////////////////


    function handleDiagram(diagram) {
      forEach(diagram.diagramElements, handleDiagramElement);
    }

    function handleDiagramElement(diagramElement) {
      registerDi(diagramElement);
    }

    function registerDi(di) {
      var dmnElement = di.dmnElementRef;

      if (dmnElement) {
        if (dmnElement.di) {
          logError('multiple DI elements defined for element', {
            element: dmnElement
          });
        } else {
          diRefs.bind(dmnElement, 'di');
          dmnElement.di = di;
        }
      } else {
        logError('no DMN element referenced in element', {
          element: di
        });
      }
    }

    function defer(fn) {
      deferred.push(fn);
    }

    function handleDeferred() {
      forEach(deferred, function (d) {
        d();
      });
    }

    function logError(message, context) {
      handler.error(message, context);
    } // API //////////////////////


    return {
      handleDefinitions: handleDefinitions
    };
  }

  /**
   * Import the definitions into a diagram.
   *
   * Errors and warnings are reported through the specified callback.
   *
   * @param  {Drd} drd
   * @param  {ModdleElement} definitions
   * @param  {Function} done
   *         the callback, invoked with (err, [ warning ]) once the import is done
   */

  function importDRD(drd, definitions, done) {
    var importer = drd.get('drdImporter'),
        eventBus = drd.get('eventBus');
    var error,
        warnings = [];

    function render(definitions) {
      var visitor = {
        root: function root(element) {
          return importer.root(element);
        },
        element: function element(_element, di) {
          return importer.add(_element, di);
        },
        error: function error(message, context) {
          warnings.push({
            message: message,
            context: context
          });
        }
      };
      var walker = new DRDTreeWalker(visitor); // import

      walker.handleDefinitions(definitions);
    }

    eventBus.fire('import.start', {
      definitions: definitions
    });

    try {
      render(definitions);
    } catch (e) {
      error = e;
    }

    eventBus.fire('import.done', {
      error: error,
      warnings: warnings
    });
    done(error, warnings);
  }

  function DrdRenderer(eventBus, pathMap, styles, textRenderer) {
    BaseRenderer.call(this, eventBus);
    var markers = {};

    function addMarker(id, element) {
      markers[id] = element;
    }

    function marker(id) {
      var marker = markers[id];
      return 'url(#' + marker.id + ')';
    }

    function initMarkers(svg) {
      function createMarker(id, options) {
        var attrs = assign({
          strokeWidth: 1,
          strokeLinecap: 'round',
          strokeDasharray: 'none'
        }, options.attrs);
        var ref = options.ref || {
          x: 0,
          y: 0
        };
        var scale = options.scale || 1; // fix for safari / chrome / firefox bug not correctly
        // resetting stroke dash array

        if (attrs.strokeDasharray === 'none') {
          attrs.strokeDasharray = [10000, 1];
        }

        var marker = create('marker');
        attr$1(options.element, attrs);
        append(marker, options.element);
        attr$1(marker, {
          id: id,
          viewBox: '0 0 20 20',
          refX: ref.x,
          refY: ref.y,
          markerWidth: 20 * scale,
          markerHeight: 20 * scale,
          orient: 'auto'
        });
        var defs = query('defs', svg);

        if (!defs) {
          defs = create('defs');
          append(svg, defs);
        }

        append(defs, marker);
        return addMarker(id, marker);
      }

      var associationStart = create('path');
      attr$1(associationStart, {
        d: 'M 11 5 L 1 10 L 11 15'
      });
      createMarker('association-start', {
        element: associationStart,
        attrs: {
          fill: 'none',
          stroke: 'black',
          strokeWidth: 1.5
        },
        ref: {
          x: 1,
          y: 10
        },
        scale: 0.5
      });
      var associationEnd = create('path');
      attr$1(associationEnd, {
        d: 'M 1 5 L 11 10 L 1 15'
      });
      createMarker('association-end', {
        element: associationEnd,
        attrs: {
          fill: 'none',
          stroke: 'black',
          strokeWidth: 1.5
        },
        ref: {
          x: 12,
          y: 10
        },
        scale: 0.5
      });
      var informationRequirementEnd = create('path');
      attr$1(informationRequirementEnd, {
        d: 'M 1 5 L 11 10 L 1 15 Z'
      });
      createMarker('information-requirement-end', {
        element: informationRequirementEnd,
        ref: {
          x: 11,
          y: 10
        },
        scale: 1
      });
      var knowledgeRequirementEnd = create('path');
      attr$1(knowledgeRequirementEnd, {
        d: 'M 1 3 L 11 10 L 1 17'
      });
      createMarker('knowledge-requirement-end', {
        element: knowledgeRequirementEnd,
        attrs: {
          fill: 'none',
          stroke: 'black',
          strokeWidth: 2
        },
        ref: {
          x: 11,
          y: 10
        },
        scale: 0.8
      });
      var authorityRequirementEnd = create('circle');
      attr$1(authorityRequirementEnd, {
        cx: 3,
        cy: 3,
        r: 3
      });
      createMarker('authority-requirement-end', {
        element: authorityRequirementEnd,
        ref: {
          x: 3,
          y: 3
        },
        scale: 0.9
      });
    }

    function computeStyle(custom, traits, defaultStyles) {
      if (!isArray(traits)) {
        defaultStyles = traits;
        traits = [];
      }

      return styles.style(traits || [], assign(defaultStyles, custom || {}));
    }

    function drawRect(p, width, height, r, offset, attrs) {
      if (isObject(offset)) {
        attrs = offset;
        offset = 0;
      }

      offset = offset || 0;
      attrs = computeStyle(attrs, {
        stroke: 'black',
        strokeWidth: 2,
        fill: 'white'
      });
      var rect = create('rect');
      attr$1(rect, {
        x: offset,
        y: offset,
        width: width - offset * 2,
        height: height - offset * 2,
        rx: r,
        ry: r
      });
      attr$1(rect, attrs);
      append(p, rect);
      return rect;
    }

    function renderLabel(p, label, options) {
      var text = textRenderer.createText(label || '', options);
      attr(text, 'class', 'djs-label');
      append(p, text);
      return text;
    }

    function renderEmbeddedLabel(p, element, align) {
      var name = getName(element);
      return renderLabel(p, name, {
        box: element,
        align: align,
        padding: 5
      });
    }

    function drawPath(p, d, attrs) {
      attrs = computeStyle(attrs, ['no-fill'], {
        strokeWidth: 2,
        stroke: 'black'
      });
      var path = create('path');
      attr$1(path, {
        d: d
      });
      attr$1(path, attrs);
      append(p, path);
      return path;
    }

    var handlers = {
      'dmn:Decision': function dmnDecision(p, element, attrs) {
        var rect = drawRect(p, element.width, element.height, 0, attrs);
        renderEmbeddedLabel(p, element, 'center-middle');
        return rect;
      },
      'dmn:KnowledgeSource': function dmnKnowledgeSource(p, element, attrs) {
        var pathData = pathMap.getScaledPath('KNOWLEDGE_SOURCE', {
          xScaleFactor: 1.021,
          yScaleFactor: 1,
          containerWidth: element.width,
          containerHeight: element.height,
          position: {
            mx: 0.0,
            my: 0.075
          }
        });
        var knowledgeSource = drawPath(p, pathData, {
          strokeWidth: 2,
          fill: 'white',
          stroke: 'black'
        });
        renderEmbeddedLabel(p, element, 'center-middle');
        return knowledgeSource;
      },
      'dmn:BusinessKnowledgeModel': function dmnBusinessKnowledgeModel(p, element, attrs) {
        var pathData = pathMap.getScaledPath('BUSINESS_KNOWLEDGE_MODEL', {
          xScaleFactor: 1,
          yScaleFactor: 1,
          containerWidth: element.width,
          containerHeight: element.height,
          position: {
            mx: 0.0,
            my: 0.3
          }
        });
        var businessKnowledge = drawPath(p, pathData, {
          strokeWidth: 2,
          fill: 'white',
          stroke: 'black'
        });
        renderEmbeddedLabel(p, element, 'center-middle');
        return businessKnowledge;
      },
      'dmn:InputData': function dmnInputData(p, element, attrs) {
        var rect = drawRect(p, element.width, element.height, 22, attrs);
        renderEmbeddedLabel(p, element, 'center-middle');
        return rect;
      },
      'dmn:TextAnnotation': function dmnTextAnnotation(p, element, attrs) {
        var style = {
          'fill': 'none',
          'stroke': 'none'
        };
        var textElement = drawRect(p, element.width, element.height, 0, 0, style);
        var textPathData = pathMap.getScaledPath('TEXT_ANNOTATION', {
          xScaleFactor: 1,
          yScaleFactor: 1,
          containerWidth: element.width,
          containerHeight: element.height,
          position: {
            mx: 0.0,
            my: 0.0
          }
        });
        drawPath(p, textPathData);
        var text = getSemantic(element).text || '';
        renderLabel(p, text, {
          box: element,
          align: 'left-top',
          padding: 5
        });
        return textElement;
      },
      'dmn:Association': function dmnAssociation(p, element, attrs) {
        var semantic = getSemantic(element);
        attrs = assign({
          strokeDasharray: '0.5, 5',
          strokeLinecap: 'round',
          strokeLinejoin: 'round',
          fill: 'none'
        }, attrs || {});

        if (semantic.associationDirection === 'One' || semantic.associationDirection === 'Both') {
          attrs.markerEnd = marker('association-end');
        }

        if (semantic.associationDirection === 'Both') {
          attrs.markerStart = marker('association-start');
        }

        return drawLine(p, element.waypoints, attrs);
      },
      'dmn:InformationRequirement': function dmnInformationRequirement(p, element, attrs) {
        attrs = assign({
          strokeWidth: 1,
          strokeLinecap: 'round',
          strokeLinejoin: 'round',
          markerEnd: marker('information-requirement-end')
        }, attrs || {});
        return drawLine(p, element.waypoints, attrs);
      },
      'dmn:KnowledgeRequirement': function dmnKnowledgeRequirement(p, element, attrs) {
        attrs = assign({
          strokeWidth: 1,
          strokeDasharray: 5,
          strokeLinecap: 'round',
          strokeLinejoin: 'round',
          markerEnd: marker('knowledge-requirement-end')
        }, attrs || {});
        return drawLine(p, element.waypoints, attrs);
      },
      'dmn:AuthorityRequirement': function dmnAuthorityRequirement(p, element, attrs) {
        attrs = assign({
          strokeWidth: 1.5,
          strokeDasharray: 5,
          strokeLinecap: 'round',
          strokeLinejoin: 'round',
          markerEnd: marker('authority-requirement-end')
        }, attrs || {});
        return drawLine(p, element.waypoints, attrs);
      }
    }; // draw shape and connection //////////////////

    function drawShape(parent, element) {
      var h = handlers[element.type];

      if (!h) {
        return BaseRenderer.prototype.drawShape.apply(this, [parent, element]);
      } else {
        return h(parent, element);
      }
    }

    function drawConnection(parent, element) {
      var type = element.type;
      var h = handlers[type];

      if (!h) {
        return BaseRenderer.prototype.drawConnection.apply(this, [parent, element]);
      } else {
        return h(parent, element);
      }
    }

    function drawLine(p, waypoints, attrs) {
      attrs = computeStyle(attrs, ['no-fill'], {
        stroke: 'black',
        strokeWidth: 2,
        fill: 'none'
      });
      var line = createLine(waypoints, attrs);
      append(p, line);
      return line;
    }

    this.canRender = function (element) {
      return is(element, 'dmn:DMNElement') || is(element, 'dmn:InformationRequirement') || is(element, 'dmn:KnowledgeRequirement') || is(element, 'dmn:AuthorityRequirement');
    };

    this.drawShape = drawShape;
    this.drawConnection = drawConnection; // hook onto canvas init event to initialize
    // connection start/end markers on svg

    eventBus.on('canvas.init', function (event) {
      initMarkers(event.svg);
    });
  }
  inherits_browser(DrdRenderer, BaseRenderer);
  DrdRenderer.$inject = ['eventBus', 'pathMap', 'styles', 'textRenderer']; // helper functions //////////////////////

  function getSemantic(element) {
    return element.businessObject;
  }

  var DEFAULT_BOX_PADDING = 0;
  var DEFAULT_LABEL_SIZE = {
    width: 150,
    height: 50
  };

  function parseAlign(align) {
    var parts = align.split('-');
    return {
      horizontal: parts[0] || 'center',
      vertical: parts[1] || 'top'
    };
  }

  function parsePadding(padding) {
    if (isObject(padding)) {
      return assign({
        top: 0,
        left: 0,
        right: 0,
        bottom: 0
      }, padding);
    } else {
      return {
        top: padding,
        left: padding,
        right: padding,
        bottom: padding
      };
    }
  }

  function getTextBBox(text, fakeText) {
    fakeText.textContent = text;
    var textBBox;

    try {
      var bbox,
          emptyLine = text === ''; // add dummy text, when line is empty to
      // determine correct height

      fakeText.textContent = emptyLine ? 'dummy' : text;
      textBBox = fakeText.getBBox(); // take text rendering related horizontal
      // padding into account

      bbox = {
        width: textBBox.width + textBBox.x * 2,
        height: textBBox.height
      };

      if (emptyLine) {
        // correct width
        bbox.width = 0;
      }

      return bbox;
    } catch (e) {
      return {
        width: 0,
        height: 0
      };
    }
  }
  /**
   * Layout the next line and return the layouted element.
   *
   * Alters the lines passed.
   *
   * @param  {Array<string>} lines
   * @return {Object} the line descriptor, an object { width, height, text }
   */


  function layoutNext(lines, maxWidth, fakeText) {
    var originalLine = lines.shift(),
        fitLine = originalLine;
    var textBBox;

    for (;;) {
      textBBox = getTextBBox(fitLine, fakeText);
      textBBox.width = fitLine ? textBBox.width : 0; // try to fit

      if (fitLine === ' ' || fitLine === '' || textBBox.width < Math.round(maxWidth) || fitLine.length < 2) {
        return fit(lines, fitLine, originalLine, textBBox);
      }

      fitLine = shortenLine(fitLine, textBBox.width, maxWidth);
    }
  }

  function fit(lines, fitLine, originalLine, textBBox) {
    if (fitLine.length < originalLine.length) {
      var remainder = originalLine.slice(fitLine.length).trim();
      lines.unshift(remainder);
    }

    return {
      width: textBBox.width,
      height: textBBox.height,
      text: fitLine
    };
  }

  var SOFT_BREAK = "\xAD";
  /**
   * Shortens a line based on spacing and hyphens.
   * Returns the shortened result on success.
   *
   * @param  {string} line
   * @param  {number} maxLength the maximum characters of the string
   * @return {string} the shortened string
   */

  function semanticShorten(line, maxLength) {
    var parts = line.split(/(\s|-|\u00AD)/g),
        part,
        shortenedParts = [],
        length = 0; // try to shorten via break chars

    if (parts.length > 1) {
      while (part = parts.shift()) {
        if (part.length + length < maxLength) {
          shortenedParts.push(part);
          length += part.length;
        } else {
          // remove previous part, too if hyphen does not fit anymore
          if (part === '-' || part === SOFT_BREAK) {
            shortenedParts.pop();
          }

          break;
        }
      }
    }

    var last = shortenedParts[shortenedParts.length - 1]; // translate trailing soft break to actual hyphen

    if (last && last === SOFT_BREAK) {
      shortenedParts[shortenedParts.length - 1] = '-';
    }

    return shortenedParts.join('');
  }

  function shortenLine(line, width, maxWidth) {
    var length = Math.max(line.length * (maxWidth / width), 1); // try to shorten semantically (i.e. based on spaces and hyphens)

    var shortenedLine = semanticShorten(line, length);

    if (!shortenedLine) {
      // force shorten by cutting the long word
      shortenedLine = line.slice(0, Math.max(Math.round(length - 1), 1));
    }

    return shortenedLine;
  }

  function getHelperSvg() {
    var helperSvg = document.getElementById('helper-svg');

    if (!helperSvg) {
      helperSvg = create('svg');
      attr$1(helperSvg, {
        id: 'helper-svg',
        width: 0,
        height: 0,
        style: 'visibility: hidden; position: fixed'
      });
      document.body.appendChild(helperSvg);
    }

    return helperSvg;
  }
  /**
   * Creates a new label utility
   *
   * @param {Object} config
   * @param {Dimensions} config.size
   * @param {number} config.padding
   * @param {Object} config.style
   * @param {string} config.align
   */


  function Text(config) {
    this._config = assign({}, {
      size: DEFAULT_LABEL_SIZE,
      padding: DEFAULT_BOX_PADDING,
      style: {},
      align: 'center-top'
    }, config || {});
  }
  /**
   * Returns the layouted text as an SVG element.
   *
   * @param {string} text
   * @param {Object} options
   *
   * @return {SVGElement}
   */

  Text.prototype.createText = function (text, options) {
    return this.layoutText(text, options).element;
  };
  /**
   * Returns a labels layouted dimensions.
   *
   * @param {string} text to layout
   * @param {Object} options
   *
   * @return {Dimensions}
   */


  Text.prototype.getDimensions = function (text, options) {
    return this.layoutText(text, options).dimensions;
  };
  /**
   * Creates and returns a label and its bounding box.
   *
   * @method Text#createText
   *
   * @param {string} text the text to render on the label
   * @param {Object} options
   * @param {string} options.align how to align in the bounding box.
   *                               Any of { 'center-middle', 'center-top' },
   *                               defaults to 'center-top'.
   * @param {string} options.style style to be applied to the text
   * @param {boolean} options.fitBox indicates if box will be recalculated to
   *                                 fit text
   *
   * @return {Object} { element, dimensions }
   */


  Text.prototype.layoutText = function (text, options) {
    var box = assign({}, this._config.size, options.box),
        style = assign({}, this._config.style, options.style),
        align = parseAlign(options.align || this._config.align),
        padding = parsePadding(options.padding !== undefined ? options.padding : this._config.padding),
        fitBox = options.fitBox || false;
    var lineHeight = getLineHeight(style); // we split text by lines and normalize
    // {soft break} + {line break} => { line break }

    var lines = text.split(/\u00AD?\r?\n/),
        layouted = [];
    var maxWidth = box.width - padding.left - padding.right; // ensure correct rendering by attaching helper text node to invisible SVG

    var helperText = create('text');
    attr$1(helperText, {
      x: 0,
      y: 0
    });
    attr$1(helperText, style);
    var helperSvg = getHelperSvg();
    append(helperSvg, helperText);

    while (lines.length) {
      layouted.push(layoutNext(lines, maxWidth, helperText));
    }

    if (align.vertical === 'middle') {
      padding.top = padding.bottom = 0;
    }

    var totalHeight = reduce(layouted, function (sum, line, idx) {
      return sum + (lineHeight || line.height);
    }, 0) + padding.top + padding.bottom;
    var maxLineWidth = reduce(layouted, function (sum, line, idx) {
      return line.width > sum ? line.width : sum;
    }, 0); // the y position of the next line

    var y = padding.top;

    if (align.vertical === 'middle') {
      y += (box.height - totalHeight) / 2;
    } // magic number initial offset


    y -= (lineHeight || layouted[0].height) / 4;
    var textElement = create('text');
    attr$1(textElement, style); // layout each line taking into account that parent
    // shape might resize to fit text size

    forEach(layouted, function (line) {
      var x;
      y += lineHeight || line.height;

      switch (align.horizontal) {
        case 'left':
          x = padding.left;
          break;

        case 'right':
          x = (fitBox ? maxLineWidth : maxWidth) - padding.right - line.width;
          break;

        default:
          // aka center
          x = Math.max(((fitBox ? maxLineWidth : maxWidth) - line.width) / 2 + padding.left, 0);
      }

      var tspan = create('tspan');
      attr$1(tspan, {
        x: x,
        y: y
      });
      tspan.textContent = line.text;
      append(textElement, tspan);
    });
    remove$1(helperText);
    var dimensions = {
      width: maxLineWidth,
      height: totalHeight
    };
    return {
      dimensions: dimensions,
      element: textElement
    };
  };

  function getLineHeight(style) {
    if ('fontSize' in style && 'lineHeight' in style) {
      return style.lineHeight * parseInt(style.fontSize, 10);
    }
  }

  var DEFAULT_FONT_SIZE = 12;
  var LINE_HEIGHT_RATIO = 1.2;
  var MIN_TEXT_ANNOTATION_HEIGHT = 30;
  function TextRenderer(config) {
    var defaultStyle = assign({
      fontFamily: 'Arial, sans-serif',
      fontSize: DEFAULT_FONT_SIZE,
      fontWeight: 'normal',
      lineHeight: LINE_HEIGHT_RATIO
    }, config && config.defaultStyle || {});
    var fontSize = parseInt(defaultStyle.fontSize, 10) - 1;
    var externalStyle = assign({}, defaultStyle, {
      fontSize: fontSize
    }, config && config.externalStyle || {});
    var textUtil = new Text({
      style: defaultStyle
    });
    /**
     * Get the new bounds of an externally rendered,
     * layouted label.
     *
     * @param  {Bounds} bounds
     * @param  {string} text
     *
     * @return {Bounds}
     */

    this.getExternalLabelBounds = function (bounds, text) {
      var layoutedDimensions = textUtil.getDimensions(text, {
        box: {
          width: 90,
          height: 30,
          x: bounds.width / 2 + bounds.x,
          y: bounds.height / 2 + bounds.y
        },
        style: externalStyle
      }); // resize label shape to fit label text

      return {
        x: Math.round(bounds.x + bounds.width / 2 - layoutedDimensions.width / 2),
        y: Math.round(bounds.y),
        width: Math.ceil(layoutedDimensions.width),
        height: Math.ceil(layoutedDimensions.height)
      };
    };
    /**
     * Get the new bounds of text annotation.
     *
     * @param  {Bounds} bounds
     * @param  {string} text
     *
     * @return {Bounds}
     */


    this.getTextAnnotationBounds = function (bounds, text) {
      var layoutedDimensions = textUtil.getDimensions(text, {
        box: bounds,
        style: defaultStyle,
        align: 'left-top',
        padding: 5
      });
      return {
        x: bounds.x,
        y: bounds.y,
        width: bounds.width,
        height: Math.max(MIN_TEXT_ANNOTATION_HEIGHT, Math.round(layoutedDimensions.height))
      };
    };
    /**
     * Create a layouted text element.
     *
     * @param {string} text
     * @param {Object} [options]
     *
     * @return {SVGElement} rendered text
     */


    this.createText = function (text, options) {
      return textUtil.createText(text, options || {});
    };
    /**
     * Get default text style.
     */


    this.getDefaultStyle = function () {
      return defaultStyle;
    };
    /**
     * Get the external text style.
     */


    this.getExternalStyle = function () {
      return externalStyle;
    };
  }
  TextRenderer.$inject = ['config.textRenderer'];

  /* eslint-disable max-len */

  /**
   * Map containing SVG paths needed by BpmnRenderer.
   */
  function PathMap() {
    /**
     * Contains a map of path elements
     *
     * <h1>Path definition</h1>
     * A parameterized path is defined like this:
     * <pre>
     * 'GATEWAY_PARALLEL': {
     *   d: 'm {mx},{my} {e.x0},0 0,{e.x1} {e.x1},0 0,{e.y0} -{e.x1},0 0,{e.y1} ' +
            '-{e.x0},0 0,-{e.y1} -{e.x1},0 0,-{e.y0} {e.x1},0 z',
     *   height: 17.5,
     *   width:  17.5,
     *   heightElements: [2.5, 7.5],
     *   widthElements: [2.5, 7.5]
     * }
     * </pre>
     * <p>It's important to specify a correct <b>height and width</b> for the path as the scaling
     * is based on the ratio between the specified height and width in this object and the
     * height and width that is set as scale target (Note x,y coordinates will be scaled with
     * individual ratios).</p>
     * <p>The '<b>heightElements</b>' and '<b>widthElements</b>' array must contain the values that will be scaled.
     * The scaling is based on the computed ratios.
     * Coordinates on the y axis should be in the <b>heightElement</b>'s array, they will be scaled using
     * the computed ratio coefficient.
     * In the parameterized path the scaled values can be accessed through the 'e' object in {} brackets.
     *   <ul>
     *    <li>The values for the y axis can be accessed in the path string using {e.y0}, {e.y1}, ....</li>
     *    <li>The values for the x axis can be accessed in the path string using {e.x0}, {e.x1}, ....</li>
     *   </ul>
     *   The numbers x0, x1 respectively y0, y1, ... map to the corresponding array index.
     * </p>
      m1,1
      l 0,55.3
      c 29.8,19.7 48.4,-4.2 67.2,-6.7
      c 12.2,-2.3 19.8,1.6 30.8,6.2
      l 0,-54.6
      z
      */
    this.pathMap = {
      'KNOWLEDGE_SOURCE': {
        d: 'm {mx},{my} ' + 'l 0,{e.y0} ' + 'c {e.x0},{e.y1} {e.x1},-{e.y2} {e.x2},-{e.y3} ' + 'c {e.x3},-{e.y4} {e.x4},{e.y5} {e.x5},{e.y6} ' + 'l 0,-{e.y7}z',
        width: 100,
        height: 65,
        widthElements: [29.8, 48.4, 67.2, 12.2, 19.8, 30.8],
        heightElements: [55.3, 19.7, 4.2, 6.7, 2.3, 1.6, 6.2, 54.6]
      },
      'BUSINESS_KNOWLEDGE_MODEL': {
        d: 'm {mx},{my} l {e.x0},-{e.y0} l {e.x1},0 l 0,{e.y1} l -{e.x2},{e.y2} l -{e.x3},0z',
        width: 125,
        height: 45,
        widthElements: [13.8, 109.2, 13.8, 109.1],
        heightElements: [13.2, 29.8, 13.2]
      },
      'TEXT_ANNOTATION': {
        d: 'm {mx}, {my} m 10,0 l -10,0 l 0,{e.y0} l 10,0',
        width: 10,
        height: 30,
        widthElements: [10],
        heightElements: [30]
      }
    };

    this.getRawPath = function getRawPath(pathId) {
      return this.pathMap[pathId].d;
    };
    /**
     * Scales the path to the given height and width.
     * <h1>Use case</h1>
     * <p>Use case is to scale the content of elements (event, gateways) based
     * on the element bounding box's size.
     * </p>
     * <h1>Why not transform</h1>
     * <p>Scaling a path with transform() will also scale the stroke and IE does not support
     * the option 'non-scaling-stroke' to prevent this.
     * Also there are use cases where only some parts of a path should be
     * scaled.</p>
     *
     * @param {string} pathId The ID of the path.
     * @param {Object} param <p>
     *   Example param object scales the path to 60% size of the container (data.width, data.height).
     *   <pre>
     *   {
     *     xScaleFactor: 0.6,
     *     yScaleFactor:0.6,
     *     containerWidth: data.width,
     *     containerHeight: data.height,
     *     position: {
     *       mx: 0.46,
     *       my: 0.2,
     *     }
     *   }
     *   </pre>
     *   <ul>
     *    <li>targetpathwidth = xScaleFactor * containerWidth</li>
     *    <li>targetpathheight = yScaleFactor * containerHeight</li>
     *    <li>Position is used to set the starting coordinate of the path. M is computed:
      *    <ul>
      *      <li>position.x * containerWidth</li>
      *      <li>position.y * containerHeight</li>
      *    </ul>
      *    Center of the container <pre> position: {
     *       mx: 0.5,
     *       my: 0.5,
     *     }</pre>
     *     Upper left corner of the container
     *     <pre> position: {
     *       mx: 0.0,
     *       my: 0.0,
     *     }</pre>
     *    </li>
     *   </ul>
     * </p>
     *
     */


    this.getScaledPath = function getScaledPath(pathId, param) {
      var rawPath = this.pathMap[pathId]; // positioning
      // compute the start point of the path

      var mx, my;

      if (param.abspos) {
        mx = param.abspos.x;
        my = param.abspos.y;
      } else {
        mx = param.containerWidth * param.position.mx;
        my = param.containerHeight * param.position.my;
      }

      var coordinates = {}; // map for the scaled coordinates

      if (param.position) {
        // path
        var heightRatio = param.containerHeight / rawPath.height * param.yScaleFactor;
        var widthRatio = param.containerWidth / rawPath.width * param.xScaleFactor; // Apply height ratio

        for (var heightIndex = 0; heightIndex < rawPath.heightElements.length; heightIndex++) {
          coordinates['y' + heightIndex] = rawPath.heightElements[heightIndex] * heightRatio;
        } // Apply width ratio


        for (var widthIndex = 0; widthIndex < rawPath.widthElements.length; widthIndex++) {
          coordinates['x' + widthIndex] = rawPath.widthElements[widthIndex] * widthRatio;
        }
      } // Apply value to raw path


      var path = format(rawPath.d, {
        mx: mx,
        my: my,
        e: coordinates
      });
      return path;
    };
  } // helpers //////////////////////
  // copied from https://github.com/adobe-webplatform/Snap.svg/blob/master/src/svg.js

  var tokenRegex = /\{([^}]+)\}/g,
      objNotationRegex = /(?:(?:^|\.)(.+?)(?=\[|\.|$|\()|\[('|")(.+?)\2\])(\(\))?/g; // matches .xxxxx or ["xxxxx"] to run over object properties

  function replacer(all, key, obj) {
    var res = obj;
    key.replace(objNotationRegex, function (all, name, quote, quotedName, isFunc) {
      name = name || quotedName;

      if (res) {
        if (name in res) {
          res = res[name];
        }

        typeof res == 'function' && isFunc && (res = res());
      }
    });
    res = (res == null || res == obj ? all : res) + '';
    return res;
  }

  function format(str, obj) {
    return String(str).replace(tokenRegex, function (all, key) {
      return replacer(all, key, obj);
    });
  }

  var DrawModule$1 = {
    __init__: ['drdRenderer'],
    drdRenderer: ['type', DrdRenderer],
    textRenderer: ['type', TextRenderer],
    pathMap: ['type', PathMap]
  };

  function DrdImporter(eventBus, canvas, elementFactory, elementRegistry) {
    this._eventBus = eventBus;
    this._canvas = canvas;
    this._elementRegistry = elementRegistry;
    this._elementFactory = elementFactory;
  }
  DrdImporter.$inject = ['eventBus', 'canvas', 'elementFactory', 'elementRegistry'];

  DrdImporter.prototype.root = function (semantic) {
    var element = this._elementFactory.createRoot(elementData(semantic));

    this._canvas.setRootElement(element);

    return element;
  };
  /**
   * Add drd element (semantic) to the canvas.
   */


  DrdImporter.prototype.add = function (semantic) {
    var elementFactory = this._elementFactory,
        canvas = this._canvas,
        eventBus = this._eventBus,
        di = semantic.di;
    var element, waypoints, source, target, elementDefinition, bounds;

    if (di.$instanceOf('dmndi:DMNShape')) {
      bounds = di.bounds;
      elementDefinition = elementData(semantic, {
        x: Math.round(bounds.x),
        y: Math.round(bounds.y),
        width: Math.round(bounds.width),
        height: Math.round(bounds.height)
      });
      element = elementFactory.createShape(elementDefinition);
      canvas.addShape(element);
      eventBus.fire('drdElement.added', {
        element: element,
        di: di
      });
    } else if (di.$instanceOf('dmndi:DMNEdge')) {
      waypoints = collectWaypoints(di);
      source = this._getSource(semantic);
      target = this._getTarget(semantic);

      if (source && target) {
        elementDefinition = elementData(semantic, {
          hidden: false,
          source: source,
          target: target,
          waypoints: waypoints
        });
        element = elementFactory.createConnection(elementDefinition);
        canvas.addConnection(element);
        eventBus.fire('drdElement.added', {
          element: element,
          di: di
        });
      }
    } else {
      throw new Error('unknown di for element ' + semantic.id);
    }

    return element;
  };

  DrdImporter.prototype._getSource = function (semantic) {
    var href, elementReference;

    if (is(semantic, 'dmn:Association')) {
      elementReference = semantic.sourceRef;
    } else if (is(semantic, 'dmn:InformationRequirement')) {
      elementReference = semantic.requiredDecision || semantic.requiredInput;
    } else if (is(semantic, 'dmn:KnowledgeRequirement')) {
      elementReference = semantic.requiredKnowledge;
    } else if (is(semantic, 'dmn:AuthorityRequirement')) {
      elementReference = semantic.requiredDecision || semantic.requiredInput || semantic.requiredAuthority;
    }

    if (elementReference) {
      href = elementReference.href;
    }

    if (href) {
      return this._getShape(getIdFromHref(href));
    }
  };

  DrdImporter.prototype._getTarget = function (semantic) {
    if (is(semantic, 'dmn:Association')) {
      return semantic.targetRef && this._getShape(getIdFromHref(semantic.targetRef.href));
    }

    return this._getShape(semantic.$parent.id);
  };

  DrdImporter.prototype._getShape = function (id) {
    return this._elementRegistry.get(id);
  }; // helper /////


  function elementData(semantic, attrs) {
    return assign({
      id: semantic.id,
      type: semantic.$type,
      businessObject: semantic
    }, attrs);
  }

  function collectWaypoints(edge) {
    var waypoints = edge.waypoint;

    if (waypoints) {
      return map(waypoints, function (waypoint) {
        var position = {
          x: waypoint.x,
          y: waypoint.y
        };
        return assign({
          original: position
        }, position);
      });
    }
  }

  function getIdFromHref(href) {
    return href.split('#').pop();
  }

  var ImportModule = {
    drdImporter: ['type', DrdImporter]
  };

  var CoreModule$1 = {
    __depends__: [DrawModule$1, ImportModule]
  };

  /**
   * A simple translation stub to be used for multi-language support
   * in diagrams. Can be easily replaced with a more sophisticated
   * solution.
   *
   * @example
   *
   * // use it inside any diagram component by injecting `translate`.
   *
   * function MyService(translate) {
   *   alert(translate('HELLO {you}', { you: 'You!' }));
   * }
   *
   * @param {string} template to interpolate
   * @param {Object} [replacements] a map with substitutes
   *
   * @return {string} the translated string
   */
  function translate$1(template, replacements) {
    replacements = replacements || {};
    return template.replace(/{([^}]+)}/g, function (_, key) {
      return replacements[key] || '{' + key + '}';
    });
  }

  var TranslateModule = {
    translate: ['value', translate$1]
  };

  function __stopPropagation(event) {
    if (!event || typeof event.stopPropagation !== 'function') {
      return;
    }

    event.stopPropagation();
  }

  function getOriginal(event) {
    return event.originalEvent || event.srcEvent;
  }
  function stopPropagation(event, immediate) {
    __stopPropagation(event);

    __stopPropagation(getOriginal(event));
  }
  function toPoint(event) {
    if (event.pointers && event.pointers.length) {
      event = event.pointers[0];
    }

    if (event.touches && event.touches.length) {
      event = event.touches[0];
    }

    return event ? {
      x: event.clientX,
      y: event.clientY
    } : null;
  }

  function isMac() {
    return /mac/i.test(navigator.platform);
  }

  function isButton(event, button) {
    return (getOriginal(event) || event).button === button;
  }
  function isPrimaryButton(event) {
    // button === 0 -> left áka primary mouse button
    return isButton(event, 0);
  }
  function isAuxiliaryButton(event) {
    // button === 1 -> auxiliary áka wheel button
    return isButton(event, 1);
  }
  function hasPrimaryModifier(event) {
    var originalEvent = getOriginal(event) || event;

    if (!isPrimaryButton(event)) {
      return false;
    } // Use alt as primary modifier key for mac OS


    if (isMac()) {
      return originalEvent.metaKey;
    } else {
      return originalEvent.ctrlKey;
    }
  }
  function hasSecondaryModifier(event) {
    var originalEvent = getOriginal(event) || event;
    return isPrimaryButton(event) && originalEvent.shiftKey;
  }

  function allowAll(event) {
    return true;
  }

  function allowPrimaryAndAuxiliary(event) {
    return isPrimaryButton(event) || isAuxiliaryButton(event);
  }

  var LOW_PRIORITY = 500;
  /**
   * A plugin that provides interaction events for diagram elements.
   *
   * It emits the following events:
   *
   *   * element.click
   *   * element.contextmenu
   *   * element.dblclick
   *   * element.hover
   *   * element.mousedown
   *   * element.mousemove
   *   * element.mouseup
   *   * element.out
   *
   * Each event is a tuple { element, gfx, originalEvent }.
   *
   * Canceling the event via Event#preventDefault()
   * prevents the original DOM operation.
   *
   * @param {EventBus} eventBus
   */

  function InteractionEvents(eventBus, elementRegistry, styles) {
    var self = this;
    /**
     * Fire an interaction event.
     *
     * @param {string} type local event name, e.g. element.click.
     * @param {DOMEvent} event native event
     * @param {djs.model.Base} [element] the diagram element to emit the event on;
     *                                   defaults to the event target
     */

    function fire(type, event, element) {
      if (isIgnored(type, event)) {
        return;
      }

      var target, gfx, returnValue;

      if (!element) {
        target = event.delegateTarget || event.target;

        if (target) {
          gfx = target;
          element = elementRegistry.get(gfx);
        }
      } else {
        gfx = elementRegistry.getGraphics(element);
      }

      if (!gfx || !element) {
        return;
      }

      returnValue = eventBus.fire(type, {
        element: element,
        gfx: gfx,
        originalEvent: event
      });

      if (returnValue === false) {
        event.stopPropagation();
        event.preventDefault();
      }
    } // TODO(nikku): document this


    var handlers = {};

    function mouseHandler(localEventName) {
      return handlers[localEventName];
    }

    function isIgnored(localEventName, event) {
      var filter = ignoredFilters[localEventName] || isPrimaryButton; // only react on left mouse button interactions
      // except for interaction events that are enabled
      // for secundary mouse button

      return !filter(event);
    }

    var bindings = {
      click: 'element.click',
      contextmenu: 'element.contextmenu',
      dblclick: 'element.dblclick',
      mousedown: 'element.mousedown',
      mousemove: 'element.mousemove',
      mouseover: 'element.hover',
      mouseout: 'element.out',
      mouseup: 'element.mouseup'
    };
    var ignoredFilters = {
      'element.contextmenu': allowAll,
      'element.mousedown': allowPrimaryAndAuxiliary,
      'element.mouseup': allowPrimaryAndAuxiliary,
      'element.click': allowPrimaryAndAuxiliary,
      'element.dblclick': allowPrimaryAndAuxiliary
    }; // manual event trigger //////////

    /**
     * Trigger an interaction event (based on a native dom event)
     * on the target shape or connection.
     *
     * @param {string} eventName the name of the triggered DOM event
     * @param {MouseEvent} event
     * @param {djs.model.Base} targetElement
     */

    function triggerMouseEvent(eventName, event, targetElement) {
      // i.e. element.mousedown...
      var localEventName = bindings[eventName];

      if (!localEventName) {
        throw new Error('unmapped DOM event name <' + eventName + '>');
      }

      return fire(localEventName, event, targetElement);
    }

    var ELEMENT_SELECTOR = 'svg, .djs-element'; // event handling ///////

    function registerEvent(node, event, localEvent, ignoredFilter) {
      var handler = handlers[localEvent] = function (event) {
        fire(localEvent, event);
      };

      if (ignoredFilter) {
        ignoredFilters[localEvent] = ignoredFilter;
      }

      handler.$delegate = delegate.bind(node, ELEMENT_SELECTOR, event, handler);
    }

    function unregisterEvent(node, event, localEvent) {
      var handler = mouseHandler(localEvent);

      if (!handler) {
        return;
      }

      delegate.unbind(node, event, handler.$delegate);
    }

    function registerEvents(svg) {
      forEach(bindings, function (val, key) {
        registerEvent(svg, key, val);
      });
    }

    function unregisterEvents(svg) {
      forEach(bindings, function (val, key) {
        unregisterEvent(svg, key, val);
      });
    }

    eventBus.on('canvas.destroy', function (event) {
      unregisterEvents(event.svg);
    });
    eventBus.on('canvas.init', function (event) {
      registerEvents(event.svg);
    }); // hit box updating ////////////////

    eventBus.on(['shape.added', 'connection.added'], function (event) {
      var element = event.element,
          gfx = event.gfx;
      eventBus.fire('interactionEvents.createHit', {
        element: element,
        gfx: gfx
      });
    }); // Update djs-hit on change.
    // A low priortity is necessary, because djs-hit of labels has to be updated
    // after the label bounds have been updated in the renderer.

    eventBus.on(['shape.changed', 'connection.changed'], LOW_PRIORITY, function (event) {
      var element = event.element,
          gfx = event.gfx;
      eventBus.fire('interactionEvents.updateHit', {
        element: element,
        gfx: gfx
      });
    });
    eventBus.on('interactionEvents.createHit', LOW_PRIORITY, function (event) {
      var element = event.element,
          gfx = event.gfx;
      self.createDefaultHit(element, gfx);
    });
    eventBus.on('interactionEvents.updateHit', function (event) {
      var element = event.element,
          gfx = event.gfx;
      self.updateDefaultHit(element, gfx);
    }); // hit styles ////////////

    var STROKE_HIT_STYLE = createHitStyle('djs-hit djs-hit-stroke');
    var CLICK_STROKE_HIT_STYLE = createHitStyle('djs-hit djs-hit-click-stroke');
    var ALL_HIT_STYLE = createHitStyle('djs-hit djs-hit-all');
    var HIT_TYPES = {
      'all': ALL_HIT_STYLE,
      'click-stroke': CLICK_STROKE_HIT_STYLE,
      'stroke': STROKE_HIT_STYLE
    };

    function createHitStyle(classNames, attrs) {
      attrs = assign({
        stroke: 'white',
        strokeWidth: 15
      }, attrs || {});
      return styles.cls(classNames, ['no-fill', 'no-border'], attrs);
    } // style helpers ///////////////


    function applyStyle(hit, type) {
      var attrs = HIT_TYPES[type];

      if (!attrs) {
        throw new Error('invalid hit type <' + type + '>');
      }

      attr$1(hit, attrs);
      return hit;
    }

    function appendHit(gfx, hit) {
      append(gfx, hit);
    } // API

    /**
     * Remove hints on the given graphics.
     *
     * @param {SVGElement} gfx
     */


    this.removeHits = function (gfx) {
      var hits = all('.djs-hit', gfx);
      forEach(hits, remove$1);
    };
    /**
     * Create default hit for the given element.
     *
     * @param {djs.model.Base} element
     * @param {SVGElement} gfx
     *
     * @return {SVGElement} created hit
     */


    this.createDefaultHit = function (element, gfx) {
      var waypoints = element.waypoints,
          isFrame = element.isFrame,
          boxType;

      if (waypoints) {
        return this.createWaypointsHit(gfx, waypoints);
      } else {
        boxType = isFrame ? 'stroke' : 'all';
        return this.createBoxHit(gfx, boxType, {
          width: element.width,
          height: element.height
        });
      }
    };
    /**
     * Create hits for the given waypoints.
     *
     * @param {SVGElement} gfx
     * @param {Array<Point>} waypoints
     *
     * @return {SVGElement}
     */


    this.createWaypointsHit = function (gfx, waypoints) {
      var hit = createLine(waypoints);
      applyStyle(hit, 'stroke');
      appendHit(gfx, hit);
      return hit;
    };
    /**
     * Create hits for a box.
     *
     * @param {SVGElement} gfx
     * @param {string} hitType
     * @param {Object} attrs
     *
     * @return {SVGElement}
     */


    this.createBoxHit = function (gfx, type, attrs) {
      attrs = assign({
        x: 0,
        y: 0
      }, attrs);
      var hit = create('rect');
      applyStyle(hit, type);
      attr$1(hit, attrs);
      appendHit(gfx, hit);
      return hit;
    };
    /**
     * Update default hit of the element.
     *
     * @param  {djs.model.Base} element
     * @param  {SVGElement} gfx
     *
     * @return {SVGElement} updated hit
     */


    this.updateDefaultHit = function (element, gfx) {
      var hit = query('.djs-hit', gfx);

      if (!hit) {
        return;
      }

      if (element.waypoints) {
        updateLine(hit, element.waypoints);
      } else {
        attr$1(hit, {
          width: element.width,
          height: element.height
        });
      }

      return hit;
    };

    this.fire = fire;
    this.triggerMouseEvent = triggerMouseEvent;
    this.mouseHandler = mouseHandler;
    this.registerEvent = registerEvent;
    this.unregisterEvent = unregisterEvent;
  }
  InteractionEvents.$inject = ['eventBus', 'elementRegistry', 'styles'];
  /**
   * An event indicating that the mouse hovered over an element
   *
   * @event element.hover
   *
   * @type {Object}
   * @property {djs.model.Base} element
   * @property {SVGElement} gfx
   * @property {Event} originalEvent
   */

  /**
   * An event indicating that the mouse has left an element
   *
   * @event element.out
   *
   * @type {Object}
   * @property {djs.model.Base} element
   * @property {SVGElement} gfx
   * @property {Event} originalEvent
   */

  /**
   * An event indicating that the mouse has clicked an element
   *
   * @event element.click
   *
   * @type {Object}
   * @property {djs.model.Base} element
   * @property {SVGElement} gfx
   * @property {Event} originalEvent
   */

  /**
   * An event indicating that the mouse has double clicked an element
   *
   * @event element.dblclick
   *
   * @type {Object}
   * @property {djs.model.Base} element
   * @property {SVGElement} gfx
   * @property {Event} originalEvent
   */

  /**
   * An event indicating that the mouse has gone down on an element.
   *
   * @event element.mousedown
   *
   * @type {Object}
   * @property {djs.model.Base} element
   * @property {SVGElement} gfx
   * @property {Event} originalEvent
   */

  /**
   * An event indicating that the mouse has gone up on an element.
   *
   * @event element.mouseup
   *
   * @type {Object}
   * @property {djs.model.Base} element
   * @property {SVGElement} gfx
   * @property {Event} originalEvent
   */

  /**
   * An event indicating that the context menu action is triggered
   * via mouse or touch controls.
   *
   * @event element.contextmenu
   *
   * @type {Object}
   * @property {djs.model.Base} element
   * @property {SVGElement} gfx
   * @property {Event} originalEvent
   */

  var InteractionEventsModule = {
    __init__: ['interactionEvents'],
    interactionEvents: ['type', InteractionEvents]
  };

  var LOW_PRIORITY$1 = 500;
  /**
   * @class
   *
   * A plugin that adds an outline to shapes and connections that may be activated and styled
   * via CSS classes.
   *
   * @param {EventBus} eventBus
   * @param {Styles} styles
   * @param {ElementRegistry} elementRegistry
   */

  function Outline(eventBus, styles, elementRegistry) {
    this.offset = 6;
    var OUTLINE_STYLE = styles.cls('djs-outline', ['no-fill']);
    var self = this;

    function createOutline(gfx, bounds) {
      var outline = create('rect');
      attr$1(outline, assign({
        x: 10,
        y: 10,
        width: 100,
        height: 100
      }, OUTLINE_STYLE));
      append(gfx, outline);
      return outline;
    } // A low priortity is necessary, because outlines of labels have to be updated
    // after the label bounds have been updated in the renderer.


    eventBus.on(['shape.added', 'shape.changed'], LOW_PRIORITY$1, function (event) {
      var element = event.element,
          gfx = event.gfx;
      var outline = query('.djs-outline', gfx);

      if (!outline) {
        outline = createOutline(gfx);
      }

      self.updateShapeOutline(outline, element);
    });
    eventBus.on(['connection.added', 'connection.changed'], function (event) {
      var element = event.element,
          gfx = event.gfx;
      var outline = query('.djs-outline', gfx);

      if (!outline) {
        outline = createOutline(gfx);
      }

      self.updateConnectionOutline(outline, element);
    });
  }
  /**
   * Updates the outline of a shape respecting the dimension of the
   * element and an outline offset.
   *
   * @param  {SVGElement} outline
   * @param  {djs.model.Base} element
   */

  Outline.prototype.updateShapeOutline = function (outline, element) {
    attr$1(outline, {
      x: -this.offset,
      y: -this.offset,
      width: element.width + this.offset * 2,
      height: element.height + this.offset * 2
    });
  };
  /**
   * Updates the outline of a connection respecting the bounding box of
   * the connection and an outline offset.
   *
   * @param  {SVGElement} outline
   * @param  {djs.model.Base} element
   */


  Outline.prototype.updateConnectionOutline = function (outline, connection) {
    var bbox = getBBox(connection);
    attr$1(outline, {
      x: bbox.x - this.offset,
      y: bbox.y - this.offset,
      width: bbox.width + this.offset * 2,
      height: bbox.height + this.offset * 2
    });
  };

  Outline.$inject = ['eventBus', 'styles', 'elementRegistry'];

  var OutlineModule = {
    __init__: ['outline'],
    outline: ['type', Outline]
  };

  /**
   * A service that offers the current selection in a diagram.
   * Offers the api to control the selection, too.
   *
   * @class
   *
   * @param {EventBus} eventBus the event bus
   */

  function Selection(eventBus) {
    this._eventBus = eventBus;
    this._selectedElements = [];
    var self = this;
    eventBus.on(['shape.remove', 'connection.remove'], function (e) {
      var element = e.element;
      self.deselect(element);
    });
    eventBus.on(['diagram.clear'], function (e) {
      self.select(null);
    });
  }
  Selection.$inject = ['eventBus'];

  Selection.prototype.deselect = function (element) {
    var selectedElements = this._selectedElements;
    var idx = selectedElements.indexOf(element);

    if (idx !== -1) {
      var oldSelection = selectedElements.slice();
      selectedElements.splice(idx, 1);

      this._eventBus.fire('selection.changed', {
        oldSelection: oldSelection,
        newSelection: selectedElements
      });
    }
  };

  Selection.prototype.get = function () {
    return this._selectedElements;
  };

  Selection.prototype.isSelected = function (element) {
    return this._selectedElements.indexOf(element) !== -1;
  };
  /**
   * This method selects one or more elements on the diagram.
   *
   * By passing an additional add parameter you can decide whether or not the element(s)
   * should be added to the already existing selection or not.
   *
   * @method Selection#select
   *
   * @param  {Object|Object[]} elements element or array of elements to be selected
   * @param  {boolean} [add] whether the element(s) should be appended to the current selection, defaults to false
   */


  Selection.prototype.select = function (elements, add) {
    var selectedElements = this._selectedElements,
        oldSelection = selectedElements.slice();

    if (!isArray(elements)) {
      elements = elements ? [elements] : [];
    } // selection may be cleared by passing an empty array or null
    // to the method


    if (add) {
      forEach(elements, function (element) {
        if (selectedElements.indexOf(element) !== -1) {
          // already selected
          return;
        } else {
          selectedElements.push(element);
        }
      });
    } else {
      this._selectedElements = selectedElements = elements.slice();
    }

    this._eventBus.fire('selection.changed', {
      oldSelection: oldSelection,
      newSelection: selectedElements
    });
  };

  var MARKER_HOVER = 'hover',
      MARKER_SELECTED = 'selected';
  /**
   * A plugin that adds a visible selection UI to shapes and connections
   * by appending the <code>hover</code> and <code>selected</code> classes to them.
   *
   * @class
   *
   * Makes elements selectable, too.
   *
   * @param {EventBus} events
   * @param {SelectionService} selection
   * @param {Canvas} canvas
   */

  function SelectionVisuals(events, canvas, selection, styles) {
    this._multiSelectionBox = null;

    function addMarker(e, cls) {
      canvas.addMarker(e, cls);
    }

    function removeMarker(e, cls) {
      canvas.removeMarker(e, cls);
    }

    events.on('element.hover', function (event) {
      addMarker(event.element, MARKER_HOVER);
    });
    events.on('element.out', function (event) {
      removeMarker(event.element, MARKER_HOVER);
    });
    events.on('selection.changed', function (event) {
      function deselect(s) {
        removeMarker(s, MARKER_SELECTED);
      }

      function select(s) {
        addMarker(s, MARKER_SELECTED);
      }

      var oldSelection = event.oldSelection,
          newSelection = event.newSelection;
      forEach(oldSelection, function (e) {
        if (newSelection.indexOf(e) === -1) {
          deselect(e);
        }
      });
      forEach(newSelection, function (e) {
        if (oldSelection.indexOf(e) === -1) {
          select(e);
        }
      });
    });
  }
  SelectionVisuals.$inject = ['eventBus', 'canvas', 'selection', 'styles'];

  function SelectionBehavior(eventBus, selection, canvas, elementRegistry) {
    // Select elements on create
    eventBus.on('create.end', 500, function (event) {
      var context = event.context,
          canExecute = context.canExecute,
          elements = context.elements,
          hints = context.hints || {},
          autoSelect = hints.autoSelect;

      if (canExecute) {
        if (autoSelect === false) {
          // Select no elements
          return;
        }

        if (isArray(autoSelect)) {
          selection.select(autoSelect);
        } else {
          // Select all elements by default
          selection.select(elements.filter(isShown));
        }
      }
    }); // Select connection targets on connect

    eventBus.on('connect.end', 500, function (event) {
      var context = event.context,
          canExecute = context.canExecute,
          hover = context.hover;

      if (canExecute && hover) {
        selection.select(hover);
      }
    }); // Select shapes on move

    eventBus.on('shape.move.end', 500, function (event) {
      var previousSelection = event.previousSelection || [];
      var shape = elementRegistry.get(event.context.shape.id); // Always select main shape on move

      var isSelected = find(previousSelection, function (selectedShape) {
        return shape.id === selectedShape.id;
      });

      if (!isSelected) {
        selection.select(shape);
      }
    }); // Select elements on click

    eventBus.on('element.click', function (event) {
      if (!isPrimaryButton(event)) {
        return;
      }

      var element = event.element;

      if (element === canvas.getRootElement()) {
        element = null;
      }

      var isSelected = selection.isSelected(element),
          isMultiSelect = selection.get().length > 1; // Add to selection if CTRL or SHIFT pressed

      var add = hasPrimaryModifier(event) || hasSecondaryModifier(event);

      if (isSelected && isMultiSelect) {
        if (add) {
          // Deselect element
          return selection.deselect(element);
        } else {
          // Select element only
          return selection.select(element);
        }
      } else if (!isSelected) {
        // Select element
        selection.select(element, add);
      } else {
        // Deselect element
        selection.deselect(element);
      }
    });
  }
  SelectionBehavior.$inject = ['eventBus', 'selection', 'canvas', 'elementRegistry'];

  function isShown(element) {
    return !element.hidden;
  }

  var SelectionModule = {
    __init__: ['selectionVisuals', 'selectionBehavior'],
    __depends__: [InteractionEventsModule, OutlineModule],
    selection: ['type', Selection],
    selectionVisuals: ['type', SelectionVisuals],
    selectionBehavior: ['type', SelectionBehavior]
  };

  /**
   * Util that provides unique IDs.
   *
   * @class djs.util.IdGenerator
   * @constructor
   * @memberOf djs.util
   *
   * The ids can be customized via a given prefix and contain a random value to avoid collisions.
   *
   * @param {string} prefix a prefix to prepend to generated ids (for better readability)
   */
  function IdGenerator(prefix) {
    this._counter = 0;
    this._prefix = (prefix ? prefix + '-' : '') + Math.floor(Math.random() * 1000000000) + '-';
  }
  /**
   * Returns a next unique ID.
   *
   * @method djs.util.IdGenerator#next
   *
   * @returns {string} the id
   */

  IdGenerator.prototype.next = function () {
    return this._prefix + ++this._counter;
  };

  var ids$1 = new IdGenerator('ov');
  var LOW_PRIORITY$2 = 500;
  /**
   * A service that allows users to attach overlays to diagram elements.
   *
   * The overlay service will take care of overlay positioning during updates.
   *
   * @example
   *
   * // add a pink badge on the top left of the shape
   * overlays.add(someShape, {
   *   position: {
   *     top: -5,
   *     left: -5
   *   },
   *   html: '<div style="width: 10px; background: fuchsia; color: white;">0</div>'
   * });
   *
   * // or add via shape id
   *
   * overlays.add('some-element-id', {
   *   position: {
   *     top: -5,
   *     left: -5
   *   }
   *   html: '<div style="width: 10px; background: fuchsia; color: white;">0</div>'
   * });
   *
   * // or add with optional type
   *
   * overlays.add(someShape, 'badge', {
   *   position: {
   *     top: -5,
   *     left: -5
   *   }
   *   html: '<div style="width: 10px; background: fuchsia; color: white;">0</div>'
   * });
   *
   *
   * // remove an overlay
   *
   * var id = overlays.add(...);
   * overlays.remove(id);
   *
   *
   * You may configure overlay defaults during tool by providing a `config` module
   * with `overlays.defaults` as an entry:
   *
   * {
   *   overlays: {
   *     defaults: {
   *       show: {
   *         minZoom: 0.7,
   *         maxZoom: 5.0
   *       },
   *       scale: {
   *         min: 1
   *       }
   *     }
   * }
   *
   * @param {Object} config
   * @param {EventBus} eventBus
   * @param {Canvas} canvas
   * @param {ElementRegistry} elementRegistry
   */

  function Overlays(config, eventBus, canvas, elementRegistry) {
    this._eventBus = eventBus;
    this._canvas = canvas;
    this._elementRegistry = elementRegistry;
    this._ids = ids$1;
    this._overlayDefaults = assign({
      // no show constraints
      show: null,
      // always scale
      scale: true
    }, config && config.defaults);
    /**
     * Mapping overlayId -> overlay
     */

    this._overlays = {};
    /**
     * Mapping elementId -> overlay container
     */

    this._overlayContainers = []; // root html element for all overlays

    this._overlayRoot = createRoot(canvas.getContainer());

    this._init();
  }
  Overlays.$inject = ['config.overlays', 'eventBus', 'canvas', 'elementRegistry'];
  /**
   * Returns the overlay with the specified id or a list of overlays
   * for an element with a given type.
   *
   * @example
   *
   * // return the single overlay with the given id
   * overlays.get('some-id');
   *
   * // return all overlays for the shape
   * overlays.get({ element: someShape });
   *
   * // return all overlays on shape with type 'badge'
   * overlays.get({ element: someShape, type: 'badge' });
   *
   * // shape can also be specified as id
   * overlays.get({ element: 'element-id', type: 'badge' });
   *
   *
   * @param {Object} search
   * @param {string} [search.id]
   * @param {string|djs.model.Base} [search.element]
   * @param {string} [search.type]
   *
   * @return {Object|Array<Object>} the overlay(s)
   */

  Overlays.prototype.get = function (search) {
    if (isString(search)) {
      search = {
        id: search
      };
    }

    if (isString(search.element)) {
      search.element = this._elementRegistry.get(search.element);
    }

    if (search.element) {
      var container = this._getOverlayContainer(search.element, true); // return a list of overlays when searching by element (+type)


      if (container) {
        return search.type ? filter(container.overlays, matchPattern({
          type: search.type
        })) : container.overlays.slice();
      } else {
        return [];
      }
    } else if (search.type) {
      return filter(this._overlays, matchPattern({
        type: search.type
      }));
    } else {
      // return single element when searching by id
      return search.id ? this._overlays[search.id] : null;
    }
  };
  /**
   * Adds a HTML overlay to an element.
   *
   * @param {string|djs.model.Base}   element   attach overlay to this shape
   * @param {string}                  [type]    optional type to assign to the overlay
   * @param {Object}                  overlay   the overlay configuration
   *
   * @param {string|DOMElement}       overlay.html                 html element to use as an overlay
   * @param {Object}                  [overlay.show]               show configuration
   * @param {number}                  [overlay.show.minZoom]       minimal zoom level to show the overlay
   * @param {number}                  [overlay.show.maxZoom]       maximum zoom level to show the overlay
   * @param {Object}                  overlay.position             where to attach the overlay
   * @param {number}                  [overlay.position.left]      relative to element bbox left attachment
   * @param {number}                  [overlay.position.top]       relative to element bbox top attachment
   * @param {number}                  [overlay.position.bottom]    relative to element bbox bottom attachment
   * @param {number}                  [overlay.position.right]     relative to element bbox right attachment
   * @param {boolean|Object}          [overlay.scale=true]         false to preserve the same size regardless of
   *                                                               diagram zoom
   * @param {number}                  [overlay.scale.min]
   * @param {number}                  [overlay.scale.max]
   *
   * @return {string}                 id that may be used to reference the overlay for update or removal
   */


  Overlays.prototype.add = function (element, type, overlay) {
    if (isObject(type)) {
      overlay = type;
      type = null;
    }

    if (!element.id) {
      element = this._elementRegistry.get(element);
    }

    if (!overlay.position) {
      throw new Error('must specifiy overlay position');
    }

    if (!overlay.html) {
      throw new Error('must specifiy overlay html');
    }

    if (!element) {
      throw new Error('invalid element specified');
    }

    var id = this._ids.next();

    overlay = assign({}, this._overlayDefaults, overlay, {
      id: id,
      type: type,
      element: element,
      html: overlay.html
    });

    this._addOverlay(overlay);

    return id;
  };
  /**
   * Remove an overlay with the given id or all overlays matching the given filter.
   *
   * @see Overlays#get for filter options.
   *
   * @param {string} [id]
   * @param {Object} [filter]
   */


  Overlays.prototype.remove = function (filter) {
    var overlays = this.get(filter) || [];

    if (!isArray(overlays)) {
      overlays = [overlays];
    }

    var self = this;
    forEach(overlays, function (overlay) {
      var container = self._getOverlayContainer(overlay.element, true);

      if (overlay) {
        remove(overlay.html);
        remove(overlay.htmlContainer);
        delete overlay.htmlContainer;
        delete overlay.element;
        delete self._overlays[overlay.id];
      }

      if (container) {
        var idx = container.overlays.indexOf(overlay);

        if (idx !== -1) {
          container.overlays.splice(idx, 1);
        }
      }
    });
  };

  Overlays.prototype.show = function () {
    setVisible(this._overlayRoot);
  };

  Overlays.prototype.hide = function () {
    setVisible(this._overlayRoot, false);
  };

  Overlays.prototype.clear = function () {
    this._overlays = {};
    this._overlayContainers = [];
    clear(this._overlayRoot);
  };

  Overlays.prototype._updateOverlayContainer = function (container) {
    var element = container.element,
        html = container.html; // update container left,top according to the elements x,y coordinates
    // this ensures we can attach child elements relative to this container

    var x = element.x,
        y = element.y;

    if (element.waypoints) {
      var bbox = getBBox(element);
      x = bbox.x;
      y = bbox.y;
    }

    setPosition(html, x, y);
    attr(container.html, 'data-container-id', element.id);
  };

  Overlays.prototype._updateOverlay = function (overlay) {
    var position = overlay.position,
        htmlContainer = overlay.htmlContainer,
        element = overlay.element; // update overlay html relative to shape because
    // it is already positioned on the element
    // update relative

    var left = position.left,
        top = position.top;

    if (position.right !== undefined) {
      var width;

      if (element.waypoints) {
        width = getBBox(element).width;
      } else {
        width = element.width;
      }

      left = position.right * -1 + width;
    }

    if (position.bottom !== undefined) {
      var height;

      if (element.waypoints) {
        height = getBBox(element).height;
      } else {
        height = element.height;
      }

      top = position.bottom * -1 + height;
    }

    setPosition(htmlContainer, left || 0, top || 0);
  };

  Overlays.prototype._createOverlayContainer = function (element) {
    var html = domify('<div class="djs-overlays" style="position: absolute" />');

    this._overlayRoot.appendChild(html);

    var container = {
      html: html,
      element: element,
      overlays: []
    };

    this._updateOverlayContainer(container);

    this._overlayContainers.push(container);

    return container;
  };

  Overlays.prototype._updateRoot = function (viewbox) {
    var scale = viewbox.scale || 1;
    var matrix = 'matrix(' + [scale, 0, 0, scale, -1 * viewbox.x * scale, -1 * viewbox.y * scale].join(',') + ')';
    setTransform(this._overlayRoot, matrix);
  };

  Overlays.prototype._getOverlayContainer = function (element, raw) {
    var container = find(this._overlayContainers, function (c) {
      return c.element === element;
    });

    if (!container && !raw) {
      return this._createOverlayContainer(element);
    }

    return container;
  };

  Overlays.prototype._addOverlay = function (overlay) {
    var id = overlay.id,
        element = overlay.element,
        html = overlay.html,
        htmlContainer,
        overlayContainer; // unwrap jquery (for those who need it)

    if (html.get && html.constructor.prototype.jquery) {
      html = html.get(0);
    } // create proper html elements from
    // overlay HTML strings


    if (isString(html)) {
      html = domify(html);
    }

    overlayContainer = this._getOverlayContainer(element);
    htmlContainer = domify('<div class="djs-overlay" data-overlay-id="' + id + '" style="position: absolute">');
    htmlContainer.appendChild(html);

    if (overlay.type) {
      classes(htmlContainer).add('djs-overlay-' + overlay.type);
    }

    overlay.htmlContainer = htmlContainer;
    overlayContainer.overlays.push(overlay);
    overlayContainer.html.appendChild(htmlContainer);
    this._overlays[id] = overlay;

    this._updateOverlay(overlay);

    this._updateOverlayVisibilty(overlay, this._canvas.viewbox());
  };

  Overlays.prototype._updateOverlayVisibilty = function (overlay, viewbox) {
    var show = overlay.show,
        minZoom = show && show.minZoom,
        maxZoom = show && show.maxZoom,
        htmlContainer = overlay.htmlContainer,
        visible = true;

    if (show) {
      if (isDefined(minZoom) && minZoom > viewbox.scale || isDefined(maxZoom) && maxZoom < viewbox.scale) {
        visible = false;
      }

      setVisible(htmlContainer, visible);
    }

    this._updateOverlayScale(overlay, viewbox);
  };

  Overlays.prototype._updateOverlayScale = function (overlay, viewbox) {
    var shouldScale = overlay.scale,
        minScale,
        maxScale,
        htmlContainer = overlay.htmlContainer;
    var scale,
        transform = '';

    if (shouldScale !== true) {
      if (shouldScale === false) {
        minScale = 1;
        maxScale = 1;
      } else {
        minScale = shouldScale.min;
        maxScale = shouldScale.max;
      }

      if (isDefined(minScale) && viewbox.scale < minScale) {
        scale = (1 / viewbox.scale || 1) * minScale;
      }

      if (isDefined(maxScale) && viewbox.scale > maxScale) {
        scale = (1 / viewbox.scale || 1) * maxScale;
      }
    }

    if (isDefined(scale)) {
      transform = 'scale(' + scale + ',' + scale + ')';
    }

    setTransform(htmlContainer, transform);
  };

  Overlays.prototype._updateOverlaysVisibilty = function (viewbox) {
    var self = this;
    forEach(this._overlays, function (overlay) {
      self._updateOverlayVisibilty(overlay, viewbox);
    });
  };

  Overlays.prototype._init = function () {
    var eventBus = this._eventBus;
    var self = this; // scroll/zoom integration

    function updateViewbox(viewbox) {
      self._updateRoot(viewbox);

      self._updateOverlaysVisibilty(viewbox);

      self.show();
    }

    eventBus.on('canvas.viewbox.changing', function (event) {
      self.hide();
    });
    eventBus.on('canvas.viewbox.changed', function (event) {
      updateViewbox(event.viewbox);
    }); // remove integration

    eventBus.on(['shape.remove', 'connection.remove'], function (e) {
      var element = e.element;
      var overlays = self.get({
        element: element
      });
      forEach(overlays, function (o) {
        self.remove(o.id);
      });

      var container = self._getOverlayContainer(element);

      if (container) {
        remove(container.html);

        var i = self._overlayContainers.indexOf(container);

        if (i !== -1) {
          self._overlayContainers.splice(i, 1);
        }
      }
    }); // move integration

    eventBus.on('element.changed', LOW_PRIORITY$2, function (e) {
      var element = e.element;

      var container = self._getOverlayContainer(element, true);

      if (container) {
        forEach(container.overlays, function (overlay) {
          self._updateOverlay(overlay);
        });

        self._updateOverlayContainer(container);
      }
    }); // marker integration, simply add them on the overlays as classes, too.

    eventBus.on('element.marker.update', function (e) {
      var container = self._getOverlayContainer(e.element, true);

      if (container) {
        classes(container.html)[e.add ? 'add' : 'remove'](e.marker);
      }
    }); // clear overlays with diagram

    eventBus.on('diagram.clear', this.clear, this);
  }; // helpers /////////////////////////////


  function createRoot(parentNode) {
    var root = domify('<div class="djs-overlay-container" style="position: absolute; width: 0; height: 0;" />');
    parentNode.insertBefore(root, parentNode.firstChild);
    return root;
  }

  function setPosition(el, x, y) {
    assign(el.style, {
      left: x + 'px',
      top: y + 'px'
    });
  }

  function setVisible(el, visible) {
    el.style.display = visible === false ? 'none' : '';
  }

  function setTransform(el, transform) {
    el.style['transform-origin'] = 'top left';
    ['', '-ms-', '-webkit-'].forEach(function (prefix) {
      el.style[prefix + 'transform'] = transform;
    });
  }

  var OverlaysModule = {
    __init__: ['overlays'],
    overlays: ['type', Overlays]
  };

  function DefinitionPropertiesView(eventBus, canvas) {
    this._eventBus = eventBus;
    this._canvas = canvas;
    eventBus.on('diagram.init', function () {
      this._init();
    }, this);
    eventBus.on('import.done', function (event) {
      if (!event.error) {
        this.update();
      }
    }, this);
  }
  DefinitionPropertiesView.$inject = ['eventBus', 'canvas'];
  /**
   * Initialize
   */

  DefinitionPropertiesView.prototype._init = function () {
    var canvas = this._canvas,
        eventBus = this._eventBus;
    var parent = canvas.getContainer(),
        container = this._container = domify(DefinitionPropertiesView.HTML_MARKUP);
    parent.appendChild(container);
    this.nameElement = query('.dmn-definitions-name', this._container);
    this.idElement = query('.dmn-definitions-id', this._container);
    delegate.bind(container, '.dmn-definitions-name, .dmn-definitions-id', 'mousedown', function (event) {
      event.stopPropagation();
    });
    eventBus.fire('definitionIdView.create', {
      html: container
    });
  };

  DefinitionPropertiesView.prototype.update = function () {
    var businessObject = this._canvas.getRootElement().businessObject;

    this.nameElement.textContent = businessObject.name;
    this.idElement.textContent = businessObject.id;
  };
  /* markup definition */


  DefinitionPropertiesView.HTML_MARKUP = '<div class="dmn-definitions">' + '<div class="dmn-definitions-name" title="Definition Name"></div>' + '<div class="dmn-definitions-id" title="Definition ID"></div>' + '</div>';

  function PaletteAdapter(eventBus, canvas) {
    function toggleMarker(cls, on) {
      var container = canvas.getContainer();
      classes(container).toggle(cls, on);
    }

    eventBus.on('palette.create', function () {
      toggleMarker('with-palette', true);
    });
    eventBus.on('palette.changed', function (event) {
      toggleMarker('with-palette-two-column', event.twoColumn);
    });
  }
  PaletteAdapter.$inject = ['eventBus', 'canvas'];

  var DefinitionPropertiesViewer = {
    __init__: ['definitionPropertiesView', 'definitionPropertiesPaletteAdapter'],
    definitionPropertiesView: ['type', DefinitionPropertiesView],
    definitionPropertiesPaletteAdapter: ['type', PaletteAdapter]
  };

  function _classCallCheck$3(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$3(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$3(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$3(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$3(Constructor, staticProps);
    return Constructor;
  }
  var PROVIDERS = [{
    className: 'dmn-icon-decision-table',
    matches: function matches(el) {
      var businessObject = el.businessObject;
      return is(businessObject, 'dmn:Decision') && is(businessObject.decisionLogic, 'dmn:DecisionTable');
    }
  }, {
    className: 'dmn-icon-literal-expression',
    matches: function matches(el) {
      var businessObject = el.businessObject;
      return is(businessObject, 'dmn:Decision') && is(businessObject.decisionLogic, 'dmn:LiteralExpression');
    }
  }];
  /**
   * Displays overlays that can be clicked in order to drill
   * down into a DMN element.
   */

  var DrillDown =
  /*#__PURE__*/
  function () {
    function DrillDown(injector, eventBus, overlays, config) {
      var _this = this;

      _classCallCheck$3(this, DrillDown);

      this._injector = injector;
      this._eventBus = eventBus;
      this._overlays = overlays;
      this._config = config || {
        enabled: true
      };
      eventBus.on(['shape.added'], function (_ref) {
        var element = _ref.element;

        for (var i = 0; i < PROVIDERS.length; i++) {
          var _PROVIDERS$i = PROVIDERS[i],
              matches = _PROVIDERS$i.matches,
              className = _PROVIDERS$i.className;
          var editable = matches && matches(element);

          if (editable) {
            _this.addOverlay(element, className);
          }
        }
      });
    }
    /**
     * Add overlay to an element that enables drill down.
     *
     * @param {Object} element Element to add overlay to.
     * @param {string} className
     *        CSS class that will be added to overlay in order to display icon.
     */


    _createClass$3(DrillDown, [{
      key: "addOverlay",
      value: function addOverlay(element, className) {
        var html = domify("\n      <div class=\"drill-down-overlay\">\n        <span class=\"".concat(className, "\"></span>\n      </div>\n    "));

        var overlayId = this._overlays.add(element, {
          position: {
            top: 2,
            left: 2
          },
          html: html
        }); // TODO(nikku): can we remove renamed to drillDown.enabled


        if (this._config.enabled !== false) {
          classes(html).add('interactive');
          this.bindEventListener(element, html, overlayId);
        }
      }
      /**
       * @param {Object} element
       * @param {Object} overlay
       * @param {string} id
       */

    }, {
      key: "bindEventListener",
      value: function bindEventListener(element, overlay, id) {
        var _this2 = this;

        var overlays = this._overlays,
            eventBus = this._eventBus;
        var overlaysRoot = overlays._overlayRoot;
        delegate.bind(overlaysRoot, '[data-overlay-id="' + id + '"]', 'click', function () {
          var triggerDefault = eventBus.fire('drillDown.click', {
            element: element
          });

          if (triggerDefault === false) {
            return;
          }

          _this2.drillDown(element);
        });
      }
      /**
       * Drill down into the specific element.
       *
       * @param  {djs.model.Base} element
       *
       * @return {boolean} whether drill down was executed
       */

    }, {
      key: "drillDown",
      value: function drillDown(element) {
        var parent = this._injector.get('_parent', false); // no parent; skip drill down


        if (!parent) {
          return false;
        }

        var view = parent.getView(element.businessObject); // no view to drill down to

        if (!view) {
          return false;
        }

        parent.open(view);
        return true;
      }
    }]);

    return DrillDown;
  }();
  DrillDown.$inject = ['injector', 'eventBus', 'overlays', 'config.drillDown'];

  var DrillDownModule = {
    __depends__: [OverlaysModule],
    __init__: ['drillDown'],
    drillDown: ['type', DrillDown]
  };

  /**
   * This file must not be changed or exchanged.
   *
   * @see http://bpmn.io/license for more information.
   */
  // eslint-disable-next-line

  var BPMNIO_LOGO_SVG = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 14.02 5.57" width="53" height="21" style="vertical-align:middle"><path fill="#000000" d="M1.88.92v.14c0 .41-.13.68-.4.8.33.14.46.44.46.86v.33c0 .61-.33.95-.95.95H0V0h.95c.65 0 .93.3.93.92zM.63.57v1.06h.24c.24 0 .38-.1.38-.43V.98c0-.28-.1-.4-.32-.4zm0 1.63v1.22h.36c.2 0 .32-.1.32-.39v-.35c0-.37-.12-.48-.4-.48H.63zM4.18.99v.52c0 .64-.31.98-.94.98h-.3V4h-.62V0h.92c.63 0 .94.35.94.99zM2.94.57v1.35h.3c.2 0 .3-.09.3-.37v-.6c0-.29-.1-.38-.3-.38h-.3zm2.89 2.27L6.25 0h.88v4h-.6V1.12L6.1 3.99h-.6l-.46-2.82v2.82h-.55V0h.87zM8.14 1.1V4h-.56V0h.79L9 2.4V0h.56v4h-.64zm2.49 2.29v.6h-.6v-.6zM12.12 1c0-.63.33-1 .95-1 .61 0 .95.37.95 1v2.04c0 .64-.34 1-.95 1-.62 0-.95-.37-.95-1zm.62 2.08c0 .28.13.39.33.39s.32-.1.32-.4V.98c0-.29-.12-.4-.32-.4s-.33.11-.33.4z"/><path fill="#000000" d="M0 4.53h14.02v1.04H0zM11.08 0h.63v.62h-.63zm.63 4V1h-.63v2.98z"/></svg>';
  var BPMNIO_IMG = BPMNIO_LOGO_SVG;

  function css(attrs) {
    return attrs.join(';');
  }

  var LIGHTBOX_STYLES = css(['z-index: 1001', 'position: fixed', 'top: 0', 'left: 0', 'right: 0', 'bottom: 0']);
  var BACKDROP_STYLES = css(['width: 100%', 'height: 100%', 'background: rgba(40,40,40,0.2)']);
  var NOTICE_STYLES = css(['position: absolute', 'left: 50%', 'top: 40%', 'transform: translate(-50%)', 'width: 260px', 'padding: 10px', 'background: white', 'box-shadow: 0 1px 4px rgba(0,0,0,0.3)', 'font-family: Helvetica, Arial, sans-serif', 'font-size: 14px', 'display: flex', 'line-height: 1.3']);
  /* eslint-disable max-len */

  var LIGHTBOX_MARKUP = '<div class="bjs-powered-by-lightbox" style="' + LIGHTBOX_STYLES + '">' + '<div class="backdrop" style="' + BACKDROP_STYLES + '"></div>' + '<div class="notice" style="' + NOTICE_STYLES + '">' + '<a href="https://bpmn.io" target="_blank" rel="noopener" style="margin: 15px 20px 15px 10px; align-self: center;' + '">' + BPMNIO_IMG + '</a>' + '<span>' + 'Web-based tooling for BPMN, DMN and CMMN diagrams ' + 'powered by <a href="https://bpmn.io" target="_blank" rel="noopener">bpmn.io</a>.' + '</span>' + '</div>' + '</div>';
  /* eslint-enable */

  var lightbox;
  function open() {
    if (!lightbox) {
      lightbox = domify(LIGHTBOX_MARKUP);
      delegate.bind(lightbox, '.backdrop', 'click', function (event) {
        document.body.removeChild(lightbox);
      });
    }

    document.body.appendChild(lightbox);
  }

  function ownKeys$1(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread$1(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys$1(source, true).forEach(function (key) {
          _defineProperty$1(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$1(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _defineProperty$1(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _toConsumableArray$1(arr) {
    return _arrayWithoutHoles$1(arr) || _iterableToArray$1(arr) || _nonIterableSpread$1();
  }

  function _nonIterableSpread$1() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray$1(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles$1(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    }
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }
  /**
   * A viewer for DMN diagrams.
   *
   * Have a look at {@link NavigatedViewer} or {@link Modeler} for bundles that include
   * additional features.
   *
   *
   * ## Extending the Viewer
   *
   * In order to extend the viewer pass extension modules to bootstrap via the
   * `additionalModules` option. An extension module is an object that exposes
   * named services.
   *
   * The following example depicts the integration of a simple
   * logging component that integrates with interaction events:
   *
   *
   * ```javascript
   *
   * // logging component
   * function InteractionLogger(eventBus) {
   *   eventBus.on('element.hover', function(event) {
   *     console.log()
   *   })
   * }
   *
   * InteractionLogger.$inject = [ 'eventBus' ]; // minification save
   *
   * // extension module
   * var extensionModule = {
   *   __init__: [ 'interactionLogger' ],
   *   interactionLogger: [ 'type', InteractionLogger ]
   * };
   *
   * // extend the viewer
   * var drdViewer = new Viewer({ additionalModules: [ extensionModule ] });
   * drdViewer.importXML(...);
   * ```
   *
   * @param {Object} options configuration options to pass to the viewer
   * @param {DOMElement} [options.container]
   *        the container to render the viewer in, defaults to body
   * @param {Array<didi.Module>} [options.modules]
   *        a list of modules to override the default modules
   * @param {Array<didi.Module>} [options.additionalModules]
   *        a list of modules to use with the default modules
   */

  function Viewer(options) {
    this._container = this._createContainer();
    /* <project-logo> */

    addProjectLogo(this._container);
    /* </project-logo> */

    this._init(this._container, options);
  }
  inherits_browser(Viewer, Diagram);
  /**
   * Export the currently displayed DMN diagram as
   * an SVG image.
   *
   * @param {Object} [options]
   * @param {Function} done invoked with (err, svgStr)
   */

  Viewer.prototype.saveSVG = function (options, done) {
    if (!done) {
      done = options;
      options = {};
    }

    var canvas = this.get('canvas');
    var contentNode = canvas.getDefaultLayer(),
        defsNode = query('defs', canvas._svg);
    var contents = innerSVG(contentNode),
        defs = defsNode && defsNode.outerHTML || '';
    var bbox = contentNode.getBBox();
    /* eslint-disable max-len */

    var svg = '<?xml version="1.0" encoding="utf-8"?>\n' + '<!-- created with dmn-js / http://bpmn.io -->\n' + '<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n' + '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" ' + 'width="' + bbox.width + '" height="' + bbox.height + '" ' + 'viewBox="' + bbox.x + ' ' + bbox.y + ' ' + bbox.width + ' ' + bbox.height + '" version="1.1">' + defs + contents + '</svg>';
    /* eslint-enable */

    done(null, svg);
  };

  Viewer.prototype.getModules = function () {
    return this._modules;
  };
  /**
   * Destroy the viewer instance and remove all its
   * remainders from the document tree.
   */


  Viewer.prototype.destroy = function () {
    // diagram destroy
    Diagram.prototype.destroy.call(this); // dom detach

    remove(this._container);
  };
  /**
   * Register an event listener
   *
   * Remove a previously added listener via {@link #off(event, callback)}.
   *
   * @param {string} event
   * @param {number} [priority]
   * @param {Function} callback
   * @param {Object} [that]
   */


  Viewer.prototype.on = function (event, priority, callback, target) {
    return this.get('eventBus').on(event, priority, callback, target);
  };
  /**
   * De-register an event listener
   *
   * @param {string} event
   * @param {Function} callback
   */


  Viewer.prototype.off = function (event, callback) {
    this.get('eventBus').off(event, callback);
  };

  Viewer.prototype._init = function (container, options) {
    var additionalModules = options.additionalModules,
        canvas = options.canvas,
        additionalOptions = _objectWithoutProperties(options, ["additionalModules", "canvas"]);

    var baseModules = options.modules || this.getModules(),
        staticModules = [{
      drd: ['value', this]
    }];
    var modules = [].concat(staticModules, _toConsumableArray$1(baseModules), _toConsumableArray$1(additionalModules || []));

    var diagramOptions = _objectSpread$1({}, additionalOptions, {
      canvas: _objectSpread$1({}, canvas, {
        container: container
      }),
      modules: modules
    }); // invoke diagram constructor


    Diagram.call(this, diagramOptions);

    if (options && options.container) {
      this.attachTo(options.container);
    }
  };
  /**
   * Emit an event on the underlying {@link EventBus}
   *
   * @param  {string} type
   * @param  {Object} event
   *
   * @return {Object} event processing result (if any)
   */


  Viewer.prototype._emit = function (type, event) {
    return this.get('eventBus').fire(type, event);
  };

  Viewer.prototype._createContainer = function () {
    return domify('<div class="dmn-drd-container"></div>');
  };

  Viewer.prototype.open = function (definitions, done) {
    var err; // use try/catch to not swallow synchronous exceptions
    // that may be raised during model parsing

    try {
      if (this._definitions) {
        // clear existing rendered diagram
        this.clear();
      } // update definitions


      this._definitions = definitions; // perform graphical import

      return importDRD(this, definitions, done);
    } catch (e) {
      err = e;
    }

    return done(err);
  };
  /**
   * Attach viewer to given parent node.
   *
   * @param  {Element} parentNode
   */


  Viewer.prototype.attachTo = function (parentNode) {
    if (!parentNode) {
      throw new Error('parentNode required');
    } // ensure we detach from the
    // previous, old parent


    this.detach();
    var container = this._container;
    parentNode.appendChild(container);

    this._emit('attach', {});

    this.get('canvas').resized();
  };
  /**
   * Detach viewer from parent node, if attached.
   */


  Viewer.prototype.detach = function () {
    var container = this._container,
        parentNode = container.parentNode;

    if (!parentNode) {
      return;
    }

    this._emit('detach', {});

    parentNode.removeChild(container);
  };
  Viewer.prototype._modules = [CoreModule$1, TranslateModule, SelectionModule, OverlaysModule, DefinitionPropertiesViewer, DrillDownModule];
  /**
   * Adds the project logo to the diagram container as
   * required by the bpmn.io license.
   *
   * @see http://bpmn.io/license
   *
   * @param {Element} container
   */

  function addProjectLogo(container) {
    var linkMarkup = '<a href="http://bpmn.io" ' + 'target="_blank" ' + 'class="bjs-powered-by" ' + 'title="Powered by bpmn.io" ' + 'style="position: absolute; bottom: 15px; right: 15px; z-index: 100;">' + BPMNIO_IMG + '</a>';
    var linkElement = domify(linkMarkup);
    container.appendChild(linkElement);
    componentEvent.bind(linkElement, 'click', function (event) {
      open();
      event.preventDefault();
    });
  }
  /* </project-logo> */

  function center(bounds) {
    return {
      x: bounds.x + bounds.width / 2,
      y: bounds.y + bounds.height / 2
    };
  }
  function delta(a, b) {
    return {
      x: a.x - b.x,
      y: a.y - b.y
    };
  }

  /**
   * Get the logarithm of x with base 10
   * @param  {Integer} value
   */
  function log10(x) {
    return Math.log(x) / Math.log(10);
  }

  /**
   * Get step size for given range and number of steps.
   *
   * @param {Object} range
   * @param {number} range.min
   * @param {number} range.max
   */

  function getStepSize(range, steps) {
    var minLinearRange = log10(range.min),
        maxLinearRange = log10(range.max);
    var absoluteLinearRange = Math.abs(minLinearRange) + Math.abs(maxLinearRange);
    return absoluteLinearRange / steps;
  }
  function cap(range, scale) {
    return Math.max(range.min, Math.min(range.max, scale));
  }

  var sign = Math.sign || function (n) {
    return n >= 0 ? 1 : -1;
  };

  var RANGE = {
    min: 0.2,
    max: 4
  },
      NUM_STEPS = 10;
  var DELTA_THRESHOLD = 0.1;
  var DEFAULT_SCALE = 0.75;
  /**
   * An implementation of zooming and scrolling within the
   * {@link Canvas} via the mouse wheel.
   *
   * Mouse wheel zooming / scrolling may be disabled using
   * the {@link toggle(enabled)} method.
   *
   * @param {Object} [config]
   * @param {boolean} [config.enabled=true] default enabled state
   * @param {number} [config.scale=.75] scroll sensivity
   * @param {EventBus} eventBus
   * @param {Canvas} canvas
   */

  function ZoomScroll(config, eventBus, canvas) {
    config = config || {};
    this._enabled = false;
    this._canvas = canvas;
    this._container = canvas._container;
    this._handleWheel = bind(this._handleWheel, this);
    this._totalDelta = 0;
    this._scale = config.scale || DEFAULT_SCALE;
    var self = this;
    eventBus.on('canvas.init', function (e) {
      self._init(config.enabled !== false);
    });
  }
  ZoomScroll.$inject = ['config.zoomScroll', 'eventBus', 'canvas'];

  ZoomScroll.prototype.scroll = function scroll(delta) {
    this._canvas.scroll(delta);
  };

  ZoomScroll.prototype.reset = function reset() {
    this._canvas.zoom('fit-viewport');
  };
  /**
   * Zoom depending on delta.
   *
   * @param {number} delta
   * @param {Object} position
   */


  ZoomScroll.prototype.zoom = function zoom(delta, position) {
    // zoom with half the step size of stepZoom
    var stepSize = getStepSize(RANGE, NUM_STEPS * 2); // add until threshold reached

    this._totalDelta += delta;

    if (Math.abs(this._totalDelta) > DELTA_THRESHOLD) {
      this._zoom(delta, position, stepSize); // reset


      this._totalDelta = 0;
    }
  };

  ZoomScroll.prototype._handleWheel = function handleWheel(event) {
    // event is already handled by '.djs-scrollable'
    if (closest(event.target, '.djs-scrollable', true)) {
      return;
    }

    var element = this._container;
    event.preventDefault(); // pinch to zoom is mapped to wheel + ctrlKey = true
    // in modern browsers (!)

    var isZoom = event.ctrlKey;
    var isHorizontalScroll = event.shiftKey;
    var factor = -1 * this._scale,
        delta;

    if (isZoom) {
      factor *= event.deltaMode === 0 ? 0.020 : 0.32;
    } else {
      factor *= event.deltaMode === 0 ? 1.0 : 16.0;
    }

    if (isZoom) {
      var elementRect = element.getBoundingClientRect();
      var offset = {
        x: event.clientX - elementRect.left,
        y: event.clientY - elementRect.top
      };
      delta = Math.sqrt(Math.pow(event.deltaY, 2) + Math.pow(event.deltaX, 2)) * sign(event.deltaY) * factor; // zoom in relative to diagram {x,y} coordinates

      this.zoom(delta, offset);
    } else {
      if (isHorizontalScroll) {
        delta = {
          dx: factor * event.deltaY,
          dy: 0
        };
      } else {
        delta = {
          dx: factor * event.deltaX,
          dy: factor * event.deltaY
        };
      }

      this.scroll(delta);
    }
  };
  /**
   * Zoom with fixed step size.
   *
   * @param {number} delta - Zoom delta (1 for zooming in, -1 for out).
   * @param {Object} position
   */


  ZoomScroll.prototype.stepZoom = function stepZoom(delta, position) {
    var stepSize = getStepSize(RANGE, NUM_STEPS);

    this._zoom(delta, position, stepSize);
  };
  /**
   * Zoom in/out given a step size.
   *
   * @param {number} delta
   * @param {Object} position
   * @param {number} stepSize
   */


  ZoomScroll.prototype._zoom = function (delta, position, stepSize) {
    var canvas = this._canvas;
    var direction = delta > 0 ? 1 : -1;
    var currentLinearZoomLevel = log10(canvas.zoom()); // snap to a proximate zoom step

    var newLinearZoomLevel = Math.round(currentLinearZoomLevel / stepSize) * stepSize; // increase or decrease one zoom step in the given direction

    newLinearZoomLevel += stepSize * direction; // calculate the absolute logarithmic zoom level based on the linear zoom level
    // (e.g. 2 for an absolute x2 zoom)

    var newLogZoomLevel = Math.pow(10, newLinearZoomLevel);
    canvas.zoom(cap(RANGE, newLogZoomLevel), position);
  };
  /**
   * Toggle the zoom scroll ability via mouse wheel.
   *
   * @param  {boolean} [newEnabled] new enabled state
   */


  ZoomScroll.prototype.toggle = function toggle(newEnabled) {
    var element = this._container;
    var handleWheel = this._handleWheel;
    var oldEnabled = this._enabled;

    if (typeof newEnabled === 'undefined') {
      newEnabled = !oldEnabled;
    } // only react on actual changes


    if (oldEnabled !== newEnabled) {
      // add or remove wheel listener based on
      // changed enabled state
      componentEvent[newEnabled ? 'bind' : 'unbind'](element, 'wheel', handleWheel, false);
    }

    this._enabled = newEnabled;
    return newEnabled;
  };

  ZoomScroll.prototype._init = function (newEnabled) {
    this.toggle(newEnabled);
  };

  var ZoomScroll$1 = {
    __init__: ['zoomScroll'],
    zoomScroll: ['type', ZoomScroll]
  };

  var CURSOR_CLS_PATTERN = /^djs-cursor-.*$/;
  function set$1(mode) {
    var classes$1 = classes(document.body);
    classes$1.removeMatching(CURSOR_CLS_PATTERN);

    if (mode) {
      classes$1.add('djs-cursor-' + mode);
    }
  }
  function unset() {
    set$1(null);
  }

  var TRAP_PRIORITY = 5000;
  /**
   * Installs a click trap that prevents a ghost click following a dragging operation.
   *
   * @return {Function} a function to immediately remove the installed trap.
   */

  function install(eventBus, eventName) {
    eventName = eventName || 'element.click';

    function trap() {
      return false;
    }

    eventBus.once(eventName, TRAP_PRIORITY, trap);
    return function () {
      eventBus.off(eventName, trap);
    };
  }

  var THRESHOLD = 15;
  /**
   * Move the canvas via mouse.
   *
   * @param {EventBus} eventBus
   * @param {Canvas} canvas
   */

  function MoveCanvas(eventBus, canvas) {
    var context; // listen for move on element mouse down;
    // allow others to hook into the event before us though
    // (dragging / element moving will do this)

    eventBus.on('element.mousedown', 500, function (e) {
      return handleStart(e.originalEvent);
    });

    function handleMove(event) {
      var start = context.start,
          button = context.button,
          position = toPoint(event),
          delta$1 = delta(position, start);

      if (!context.dragging && length(delta$1) > THRESHOLD) {
        context.dragging = true;

        if (button === 0) {
          install(eventBus);
        }

        set$1('grab');
      }

      if (context.dragging) {
        var lastPosition = context.last || context.start;
        delta$1 = delta(position, lastPosition);
        canvas.scroll({
          dx: delta$1.x,
          dy: delta$1.y
        });
        context.last = position;
      } // prevent select


      event.preventDefault();
    }

    function handleEnd(event) {
      componentEvent.unbind(document, 'mousemove', handleMove);
      componentEvent.unbind(document, 'mouseup', handleEnd);
      context = null;
      unset();
    }

    function handleStart(event) {
      // event is already handled by '.djs-draggable'
      if (closest(event.target, '.djs-draggable')) {
        return;
      }

      var button = event.button; // reject right mouse button or modifier key

      if (button >= 2 || event.ctrlKey || event.shiftKey || event.altKey) {
        return;
      }

      context = {
        button: button,
        start: toPoint(event)
      };
      componentEvent.bind(document, 'mousemove', handleMove);
      componentEvent.bind(document, 'mouseup', handleEnd); // we've handled the event

      return true;
    }

    this.isActive = function () {
      return !!context;
    };
  }
  MoveCanvas.$inject = ['eventBus', 'canvas']; // helpers ///////

  function length(point) {
    return Math.sqrt(Math.pow(point.x, 2) + Math.pow(point.y, 2));
  }

  var MoveCanvas$1 = {
    __init__: ['moveCanvas'],
    moveCanvas: ['type', MoveCanvas]
  };

  var hammer = createCommonjsModule(function (module) {
    /*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
    (function (window, document, exportName, undefined$1) {

      var VENDOR_PREFIXES = ['', 'webkit', 'Moz', 'MS', 'ms', 'o'];
      var TEST_ELEMENT = document.createElement('div');
      var TYPE_FUNCTION = 'function';
      var round = Math.round;
      var abs = Math.abs;
      var now = Date.now;
      /**
       * set a timeout with a given scope
       * @param {Function} fn
       * @param {Number} timeout
       * @param {Object} context
       * @returns {number}
       */

      function setTimeoutContext(fn, timeout, context) {
        return setTimeout(bindFn(fn, context), timeout);
      }
      /**
       * if the argument is an array, we want to execute the fn on each entry
       * if it aint an array we don't want to do a thing.
       * this is used by all the methods that accept a single and array argument.
       * @param {*|Array} arg
       * @param {String} fn
       * @param {Object} [context]
       * @returns {Boolean}
       */


      function invokeArrayArg(arg, fn, context) {
        if (Array.isArray(arg)) {
          each(arg, context[fn], context);
          return true;
        }

        return false;
      }
      /**
       * walk objects and arrays
       * @param {Object} obj
       * @param {Function} iterator
       * @param {Object} context
       */


      function each(obj, iterator, context) {
        var i;

        if (!obj) {
          return;
        }

        if (obj.forEach) {
          obj.forEach(iterator, context);
        } else if (obj.length !== undefined$1) {
          i = 0;

          while (i < obj.length) {
            iterator.call(context, obj[i], i, obj);
            i++;
          }
        } else {
          for (i in obj) {
            obj.hasOwnProperty(i) && iterator.call(context, obj[i], i, obj);
          }
        }
      }
      /**
       * wrap a method with a deprecation warning and stack trace
       * @param {Function} method
       * @param {String} name
       * @param {String} message
       * @returns {Function} A new function wrapping the supplied method.
       */


      function deprecate(method, name, message) {
        var deprecationMessage = 'DEPRECATED METHOD: ' + name + '\n' + message + ' AT \n';
        return function () {
          var e = new Error('get-stack-trace');
          var stack = e && e.stack ? e.stack.replace(/^[^\(]+?[\n$]/gm, '').replace(/^\s+at\s+/gm, '').replace(/^Object.<anonymous>\s*\(/gm, '{anonymous}()@') : 'Unknown Stack Trace';
          var log = window.console && (window.console.warn || window.console.log);

          if (log) {
            log.call(window.console, deprecationMessage, stack);
          }

          return method.apply(this, arguments);
        };
      }
      /**
       * extend object.
       * means that properties in dest will be overwritten by the ones in src.
       * @param {Object} target
       * @param {...Object} objects_to_assign
       * @returns {Object} target
       */


      var assign;

      if (typeof Object.assign !== 'function') {
        assign = function assign(target) {
          if (target === undefined$1 || target === null) {
            throw new TypeError('Cannot convert undefined or null to object');
          }

          var output = Object(target);

          for (var index = 1; index < arguments.length; index++) {
            var source = arguments[index];

            if (source !== undefined$1 && source !== null) {
              for (var nextKey in source) {
                if (source.hasOwnProperty(nextKey)) {
                  output[nextKey] = source[nextKey];
                }
              }
            }
          }

          return output;
        };
      } else {
        assign = Object.assign;
      }
      /**
       * extend object.
       * means that properties in dest will be overwritten by the ones in src.
       * @param {Object} dest
       * @param {Object} src
       * @param {Boolean} [merge=false]
       * @returns {Object} dest
       */


      var extend = deprecate(function extend(dest, src, merge) {
        var keys = Object.keys(src);
        var i = 0;

        while (i < keys.length) {
          if (!merge || merge && dest[keys[i]] === undefined$1) {
            dest[keys[i]] = src[keys[i]];
          }

          i++;
        }

        return dest;
      }, 'extend', 'Use `assign`.');
      /**
       * merge the values from src in the dest.
       * means that properties that exist in dest will not be overwritten by src
       * @param {Object} dest
       * @param {Object} src
       * @returns {Object} dest
       */

      var merge = deprecate(function merge(dest, src) {
        return extend(dest, src, true);
      }, 'merge', 'Use `assign`.');
      /**
       * simple class inheritance
       * @param {Function} child
       * @param {Function} base
       * @param {Object} [properties]
       */

      function inherit(child, base, properties) {
        var baseP = base.prototype,
            childP;
        childP = child.prototype = Object.create(baseP);
        childP.constructor = child;
        childP._super = baseP;

        if (properties) {
          assign(childP, properties);
        }
      }
      /**
       * simple function bind
       * @param {Function} fn
       * @param {Object} context
       * @returns {Function}
       */


      function bindFn(fn, context) {
        return function boundFn() {
          return fn.apply(context, arguments);
        };
      }
      /**
       * let a boolean value also be a function that must return a boolean
       * this first item in args will be used as the context
       * @param {Boolean|Function} val
       * @param {Array} [args]
       * @returns {Boolean}
       */


      function boolOrFn(val, args) {
        if (_typeof(val) == TYPE_FUNCTION) {
          return val.apply(args ? args[0] || undefined$1 : undefined$1, args);
        }

        return val;
      }
      /**
       * use the val2 when val1 is undefined
       * @param {*} val1
       * @param {*} val2
       * @returns {*}
       */


      function ifUndefined(val1, val2) {
        return val1 === undefined$1 ? val2 : val1;
      }
      /**
       * addEventListener with multiple events at once
       * @param {EventTarget} target
       * @param {String} types
       * @param {Function} handler
       */


      function addEventListeners(target, types, handler) {
        each(splitStr(types), function (type) {
          target.addEventListener(type, handler, false);
        });
      }
      /**
       * removeEventListener with multiple events at once
       * @param {EventTarget} target
       * @param {String} types
       * @param {Function} handler
       */


      function removeEventListeners(target, types, handler) {
        each(splitStr(types), function (type) {
          target.removeEventListener(type, handler, false);
        });
      }
      /**
       * find if a node is in the given parent
       * @method hasParent
       * @param {HTMLElement} node
       * @param {HTMLElement} parent
       * @return {Boolean} found
       */


      function hasParent(node, parent) {
        while (node) {
          if (node == parent) {
            return true;
          }

          node = node.parentNode;
        }

        return false;
      }
      /**
       * small indexOf wrapper
       * @param {String} str
       * @param {String} find
       * @returns {Boolean} found
       */


      function inStr(str, find) {
        return str.indexOf(find) > -1;
      }
      /**
       * split string on whitespace
       * @param {String} str
       * @returns {Array} words
       */


      function splitStr(str) {
        return str.trim().split(/\s+/g);
      }
      /**
       * find if a array contains the object using indexOf or a simple polyFill
       * @param {Array} src
       * @param {String} find
       * @param {String} [findByKey]
       * @return {Boolean|Number} false when not found, or the index
       */


      function inArray(src, find, findByKey) {
        if (src.indexOf && !findByKey) {
          return src.indexOf(find);
        } else {
          var i = 0;

          while (i < src.length) {
            if (findByKey && src[i][findByKey] == find || !findByKey && src[i] === find) {
              return i;
            }

            i++;
          }

          return -1;
        }
      }
      /**
       * convert array-like objects to real arrays
       * @param {Object} obj
       * @returns {Array}
       */


      function toArray(obj) {
        return Array.prototype.slice.call(obj, 0);
      }
      /**
       * unique array with objects based on a key (like 'id') or just by the array's value
       * @param {Array} src [{id:1},{id:2},{id:1}]
       * @param {String} [key]
       * @param {Boolean} [sort=False]
       * @returns {Array} [{id:1},{id:2}]
       */


      function uniqueArray(src, key, sort) {
        var results = [];
        var values = [];
        var i = 0;

        while (i < src.length) {
          var val = key ? src[i][key] : src[i];

          if (inArray(values, val) < 0) {
            results.push(src[i]);
          }

          values[i] = val;
          i++;
        }

        if (sort) {
          if (!key) {
            results = results.sort();
          } else {
            results = results.sort(function sortUniqueArray(a, b) {
              return a[key] > b[key];
            });
          }
        }

        return results;
      }
      /**
       * get the prefixed property
       * @param {Object} obj
       * @param {String} property
       * @returns {String|Undefined} prefixed
       */


      function prefixed(obj, property) {
        var prefix, prop;
        var camelProp = property[0].toUpperCase() + property.slice(1);
        var i = 0;

        while (i < VENDOR_PREFIXES.length) {
          prefix = VENDOR_PREFIXES[i];
          prop = prefix ? prefix + camelProp : property;

          if (prop in obj) {
            return prop;
          }

          i++;
        }

        return undefined$1;
      }
      /**
       * get a unique id
       * @returns {number} uniqueId
       */


      var _uniqueId = 1;

      function uniqueId() {
        return _uniqueId++;
      }
      /**
       * get the window object of an element
       * @param {HTMLElement} element
       * @returns {DocumentView|Window}
       */


      function getWindowForElement(element) {
        var doc = element.ownerDocument || element;
        return doc.defaultView || doc.parentWindow || window;
      }

      var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;
      var SUPPORT_TOUCH = 'ontouchstart' in window;
      var SUPPORT_POINTER_EVENTS = prefixed(window, 'PointerEvent') !== undefined$1;
      var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);
      var INPUT_TYPE_TOUCH = 'touch';
      var INPUT_TYPE_PEN = 'pen';
      var INPUT_TYPE_MOUSE = 'mouse';
      var INPUT_TYPE_KINECT = 'kinect';
      var COMPUTE_INTERVAL = 25;
      var INPUT_START = 1;
      var INPUT_MOVE = 2;
      var INPUT_END = 4;
      var INPUT_CANCEL = 8;
      var DIRECTION_NONE = 1;
      var DIRECTION_LEFT = 2;
      var DIRECTION_RIGHT = 4;
      var DIRECTION_UP = 8;
      var DIRECTION_DOWN = 16;
      var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;
      var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;
      var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;
      var PROPS_XY = ['x', 'y'];
      var PROPS_CLIENT_XY = ['clientX', 'clientY'];
      /**
       * create new input type manager
       * @param {Manager} manager
       * @param {Function} callback
       * @returns {Input}
       * @constructor
       */

      function Input(manager, callback) {
        var self = this;
        this.manager = manager;
        this.callback = callback;
        this.element = manager.element;
        this.target = manager.options.inputTarget; // smaller wrapper around the handler, for the scope and the enabled state of the manager,
        // so when disabled the input events are completely bypassed.

        this.domHandler = function (ev) {
          if (boolOrFn(manager.options.enable, [manager])) {
            self.handler(ev);
          }
        };

        this.init();
      }

      Input.prototype = {
        /**
         * should handle the inputEvent data and trigger the callback
         * @virtual
         */
        handler: function handler() {},

        /**
         * bind the events
         */
        init: function init() {
          this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);
          this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);
          this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
        },

        /**
         * unbind the events
         */
        destroy: function destroy() {
          this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);
          this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);
          this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
        }
      };
      /**
       * create new input type manager
       * called by the Manager constructor
       * @param {Hammer} manager
       * @returns {Input}
       */

      function createInputInstance(manager) {
        var Type;
        var inputClass = manager.options.inputClass;

        if (inputClass) {
          Type = inputClass;
        } else if (SUPPORT_POINTER_EVENTS) {
          Type = PointerEventInput;
        } else if (SUPPORT_ONLY_TOUCH) {
          Type = TouchInput;
        } else if (!SUPPORT_TOUCH) {
          Type = MouseInput;
        } else {
          Type = TouchMouseInput;
        }

        return new Type(manager, inputHandler);
      }
      /**
       * handle input events
       * @param {Manager} manager
       * @param {String} eventType
       * @param {Object} input
       */


      function inputHandler(manager, eventType, input) {
        var pointersLen = input.pointers.length;
        var changedPointersLen = input.changedPointers.length;
        var isFirst = eventType & INPUT_START && pointersLen - changedPointersLen === 0;
        var isFinal = eventType & (INPUT_END | INPUT_CANCEL) && pointersLen - changedPointersLen === 0;
        input.isFirst = !!isFirst;
        input.isFinal = !!isFinal;

        if (isFirst) {
          manager.session = {};
        } // source event is the normalized value of the domEvents
        // like 'touchstart, mouseup, pointerdown'


        input.eventType = eventType; // compute scale, rotation etc

        computeInputData(manager, input); // emit secret event

        manager.emit('hammer.input', input);
        manager.recognize(input);
        manager.session.prevInput = input;
      }
      /**
       * extend the data with some usable properties like scale, rotate, velocity etc
       * @param {Object} manager
       * @param {Object} input
       */


      function computeInputData(manager, input) {
        var session = manager.session;
        var pointers = input.pointers;
        var pointersLength = pointers.length; // store the first input to calculate the distance and direction

        if (!session.firstInput) {
          session.firstInput = simpleCloneInputData(input);
        } // to compute scale and rotation we need to store the multiple touches


        if (pointersLength > 1 && !session.firstMultiple) {
          session.firstMultiple = simpleCloneInputData(input);
        } else if (pointersLength === 1) {
          session.firstMultiple = false;
        }

        var firstInput = session.firstInput;
        var firstMultiple = session.firstMultiple;
        var offsetCenter = firstMultiple ? firstMultiple.center : firstInput.center;
        var center = input.center = getCenter(pointers);
        input.timeStamp = now();
        input.deltaTime = input.timeStamp - firstInput.timeStamp;
        input.angle = getAngle(offsetCenter, center);
        input.distance = getDistance(offsetCenter, center);
        computeDeltaXY(session, input);
        input.offsetDirection = getDirection(input.deltaX, input.deltaY);
        var overallVelocity = getVelocity(input.deltaTime, input.deltaX, input.deltaY);
        input.overallVelocityX = overallVelocity.x;
        input.overallVelocityY = overallVelocity.y;
        input.overallVelocity = abs(overallVelocity.x) > abs(overallVelocity.y) ? overallVelocity.x : overallVelocity.y;
        input.scale = firstMultiple ? getScale(firstMultiple.pointers, pointers) : 1;
        input.rotation = firstMultiple ? getRotation(firstMultiple.pointers, pointers) : 0;
        input.maxPointers = !session.prevInput ? input.pointers.length : input.pointers.length > session.prevInput.maxPointers ? input.pointers.length : session.prevInput.maxPointers;
        computeIntervalInputData(session, input); // find the correct target

        var target = manager.element;

        if (hasParent(input.srcEvent.target, target)) {
          target = input.srcEvent.target;
        }

        input.target = target;
      }

      function computeDeltaXY(session, input) {
        var center = input.center;
        var offset = session.offsetDelta || {};
        var prevDelta = session.prevDelta || {};
        var prevInput = session.prevInput || {};

        if (input.eventType === INPUT_START || prevInput.eventType === INPUT_END) {
          prevDelta = session.prevDelta = {
            x: prevInput.deltaX || 0,
            y: prevInput.deltaY || 0
          };
          offset = session.offsetDelta = {
            x: center.x,
            y: center.y
          };
        }

        input.deltaX = prevDelta.x + (center.x - offset.x);
        input.deltaY = prevDelta.y + (center.y - offset.y);
      }
      /**
       * velocity is calculated every x ms
       * @param {Object} session
       * @param {Object} input
       */


      function computeIntervalInputData(session, input) {
        var last = session.lastInterval || input,
            deltaTime = input.timeStamp - last.timeStamp,
            velocity,
            velocityX,
            velocityY,
            direction;

        if (input.eventType != INPUT_CANCEL && (deltaTime > COMPUTE_INTERVAL || last.velocity === undefined$1)) {
          var deltaX = input.deltaX - last.deltaX;
          var deltaY = input.deltaY - last.deltaY;
          var v = getVelocity(deltaTime, deltaX, deltaY);
          velocityX = v.x;
          velocityY = v.y;
          velocity = abs(v.x) > abs(v.y) ? v.x : v.y;
          direction = getDirection(deltaX, deltaY);
          session.lastInterval = input;
        } else {
          // use latest velocity info if it doesn't overtake a minimum period
          velocity = last.velocity;
          velocityX = last.velocityX;
          velocityY = last.velocityY;
          direction = last.direction;
        }

        input.velocity = velocity;
        input.velocityX = velocityX;
        input.velocityY = velocityY;
        input.direction = direction;
      }
      /**
       * create a simple clone from the input used for storage of firstInput and firstMultiple
       * @param {Object} input
       * @returns {Object} clonedInputData
       */


      function simpleCloneInputData(input) {
        // make a simple copy of the pointers because we will get a reference if we don't
        // we only need clientXY for the calculations
        var pointers = [];
        var i = 0;

        while (i < input.pointers.length) {
          pointers[i] = {
            clientX: round(input.pointers[i].clientX),
            clientY: round(input.pointers[i].clientY)
          };
          i++;
        }

        return {
          timeStamp: now(),
          pointers: pointers,
          center: getCenter(pointers),
          deltaX: input.deltaX,
          deltaY: input.deltaY
        };
      }
      /**
       * get the center of all the pointers
       * @param {Array} pointers
       * @return {Object} center contains `x` and `y` properties
       */


      function getCenter(pointers) {
        var pointersLength = pointers.length; // no need to loop when only one touch

        if (pointersLength === 1) {
          return {
            x: round(pointers[0].clientX),
            y: round(pointers[0].clientY)
          };
        }

        var x = 0,
            y = 0,
            i = 0;

        while (i < pointersLength) {
          x += pointers[i].clientX;
          y += pointers[i].clientY;
          i++;
        }

        return {
          x: round(x / pointersLength),
          y: round(y / pointersLength)
        };
      }
      /**
       * calculate the velocity between two points. unit is in px per ms.
       * @param {Number} deltaTime
       * @param {Number} x
       * @param {Number} y
       * @return {Object} velocity `x` and `y`
       */


      function getVelocity(deltaTime, x, y) {
        return {
          x: x / deltaTime || 0,
          y: y / deltaTime || 0
        };
      }
      /**
       * get the direction between two points
       * @param {Number} x
       * @param {Number} y
       * @return {Number} direction
       */


      function getDirection(x, y) {
        if (x === y) {
          return DIRECTION_NONE;
        }

        if (abs(x) >= abs(y)) {
          return x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
        }

        return y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
      }
      /**
       * calculate the absolute distance between two points
       * @param {Object} p1 {x, y}
       * @param {Object} p2 {x, y}
       * @param {Array} [props] containing x and y keys
       * @return {Number} distance
       */


      function getDistance(p1, p2, props) {
        if (!props) {
          props = PROPS_XY;
        }

        var x = p2[props[0]] - p1[props[0]],
            y = p2[props[1]] - p1[props[1]];
        return Math.sqrt(x * x + y * y);
      }
      /**
       * calculate the angle between two coordinates
       * @param {Object} p1
       * @param {Object} p2
       * @param {Array} [props] containing x and y keys
       * @return {Number} angle
       */


      function getAngle(p1, p2, props) {
        if (!props) {
          props = PROPS_XY;
        }

        var x = p2[props[0]] - p1[props[0]],
            y = p2[props[1]] - p1[props[1]];
        return Math.atan2(y, x) * 180 / Math.PI;
      }
      /**
       * calculate the rotation degrees between two pointersets
       * @param {Array} start array of pointers
       * @param {Array} end array of pointers
       * @return {Number} rotation
       */


      function getRotation(start, end) {
        return getAngle(end[1], end[0], PROPS_CLIENT_XY) + getAngle(start[1], start[0], PROPS_CLIENT_XY);
      }
      /**
       * calculate the scale factor between two pointersets
       * no scale is 1, and goes down to 0 when pinched together, and bigger when pinched out
       * @param {Array} start array of pointers
       * @param {Array} end array of pointers
       * @return {Number} scale
       */


      function getScale(start, end) {
        return getDistance(end[0], end[1], PROPS_CLIENT_XY) / getDistance(start[0], start[1], PROPS_CLIENT_XY);
      }

      var MOUSE_INPUT_MAP = {
        mousedown: INPUT_START,
        mousemove: INPUT_MOVE,
        mouseup: INPUT_END
      };
      var MOUSE_ELEMENT_EVENTS = 'mousedown';
      var MOUSE_WINDOW_EVENTS = 'mousemove mouseup';
      /**
       * Mouse events input
       * @constructor
       * @extends Input
       */

      function MouseInput() {
        this.evEl = MOUSE_ELEMENT_EVENTS;
        this.evWin = MOUSE_WINDOW_EVENTS;
        this.pressed = false; // mousedown state

        Input.apply(this, arguments);
      }

      inherit(MouseInput, Input, {
        /**
         * handle mouse events
         * @param {Object} ev
         */
        handler: function MEhandler(ev) {
          var eventType = MOUSE_INPUT_MAP[ev.type]; // on start we want to have the left mouse button down

          if (eventType & INPUT_START && ev.button === 0) {
            this.pressed = true;
          }

          if (eventType & INPUT_MOVE && ev.which !== 1) {
            eventType = INPUT_END;
          } // mouse must be down


          if (!this.pressed) {
            return;
          }

          if (eventType & INPUT_END) {
            this.pressed = false;
          }

          this.callback(this.manager, eventType, {
            pointers: [ev],
            changedPointers: [ev],
            pointerType: INPUT_TYPE_MOUSE,
            srcEvent: ev
          });
        }
      });
      var POINTER_INPUT_MAP = {
        pointerdown: INPUT_START,
        pointermove: INPUT_MOVE,
        pointerup: INPUT_END,
        pointercancel: INPUT_CANCEL,
        pointerout: INPUT_CANCEL
      }; // in IE10 the pointer types is defined as an enum

      var IE10_POINTER_TYPE_ENUM = {
        2: INPUT_TYPE_TOUCH,
        3: INPUT_TYPE_PEN,
        4: INPUT_TYPE_MOUSE,
        5: INPUT_TYPE_KINECT // see https://twitter.com/jacobrossi/status/480596438489890816

      };
      var POINTER_ELEMENT_EVENTS = 'pointerdown';
      var POINTER_WINDOW_EVENTS = 'pointermove pointerup pointercancel'; // IE10 has prefixed support, and case-sensitive

      if (window.MSPointerEvent && !window.PointerEvent) {
        POINTER_ELEMENT_EVENTS = 'MSPointerDown';
        POINTER_WINDOW_EVENTS = 'MSPointerMove MSPointerUp MSPointerCancel';
      }
      /**
       * Pointer events input
       * @constructor
       * @extends Input
       */


      function PointerEventInput() {
        this.evEl = POINTER_ELEMENT_EVENTS;
        this.evWin = POINTER_WINDOW_EVENTS;
        Input.apply(this, arguments);
        this.store = this.manager.session.pointerEvents = [];
      }

      inherit(PointerEventInput, Input, {
        /**
         * handle mouse events
         * @param {Object} ev
         */
        handler: function PEhandler(ev) {
          var store = this.store;
          var removePointer = false;
          var eventTypeNormalized = ev.type.toLowerCase().replace('ms', '');
          var eventType = POINTER_INPUT_MAP[eventTypeNormalized];
          var pointerType = IE10_POINTER_TYPE_ENUM[ev.pointerType] || ev.pointerType;
          var isTouch = pointerType == INPUT_TYPE_TOUCH; // get index of the event in the store

          var storeIndex = inArray(store, ev.pointerId, 'pointerId'); // start and mouse must be down

          if (eventType & INPUT_START && (ev.button === 0 || isTouch)) {
            if (storeIndex < 0) {
              store.push(ev);
              storeIndex = store.length - 1;
            }
          } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
            removePointer = true;
          } // it not found, so the pointer hasn't been down (so it's probably a hover)


          if (storeIndex < 0) {
            return;
          } // update the event in the store


          store[storeIndex] = ev;
          this.callback(this.manager, eventType, {
            pointers: store,
            changedPointers: [ev],
            pointerType: pointerType,
            srcEvent: ev
          });

          if (removePointer) {
            // remove from the store
            store.splice(storeIndex, 1);
          }
        }
      });
      var SINGLE_TOUCH_INPUT_MAP = {
        touchstart: INPUT_START,
        touchmove: INPUT_MOVE,
        touchend: INPUT_END,
        touchcancel: INPUT_CANCEL
      };
      var SINGLE_TOUCH_TARGET_EVENTS = 'touchstart';
      var SINGLE_TOUCH_WINDOW_EVENTS = 'touchstart touchmove touchend touchcancel';
      /**
       * Touch events input
       * @constructor
       * @extends Input
       */

      function SingleTouchInput() {
        this.evTarget = SINGLE_TOUCH_TARGET_EVENTS;
        this.evWin = SINGLE_TOUCH_WINDOW_EVENTS;
        this.started = false;
        Input.apply(this, arguments);
      }

      inherit(SingleTouchInput, Input, {
        handler: function TEhandler(ev) {
          var type = SINGLE_TOUCH_INPUT_MAP[ev.type]; // should we handle the touch events?

          if (type === INPUT_START) {
            this.started = true;
          }

          if (!this.started) {
            return;
          }

          var touches = normalizeSingleTouches.call(this, ev, type); // when done, reset the started state

          if (type & (INPUT_END | INPUT_CANCEL) && touches[0].length - touches[1].length === 0) {
            this.started = false;
          }

          this.callback(this.manager, type, {
            pointers: touches[0],
            changedPointers: touches[1],
            pointerType: INPUT_TYPE_TOUCH,
            srcEvent: ev
          });
        }
      });
      /**
       * @this {TouchInput}
       * @param {Object} ev
       * @param {Number} type flag
       * @returns {undefined|Array} [all, changed]
       */

      function normalizeSingleTouches(ev, type) {
        var all = toArray(ev.touches);
        var changed = toArray(ev.changedTouches);

        if (type & (INPUT_END | INPUT_CANCEL)) {
          all = uniqueArray(all.concat(changed), 'identifier', true);
        }

        return [all, changed];
      }

      var TOUCH_INPUT_MAP = {
        touchstart: INPUT_START,
        touchmove: INPUT_MOVE,
        touchend: INPUT_END,
        touchcancel: INPUT_CANCEL
      };
      var TOUCH_TARGET_EVENTS = 'touchstart touchmove touchend touchcancel';
      /**
       * Multi-user touch events input
       * @constructor
       * @extends Input
       */

      function TouchInput() {
        this.evTarget = TOUCH_TARGET_EVENTS;
        this.targetIds = {};
        Input.apply(this, arguments);
      }

      inherit(TouchInput, Input, {
        handler: function MTEhandler(ev) {
          var type = TOUCH_INPUT_MAP[ev.type];
          var touches = getTouches.call(this, ev, type);

          if (!touches) {
            return;
          }

          this.callback(this.manager, type, {
            pointers: touches[0],
            changedPointers: touches[1],
            pointerType: INPUT_TYPE_TOUCH,
            srcEvent: ev
          });
        }
      });
      /**
       * @this {TouchInput}
       * @param {Object} ev
       * @param {Number} type flag
       * @returns {undefined|Array} [all, changed]
       */

      function getTouches(ev, type) {
        var allTouches = toArray(ev.touches);
        var targetIds = this.targetIds; // when there is only one touch, the process can be simplified

        if (type & (INPUT_START | INPUT_MOVE) && allTouches.length === 1) {
          targetIds[allTouches[0].identifier] = true;
          return [allTouches, allTouches];
        }

        var i,
            targetTouches,
            changedTouches = toArray(ev.changedTouches),
            changedTargetTouches = [],
            target = this.target; // get target touches from touches

        targetTouches = allTouches.filter(function (touch) {
          return hasParent(touch.target, target);
        }); // collect touches

        if (type === INPUT_START) {
          i = 0;

          while (i < targetTouches.length) {
            targetIds[targetTouches[i].identifier] = true;
            i++;
          }
        } // filter changed touches to only contain touches that exist in the collected target ids


        i = 0;

        while (i < changedTouches.length) {
          if (targetIds[changedTouches[i].identifier]) {
            changedTargetTouches.push(changedTouches[i]);
          } // cleanup removed touches


          if (type & (INPUT_END | INPUT_CANCEL)) {
            delete targetIds[changedTouches[i].identifier];
          }

          i++;
        }

        if (!changedTargetTouches.length) {
          return;
        }

        return [// merge targetTouches with changedTargetTouches so it contains ALL touches, including 'end' and 'cancel'
        uniqueArray(targetTouches.concat(changedTargetTouches), 'identifier', true), changedTargetTouches];
      }
      /**
       * Combined touch and mouse input
       *
       * Touch has a higher priority then mouse, and while touching no mouse events are allowed.
       * This because touch devices also emit mouse events while doing a touch.
       *
       * @constructor
       * @extends Input
       */


      var DEDUP_TIMEOUT = 2500;
      var DEDUP_DISTANCE = 25;

      function TouchMouseInput() {
        Input.apply(this, arguments);
        var handler = bindFn(this.handler, this);
        this.touch = new TouchInput(this.manager, handler);
        this.mouse = new MouseInput(this.manager, handler);
        this.primaryTouch = null;
        this.lastTouches = [];
      }

      inherit(TouchMouseInput, Input, {
        /**
         * handle mouse and touch events
         * @param {Hammer} manager
         * @param {String} inputEvent
         * @param {Object} inputData
         */
        handler: function TMEhandler(manager, inputEvent, inputData) {
          var isTouch = inputData.pointerType == INPUT_TYPE_TOUCH,
              isMouse = inputData.pointerType == INPUT_TYPE_MOUSE;

          if (isMouse && inputData.sourceCapabilities && inputData.sourceCapabilities.firesTouchEvents) {
            return;
          } // when we're in a touch event, record touches to  de-dupe synthetic mouse event


          if (isTouch) {
            recordTouches.call(this, inputEvent, inputData);
          } else if (isMouse && isSyntheticEvent.call(this, inputData)) {
            return;
          }

          this.callback(manager, inputEvent, inputData);
        },

        /**
         * remove the event listeners
         */
        destroy: function destroy() {
          this.touch.destroy();
          this.mouse.destroy();
        }
      });

      function recordTouches(eventType, eventData) {
        if (eventType & INPUT_START) {
          this.primaryTouch = eventData.changedPointers[0].identifier;
          setLastTouch.call(this, eventData);
        } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
          setLastTouch.call(this, eventData);
        }
      }

      function setLastTouch(eventData) {
        var touch = eventData.changedPointers[0];

        if (touch.identifier === this.primaryTouch) {
          var lastTouch = {
            x: touch.clientX,
            y: touch.clientY
          };
          this.lastTouches.push(lastTouch);
          var lts = this.lastTouches;

          var removeLastTouch = function removeLastTouch() {
            var i = lts.indexOf(lastTouch);

            if (i > -1) {
              lts.splice(i, 1);
            }
          };

          setTimeout(removeLastTouch, DEDUP_TIMEOUT);
        }
      }

      function isSyntheticEvent(eventData) {
        var x = eventData.srcEvent.clientX,
            y = eventData.srcEvent.clientY;

        for (var i = 0; i < this.lastTouches.length; i++) {
          var t = this.lastTouches[i];
          var dx = Math.abs(x - t.x),
              dy = Math.abs(y - t.y);

          if (dx <= DEDUP_DISTANCE && dy <= DEDUP_DISTANCE) {
            return true;
          }
        }

        return false;
      }

      var PREFIXED_TOUCH_ACTION = prefixed(TEST_ELEMENT.style, 'touchAction');
      var NATIVE_TOUCH_ACTION = PREFIXED_TOUCH_ACTION !== undefined$1; // magical touchAction value

      var TOUCH_ACTION_COMPUTE = 'compute';
      var TOUCH_ACTION_AUTO = 'auto';
      var TOUCH_ACTION_MANIPULATION = 'manipulation'; // not implemented

      var TOUCH_ACTION_NONE = 'none';
      var TOUCH_ACTION_PAN_X = 'pan-x';
      var TOUCH_ACTION_PAN_Y = 'pan-y';
      var TOUCH_ACTION_MAP = getTouchActionProps();
      /**
       * Touch Action
       * sets the touchAction property or uses the js alternative
       * @param {Manager} manager
       * @param {String} value
       * @constructor
       */

      function TouchAction(manager, value) {
        this.manager = manager;
        this.set(value);
      }

      TouchAction.prototype = {
        /**
         * set the touchAction value on the element or enable the polyfill
         * @param {String} value
         */
        set: function set(value) {
          // find out the touch-action by the event handlers
          if (value == TOUCH_ACTION_COMPUTE) {
            value = this.compute();
          }

          if (NATIVE_TOUCH_ACTION && this.manager.element.style && TOUCH_ACTION_MAP[value]) {
            this.manager.element.style[PREFIXED_TOUCH_ACTION] = value;
          }

          this.actions = value.toLowerCase().trim();
        },

        /**
         * just re-set the touchAction value
         */
        update: function update() {
          this.set(this.manager.options.touchAction);
        },

        /**
         * compute the value for the touchAction property based on the recognizer's settings
         * @returns {String} value
         */
        compute: function compute() {
          var actions = [];
          each(this.manager.recognizers, function (recognizer) {
            if (boolOrFn(recognizer.options.enable, [recognizer])) {
              actions = actions.concat(recognizer.getTouchAction());
            }
          });
          return cleanTouchActions(actions.join(' '));
        },

        /**
         * this method is called on each input cycle and provides the preventing of the browser behavior
         * @param {Object} input
         */
        preventDefaults: function preventDefaults(input) {
          var srcEvent = input.srcEvent;
          var direction = input.offsetDirection; // if the touch action did prevented once this session

          if (this.manager.session.prevented) {
            srcEvent.preventDefault();
            return;
          }

          var actions = this.actions;
          var hasNone = inStr(actions, TOUCH_ACTION_NONE) && !TOUCH_ACTION_MAP[TOUCH_ACTION_NONE];
          var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_Y];
          var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_X];

          if (hasNone) {
            //do not prevent defaults if this is a tap gesture
            var isTapPointer = input.pointers.length === 1;
            var isTapMovement = input.distance < 2;
            var isTapTouchTime = input.deltaTime < 250;

            if (isTapPointer && isTapMovement && isTapTouchTime) {
              return;
            }
          }

          if (hasPanX && hasPanY) {
            // `pan-x pan-y` means browser handles all scrolling/panning, do not prevent
            return;
          }

          if (hasNone || hasPanY && direction & DIRECTION_HORIZONTAL || hasPanX && direction & DIRECTION_VERTICAL) {
            return this.preventSrc(srcEvent);
          }
        },

        /**
         * call preventDefault to prevent the browser's default behavior (scrolling in most cases)
         * @param {Object} srcEvent
         */
        preventSrc: function preventSrc(srcEvent) {
          this.manager.session.prevented = true;
          srcEvent.preventDefault();
        }
      };
      /**
       * when the touchActions are collected they are not a valid value, so we need to clean things up. *
       * @param {String} actions
       * @returns {*}
       */

      function cleanTouchActions(actions) {
        // none
        if (inStr(actions, TOUCH_ACTION_NONE)) {
          return TOUCH_ACTION_NONE;
        }

        var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X);
        var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y); // if both pan-x and pan-y are set (different recognizers
        // for different directions, e.g. horizontal pan but vertical swipe?)
        // we need none (as otherwise with pan-x pan-y combined none of these
        // recognizers will work, since the browser would handle all panning

        if (hasPanX && hasPanY) {
          return TOUCH_ACTION_NONE;
        } // pan-x OR pan-y


        if (hasPanX || hasPanY) {
          return hasPanX ? TOUCH_ACTION_PAN_X : TOUCH_ACTION_PAN_Y;
        } // manipulation


        if (inStr(actions, TOUCH_ACTION_MANIPULATION)) {
          return TOUCH_ACTION_MANIPULATION;
        }

        return TOUCH_ACTION_AUTO;
      }

      function getTouchActionProps() {
        if (!NATIVE_TOUCH_ACTION) {
          return false;
        }

        var touchMap = {};
        var cssSupports = window.CSS && window.CSS.supports;
        ['auto', 'manipulation', 'pan-y', 'pan-x', 'pan-x pan-y', 'none'].forEach(function (val) {
          // If css.supports is not supported but there is native touch-action assume it supports
          // all values. This is the case for IE 10 and 11.
          touchMap[val] = cssSupports ? window.CSS.supports('touch-action', val) : true;
        });
        return touchMap;
      }
      /**
       * Recognizer flow explained; *
       * All recognizers have the initial state of POSSIBLE when a input session starts.
       * The definition of a input session is from the first input until the last input, with all it's movement in it. *
       * Example session for mouse-input: mousedown -> mousemove -> mouseup
       *
       * On each recognizing cycle (see Manager.recognize) the .recognize() method is executed
       * which determines with state it should be.
       *
       * If the recognizer has the state FAILED, CANCELLED or RECOGNIZED (equals ENDED), it is reset to
       * POSSIBLE to give it another change on the next cycle.
       *
       *               Possible
       *                  |
       *            +-----+---------------+
       *            |                     |
       *      +-----+-----+               |
       *      |           |               |
       *   Failed      Cancelled          |
       *                          +-------+------+
       *                          |              |
       *                      Recognized       Began
       *                                         |
       *                                      Changed
       *                                         |
       *                                  Ended/Recognized
       */


      var STATE_POSSIBLE = 1;
      var STATE_BEGAN = 2;
      var STATE_CHANGED = 4;
      var STATE_ENDED = 8;
      var STATE_RECOGNIZED = STATE_ENDED;
      var STATE_CANCELLED = 16;
      var STATE_FAILED = 32;
      /**
       * Recognizer
       * Every recognizer needs to extend from this class.
       * @constructor
       * @param {Object} options
       */

      function Recognizer(options) {
        this.options = assign({}, this.defaults, options || {});
        this.id = uniqueId();
        this.manager = null; // default is enable true

        this.options.enable = ifUndefined(this.options.enable, true);
        this.state = STATE_POSSIBLE;
        this.simultaneous = {};
        this.requireFail = [];
      }

      Recognizer.prototype = {
        /**
         * @virtual
         * @type {Object}
         */
        defaults: {},

        /**
         * set options
         * @param {Object} options
         * @return {Recognizer}
         */
        set: function set(options) {
          assign(this.options, options); // also update the touchAction, in case something changed about the directions/enabled state

          this.manager && this.manager.touchAction.update();
          return this;
        },

        /**
         * recognize simultaneous with an other recognizer.
         * @param {Recognizer} otherRecognizer
         * @returns {Recognizer} this
         */
        recognizeWith: function recognizeWith(otherRecognizer) {
          if (invokeArrayArg(otherRecognizer, 'recognizeWith', this)) {
            return this;
          }

          var simultaneous = this.simultaneous;
          otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

          if (!simultaneous[otherRecognizer.id]) {
            simultaneous[otherRecognizer.id] = otherRecognizer;
            otherRecognizer.recognizeWith(this);
          }

          return this;
        },

        /**
         * drop the simultaneous link. it doesnt remove the link on the other recognizer.
         * @param {Recognizer} otherRecognizer
         * @returns {Recognizer} this
         */
        dropRecognizeWith: function dropRecognizeWith(otherRecognizer) {
          if (invokeArrayArg(otherRecognizer, 'dropRecognizeWith', this)) {
            return this;
          }

          otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
          delete this.simultaneous[otherRecognizer.id];
          return this;
        },

        /**
         * recognizer can only run when an other is failing
         * @param {Recognizer} otherRecognizer
         * @returns {Recognizer} this
         */
        requireFailure: function requireFailure(otherRecognizer) {
          if (invokeArrayArg(otherRecognizer, 'requireFailure', this)) {
            return this;
          }

          var requireFail = this.requireFail;
          otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

          if (inArray(requireFail, otherRecognizer) === -1) {
            requireFail.push(otherRecognizer);
            otherRecognizer.requireFailure(this);
          }

          return this;
        },

        /**
         * drop the requireFailure link. it does not remove the link on the other recognizer.
         * @param {Recognizer} otherRecognizer
         * @returns {Recognizer} this
         */
        dropRequireFailure: function dropRequireFailure(otherRecognizer) {
          if (invokeArrayArg(otherRecognizer, 'dropRequireFailure', this)) {
            return this;
          }

          otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
          var index = inArray(this.requireFail, otherRecognizer);

          if (index > -1) {
            this.requireFail.splice(index, 1);
          }

          return this;
        },

        /**
         * has require failures boolean
         * @returns {boolean}
         */
        hasRequireFailures: function hasRequireFailures() {
          return this.requireFail.length > 0;
        },

        /**
         * if the recognizer can recognize simultaneous with an other recognizer
         * @param {Recognizer} otherRecognizer
         * @returns {Boolean}
         */
        canRecognizeWith: function canRecognizeWith(otherRecognizer) {
          return !!this.simultaneous[otherRecognizer.id];
        },

        /**
         * You should use `tryEmit` instead of `emit` directly to check
         * that all the needed recognizers has failed before emitting.
         * @param {Object} input
         */
        emit: function emit(input) {
          var self = this;
          var state = this.state;

          function emit(event) {
            self.manager.emit(event, input);
          } // 'panstart' and 'panmove'


          if (state < STATE_ENDED) {
            emit(self.options.event + stateStr(state));
          }

          emit(self.options.event); // simple 'eventName' events

          if (input.additionalEvent) {
            // additional event(panleft, panright, pinchin, pinchout...)
            emit(input.additionalEvent);
          } // panend and pancancel


          if (state >= STATE_ENDED) {
            emit(self.options.event + stateStr(state));
          }
        },

        /**
         * Check that all the require failure recognizers has failed,
         * if true, it emits a gesture event,
         * otherwise, setup the state to FAILED.
         * @param {Object} input
         */
        tryEmit: function tryEmit(input) {
          if (this.canEmit()) {
            return this.emit(input);
          } // it's failing anyway


          this.state = STATE_FAILED;
        },

        /**
         * can we emit?
         * @returns {boolean}
         */
        canEmit: function canEmit() {
          var i = 0;

          while (i < this.requireFail.length) {
            if (!(this.requireFail[i].state & (STATE_FAILED | STATE_POSSIBLE))) {
              return false;
            }

            i++;
          }

          return true;
        },

        /**
         * update the recognizer
         * @param {Object} inputData
         */
        recognize: function recognize(inputData) {
          // make a new copy of the inputData
          // so we can change the inputData without messing up the other recognizers
          var inputDataClone = assign({}, inputData); // is is enabled and allow recognizing?

          if (!boolOrFn(this.options.enable, [this, inputDataClone])) {
            this.reset();
            this.state = STATE_FAILED;
            return;
          } // reset when we've reached the end


          if (this.state & (STATE_RECOGNIZED | STATE_CANCELLED | STATE_FAILED)) {
            this.state = STATE_POSSIBLE;
          }

          this.state = this.process(inputDataClone); // the recognizer has recognized a gesture
          // so trigger an event

          if (this.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED | STATE_CANCELLED)) {
            this.tryEmit(inputDataClone);
          }
        },

        /**
         * return the state of the recognizer
         * the actual recognizing happens in this method
         * @virtual
         * @param {Object} inputData
         * @returns {Const} STATE
         */
        process: function process(inputData) {},
        // jshint ignore:line

        /**
         * return the preferred touch-action
         * @virtual
         * @returns {Array}
         */
        getTouchAction: function getTouchAction() {},

        /**
         * called when the gesture isn't allowed to recognize
         * like when another is being recognized or it is disabled
         * @virtual
         */
        reset: function reset() {}
      };
      /**
       * get a usable string, used as event postfix
       * @param {Const} state
       * @returns {String} state
       */

      function stateStr(state) {
        if (state & STATE_CANCELLED) {
          return 'cancel';
        } else if (state & STATE_ENDED) {
          return 'end';
        } else if (state & STATE_CHANGED) {
          return 'move';
        } else if (state & STATE_BEGAN) {
          return 'start';
        }

        return '';
      }
      /**
       * direction cons to string
       * @param {Const} direction
       * @returns {String}
       */


      function directionStr(direction) {
        if (direction == DIRECTION_DOWN) {
          return 'down';
        } else if (direction == DIRECTION_UP) {
          return 'up';
        } else if (direction == DIRECTION_LEFT) {
          return 'left';
        } else if (direction == DIRECTION_RIGHT) {
          return 'right';
        }

        return '';
      }
      /**
       * get a recognizer by name if it is bound to a manager
       * @param {Recognizer|String} otherRecognizer
       * @param {Recognizer} recognizer
       * @returns {Recognizer}
       */


      function getRecognizerByNameIfManager(otherRecognizer, recognizer) {
        var manager = recognizer.manager;

        if (manager) {
          return manager.get(otherRecognizer);
        }

        return otherRecognizer;
      }
      /**
       * This recognizer is just used as a base for the simple attribute recognizers.
       * @constructor
       * @extends Recognizer
       */


      function AttrRecognizer() {
        Recognizer.apply(this, arguments);
      }

      inherit(AttrRecognizer, Recognizer, {
        /**
         * @namespace
         * @memberof AttrRecognizer
         */
        defaults: {
          /**
           * @type {Number}
           * @default 1
           */
          pointers: 1
        },

        /**
         * Used to check if it the recognizer receives valid input, like input.distance > 10.
         * @memberof AttrRecognizer
         * @param {Object} input
         * @returns {Boolean} recognized
         */
        attrTest: function attrTest(input) {
          var optionPointers = this.options.pointers;
          return optionPointers === 0 || input.pointers.length === optionPointers;
        },

        /**
         * Process the input and return the state for the recognizer
         * @memberof AttrRecognizer
         * @param {Object} input
         * @returns {*} State
         */
        process: function process(input) {
          var state = this.state;
          var eventType = input.eventType;
          var isRecognized = state & (STATE_BEGAN | STATE_CHANGED);
          var isValid = this.attrTest(input); // on cancel input and we've recognized before, return STATE_CANCELLED

          if (isRecognized && (eventType & INPUT_CANCEL || !isValid)) {
            return state | STATE_CANCELLED;
          } else if (isRecognized || isValid) {
            if (eventType & INPUT_END) {
              return state | STATE_ENDED;
            } else if (!(state & STATE_BEGAN)) {
              return STATE_BEGAN;
            }

            return state | STATE_CHANGED;
          }

          return STATE_FAILED;
        }
      });
      /**
       * Pan
       * Recognized when the pointer is down and moved in the allowed direction.
       * @constructor
       * @extends AttrRecognizer
       */

      function PanRecognizer() {
        AttrRecognizer.apply(this, arguments);
        this.pX = null;
        this.pY = null;
      }

      inherit(PanRecognizer, AttrRecognizer, {
        /**
         * @namespace
         * @memberof PanRecognizer
         */
        defaults: {
          event: 'pan',
          threshold: 10,
          pointers: 1,
          direction: DIRECTION_ALL
        },
        getTouchAction: function getTouchAction() {
          var direction = this.options.direction;
          var actions = [];

          if (direction & DIRECTION_HORIZONTAL) {
            actions.push(TOUCH_ACTION_PAN_Y);
          }

          if (direction & DIRECTION_VERTICAL) {
            actions.push(TOUCH_ACTION_PAN_X);
          }

          return actions;
        },
        directionTest: function directionTest(input) {
          var options = this.options;
          var hasMoved = true;
          var distance = input.distance;
          var direction = input.direction;
          var x = input.deltaX;
          var y = input.deltaY; // lock to axis?

          if (!(direction & options.direction)) {
            if (options.direction & DIRECTION_HORIZONTAL) {
              direction = x === 0 ? DIRECTION_NONE : x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
              hasMoved = x != this.pX;
              distance = Math.abs(input.deltaX);
            } else {
              direction = y === 0 ? DIRECTION_NONE : y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
              hasMoved = y != this.pY;
              distance = Math.abs(input.deltaY);
            }
          }

          input.direction = direction;
          return hasMoved && distance > options.threshold && direction & options.direction;
        },
        attrTest: function attrTest(input) {
          return AttrRecognizer.prototype.attrTest.call(this, input) && (this.state & STATE_BEGAN || !(this.state & STATE_BEGAN) && this.directionTest(input));
        },
        emit: function emit(input) {
          this.pX = input.deltaX;
          this.pY = input.deltaY;
          var direction = directionStr(input.direction);

          if (direction) {
            input.additionalEvent = this.options.event + direction;
          }

          this._super.emit.call(this, input);
        }
      });
      /**
       * Pinch
       * Recognized when two or more pointers are moving toward (zoom-in) or away from each other (zoom-out).
       * @constructor
       * @extends AttrRecognizer
       */

      function PinchRecognizer() {
        AttrRecognizer.apply(this, arguments);
      }

      inherit(PinchRecognizer, AttrRecognizer, {
        /**
         * @namespace
         * @memberof PinchRecognizer
         */
        defaults: {
          event: 'pinch',
          threshold: 0,
          pointers: 2
        },
        getTouchAction: function getTouchAction() {
          return [TOUCH_ACTION_NONE];
        },
        attrTest: function attrTest(input) {
          return this._super.attrTest.call(this, input) && (Math.abs(input.scale - 1) > this.options.threshold || this.state & STATE_BEGAN);
        },
        emit: function emit(input) {
          if (input.scale !== 1) {
            var inOut = input.scale < 1 ? 'in' : 'out';
            input.additionalEvent = this.options.event + inOut;
          }

          this._super.emit.call(this, input);
        }
      });
      /**
       * Press
       * Recognized when the pointer is down for x ms without any movement.
       * @constructor
       * @extends Recognizer
       */

      function PressRecognizer() {
        Recognizer.apply(this, arguments);
        this._timer = null;
        this._input = null;
      }

      inherit(PressRecognizer, Recognizer, {
        /**
         * @namespace
         * @memberof PressRecognizer
         */
        defaults: {
          event: 'press',
          pointers: 1,
          time: 251,
          // minimal time of the pointer to be pressed
          threshold: 9 // a minimal movement is ok, but keep it low

        },
        getTouchAction: function getTouchAction() {
          return [TOUCH_ACTION_AUTO];
        },
        process: function process(input) {
          var options = this.options;
          var validPointers = input.pointers.length === options.pointers;
          var validMovement = input.distance < options.threshold;
          var validTime = input.deltaTime > options.time;
          this._input = input; // we only allow little movement
          // and we've reached an end event, so a tap is possible

          if (!validMovement || !validPointers || input.eventType & (INPUT_END | INPUT_CANCEL) && !validTime) {
            this.reset();
          } else if (input.eventType & INPUT_START) {
            this.reset();
            this._timer = setTimeoutContext(function () {
              this.state = STATE_RECOGNIZED;
              this.tryEmit();
            }, options.time, this);
          } else if (input.eventType & INPUT_END) {
            return STATE_RECOGNIZED;
          }

          return STATE_FAILED;
        },
        reset: function reset() {
          clearTimeout(this._timer);
        },
        emit: function emit(input) {
          if (this.state !== STATE_RECOGNIZED) {
            return;
          }

          if (input && input.eventType & INPUT_END) {
            this.manager.emit(this.options.event + 'up', input);
          } else {
            this._input.timeStamp = now();
            this.manager.emit(this.options.event, this._input);
          }
        }
      });
      /**
       * Rotate
       * Recognized when two or more pointer are moving in a circular motion.
       * @constructor
       * @extends AttrRecognizer
       */

      function RotateRecognizer() {
        AttrRecognizer.apply(this, arguments);
      }

      inherit(RotateRecognizer, AttrRecognizer, {
        /**
         * @namespace
         * @memberof RotateRecognizer
         */
        defaults: {
          event: 'rotate',
          threshold: 0,
          pointers: 2
        },
        getTouchAction: function getTouchAction() {
          return [TOUCH_ACTION_NONE];
        },
        attrTest: function attrTest(input) {
          return this._super.attrTest.call(this, input) && (Math.abs(input.rotation) > this.options.threshold || this.state & STATE_BEGAN);
        }
      });
      /**
       * Swipe
       * Recognized when the pointer is moving fast (velocity), with enough distance in the allowed direction.
       * @constructor
       * @extends AttrRecognizer
       */

      function SwipeRecognizer() {
        AttrRecognizer.apply(this, arguments);
      }

      inherit(SwipeRecognizer, AttrRecognizer, {
        /**
         * @namespace
         * @memberof SwipeRecognizer
         */
        defaults: {
          event: 'swipe',
          threshold: 10,
          velocity: 0.3,
          direction: DIRECTION_HORIZONTAL | DIRECTION_VERTICAL,
          pointers: 1
        },
        getTouchAction: function getTouchAction() {
          return PanRecognizer.prototype.getTouchAction.call(this);
        },
        attrTest: function attrTest(input) {
          var direction = this.options.direction;
          var velocity;

          if (direction & (DIRECTION_HORIZONTAL | DIRECTION_VERTICAL)) {
            velocity = input.overallVelocity;
          } else if (direction & DIRECTION_HORIZONTAL) {
            velocity = input.overallVelocityX;
          } else if (direction & DIRECTION_VERTICAL) {
            velocity = input.overallVelocityY;
          }

          return this._super.attrTest.call(this, input) && direction & input.offsetDirection && input.distance > this.options.threshold && input.maxPointers == this.options.pointers && abs(velocity) > this.options.velocity && input.eventType & INPUT_END;
        },
        emit: function emit(input) {
          var direction = directionStr(input.offsetDirection);

          if (direction) {
            this.manager.emit(this.options.event + direction, input);
          }

          this.manager.emit(this.options.event, input);
        }
      });
      /**
       * A tap is ecognized when the pointer is doing a small tap/click. Multiple taps are recognized if they occur
       * between the given interval and position. The delay option can be used to recognize multi-taps without firing
       * a single tap.
       *
       * The eventData from the emitted event contains the property `tapCount`, which contains the amount of
       * multi-taps being recognized.
       * @constructor
       * @extends Recognizer
       */

      function TapRecognizer() {
        Recognizer.apply(this, arguments); // previous time and center,
        // used for tap counting

        this.pTime = false;
        this.pCenter = false;
        this._timer = null;
        this._input = null;
        this.count = 0;
      }

      inherit(TapRecognizer, Recognizer, {
        /**
         * @namespace
         * @memberof PinchRecognizer
         */
        defaults: {
          event: 'tap',
          pointers: 1,
          taps: 1,
          interval: 300,
          // max time between the multi-tap taps
          time: 250,
          // max time of the pointer to be down (like finger on the screen)
          threshold: 9,
          // a minimal movement is ok, but keep it low
          posThreshold: 10 // a multi-tap can be a bit off the initial position

        },
        getTouchAction: function getTouchAction() {
          return [TOUCH_ACTION_MANIPULATION];
        },
        process: function process(input) {
          var options = this.options;
          var validPointers = input.pointers.length === options.pointers;
          var validMovement = input.distance < options.threshold;
          var validTouchTime = input.deltaTime < options.time;
          this.reset();

          if (input.eventType & INPUT_START && this.count === 0) {
            return this.failTimeout();
          } // we only allow little movement
          // and we've reached an end event, so a tap is possible


          if (validMovement && validTouchTime && validPointers) {
            if (input.eventType != INPUT_END) {
              return this.failTimeout();
            }

            var validInterval = this.pTime ? input.timeStamp - this.pTime < options.interval : true;
            var validMultiTap = !this.pCenter || getDistance(this.pCenter, input.center) < options.posThreshold;
            this.pTime = input.timeStamp;
            this.pCenter = input.center;

            if (!validMultiTap || !validInterval) {
              this.count = 1;
            } else {
              this.count += 1;
            }

            this._input = input; // if tap count matches we have recognized it,
            // else it has began recognizing...

            var tapCount = this.count % options.taps;

            if (tapCount === 0) {
              // no failing requirements, immediately trigger the tap event
              // or wait as long as the multitap interval to trigger
              if (!this.hasRequireFailures()) {
                return STATE_RECOGNIZED;
              } else {
                this._timer = setTimeoutContext(function () {
                  this.state = STATE_RECOGNIZED;
                  this.tryEmit();
                }, options.interval, this);
                return STATE_BEGAN;
              }
            }
          }

          return STATE_FAILED;
        },
        failTimeout: function failTimeout() {
          this._timer = setTimeoutContext(function () {
            this.state = STATE_FAILED;
          }, this.options.interval, this);
          return STATE_FAILED;
        },
        reset: function reset() {
          clearTimeout(this._timer);
        },
        emit: function emit() {
          if (this.state == STATE_RECOGNIZED) {
            this._input.tapCount = this.count;
            this.manager.emit(this.options.event, this._input);
          }
        }
      });
      /**
       * Simple way to create a manager with a default set of recognizers.
       * @param {HTMLElement} element
       * @param {Object} [options]
       * @constructor
       */

      function Hammer(element, options) {
        options = options || {};
        options.recognizers = ifUndefined(options.recognizers, Hammer.defaults.preset);
        return new Manager(element, options);
      }
      /**
       * @const {string}
       */


      Hammer.VERSION = '2.0.7';
      /**
       * default settings
       * @namespace
       */

      Hammer.defaults = {
        /**
         * set if DOM events are being triggered.
         * But this is slower and unused by simple implementations, so disabled by default.
         * @type {Boolean}
         * @default false
         */
        domEvents: false,

        /**
         * The value for the touchAction property/fallback.
         * When set to `compute` it will magically set the correct value based on the added recognizers.
         * @type {String}
         * @default compute
         */
        touchAction: TOUCH_ACTION_COMPUTE,

        /**
         * @type {Boolean}
         * @default true
         */
        enable: true,

        /**
         * EXPERIMENTAL FEATURE -- can be removed/changed
         * Change the parent input target element.
         * If Null, then it is being set the to main element.
         * @type {Null|EventTarget}
         * @default null
         */
        inputTarget: null,

        /**
         * force an input class
         * @type {Null|Function}
         * @default null
         */
        inputClass: null,

        /**
         * Default recognizer setup when calling `Hammer()`
         * When creating a new Manager these will be skipped.
         * @type {Array}
         */
        preset: [// RecognizerClass, options, [recognizeWith, ...], [requireFailure, ...]
        [RotateRecognizer, {
          enable: false
        }], [PinchRecognizer, {
          enable: false
        }, ['rotate']], [SwipeRecognizer, {
          direction: DIRECTION_HORIZONTAL
        }], [PanRecognizer, {
          direction: DIRECTION_HORIZONTAL
        }, ['swipe']], [TapRecognizer], [TapRecognizer, {
          event: 'doubletap',
          taps: 2
        }, ['tap']], [PressRecognizer]],

        /**
         * Some CSS properties can be used to improve the working of Hammer.
         * Add them to this method and they will be set when creating a new Manager.
         * @namespace
         */
        cssProps: {
          /**
           * Disables text selection to improve the dragging gesture. Mainly for desktop browsers.
           * @type {String}
           * @default 'none'
           */
          userSelect: 'none',

          /**
           * Disable the Windows Phone grippers when pressing an element.
           * @type {String}
           * @default 'none'
           */
          touchSelect: 'none',

          /**
           * Disables the default callout shown when you touch and hold a touch target.
           * On iOS, when you touch and hold a touch target such as a link, Safari displays
           * a callout containing information about the link. This property allows you to disable that callout.
           * @type {String}
           * @default 'none'
           */
          touchCallout: 'none',

          /**
           * Specifies whether zooming is enabled. Used by IE10>
           * @type {String}
           * @default 'none'
           */
          contentZooming: 'none',

          /**
           * Specifies that an entire element should be draggable instead of its contents. Mainly for desktop browsers.
           * @type {String}
           * @default 'none'
           */
          userDrag: 'none',

          /**
           * Overrides the highlight color shown when the user taps a link or a JavaScript
           * clickable element in iOS. This property obeys the alpha value, if specified.
           * @type {String}
           * @default 'rgba(0,0,0,0)'
           */
          tapHighlightColor: 'rgba(0,0,0,0)'
        }
      };
      var STOP = 1;
      var FORCED_STOP = 2;
      /**
       * Manager
       * @param {HTMLElement} element
       * @param {Object} [options]
       * @constructor
       */

      function Manager(element, options) {
        this.options = assign({}, Hammer.defaults, options || {});
        this.options.inputTarget = this.options.inputTarget || element;
        this.handlers = {};
        this.session = {};
        this.recognizers = [];
        this.oldCssProps = {};
        this.element = element;
        this.input = createInputInstance(this);
        this.touchAction = new TouchAction(this, this.options.touchAction);
        toggleCssProps(this, true);
        each(this.options.recognizers, function (item) {
          var recognizer = this.add(new item[0](item[1]));
          item[2] && recognizer.recognizeWith(item[2]);
          item[3] && recognizer.requireFailure(item[3]);
        }, this);
      }

      Manager.prototype = {
        /**
         * set options
         * @param {Object} options
         * @returns {Manager}
         */
        set: function set(options) {
          assign(this.options, options); // Options that need a little more setup

          if (options.touchAction) {
            this.touchAction.update();
          }

          if (options.inputTarget) {
            // Clean up existing event listeners and reinitialize
            this.input.destroy();
            this.input.target = options.inputTarget;
            this.input.init();
          }

          return this;
        },

        /**
         * stop recognizing for this session.
         * This session will be discarded, when a new [input]start event is fired.
         * When forced, the recognizer cycle is stopped immediately.
         * @param {Boolean} [force]
         */
        stop: function stop(force) {
          this.session.stopped = force ? FORCED_STOP : STOP;
        },

        /**
         * run the recognizers!
         * called by the inputHandler function on every movement of the pointers (touches)
         * it walks through all the recognizers and tries to detect the gesture that is being made
         * @param {Object} inputData
         */
        recognize: function recognize(inputData) {
          var session = this.session;

          if (session.stopped) {
            return;
          } // run the touch-action polyfill


          this.touchAction.preventDefaults(inputData);
          var recognizer;
          var recognizers = this.recognizers; // this holds the recognizer that is being recognized.
          // so the recognizer's state needs to be BEGAN, CHANGED, ENDED or RECOGNIZED
          // if no recognizer is detecting a thing, it is set to `null`

          var curRecognizer = session.curRecognizer; // reset when the last recognizer is recognized
          // or when we're in a new session

          if (!curRecognizer || curRecognizer && curRecognizer.state & STATE_RECOGNIZED) {
            curRecognizer = session.curRecognizer = null;
          }

          var i = 0;

          while (i < recognizers.length) {
            recognizer = recognizers[i]; // find out if we are allowed try to recognize the input for this one.
            // 1.   allow if the session is NOT forced stopped (see the .stop() method)
            // 2.   allow if we still haven't recognized a gesture in this session, or the this recognizer is the one
            //      that is being recognized.
            // 3.   allow if the recognizer is allowed to run simultaneous with the current recognized recognizer.
            //      this can be setup with the `recognizeWith()` method on the recognizer.

            if (session.stopped !== FORCED_STOP && ( // 1
            !curRecognizer || recognizer == curRecognizer || // 2
            recognizer.canRecognizeWith(curRecognizer))) {
              // 3
              recognizer.recognize(inputData);
            } else {
              recognizer.reset();
            } // if the recognizer has been recognizing the input as a valid gesture, we want to store this one as the
            // current active recognizer. but only if we don't already have an active recognizer


            if (!curRecognizer && recognizer.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED)) {
              curRecognizer = session.curRecognizer = recognizer;
            }

            i++;
          }
        },

        /**
         * get a recognizer by its event name.
         * @param {Recognizer|String} recognizer
         * @returns {Recognizer|Null}
         */
        get: function get(recognizer) {
          if (recognizer instanceof Recognizer) {
            return recognizer;
          }

          var recognizers = this.recognizers;

          for (var i = 0; i < recognizers.length; i++) {
            if (recognizers[i].options.event == recognizer) {
              return recognizers[i];
            }
          }

          return null;
        },

        /**
         * add a recognizer to the manager
         * existing recognizers with the same event name will be removed
         * @param {Recognizer} recognizer
         * @returns {Recognizer|Manager}
         */
        add: function add(recognizer) {
          if (invokeArrayArg(recognizer, 'add', this)) {
            return this;
          } // remove existing


          var existing = this.get(recognizer.options.event);

          if (existing) {
            this.remove(existing);
          }

          this.recognizers.push(recognizer);
          recognizer.manager = this;
          this.touchAction.update();
          return recognizer;
        },

        /**
         * remove a recognizer by name or instance
         * @param {Recognizer|String} recognizer
         * @returns {Manager}
         */
        remove: function remove(recognizer) {
          if (invokeArrayArg(recognizer, 'remove', this)) {
            return this;
          }

          recognizer = this.get(recognizer); // let's make sure this recognizer exists

          if (recognizer) {
            var recognizers = this.recognizers;
            var index = inArray(recognizers, recognizer);

            if (index !== -1) {
              recognizers.splice(index, 1);
              this.touchAction.update();
            }
          }

          return this;
        },

        /**
         * bind event
         * @param {String} events
         * @param {Function} handler
         * @returns {EventEmitter} this
         */
        on: function on(events, handler) {
          if (events === undefined$1) {
            return;
          }

          if (handler === undefined$1) {
            return;
          }

          var handlers = this.handlers;
          each(splitStr(events), function (event) {
            handlers[event] = handlers[event] || [];
            handlers[event].push(handler);
          });
          return this;
        },

        /**
         * unbind event, leave emit blank to remove all handlers
         * @param {String} events
         * @param {Function} [handler]
         * @returns {EventEmitter} this
         */
        off: function off(events, handler) {
          if (events === undefined$1) {
            return;
          }

          var handlers = this.handlers;
          each(splitStr(events), function (event) {
            if (!handler) {
              delete handlers[event];
            } else {
              handlers[event] && handlers[event].splice(inArray(handlers[event], handler), 1);
            }
          });
          return this;
        },

        /**
         * emit event to the listeners
         * @param {String} event
         * @param {Object} data
         */
        emit: function emit(event, data) {
          // we also want to trigger dom events
          if (this.options.domEvents) {
            triggerDomEvent(event, data);
          } // no handlers, so skip it all


          var handlers = this.handlers[event] && this.handlers[event].slice();

          if (!handlers || !handlers.length) {
            return;
          }

          data.type = event;

          data.preventDefault = function () {
            data.srcEvent.preventDefault();
          };

          var i = 0;

          while (i < handlers.length) {
            handlers[i](data);
            i++;
          }
        },

        /**
         * destroy the manager and unbinds all events
         * it doesn't unbind dom events, that is the user own responsibility
         */
        destroy: function destroy() {
          this.element && toggleCssProps(this, false);
          this.handlers = {};
          this.session = {};
          this.input.destroy();
          this.element = null;
        }
      };
      /**
       * add/remove the css properties as defined in manager.options.cssProps
       * @param {Manager} manager
       * @param {Boolean} add
       */

      function toggleCssProps(manager, add) {
        var element = manager.element;

        if (!element.style) {
          return;
        }

        var prop;
        each(manager.options.cssProps, function (value, name) {
          prop = prefixed(element.style, name);

          if (add) {
            manager.oldCssProps[prop] = element.style[prop];
            element.style[prop] = value;
          } else {
            element.style[prop] = manager.oldCssProps[prop] || '';
          }
        });

        if (!add) {
          manager.oldCssProps = {};
        }
      }
      /**
       * trigger dom event
       * @param {String} event
       * @param {Object} data
       */


      function triggerDomEvent(event, data) {
        var gestureEvent = document.createEvent('Event');
        gestureEvent.initEvent(event, true, true);
        gestureEvent.gesture = data;
        data.target.dispatchEvent(gestureEvent);
      }

      assign(Hammer, {
        INPUT_START: INPUT_START,
        INPUT_MOVE: INPUT_MOVE,
        INPUT_END: INPUT_END,
        INPUT_CANCEL: INPUT_CANCEL,
        STATE_POSSIBLE: STATE_POSSIBLE,
        STATE_BEGAN: STATE_BEGAN,
        STATE_CHANGED: STATE_CHANGED,
        STATE_ENDED: STATE_ENDED,
        STATE_RECOGNIZED: STATE_RECOGNIZED,
        STATE_CANCELLED: STATE_CANCELLED,
        STATE_FAILED: STATE_FAILED,
        DIRECTION_NONE: DIRECTION_NONE,
        DIRECTION_LEFT: DIRECTION_LEFT,
        DIRECTION_RIGHT: DIRECTION_RIGHT,
        DIRECTION_UP: DIRECTION_UP,
        DIRECTION_DOWN: DIRECTION_DOWN,
        DIRECTION_HORIZONTAL: DIRECTION_HORIZONTAL,
        DIRECTION_VERTICAL: DIRECTION_VERTICAL,
        DIRECTION_ALL: DIRECTION_ALL,
        Manager: Manager,
        Input: Input,
        TouchAction: TouchAction,
        TouchInput: TouchInput,
        MouseInput: MouseInput,
        PointerEventInput: PointerEventInput,
        TouchMouseInput: TouchMouseInput,
        SingleTouchInput: SingleTouchInput,
        Recognizer: Recognizer,
        AttrRecognizer: AttrRecognizer,
        Tap: TapRecognizer,
        Pan: PanRecognizer,
        Swipe: SwipeRecognizer,
        Pinch: PinchRecognizer,
        Rotate: RotateRecognizer,
        Press: PressRecognizer,
        on: addEventListeners,
        off: removeEventListeners,
        each: each,
        merge: merge,
        extend: extend,
        assign: assign,
        inherit: inherit,
        bindFn: bindFn,
        prefixed: prefixed
      }); // this prevents errors when Hammer is loaded in the presence of an AMD
      //  style loader but by script tag, not by the loader.

      var freeGlobal = typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : {}; // jshint ignore:line

      freeGlobal.Hammer = Hammer;

      if (typeof undefined$1 === 'function' && undefined$1.amd) {
        undefined$1(function () {
          return Hammer;
        });
      } else if ( module.exports) {
        module.exports = Hammer;
      } else {
        window[exportName] = Hammer;
      }
    })(window, document, 'Hammer');
  });

  var MIN_ZOOM = 0.2,
      MAX_ZOOM = 4;
  var mouseEvents = ['mousedown', 'mouseup', 'mouseover', 'mouseout', 'click', 'dblclick'];

  function get$1(service, injector) {
    return injector.get(service, false);
  }

  function stopEvent(event) {
    event.preventDefault();

    if (typeof event.stopPropagation === 'function') {
      event.stopPropagation();
    } else if (event.srcEvent && typeof event.srcEvent.stopPropagation === 'function') {
      // iPhone & iPad
      event.srcEvent.stopPropagation();
    }

    if (typeof event.stopImmediatePropagation === 'function') {
      event.stopImmediatePropagation();
    }
  }

  function createTouchRecognizer(node) {
    function stopMouse(event) {
      forEach(mouseEvents, function (e) {
        componentEvent.bind(node, e, stopEvent, true);
      });
    }

    function allowMouse(event) {
      setTimeout(function () {
        forEach(mouseEvents, function (e) {
          componentEvent.unbind(node, e, stopEvent, true);
        });
      }, 500);
    }

    componentEvent.bind(node, 'touchstart', stopMouse, true);
    componentEvent.bind(node, 'touchend', allowMouse, true);
    componentEvent.bind(node, 'touchcancel', allowMouse, true); // A touch event recognizer that handles
    // touch events only (we know, we can already handle
    // mouse events out of the box)

    var recognizer = new hammer.Manager(node, {
      inputClass: hammer.TouchInput,
      recognizers: [],
      domEvents: true
    });
    var tap = new hammer.Tap();
    var pan = new hammer.Pan({
      threshold: 10
    });
    var press = new hammer.Press();
    var pinch = new hammer.Pinch();
    var doubleTap = new hammer.Tap({
      event: 'doubletap',
      taps: 2
    });
    pinch.requireFailure(pan);
    pinch.requireFailure(press);
    recognizer.add([pan, press, pinch, doubleTap, tap]);

    recognizer.reset = function (force) {
      var recognizers = this.recognizers,
          session = this.session;

      if (session.stopped) {
        return;
      }
      recognizer.stop(force);
      setTimeout(function () {
        var i, r;

        for (i = 0; r = recognizers[i]; i++) {
          r.reset();
          r.state = 8; // FAILED STATE
        }

        session.curRecognizer = null;
      }, 0);
    };

    recognizer.on('hammer.input', function (event) {
      if (event.srcEvent.defaultPrevented) {
        recognizer.reset(true);
      }
    });
    return recognizer;
  }
  /**
   * A plugin that provides touch events for elements.
   *
   * @param {EventBus} eventBus
   * @param {InteractionEvents} interactionEvents
   */


  function TouchInteractionEvents(injector, canvas, eventBus, elementRegistry, interactionEvents) {
    // optional integrations
    var dragging = get$1('dragging', injector),
        move = get$1('move', injector),
        contextPad = get$1('contextPad', injector),
        palette = get$1('palette', injector); // the touch recognizer

    var recognizer;

    function handler(type) {
      return function (event) {
        interactionEvents.fire(type, event);
      };
    }

    function getGfx(target) {
      var node = closest(target, 'svg, .djs-element', true);
      return node;
    }

    function initEvents(svg) {
      // touch recognizer
      recognizer = createTouchRecognizer(svg);
      recognizer.on('doubletap', handler('element.dblclick'));
      recognizer.on('tap', handler('element.click'));

      function startGrabCanvas(event) {
        var lx = 0,
            ly = 0;

        function update(e) {
          var dx = e.deltaX - lx,
              dy = e.deltaY - ly;
          canvas.scroll({
            dx: dx,
            dy: dy
          });
          lx = e.deltaX;
          ly = e.deltaY;
        }

        function end(e) {
          recognizer.off('panmove', update);
          recognizer.off('panend', end);
          recognizer.off('pancancel', end);
        }

        recognizer.on('panmove', update);
        recognizer.on('panend', end);
        recognizer.on('pancancel', end);
      }

      function startGrab(event) {
        var gfx = getGfx(event.target),
            element = gfx && elementRegistry.get(gfx); // recognizer

        if (move && canvas.getRootElement() !== element) {
          return move.start(event, element, true);
        } else {
          startGrabCanvas();
        }
      }

      function startZoom(e) {
        var zoom = canvas.zoom(),
            mid = e.center;

        function update(e) {
          var ratio = 1 - (1 - e.scale) / 1.50,
              newZoom = Math.max(MIN_ZOOM, Math.min(MAX_ZOOM, ratio * zoom));
          canvas.zoom(newZoom, mid);
          stopEvent(e);
        }

        function end(e) {
          recognizer.off('pinchmove', update);
          recognizer.off('pinchend', end);
          recognizer.off('pinchcancel', end);
          recognizer.reset(true);
        }

        recognizer.on('pinchmove', update);
        recognizer.on('pinchend', end);
        recognizer.on('pinchcancel', end);
      }

      recognizer.on('panstart', startGrab);
      recognizer.on('press', startGrab);
      recognizer.on('pinchstart', startZoom);
    }

    if (dragging) {
      // simulate hover during dragging
      eventBus.on('drag.move', function (event) {
        var originalEvent = event.originalEvent;

        if (!originalEvent || originalEvent instanceof MouseEvent) {
          return;
        }

        var position = toPoint(originalEvent); // this gets really expensive ...

        var node = document.elementFromPoint(position.x, position.y),
            gfx = getGfx(node),
            element = gfx && elementRegistry.get(gfx);

        if (element !== event.hover) {
          if (event.hover) {
            dragging.out(event);
          }

          if (element) {
            dragging.hover({
              element: element,
              gfx: gfx
            });
            event.hover = element;
            event.hoverGfx = gfx;
          }
        }
      });
    }

    if (contextPad) {
      eventBus.on('contextPad.create', function (event) {
        var node = event.pad.html; // touch recognizer

        var padRecognizer = createTouchRecognizer(node);
        padRecognizer.on('panstart', function (event) {
          contextPad.trigger('dragstart', event, true);
        });
        padRecognizer.on('press', function (event) {
          contextPad.trigger('dragstart', event, true);
        });
        padRecognizer.on('tap', function (event) {
          contextPad.trigger('click', event);
        });
      });
    }

    if (palette) {
      eventBus.on('palette.create', function (event) {
        var node = event.container; // touch recognizer

        var padRecognizer = createTouchRecognizer(node);
        padRecognizer.on('panstart', function (event) {
          palette.trigger('dragstart', event, true);
        });
        padRecognizer.on('press', function (event) {
          palette.trigger('dragstart', event, true);
        });
        padRecognizer.on('tap', function (event) {
          palette.trigger('click', event);
        });
      });
    }

    eventBus.on('canvas.init', function (event) {
      initEvents(event.svg);
    });
  }
  TouchInteractionEvents.$inject = ['injector', 'canvas', 'eventBus', 'elementRegistry', 'interactionEvents', 'touchFix'];

  function TouchFix(canvas, eventBus) {
    var self = this;
    eventBus.on('canvas.init', function (e) {
      self.addBBoxMarker(e.svg);
    });
  }
  TouchFix.$inject = ['canvas', 'eventBus'];
  /**
   * Safari mobile (iOS 7) does not fire touchstart event in <SVG> element
   * if there is no shape between 0,0 and viewport elements origin.
   *
   * So touchstart event is only fired when the <g class="viewport"> element was hit.
   * Putting an element over and below the 'viewport' fixes that behavior.
   */

  TouchFix.prototype.addBBoxMarker = function (svg) {
    var markerStyle = {
      fill: 'none',
      "class": 'outer-bound-marker'
    };
    var rect1 = create('rect');
    attr$1(rect1, {
      x: -10000,
      y: 10000,
      width: 10,
      height: 10
    });
    attr$1(rect1, markerStyle);
    append(svg, rect1);
    var rect2 = create('rect');
    attr$1(rect2, {
      x: 10000,
      y: 10000,
      width: 10,
      height: 10
    });
    attr$1(rect2, markerStyle);
    append(svg, rect2);
  };

  var TouchModule = {
    __depends__: [InteractionEventsModule],
    __init__: ['touchInteractionEvents'],
    touchInteractionEvents: ['type', TouchInteractionEvents],
    touchFix: ['type', TouchFix]
  };

  var TouchModule$1 = {
    __depends__: [TouchModule]
  };

  /**
   * A viewer that includes mouse navigation facilities
   *
   * @param {Object} options
   */

  function NavigatedViewer(options) {
    Viewer.call(this, options);
  }
  inherits_browser(NavigatedViewer, Viewer);
  NavigatedViewer.prototype._navigationModules = [ZoomScroll$1, MoveCanvas$1, TouchModule$1];
  NavigatedViewer.prototype._modules = [].concat(NavigatedViewer.prototype._modules, NavigatedViewer.prototype._navigationModules);

  function last(arr) {
    return arr && arr[arr.length - 1];
  }

  function sortTopOrMiddle(element) {
    return element.y;
  }

  function sortLeftOrCenter(element) {
    return element.x;
  }
  /**
   * Sorting functions for different types of alignment
   *
   * @type {Object}
   *
   * @return {Function}
   */


  var ALIGNMENT_SORTING = {
    left: sortLeftOrCenter,
    center: sortLeftOrCenter,
    right: function right(element) {
      return element.x + element.width;
    },
    top: sortTopOrMiddle,
    middle: sortTopOrMiddle,
    bottom: function bottom(element) {
      return element.y + element.height;
    }
  };
  function AlignElements(modeling) {
    this._modeling = modeling;
  }
  AlignElements.$inject = ['modeling'];
  /**
   * Get the relevant "axis" and "dimension" related to the current type of alignment
   *
   * @param  {string} type left|right|center|top|bottom|middle
   *
   * @return {Object} { axis, dimension }
   */

  AlignElements.prototype._getOrientationDetails = function (type) {
    var vertical = ['top', 'bottom', 'middle'],
        axis = 'x',
        dimension = 'width';

    if (vertical.indexOf(type) !== -1) {
      axis = 'y';
      dimension = 'height';
    }

    return {
      axis: axis,
      dimension: dimension
    };
  };

  AlignElements.prototype._isType = function (type, types) {
    return types.indexOf(type) !== -1;
  };
  /**
   * Get a point on the relevant axis where elements should align to
   *
   * @param  {string} type left|right|center|top|bottom|middle
   * @param  {Array} sortedElements
   *
   * @return {Object}
   */


  AlignElements.prototype._alignmentPosition = function (type, sortedElements) {
    var orientation = this._getOrientationDetails(type),
        axis = orientation.axis,
        dimension = orientation.dimension,
        alignment = {},
        centers = {},
        hasSharedCenters = false,
        centeredElements,
        firstElement,
        lastElement;

    function getMiddleOrTop(first, last) {
      return Math.round((first[axis] + last[axis] + last[dimension]) / 2);
    }

    if (this._isType(type, ['left', 'top'])) {
      alignment[type] = sortedElements[0][axis];
    } else if (this._isType(type, ['right', 'bottom'])) {
      lastElement = last(sortedElements);
      alignment[type] = lastElement[axis] + lastElement[dimension];
    } else if (this._isType(type, ['center', 'middle'])) {
      // check if there is a center shared by more than one shape
      // if not, just take the middle of the range
      forEach(sortedElements, function (element) {
        var center = element[axis] + Math.round(element[dimension] / 2);

        if (centers[center]) {
          centers[center].elements.push(element);
        } else {
          centers[center] = {
            elements: [element],
            center: center
          };
        }
      });
      centeredElements = sortBy(centers, function (center) {
        if (center.elements.length > 1) {
          hasSharedCenters = true;
        }

        return center.elements.length;
      });

      if (hasSharedCenters) {
        alignment[type] = last(centeredElements).center;
        return alignment;
      }

      firstElement = sortedElements[0];
      sortedElements = sortBy(sortedElements, function (element) {
        return element[axis] + element[dimension];
      });
      lastElement = last(sortedElements);
      alignment[type] = getMiddleOrTop(firstElement, lastElement);
    }

    return alignment;
  };
  /**
   * Executes the alignment of a selection of elements
   *
   * @param  {Array} elements [description]
   * @param  {string} type left|right|center|top|bottom|middle
   */


  AlignElements.prototype.trigger = function (elements, type) {
    var modeling = this._modeling;
    var filteredElements = filter(elements, function (element) {
      return !(element.waypoints || element.host || element.labelTarget);
    });
    var sortFn = ALIGNMENT_SORTING[type];
    var sortedElements = sortBy(filteredElements, sortFn);

    var alignment = this._alignmentPosition(type, sortedElements);

    modeling.alignElements(sortedElements, alignment);
  };

  var AlignElementsModule = {
    __init__: ['alignElements'],
    alignElements: ['type', AlignElements]
  };

  /**
   * Computes the distance between two points
   *
   * @param  {Point}  p
   * @param  {Point}  q
   *
   * @return {number}  distance
   */

  function pointDistance(a, b) {
    if (!a || !b) {
      return -1;
    }

    return Math.sqrt(Math.pow(a.x - b.x, 2) + Math.pow(a.y - b.y, 2));
  }
  /**
   * Returns true if the point r is on the line between p and q
   *
   * @param  {Point}  p
   * @param  {Point}  q
   * @param  {Point}  r
   * @param  {number} [accuracy=5] accuracy for points on line check (lower is better)
   *
   * @return {boolean}
   */

  function pointsOnLine(p, q, r, accuracy) {
    if (typeof accuracy === 'undefined') {
      accuracy = 5;
    }

    if (!p || !q || !r) {
      return false;
    }

    var val = (q.x - p.x) * (r.y - p.y) - (q.y - p.y) * (r.x - p.x),
        dist = pointDistance(p, q); // @see http://stackoverflow.com/a/907491/412190

    return Math.abs(val / dist) <= accuracy;
  }
  var ALIGNED_THRESHOLD = 2;
  /**
   * Check whether two points are horizontally or vertically aligned.
   *
   * @param {Array<Point>|Point}
   * @param {Point}
   *
   * @return {string|boolean}
   */

  function pointsAligned(a, b) {
    var points;

    if (isArray(a)) {
      points = a;
    } else {
      points = [a, b];
    }

    if (pointsAlignedHorizontally(points)) {
      return 'h';
    }

    if (pointsAlignedVertically(points)) {
      return 'v';
    }

    return false;
  }
  function pointsAlignedHorizontally(a, b) {
    var points;

    if (isArray(a)) {
      points = a;
    } else {
      points = [a, b];
    }

    var firstPoint = points.slice().shift();
    return every(points, function (point) {
      return Math.abs(firstPoint.y - point.y) <= ALIGNED_THRESHOLD;
    });
  }
  function pointsAlignedVertically(a, b) {
    var points;

    if (isArray(a)) {
      points = a;
    } else {
      points = [a, b];
    }

    var firstPoint = points.slice().shift();
    return every(points, function (point) {
      return Math.abs(firstPoint.x - point.x) <= ALIGNED_THRESHOLD;
    });
  }
  /**
   * Returns a point in the middle of points p and q
   *
   * @param  {Point}  p
   * @param  {Point}  q
   *
   * @return {Point} middle point
   */

  function getMidPoint(p, q) {
    return {
      x: Math.round(p.x + (q.x - p.x) / 2.0),
      y: Math.round(p.y + (q.y - p.y) / 2.0)
    };
  }

  /**
   * This file contains source code adapted from Snap.svg (licensed Apache-2.0).
   *
   * @see https://github.com/adobe-webplatform/Snap.svg/blob/master/src/path.js
   */

  /* eslint no-fallthrough: "off" */

  var p2s = /,?([a-z]),?/gi,
      toFloat = parseFloat,
      math = Math,
      PI = math.PI,
      mmin = math.min,
      mmax = math.max,
      pow = math.pow,
      abs = math.abs,
      pathCommand = /([a-z])[\s,]*((-?\d*\.?\d*(?:e[-+]?\d+)?[\s]*,?[\s]*)+)/ig,
      pathValues = /(-?\d*\.?\d*(?:e[-+]?\\d+)?)[\s]*,?[\s]*/ig;

  var isArray$2 = Array.isArray || function (o) {
    return o instanceof Array;
  };

  function hasProperty(obj, property) {
    return Object.prototype.hasOwnProperty.call(obj, property);
  }

  function clone$1(obj) {
    if (typeof obj == 'function' || Object(obj) !== obj) {
      return obj;
    }

    var res = new obj.constructor();

    for (var key in obj) {
      if (hasProperty(obj, key)) {
        res[key] = clone$1(obj[key]);
      }
    }

    return res;
  }

  function repush(array, item) {
    for (var i = 0, ii = array.length; i < ii; i++) {
      if (array[i] === item) {
        return array.push(array.splice(i, 1)[0]);
      }
    }
  }

  function cacher(f) {
    function newf() {
      var arg = Array.prototype.slice.call(arguments, 0),
          args = arg.join("\u2400"),
          cache = newf.cache = newf.cache || {},
          count = newf.count = newf.count || [];

      if (hasProperty(cache, args)) {
        repush(count, args);
        return cache[args];
      }

      count.length >= 1e3 && delete cache[count.shift()];
      count.push(args);
      cache[args] = f.apply(0, arg);
      return cache[args];
    }

    return newf;
  }

  function parsePathString(pathString) {
    if (!pathString) {
      return null;
    }

    var pth = paths(pathString);

    if (pth.arr) {
      return clone$1(pth.arr);
    }

    var paramCounts = {
      a: 7,
      c: 6,
      h: 1,
      l: 2,
      m: 2,
      q: 4,
      s: 4,
      t: 2,
      v: 1,
      z: 0
    },
        data = [];

    if (isArray$2(pathString) && isArray$2(pathString[0])) {
      // rough assumption
      data = clone$1(pathString);
    }

    if (!data.length) {
      String(pathString).replace(pathCommand, function (a, b, c) {
        var params = [],
            name = b.toLowerCase();
        c.replace(pathValues, function (a, b) {
          b && params.push(+b);
        });

        if (name == 'm' && params.length > 2) {
          data.push([b].concat(params.splice(0, 2)));
          name = 'l';
          b = b == 'm' ? 'l' : 'L';
        }

        while (params.length >= paramCounts[name]) {
          data.push([b].concat(params.splice(0, paramCounts[name])));

          if (!paramCounts[name]) {
            break;
          }
        }
      });
    }

    data.toString = paths.toString;
    pth.arr = clone$1(data);
    return data;
  }

  function paths(ps) {
    var p = paths.ps = paths.ps || {};

    if (p[ps]) {
      p[ps].sleep = 100;
    } else {
      p[ps] = {
        sleep: 100
      };
    }

    setTimeout(function () {
      for (var key in p) {
        if (hasProperty(p, key) && key != ps) {
          p[key].sleep--;
          !p[key].sleep && delete p[key];
        }
      }
    });
    return p[ps];
  }

  function rectBBox(x, y, width, height) {
    if (arguments.length === 1) {
      y = x.y;
      width = x.width;
      height = x.height;
      x = x.x;
    }

    return {
      x: x,
      y: y,
      width: width,
      height: height,
      x2: x + width,
      y2: y + height
    };
  }

  function pathToString() {
    return this.join(',').replace(p2s, '$1');
  }

  function pathClone(pathArray) {
    var res = clone$1(pathArray);
    res.toString = pathToString;
    return res;
  }

  function findDotsAtSegment(p1x, p1y, c1x, c1y, c2x, c2y, p2x, p2y, t) {
    var t1 = 1 - t,
        t13 = pow(t1, 3),
        t12 = pow(t1, 2),
        t2 = t * t,
        t3 = t2 * t,
        x = t13 * p1x + t12 * 3 * t * c1x + t1 * 3 * t * t * c2x + t3 * p2x,
        y = t13 * p1y + t12 * 3 * t * c1y + t1 * 3 * t * t * c2y + t3 * p2y;
    return {
      x: fixError(x),
      y: fixError(y)
    };
  }

  function bezierBBox(points) {
    var bbox = curveBBox.apply(null, points);
    return rectBBox(bbox.x0, bbox.y0, bbox.x1 - bbox.x0, bbox.y1 - bbox.y0);
  }

  function isPointInsideBBox(bbox, x, y) {
    return x >= bbox.x && x <= bbox.x + bbox.width && y >= bbox.y && y <= bbox.y + bbox.height;
  }

  function isBBoxIntersect(bbox1, bbox2) {
    bbox1 = rectBBox(bbox1);
    bbox2 = rectBBox(bbox2);
    return isPointInsideBBox(bbox2, bbox1.x, bbox1.y) || isPointInsideBBox(bbox2, bbox1.x2, bbox1.y) || isPointInsideBBox(bbox2, bbox1.x, bbox1.y2) || isPointInsideBBox(bbox2, bbox1.x2, bbox1.y2) || isPointInsideBBox(bbox1, bbox2.x, bbox2.y) || isPointInsideBBox(bbox1, bbox2.x2, bbox2.y) || isPointInsideBBox(bbox1, bbox2.x, bbox2.y2) || isPointInsideBBox(bbox1, bbox2.x2, bbox2.y2) || (bbox1.x < bbox2.x2 && bbox1.x > bbox2.x || bbox2.x < bbox1.x2 && bbox2.x > bbox1.x) && (bbox1.y < bbox2.y2 && bbox1.y > bbox2.y || bbox2.y < bbox1.y2 && bbox2.y > bbox1.y);
  }

  function base3(t, p1, p2, p3, p4) {
    var t1 = -3 * p1 + 9 * p2 - 9 * p3 + 3 * p4,
        t2 = t * t1 + 6 * p1 - 12 * p2 + 6 * p3;
    return t * t2 - 3 * p1 + 3 * p2;
  }

  function bezlen(x1, y1, x2, y2, x3, y3, x4, y4, z) {
    if (z == null) {
      z = 1;
    }

    z = z > 1 ? 1 : z < 0 ? 0 : z;
    var z2 = z / 2,
        n = 12,
        Tvalues = [-.1252, .1252, -.3678, .3678, -.5873, .5873, -.7699, .7699, -.9041, .9041, -.9816, .9816],
        Cvalues = [0.2491, 0.2491, 0.2335, 0.2335, 0.2032, 0.2032, 0.1601, 0.1601, 0.1069, 0.1069, 0.0472, 0.0472],
        sum = 0;

    for (var i = 0; i < n; i++) {
      var ct = z2 * Tvalues[i] + z2,
          xbase = base3(ct, x1, x2, x3, x4),
          ybase = base3(ct, y1, y2, y3, y4),
          comb = xbase * xbase + ybase * ybase;
      sum += Cvalues[i] * math.sqrt(comb);
    }

    return z2 * sum;
  }

  function intersectLines(x1, y1, x2, y2, x3, y3, x4, y4) {
    if (mmax(x1, x2) < mmin(x3, x4) || mmin(x1, x2) > mmax(x3, x4) || mmax(y1, y2) < mmin(y3, y4) || mmin(y1, y2) > mmax(y3, y4)) {
      return;
    }

    var nx = (x1 * y2 - y1 * x2) * (x3 - x4) - (x1 - x2) * (x3 * y4 - y3 * x4),
        ny = (x1 * y2 - y1 * x2) * (y3 - y4) - (y1 - y2) * (x3 * y4 - y3 * x4),
        denominator = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);

    if (!denominator) {
      return;
    }

    var px = fixError(nx / denominator),
        py = fixError(ny / denominator),
        px2 = +px.toFixed(2),
        py2 = +py.toFixed(2);

    if (px2 < +mmin(x1, x2).toFixed(2) || px2 > +mmax(x1, x2).toFixed(2) || px2 < +mmin(x3, x4).toFixed(2) || px2 > +mmax(x3, x4).toFixed(2) || py2 < +mmin(y1, y2).toFixed(2) || py2 > +mmax(y1, y2).toFixed(2) || py2 < +mmin(y3, y4).toFixed(2) || py2 > +mmax(y3, y4).toFixed(2)) {
      return;
    }

    return {
      x: px,
      y: py
    };
  }

  function fixError(number) {
    return Math.round(number * 100000000000) / 100000000000;
  }

  function findBezierIntersections(bez1, bez2, justCount) {
    var bbox1 = bezierBBox(bez1),
        bbox2 = bezierBBox(bez2);

    if (!isBBoxIntersect(bbox1, bbox2)) {
      return justCount ? 0 : [];
    } // As an optimization, lines will have only 1 segment


    var l1 = bezlen.apply(0, bez1),
        l2 = bezlen.apply(0, bez2),
        n1 = isLine(bez1) ? 1 : ~~(l1 / 5) || 1,
        n2 = isLine(bez2) ? 1 : ~~(l2 / 5) || 1,
        dots1 = [],
        dots2 = [],
        xy = {},
        res = justCount ? 0 : [];

    for (var i = 0; i < n1 + 1; i++) {
      var p = findDotsAtSegment.apply(0, bez1.concat(i / n1));
      dots1.push({
        x: p.x,
        y: p.y,
        t: i / n1
      });
    }

    for (i = 0; i < n2 + 1; i++) {
      p = findDotsAtSegment.apply(0, bez2.concat(i / n2));
      dots2.push({
        x: p.x,
        y: p.y,
        t: i / n2
      });
    }

    for (i = 0; i < n1; i++) {
      for (var j = 0; j < n2; j++) {
        var di = dots1[i],
            di1 = dots1[i + 1],
            dj = dots2[j],
            dj1 = dots2[j + 1],
            ci = abs(di1.x - di.x) < .01 ? 'y' : 'x',
            cj = abs(dj1.x - dj.x) < .01 ? 'y' : 'x',
            is = intersectLines(di.x, di.y, di1.x, di1.y, dj.x, dj.y, dj1.x, dj1.y),
            key;

        if (is) {
          key = is.x.toFixed(9) + '#' + is.y.toFixed(9);

          if (xy[key]) {
            continue;
          }

          xy[key] = true;
          var t1 = di.t + abs((is[ci] - di[ci]) / (di1[ci] - di[ci])) * (di1.t - di.t),
              t2 = dj.t + abs((is[cj] - dj[cj]) / (dj1[cj] - dj[cj])) * (dj1.t - dj.t);

          if (t1 >= 0 && t1 <= 1 && t2 >= 0 && t2 <= 1) {
            if (justCount) {
              res++;
            } else {
              res.push({
                x: is.x,
                y: is.y,
                t1: t1,
                t2: t2
              });
            }
          }
        }
      }
    }

    return res;
  }
  /**
   * Find or counts the intersections between two SVG paths.
   *
   * Returns a number in counting mode and a list of intersections otherwise.
   *
   * A single intersection entry contains the intersection coordinates (x, y)
   * as well as additional information regarding the intersecting segments
   * on each path (segment1, segment2) and the relative location of the
   * intersection on these segments (t1, t2).
   *
   * The path may be an SVG path string or a list of path components
   * such as `[ [ 'M', 0, 10 ], [ 'L', 20, 0 ] ]`.
   *
   * @example
   *
   * var intersections = findPathIntersections(
   *   'M0,0L100,100',
   *   [ [ 'M', 0, 100 ], [ 'L', 100, 0 ] ]
   * );
   *
   * // intersections = [
   * //   { x: 50, y: 50, segment1: 1, segment2: 1, t1: 0.5, t2: 0.5 }
   * // ]
   *
   * @param {String|Array<PathDef>} path1
   * @param {String|Array<PathDef>} path2
   * @param {Boolean} [justCount=false]
   *
   * @return {Array<Intersection>|Number}
   */


  function findPathIntersections(path1, path2, justCount) {
    path1 = pathToCurve(path1);
    path2 = pathToCurve(path2);
    var x1,
        y1,
        x2,
        y2,
        x1m,
        y1m,
        x2m,
        y2m,
        bez1,
        bez2,
        res = justCount ? 0 : [];

    for (var i = 0, ii = path1.length; i < ii; i++) {
      var pi = path1[i];

      if (pi[0] == 'M') {
        x1 = x1m = pi[1];
        y1 = y1m = pi[2];
      } else {
        if (pi[0] == 'C') {
          bez1 = [x1, y1].concat(pi.slice(1));
          x1 = bez1[6];
          y1 = bez1[7];
        } else {
          bez1 = [x1, y1, x1, y1, x1m, y1m, x1m, y1m];
          x1 = x1m;
          y1 = y1m;
        }

        for (var j = 0, jj = path2.length; j < jj; j++) {
          var pj = path2[j];

          if (pj[0] == 'M') {
            x2 = x2m = pj[1];
            y2 = y2m = pj[2];
          } else {
            if (pj[0] == 'C') {
              bez2 = [x2, y2].concat(pj.slice(1));
              x2 = bez2[6];
              y2 = bez2[7];
            } else {
              bez2 = [x2, y2, x2, y2, x2m, y2m, x2m, y2m];
              x2 = x2m;
              y2 = y2m;
            }

            var intr = findBezierIntersections(bez1, bez2, justCount);

            if (justCount) {
              res += intr;
            } else {
              for (var k = 0, kk = intr.length; k < kk; k++) {
                intr[k].segment1 = i;
                intr[k].segment2 = j;
                intr[k].bez1 = bez1;
                intr[k].bez2 = bez2;
              }

              res = res.concat(intr);
            }
          }
        }
      }
    }

    return res;
  }

  function pathToAbsolute(pathArray) {
    var pth = paths(pathArray);

    if (pth.abs) {
      return pathClone(pth.abs);
    }

    if (!isArray$2(pathArray) || !isArray$2(pathArray && pathArray[0])) {
      // rough assumption
      pathArray = parsePathString(pathArray);
    }

    if (!pathArray || !pathArray.length) {
      return [['M', 0, 0]];
    }

    var res = [],
        x = 0,
        y = 0,
        mx = 0,
        my = 0,
        start = 0,
        pa0;

    if (pathArray[0][0] == 'M') {
      x = +pathArray[0][1];
      y = +pathArray[0][2];
      mx = x;
      my = y;
      start++;
      res[0] = ['M', x, y];
    }

    for (var r, pa, i = start, ii = pathArray.length; i < ii; i++) {
      res.push(r = []);
      pa = pathArray[i];
      pa0 = pa[0];

      if (pa0 != pa0.toUpperCase()) {
        r[0] = pa0.toUpperCase();

        switch (r[0]) {
          case 'A':
            r[1] = pa[1];
            r[2] = pa[2];
            r[3] = pa[3];
            r[4] = pa[4];
            r[5] = pa[5];
            r[6] = +pa[6] + x;
            r[7] = +pa[7] + y;
            break;

          case 'V':
            r[1] = +pa[1] + y;
            break;

          case 'H':
            r[1] = +pa[1] + x;
            break;

          case 'M':
            mx = +pa[1] + x;
            my = +pa[2] + y;

          default:
            for (var j = 1, jj = pa.length; j < jj; j++) {
              r[j] = +pa[j] + (j % 2 ? x : y);
            }

        }
      } else {
        for (var k = 0, kk = pa.length; k < kk; k++) {
          r[k] = pa[k];
        }
      }

      pa0 = pa0.toUpperCase();

      switch (r[0]) {
        case 'Z':
          x = +mx;
          y = +my;
          break;

        case 'H':
          x = r[1];
          break;

        case 'V':
          y = r[1];
          break;

        case 'M':
          mx = r[r.length - 2];
          my = r[r.length - 1];

        default:
          x = r[r.length - 2];
          y = r[r.length - 1];
      }
    }

    res.toString = pathToString;
    pth.abs = pathClone(res);
    return res;
  }

  function isLine(bez) {
    return bez[0] === bez[2] && bez[1] === bez[3] && bez[4] === bez[6] && bez[5] === bez[7];
  }

  function lineToCurve(x1, y1, x2, y2) {
    return [x1, y1, x2, y2, x2, y2];
  }

  function qubicToCurve(x1, y1, ax, ay, x2, y2) {
    var _13 = 1 / 3,
        _23 = 2 / 3;

    return [_13 * x1 + _23 * ax, _13 * y1 + _23 * ay, _13 * x2 + _23 * ax, _13 * y2 + _23 * ay, x2, y2];
  }

  function arcToCurve(x1, y1, rx, ry, angle, large_arc_flag, sweep_flag, x2, y2, recursive) {
    // for more information of where this math came from visit:
    // http://www.w3.org/TR/SVG11/implnote.html#ArcImplementationNotes
    var _120 = PI * 120 / 180,
        rad = PI / 180 * (+angle || 0),
        res = [],
        xy,
        rotate = cacher(function (x, y, rad) {
      var X = x * math.cos(rad) - y * math.sin(rad),
          Y = x * math.sin(rad) + y * math.cos(rad);
      return {
        x: X,
        y: Y
      };
    });

    if (!recursive) {
      xy = rotate(x1, y1, -rad);
      x1 = xy.x;
      y1 = xy.y;
      xy = rotate(x2, y2, -rad);
      x2 = xy.x;
      y2 = xy.y;
      var x = (x1 - x2) / 2,
          y = (y1 - y2) / 2;
      var h = x * x / (rx * rx) + y * y / (ry * ry);

      if (h > 1) {
        h = math.sqrt(h);
        rx = h * rx;
        ry = h * ry;
      }

      var rx2 = rx * rx,
          ry2 = ry * ry,
          k = (large_arc_flag == sweep_flag ? -1 : 1) * math.sqrt(abs((rx2 * ry2 - rx2 * y * y - ry2 * x * x) / (rx2 * y * y + ry2 * x * x))),
          cx = k * rx * y / ry + (x1 + x2) / 2,
          cy = k * -ry * x / rx + (y1 + y2) / 2,
          f1 = math.asin(((y1 - cy) / ry).toFixed(9)),
          f2 = math.asin(((y2 - cy) / ry).toFixed(9));
      f1 = x1 < cx ? PI - f1 : f1;
      f2 = x2 < cx ? PI - f2 : f2;
      f1 < 0 && (f1 = PI * 2 + f1);
      f2 < 0 && (f2 = PI * 2 + f2);

      if (sweep_flag && f1 > f2) {
        f1 = f1 - PI * 2;
      }

      if (!sweep_flag && f2 > f1) {
        f2 = f2 - PI * 2;
      }
    } else {
      f1 = recursive[0];
      f2 = recursive[1];
      cx = recursive[2];
      cy = recursive[3];
    }

    var df = f2 - f1;

    if (abs(df) > _120) {
      var f2old = f2,
          x2old = x2,
          y2old = y2;
      f2 = f1 + _120 * (sweep_flag && f2 > f1 ? 1 : -1);
      x2 = cx + rx * math.cos(f2);
      y2 = cy + ry * math.sin(f2);
      res = arcToCurve(x2, y2, rx, ry, angle, 0, sweep_flag, x2old, y2old, [f2, f2old, cx, cy]);
    }

    df = f2 - f1;
    var c1 = math.cos(f1),
        s1 = math.sin(f1),
        c2 = math.cos(f2),
        s2 = math.sin(f2),
        t = math.tan(df / 4),
        hx = 4 / 3 * rx * t,
        hy = 4 / 3 * ry * t,
        m1 = [x1, y1],
        m2 = [x1 + hx * s1, y1 - hy * c1],
        m3 = [x2 + hx * s2, y2 - hy * c2],
        m4 = [x2, y2];
    m2[0] = 2 * m1[0] - m2[0];
    m2[1] = 2 * m1[1] - m2[1];

    if (recursive) {
      return [m2, m3, m4].concat(res);
    } else {
      res = [m2, m3, m4].concat(res).join().split(',');
      var newres = [];

      for (var i = 0, ii = res.length; i < ii; i++) {
        newres[i] = i % 2 ? rotate(res[i - 1], res[i], rad).y : rotate(res[i], res[i + 1], rad).x;
      }

      return newres;
    }
  } // Returns bounding box of cubic bezier curve.
  // Source: http://blog.hackers-cafe.net/2009/06/how-to-calculate-bezier-curves-bounding.html
  // Original version: NISHIO Hirokazu
  // Modifications: https://github.com/timo22345


  function curveBBox(x0, y0, x1, y1, x2, y2, x3, y3) {
    var tvalues = [],
        bounds = [[], []],
        a,
        b,
        c,
        t,
        t1,
        t2,
        b2ac,
        sqrtb2ac;

    for (var i = 0; i < 2; ++i) {
      if (i == 0) {
        b = 6 * x0 - 12 * x1 + 6 * x2;
        a = -3 * x0 + 9 * x1 - 9 * x2 + 3 * x3;
        c = 3 * x1 - 3 * x0;
      } else {
        b = 6 * y0 - 12 * y1 + 6 * y2;
        a = -3 * y0 + 9 * y1 - 9 * y2 + 3 * y3;
        c = 3 * y1 - 3 * y0;
      }

      if (abs(a) < 1e-12) {
        if (abs(b) < 1e-12) {
          continue;
        }

        t = -c / b;

        if (0 < t && t < 1) {
          tvalues.push(t);
        }

        continue;
      }

      b2ac = b * b - 4 * c * a;
      sqrtb2ac = math.sqrt(b2ac);

      if (b2ac < 0) {
        continue;
      }

      t1 = (-b + sqrtb2ac) / (2 * a);

      if (0 < t1 && t1 < 1) {
        tvalues.push(t1);
      }

      t2 = (-b - sqrtb2ac) / (2 * a);

      if (0 < t2 && t2 < 1) {
        tvalues.push(t2);
      }
    }

    var j = tvalues.length,
        jlen = j,
        mt;

    while (j--) {
      t = tvalues[j];
      mt = 1 - t;
      bounds[0][j] = mt * mt * mt * x0 + 3 * mt * mt * t * x1 + 3 * mt * t * t * x2 + t * t * t * x3;
      bounds[1][j] = mt * mt * mt * y0 + 3 * mt * mt * t * y1 + 3 * mt * t * t * y2 + t * t * t * y3;
    }

    bounds[0][jlen] = x0;
    bounds[1][jlen] = y0;
    bounds[0][jlen + 1] = x3;
    bounds[1][jlen + 1] = y3;
    bounds[0].length = bounds[1].length = jlen + 2;
    return {
      x0: mmin.apply(0, bounds[0]),
      y0: mmin.apply(0, bounds[1]),
      x1: mmax.apply(0, bounds[0]),
      y1: mmax.apply(0, bounds[1])
    };
  }

  function pathToCurve(path) {
    var pth = paths(path); // return cached curve, if existing

    if (pth.curve) {
      return pathClone(pth.curve);
    }

    var curvedPath = pathToAbsolute(path),
        attrs = {
      x: 0,
      y: 0,
      bx: 0,
      by: 0,
      X: 0,
      Y: 0,
      qx: null,
      qy: null
    },
        processPath = function processPath(path, d, pathCommand) {
      var nx, ny;

      if (!path) {
        return ['C', d.x, d.y, d.x, d.y, d.x, d.y];
      }

      !(path[0] in {
        T: 1,
        Q: 1
      }) && (d.qx = d.qy = null);

      switch (path[0]) {
        case 'M':
          d.X = path[1];
          d.Y = path[2];
          break;

        case 'A':
          path = ['C'].concat(arcToCurve.apply(0, [d.x, d.y].concat(path.slice(1))));
          break;

        case 'S':
          if (pathCommand == 'C' || pathCommand == 'S') {
            // In 'S' case we have to take into account, if the previous command is C/S.
            nx = d.x * 2 - d.bx; // And reflect the previous

            ny = d.y * 2 - d.by; // command's control point relative to the current point.
          } else {
            // or some else or nothing
            nx = d.x;
            ny = d.y;
          }

          path = ['C', nx, ny].concat(path.slice(1));
          break;

        case 'T':
          if (pathCommand == 'Q' || pathCommand == 'T') {
            // In 'T' case we have to take into account, if the previous command is Q/T.
            d.qx = d.x * 2 - d.qx; // And make a reflection similar

            d.qy = d.y * 2 - d.qy; // to case 'S'.
          } else {
            // or something else or nothing
            d.qx = d.x;
            d.qy = d.y;
          }

          path = ['C'].concat(qubicToCurve(d.x, d.y, d.qx, d.qy, path[1], path[2]));
          break;

        case 'Q':
          d.qx = path[1];
          d.qy = path[2];
          path = ['C'].concat(qubicToCurve(d.x, d.y, path[1], path[2], path[3], path[4]));
          break;

        case 'L':
          path = ['C'].concat(lineToCurve(d.x, d.y, path[1], path[2]));
          break;

        case 'H':
          path = ['C'].concat(lineToCurve(d.x, d.y, path[1], d.y));
          break;

        case 'V':
          path = ['C'].concat(lineToCurve(d.x, d.y, d.x, path[1]));
          break;

        case 'Z':
          path = ['C'].concat(lineToCurve(d.x, d.y, d.X, d.Y));
          break;
      }

      return path;
    },
        fixArc = function fixArc(pp, i) {
      if (pp[i].length > 7) {
        pp[i].shift();
        var pi = pp[i];

        while (pi.length) {
          pathCommands[i] = 'A'; // if created multiple C:s, their original seg is saved

          pp.splice(i++, 0, ['C'].concat(pi.splice(0, 6)));
        }

        pp.splice(i, 1);
        ii = curvedPath.length;
      }
    },
        pathCommands = [],
        // path commands of original path p
    pfirst = '',
        // temporary holder for original path command
    pathCommand = ''; // holder for previous path command of original path


    for (var i = 0, ii = curvedPath.length; i < ii; i++) {
      curvedPath[i] && (pfirst = curvedPath[i][0]); // save current path command

      if (pfirst != 'C') // C is not saved yet, because it may be result of conversion
        {
          pathCommands[i] = pfirst; // Save current path command

          i && (pathCommand = pathCommands[i - 1]); // Get previous path command pathCommand
        }

      curvedPath[i] = processPath(curvedPath[i], attrs, pathCommand); // Previous path command is inputted to processPath

      if (pathCommands[i] != 'A' && pfirst == 'C') pathCommands[i] = 'C'; // A is the only command
      // which may produce multiple C:s
      // so we have to make sure that C is also C in original path

      fixArc(curvedPath, i); // fixArc adds also the right amount of A:s to pathCommands

      var seg = curvedPath[i],
          seglen = seg.length;
      attrs.x = seg[seglen - 2];
      attrs.y = seg[seglen - 1];
      attrs.bx = toFloat(seg[seglen - 4]) || attrs.x;
      attrs.by = toFloat(seg[seglen - 3]) || attrs.y;
    } // cache curve


    pth.curve = pathClone(curvedPath);
    return curvedPath;
  }

  var intersect = findPathIntersections;

  function roundBounds(bounds) {
    return {
      x: Math.round(bounds.x),
      y: Math.round(bounds.y),
      width: Math.round(bounds.width),
      height: Math.round(bounds.height)
    };
  }
  function roundPoint(point) {
    return {
      x: Math.round(point.x),
      y: Math.round(point.y)
    };
  }
  /**
   * Convert the given bounds to a { top, left, bottom, right } descriptor.
   *
   * @param {Bounds|Point} bounds
   *
   * @return {Object}
   */

  function asTRBL(bounds) {
    return {
      top: bounds.y,
      right: bounds.x + (bounds.width || 0),
      bottom: bounds.y + (bounds.height || 0),
      left: bounds.x
    };
  }
  /**
   * Convert a { top, left, bottom, right } to an objects bounds.
   *
   * @param {Object} trbl
   *
   * @return {Bounds}
   */

  function asBounds(trbl) {
    return {
      x: trbl.left,
      y: trbl.top,
      width: trbl.right - trbl.left,
      height: trbl.bottom - trbl.top
    };
  }
  /**
   * Get the mid of the given bounds or point.
   *
   * @param {Bounds|Point} bounds
   *
   * @return {Point}
   */

  function getMid(bounds) {
    return roundPoint({
      x: bounds.x + (bounds.width || 0) / 2,
      y: bounds.y + (bounds.height || 0) / 2
    });
  } // orientation utils //////////////////////

  /**
   * Get orientation of the given rectangle with respect to
   * the reference rectangle.
   *
   * A padding (positive or negative) may be passed to influence
   * horizontal / vertical orientation and intersection.
   *
   * @param {Bounds} rect
   * @param {Bounds} reference
   * @param {Point|number} padding
   *
   * @return {string} the orientation; one of top, top-left, left, ..., bottom, right or intersect.
   */

  function getOrientation(rect, reference, padding) {
    padding = padding || 0; // make sure we can use an object, too
    // for individual { x, y } padding

    if (!isObject(padding)) {
      padding = {
        x: padding,
        y: padding
      };
    }

    var rectOrientation = asTRBL(rect),
        referenceOrientation = asTRBL(reference);
    var top = rectOrientation.bottom + padding.y <= referenceOrientation.top,
        right = rectOrientation.left - padding.x >= referenceOrientation.right,
        bottom = rectOrientation.top - padding.y >= referenceOrientation.bottom,
        left = rectOrientation.right + padding.x <= referenceOrientation.left;
    var vertical = top ? 'top' : bottom ? 'bottom' : null,
        horizontal = left ? 'left' : right ? 'right' : null;

    if (horizontal && vertical) {
      return vertical + '-' + horizontal;
    } else {
      return horizontal || vertical || 'intersect';
    }
  } // intersection utils //////////////////////

  /**
   * Get intersection between an element and a line path.
   *
   * @param {PathDef} elementPath
   * @param {PathDef} linePath
   * @param {boolean} cropStart crop from start or end
   *
   * @return {Point}
   */

  function getElementLineIntersection(elementPath, linePath, cropStart) {
    var intersections = getIntersections(elementPath, linePath); // recognize intersections
    // only one -> choose
    // two close together -> choose first
    // two or more distinct -> pull out appropriate one
    // none -> ok (fallback to point itself)

    if (intersections.length === 1) {
      return roundPoint(intersections[0]);
    } else if (intersections.length === 2 && pointDistance(intersections[0], intersections[1]) < 1) {
      return roundPoint(intersections[0]);
    } else if (intersections.length > 1) {
      // sort by intersections based on connection segment +
      // distance from start
      intersections = sortBy(intersections, function (i) {
        var distance = Math.floor(i.t2 * 100) || 1;
        distance = 100 - distance;
        distance = (distance < 10 ? '0' : '') + distance; // create a sort string that makes sure we sort
        // line segment ASC + line segment position DESC (for cropStart)
        // line segment ASC + line segment position ASC (for cropEnd)

        return i.segment2 + '#' + distance;
      });
      return roundPoint(intersections[cropStart ? 0 : intersections.length - 1]);
    }

    return null;
  }
  function getIntersections(a, b) {
    return intersect(a, b);
  }
  function filterRedundantWaypoints(waypoints) {
    // alter copy of waypoints, not original
    waypoints = waypoints.slice();
    var idx = 0,
        point,
        previousPoint,
        nextPoint;

    while (waypoints[idx]) {
      point = waypoints[idx];
      previousPoint = waypoints[idx - 1];
      nextPoint = waypoints[idx + 1];

      if (pointDistance(point, nextPoint) === 0 || pointsOnLine(previousPoint, nextPoint, point)) {
        // remove point, if overlapping with {nextPoint}
        // or on line with {previousPoint} -> {point} -> {nextPoint}
        waypoints.splice(idx, 1);
      } else {
        idx++;
      }
    }

    return waypoints;
  }

  var PLACEMENT_DETECTION_PAD = 10;
  var DEFAULT_DISTANCE = 50;
  var DEFAULT_MAX_DISTANCE = 250;
  /**
   * Get free position starting from given position.
   *
   * @param {djs.model.Shape} source
   * @param {djs.model.Shape} element
   * @param {Point} position
   * @param {Function} getNextPosition
   *
   * @return {Point}
   */

  function findFreePosition(source, element, position, getNextPosition) {
    var connectedAtPosition;

    while (connectedAtPosition = getConnectedAtPosition(source, position, element)) {
      position = getNextPosition(element, position, connectedAtPosition);
    }

    return position;
  }
  /**
   * Returns function that returns next position.
   *
   * @param {Object} nextPositionDirection
   * @param {Object} [nextPositionDirection.x]
   * @param {Object} [nextPositionDirection.y]
   *
   * @returns {Function}
   */

  function generateGetNextPosition(nextPositionDirection) {
    return function (element, previousPosition, connectedAtPosition) {
      var nextPosition = {
        x: previousPosition.x,
        y: previousPosition.y
      };
      ['x', 'y'].forEach(function (axis) {
        var nextPositionDirectionForAxis = nextPositionDirection[axis];

        if (!nextPositionDirectionForAxis) {
          return;
        }

        var dimension = axis === 'x' ? 'width' : 'height';
        var margin = nextPositionDirectionForAxis.margin,
            minDistance = nextPositionDirectionForAxis.minDistance;

        if (margin < 0) {
          nextPosition[axis] = Math.min(connectedAtPosition[axis] + margin - element[dimension] / 2, previousPosition[axis] - minDistance + margin);
        } else {
          nextPosition[axis] = Math.max(connectedAtPosition[axis] + connectedAtPosition[dimension] + margin + element[dimension] / 2, previousPosition[axis] + minDistance + margin);
        }
      });
      return nextPosition;
    };
  }
  /**
   * Return target at given position, if defined.
   *
   * This takes connected elements from host and attachers
   * into account, too.
   */

  function getConnectedAtPosition(source, position, element) {
    var bounds = {
      x: position.x - element.width / 2,
      y: position.y - element.height / 2,
      width: element.width,
      height: element.height
    };
    var closure = getAutoPlaceClosure(source);
    return find(closure, function (target) {
      if (target === element) {
        return false;
      }

      var orientation = getOrientation(target, bounds, PLACEMENT_DETECTION_PAD);
      return orientation === 'intersect';
    });
  }
  /**
  * Compute optimal distance between source and target based on existing connections to and from source.
  * Assumes left-to-right and top-to-down modeling.
  *
  * @param {djs.model.Shape} source
  * @param {Object} [hints]
  * @param {number} [hints.defaultDistance]
  * @param {string} [hints.direction]
  * @param {Function} [hints.filter]
  * @param {Function} [hints.getWeight]
  * @param {number} [hints.maxDistance]
  * @param {string} [hints.reference]
  *
  * @return {number}
  */

  function getConnectedDistance(source, hints) {
    if (!hints) {
      hints = {};
    } // targets > sources by default


    function getDefaultWeight(connection) {
      return connection.source === source ? 1 : -1;
    }

    var defaultDistance = hints.defaultDistance || DEFAULT_DISTANCE,
        direction = hints.direction || 'e',
        filter = hints.filter,
        getWeight = hints.getWeight || getDefaultWeight,
        maxDistance = hints.maxDistance || DEFAULT_MAX_DISTANCE,
        reference = hints.reference || 'start';

    if (!filter) {
      filter = noneFilter;
    }

    function getDistance(a, b) {
      if (direction === 'n') {
        if (reference === 'start') {
          return asTRBL(a).top - asTRBL(b).bottom;
        } else if (reference === 'center') {
          return asTRBL(a).top - getMid(b).y;
        } else {
          return asTRBL(a).top - asTRBL(b).top;
        }
      } else if (direction === 'w') {
        if (reference === 'start') {
          return asTRBL(a).left - asTRBL(b).right;
        } else if (reference === 'center') {
          return asTRBL(a).left - getMid(b).x;
        } else {
          return asTRBL(a).left - asTRBL(b).left;
        }
      } else if (direction === 's') {
        if (reference === 'start') {
          return asTRBL(b).top - asTRBL(a).bottom;
        } else if (reference === 'center') {
          return getMid(b).y - asTRBL(a).bottom;
        } else {
          return asTRBL(b).bottom - asTRBL(a).bottom;
        }
      } else {
        if (reference === 'start') {
          return asTRBL(b).left - asTRBL(a).right;
        } else if (reference === 'center') {
          return getMid(b).x - asTRBL(a).right;
        } else {
          return asTRBL(b).right - asTRBL(a).right;
        }
      }
    }

    var sourcesDistances = source.incoming.filter(filter).map(function (connection) {
      var weight = getWeight(connection);
      var distance = weight < 0 ? getDistance(connection.source, source) : getDistance(source, connection.source);
      return {
        id: connection.source.id,
        distance: distance,
        weight: weight
      };
    });
    var targetsDistances = source.outgoing.filter(filter).map(function (connection) {
      var weight = getWeight(connection);
      var distance = weight > 0 ? getDistance(source, connection.target) : getDistance(connection.target, source);
      return {
        id: connection.target.id,
        distance: distance,
        weight: weight
      };
    });
    var distances = sourcesDistances.concat(targetsDistances).reduce(function (accumulator, currentValue) {
      accumulator[currentValue.id + '__weight_' + currentValue.weight] = currentValue;
      return accumulator;
    }, {});
    var distancesGrouped = reduce(distances, function (accumulator, currentValue) {
      var distance = currentValue.distance,
          weight = currentValue.weight;

      if (distance < 0 || distance > maxDistance) {
        return accumulator;
      }

      if (!accumulator[String(distance)]) {
        accumulator[String(distance)] = 0;
      }

      accumulator[String(distance)] += 1 * weight;

      if (!accumulator.distance || accumulator[accumulator.distance] < accumulator[String(distance)]) {
        accumulator.distance = distance;
      }

      return accumulator;
    }, {});
    return distancesGrouped.distance || defaultDistance;
  }
  /**
   * Returns all connected elements around the given source.
   *
   * This includes:
   *
   *   - connected elements
   *   - host connected elements
   *   - attachers connected elements
   *
   * @param  {djs.model.Shape} source
   *
   * @return {Array<djs.model.Shape>}
   */

  function getAutoPlaceClosure(source) {
    var allConnected = getConnected(source);

    if (source.host) {
      allConnected = allConnected.concat(getConnected(source.host));
    }

    if (source.attachers) {
      allConnected = allConnected.concat(source.attachers.reduce(function (shapes, attacher) {
        return shapes.concat(getConnected(attacher));
      }, []));
    }

    return allConnected;
  }

  function getConnected(element) {
    return getTargets(element).concat(getSources(element));
  }

  function getSources(shape) {
    return shape.incoming.map(function (connection) {
      return connection.source;
    });
  }

  function getTargets(shape) {
    return shape.outgoing.map(function (connection) {
      return connection.target;
    });
  }

  function noneFilter() {
    return true;
  }

  var LOW_PRIORITY$3 = 100;
  /**
   * A service that places elements connected to existing ones
   * to an appropriate position in an _automated_ fashion.
   *
   * @param {EventBus} eventBus
   * @param {Modeling} modeling
   */

  function AutoPlace(eventBus, modeling) {
    eventBus.on('autoPlace', LOW_PRIORITY$3, function (context) {
      var shape = context.shape,
          source = context.source;
      return getNewShapePosition(source, shape);
    });
    /**
     * Append shape to source at appropriate position.
     *
     * @param {djs.model.Shape} source
     * @param {djs.model.Shape} shape
     *
     * @return {djs.model.Shape} appended shape
     */

    this.append = function (source, shape, hints) {
      eventBus.fire('autoPlace.start', {
        source: source,
        shape: shape
      }); // allow others to provide the position

      var position = eventBus.fire('autoPlace', {
        source: source,
        shape: shape
      });
      var newShape = modeling.appendShape(source, shape, position, source.parent, hints);
      eventBus.fire('autoPlace.end', {
        source: source,
        shape: newShape
      });
      return newShape;
    };
  }
  AutoPlace.$inject = ['eventBus', 'modeling']; // helpers //////////

  /**
   * Find the new position for the target element to
   * connect to source.
   *
   * @param  {djs.model.Shape} source
   * @param  {djs.model.Shape} element
   * @param  {Object} [hints]
   * @param  {Object} [hints.defaultDistance]
   *
   * @returns {Point}
   */

  function getNewShapePosition(source, element, hints) {
    if (!hints) {
      hints = {};
    }

    var distance = hints.defaultDistance || DEFAULT_DISTANCE;
    var sourceMid = getMid(source),
        sourceTrbl = asTRBL(source); // simply put element right next to source

    return {
      x: sourceTrbl.right + distance + element.width / 2,
      y: sourceMid.y
    };
  }

  /**
   * Select element after auto placement.
   *
   * @param {EventBus} eventBus
   * @param {Selection} selection
   */
  function AutoPlaceSelectionBehavior(eventBus, selection) {
    eventBus.on('autoPlace.end', 500, function (e) {
      selection.select(e.shape);
    });
  }
  AutoPlaceSelectionBehavior.$inject = ['eventBus', 'selection'];

  var AutoPlaceModule = {
    __init__: ['autoPlaceSelectionBehavior'],
    autoPlace: ['type', AutoPlace],
    autoPlaceSelectionBehavior: ['type', AutoPlaceSelectionBehavior]
  };

  var BUSINESS_KNOWLEDGE_MODEL_SIZE = {
    width: 135,
    height: 46
  };
  var DECISION_SIZE = {
    width: 180,
    height: 80
  };
  var INPUT_DATA_SIZE = {
    width: 125,
    height: 45
  };
  var KNOWLEDGE_SOURCE_SIZE = {
    width: 100,
    height: 63
  };
  /**
   * A drd-aware factory for diagram-js shapes
   */

  function ElementFactory$1(drdFactory) {
    ElementFactory.call(this);
    this._drdFactory = drdFactory;
  }
  inherits_browser(ElementFactory$1, ElementFactory);
  ElementFactory$1.$inject = ['drdFactory'];
  ElementFactory$1.prototype.baseCreate = ElementFactory.prototype.create;

  ElementFactory$1.prototype.create = function (elementType, attrs) {
    return this.createDrdElement(elementType, attrs);
  };

  ElementFactory$1.prototype.createDrdElement = function (elementType, attrs) {
    var drdFactory = this._drdFactory;
    var size;
    attrs = attrs || {};
    var businessObject = attrs.businessObject;

    if (!businessObject) {
      if (!attrs.type) {
        throw new Error('no shape type specified');
      }

      businessObject = drdFactory.create(attrs.type);
    }

    if (!businessObject.di) {
      if (elementType === 'connection') {
        businessObject.di = drdFactory.createDiEdge(businessObject, []);
      } else if (elementType === 'shape') {
        businessObject.di = drdFactory.createDiShape(businessObject, {});
      }
    }

    size = this._getDefaultSize(businessObject);
    attrs = assign({
      businessObject: businessObject,
      id: businessObject.id
    }, size, attrs);
    return this.baseCreate(elementType, attrs);
  };

  ElementFactory$1.prototype._getDefaultSize = function (semantic) {
    if (is(semantic, 'dmn:BusinessKnowledgeModel')) {
      return BUSINESS_KNOWLEDGE_MODEL_SIZE;
    }

    if (is(semantic, 'dmn:Decision')) {
      return DECISION_SIZE;
    }

    if (is(semantic, 'dmn:InputData')) {
      return INPUT_DATA_SIZE;
    }

    if (is(semantic, 'dmn:KnowledgeSource')) {
      return KNOWLEDGE_SOURCE_SIZE;
    }

    return {
      width: 100,
      height: 80
    };
  };

  var DIRECTION_LEFT = 'left',
      DIRECTION_RIGHT = 'right';
  var DRG_ELEMENT_MARGIN = 60,
      DRG_ELEMENT_ROW_SIZE = DECISION_SIZE.width;
  function getNewShapePosition$1(source, element) {
    if (is(element, 'dmn:TextAnnotation')) {
      return getTextAnnotationPosition(source, element);
    }

    if (is(element, 'dmn:DRGElement')) {
      return getDRGElementPosition(source, element);
    }
  }
  /**
   * Always try to place text annotations top right of source.
   */

  function getTextAnnotationPosition(source, element) {
    var sourceTrbl = asTRBL(source);
    var position = {
      x: sourceTrbl.right + element.width / 2,
      y: sourceTrbl.top - 50 - element.height / 2
    };
    var nextPositionDirection = {
      y: {
        margin: -30,
        minDistance: 20
      }
    };
    return findFreePosition(source, element, position, generateGetNextPosition(nextPositionDirection));
  }
  /**
   * Get position for DRG elements.
   *
   * @param {djs.model.Shape} source
   * @param {djs.model.Shape} element
   *
   * @returns {Point}
   */


  function getDRGElementPosition(source, element) {
    var sourceTrbl = asTRBL(source),
        sourceMid = getMid(source);

    function getWeight(connection) {
      return connection.target === source ? 1 : -1;
    }

    var verticalDistance = getConnectedDistance(source, {
      defaultDistance: 180,
      direction: 's',
      getWeight: getWeight,
      filter: filter$1,
      reference: 'center'
    });
    var position = {
      x: sourceMid.x,
      y: sourceTrbl.bottom + verticalDistance
    };
    return findFreePosition(source, element, position, generateGetNextDRGElementPosition(source));
  } // helpers //////////


  function filter$1(connection) {
    return !is(connection, 'dmn:Association');
  }

  function getHorizontalDistance(a, b) {
    return Math.abs(b.x - a.x);
  }

  function generateGetNextDRGElementPosition(source) {
    var sourceMid = getMid(source);
    var connectedAtPositionLeft, connectedAtPositionRight;
    return function (element, previousPosition, connectedAtPreviousPosition) {
      var direction; // (1) get direction

      if (!connectedAtPositionLeft) {
        connectedAtPositionLeft = connectedAtPreviousPosition;
        connectedAtPositionRight = connectedAtPreviousPosition;

        if (getMid(connectedAtPreviousPosition).x - sourceMid.x > 0) {
          direction = DIRECTION_LEFT;
        } else {
          direction = DIRECTION_RIGHT;
        }
      } else {
        if (previousPosition.x < sourceMid.x) {
          connectedAtPositionLeft = connectedAtPreviousPosition;
        } else {
          connectedAtPositionRight = connectedAtPreviousPosition;
        }

        if (getHorizontalDistance(sourceMid, getMid(connectedAtPositionLeft)) < getHorizontalDistance(sourceMid, getMid(connectedAtPositionRight))) {
          direction = DIRECTION_LEFT;
        } else {
          direction = DIRECTION_RIGHT;
        }
      } // (2) get next position


      if (direction === DIRECTION_LEFT) {
        return {
          x: Math.min(getMid(connectedAtPositionLeft).x - DRG_ELEMENT_ROW_SIZE - DRG_ELEMENT_MARGIN, asTRBL(connectedAtPositionLeft).left - DRG_ELEMENT_MARGIN - element.width / 2),
          y: previousPosition.y
        };
      } else {
        return {
          x: Math.max(getMid(connectedAtPositionRight).x + DRG_ELEMENT_ROW_SIZE + DRG_ELEMENT_MARGIN, asTRBL(connectedAtPositionRight).right + DRG_ELEMENT_MARGIN + element.width / 2),
          y: previousPosition.y
        };
      }
    };
  }

  /**
   * DMN auto-place behavior.
   *
   * @param {EventBus} eventBus
   */

  function AutoPlace$1(eventBus) {
    eventBus.on('autoPlace', function (context) {
      var shape = context.shape,
          source = context.source;
      return getNewShapePosition$1(source, shape);
    });
  }
  AutoPlace$1.$inject = ['eventBus'];

  var AutoPlaceModule$1 = {
    __depends__: [AutoPlaceModule],
    __init__: ['dmnAutoPlace'],
    dmnAutoPlace: ['type', AutoPlace$1]
  };

  var HIGH_PRIORITY = 1500;
  /**
   * Browsers may swallow certain events (hover, out ...) if users are to
   * fast with the mouse.
   *
   * @see http://stackoverflow.com/questions/7448468/why-cant-i-reliably-capture-a-mouseout-event
   *
   * The fix implemented in this component ensure that we
   *
   * 1) have a hover state after a successful drag.move event
   * 2) have an out event when dragging leaves an element
   *
   * @param {ElementRegistry} elementRegistry
   * @param {EventBus} eventBus
   * @param {Injector} injector
   */

  function HoverFix(elementRegistry, eventBus, injector) {
    var self = this;
    var dragging = injector.get('dragging', false);
    /**
     * Make sure we are god damn hovering!
     *
     * @param {Event} dragging event
     */

    function ensureHover(event) {
      if (event.hover) {
        return;
      }

      var originalEvent = event.originalEvent;

      var gfx = self._findTargetGfx(originalEvent);

      var element = gfx && elementRegistry.get(gfx);

      if (gfx && element) {
        // 1) cancel current mousemove
        event.stopPropagation(); // 2) emit fake hover for new target

        dragging.hover({
          element: element,
          gfx: gfx
        }); // 3) re-trigger move event

        dragging.move(originalEvent);
      }
    }

    if (dragging) {
      /**
       * We wait for a specific sequence of events before
       * emitting a fake drag.hover event.
       *
       * Event Sequence:
       *
       * drag.start
       * drag.move >> ensure we are hovering
       */
      eventBus.on('drag.start', function (event) {
        eventBus.once('drag.move', HIGH_PRIORITY, function (event) {
          ensureHover(event);
        });
      });
    }
    /**
     * We make sure that element.out is always fired, even if the
     * browser swallows an element.out event.
     *
     * Event sequence:
     *
     * element.hover
     * (element.out >> sometimes swallowed)
     * element.hover >> ensure we fired element.out
     */


    (function () {
      var hoverGfx;
      var hover;
      eventBus.on('element.hover', function (event) {
        // (1) remember current hover element
        hoverGfx = event.gfx;
        hover = event.element;
      });
      eventBus.on('element.hover', HIGH_PRIORITY, function (event) {
        // (3) am I on an element still?
        if (hover) {
          // (4) that is a problem, gotta "simulate the out"
          eventBus.fire('element.out', {
            element: hover,
            gfx: hoverGfx
          });
        }
      });
      eventBus.on('element.out', function () {
        // (2) unset hover state if we correctly outed us *GG*
        hoverGfx = null;
        hover = null;
      });
    })();

    this._findTargetGfx = function (event) {
      var position, target;

      if (!(event instanceof MouseEvent)) {
        return;
      }

      position = toPoint(event); // damn expensive operation, ouch!

      target = document.elementFromPoint(position.x, position.y);
      return getGfx(target);
    };
  }
  HoverFix.$inject = ['elementRegistry', 'eventBus', 'injector']; // helpers /////////////////////

  function getGfx(target) {
    return closest(target, 'svg, .djs-element', true);
  }

  var HoverFixModule = {
    __init__: ['hoverFix'],
    hoverFix: ['type', HoverFix]
  };

  var round$1 = Math.round;
  var DRAG_ACTIVE_CLS = 'djs-drag-active';

  function preventDefault(event) {
    event.preventDefault();
  }

  function isTouchEvent(event) {
    // check for TouchEvent being available first
    // (i.e. not available on desktop Firefox)
    return typeof TouchEvent !== 'undefined' && event instanceof TouchEvent;
  }

  function getLength(point) {
    return Math.sqrt(Math.pow(point.x, 2) + Math.pow(point.y, 2));
  }
  /**
   * A helper that fires canvas localized drag events and realizes
   * the general "drag-and-drop" look and feel.
   *
   * Calling {@link Dragging#activate} activates dragging on a canvas.
   *
   * It provides the following:
   *
   *   * emits life cycle events, namespaced with a prefix assigned
   *     during dragging activation
   *   * sets and restores the cursor
   *   * sets and restores the selection if elements still exist
   *   * ensures there can be only one drag operation active at a time
   *
   * Dragging may be canceled manually by calling {@link Dragging#cancel}
   * or by pressing ESC.
   *
   *
   * ## Life-cycle events
   *
   * Dragging can be in three different states, off, initialized
   * and active.
   *
   * (1) off: no dragging operation is in progress
   * (2) initialized: a new drag operation got initialized but not yet
   *                  started (i.e. because of no initial move)
   * (3) started: dragging is in progress
   *
   * Eventually dragging will be off again after a drag operation has
   * been ended or canceled via user click or ESC key press.
   *
   * To indicate transitions between these states dragging emits generic
   * life-cycle events with the `drag.` prefix _and_ events namespaced
   * to a prefix choosen by a user during drag initialization.
   *
   * The following events are emitted (appropriately prefixed) via
   * the {@link EventBus}.
   *
   * * `init`
   * * `start`
   * * `move`
   * * `end`
   * * `ended` (dragging already in off state)
   * * `cancel` (only if previously started)
   * * `canceled` (dragging already in off state, only if previously started)
   * * `cleanup`
   *
   *
   * @example
   *
   * function MyDragComponent(eventBus, dragging) {
   *
   *   eventBus.on('mydrag.start', function(event) {
   *     console.log('yes, we start dragging');
   *   });
   *
   *   eventBus.on('mydrag.move', function(event) {
   *     console.log('canvas local coordinates', event.x, event.y, event.dx, event.dy);
   *
   *     // local drag data is passed with the event
   *     event.context.foo; // "BAR"
   *
   *     // the original mouse event, too
   *     event.originalEvent; // MouseEvent(...)
   *   });
   *
   *   eventBus.on('element.click', function(event) {
   *     dragging.init(event, 'mydrag', {
   *       cursor: 'grabbing',
   *       data: {
   *         context: {
   *           foo: "BAR"
   *         }
   *       }
   *     });
   *   });
   * }
   */


  function Dragging(eventBus, canvas, selection, elementRegistry) {
    var defaultOptions = {
      threshold: 5,
      trapClick: true
    }; // the currently active drag operation
    // dragging is active as soon as this context exists.
    //
    // it is visually _active_ only when a context.active flag is set to true.

    var context;
    /* convert a global event into local coordinates */

    function toLocalPoint(globalPosition) {
      var viewbox = canvas.viewbox();

      var clientRect = canvas._container.getBoundingClientRect();

      return {
        x: viewbox.x + (globalPosition.x - clientRect.left) / viewbox.scale,
        y: viewbox.y + (globalPosition.y - clientRect.top) / viewbox.scale
      };
    } // helpers


    function fire(type, dragContext) {
      dragContext = dragContext || context;
      var event = eventBus.createEvent(assign({}, dragContext.payload, dragContext.data, {
        isTouch: dragContext.isTouch
      })); // default integration

      if (eventBus.fire('drag.' + type, event) === false) {
        return false;
      }

      return eventBus.fire(dragContext.prefix + '.' + type, event);
    }

    function restoreSelection(previousSelection) {
      var existingSelection = previousSelection.filter(function (element) {
        return elementRegistry.get(element.id);
      });
      existingSelection.length && selection.select(existingSelection);
    } // event listeners


    function move(event, activate) {
      var payload = context.payload,
          displacement = context.displacement;
      var globalStart = context.globalStart,
          globalCurrent = toPoint(event),
          globalDelta = delta(globalCurrent, globalStart);
      var localStart = context.localStart,
          localCurrent = toLocalPoint(globalCurrent),
          localDelta = delta(localCurrent, localStart); // activate context explicitly or once threshold is reached

      if (!context.active && (activate || getLength(globalDelta) > context.threshold)) {
        // fire start event with original
        // starting coordinates
        assign(payload, {
          x: round$1(localStart.x + displacement.x),
          y: round$1(localStart.y + displacement.y),
          dx: 0,
          dy: 0
        }, {
          originalEvent: event
        });

        if (false === fire('start')) {
          return cancel();
        }

        context.active = true; // unset selection and remember old selection
        // the previous (old) selection will always passed
        // with the event via the event.previousSelection property

        if (!context.keepSelection) {
          payload.previousSelection = selection.get();
          selection.select(null);
        } // allow custom cursor


        if (context.cursor) {
          set$1(context.cursor);
        } // indicate dragging via marker on root element


        canvas.addMarker(canvas.getRootElement(), DRAG_ACTIVE_CLS);
      }

      stopPropagation(event);

      if (context.active) {
        // update payload with actual coordinates
        assign(payload, {
          x: round$1(localCurrent.x + displacement.x),
          y: round$1(localCurrent.y + displacement.y),
          dx: round$1(localDelta.x),
          dy: round$1(localDelta.y)
        }, {
          originalEvent: event
        }); // emit move event

        fire('move');
      }
    }

    function end(event) {
      var previousContext,
          returnValue = true;

      if (context.active) {
        if (event) {
          context.payload.originalEvent = event; // suppress original event (click, ...)
          // because we just ended a drag operation

          stopPropagation(event);
        } // implementations may stop restoring the
        // original state (selections, ...) by preventing the
        // end events default action


        returnValue = fire('end');
      }

      if (returnValue === false) {
        fire('rejected');
      }

      previousContext = cleanup(returnValue !== true); // last event to be fired when all drag operations are done
      // at this point in time no drag operation is in progress anymore

      fire('ended', previousContext);
    } // cancel active drag operation if the user presses
    // the ESC key on the keyboard


    function checkCancel(event) {
      if (event.which === 27) {
        preventDefault(event);
        cancel();
      }
    } // prevent ghost click that might occur after a finished
    // drag and drop session


    function trapClickAndEnd(event) {
      var untrap; // trap the click in case we are part of an active
      // drag operation. This will effectively prevent
      // the ghost click that cannot be canceled otherwise.

      if (context.active) {
        untrap = install(eventBus); // remove trap after minimal delay

        setTimeout(untrap, 400); // prevent default action (click)

        preventDefault(event);
      }

      end(event);
    }

    function trapTouch(event) {
      move(event);
    } // update the drag events hover (djs.model.Base) and hoverGfx (Snap<SVGElement>)
    // properties during hover and out and fire {prefix}.hover and {prefix}.out properties
    // respectively


    function hover(event) {
      var payload = context.payload;
      payload.hoverGfx = event.gfx;
      payload.hover = event.element;
      fire('hover');
    }

    function out(event) {
      fire('out');
      var payload = context.payload;
      payload.hoverGfx = null;
      payload.hover = null;
    } // life-cycle methods


    function cancel(restore) {
      var previousContext;

      if (!context) {
        return;
      }

      var wasActive = context.active;

      if (wasActive) {
        fire('cancel');
      }

      previousContext = cleanup(restore);

      if (wasActive) {
        // last event to be fired when all drag operations are done
        // at this point in time no drag operation is in progress anymore
        fire('canceled', previousContext);
      }
    }

    function cleanup(restore) {
      var previousContext, endDrag;
      fire('cleanup'); // reset cursor

      unset();

      if (context.trapClick) {
        endDrag = trapClickAndEnd;
      } else {
        endDrag = end;
      } // reset dom listeners


      componentEvent.unbind(document, 'mousemove', move);
      componentEvent.unbind(document, 'dragstart', preventDefault);
      componentEvent.unbind(document, 'selectstart', preventDefault);
      componentEvent.unbind(document, 'mousedown', endDrag, true);
      componentEvent.unbind(document, 'mouseup', endDrag, true);
      componentEvent.unbind(document, 'keyup', checkCancel);
      componentEvent.unbind(document, 'touchstart', trapTouch, true);
      componentEvent.unbind(document, 'touchcancel', cancel, true);
      componentEvent.unbind(document, 'touchmove', move, true);
      componentEvent.unbind(document, 'touchend', end, true);
      eventBus.off('element.hover', hover);
      eventBus.off('element.out', out); // remove drag marker on root element

      canvas.removeMarker(canvas.getRootElement(), DRAG_ACTIVE_CLS); // restore selection, unless it has changed

      var previousSelection = context.payload.previousSelection;

      if (restore !== false && previousSelection && !selection.get().length) {
        restoreSelection(previousSelection);
      }

      previousContext = context;
      context = null;
      return previousContext;
    }
    /**
     * Initialize a drag operation.
     *
     * If `localPosition` is given, drag events will be emitted
     * relative to it.
     *
     * @param {MouseEvent|TouchEvent} [event]
     * @param {Point} [localPosition] actual diagram local position this drag operation should start at
     * @param {string} prefix
     * @param {Object} [options]
     */


    function init(event, relativeTo, prefix, options) {
      // only one drag operation may be active, at a time
      if (context) {
        cancel(false);
      }

      if (typeof relativeTo === 'string') {
        options = prefix;
        prefix = relativeTo;
        relativeTo = null;
      }

      options = assign({}, defaultOptions, options || {});
      var data = options.data || {},
          originalEvent,
          globalStart,
          localStart,
          endDrag,
          isTouch;

      if (options.trapClick) {
        endDrag = trapClickAndEnd;
      } else {
        endDrag = end;
      }

      if (event) {
        originalEvent = getOriginal(event) || event;
        globalStart = toPoint(event);
        stopPropagation(event); // prevent default browser dragging behavior

        if (originalEvent.type === 'dragstart') {
          preventDefault(originalEvent);
        }
      } else {
        originalEvent = null;
        globalStart = {
          x: 0,
          y: 0
        };
      }

      localStart = toLocalPoint(globalStart);

      if (!relativeTo) {
        relativeTo = localStart;
      }

      isTouch = isTouchEvent(originalEvent);
      context = assign({
        prefix: prefix,
        data: data,
        payload: {},
        globalStart: globalStart,
        displacement: delta(relativeTo, localStart),
        localStart: localStart,
        isTouch: isTouch
      }, options); // skip dom registration if trigger
      // is set to manual (during testing)

      if (!options.manual) {
        // add dom listeners
        if (isTouch) {
          componentEvent.bind(document, 'touchstart', trapTouch, true);
          componentEvent.bind(document, 'touchcancel', cancel, true);
          componentEvent.bind(document, 'touchmove', move, true);
          componentEvent.bind(document, 'touchend', end, true);
        } else {
          // assume we use the mouse to interact per default
          componentEvent.bind(document, 'mousemove', move); // prevent default browser drag and text selection behavior

          componentEvent.bind(document, 'dragstart', preventDefault);
          componentEvent.bind(document, 'selectstart', preventDefault);
          componentEvent.bind(document, 'mousedown', endDrag, true);
          componentEvent.bind(document, 'mouseup', endDrag, true);
        }

        componentEvent.bind(document, 'keyup', checkCancel);
        eventBus.on('element.hover', hover);
        eventBus.on('element.out', out);
      }

      fire('init');

      if (options.autoActivate) {
        move(event, true);
      }
    } // cancel on diagram destruction


    eventBus.on('diagram.destroy', cancel); // API

    this.init = init;
    this.move = move;
    this.hover = hover;
    this.out = out;
    this.end = end;
    this.cancel = cancel; // for introspection

    this.context = function () {
      return context;
    };

    this.setOptions = function (options) {
      assign(defaultOptions, options);
    };
  }
  Dragging.$inject = ['eventBus', 'canvas', 'selection', 'elementRegistry'];

  var DraggingModule = {
    __depends__: [HoverFixModule, SelectionModule],
    dragging: ['type', Dragging]
  };

  /**
   * Initiates canvas scrolling if current cursor point is close to a border.
   * Cancelled when current point moves back inside the scrolling borders
   * or cancelled manually.
   *
   * Default options :
   *   scrollThresholdIn: [ 20, 20, 20, 20 ],
   *   scrollThresholdOut: [ 0, 0, 0, 0 ],
   *   scrollRepeatTimeout: 15,
   *   scrollStep: 10
   *
   * Threshold order:
   *   [ left, top, right, bottom ]
   */

  function AutoScroll(config, eventBus, canvas) {
    this._canvas = canvas;
    this._opts = assign({
      scrollThresholdIn: [20, 20, 20, 20],
      scrollThresholdOut: [0, 0, 0, 0],
      scrollRepeatTimeout: 15,
      scrollStep: 10
    }, config);
    var self = this;
    eventBus.on('drag.move', function (e) {
      var point = self._toBorderPoint(e);

      self.startScroll(point);
    });
    eventBus.on(['drag.cleanup'], function () {
      self.stopScroll();
    });
  }
  AutoScroll.$inject = ['config.autoScroll', 'eventBus', 'canvas'];
  /**
   * Starts scrolling loop.
   * Point is given in global scale in canvas container box plane.
   *
   * @param  {Object} point { x: X, y: Y }
   */

  AutoScroll.prototype.startScroll = function (point) {
    var canvas = this._canvas;
    var opts = this._opts;
    var self = this;
    var clientRect = canvas.getContainer().getBoundingClientRect();
    var diff = [point.x, point.y, clientRect.width - point.x, clientRect.height - point.y];
    this.stopScroll();
    var dx = 0,
        dy = 0;

    for (var i = 0; i < 4; i++) {
      if (between(diff[i], opts.scrollThresholdOut[i], opts.scrollThresholdIn[i])) {
        if (i === 0) {
          dx = opts.scrollStep;
        } else if (i == 1) {
          dy = opts.scrollStep;
        } else if (i == 2) {
          dx = -opts.scrollStep;
        } else if (i == 3) {
          dy = -opts.scrollStep;
        }
      }
    }

    if (dx !== 0 || dy !== 0) {
      canvas.scroll({
        dx: dx,
        dy: dy
      });
      this._scrolling = setTimeout(function () {
        self.startScroll(point);
      }, opts.scrollRepeatTimeout);
    }
  };

  function between(val, start, end) {
    if (start < val && val < end) {
      return true;
    }

    return false;
  }
  /**
   * Stops scrolling loop.
   */


  AutoScroll.prototype.stopScroll = function () {
    clearTimeout(this._scrolling);
  };
  /**
   * Overrides defaults options.
   *
   * @param  {Object} options
   */


  AutoScroll.prototype.setOptions = function (options) {
    this._opts = assign({}, this._opts, options);
  };
  /**
   * Converts event to a point in canvas container plane in global scale.
   *
   * @param  {Event} event
   * @return {Point}
   */


  AutoScroll.prototype._toBorderPoint = function (event) {
    var clientRect = this._canvas._container.getBoundingClientRect();

    var globalPosition = toPoint(event.originalEvent);
    return {
      x: globalPosition.x - clientRect.left,
      y: globalPosition.y - clientRect.top
    };
  };

  var AutoScrollModule = {
    __depends__: [DraggingModule],
    __init__: ['autoScroll'],
    autoScroll: ['type', AutoScroll]
  };

  /**
   * A service that provides rules for certain diagram actions.
   *
   * The default implementation will hook into the {@link CommandStack}
   * to perform the actual rule evaluation. Make sure to provide the
   * `commandStack` service with this module if you plan to use it.
   *
   * Together with this implementation you may use the {@link RuleProvider}
   * to implement your own rule checkers.
   *
   * This module is ment to be easily replaced, thus the tiny foot print.
   *
   * @param {Injector} injector
   */
  function Rules(injector) {
    this._commandStack = injector.get('commandStack', false);
  }
  Rules.$inject = ['injector'];
  /**
   * Returns whether or not a given modeling action can be executed
   * in the specified context.
   *
   * This implementation will respond with allow unless anyone
   * objects.
   *
   * @param {string} action the action to be checked
   * @param {Object} [context] the context to check the action in
   *
   * @return {boolean} returns true, false or null depending on whether the
   *                   operation is allowed, not allowed or should be ignored.
   */

  Rules.prototype.allowed = function (action, context) {
    var allowed = true;
    var commandStack = this._commandStack;

    if (commandStack) {
      allowed = commandStack.canExecute(action, context);
    } // map undefined to true, i.e. no rules


    return allowed === undefined ? true : allowed;
  };

  var Rules$1 = {
    __init__: ['rules'],
    rules: ['type', Rules]
  };

  var round$2 = Math.round,
      max = Math.max;

  function circlePath(center, r) {
    var x = center.x,
        y = center.y;
    return [['M', x, y], ['m', 0, -r], ['a', r, r, 0, 1, 1, 0, 2 * r], ['a', r, r, 0, 1, 1, 0, -2 * r], ['z']];
  }

  function linePath(points) {
    var segments = [];
    points.forEach(function (p, idx) {
      segments.push([idx === 0 ? 'M' : 'L', p.x, p.y]);
    });
    return segments;
  }

  var INTERSECTION_THRESHOLD = 10;

  function getBendpointIntersection(waypoints, reference) {
    var i, w;

    for (i = 0; w = waypoints[i]; i++) {
      if (pointDistance(w, reference) <= INTERSECTION_THRESHOLD) {
        return {
          point: waypoints[i],
          bendpoint: true,
          index: i
        };
      }
    }

    return null;
  }

  function getPathIntersection(waypoints, reference) {
    var intersections = intersect(circlePath(reference, INTERSECTION_THRESHOLD), linePath(waypoints));
    var a = intersections[0],
        b = intersections[intersections.length - 1],
        idx;

    if (!a) {
      // no intersection
      return null;
    }

    if (a !== b) {
      if (a.segment2 !== b.segment2) {
        // we use the bendpoint in between both segments
        // as the intersection point
        idx = max(a.segment2, b.segment2) - 1;
        return {
          point: waypoints[idx],
          bendpoint: true,
          index: idx
        };
      }

      return {
        point: {
          x: round$2(a.x + b.x) / 2,
          y: round$2(a.y + b.y) / 2
        },
        index: a.segment2
      };
    }

    return {
      point: {
        x: round$2(a.x),
        y: round$2(a.y)
      },
      index: a.segment2
    };
  }
  /**
   * Returns the closest point on the connection towards a given reference point.
   *
   * @param  {Array<Point>} waypoints
   * @param  {Point} reference
   *
   * @return {Object} intersection data (segment, point)
   */


  function getApproxIntersection(waypoints, reference) {
    return getBendpointIntersection(waypoints, reference) || getPathIntersection(waypoints, reference);
  }

  var BENDPOINT_CLS = 'djs-bendpoint';
  var SEGMENT_DRAGGER_CLS = 'djs-segment-dragger';
  function toCanvasCoordinates(canvas, event) {
    var position = toPoint(event),
        clientRect = canvas._container.getBoundingClientRect(),
        offset; // canvas relative position


    offset = {
      x: clientRect.left,
      y: clientRect.top
    }; // update actual event payload with canvas relative measures

    var viewbox = canvas.viewbox();
    return {
      x: viewbox.x + (position.x - offset.x) / viewbox.scale,
      y: viewbox.y + (position.y - offset.y) / viewbox.scale
    };
  }
  function getConnectionIntersection(canvas, waypoints, event) {
    var localPosition = toCanvasCoordinates(canvas, event),
        intersection = getApproxIntersection(waypoints, localPosition);
    return intersection;
  }
  function addBendpoint(parentGfx, cls) {
    var groupGfx = create('g');
    classes$1(groupGfx).add(BENDPOINT_CLS);
    append(parentGfx, groupGfx);
    var visual = create('circle');
    attr$1(visual, {
      cx: 0,
      cy: 0,
      r: 4
    });
    classes$1(visual).add('djs-visual');
    append(groupGfx, visual);
    var hit = create('circle');
    attr$1(hit, {
      cx: 0,
      cy: 0,
      r: 10
    });
    classes$1(hit).add('djs-hit');
    append(groupGfx, hit);

    if (cls) {
      classes$1(groupGfx).add(cls);
    }

    return groupGfx;
  }

  function createParallelDragger(parentGfx, segmentStart, segmentEnd, alignment) {
    var draggerGfx = create('g');
    append(parentGfx, draggerGfx);
    var width = 14,
        height = 3,
        padding = 11,
        hitWidth = calculateHitWidth(segmentStart, segmentEnd, alignment),
        hitHeight = height + padding;
    var visual = create('rect');
    attr$1(visual, {
      x: -width / 2,
      y: -height / 2,
      width: width,
      height: height
    });
    classes$1(visual).add('djs-visual');
    append(draggerGfx, visual);
    var hit = create('rect');
    attr$1(hit, {
      x: -hitWidth / 2,
      y: -hitHeight / 2,
      width: hitWidth,
      height: hitHeight
    });
    classes$1(hit).add('djs-hit');
    append(draggerGfx, hit);
    rotate(draggerGfx, alignment === 'v' ? 90 : 0);
    return draggerGfx;
  }

  function addSegmentDragger(parentGfx, segmentStart, segmentEnd) {
    var groupGfx = create('g'),
        mid = getMidPoint(segmentStart, segmentEnd),
        alignment = pointsAligned(segmentStart, segmentEnd);
    append(parentGfx, groupGfx);
    createParallelDragger(groupGfx, segmentStart, segmentEnd, alignment);
    classes$1(groupGfx).add(SEGMENT_DRAGGER_CLS);
    classes$1(groupGfx).add(alignment === 'h' ? 'horizontal' : 'vertical');
    translate(groupGfx, mid.x, mid.y);
    return groupGfx;
  }
  /**
   * Calculates region for segment move which is 2/3 of the full segment length
   * @param {number} segmentLength
   *
   * @return {number}
   */

  function calculateSegmentMoveRegion(segmentLength) {
    return Math.abs(Math.round(segmentLength * 2 / 3));
  } // helper //////////

  function calculateHitWidth(segmentStart, segmentEnd, alignment) {
    var segmentLengthXAxis = segmentEnd.x - segmentStart.x,
        segmentLengthYAxis = segmentEnd.y - segmentStart.y;
    return alignment === 'h' ? calculateSegmentMoveRegion(segmentLengthXAxis) : calculateSegmentMoveRegion(segmentLengthYAxis);
  }

  var css_escape = createCommonjsModule(function (module, exports) {

    (function (root, factory) {
      // https://github.com/umdjs/umd/blob/master/returnExports.js
      {
        // For Node.js.
        module.exports = factory(root);
      }
    })(typeof commonjsGlobal != 'undefined' ? commonjsGlobal : commonjsGlobal, function (root) {
      if (root.CSS && root.CSS.escape) {
        return root.CSS.escape;
      } // https://drafts.csswg.org/cssom/#serialize-an-identifier


      var cssEscape = function cssEscape(value) {
        if (arguments.length == 0) {
          throw new TypeError('`CSS.escape` requires an argument.');
        }

        var string = String(value);
        var length = string.length;
        var index = -1;
        var codeUnit;
        var result = '';
        var firstCodeUnit = string.charCodeAt(0);

        while (++index < length) {
          codeUnit = string.charCodeAt(index); // Note: there’s no need to special-case astral symbols, surrogate
          // pairs, or lone surrogates.
          // If the character is NULL (U+0000), then the REPLACEMENT CHARACTER
          // (U+FFFD).

          if (codeUnit == 0x0000) {
            result += "\uFFFD";
            continue;
          }

          if ( // If the character is in the range [\1-\1F] (U+0001 to U+001F) or is
          // U+007F, […]
          codeUnit >= 0x0001 && codeUnit <= 0x001F || codeUnit == 0x007F || // If the character is the first character and is in the range [0-9]
          // (U+0030 to U+0039), […]
          index == 0 && codeUnit >= 0x0030 && codeUnit <= 0x0039 || // If the character is the second character and is in the range [0-9]
          // (U+0030 to U+0039) and the first character is a `-` (U+002D), […]
          index == 1 && codeUnit >= 0x0030 && codeUnit <= 0x0039 && firstCodeUnit == 0x002D) {
            // https://drafts.csswg.org/cssom/#escape-a-character-as-code-point
            result += '\\' + codeUnit.toString(16) + ' ';
            continue;
          }

          if ( // If the character is the first character and is a `-` (U+002D), and
          // there is no second character, […]
          index == 0 && length == 1 && codeUnit == 0x002D) {
            result += '\\' + string.charAt(index);
            continue;
          } // If the character is not handled by one of the above rules and is
          // greater than or equal to U+0080, is `-` (U+002D) or `_` (U+005F), or
          // is in one of the ranges [0-9] (U+0030 to U+0039), [A-Z] (U+0041 to
          // U+005A), or [a-z] (U+0061 to U+007A), […]


          if (codeUnit >= 0x0080 || codeUnit == 0x002D || codeUnit == 0x005F || codeUnit >= 0x0030 && codeUnit <= 0x0039 || codeUnit >= 0x0041 && codeUnit <= 0x005A || codeUnit >= 0x0061 && codeUnit <= 0x007A) {
            // the character itself
            result += string.charAt(index);
            continue;
          } // Otherwise, the escaped character.
          // https://drafts.csswg.org/cssom/#escape-a-character


          result += '\\' + string.charAt(index);
        }

        return result;
      };

      if (!root.CSS) {
        root.CSS = {};
      }

      root.CSS.escape = cssEscape;
      return cssEscape;
    });
  });

  /**
   * A service that adds editable bendpoints to connections.
   */

  function Bendpoints(eventBus, canvas, interactionEvents, bendpointMove, connectionSegmentMove) {
    /**
     * Returns true if intersection point is inside middle region of segment, adjusted by
     * optional threshold
     */
    function isIntersectionMiddle(intersection, waypoints, treshold) {
      var idx = intersection.index,
          p = intersection.point,
          p0,
          p1,
          mid,
          aligned,
          xDelta,
          yDelta;

      if (idx <= 0 || intersection.bendpoint) {
        return false;
      }

      p0 = waypoints[idx - 1];
      p1 = waypoints[idx];
      mid = getMidPoint(p0, p1), aligned = pointsAligned(p0, p1);
      xDelta = Math.abs(p.x - mid.x);
      yDelta = Math.abs(p.y - mid.y);
      return aligned && xDelta <= treshold && yDelta <= treshold;
    }
    /**
     * Calculates the threshold from a connection's middle which fits the two-third-region
     */


    function calculateIntersectionThreshold(connection, intersection) {
      var waypoints = connection.waypoints,
          relevantSegment,
          alignment,
          segmentLength,
          threshold;

      if (intersection.index <= 0 || intersection.bendpoint) {
        return null;
      } // segment relative to connection intersection


      relevantSegment = {
        start: waypoints[intersection.index - 1],
        end: waypoints[intersection.index]
      };
      alignment = pointsAligned(relevantSegment.start, relevantSegment.end);

      if (!alignment) {
        return null;
      }

      if (alignment === 'h') {
        segmentLength = relevantSegment.end.x - relevantSegment.start.x;
      } else {
        segmentLength = relevantSegment.end.y - relevantSegment.start.y;
      } // calculate threshold relative to 2/3 of segment length


      threshold = calculateSegmentMoveRegion(segmentLength) / 2;
      return threshold;
    }

    function activateBendpointMove(event, connection) {
      var waypoints = connection.waypoints,
          intersection = getConnectionIntersection(canvas, waypoints, event),
          threshold;

      if (!intersection) {
        return;
      }

      threshold = calculateIntersectionThreshold(connection, intersection);

      if (isIntersectionMiddle(intersection, waypoints, threshold)) {
        connectionSegmentMove.start(event, connection, intersection.index);
      } else {
        bendpointMove.start(event, connection, intersection.index, !intersection.bendpoint);
      } // we've handled the event


      return true;
    }

    function bindInteractionEvents(node, eventName, element) {
      componentEvent.bind(node, eventName, function (event) {
        interactionEvents.triggerMouseEvent(eventName, event, element);
        event.stopPropagation();
      });
    }

    function getBendpointsContainer(element, create$1) {
      var layer = canvas.getLayer('overlays'),
          gfx = query('.djs-bendpoints[data-element-id="' + css_escape(element.id) + '"]', layer);

      if (!gfx && create$1) {
        gfx = create('g');
        attr$1(gfx, {
          'data-element-id': element.id
        });
        classes$1(gfx).add('djs-bendpoints');
        append(layer, gfx);
        bindInteractionEvents(gfx, 'mousedown', element);
        bindInteractionEvents(gfx, 'click', element);
        bindInteractionEvents(gfx, 'dblclick', element);
      }

      return gfx;
    }

    function getSegmentDragger(idx, parentGfx) {
      return query('.djs-segment-dragger[data-segment-idx="' + idx + '"]', parentGfx);
    }

    function createBendpoints(gfx, connection) {
      connection.waypoints.forEach(function (p, idx) {
        var bendpoint = addBendpoint(gfx);
        append(gfx, bendpoint);
        translate(bendpoint, p.x, p.y);
      }); // add floating bendpoint

      addBendpoint(gfx, 'floating');
    }

    function createSegmentDraggers(gfx, connection) {
      var waypoints = connection.waypoints;
      var segmentStart, segmentEnd, segmentDraggerGfx;

      for (var i = 1; i < waypoints.length; i++) {
        segmentStart = waypoints[i - 1];
        segmentEnd = waypoints[i];

        if (pointsAligned(segmentStart, segmentEnd)) {
          segmentDraggerGfx = addSegmentDragger(gfx, segmentStart, segmentEnd);
          attr$1(segmentDraggerGfx, {
            'data-segment-idx': i
          });
          bindInteractionEvents(segmentDraggerGfx, 'mousemove', connection);
        }
      }
    }

    function clearBendpoints(gfx) {
      forEach(all('.' + BENDPOINT_CLS, gfx), function (node) {
        remove$1(node);
      });
    }

    function clearSegmentDraggers(gfx) {
      forEach(all('.' + SEGMENT_DRAGGER_CLS, gfx), function (node) {
        remove$1(node);
      });
    }

    function addHandles(connection) {
      var gfx = getBendpointsContainer(connection);

      if (!gfx) {
        gfx = getBendpointsContainer(connection, true);
        createBendpoints(gfx, connection);
        createSegmentDraggers(gfx, connection);
      }

      return gfx;
    }

    function updateHandles(connection) {
      var gfx = getBendpointsContainer(connection);

      if (gfx) {
        clearSegmentDraggers(gfx);
        clearBendpoints(gfx);
        createSegmentDraggers(gfx, connection);
        createBendpoints(gfx, connection);
      }
    }

    function updateFloatingBendpointPosition(parentGfx, intersection) {
      var floating = query('.floating', parentGfx),
          point = intersection.point;

      if (!floating) {
        return;
      }

      translate(floating, point.x, point.y);
    }

    function updateSegmentDraggerPosition(parentGfx, intersection, waypoints) {
      var draggerGfx = getSegmentDragger(intersection.index, parentGfx),
          segmentStart = waypoints[intersection.index - 1],
          segmentEnd = waypoints[intersection.index],
          point = intersection.point,
          mid = getMidPoint(segmentStart, segmentEnd),
          alignment = pointsAligned(segmentStart, segmentEnd),
          draggerVisual,
          relativePosition;

      if (!draggerGfx) {
        return;
      }

      draggerVisual = getDraggerVisual(draggerGfx);
      relativePosition = {
        x: point.x - mid.x,
        y: point.y - mid.y
      };

      if (alignment === 'v') {
        // rotate position
        relativePosition = {
          x: relativePosition.y,
          y: relativePosition.x
        };
      }

      translate(draggerVisual, relativePosition.x, relativePosition.y);
    }

    eventBus.on('connection.changed', function (event) {
      updateHandles(event.element);
    });
    eventBus.on('connection.remove', function (event) {
      var gfx = getBendpointsContainer(event.element);

      if (gfx) {
        remove$1(gfx);
      }
    });
    eventBus.on('element.marker.update', function (event) {
      var element = event.element,
          bendpointsGfx;

      if (!element.waypoints) {
        return;
      }

      bendpointsGfx = addHandles(element);

      if (event.add) {
        classes$1(bendpointsGfx).add(event.marker);
      } else {
        classes$1(bendpointsGfx).remove(event.marker);
      }
    });
    eventBus.on('element.mousemove', function (event) {
      var element = event.element,
          waypoints = element.waypoints,
          bendpointsGfx,
          intersection;

      if (waypoints) {
        bendpointsGfx = getBendpointsContainer(element, true);
        intersection = getConnectionIntersection(canvas, waypoints, event.originalEvent);

        if (!intersection) {
          return;
        }

        updateFloatingBendpointPosition(bendpointsGfx, intersection);

        if (!intersection.bendpoint) {
          updateSegmentDraggerPosition(bendpointsGfx, intersection, waypoints);
        }
      }
    });
    eventBus.on('element.mousedown', function (event) {
      if (!isPrimaryButton(event)) {
        return;
      }

      var originalEvent = event.originalEvent,
          element = event.element;

      if (!element.waypoints) {
        return;
      }

      return activateBendpointMove(originalEvent, element);
    });
    eventBus.on('selection.changed', function (event) {
      var newSelection = event.newSelection,
          primary = newSelection[0];

      if (primary && primary.waypoints) {
        addHandles(primary);
      }
    });
    eventBus.on('element.hover', function (event) {
      var element = event.element;

      if (element.waypoints) {
        addHandles(element);
        interactionEvents.registerEvent(event.gfx, 'mousemove', 'element.mousemove');
      }
    });
    eventBus.on('element.out', function (event) {
      interactionEvents.unregisterEvent(event.gfx, 'mousemove', 'element.mousemove');
    }); // update bendpoint container data attribute on element ID change

    eventBus.on('element.updateId', function (context) {
      var element = context.element,
          newId = context.newId;

      if (element.waypoints) {
        var bendpointContainer = getBendpointsContainer(element);

        if (bendpointContainer) {
          attr$1(bendpointContainer, {
            'data-element-id': newId
          });
        }
      }
    }); // API

    this.addHandles = addHandles;
    this.updateHandles = updateHandles;
    this.getBendpointsContainer = getBendpointsContainer;
    this.getSegmentDragger = getSegmentDragger;
  }
  Bendpoints.$inject = ['eventBus', 'canvas', 'interactionEvents', 'bendpointMove', 'connectionSegmentMove']; // helper /////////////

  function getDraggerVisual(draggerGfx) {
    return query('.djs-visual', draggerGfx);
  }

  var round$3 = Math.round;
  var RECONNECT_START = 'reconnectStart',
      RECONNECT_END = 'reconnectEnd',
      UPDATE_WAYPOINTS = 'updateWaypoints';
  /**
   * Move bendpoints through drag and drop to add/remove bendpoints or reconnect connection.
   */

  function BendpointMove(injector, eventBus, canvas, dragging, rules, modeling) {
    this._injector = injector;

    this.start = function (event, connection, bendpointIndex, insert) {
      var gfx = canvas.getGraphics(connection),
          source = connection.source,
          target = connection.target,
          waypoints = connection.waypoints,
          type;

      if (!insert && bendpointIndex === 0) {
        type = RECONNECT_START;
      } else if (!insert && bendpointIndex === waypoints.length - 1) {
        type = RECONNECT_END;
      } else {
        type = UPDATE_WAYPOINTS;
      }

      var command = type === UPDATE_WAYPOINTS ? 'connection.updateWaypoints' : 'connection.reconnect';
      var allowed = rules.allowed(command, {
        connection: connection,
        source: source,
        target: target
      });

      if (allowed === false) {
        allowed = rules.allowed(command, {
          connection: connection,
          source: target,
          target: source
        });
      }

      if (allowed === false) {
        return;
      }

      dragging.init(event, 'bendpoint.move', {
        data: {
          connection: connection,
          connectionGfx: gfx,
          context: {
            allowed: allowed,
            bendpointIndex: bendpointIndex,
            connection: connection,
            source: source,
            target: target,
            insert: insert,
            type: type
          }
        }
      });
    };

    eventBus.on('bendpoint.move.hover', function (event) {
      var context = event.context,
          connection = context.connection,
          source = connection.source,
          target = connection.target,
          hover = event.hover,
          type = context.type; // cache hover state

      context.hover = hover;
      var allowed;

      if (!hover) {
        return;
      }

      var command = type === UPDATE_WAYPOINTS ? 'connection.updateWaypoints' : 'connection.reconnect';
      allowed = context.allowed = rules.allowed(command, {
        connection: connection,
        source: type === RECONNECT_START ? hover : source,
        target: type === RECONNECT_END ? hover : target
      });

      if (allowed) {
        context.source = type === RECONNECT_START ? hover : source;
        context.target = type === RECONNECT_END ? hover : target;
        return;
      }

      if (allowed === false) {
        allowed = context.allowed = rules.allowed(command, {
          connection: connection,
          source: type === RECONNECT_END ? hover : target,
          target: type === RECONNECT_START ? hover : source
        });
      }

      if (allowed) {
        context.source = type === RECONNECT_END ? hover : target;
        context.target = type === RECONNECT_START ? hover : source;
      }
    });
    eventBus.on(['bendpoint.move.out', 'bendpoint.move.cleanup'], function (event) {
      var context = event.context;
      context.hover = null;
      context.source = null;
      context.target = null;
      context.allowed = false;
    });
    eventBus.on('bendpoint.move.end', function (event) {
      var context = event.context,
          allowed = context.allowed,
          bendpointIndex = context.bendpointIndex,
          connection = context.connection,
          insert = context.insert,
          newWaypoints = connection.waypoints.slice(),
          source = context.source,
          target = context.target,
          type = context.type,
          hints = context.hints || {}; // ensure integer values (important if zoom level was > 1 during move)

      var docking = {
        x: round$3(event.x),
        y: round$3(event.y)
      };

      if (!allowed) {
        return false;
      }

      if (type === UPDATE_WAYPOINTS) {
        if (insert) {
          // insert new bendpoint
          newWaypoints.splice(bendpointIndex, 0, docking);
        } else {
          // swap previous waypoint with moved one
          newWaypoints[bendpointIndex] = docking;
        } // pass hints about actual moved bendpoint
        // useful for connection/label layout


        hints.bendpointMove = {
          insert: insert,
          bendpointIndex: bendpointIndex
        };
        newWaypoints = this.cropWaypoints(connection, newWaypoints);
        modeling.updateWaypoints(connection, filterRedundantWaypoints(newWaypoints), hints);
      } else {
        if (type === RECONNECT_START) {
          hints.docking = 'source';

          if (isReverse(context)) {
            hints.docking = 'target';
            hints.newWaypoints = newWaypoints.reverse();
          }
        } else if (type === RECONNECT_END) {
          hints.docking = 'target';

          if (isReverse(context)) {
            hints.docking = 'source';
            hints.newWaypoints = newWaypoints.reverse();
          }
        }

        modeling.reconnect(connection, source, target, docking, hints);
      }
    }, this);
  }
  BendpointMove.$inject = ['injector', 'eventBus', 'canvas', 'dragging', 'rules', 'modeling'];

  BendpointMove.prototype.cropWaypoints = function (connection, newWaypoints) {
    var connectionDocking = this._injector.get('connectionDocking', false);

    if (!connectionDocking) {
      return newWaypoints;
    }

    var waypoints = connection.waypoints;
    connection.waypoints = newWaypoints;
    connection.waypoints = connectionDocking.getCroppedWaypoints(connection);
    newWaypoints = connection.waypoints;
    connection.waypoints = waypoints;
    return newWaypoints;
  }; // helpers //////////


  function isReverse(context) {
    var hover = context.hover,
        source = context.source,
        target = context.target,
        type = context.type;

    if (type === RECONNECT_START) {
      return hover && target && hover === target && source !== target;
    }

    if (type === RECONNECT_END) {
      return hover && source && hover === source && source !== target;
    }
  }

  var RECONNECT_START$1 = 'reconnectStart',
      RECONNECT_END$1 = 'reconnectEnd',
      UPDATE_WAYPOINTS$1 = 'updateWaypoints';
  var MARKER_OK = 'connect-ok',
      MARKER_NOT_OK = 'connect-not-ok',
      MARKER_CONNECT_HOVER = 'connect-hover',
      MARKER_CONNECT_UPDATING = 'djs-updating',
      MARKER_ELEMENT_HIDDEN = 'djs-element-hidden';
  var HIGH_PRIORITY$1 = 1100;
  /**
   * Preview connection while moving bendpoints.
   */

  function BendpointMovePreview(bendpointMove, injector, eventBus, canvas) {
    this._injector = injector;
    var connectionPreview = injector.get('connectionPreview', false);
    eventBus.on('bendpoint.move.start', function (event) {
      var context = event.context,
          bendpointIndex = context.bendpointIndex,
          connection = context.connection,
          insert = context.insert,
          waypoints = connection.waypoints,
          newWaypoints = waypoints.slice();
      context.waypoints = waypoints;

      if (insert) {
        // insert placeholder for new bendpoint
        newWaypoints.splice(bendpointIndex, 0, {
          x: event.x,
          y: event.y
        });
      }

      connection.waypoints = newWaypoints; // add dragger gfx

      var draggerGfx = context.draggerGfx = addBendpoint(canvas.getLayer('overlays'));
      classes$1(draggerGfx).add('djs-dragging');
      canvas.addMarker(connection, MARKER_ELEMENT_HIDDEN);
      canvas.addMarker(connection, MARKER_CONNECT_UPDATING);
    });
    eventBus.on('bendpoint.move.hover', function (event) {
      var context = event.context,
          allowed = context.allowed,
          hover = context.hover,
          type = context.type;

      if (hover) {
        canvas.addMarker(hover, MARKER_CONNECT_HOVER);

        if (type === UPDATE_WAYPOINTS$1) {
          return;
        }

        if (allowed) {
          canvas.removeMarker(hover, MARKER_NOT_OK);
          canvas.addMarker(hover, MARKER_OK);
        } else if (allowed === false) {
          canvas.removeMarker(hover, MARKER_OK);
          canvas.addMarker(hover, MARKER_NOT_OK);
        }
      }
    });
    eventBus.on(['bendpoint.move.out', 'bendpoint.move.cleanup'], HIGH_PRIORITY$1, function (event) {
      var context = event.context,
          hover = context.hover,
          target = context.target;

      if (hover) {
        canvas.removeMarker(hover, MARKER_CONNECT_HOVER);
        canvas.removeMarker(hover, target ? MARKER_OK : MARKER_NOT_OK);
      }
    });
    eventBus.on('bendpoint.move.move', function (event) {
      var context = event.context,
          allowed = context.allowed,
          bendpointIndex = context.bendpointIndex,
          draggerGfx = context.draggerGfx,
          hover = context.hover,
          type = context.type,
          connection = context.connection,
          source = connection.source,
          target = connection.target,
          newWaypoints = connection.waypoints.slice(),
          bendpoint = {
        x: event.x,
        y: event.y
      },
          hints = context.hints || {},
          drawPreviewHints = {};

      if (connectionPreview) {
        if (hints.connectionStart) {
          drawPreviewHints.connectionStart = hints.connectionStart;
        }

        if (hints.connectionEnd) {
          drawPreviewHints.connectionEnd = hints.connectionEnd;
        }

        if (type === RECONNECT_START$1) {
          if (isReverse(context)) {
            drawPreviewHints.connectionEnd = drawPreviewHints.connectionEnd || bendpoint;
            drawPreviewHints.source = target;
            drawPreviewHints.target = hover || source;
            newWaypoints = newWaypoints.reverse();
          } else {
            drawPreviewHints.connectionStart = drawPreviewHints.connectionStart || bendpoint;
            drawPreviewHints.source = hover || source;
            drawPreviewHints.target = target;
          }
        } else if (type === RECONNECT_END$1) {
          if (isReverse(context)) {
            drawPreviewHints.connectionStart = drawPreviewHints.connectionStart || bendpoint;
            drawPreviewHints.source = hover || target;
            drawPreviewHints.target = source;
            newWaypoints = newWaypoints.reverse();
          } else {
            drawPreviewHints.connectionEnd = drawPreviewHints.connectionEnd || bendpoint;
            drawPreviewHints.source = source;
            drawPreviewHints.target = hover || target;
          }
        } else {
          drawPreviewHints.noCropping = true;
          drawPreviewHints.noLayout = true;
          newWaypoints[bendpointIndex] = bendpoint;
        }

        if (type === UPDATE_WAYPOINTS$1) {
          newWaypoints = bendpointMove.cropWaypoints(connection, newWaypoints);
        }

        drawPreviewHints.waypoints = newWaypoints;
        connectionPreview.drawPreview(context, allowed, drawPreviewHints);
      }

      translate(draggerGfx, event.x, event.y);
    }, this);
    eventBus.on(['bendpoint.move.end', 'bendpoint.move.cancel'], HIGH_PRIORITY$1, function (event) {
      var context = event.context,
          connection = context.connection,
          draggerGfx = context.draggerGfx,
          hover = context.hover,
          target = context.target,
          waypoints = context.waypoints;
      connection.waypoints = waypoints; // remove dragger gfx

      remove$1(draggerGfx);
      canvas.removeMarker(connection, MARKER_CONNECT_UPDATING);
      canvas.removeMarker(connection, MARKER_ELEMENT_HIDDEN);

      if (hover) {
        canvas.removeMarker(hover, MARKER_OK);
        canvas.removeMarker(hover, target ? MARKER_OK : MARKER_NOT_OK);
      }

      if (connectionPreview) {
        connectionPreview.cleanUp(context);
      }
    });
  }
  BendpointMovePreview.$inject = ['bendpointMove', 'injector', 'eventBus', 'canvas'];

  var MARKER_CONNECT_HOVER$1 = 'connect-hover',
      MARKER_CONNECT_UPDATING$1 = 'djs-updating';

  function axisAdd(point, axis, delta) {
    return axisSet(point, axis, point[axis] + delta);
  }

  function axisSet(point, axis, value) {
    return {
      x: axis === 'x' ? value : point.x,
      y: axis === 'y' ? value : point.y
    };
  }

  function axisFenced(position, segmentStart, segmentEnd, axis) {
    var maxValue = Math.max(segmentStart[axis], segmentEnd[axis]),
        minValue = Math.min(segmentStart[axis], segmentEnd[axis]);
    var padding = 20;
    var fencedValue = Math.min(Math.max(minValue + padding, position[axis]), maxValue - padding);
    return axisSet(segmentStart, axis, fencedValue);
  }

  function flipAxis(axis) {
    return axis === 'x' ? 'y' : 'x';
  }
  /**
   * Get the docking point on the given element.
   *
   * Compute a reasonable docking, if non exists.
   *
   * @param  {Point} point
   * @param  {djs.model.Shape} referenceElement
   * @param  {string} moveAxis (x|y)
   *
   * @return {Point}
   */


  function getDocking(point, referenceElement, moveAxis) {
    var referenceMid, inverseAxis;

    if (point.original) {
      return point.original;
    } else {
      referenceMid = getMid(referenceElement);
      inverseAxis = flipAxis(moveAxis);
      return axisSet(point, inverseAxis, referenceMid[inverseAxis]);
    }
  }
  /**
   * A component that implements moving of bendpoints
   */


  function ConnectionSegmentMove(injector, eventBus, canvas, dragging, graphicsFactory, modeling) {
    // optional connection docking integration
    var connectionDocking = injector.get('connectionDocking', false); // API

    this.start = function (event, connection, idx) {
      var context,
          gfx = canvas.getGraphics(connection),
          segmentStartIndex = idx - 1,
          segmentEndIndex = idx,
          waypoints = connection.waypoints,
          segmentStart = waypoints[segmentStartIndex],
          segmentEnd = waypoints[segmentEndIndex],
          intersection = getConnectionIntersection(canvas, waypoints, event),
          direction,
          axis,
          dragPosition;
      direction = pointsAligned(segmentStart, segmentEnd); // do not move diagonal connection

      if (!direction) {
        return;
      } // the axis where we are going to move things


      axis = direction === 'v' ? 'x' : 'y';

      if (segmentStartIndex === 0) {
        segmentStart = getDocking(segmentStart, connection.source, axis);
      }

      if (segmentEndIndex === waypoints.length - 1) {
        segmentEnd = getDocking(segmentEnd, connection.target, axis);
      }

      if (intersection) {
        dragPosition = intersection.point;
      } else {
        // set to segment center as default
        dragPosition = {
          x: (segmentStart.x + segmentEnd.x) / 2,
          y: (segmentStart.y + segmentEnd.y) / 2
        };
      }

      context = {
        connection: connection,
        segmentStartIndex: segmentStartIndex,
        segmentEndIndex: segmentEndIndex,
        segmentStart: segmentStart,
        segmentEnd: segmentEnd,
        axis: axis,
        dragPosition: dragPosition
      };
      dragging.init(event, dragPosition, 'connectionSegment.move', {
        cursor: axis === 'x' ? 'resize-ew' : 'resize-ns',
        data: {
          connection: connection,
          connectionGfx: gfx,
          context: context
        }
      });
    };
    /**
     * Crop connection if connection cropping is provided.
     *
     * @param {Connection} connection
     * @param {Array<Point>} newWaypoints
     *
     * @return {Array<Point>} cropped connection waypoints
     */


    function cropConnection(connection, newWaypoints) {
      // crop connection, if docking service is provided only
      if (!connectionDocking) {
        return newWaypoints;
      }

      var oldWaypoints = connection.waypoints,
          croppedWaypoints; // temporary set new waypoints

      connection.waypoints = newWaypoints;
      croppedWaypoints = connectionDocking.getCroppedWaypoints(connection); // restore old waypoints

      connection.waypoints = oldWaypoints;
      return croppedWaypoints;
    } // DRAGGING IMPLEMENTATION


    function redrawConnection(data) {
      graphicsFactory.update('connection', data.connection, data.connectionGfx);
    }

    function updateDragger(context, segmentOffset, event) {
      var newWaypoints = context.newWaypoints,
          segmentStartIndex = context.segmentStartIndex + segmentOffset,
          segmentStart = newWaypoints[segmentStartIndex],
          segmentEndIndex = context.segmentEndIndex + segmentOffset,
          segmentEnd = newWaypoints[segmentEndIndex],
          axis = flipAxis(context.axis); // make sure the dragger does not move
      // outside the connection

      var draggerPosition = axisFenced(event, segmentStart, segmentEnd, axis); // update dragger

      translate(context.draggerGfx, draggerPosition.x, draggerPosition.y);
    }
    /**
     * Filter waypoints for redundant ones (i.e. on the same axis).
     * Returns the filtered waypoints and the offset related to the segment move.
     *
     * @param {Array<Point>} waypoints
     * @param {Integer} segmentStartIndex of moved segment start
     *
     * @return {Object} { filteredWaypoints, segmentOffset }
     */


    function filterRedundantWaypoints(waypoints, segmentStartIndex) {
      var segmentOffset = 0;
      var filteredWaypoints = waypoints.filter(function (r, idx) {
        if (pointsOnLine(waypoints[idx - 1], waypoints[idx + 1], r)) {
          // remove point and increment offset
          segmentOffset = idx <= segmentStartIndex ? segmentOffset - 1 : segmentOffset;
          return false;
        } // dont remove point


        return true;
      });
      return {
        waypoints: filteredWaypoints,
        segmentOffset: segmentOffset
      };
    }

    eventBus.on('connectionSegment.move.start', function (event) {
      var context = event.context,
          connection = event.connection,
          layer = canvas.getLayer('overlays');
      context.originalWaypoints = connection.waypoints.slice(); // add dragger gfx

      context.draggerGfx = addSegmentDragger(layer, context.segmentStart, context.segmentEnd);
      classes$1(context.draggerGfx).add('djs-dragging');
      canvas.addMarker(connection, MARKER_CONNECT_UPDATING$1);
    });
    eventBus.on('connectionSegment.move.move', function (event) {
      var context = event.context,
          connection = context.connection,
          segmentStartIndex = context.segmentStartIndex,
          segmentEndIndex = context.segmentEndIndex,
          segmentStart = context.segmentStart,
          segmentEnd = context.segmentEnd,
          axis = context.axis;
      var newWaypoints = context.originalWaypoints.slice(),
          newSegmentStart = axisAdd(segmentStart, axis, event['d' + axis]),
          newSegmentEnd = axisAdd(segmentEnd, axis, event['d' + axis]); // original waypoint count and added / removed
      // from start waypoint delta. We use the later
      // to retrieve the updated segmentStartIndex / segmentEndIndex

      var waypointCount = newWaypoints.length,
          segmentOffset = 0; // move segment start / end by axis delta

      newWaypoints[segmentStartIndex] = newSegmentStart;
      newWaypoints[segmentEndIndex] = newSegmentEnd;
      var sourceToSegmentOrientation, targetToSegmentOrientation; // handle first segment

      if (segmentStartIndex < 2) {
        sourceToSegmentOrientation = getOrientation(connection.source, newSegmentStart); // first bendpoint, remove first segment if intersecting

        if (segmentStartIndex === 1) {
          if (sourceToSegmentOrientation === 'intersect') {
            newWaypoints.shift();
            newWaypoints[0] = newSegmentStart;
            segmentOffset--;
          }
        } // docking point, add segment if not intersecting anymore
        else {
            if (sourceToSegmentOrientation !== 'intersect') {
              newWaypoints.unshift(segmentStart);
              segmentOffset++;
            }
          }
      } // handle last segment


      if (segmentEndIndex > waypointCount - 3) {
        targetToSegmentOrientation = getOrientation(connection.target, newSegmentEnd); // last bendpoint, remove last segment if intersecting

        if (segmentEndIndex === waypointCount - 2) {
          if (targetToSegmentOrientation === 'intersect') {
            newWaypoints.pop();
            newWaypoints[newWaypoints.length - 1] = newSegmentEnd;
          }
        } // last bendpoint, remove last segment if intersecting
        else {
            if (targetToSegmentOrientation !== 'intersect') {
              newWaypoints.push(segmentEnd);
            }
          }
      } // update connection waypoints


      context.newWaypoints = connection.waypoints = cropConnection(connection, newWaypoints); // update dragger position

      updateDragger(context, segmentOffset, event); // save segmentOffset in context

      context.newSegmentStartIndex = segmentStartIndex + segmentOffset; // redraw connection

      redrawConnection(event);
    });
    eventBus.on('connectionSegment.move.hover', function (event) {
      event.context.hover = event.hover;
      canvas.addMarker(event.hover, MARKER_CONNECT_HOVER$1);
    });
    eventBus.on(['connectionSegment.move.out', 'connectionSegment.move.cleanup'], function (event) {
      // remove connect marker
      // if it was added
      var hover = event.context.hover;

      if (hover) {
        canvas.removeMarker(hover, MARKER_CONNECT_HOVER$1);
      }
    });
    eventBus.on('connectionSegment.move.cleanup', function (event) {
      var context = event.context,
          connection = context.connection; // remove dragger gfx

      if (context.draggerGfx) {
        remove$1(context.draggerGfx);
      }

      canvas.removeMarker(connection, MARKER_CONNECT_UPDATING$1);
    });
    eventBus.on(['connectionSegment.move.cancel', 'connectionSegment.move.end'], function (event) {
      var context = event.context,
          connection = context.connection;
      connection.waypoints = context.originalWaypoints;
      redrawConnection(event);
    });
    eventBus.on('connectionSegment.move.end', function (event) {
      var context = event.context,
          connection = context.connection,
          newWaypoints = context.newWaypoints,
          newSegmentStartIndex = context.newSegmentStartIndex; // ensure we have actual pixel values bendpoint
      // coordinates (important when zoom level was > 1 during move)

      newWaypoints = newWaypoints.map(function (p) {
        return {
          original: p.original,
          x: Math.round(p.x),
          y: Math.round(p.y)
        };
      }); // apply filter redunant waypoints

      var filtered = filterRedundantWaypoints(newWaypoints, newSegmentStartIndex); // get filtered waypoints

      var filteredWaypoints = filtered.waypoints,
          croppedWaypoints = cropConnection(connection, filteredWaypoints),
          segmentOffset = filtered.segmentOffset;
      var hints = {
        segmentMove: {
          segmentStartIndex: context.segmentStartIndex,
          newSegmentStartIndex: newSegmentStartIndex + segmentOffset
        }
      };
      modeling.updateWaypoints(connection, croppedWaypoints, hints);
    });
  }
  ConnectionSegmentMove.$inject = ['injector', 'eventBus', 'canvas', 'dragging', 'graphicsFactory', 'modeling'];

  var abs$1 = Math.abs,
      round$4 = Math.round;
  /**
   * Snap value to a collection of reference values.
   *
   * @param  {number} value
   * @param  {Array<number>} values
   * @param  {number} [tolerance=10]
   *
   * @return {number} the value we snapped to or null, if none snapped
   */

  function snapTo(value, values, tolerance) {
    tolerance = tolerance === undefined ? 10 : tolerance;
    var idx, snapValue;

    for (idx = 0; idx < values.length; idx++) {
      snapValue = values[idx];

      if (abs$1(snapValue - value) <= tolerance) {
        return snapValue;
      }
    }
  }
  function topLeft(bounds) {
    return {
      x: bounds.x,
      y: bounds.y
    };
  }
  function bottomRight(bounds) {
    return {
      x: bounds.x + bounds.width,
      y: bounds.y + bounds.height
    };
  }
  function mid(bounds, defaultValue) {
    if (!bounds || isNaN(bounds.x) || isNaN(bounds.y)) {
      return defaultValue;
    }

    return {
      x: round$4(bounds.x + bounds.width / 2),
      y: round$4(bounds.y + bounds.height / 2)
    };
  }
  /**
   * Retrieve the snap state of the given event.
   *
   * @param  {Event} event
   * @param  {string} axis
   *
   * @return {boolean} the snapped state
   *
   */

  function isSnapped(event, axis) {
    var snapped = event.snapped;

    if (!snapped) {
      return false;
    }

    if (typeof axis === 'string') {
      return snapped[axis];
    }

    return snapped.x && snapped.y;
  }
  /**
   * Set the given event as snapped.
   *
   * This method may change the x and/or y position of the shape
   * from the given event!
   *
   * @param {Event} event
   * @param {string} axis
   * @param {number|boolean} value
   *
   * @return {number} old value
   */

  function setSnapped(event, axis, value) {
    if (typeof axis !== 'string') {
      throw new Error('axis must be in [x, y]');
    }

    if (typeof value !== 'number' && value !== false) {
      throw new Error('value must be Number or false');
    }

    var delta,
        previousValue = event[axis];
    var snapped = event.snapped = event.snapped || {};

    if (value === false) {
      snapped[axis] = false;
    } else {
      snapped[axis] = true;
      delta = value - previousValue;
      event[axis] += delta;
      event['d' + axis] += delta;
    }

    return previousValue;
  }
  /**
   * Get children of a shape.
   *
   * @param {djs.model.Shape} parent
   *
   * @returns {Array<djs.model.Shape|djs.model.Connection>}
   */

  function getChildren$1(parent) {
    return parent.children || [];
  }

  var abs$2 = Math.abs,
      round$5 = Math.round;
  var TOLERANCE = 10;
  function BendpointSnapping(eventBus) {
    function snapTo(values, value) {
      if (isArray(values)) {
        var i = values.length;

        while (i--) {
          if (abs$2(values[i] - value) <= TOLERANCE) {
            return values[i];
          }
        }
      } else {
        values = +values;
        var rem = value % values;

        if (rem < TOLERANCE) {
          return value - rem;
        }

        if (rem > values - TOLERANCE) {
          return value - rem + values;
        }
      }

      return value;
    }

    function mid(element) {
      if (element.width) {
        return {
          x: round$5(element.width / 2 + element.x),
          y: round$5(element.height / 2 + element.y)
        };
      }
    } // connection segment snapping //////////////////////


    function getConnectionSegmentSnaps(context) {
      var snapPoints = context.snapPoints,
          connection = context.connection,
          waypoints = connection.waypoints,
          segmentStart = context.segmentStart,
          segmentStartIndex = context.segmentStartIndex,
          segmentEnd = context.segmentEnd,
          segmentEndIndex = context.segmentEndIndex,
          axis = context.axis;

      if (snapPoints) {
        return snapPoints;
      }

      var referenceWaypoints = [waypoints[segmentStartIndex - 1], segmentStart, segmentEnd, waypoints[segmentEndIndex + 1]];

      if (segmentStartIndex < 2) {
        referenceWaypoints.unshift(mid(connection.source));
      }

      if (segmentEndIndex > waypoints.length - 3) {
        referenceWaypoints.unshift(mid(connection.target));
      }

      context.snapPoints = snapPoints = {
        horizontal: [],
        vertical: []
      };
      forEach(referenceWaypoints, function (p) {
        // we snap on existing bendpoints only,
        // not placeholders that are inserted during add
        if (p) {
          p = p.original || p;

          if (axis === 'y') {
            snapPoints.horizontal.push(p.y);
          }

          if (axis === 'x') {
            snapPoints.vertical.push(p.x);
          }
        }
      });
      return snapPoints;
    }

    eventBus.on('connectionSegment.move.move', 1500, function (event) {
      var context = event.context,
          snapPoints = getConnectionSegmentSnaps(context),
          x = event.x,
          y = event.y,
          sx,
          sy;

      if (!snapPoints) {
        return;
      } // snap


      sx = snapTo(snapPoints.vertical, x);
      sy = snapTo(snapPoints.horizontal, y); // correction x/y

      var cx = x - sx,
          cy = y - sy; // update delta

      assign(event, {
        dx: event.dx - cx,
        dy: event.dy - cy,
        x: sx,
        y: sy
      }); // only set snapped if actually snapped

      if (cx || snapPoints.vertical.indexOf(x) !== -1) {
        setSnapped(event, 'x', sx);
      }

      if (cy || snapPoints.horizontal.indexOf(y) !== -1) {
        setSnapped(event, 'y', sy);
      }
    }); // bendpoint snapping //////////////////////

    function getBendpointSnaps(context) {
      var snapPoints = context.snapPoints,
          waypoints = context.connection.waypoints,
          bendpointIndex = context.bendpointIndex;

      if (snapPoints) {
        return snapPoints;
      }

      var referenceWaypoints = [waypoints[bendpointIndex - 1], waypoints[bendpointIndex + 1]];
      context.snapPoints = snapPoints = {
        horizontal: [],
        vertical: []
      };
      forEach(referenceWaypoints, function (p) {
        // we snap on existing bendpoints only,
        // not placeholders that are inserted during add
        if (p) {
          p = p.original || p;
          snapPoints.horizontal.push(p.y);
          snapPoints.vertical.push(p.x);
        }
      });
      return snapPoints;
    }

    eventBus.on(['bendpoint.move.move', 'bendpoint.move.end'], 1500, function (event) {
      var context = event.context,
          snapPoints = getBendpointSnaps(context),
          hover = context.hover,
          hoverMid = hover && mid(hover),
          x = event.x,
          y = event.y,
          sx,
          sy;

      if (!snapPoints) {
        return;
      } // snap to hover mid


      sx = snapTo(hoverMid ? snapPoints.vertical.concat([hoverMid.x]) : snapPoints.vertical, x);
      sy = snapTo(hoverMid ? snapPoints.horizontal.concat([hoverMid.y]) : snapPoints.horizontal, y); // correction x/y

      var cx = x - sx,
          cy = y - sy; // update delta

      assign(event, {
        dx: event.dx - cx,
        dy: event.dy - cy,
        x: event.x - cx,
        y: event.y - cy
      }); // only set snapped if actually snapped

      if (cx || snapPoints.vertical.indexOf(x) !== -1) {
        setSnapped(event, 'x', sx);
      }

      if (cy || snapPoints.horizontal.indexOf(y) !== -1) {
        setSnapped(event, 'y', sy);
      }
    });
  }
  BendpointSnapping.$inject = ['eventBus'];

  var BendpointsModule = {
    __depends__: [DraggingModule, Rules$1],
    __init__: ['bendpoints', 'bendpointSnapping', 'bendpointMovePreview'],
    bendpoints: ['type', Bendpoints],
    bendpointMove: ['type', BendpointMove],
    bendpointMovePreview: ['type', BendpointMovePreview],
    connectionSegmentMove: ['type', ConnectionSegmentMove],
    bendpointSnapping: ['type', BendpointSnapping]
  };

  var entrySelector = '.entry';
  var DEFAULT_PRIORITY$1 = 1000;
  /**
   * A context pad that displays element specific, contextual actions next
   * to a diagram element.
   *
   * @param {Object} config
   * @param {boolean|Object} [config.scale={ min: 1.0, max: 1.5 }]
   * @param {number} [config.scale.min]
   * @param {number} [config.scale.max]
   * @param {EventBus} eventBus
   * @param {Overlays} overlays
   */

  function ContextPad(config, eventBus, overlays) {
    this._eventBus = eventBus;
    this._overlays = overlays;
    var scale = isDefined(config && config.scale) ? config.scale : {
      min: 1,
      max: 1.5
    };
    this._overlaysConfig = {
      position: {
        right: -9,
        top: -6
      },
      scale: scale
    };
    this._current = null;

    this._init();
  }
  ContextPad.$inject = ['config.contextPad', 'eventBus', 'overlays'];
  /**
   * Registers events needed for interaction with other components
   */

  ContextPad.prototype._init = function () {
    var eventBus = this._eventBus;
    var self = this;
    eventBus.on('selection.changed', function (e) {
      var selection = e.newSelection;

      if (selection.length === 1) {
        self.open(selection[0]);
      } else {
        self.close();
      }
    });
    eventBus.on('elements.delete', function (event) {
      var elements = event.elements;
      forEach(elements, function (e) {
        if (self.isOpen(e)) {
          self.close();
        }
      });
    });
    eventBus.on('element.changed', function (event) {
      var element = event.element,
          current = self._current; // force reopen if element for which we are currently opened changed

      if (current && current.element === element) {
        self.open(element, true);
      }
    });
  };
  /**
   * Register a provider with the context pad
   *
   * @param  {number} [priority=1000]
   * @param  {ContextPadProvider} provider
   *
   * @example
   * const contextPadProvider = {
    *   getContextPadEntries: function(element) {
    *     return function(entries) {
    *       return {
    *         ...entries,
    *         'entry-1': {
    *           label: 'My Entry',
    *           action: function() { alert("I have been clicked!"); }
    *         }
    *       };
    *     }
    *   }
    * };
    *
   * contextPad.registerProvider(800, contextPadProvider);
   */


  ContextPad.prototype.registerProvider = function (priority, provider) {
    if (!provider) {
      provider = priority;
      priority = DEFAULT_PRIORITY$1;
    }

    this._eventBus.on('contextPad.getProviders', priority, function (event) {
      event.providers.push(provider);
    });
  };
  /**
   * Returns the context pad entries for a given element
   *
   * @param {djs.element.Base} element
   *
   * @return {Array<ContextPadEntryDescriptor>} list of entries
   */


  ContextPad.prototype.getEntries = function (element) {
    var providers = this._getProviders();

    var entries = {}; // loop through all providers and their entries.
    // group entries by id so that overriding an entry is possible

    forEach(providers, function (provider) {
      var entriesOrUpdater = provider.getContextPadEntries(element);

      if (isFunction(entriesOrUpdater)) {
        entries = entriesOrUpdater(entries);
      } else {
        forEach(entriesOrUpdater, function (entry, id) {
          entries[id] = entry;
        });
      }
    });
    return entries;
  };
  /**
   * Trigger an action available on the opened context pad
   *
   * @param  {string} action
   * @param  {Event} event
   * @param  {boolean} [autoActivate=false]
   */


  ContextPad.prototype.trigger = function (action, event, autoActivate) {
    var element = this._current.element,
        entries = this._current.entries,
        entry,
        handler,
        originalEvent,
        button = event.delegateTarget || event.target;

    if (!button) {
      return event.preventDefault();
    }

    entry = entries[attr(button, 'data-action')];
    handler = entry.action;
    originalEvent = event.originalEvent || event; // simple action (via callback function)

    if (isFunction(handler)) {
      if (action === 'click') {
        return handler(originalEvent, element, autoActivate);
      }
    } else {
      if (handler[action]) {
        return handler[action](originalEvent, element, autoActivate);
      }
    } // silence other actions


    event.preventDefault();
  };
  /**
   * Open the context pad for the given element
   *
   * @param {djs.model.Base} element
   * @param {boolean} force if true, force reopening the context pad
   */


  ContextPad.prototype.open = function (element, force) {
    if (!force && this.isOpen(element)) {
      return;
    }

    this.close();

    this._updateAndOpen(element);
  };

  ContextPad.prototype._getProviders = function (id) {
    var event = this._eventBus.createEvent({
      type: 'contextPad.getProviders',
      providers: []
    });

    this._eventBus.fire(event);

    return event.providers;
  };

  ContextPad.prototype._updateAndOpen = function (element) {
    var entries = this.getEntries(element),
        pad = this.getPad(element),
        html = pad.html;
    forEach(entries, function (entry, id) {
      var grouping = entry.group || 'default',
          control = domify(entry.html || '<div class="entry" draggable="true"></div>'),
          container;
      attr(control, 'data-action', id);
      container = query('[data-group=' + grouping + ']', html);

      if (!container) {
        container = domify('<div class="group" data-group="' + grouping + '"></div>');
        html.appendChild(container);
      }

      container.appendChild(control);

      if (entry.className) {
        addClasses(control, entry.className);
      }

      if (entry.title) {
        attr(control, 'title', entry.title);
      }

      if (entry.imageUrl) {
        control.appendChild(domify('<img src="' + entry.imageUrl + '">'));
      }
    });
    classes(html).add('open');
    this._current = {
      element: element,
      pad: pad,
      entries: entries
    };

    this._eventBus.fire('contextPad.open', {
      current: this._current
    });
  };

  ContextPad.prototype.getPad = function (element) {
    if (this.isOpen()) {
      return this._current.pad;
    }

    var self = this;
    var overlays = this._overlays;
    var html = domify('<div class="djs-context-pad"></div>');
    var overlaysConfig = assign({
      html: html
    }, this._overlaysConfig);
    delegate.bind(html, entrySelector, 'click', function (event) {
      self.trigger('click', event);
    });
    delegate.bind(html, entrySelector, 'dragstart', function (event) {
      self.trigger('dragstart', event);
    }); // stop propagation of mouse events

    componentEvent.bind(html, 'mousedown', function (event) {
      event.stopPropagation();
    });
    this._overlayId = overlays.add(element, 'context-pad', overlaysConfig);
    var pad = overlays.get(this._overlayId);

    this._eventBus.fire('contextPad.create', {
      element: element,
      pad: pad
    });

    return pad;
  };
  /**
   * Close the context pad
   */


  ContextPad.prototype.close = function () {
    if (!this.isOpen()) {
      return;
    }

    this._overlays.remove(this._overlayId);

    this._overlayId = null;

    this._eventBus.fire('contextPad.close', {
      current: this._current
    });

    this._current = null;
  };
  /**
   * Check if pad is open. If element is given, will check
   * if pad is opened with given element.
   *
   * @param {Element} element
   * @return {boolean}
   */


  ContextPad.prototype.isOpen = function (element) {
    return !!this._current && (!element ? true : this._current.element === element);
  }; // helpers //////////////////////


  function addClasses(element, classNames) {
    var classes$1 = classes(element);
    var actualClassNames = isArray(classNames) ? classNames : classNames.split(/\s+/g);
    actualClassNames.forEach(function (cls) {
      classes$1.add(cls);
    });
  }

  var DiagramContextPad = {
    __depends__: [InteractionEventsModule, OverlaysModule],
    contextPad: ['type', ContextPad]
  };

  function Connect(eventBus, dragging, modeling, rules) {
    // rules
    function canConnect(source, target) {
      return rules.allowed('connection.create', {
        source: source,
        target: target
      });
    }

    function canConnectReverse(source, target) {
      return canConnect(target, source);
    } // event handlers


    eventBus.on('connect.hover', function (event) {
      var context = event.context,
          start = context.start,
          hover = event.hover,
          canExecute; // cache hover state

      context.hover = hover;
      canExecute = context.canExecute = canConnect(start, hover); // ignore hover

      if (isNil(canExecute)) {
        return;
      }

      if (canExecute !== false) {
        context.source = start;
        context.target = hover;
        return;
      }

      canExecute = context.canExecute = canConnectReverse(start, hover); // ignore hover

      if (isNil(canExecute)) {
        return;
      }

      if (canExecute !== false) {
        context.source = hover;
        context.target = start;
      }
    });
    eventBus.on(['connect.out', 'connect.cleanup'], function (event) {
      var context = event.context;
      context.hover = null;
      context.source = null;
      context.target = null;
      context.canExecute = false;
    });
    eventBus.on('connect.end', function (event) {
      var context = event.context,
          canExecute = context.canExecute,
          connectionStart = context.connectionStart,
          connectionEnd = {
        x: event.x,
        y: event.y
      },
          source = context.source,
          target = context.target;

      if (!canExecute) {
        return false;
      }

      var attrs = null,
          hints = {
        connectionStart: isReverse$1(context) ? connectionEnd : connectionStart,
        connectionEnd: isReverse$1(context) ? connectionStart : connectionEnd
      };

      if (isObject(canExecute)) {
        attrs = canExecute;
      }

      modeling.connect(source, target, attrs, hints);
    }); // API

    /**
     * Start connect operation.
     *
     * @param {DOMEvent} event
     * @param {djs.model.Base} start
     * @param {Point} [connectionStart]
     * @param {boolean} [autoActivate=false]
     */

    this.start = function (event, start, connectionStart, autoActivate) {
      if (!isObject(connectionStart)) {
        autoActivate = connectionStart;
        connectionStart = getMid(start);
      }

      dragging.init(event, 'connect', {
        autoActivate: autoActivate,
        data: {
          shape: start,
          context: {
            start: start,
            connectionStart: connectionStart
          }
        }
      });
    };
  }
  Connect.$inject = ['eventBus', 'dragging', 'modeling', 'rules']; // helpers //////////

  function isReverse$1(context) {
    var hover = context.hover,
        source = context.source,
        target = context.target;
    return hover && source && hover === source && source !== target;
  }

  var HIGH_PRIORITY$2 = 1100,
      LOW_PRIORITY$4 = 900;
  var MARKER_OK$1 = 'connect-ok',
      MARKER_NOT_OK$1 = 'connect-not-ok';
  /**
   * Shows connection preview during connect.
   *
   * @param {didi.Injector} injector
   * @param {EventBus} eventBus
   * @param {Canvas} canvas
   */

  function ConnectPreview(injector, eventBus, canvas) {
    var connectionPreview = injector.get('connectionPreview', false);
    connectionPreview && eventBus.on('connect.move', function (event) {
      var context = event.context,
          canConnect = context.canExecute,
          hover = context.hover,
          source = context.source,
          start = context.start,
          startPosition = context.startPosition,
          connectionStart = context.connectionStart,
          connectionEnd = context.connectionEnd,
          target = context.target;

      if (!connectionStart) {
        connectionStart = isReverse$1(context) ? {
          x: event.x,
          y: event.y
        } : startPosition;
      }

      if (!connectionEnd) {
        connectionEnd = isReverse$1(context) ? startPosition : {
          x: event.x,
          y: event.y
        };
      }

      connectionPreview.drawPreview(context, canConnect, {
        source: source || start,
        target: target || hover,
        connectionStart: connectionStart,
        connectionEnd: connectionEnd
      });
    });
    eventBus.on('connect.hover', LOW_PRIORITY$4, function (event) {
      var context = event.context,
          hover = event.hover,
          canExecute = context.canExecute; // ignore hover

      if (canExecute === null) {
        return;
      }

      canvas.addMarker(hover, canExecute ? MARKER_OK$1 : MARKER_NOT_OK$1);
    });
    eventBus.on(['connect.out', 'connect.cleanup'], HIGH_PRIORITY$2, function (event) {
      var hover = event.hover;

      if (hover) {
        canvas.removeMarker(hover, MARKER_OK$1);
        canvas.removeMarker(hover, MARKER_NOT_OK$1);
      }
    });
    connectionPreview && eventBus.on('connect.cleanup', function (event) {
      connectionPreview.cleanUp(event.context);
    });
  }
  ConnectPreview.$inject = ['injector', 'eventBus', 'canvas'];

  var DiagramConnect = {
    __depends__: [SelectionModule, Rules$1, DraggingModule],
    __init__: ['connectPreview'],
    connect: ['type', Connect],
    connectPreview: ['type', ConnectPreview]
  };

  var MARKER_TYPES = ['marker-start', 'marker-mid', 'marker-end'];
  var NODES_CAN_HAVE_MARKER = ['circle', 'ellipse', 'line', 'path', 'polygon', 'polyline', 'rect'];
  /**
   * Adds support for previews of moving/resizing elements.
   */

  function PreviewSupport(elementRegistry, eventBus, canvas, styles) {
    this._elementRegistry = elementRegistry;
    this._canvas = canvas;
    this._styles = styles;
    this._clonedMarkers = {};
    var self = this;
    eventBus.on('drag.cleanup', function () {
      forEach(self._clonedMarkers, function (clonedMarker) {
        remove$1(clonedMarker);
      });
      self._clonedMarkers = {};
    });
  }
  PreviewSupport.$inject = ['elementRegistry', 'eventBus', 'canvas', 'styles'];
  /**
   * Returns graphics of an element.
   *
   * @param {djs.model.Base} element
   *
   * @return {SVGElement}
   */

  PreviewSupport.prototype.getGfx = function (element) {
    return this._elementRegistry.getGraphics(element);
  };
  /**
   * Adds a move preview of a given shape to a given svg group.
   *
   * @param {djs.model.Base} element
   * @param {SVGElement} group
   * @param {SVGElement} [gfx]
   *
   * @return {SVGElement} dragger
   */


  PreviewSupport.prototype.addDragger = function (element, group, gfx) {
    gfx = gfx || this.getGfx(element);
    var dragger = clone(gfx);
    var bbox = gfx.getBoundingClientRect();

    this._cloneMarkers(getVisual(dragger));

    attr$1(dragger, this._styles.cls('djs-dragger', [], {
      x: bbox.top,
      y: bbox.left
    }));
    append(group, dragger);
    return dragger;
  };
  /**
   * Adds a resize preview of a given shape to a given svg group.
   *
   * @param {djs.model.Base} element
   * @param {SVGElement} group
   *
   * @return {SVGElement} frame
   */


  PreviewSupport.prototype.addFrame = function (shape, group) {
    var frame = create('rect', {
      "class": 'djs-resize-overlay',
      width: shape.width,
      height: shape.height,
      x: shape.x,
      y: shape.y
    });
    append(group, frame);
    return frame;
  };
  /**
   * Clone all markers referenced by a node and its child nodes.
   *
   * @param {SVGElement} gfx
   */


  PreviewSupport.prototype._cloneMarkers = function (gfx) {
    var self = this;

    if (gfx.childNodes) {
      // TODO: use forEach once we drop PhantomJS
      for (var i = 0; i < gfx.childNodes.length; i++) {
        // recursively clone markers of child nodes
        self._cloneMarkers(gfx.childNodes[i]);
      }
    }

    if (!canHaveMarker(gfx)) {
      return;
    }

    MARKER_TYPES.forEach(function (markerType) {
      if (attr$1(gfx, markerType)) {
        var marker = getMarker(gfx, markerType, self._canvas.getContainer());

        self._cloneMarker(gfx, marker, markerType);
      }
    });
  };
  /**
   * Clone marker referenced by an element.
   *
   * @param {SVGElement} gfx
   * @param {SVGElement} marker
   * @param {string} markerType
   */


  PreviewSupport.prototype._cloneMarker = function (gfx, marker, markerType) {
    var markerId = marker.id;
    var clonedMarker = this._clonedMarkers[markerId];

    if (!clonedMarker) {
      clonedMarker = clone(marker);
      var clonedMarkerId = markerId + '-clone';
      clonedMarker.id = clonedMarkerId;
      classes$1(clonedMarker).add('djs-dragger').add('djs-dragger-marker');
      this._clonedMarkers[markerId] = clonedMarker;
      var defs = query('defs', this._canvas._svg);

      if (!defs) {
        defs = create('defs');
        append(this._canvas._svg, defs);
      }

      append(defs, clonedMarker);
    }

    var reference = idToReference(this._clonedMarkers[markerId].id);
    attr$1(gfx, markerType, reference);
  }; // helpers //////////

  /**
   * Get marker of given type referenced by node.
   *
   * @param {Node} node
   * @param {string} markerType
   * @param {Node} [parentNode]
   *
   * @param {Node}
   */


  function getMarker(node, markerType, parentNode) {
    var id = referenceToId(attr$1(node, markerType));
    return query('marker#' + id, parentNode || document);
  }
  /**
   * Get ID of fragment within current document from its functional IRI reference.
   * References may use single or double quotes.
   *
   * @param {string} reference
   *
   * @returns {string}
   */


  function referenceToId(reference) {
    return reference.match(/url\(['"]?#([^'"]*)['"]?\)/)[1];
  }
  /**
   * Get functional IRI reference for given ID of fragment within current document.
   *
   * @param {string} id
   *
   * @returns {string}
   */


  function idToReference(id) {
    return 'url(#' + id + ')';
  }
  /**
   * Check wether node type can have marker attributes.
   *
   * @param {Node} node
   *
   * @returns {boolean}
   */


  function canHaveMarker(node) {
    return NODES_CAN_HAVE_MARKER.indexOf(node.nodeName) !== -1;
  }

  var PreviewSupportModule = {
    __init__: ['previewSupport'],
    previewSupport: ['type', PreviewSupport]
  };

  var MARKER_OK$2 = 'drop-ok',
      MARKER_NOT_OK$2 = 'drop-not-ok',
      MARKER_ATTACH = 'attach-ok',
      MARKER_NEW_PARENT = 'new-parent';
  var PREFIX = 'create';
  var HIGH_PRIORITY$3 = 2000;
  /**
   * Create new elements through drag and drop.
   *
   * @param {Canvas} canvas
   * @param {Dragging} dragging
   * @param {EventBus} eventBus
   * @param {Modeling} modeling
   * @param {Rules} rules
   */

  function Create(canvas, dragging, eventBus, modeling, rules) {
    // rules //////////

    /**
     * Check wether elements can be created.
     *
     * @param {Array<djs.model.Base>} elements
     * @param {djs.model.Base} target
     * @param {Point} position
     * @param {djs.model.Base} [source]
     *
     * @returns {boolean|null|Object}
     */
    function canCreate(elements, target, position, source, hints) {
      if (!target) {
        return false;
      } // ignore child elements and external labels


      elements = filter(elements, function (element) {
        var labelTarget = element.labelTarget;
        return !element.parent && !(isLabel(element) && elements.indexOf(labelTarget) !== -1);
      });
      var shape = find(elements, function (element) {
        return !isConnection(element);
      });
      var attach = false,
          connect = false,
          create = false; // (1) attaching single shapes

      if (isSingleShape(elements)) {
        attach = rules.allowed('shape.attach', {
          position: position,
          shape: shape,
          target: target
        });
      }

      if (!attach) {
        // (2) creating elements
        if (isSingleShape(elements)) {
          create = rules.allowed('shape.create', {
            position: position,
            shape: shape,
            source: source,
            target: target
          });
        } else {
          create = rules.allowed('elements.create', {
            elements: elements,
            position: position,
            target: target
          });
        }
      }

      var connectionTarget = hints.connectionTarget; // (3) appending single shapes

      if (create || attach) {
        if (shape && source) {
          connect = rules.allowed('connection.create', {
            source: connectionTarget === source ? shape : source,
            target: connectionTarget === source ? source : shape,
            hints: {
              targetParent: target,
              targetAttach: attach
            }
          });
        }

        return {
          attach: attach,
          connect: connect
        };
      } // ignore wether or not elements can be created


      if (create === null || attach === null) {
        return null;
      }

      return false;
    }

    function setMarker(element, marker) {
      [MARKER_ATTACH, MARKER_OK$2, MARKER_NOT_OK$2, MARKER_NEW_PARENT].forEach(function (m) {
        if (m === marker) {
          canvas.addMarker(element, m);
        } else {
          canvas.removeMarker(element, m);
        }
      });
    } // event handling //////////


    eventBus.on(['create.move', 'create.hover'], function (event) {
      var context = event.context,
          elements = context.elements,
          hover = event.hover,
          source = context.source,
          hints = context.hints || {};

      if (!hover) {
        context.canExecute = false;
        context.target = null;
        return;
      }

      ensureConstraints(event);
      var position = {
        x: event.x,
        y: event.y
      };
      var canExecute = context.canExecute = hover && canCreate(elements, hover, position, source, hints);

      if (hover && canExecute !== null) {
        context.target = hover;

        if (canExecute && canExecute.attach) {
          setMarker(hover, MARKER_ATTACH);
        } else {
          setMarker(hover, canExecute ? MARKER_NEW_PARENT : MARKER_NOT_OK$2);
        }
      }
    });
    eventBus.on(['create.end', 'create.out', 'create.cleanup'], function (event) {
      var hover = event.hover;

      if (hover) {
        setMarker(hover, null);
      }
    });
    eventBus.on('create.end', function (event) {
      var context = event.context,
          source = context.source,
          shape = context.shape,
          elements = context.elements,
          target = context.target,
          canExecute = context.canExecute,
          attach = canExecute && canExecute.attach,
          connect = canExecute && canExecute.connect,
          hints = context.hints || {};

      if (canExecute === false || !target) {
        return false;
      }

      ensureConstraints(event);
      var position = {
        x: event.x,
        y: event.y
      };

      if (connect) {
        shape = modeling.appendShape(source, shape, position, target, {
          attach: attach,
          connection: connect === true ? {} : connect,
          connectionTarget: hints.connectionTarget
        });
      } else {
        elements = modeling.createElements(elements, position, target, assign({}, hints, {
          attach: attach
        })); // update shape

        shape = find(elements, function (element) {
          return !isConnection(element);
        });
      } // update elements and shape


      assign(context, {
        elements: elements,
        shape: shape
      });
      assign(event, {
        elements: elements,
        shape: shape
      });
    });

    function cancel() {
      var context = dragging.context();

      if (context && context.prefix === PREFIX) {
        dragging.cancel();
      }
    } // cancel on <elements.changed> that is not result of <drag.end>


    eventBus.on('create.init', function () {
      eventBus.on('elements.changed', cancel);
      eventBus.once(['create.cancel', 'create.end'], HIGH_PRIORITY$3, function () {
        eventBus.off('elements.changed', cancel);
      });
    }); // API //////////

    this.start = function (event, elements, context) {
      if (!isArray(elements)) {
        elements = [elements];
      }

      var shape = find(elements, function (element) {
        return !isConnection(element);
      });

      if (!shape) {
        // at least one shape is required
        return;
      }

      context = assign({
        elements: elements,
        hints: {},
        shape: shape
      }, context || {}); // make sure each element has x and y

      forEach(elements, function (element) {
        if (!isNumber(element.x)) {
          element.x = 0;
        }

        if (!isNumber(element.y)) {
          element.y = 0;
        }
      });
      var bbox = getBBox(elements); // center elements around cursor

      forEach(elements, function (element) {
        if (isConnection(element)) {
          element.waypoints = map(element.waypoints, function (waypoint) {
            return {
              x: waypoint.x - bbox.x - bbox.width / 2,
              y: waypoint.y - bbox.y - bbox.height / 2
            };
          });
        }

        assign(element, {
          x: element.x - bbox.x - bbox.width / 2,
          y: element.y - bbox.y - bbox.height / 2
        });
      });
      dragging.init(event, PREFIX, {
        cursor: 'grabbing',
        autoActivate: true,
        data: {
          shape: shape,
          elements: elements,
          context: context
        }
      });
    };
  }
  Create.$inject = ['canvas', 'dragging', 'eventBus', 'modeling', 'rules']; // helpers //////////

  function ensureConstraints(event) {
    var context = event.context,
        createConstraints = context.createConstraints;

    if (!createConstraints) {
      return;
    }

    if (createConstraints.left) {
      event.x = Math.max(event.x, createConstraints.left);
    }

    if (createConstraints.right) {
      event.x = Math.min(event.x, createConstraints.right);
    }

    if (createConstraints.top) {
      event.y = Math.max(event.y, createConstraints.top);
    }

    if (createConstraints.bottom) {
      event.y = Math.min(event.y, createConstraints.bottom);
    }
  }

  function isConnection(element) {
    return !!element.waypoints;
  }

  function isSingleShape(elements) {
    return elements && elements.length === 1 && !isConnection(elements[0]);
  }

  function isLabel(element) {
    return !!element.labelTarget;
  }

  var LOW_PRIORITY$5 = 750;
  function CreatePreview(canvas, eventBus, graphicsFactory, previewSupport, styles) {
    function createDragGroup(elements) {
      var dragGroup = create('g');
      attr$1(dragGroup, styles.cls('djs-drag-group', ['no-events']));
      var childrenGfx = create('g');
      elements.forEach(function (element) {
        // create graphics
        var gfx;

        if (element.hidden) {
          return;
        }

        if (element.waypoints) {
          gfx = graphicsFactory._createContainer('connection', childrenGfx);
          graphicsFactory.drawConnection(getVisual(gfx), element);
        } else {
          gfx = graphicsFactory._createContainer('shape', childrenGfx);
          graphicsFactory.drawShape(getVisual(gfx), element);
          translate(gfx, element.x, element.y);
        } // add preview


        previewSupport.addDragger(element, dragGroup, gfx);
      });
      return dragGroup;
    }

    eventBus.on('create.move', LOW_PRIORITY$5, function (event) {
      var hover = event.hover,
          context = event.context,
          elements = context.elements,
          dragGroup = context.dragGroup; // lazily create previews

      if (!dragGroup) {
        dragGroup = context.dragGroup = createDragGroup(elements);
      }

      var defaultLayer;

      if (hover) {
        if (!dragGroup.parentNode) {
          defaultLayer = canvas.getDefaultLayer();
          append(defaultLayer, dragGroup);
        }

        translate(dragGroup, event.x, event.y);
      } else {
        remove$1(dragGroup);
      }
    });
    eventBus.on('create.cleanup', function (event) {
      var context = event.context,
          dragGroup = context.dragGroup;

      if (dragGroup) {
        remove$1(dragGroup);
      }
    });
  }
  CreatePreview.$inject = ['canvas', 'eventBus', 'graphicsFactory', 'previewSupport', 'styles'];

  var DiagramCreate = {
    __depends__: [DraggingModule, PreviewSupportModule, Rules$1, SelectionModule],
    __init__: ['create', 'createPreview'],
    create: ['type', Create],
    createPreview: ['type', CreatePreview]
  };

  var DATA_REF = 'data-id';
  var CLOSE_EVENTS = ['contextPad.close', 'canvas.viewbox.changing', 'commandStack.changed'];
  var DEFAULT_PRIORITY$2 = 1000;
  /**
   * A popup menu that can be used to display a list of actions anywhere in the canvas.
   *
   * @param {Object} config
   * @param {boolean|Object} [config.scale={ min: 1.0, max: 1.5 }]
   * @param {number} [config.scale.min]
   * @param {number} [config.scale.max]
   * @param {EventBus} eventBus
   * @param {Canvas} canvas
   *
   * @class
   * @constructor
   */

  function PopupMenu(config, eventBus, canvas) {
    var scale = isDefined(config && config.scale) ? config.scale : {
      min: 1,
      max: 1.5
    };
    this._config = {
      scale: scale
    };
    this._eventBus = eventBus;
    this._canvas = canvas;
    this._providers = {};
    this._current = {};
  }
  PopupMenu.$inject = ['config.popupMenu', 'eventBus', 'canvas'];
  /**
   * Registers a popup menu provider
   *
   * @param  {string} id
   * @param {number} [priority=1000]
   * @param  {Object} provider
   *
   * @example
   * const popupMenuProvider = {
   *   getPopupMenuEntries: function(element) {
   *     return {
   *       'entry-1': {
   *         label: 'My Entry',
   *         action: function() { alert("I have been clicked!"); }
   *       }
   *     }
   *   }
   * };
   *
   * popupMenu.registerProvider('myMenuID', popupMenuProvider);
   */

  PopupMenu.prototype.registerProvider = function (id, priority, provider) {
    if (!provider) {
      provider = priority;
      priority = DEFAULT_PRIORITY$2;
    }

    this._eventBus.on('popupMenu.getProviders.' + id, priority, function (event) {
      event.providers.push(provider);
    });
  };
  /**
   * Determine if the popup menu has entries.
   *
   * @return {boolean} true if empty
   */


  PopupMenu.prototype.isEmpty = function (element, providerId) {
    if (!element) {
      throw new Error('element parameter is missing');
    }

    if (!providerId) {
      throw new Error('providerId parameter is missing');
    }

    var providers = this._getProviders(providerId);

    if (!providers) {
      return true;
    }

    var entries = this._getEntries(element, providers),
        headerEntries = this._getHeaderEntries(element, providers);

    var hasEntries = size(entries) > 0,
        hasHeaderEntries = headerEntries && size(headerEntries) > 0;
    return !hasEntries && !hasHeaderEntries;
  };
  /**
   * Create entries and open popup menu at given position
   *
   * @param  {Object} element
   * @param  {string} id provider id
   * @param  {Object} position
   *
   * @return {Object} popup menu instance
   */


  PopupMenu.prototype.open = function (element, id, position) {
    var providers = this._getProviders(id);

    if (!element) {
      throw new Error('Element is missing');
    }

    if (!providers || !providers.length) {
      throw new Error('No registered providers for: ' + id);
    }

    if (!position) {
      throw new Error('the position argument is missing');
    }

    if (this.isOpen()) {
      this.close();
    }

    this._emit('open');

    var current = this._current = {
      className: id,
      element: element,
      position: position
    };

    var entries = this._getEntries(element, providers),
        headerEntries = this._getHeaderEntries(element, providers);

    current.entries = assign({}, entries, headerEntries);
    current.container = this._createContainer();

    if (size(headerEntries)) {
      current.container.appendChild(this._createEntries(headerEntries, 'djs-popup-header'));
    }

    if (size(entries)) {
      current.container.appendChild(this._createEntries(entries, 'djs-popup-body'));
    }

    var canvas = this._canvas,
        parent = canvas.getContainer();

    this._attachContainer(current.container, parent, position.cursor);

    this._bindAutoClose();
  };
  /**
   * Removes the popup menu and unbinds the event handlers.
   */


  PopupMenu.prototype.close = function () {
    if (!this.isOpen()) {
      return;
    }

    this._emit('close');

    this._unbindAutoClose();

    remove(this._current.container);
    this._current.container = null;
  };
  /**
   * Determine if an open popup menu exist.
   *
   * @return {boolean} true if open
   */


  PopupMenu.prototype.isOpen = function () {
    return !!this._current.container;
  };
  /**
   * Trigger an action associated with an entry.
   *
   * @param {Object} event
   *
   * @return the result of the action callback, if any
   */


  PopupMenu.prototype.trigger = function (event) {
    // silence other actions
    event.preventDefault();
    var element = event.delegateTarget || event.target,
        entryId = attr(element, DATA_REF);

    var entry = this._getEntry(entryId);

    if (entry.action) {
      return entry.action.call(null, event, entry);
    }
  };

  PopupMenu.prototype._getProviders = function (id) {
    var event = this._eventBus.createEvent({
      type: 'popupMenu.getProviders.' + id,
      providers: []
    });

    this._eventBus.fire(event);

    return event.providers;
  };

  PopupMenu.prototype._getEntries = function (element, providers) {
    var entries = {};
    forEach(providers, function (provider) {
      // handle legacy method
      if (!provider.getPopupMenuEntries) {
        forEach(provider.getEntries(element), function (entry) {
          var id = entry.id;

          if (!id) {
            throw new Error('every entry must have the id property set');
          }

          entries[id] = omit(entry, ['id']);
        });
        return;
      }

      var entriesOrUpdater = provider.getPopupMenuEntries(element);

      if (isFunction(entriesOrUpdater)) {
        entries = entriesOrUpdater(entries);
      } else {
        forEach(entriesOrUpdater, function (entry, id) {
          entries[id] = entry;
        });
      }
    });
    return entries;
  };

  PopupMenu.prototype._getHeaderEntries = function (element, providers) {
    var entries = {};
    forEach(providers, function (provider) {
      // handle legacy method
      if (!provider.getPopupMenuHeaderEntries) {
        if (!provider.getHeaderEntries) {
          return;
        }

        forEach(provider.getHeaderEntries(element), function (entry) {
          var id = entry.id;

          if (!id) {
            throw new Error('every entry must have the id property set');
          }

          entries[id] = omit(entry, ['id']);
        });
        return;
      }

      var entriesOrUpdater = provider.getPopupMenuHeaderEntries(element);

      if (isFunction(entriesOrUpdater)) {
        entries = entriesOrUpdater(entries);
      } else {
        forEach(entriesOrUpdater, function (entry, id) {
          entries[id] = entry;
        });
      }
    });
    return entries;
  };
  /**
   * Gets an entry instance (either entry or headerEntry) by id.
   *
   * @param  {string} entryId
   *
   * @return {Object} entry instance
   */


  PopupMenu.prototype._getEntry = function (entryId) {
    var entry = this._current.entries[entryId];

    if (!entry) {
      throw new Error('entry not found');
    }

    return entry;
  };

  PopupMenu.prototype._emit = function (eventName) {
    this._eventBus.fire('popupMenu.' + eventName);
  };
  /**
   * Creates the popup menu container.
   *
   * @return {Object} a DOM container
   */


  PopupMenu.prototype._createContainer = function () {
    var container = domify('<div class="djs-popup">'),
        position = this._current.position,
        className = this._current.className;
    assign(container.style, {
      position: 'absolute',
      left: position.x + 'px',
      top: position.y + 'px',
      visibility: 'hidden'
    });
    classes(container).add(className);
    return container;
  };
  /**
   * Attaches the container to the DOM.
   *
   * @param {Object} container
   * @param {Object} parent
   */


  PopupMenu.prototype._attachContainer = function (container, parent, cursor) {
    var self = this; // Event handler

    delegate.bind(container, '.entry', 'click', function (event) {
      self.trigger(event);
    });

    this._updateScale(container); // Attach to DOM


    parent.appendChild(container);

    if (cursor) {
      this._assureIsInbounds(container, cursor);
    }
  };
  /**
   * Updates popup style.transform with respect to the config and zoom level.
   *
   * @method _updateScale
   *
   * @param {Object} container
   */


  PopupMenu.prototype._updateScale = function (container) {
    var zoom = this._canvas.zoom();

    var scaleConfig = this._config.scale,
        minScale,
        maxScale,
        scale = zoom;

    if (scaleConfig !== true) {
      if (scaleConfig === false) {
        minScale = 1;
        maxScale = 1;
      } else {
        minScale = scaleConfig.min;
        maxScale = scaleConfig.max;
      }

      if (isDefined(minScale) && zoom < minScale) {
        scale = minScale;
      }

      if (isDefined(maxScale) && zoom > maxScale) {
        scale = maxScale;
      }
    }

    setTransform$1(container, 'scale(' + scale + ')');
  };
  /**
   * Make sure that the menu is always fully shown
   *
   * @method function
   *
   * @param  {Object} container
   * @param  {Position} cursor {x, y}
   */


  PopupMenu.prototype._assureIsInbounds = function (container, cursor) {
    var canvas = this._canvas,
        clientRect = canvas._container.getBoundingClientRect();

    var containerX = container.offsetLeft,
        containerY = container.offsetTop,
        containerWidth = container.scrollWidth,
        containerHeight = container.scrollHeight,
        overAxis = {},
        left,
        top;
    var cursorPosition = {
      x: cursor.x - clientRect.left,
      y: cursor.y - clientRect.top
    };

    if (containerX + containerWidth > clientRect.width) {
      overAxis.x = true;
    }

    if (containerY + containerHeight > clientRect.height) {
      overAxis.y = true;
    }

    if (overAxis.x && overAxis.y) {
      left = cursorPosition.x - containerWidth + 'px';
      top = cursorPosition.y - containerHeight + 'px';
    } else if (overAxis.x) {
      left = cursorPosition.x - containerWidth + 'px';
      top = cursorPosition.y + 'px';
    } else if (overAxis.y && cursorPosition.y < containerHeight) {
      left = cursorPosition.x + 'px';
      top = 10 + 'px';
    } else if (overAxis.y) {
      left = cursorPosition.x + 'px';
      top = cursorPosition.y - containerHeight + 'px';
    }

    assign(container.style, {
      left: left,
      top: top
    }, {
      visibility: 'visible',
      'z-index': 1000
    });
  };
  /**
   * Creates a list of entries and returns them as a DOM container.
   *
   * @param {Array<Object>} entries an array of entry objects
   * @param {string} className the class name of the entry container
   *
   * @return {Object} a DOM container
   */


  PopupMenu.prototype._createEntries = function (entries, className) {
    var entriesContainer = domify('<div>'),
        self = this;
    classes(entriesContainer).add(className);
    forEach(entries, function (entry, id) {
      var entryContainer = self._createEntry(entry, id);

      entriesContainer.appendChild(entryContainer);
    });
    return entriesContainer;
  };
  /**
   * Creates a single entry and returns it as a DOM container.
   *
   * @param  {Object} entry
   *
   * @return {Object} a DOM container
   */


  PopupMenu.prototype._createEntry = function (entry, id) {
    var entryContainer = domify('<div>'),
        entryClasses = classes(entryContainer);
    entryClasses.add('entry');

    if (entry.className) {
      entry.className.split(' ').forEach(function (className) {
        entryClasses.add(className);
      });
    }

    attr(entryContainer, DATA_REF, id);

    if (entry.label) {
      var label = domify('<span>');
      label.textContent = entry.label;
      entryContainer.appendChild(label);
    }

    if (entry.imageUrl) {
      entryContainer.appendChild(domify('<img src="' + entry.imageUrl + '" />'));
    }

    if (entry.active === true) {
      entryClasses.add('active');
    }

    if (entry.disabled === true) {
      entryClasses.add('disabled');
    }

    if (entry.title) {
      entryContainer.title = entry.title;
    }

    return entryContainer;
  };
  /**
   * Set up listener to close popup automatically on certain events.
   */


  PopupMenu.prototype._bindAutoClose = function () {
    this._eventBus.once(CLOSE_EVENTS, this.close, this);
  };
  /**
   * Remove the auto-closing listener.
   */


  PopupMenu.prototype._unbindAutoClose = function () {
    this._eventBus.off(CLOSE_EVENTS, this.close, this);
  }; // helpers /////////////////////////////


  function setTransform$1(element, transform) {
    element.style['transform-origin'] = 'top left';
    ['', '-ms-', '-webkit-'].forEach(function (prefix) {
      element.style[prefix + 'transform'] = transform;
    });
  }

  var DiagramPopupMenu = {
    __init__: ['popupMenu'],
    popupMenu: ['type', PopupMenu]
  };

  var round$6 = Math.round;
  /**
   * Service that allow replacing of elements.
   */

  function Replace(modeling) {
    this._modeling = modeling;
  }
  Replace.$inject = ['modeling'];
  /**
   * @param {Element} oldElement - Element to be replaced
   * @param {Object}  newElementData - Containing information about the new element,
   *                                   for example the new bounds and type.
   * @param {Object}  options - Custom options that will be attached to the context. It can be used to inject data
   *                            that is needed in the command chain. For example it could be used in
   *                            eventbus.on('commandStack.shape.replace.postExecute') to change shape attributes after
   *                            shape creation.
   */

  Replace.prototype.replaceElement = function (oldElement, newElementData, options) {
    if (oldElement.waypoints) {
      // TODO(nikku): we do not replace connections, yet
      return null;
    }

    var modeling = this._modeling;
    var width = newElementData.width || oldElement.width,
        height = newElementData.height || oldElement.height,
        x = newElementData.x || oldElement.x,
        y = newElementData.y || oldElement.y,
        centerX = round$6(x + width / 2),
        centerY = round$6(y + height / 2); // modeling API requires center coordinates,
    // account for that when handling shape bounds

    return modeling.replaceShape(oldElement, assign({}, newElementData, {
      x: centerX,
      y: centerY,
      width: width,
      height: height
    }), options);
  };

  var DiagramReplace = {
    __init__: ['replace'],
    replace: ['type', Replace]
  };

  /**
   * This module takes care of replacing DRD elements
   */
  function DrdReplace(drdFactory, replace, selection, modeling) {
    /**
     * Prepares a new business object for the replacement element
     * and triggers the replace operation.
     *
     * @param  {djs.model.Base} element
     * @param  {Object} target
     * @param  {Object} [hints]
     *
     * @return {djs.model.Base} the newly created element
     */
    function replaceElement(element, target, hints) {
      hints = hints || {};
      var type = target.type,
          oldBusinessObject = element.businessObject;
      var newBusinessObject = drdFactory.create(type);
      var newElement = {
        type: type,
        businessObject: newBusinessObject
      };
      newElement.width = element.width;
      newElement.height = element.height;
      newBusinessObject.name = oldBusinessObject.name;

      if (target.table) {
        var table = drdFactory.create('dmn:DecisionTable');
        newBusinessObject.decisionLogic = table;
        table.$parent = newBusinessObject;
        var output = drdFactory.create('dmn:OutputClause');
        output.typeRef = 'string';
        output.$parent = table;
        table.output = [output];
        var input = drdFactory.create('dmn:InputClause');
        input.$parent = table;
        var inputExpression = drdFactory.create('dmn:LiteralExpression', {
          typeRef: 'string'
        });
        input.inputExpression = inputExpression;
        inputExpression.$parent = input;
        table.input = [input];
      }

      if (target.expression) {
        newBusinessObject.decisionLogic = drdFactory.create('dmn:LiteralExpression');
        newBusinessObject.variable = drdFactory.create('dmn:InformationItem');
      }

      return replace.replaceElement(element, newElement, hints);
    }

    this.replaceElement = replaceElement;
  }
  DrdReplace.$inject = ['drdFactory', 'replace', 'selection', 'modeling'];

  var Replace$1 = {
    __depends__: [DiagramReplace, SelectionModule],
    drdReplace: ['type', DrdReplace]
  };

  var replaceOptions = {
    DECISION: [{
      label: 'Empty',
      actionName: 'replace-with-empty-decision',
      className: 'dmn-icon-clear',
      target: {
        type: 'dmn:Decision',
        table: false,
        expression: false
      }
    }, {
      label: 'Decision Table',
      actionName: 'replace-with-decision-table',
      className: 'dmn-icon-decision-table',
      target: {
        type: 'dmn:Decision',
        table: true,
        expression: false
      }
    }, {
      label: 'Literal Expression',
      actionName: 'replace-with-literal-expression',
      className: 'dmn-icon-literal-expression',
      target: {
        type: 'dmn:Decision',
        table: false,
        expression: true
      }
    }]
  };

  /**
   * This module is an element agnostic replace menu provider for the popup menu.
   */

  function ReplaceMenuProvider(popupMenu, modeling, moddle, drdReplace, rules, translate) {
    this._popupMenu = popupMenu;
    this._modeling = modeling;
    this._moddle = moddle;
    this._drdReplace = drdReplace;
    this._rules = rules;
    this._translate = translate;
    this.register();
  }
  ReplaceMenuProvider.$inject = ['popupMenu', 'modeling', 'moddle', 'drdReplace', 'rules', 'translate'];
  /**
   * Register replace menu provider in the popup menu
   */

  ReplaceMenuProvider.prototype.register = function () {
    this._popupMenu.registerProvider('dmn-replace', this);
  };
  /**
   * Get all entries from replaceOptions for the given element.
   *
   * @param {djs.model.Base} element
   *
   * @return {Array<Object>} a list of menu entry items
   */


  ReplaceMenuProvider.prototype.getEntries = function (element) {
    var businessObject = element.businessObject;
    var rules = this._rules;

    if (!rules.allowed('shape.replace', {
      element: element
    })) {
      return [];
    }

    if (is(businessObject, 'dmn:Decision')) {
      var options = filter(replaceOptions.DECISION, function (option) {
        var notEmpty = option.actionName === 'replace-with-empty-decision' && businessObject.decisionLogic;
        var notTable = option.actionName === 'replace-with-decision-table' && !is(businessObject.decisionLogic, 'dmn:DecisionTable');
        var notExp = option.actionName === 'replace-with-literal-expression' && !is(businessObject.decisionLogic, 'dmn:LiteralExpression');
        return notEmpty || notTable || notExp;
      });
      return this._createEntries(element, options);
    }

    return [];
  };
  /**
   * Creates an array of menu entry objects for a given element.
   *
   * @param  {djs.model.Base} element
   * @param  {Object} replaceOptions
   *
   * @return {Array<Object>} a list of menu items
   */


  ReplaceMenuProvider.prototype._createEntries = function (element, replaceOptions) {
    var menuEntries = [];
    var self = this;
    forEach(replaceOptions, function (definition) {
      var entry = self._createMenuEntry(definition, element);

      menuEntries.push(entry);
    });
    return menuEntries;
  };
  /**
   * Creates and returns a single menu entry item.
   *
   * @param  {Object} definition a single replace options definition object
   * @param  {djs.model.Base} element
   * @param  {Function} [action] an action callback function which gets called when
   *                             the menu entry is being triggered.
   *
   * @return {Object} menu entry item
   */


  ReplaceMenuProvider.prototype._createMenuEntry = function (definition, element, action) {
    var replaceElement = this._drdReplace.replaceElement;
    var translate = this._translate;

    var replaceAction = function replaceAction() {
      return replaceElement(element, definition.target);
    };

    action = action || replaceAction;
    var menuEntry = {
      label: translate(definition.label),
      className: definition.className,
      id: definition.actionName,
      action: action
    };
    return menuEntry;
  };

  ReplaceMenuProvider.prototype.getHeaderEntries = function (element) {
    return [];
  };

  var PopupMenu$1 = {
    __depends__: [TranslateModule, DiagramPopupMenu, Replace$1],
    __init__: ['replaceMenuProvider'],
    replaceMenuProvider: ['type', ReplaceMenuProvider]
  };

  /**
  * A provider for DMN elements context pad
  */

  function ContextPadProvider(eventBus, contextPad, modeling, elementFactory, connect, create, rules, popupMenu, canvas, translate, config, injector) {
    config = config || {};
    contextPad.registerProvider(this);
    this._contextPad = contextPad;
    this._modeling = modeling;
    this._elementFactory = elementFactory;
    this._connect = connect;
    this._create = create;
    this._rules = rules;
    this._popupMenu = popupMenu;
    this._canvas = canvas;
    this._translate = translate;

    if (config.autoPlace !== false) {
      this._autoPlace = injector.get('autoPlace', false);
    }

    eventBus.on('create.end', 250, function (event) {
      var shape = event.context.shape;

      if (!hasPrimaryModifier(event)) {
        return;
      }

      var entries = contextPad.getEntries(shape);

      if (entries.replace) {
        entries.replace.action.click(event, shape);
      }
    });
  }
  ContextPadProvider.$inject = ['eventBus', 'contextPad', 'modeling', 'elementFactory', 'connect', 'create', 'rules', 'popupMenu', 'canvas', 'translate', 'config.contextPad', 'injector'];

  ContextPadProvider.prototype.getContextPadEntries = function (element) {
    var modeling = this._modeling,
        elementFactory = this._elementFactory,
        connect = this._connect,
        create = this._create,
        popupMenu = this._popupMenu,
        canvas = this._canvas,
        contextPad = this._contextPad,
        rules = this._rules,
        translate = this._translate,
        autoPlace = this._autoPlace;
    var actions = {};

    if (element.type === 'label') {
      return actions;
    }

    var businessObject = element.businessObject;

    function startConnect(event, element, autoActivate) {
      connect.start(event, element, autoActivate);
    }

    function removeElement(e) {
      modeling.removeElements([element]);
    }

    function getReplaceMenuPosition(element) {
      var Y_OFFSET = 5;
      var diagramContainer = canvas.getContainer(),
          pad = contextPad.getPad(element).html;
      var diagramRect = diagramContainer.getBoundingClientRect(),
          padRect = pad.getBoundingClientRect();
      var top = padRect.top - diagramRect.top;
      var left = padRect.left - diagramRect.left;
      var pos = {
        x: left,
        y: top + padRect.height + Y_OFFSET
      };
      return pos;
    }
    /**
    * Create an append action
    *
    * @param {string} type
    * @param {string} className
    * @param {string} [title]
    * @param {Object} [options]
    *
    * @return {Object} descriptor
    */


    function appendAction(type, className, title, options) {
      if (typeof title !== 'string') {
        options = title;
        title = translate('Append {type}', {
          type: type.replace(/^dmn:/, '')
        });
      }

      function appendStart(event, element) {
        var shape = elementFactory.createShape(assign({
          type: type
        }, options));
        create.start(event, shape, {
          source: element,
          hints: {
            connectionTarget: element
          }
        });
      }

      var append = autoPlace ? function (event, element) {
        var shape = elementFactory.createShape(assign({
          type: type
        }, options));
        autoPlace.append(element, shape, {
          connectionTarget: element
        });
      } : appendStart;
      return {
        group: 'model',
        className: className,
        title: title,
        action: {
          dragstart: appendStart,
          click: append
        }
      };
    }

    if (is(businessObject, 'dmn:Decision')) {
      assign(actions, {
        'append.decision': appendAction('dmn:Decision', 'dmn-icon-decision')
      });
    }

    if (isAny(businessObject, ['dmn:BusinessKnowledgeModel', 'dmn:Decision', 'dmn:KnowledgeSource'])) {
      assign(actions, {
        'append.knowledge-source': appendAction('dmn:KnowledgeSource', 'dmn-icon-knowledge-source')
      });
    }

    if (isAny(businessObject, ['dmn:BusinessKnowledgeModel', 'dmn:Decision'])) {
      assign(actions, {
        'append.business-knowledge-model': appendAction('dmn:BusinessKnowledgeModel', 'dmn-icon-business-knowledge')
      });
    }

    if (isAny(businessObject, ['dmn:Decision', 'dmn:KnowledgeSource'])) {
      assign(actions, {
        'append.input-data': appendAction('dmn:InputData', 'dmn-icon-input-data')
      });
    }

    if (is(businessObject, 'dmn:DRGElement')) {
      assign(actions, {
        'append.text-annotation': appendAction('dmn:TextAnnotation', 'dmn-icon-text-annotation'),
        'connect': {
          group: 'connect',
          className: 'dmn-icon-connection-multi',
          title: translate('Connect using Information/Knowledge' + '/Authority Requirement or Association'),
          action: {
            click: startConnect,
            dragstart: startConnect
          }
        }
      });
    }

    if (!popupMenu.isEmpty(element, 'dmn-replace')) {
      // Replace menu entry
      assign(actions, {
        'replace': {
          group: 'edit',
          className: 'dmn-icon-screw-wrench',
          title: translate('Change type'),
          action: {
            click: function click(event, element) {
              var position = assign(getReplaceMenuPosition(element), {
                cursor: {
                  x: event.x,
                  y: event.y
                }
              });
              popupMenu.open(element, 'dmn-replace', position);
            }
          }
        }
      });
    } // delete element entry, only show if allowed by rules


    var deleteAllowed = rules.allowed('elements.delete', {
      elements: [element]
    });

    if (isArray(deleteAllowed)) {
      // was the element returned as a deletion candidate?
      deleteAllowed = deleteAllowed[0] === element;
    }

    if (deleteAllowed) {
      assign(actions, {
        'delete': {
          group: 'edit',
          className: 'dmn-icon-trash',
          title: translate('Remove'),
          action: {
            click: removeElement
          }
        }
      });
    }

    return actions;
  };

  var ContextPadModule = {
    __depends__: [TranslateModule, DiagramContextPad, SelectionModule, DiagramConnect, DiagramCreate, PopupMenu$1],
    __init__: ['contextPadProvider'],
    contextPadProvider: ['type', ContextPadProvider]
  };

  var MARKER_CONNECTION_PREVIEW = 'djs-connection-preview';
  /**
   * Draws connection preview. Optionally, this can use layouter and connection docking to draw
   * better looking previews.
   *
   * @param {didi.Injector} injector
   * @param {Canvas} canvas
   * @param {GraphicsFactory} graphicsFactory
   * @param {ElementFactory} elementFactory
   */

  function ConnectionPreview(injector, canvas, graphicsFactory, elementFactory) {
    this._canvas = canvas;
    this._graphicsFactory = graphicsFactory;
    this._elementFactory = elementFactory; // optional components

    this._connectionDocking = injector.get('connectionDocking', false);
    this._layouter = injector.get('layouter', false);
  }
  ConnectionPreview.$inject = ['injector', 'canvas', 'graphicsFactory', 'elementFactory'];
  /**
   * Draw connection preview.
   *
   * Provide at least one of <source, connectionStart> and <target, connectionEnd> to create a preview.
   * In the clean up stage, call `connectionPreview#cleanUp` with the context to remove preview.
   *
   * @param {Object} context
   * @param {Object|boolean} canConnect
   * @param {Object} hints
   * @param {djs.model.shape} [hints.source] source element
   * @param {djs.model.shape} [hints.target] target element
   * @param {Point} [hints.connectionStart] connection preview start
   * @param {Point} [hints.connectionEnd] connection preview end
   * @param {Array<Point>} [hints.waypoints] provided waypoints for preview
   * @param {boolean} [hints.noLayout] true if preview should not be laid out
   * @param {boolean} [hints.noCropping] true if preview should not be cropped
   * @param {boolean} [hints.noNoop] true if simple connection should not be drawn
   */

  ConnectionPreview.prototype.drawPreview = function (context, canConnect, hints) {
    hints = hints || {};
    var connectionPreviewGfx = context.connectionPreviewGfx,
        getConnection = context.getConnection,
        source = hints.source,
        target = hints.target,
        waypoints = hints.waypoints,
        connectionStart = hints.connectionStart,
        connectionEnd = hints.connectionEnd,
        noLayout = hints.noLayout,
        noCropping = hints.noCropping,
        noNoop = hints.noNoop,
        connection;
    var self = this;

    if (!connectionPreviewGfx) {
      connectionPreviewGfx = context.connectionPreviewGfx = this.createConnectionPreviewGfx();
    }

    clear$1(connectionPreviewGfx);

    if (!getConnection) {
      getConnection = context.getConnection = cacheReturnValues(function (canConnect, source, target) {
        return self.getConnection(canConnect, source, target);
      });
    }

    if (canConnect) {
      connection = getConnection(canConnect, source, target);
    }

    if (!connection) {
      !noNoop && this.drawNoopPreview(connectionPreviewGfx, hints);
      return;
    }

    connection.waypoints = waypoints || []; // optional layout

    if (this._layouter && !noLayout) {
      connection.waypoints = this._layouter.layoutConnection(connection, {
        source: source,
        target: target,
        connectionStart: connectionStart,
        connectionEnd: connectionEnd,
        waypoints: hints.waypoints || connection.waypoints
      });
    } // fallback if no waypoints were provided nor created with layouter


    if (!connection.waypoints || !connection.waypoints.length) {
      connection.waypoints = [source ? getMid(source) : connectionStart, target ? getMid(target) : connectionEnd];
    } // optional cropping


    if (this._connectionDocking && (source || target) && !noCropping) {
      connection.waypoints = this._connectionDocking.getCroppedWaypoints(connection, source, target);
    }

    this._graphicsFactory.drawConnection(connectionPreviewGfx, connection);
  };
  /**
   * Draw simple connection between source and target or provided points.
   *
   * @param {SVGElement} connectionPreviewGfx container for the connection
   * @param {Object} hints
   * @param {djs.model.shape} [hints.source] source element
   * @param {djs.model.shape} [hints.target] target element
   * @param {Point} [hints.connectionStart] required if source is not provided
   * @param {Point} [hints.connectionEnd] required if target is not provided
   */


  ConnectionPreview.prototype.drawNoopPreview = function (connectionPreviewGfx, hints) {
    var source = hints.source,
        target = hints.target,
        start = hints.connectionStart || getMid(source),
        end = hints.connectionEnd || getMid(target);
    var waypoints = this.cropWaypoints(start, end, source, target);
    var connection = this.createNoopConnection(waypoints[0], waypoints[1]);
    append(connectionPreviewGfx, connection);
  };
  /**
   * Return cropped waypoints.
   *
   * @param {Point} start
   * @param {Point} end
   * @param {djs.model.shape} source
   * @param {djs.model.shape} target
   *
   * @returns {Array}
   */


  ConnectionPreview.prototype.cropWaypoints = function (start, end, source, target) {
    var graphicsFactory = this._graphicsFactory,
        sourcePath = source && graphicsFactory.getShapePath(source),
        targetPath = target && graphicsFactory.getShapePath(target),
        connectionPath = graphicsFactory.getConnectionPath({
      waypoints: [start, end]
    });
    start = source && getElementLineIntersection(sourcePath, connectionPath, true) || start;
    end = target && getElementLineIntersection(targetPath, connectionPath, false) || end;
    return [start, end];
  };
  /**
   * Remove connection preview container if it exists.
   *
   * @param {Object} [context]
   * @param {SVGElement} [context.connectionPreviewGfx] preview container
   */


  ConnectionPreview.prototype.cleanUp = function (context) {
    if (context && context.connectionPreviewGfx) {
      remove$1(context.connectionPreviewGfx);
    }
  };
  /**
   * Get connection that connects source and target.
   *
   * @param {Object|boolean} canConnect
   *
   * @returns {djs.model.connection}
   */


  ConnectionPreview.prototype.getConnection = function (canConnect) {
    var attrs = ensureConnectionAttrs(canConnect);
    return this._elementFactory.createConnection(attrs);
  };
  /**
   * Add and return preview graphics.
   *
   * @returns {SVGElement}
   */


  ConnectionPreview.prototype.createConnectionPreviewGfx = function () {
    var gfx = create('g');
    attr$1(gfx, {
      pointerEvents: 'none'
    });
    classes$1(gfx).add(MARKER_CONNECTION_PREVIEW);
    append(this._canvas.getDefaultLayer(), gfx);
    return gfx;
  };
  /**
   * Create and return simple connection.
   *
   * @param {Point} start
   * @param {Point} end
   *
   * @returns {SVGElement}
   */


  ConnectionPreview.prototype.createNoopConnection = function (start, end) {
    var connection = create('polyline');
    attr$1(connection, {
      'stroke': '#333',
      'strokeDasharray': [1],
      'strokeWidth': 2,
      'pointer-events': 'none'
    });
    attr$1(connection, {
      'points': [start.x, start.y, end.x, end.y]
    });
    return connection;
  }; // helpers //////////

  /**
   * Returns function that returns cached return values referenced by stringified first argument.
   *
   * @param {Function} fn
   *
   * @return {Function}
   */


  function cacheReturnValues(fn) {
    var returnValues = {};
    /**
     * Return cached return value referenced by stringified first argument.
     *
     * @returns {*}
     */

    return function (firstArgument) {
      var key = JSON.stringify(firstArgument);
      var returnValue = returnValues[key];

      if (!returnValue) {
        returnValue = returnValues[key] = fn.apply(null, arguments);
      }

      return returnValue;
    };
  }
  /**
   * Ensure connection attributes is object.
   *
   * @param {Object|boolean} canConnect
   *
   * @returns {Object}
   */


  function ensureConnectionAttrs(canConnect) {
    if (isObject(canConnect)) {
      return canConnect;
    } else {
      return {};
    }
  }

  var ConnectPreviewModule = {
    __init__: ['connectionPreview'],
    connectionPreview: ['type', ConnectionPreview]
  };

  var DEBOUNCE_DELAY = 300;
  function DefinitionIdEdit(eventBus, modeling, canvas) {
    this._eventBus = eventBus;
    this._modeling = modeling;
    this._canvas = canvas;
    eventBus.on('definitionIdView.create', function (event) {
      var container = event.html,
          nameElement = query('.dmn-definitions-name', container),
          idElement = query('.dmn-definitions-id', container);

      this._setup(nameElement, 'name');

      this._setup(idElement, 'id');
    }, this);
  }
  DefinitionIdEdit.$inject = ['eventBus', 'modeling', 'canvas'];

  DefinitionIdEdit.prototype.update = function (type, newValue) {
    var newProperties = {};
    newProperties[type] = newValue;

    this._modeling.updateProperties(this._canvas.getRootElement(), newProperties);
  };

  DefinitionIdEdit.prototype._setup = function (node, type) {
    var self = this;
    node.setAttribute('contenteditable', true);
    node.addEventListener('input', debounce(function (evt) {
      var value = evt.target.value || evt.target.textContent;
      self.update(type, value.trim());
    }, DEBOUNCE_DELAY));
    node.addEventListener('keydown', function (evt) {
      if (evt.keyCode === 13) {
        node.blur();
        window.getSelection().removeAllRanges();
      }
    });
  };

  var DefinitionPropertiesModule = {
    __init__: ['definitionPropertiesEdit', 'definitionPropertiesPaletteAdapter'],
    definitionPropertiesEdit: ['type', DefinitionIdEdit],
    definitionPropertiesPaletteAdapter: ['type', PaletteAdapter]
  };

  var AXIS_DIMENSIONS = {
    horizontal: ['x', 'width'],
    vertical: ['y', 'height']
  };
  var THRESHOLD$1 = 5;
  /**
   * Groups and filters elements and then trigger even distribution.
   */

  function DistributeElements(modeling) {
    this._modeling = modeling;
    this._filters = []; // register filter for filtering big elements

    this.registerFilter(function (elements, axis, dimension) {
      var elementsSize = 0,
          numOfShapes = 0,
          avgDimension;
      forEach(elements, function (element) {
        if (element.waypoints || element.labelTarget) {
          return;
        }

        elementsSize += element[dimension];
        numOfShapes += 1;
      });
      avgDimension = Math.round(elementsSize / numOfShapes);
      return filter(elements, function (element) {
        return element[dimension] < avgDimension + 50;
      });
    });
  }
  DistributeElements.$inject = ['modeling'];
  /**
   * Registers filter functions that allow external parties to filter
   * out certain elements.
   *
   * @param  {Function} filterFn
   */

  DistributeElements.prototype.registerFilter = function (filterFn) {
    if (typeof filterFn !== 'function') {
      throw new Error('the filter has to be a function');
    }

    this._filters.push(filterFn);
  };
  /**
   * Distributes the elements with a given orientation
   *
   * @param  {Array} elements    [description]
   * @param  {string} orientation [description]
   */


  DistributeElements.prototype.trigger = function (elements, orientation) {
    var modeling = this._modeling;
    var groups, distributableElements;

    if (elements.length < 3) {
      return;
    }

    this._setOrientation(orientation);

    distributableElements = this._filterElements(elements);
    groups = this._createGroups(distributableElements); // nothing to distribute

    if (groups.length <= 2) {
      return;
    }

    modeling.distributeElements(groups, this._axis, this._dimension);
    return groups;
  };
  /**
   * Filters the elements with provided filters by external parties
   *
   * @param  {Array[Elements]} elements
   *
   * @return {Array[Elements]}
   */


  DistributeElements.prototype._filterElements = function (elements) {
    var filters = this._filters,
        axis = this._axis,
        dimension = this._dimension,
        distributableElements = [].concat(elements);

    if (!filters.length) {
      return elements;
    }

    forEach(filters, function (filterFn) {
      distributableElements = filterFn(distributableElements, axis, dimension);
    });
    return distributableElements;
  };
  /**
   * Create range (min, max) groups. Also tries to group elements
   * together that share the same range.
   *
   * @example
   * 	var distributableElements = [
   * 		{
   * 			range: {
   * 				min: 100,
   * 				max: 200
   * 			},
   * 			elements: [ { id: 'shape1', .. }]
   * 		}
   * 	]
   *
   * @param  {Array} elements
   *
   * @return {Array[Objects]}
   */


  DistributeElements.prototype._createGroups = function (elements) {
    var rangeGroups = [],
        self = this,
        axis = this._axis,
        dimension = this._dimension;

    if (!axis) {
      throw new Error('must have a defined "axis" and "dimension"');
    } // sort by 'left->right' or 'top->bottom'


    var sortedElements = sortBy(elements, axis);
    forEach(sortedElements, function (element, idx) {
      var elementRange = self._findRange(element, axis, dimension),
          range;

      var previous = rangeGroups[rangeGroups.length - 1];

      if (previous && self._hasIntersection(previous.range, elementRange)) {
        rangeGroups[rangeGroups.length - 1].elements.push(element);
      } else {
        range = {
          range: elementRange,
          elements: [element]
        };
        rangeGroups.push(range);
      }
    });
    return rangeGroups;
  };
  /**
   * Maps a direction to the according axis and dimension
   *
   * @param  {string} direction 'horizontal' or 'vertical'
   */


  DistributeElements.prototype._setOrientation = function (direction) {
    var orientation = AXIS_DIMENSIONS[direction];
    this._axis = orientation[0];
    this._dimension = orientation[1];
  };
  /**
   * Checks if the two ranges intercept each other
   *
   * @param  {Object} rangeA {min, max}
   * @param  {Object} rangeB {min, max}
   *
   * @return {boolean}
   */


  DistributeElements.prototype._hasIntersection = function (rangeA, rangeB) {
    return Math.max(rangeA.min, rangeA.max) >= Math.min(rangeB.min, rangeB.max) && Math.min(rangeA.min, rangeA.max) <= Math.max(rangeB.min, rangeB.max);
  };
  /**
   * Returns the min and max values for an element
   *
   * @param  {[type]} element   [description]
   * @param  {[type]} axis      [description]
   * @param  {[type]} dimension [description]
   *
   * @return {[type]}           [description]
   */


  DistributeElements.prototype._findRange = function (element) {
    var axis = element[this._axis],
        dimension = element[this._dimension];
    return {
      min: axis + THRESHOLD$1,
      max: axis + dimension - THRESHOLD$1
    };
  };

  var DistributeElementsModule = {
    __init__: ['distributeElements'],
    distributeElements: ['type', DistributeElements]
  };

  /**
   * Registers element exclude filters for elements that
   * currently do not support distribution.
   */

  function DrdDistributeElements(distributeElements) {
    distributeElements.registerFilter(function (elements) {
      return filter(elements, function (element) {
        var cannotDistribute = isAny(element, ['dmn:AuthorityRequirement', 'dmn:InformationRequirement', 'dmn:KnowledgeRequirement', 'dmn:Association', 'dmn:TextAnnotation']);
        return !(element.labelTarget || cannotDistribute);
      });
    });
  }
  DrdDistributeElements.$inject = ['distributeElements'];

  var DistributeElementsModule$1 = {
    __depends__: [DistributeElementsModule],
    __init__: ['drdDistributeElements'],
    drdDistributeElements: ['type', DrdDistributeElements]
  };

  var NOT_REGISTERED_ERROR = 'is not a registered action',
      IS_REGISTERED_ERROR = 'is already registered';
  /**
   * An interface that provides access to modeling actions by decoupling
   * the one who requests the action to be triggered and the trigger itself.
   *
   * It's possible to add new actions by registering them with ´registerAction´
   * and likewise unregister existing ones with ´unregisterAction´.
   *
   *
   * ## Life-Cycle and configuration
   *
   * The editor actions will wait for diagram initialization before
   * registering default actions _and_ firing an `editorActions.init` event.
   *
   * Interested parties may listen to the `editorActions.init` event with
   * low priority to check, which actions got registered. Other components
   * may use the event to register their own actions via `registerAction`.
   *
   * @param {EventBus} eventBus
   * @param {Injector} injector
   */

  function EditorActions(eventBus, injector) {
    // initialize actions
    this._actions = {};
    var self = this;
    eventBus.on('diagram.init', function () {
      // all diagram modules got loaded; check which ones
      // are available and register the respective default actions
      self._registerDefaultActions(injector); // ask interested parties to register available editor
      // actions on diagram initialization


      eventBus.fire('editorActions.init', {
        editorActions: self
      });
    });
  }
  EditorActions.$inject = ['eventBus', 'injector'];
  /**
   * Register default actions.
   *
   * @param {Injector} injector
   */

  EditorActions.prototype._registerDefaultActions = function (injector) {
    // (1) retrieve optional components to integrate with
    var commandStack = injector.get('commandStack', false);
    var modeling = injector.get('modeling', false);
    var selection = injector.get('selection', false);
    var zoomScroll = injector.get('zoomScroll', false);
    var copyPaste = injector.get('copyPaste', false);
    var canvas = injector.get('canvas', false);
    var rules = injector.get('rules', false);
    var keyboardMove = injector.get('keyboardMove', false);
    var keyboardMoveSelection = injector.get('keyboardMoveSelection', false); // (2) check components and register actions

    if (commandStack) {
      this.register('undo', function () {
        commandStack.undo();
      });
      this.register('redo', function () {
        commandStack.redo();
      });
    }

    if (copyPaste && selection) {
      this.register('copy', function () {
        var selectedElements = selection.get();
        copyPaste.copy(selectedElements);
      });
    }

    if (copyPaste) {
      this.register('paste', function () {
        copyPaste.paste();
      });
    }

    if (zoomScroll) {
      this.register('stepZoom', function (opts) {
        zoomScroll.stepZoom(opts.value);
      });
    }

    if (canvas) {
      this.register('zoom', function (opts) {
        canvas.zoom(opts.value);
      });
    }

    if (modeling && selection && rules) {
      this.register('removeSelection', function () {
        var selectedElements = selection.get();

        if (!selectedElements.length) {
          return;
        }

        var allowed = rules.allowed('elements.delete', {
          elements: selectedElements
        }),
            removableElements;

        if (allowed === false) {
          return;
        } else if (isArray(allowed)) {
          removableElements = allowed;
        } else {
          removableElements = selectedElements;
        }

        if (removableElements.length) {
          modeling.removeElements(removableElements.slice());
        }
      });
    }

    if (keyboardMove) {
      this.register('moveCanvas', function (opts) {
        keyboardMove.moveCanvas(opts);
      });
    }

    if (keyboardMoveSelection) {
      this.register('moveSelection', function (opts) {
        keyboardMoveSelection.moveSelection(opts.direction, opts.accelerated);
      });
    }
  };
  /**
   * Triggers a registered action
   *
   * @param  {string} action
   * @param  {Object} opts
   *
   * @return {Unknown} Returns what the registered listener returns
   */


  EditorActions.prototype.trigger = function (action, opts) {
    if (!this._actions[action]) {
      throw error$2(action, NOT_REGISTERED_ERROR);
    }

    return this._actions[action](opts);
  };
  /**
   * Registers a collections of actions.
   * The key of the object will be the name of the action.
   *
   * @example
   * ´´´
   * var actions = {
   *   spaceTool: function() {
   *     spaceTool.activateSelection();
   *   },
   *   lassoTool: function() {
   *     lassoTool.activateSelection();
   *   }
   * ];
   *
   * editorActions.register(actions);
   *
   * editorActions.isRegistered('spaceTool'); // true
   * ´´´
   *
   * @param  {Object} actions
   */


  EditorActions.prototype.register = function (actions, listener) {
    var self = this;

    if (typeof actions === 'string') {
      return this._registerAction(actions, listener);
    }

    forEach(actions, function (listener, action) {
      self._registerAction(action, listener);
    });
  };
  /**
   * Registers a listener to an action key
   *
   * @param  {string} action
   * @param  {Function} listener
   */


  EditorActions.prototype._registerAction = function (action, listener) {
    if (this.isRegistered(action)) {
      throw error$2(action, IS_REGISTERED_ERROR);
    }

    this._actions[action] = listener;
  };
  /**
   * Unregister an existing action
   *
   * @param {string} action
   */


  EditorActions.prototype.unregister = function (action) {
    if (!this.isRegistered(action)) {
      throw error$2(action, NOT_REGISTERED_ERROR);
    }

    this._actions[action] = undefined;
  };
  /**
   * Returns the number of actions that are currently registered
   *
   * @return {number}
   */


  EditorActions.prototype.getActions = function () {
    return Object.keys(this._actions);
  };
  /**
   * Checks wether the given action is registered
   *
   * @param {string} action
   *
   * @return {boolean}
   */


  EditorActions.prototype.isRegistered = function (action) {
    return !!this._actions[action];
  };

  function error$2(action, message) {
    return new Error(action + ' ' + message);
  }

  var EditorActionsModule = {
    __init__: ['editorActions'],
    editorActions: ['type', EditorActions]
  };

  function DrdEditorActions(injector) {
    injector.invoke(EditorActions, this);
  }
  inherits_browser(DrdEditorActions, EditorActions);
  DrdEditorActions.$inject = ['injector'];
  /**
   * Register default actions.
   *
   * @param {Injector} injector
   */

  DrdEditorActions.prototype._registerDefaultActions = function (injector) {
    // (0) invoke super method
    EditorActions.prototype._registerDefaultActions.call(this, injector); // (1) retrieve optional components to integrate with


    var canvas = injector.get('canvas', false);
    var elementRegistry = injector.get('elementRegistry', false);
    var selection = injector.get('selection', false);
    var lassoTool = injector.get('lassoTool', false);
    var directEditing = injector.get('directEditing', false);
    var distributeElements = injector.get('distributeElements', false);
    var alignElements = injector.get('alignElements', false); // (2) check components and register actions

    if (canvas && elementRegistry && selection) {
      this._registerAction('selectElements', function () {
        // select all elements except for the invisible
        // root element
        var rootElement = canvas.getRootElement();
        var elements = elementRegistry.filter(function (element) {
          return element !== rootElement;
        });
        selection.select(elements);
        return elements;
      });
    }

    if (selection && distributeElements) {
      this._registerAction('distributeElements', function (opts) {
        var currentSelection = selection.get(),
            type = opts.type;

        if (currentSelection.length > 2) {
          distributeElements.trigger(currentSelection, type);
        }
      });
    }

    if (selection && alignElements) {
      this._registerAction('alignElements', function (opts) {
        var currentSelection = selection.get(),
            type = opts.type;

        if (currentSelection.length > 1) {
          alignElements.trigger(currentSelection, type);
        }
      });
    }

    if (lassoTool) {
      this._registerAction('lassoTool', function () {
        lassoTool.toggle();
      });
    }

    if (selection && directEditing) {
      this._registerAction('directEditing', function () {
        var currentSelection = selection.get();

        if (currentSelection.length) {
          directEditing.activate(currentSelection[0]);
        }
      });
    }
  };

  var EditorActionsModule$1 = {
    __depends__: [EditorActionsModule],
    editorActions: ['type', DrdEditorActions]
  };

  /**
   * Does the definitions element contain graphical information?
   *
   * @param  {ModdleElement} definitions
   *
   * @return {boolean} true, if the definitions contains graphical information
   */
  function containsDi(definitions) {
    return definitions.dmnDI && definitions.dmnDI.diagrams && definitions.dmnDI.diagrams[0];
  }

  /**
   * Generates missing DI on import.
   *
   * @param {DrdFactory} drdFactory
   * @param {ElementFactory} elementFactory
   * @param {EventBus} eventBus
   */

  function DiGenerator(drdFactory, elementFactory, eventBus, drdUpdater) {
    function createDi(definitions) {
      // retrieve or create dmnDI
      var dmnDI = definitions.dmnDI;

      if (!dmnDI) {
        dmnDI = drdFactory.create('dmndi:DMNDI');
        definitions.set('dmnDI', dmnDI);
      }

      var diagram = drdFactory.create('dmndi:DMNDiagram');
      dmnDI.set('diagrams', [diagram]);
      var index = 0;
      forEach(definitions.get('drgElement'), function (drgElement) {
        // generate DI for decisions only
        if (!is(drgElement, 'dmn:Decision')) {
          return;
        }

        var dimensions = elementFactory._getDefaultSize(drgElement);

        var di = drdFactory.createDiShape(drgElement, {
          x: 150 + index * 30,
          y: 150 + index * 30,
          width: dimensions.width,
          height: dimensions.height
        });
        drdUpdater.updateDiParent(di, diagram);
        index++;
      });
    }

    eventBus.on('import.start', function (_ref) {
      var definitions = _ref.definitions;

      if (!containsDi(definitions)) {
        createDi(definitions);
      }
    });
  }
  DiGenerator.$inject = ['drdFactory', 'elementFactory', 'eventBus', 'drdUpdater'];

  var GenerateDiModule = {
    __init__: ['diGenerator'],
    diGenerator: ['type', DiGenerator]
  };

  /**
   * Returns true if event was triggered with any modifier
   * @param {KeyboardEvent} event
   */

  function hasModifier(event) {
    return event.ctrlKey || event.metaKey || event.shiftKey || event.altKey;
  }
  /**
   * @param {KeyboardEvent} event
   */

  function isCmd(event) {
    // ensure we don't react to AltGr
    // (mapped to CTRL + ALT)
    if (event.altKey) {
      return false;
    }

    return event.ctrlKey || event.metaKey;
  }
  /**
   * Checks if key pressed is one of provided keys.
   *
   * @param {string|Array<string>} keys
   * @param {KeyboardEvent} event
   */

  function isKey(keys, event) {
    keys = isArray(keys) ? keys : [keys];
    return keys.indexOf(event.key) !== -1 || keys.indexOf(event.keyCode) !== -1;
  }
  /**
   * @param {KeyboardEvent} event
   */

  function isShift(event) {
    return event.shiftKey;
  }

  var SPACING = 10;
  function quantize(value, quantum, fn) {
    if (!fn) {
      fn = 'round';
    }

    return Math[fn](value / quantum) * quantum;
  }

  var LOWER_PRIORITY = 1200;
  var LOW_PRIORITY$6 = 800;
  /**
   * Basic grid snapping that covers connecting, creating, moving, resizing shapes, moving bendpoints
   * and connection segments.
   */

  function GridSnapping(elementRegistry, eventBus, config) {
    var active = !config || config.active !== false;
    this._eventBus = eventBus;
    var self = this;
    eventBus.on('diagram.init', LOW_PRIORITY$6, function () {
      self.setActive(active);
    });
    eventBus.on(['create.move', 'create.end', 'bendpoint.move.move', 'bendpoint.move.end', 'connect.move', 'connect.end', 'connectionSegment.move.move', 'connectionSegment.move.end', 'resize.move', 'resize.end', 'shape.move.move', 'shape.move.end'], LOWER_PRIORITY, function (event) {
      var originalEvent = event.originalEvent;

      if (!self.active || originalEvent && isCmd(originalEvent)) {
        return;
      }

      var context = event.context,
          gridSnappingContext = context.gridSnappingContext;

      if (!gridSnappingContext) {
        gridSnappingContext = context.gridSnappingContext = {};
      }

      ['x', 'y'].forEach(function (axis) {
        var options = {}; // allow snapping with offset

        var snapOffset = getSnapOffset(event, axis, elementRegistry);

        if (snapOffset) {
          options.offset = snapOffset;
        } // allow snapping with min and max


        var snapConstraints = getSnapConstraints(event, axis);

        if (snapConstraints) {
          assign(options, snapConstraints);
        }

        if (!isSnapped(event, axis)) {
          self.snapEvent(event, axis, options);
        }
      });
    });
  }
  /**
   * Snap an events x or y with optional min, max and offset.
   *
   * @param {Object} event
   * @param {string} axis
   * @param {number} [options.min]
   * @param {number} [options.max]
   * @param {number} [options.offset]
   */

  GridSnapping.prototype.snapEvent = function (event, axis, options) {
    var snappedValue = this.snapValue(event[axis], options);
    setSnapped(event, axis, snappedValue);
  };
  /**
   * Expose grid spacing for third parties (i.e. extensions).
   *
   * @return {number} spacing of grid dots
   */


  GridSnapping.prototype.getGridSpacing = function () {
    return SPACING;
  };
  /**
   * Snap value with optional min, max and offset.
   *
   * @param {number} value
   * @param {Object} options
   * @param {number} [options.min]
   * @param {number} [options.max]
   * @param {number} [options.offset]
   */


  GridSnapping.prototype.snapValue = function (value, options) {
    var offset = 0;

    if (options && options.offset) {
      offset = options.offset;
    }

    value += offset;
    value = quantize(value, SPACING);
    var min, max;

    if (options && options.min) {
      min = options.min;

      if (isNumber(min)) {
        min = quantize(min + offset, SPACING, 'ceil');
        value = Math.max(value, min);
      }
    }

    if (options && options.max) {
      max = options.max;

      if (isNumber(max)) {
        max = quantize(max + offset, SPACING, 'floor');
        value = Math.min(value, max);
      }
    }

    value -= offset;
    return value;
  };

  GridSnapping.prototype.isActive = function () {
    return this.active;
  };

  GridSnapping.prototype.setActive = function (active) {
    this.active = active;

    this._eventBus.fire('gridSnapping.toggle', {
      active: active
    });
  };

  GridSnapping.prototype.toggleActive = function () {
    this.setActive(!this.active);
  };

  GridSnapping.$inject = ['elementRegistry', 'eventBus', 'config.gridSnapping']; // helpers //////////

  /**
   * Get minimum and maximum snap constraints.
   * Constraints are cached.
   *
   * @param {Object} event
   * @param {Object} event.context
   * @param {string} axis
   *
   * @returns {boolean|Object}
   */

  function getSnapConstraints(event, axis) {
    var context = event.context,
        createConstraints = context.createConstraints,
        resizeConstraints = context.resizeConstraints || {},
        gridSnappingContext = context.gridSnappingContext,
        snapConstraints = gridSnappingContext.snapConstraints; // cache snap constraints

    if (snapConstraints && snapConstraints[axis]) {
      return snapConstraints[axis];
    }

    if (!snapConstraints) {
      snapConstraints = gridSnappingContext.snapConstraints = {};
    }

    if (!snapConstraints[axis]) {
      snapConstraints[axis] = {};
    }

    var direction = context.direction; // create

    if (createConstraints) {
      if (isHorizontal(axis)) {
        snapConstraints.x.min = createConstraints.left;
        snapConstraints.x.max = createConstraints.right;
      } else {
        snapConstraints.y.min = createConstraints.top;
        snapConstraints.y.max = createConstraints.bottom;
      }
    } // resize


    var minResizeConstraints = resizeConstraints.min,
        maxResizeConstraints = resizeConstraints.max;

    if (minResizeConstraints) {
      if (isHorizontal(axis)) {
        if (isWest(direction)) {
          snapConstraints.x.max = minResizeConstraints.left;
        } else {
          snapConstraints.x.min = minResizeConstraints.right;
        }
      } else {
        if (isNorth(direction)) {
          snapConstraints.y.max = minResizeConstraints.top;
        } else {
          snapConstraints.y.min = minResizeConstraints.bottom;
        }
      }
    }

    if (maxResizeConstraints) {
      if (isHorizontal(axis)) {
        if (isWest(direction)) {
          snapConstraints.x.min = maxResizeConstraints.left;
        } else {
          snapConstraints.x.max = maxResizeConstraints.right;
        }
      } else {
        if (isNorth(direction)) {
          snapConstraints.y.min = maxResizeConstraints.top;
        } else {
          snapConstraints.y.max = maxResizeConstraints.bottom;
        }
      }
    }

    return snapConstraints[axis];
  }
  /**
   * Get snap offset.
   * Offset is cached.
   *
   * @param {Object} event
   * @param {string} axis
   * @param {ElementRegistry} elementRegistry
   *
   * @returns {number}
   */


  function getSnapOffset(event, axis, elementRegistry) {
    var context = event.context,
        shape = event.shape,
        gridSnappingContext = context.gridSnappingContext,
        snapLocation = gridSnappingContext.snapLocation,
        snapOffset = gridSnappingContext.snapOffset; // cache snap offset

    if (snapOffset && isNumber(snapOffset[axis])) {
      return snapOffset[axis];
    }

    if (!snapOffset) {
      snapOffset = gridSnappingContext.snapOffset = {};
    }

    if (!isNumber(snapOffset[axis])) {
      snapOffset[axis] = 0;
    }

    if (!shape) {
      return snapOffset[axis];
    }

    if (!elementRegistry.get(shape.id)) {
      if (isHorizontal(axis)) {
        snapOffset[axis] += shape[axis] + shape.width / 2;
      } else {
        snapOffset[axis] += shape[axis] + shape.height / 2;
      }
    }

    if (!snapLocation) {
      return snapOffset[axis];
    }

    if (axis === 'x') {
      if (/left/.test(snapLocation)) {
        snapOffset[axis] -= shape.width / 2;
      } else if (/right/.test(snapLocation)) {
        snapOffset[axis] += shape.width / 2;
      }
    } else {
      if (/top/.test(snapLocation)) {
        snapOffset[axis] -= shape.height / 2;
      } else if (/bottom/.test(snapLocation)) {
        snapOffset[axis] += shape.height / 2;
      }
    }

    return snapOffset[axis];
  }

  function isHorizontal(axis) {
    return axis === 'x';
  }

  function isNorth(direction) {
    return direction.indexOf('n') !== -1;
  }

  function isWest(direction) {
    return direction.indexOf('w') !== -1;
  }

  var DEFAULT_PRIORITY$3 = 1000;
  /**
   * A utility that can be used to plug-in into the command execution for
   * extension and/or validation.
   *
   * @param {EventBus} eventBus
   *
   * @example
   *
   * import inherits from 'inherits';
   *
   * import CommandInterceptor from 'diagram-js/lib/command/CommandInterceptor';
   *
   * function CommandLogger(eventBus) {
   *   CommandInterceptor.call(this, eventBus);
   *
   *   this.preExecute(function(event) {
   *     console.log('command pre-execute', event);
   *   });
   * }
   *
   * inherits(CommandLogger, CommandInterceptor);
   *
   */

  function CommandInterceptor(eventBus) {
    this._eventBus = eventBus;
  }
  CommandInterceptor.$inject = ['eventBus'];

  function unwrapEvent(fn, that) {
    return function (event) {
      return fn.call(that || null, event.context, event.command, event);
    };
  }
  /**
   * Register an interceptor for a command execution
   *
   * @param {string|Array<string>} [events] list of commands to register on
   * @param {string} [hook] command hook, i.e. preExecute, executed to listen on
   * @param {number} [priority] the priority on which to hook into the execution
   * @param {Function} handlerFn interceptor to be invoked with (event)
   * @param {boolean} unwrap if true, unwrap the event and pass (context, command, event) to the
   *                          listener instead
   * @param {Object} [that] Pass context (`this`) to the handler function
   */


  CommandInterceptor.prototype.on = function (events, hook, priority, handlerFn, unwrap, that) {
    if (isFunction(hook) || isNumber(hook)) {
      that = unwrap;
      unwrap = handlerFn;
      handlerFn = priority;
      priority = hook;
      hook = null;
    }

    if (isFunction(priority)) {
      that = unwrap;
      unwrap = handlerFn;
      handlerFn = priority;
      priority = DEFAULT_PRIORITY$3;
    }

    if (isObject(unwrap)) {
      that = unwrap;
      unwrap = false;
    }

    if (!isFunction(handlerFn)) {
      throw new Error('handlerFn must be a function');
    }

    if (!isArray(events)) {
      events = [events];
    }

    var eventBus = this._eventBus;
    forEach(events, function (event) {
      // concat commandStack(.event)?(.hook)?
      var fullEvent = ['commandStack', event, hook].filter(function (e) {
        return e;
      }).join('.');
      eventBus.on(fullEvent, priority, unwrap ? unwrapEvent(handlerFn, that) : handlerFn, that);
    });
  };

  var hooks = ['canExecute', 'preExecute', 'preExecuted', 'execute', 'executed', 'postExecute', 'postExecuted', 'revert', 'reverted'];
  /*
   * Install hook shortcuts
   *
   * This will generate the CommandInterceptor#(preExecute|...|reverted) methods
   * which will in term forward to CommandInterceptor#on.
   */

  forEach(hooks, function (hook) {
    /**
     * {canExecute|preExecute|preExecuted|execute|executed|postExecute|postExecuted|revert|reverted}
     *
     * A named hook for plugging into the command execution
     *
     * @param {string|Array<string>} [events] list of commands to register on
     * @param {number} [priority] the priority on which to hook into the execution
     * @param {Function} handlerFn interceptor to be invoked with (event)
     * @param {boolean} [unwrap=false] if true, unwrap the event and pass (context, command, event) to the
     *                          listener instead
     * @param {Object} [that] Pass context (`this`) to the handler function
     */
    CommandInterceptor.prototype[hook] = function (events, priority, handlerFn, unwrap, that) {
      if (isFunction(events) || isNumber(events)) {
        that = unwrap;
        unwrap = handlerFn;
        handlerFn = priority;
        priority = events;
        events = null;
      }

      this.on(events, hook, priority, handlerFn, unwrap, that);
    };
  });

  /**
   * Integrates resizing with grid snapping.
   */

  function ResizeBehavior(eventBus, gridSnapping) {
    CommandInterceptor.call(this, eventBus);
    this._gridSnapping = gridSnapping;
    var self = this;
    this.preExecute('shape.resize', function (event) {
      var context = event.context,
          hints = context.hints || {},
          autoResize = hints.autoResize;

      if (!autoResize) {
        return;
      }

      var shape = context.shape,
          newBounds = context.newBounds;

      if (isString(autoResize)) {
        context.newBounds = self.snapComplex(newBounds, autoResize);
      } else {
        context.newBounds = self.snapSimple(shape, newBounds);
      }
    });
  }
  ResizeBehavior.$inject = ['eventBus', 'gridSnapping', 'modeling'];
  inherits_browser$1(ResizeBehavior, CommandInterceptor);
  /**
   * Snap width and height in relation to center.
   *
   * @param {djs.model.shape} shape
   * @param {Bounds} newBounds
   *
   * @returns {Bounds} Snapped bounds.
   */

  ResizeBehavior.prototype.snapSimple = function (shape, newBounds) {
    var gridSnapping = this._gridSnapping;
    newBounds.width = gridSnapping.snapValue(newBounds.width, {
      min: newBounds.width
    });
    newBounds.height = gridSnapping.snapValue(newBounds.height, {
      min: newBounds.height
    });
    newBounds.x = shape.x + shape.width / 2 - newBounds.width / 2;
    newBounds.y = shape.y + shape.height / 2 - newBounds.height / 2;
    return newBounds;
  };
  /**
   * Snap x, y, width and height according to given directions.
   *
   * @param {Bounds} newBounds
   * @param {string} directions - Directions as {n|w|s|e}.
   *
   * @returns {Bounds} Snapped bounds.
   */


  ResizeBehavior.prototype.snapComplex = function (newBounds, directions) {
    if (/w|e/.test(directions)) {
      newBounds = this.snapHorizontally(newBounds, directions);
    }

    if (/n|s/.test(directions)) {
      newBounds = this.snapVertically(newBounds, directions);
    }

    return newBounds;
  };
  /**
   * Snap in one or both directions horizontally.
   *
   * @param {Bounds} newBounds
   * @param {string} directions - Directions as {n|w|s|e}.
   *
   * @returns {Bounds} Snapped bounds.
   */


  ResizeBehavior.prototype.snapHorizontally = function (newBounds, directions) {
    var gridSnapping = this._gridSnapping,
        west = /w/.test(directions),
        east = /e/.test(directions);
    var snappedNewBounds = {};
    snappedNewBounds.width = gridSnapping.snapValue(newBounds.width, {
      min: newBounds.width
    });

    if (east) {
      // handle <we>
      if (west) {
        snappedNewBounds.x = gridSnapping.snapValue(newBounds.x, {
          max: newBounds.x
        });
        snappedNewBounds.width += gridSnapping.snapValue(newBounds.x - snappedNewBounds.x, {
          min: newBounds.x - snappedNewBounds.x
        });
      } // handle <e>
      else {
          newBounds.x = newBounds.x + newBounds.width - snappedNewBounds.width;
        }
    } // assign snapped x and width


    assign(newBounds, snappedNewBounds);
    return newBounds;
  };
  /**
   * Snap in one or both directions vertically.
   *
   * @param {Bounds} newBounds
   * @param {string} directions - Directions as {n|w|s|e}.
   *
   * @returns {Bounds} Snapped bounds.
   */


  ResizeBehavior.prototype.snapVertically = function (newBounds, directions) {
    var gridSnapping = this._gridSnapping,
        north = /n/.test(directions),
        south = /s/.test(directions);
    var snappedNewBounds = {};
    snappedNewBounds.height = gridSnapping.snapValue(newBounds.height, {
      min: newBounds.height
    });

    if (north) {
      // handle <ns>
      if (south) {
        snappedNewBounds.y = gridSnapping.snapValue(newBounds.y, {
          max: newBounds.y
        });
        snappedNewBounds.height += gridSnapping.snapValue(newBounds.y - snappedNewBounds.y, {
          min: newBounds.y - snappedNewBounds.y
        });
      } // handle <n>
      else {
          newBounds.y = newBounds.y + newBounds.height - snappedNewBounds.height;
        }
    } // assign snapped y and height


    assign(newBounds, snappedNewBounds);
    return newBounds;
  };

  var HIGH_PRIORITY$4 = 2000;
  /**
   * Integrates space tool with grid snapping.
   */

  function SpaceToolBehavior(eventBus, gridSnapping) {
    eventBus.on(['spaceTool.move', 'spaceTool.end'], HIGH_PRIORITY$4, function (event) {
      var context = event.context;

      if (!context.initialized) {
        return;
      }

      var axis = context.axis;
      var snapped;

      if (axis === 'x') {
        // snap delta x to multiple of 10
        snapped = gridSnapping.snapValue(event.dx);
        event.x = event.x + snapped - event.dx;
        event.dx = snapped;
      } else {
        // snap delta y to multiple of 10
        snapped = gridSnapping.snapValue(event.dy);
        event.y = event.y + snapped - event.dy;
        event.dy = snapped;
      }
    });
  }
  SpaceToolBehavior.$inject = ['eventBus', 'gridSnapping'];

  var GridSnappingBehaviorModule = {
    __init__: ['gridSnappingResizeBehavior', 'gridSnappingSpaceToolBehavior'],
    gridSnappingResizeBehavior: ['type', ResizeBehavior],
    gridSnappingSpaceToolBehavior: ['type', SpaceToolBehavior]
  };

  var GridSnappingModule = {
    __depends__: [GridSnappingBehaviorModule],
    __init__: ['gridSnapping'],
    gridSnapping: ['type', GridSnapping]
  };

  var KEYDOWN_EVENT = 'keyboard.keydown',
      KEYUP_EVENT = 'keyboard.keyup';
  var DEFAULT_PRIORITY$4 = 1000;
  /**
   * A keyboard abstraction that may be activated and
   * deactivated by users at will, consuming key events
   * and triggering diagram actions.
   *
   * For keys pressed down, keyboard fires `keyboard.keydown` event.
   * The event context contains one field which is `KeyboardEvent` event.
   *
   * The implementation fires the following key events that allow
   * other components to hook into key handling:
   *
   *  - keyboard.bind
   *  - keyboard.unbind
   *  - keyboard.init
   *  - keyboard.destroy
   *
   * All events contain one field which is node.
   *
   * A default binding for the keyboard may be specified via the
   * `keyboard.bindTo` configuration option.
   *
   * @param {Config} config
   * @param {EventBus} eventBus
   */

  function Keyboard(config, eventBus) {
    var self = this;
    this._config = config || {};
    this._eventBus = eventBus;
    this._keydownHandler = this._keydownHandler.bind(this);
    this._keyupHandler = this._keyupHandler.bind(this); // properly clean dom registrations

    eventBus.on('diagram.destroy', function () {
      self._fire('destroy');

      self.unbind();
    });
    eventBus.on('diagram.init', function () {
      self._fire('init');
    });
    eventBus.on('attach', function () {
      if (config && config.bindTo) {
        self.bind(config.bindTo);
      }
    });
    eventBus.on('detach', function () {
      self.unbind();
    });
  }
  Keyboard.$inject = ['config.keyboard', 'eventBus'];

  Keyboard.prototype._keydownHandler = function (event) {
    this._keyHandler(event, KEYDOWN_EVENT);
  };

  Keyboard.prototype._keyupHandler = function (event) {
    this._keyHandler(event, KEYUP_EVENT);
  };

  Keyboard.prototype._keyHandler = function (event, type) {
    var target = event.target,
        eventBusResult;

    if (isInput$1(target)) {
      return;
    }

    var context = {
      keyEvent: event
    };
    eventBusResult = this._eventBus.fire(type || KEYDOWN_EVENT, context);

    if (eventBusResult) {
      event.preventDefault();
    }
  };

  Keyboard.prototype.bind = function (node) {
    // make sure that the keyboard is only bound once to the DOM
    this.unbind();
    this._node = node; // bind key events

    componentEvent.bind(node, 'keydown', this._keydownHandler, true);
    componentEvent.bind(node, 'keyup', this._keyupHandler, true);

    this._fire('bind');
  };

  Keyboard.prototype.getBinding = function () {
    return this._node;
  };

  Keyboard.prototype.unbind = function () {
    var node = this._node;

    if (node) {
      this._fire('unbind'); // unbind key events


      componentEvent.unbind(node, 'keydown', this._keydownHandler, true);
      componentEvent.unbind(node, 'keyup', this._keyupHandler, true);
    }

    this._node = null;
  };

  Keyboard.prototype._fire = function (event) {
    this._eventBus.fire('keyboard.' + event, {
      node: this._node
    });
  };
  /**
   * Add a listener function that is notified with `KeyboardEvent` whenever
   * the keyboard is bound and the user presses a key. If no priority is
   * provided, the default value of 1000 is used.
   *
   * @param {number} [priority]
   * @param {Function} listener
   * @param {string} type
   */


  Keyboard.prototype.addListener = function (priority, listener, type) {
    if (isFunction(priority)) {
      type = listener;
      listener = priority;
      priority = DEFAULT_PRIORITY$4;
    }

    this._eventBus.on(type || KEYDOWN_EVENT, priority, listener);
  };

  Keyboard.prototype.removeListener = function (listener, type) {
    this._eventBus.off(type || KEYDOWN_EVENT, listener);
  };

  Keyboard.prototype.hasModifier = hasModifier;
  Keyboard.prototype.isCmd = isCmd;
  Keyboard.prototype.isShift = isShift;
  Keyboard.prototype.isKey = isKey; // helpers ///////

  function isInput$1(target) {
    return target && (matchesSelector(target, 'input, textarea') || target.contentEditable === 'true');
  }

  var LOW_PRIORITY$7 = 500;
  var KEYCODE_C = 67;
  var KEYCODE_V = 86;
  var KEYCODE_Y = 89;
  var KEYCODE_Z = 90;
  var KEYS_COPY = ['c', 'C', KEYCODE_C];
  var KEYS_PASTE = ['v', 'V', KEYCODE_V];
  var KEYS_REDO = ['y', 'Y', KEYCODE_Y];
  var KEYS_UNDO = ['z', 'Z', KEYCODE_Z];
  /**
   * Adds default keyboard bindings.
   *
   * This does not pull in any features will bind only actions that
   * have previously been registered against the editorActions component.
   *
   * @param {EventBus} eventBus
   * @param {Keyboard} keyboard
   */

  function KeyboardBindings(eventBus, keyboard) {
    var self = this;
    eventBus.on('editorActions.init', LOW_PRIORITY$7, function (event) {
      var editorActions = event.editorActions;
      self.registerBindings(keyboard, editorActions);
    });
  }
  KeyboardBindings.$inject = ['eventBus', 'keyboard'];
  /**
   * Register available keyboard bindings.
   *
   * @param {Keyboard} keyboard
   * @param {EditorActions} editorActions
   */

  KeyboardBindings.prototype.registerBindings = function (keyboard, editorActions) {
    /**
     * Add keyboard binding if respective editor action
     * is registered.
     *
     * @param {string} action name
     * @param {Function} fn that implements the key binding
     */
    function addListener(action, fn) {
      if (editorActions.isRegistered(action)) {
        keyboard.addListener(fn);
      }
    } // undo
    // (CTRL|CMD) + Z


    addListener('undo', function (context) {
      var event = context.keyEvent;

      if (isCmd(event) && !isShift(event) && isKey(KEYS_UNDO, event)) {
        editorActions.trigger('undo');
        return true;
      }
    }); // redo
    // CTRL + Y
    // CMD + SHIFT + Z

    addListener('redo', function (context) {
      var event = context.keyEvent;

      if (isCmd(event) && (isKey(KEYS_REDO, event) || isKey(KEYS_UNDO, event) && isShift(event))) {
        editorActions.trigger('redo');
        return true;
      }
    }); // copy
    // CTRL/CMD + C

    addListener('copy', function (context) {
      var event = context.keyEvent;

      if (isCmd(event) && isKey(KEYS_COPY, event)) {
        editorActions.trigger('copy');
        return true;
      }
    }); // paste
    // CTRL/CMD + V

    addListener('paste', function (context) {
      var event = context.keyEvent;

      if (isCmd(event) && isKey(KEYS_PASTE, event)) {
        editorActions.trigger('paste');
        return true;
      }
    }); // zoom in one step
    // CTRL/CMD + +

    addListener('stepZoom', function (context) {
      var event = context.keyEvent; // quirk: it has to be triggered by `=` as well to work on international keyboard layout
      // cf: https://github.com/bpmn-io/bpmn-js/issues/1362#issuecomment-722989754

      if (isKey(['+', 'Add', '='], event) && isCmd(event)) {
        editorActions.trigger('stepZoom', {
          value: 1
        });
        return true;
      }
    }); // zoom out one step
    // CTRL + -

    addListener('stepZoom', function (context) {
      var event = context.keyEvent;

      if (isKey(['-', 'Subtract'], event) && isCmd(event)) {
        editorActions.trigger('stepZoom', {
          value: -1
        });
        return true;
      }
    }); // zoom to the default level
    // CTRL + 0

    addListener('zoom', function (context) {
      var event = context.keyEvent;

      if (isKey('0', event) && isCmd(event)) {
        editorActions.trigger('zoom', {
          value: 1
        });
        return true;
      }
    }); // delete selected element
    // DEL

    addListener('removeSelection', function (context) {
      var event = context.keyEvent;

      if (isKey(['Backspace', 'Delete', 'Del'], event)) {
        editorActions.trigger('removeSelection');
        return true;
      }
    });
  };

  var KeyboardModule = {
    __init__: ['keyboard', 'keyboardBindings'],
    keyboard: ['type', Keyboard],
    keyboardBindings: ['type', KeyboardBindings]
  };

  /**
   * DRD specific key bindings.
   *
   * @param {Keyboard} keyboard
   * @param {EditorActions} editorActions
   */

  function DrdKeyboardBindings(injector) {
    injector.invoke(KeyboardBindings, this);
  }
  inherits_browser(DrdKeyboardBindings, KeyboardBindings);
  DrdKeyboardBindings.$inject = ['injector'];
  /**
   * Register available keyboard bindings.
   *
   * @param {Keyboard} keyboard
   * @param {EditorActions} editorActions
   */

  DrdKeyboardBindings.prototype.registerBindings = function (keyboard, editorActions) {
    // inherit default bindings
    KeyboardBindings.prototype.registerBindings.call(this, keyboard, editorActions);
    /**
     * Add keyboard binding if respective editor action
     * is registered.
     *
     * @param {string} action name
     * @param {Function} fn that implements the key binding
     */

    function addListener(action, fn) {
      if (editorActions.isRegistered(action)) {
        keyboard.addListener(fn);
      }
    } // select all elements
    // CTRL + A


    addListener('selectElements', function (context) {
      var event = context.keyEvent;

      if (keyboard.isKey(['a', 'A'], event) && keyboard.isCmd(event)) {
        editorActions.trigger('selectElements');
        return true;
      }
    }); // activate lasso tool
    // L

    addListener('lassoTool', function (context) {
      var event = context.keyEvent;

      if (keyboard.hasModifier(event)) {
        return;
      }

      if (keyboard.isKey(['l', 'L'], event)) {
        editorActions.trigger('lassoTool');
        return true;
      }
    }); // activate direct editing
    // E

    addListener('directEditing', function (context) {
      var event = context.keyEvent;

      if (keyboard.hasModifier(event)) {
        return;
      }

      if (keyboard.isKey(['e', 'E'], event)) {
        editorActions.trigger('directEditing');
        return true;
      }
    });
  };

  var KeyboardModule$1 = {
    __depends__: [KeyboardModule],
    __init__: ['keyboardBindings'],
    keyboardBindings: ['type', DrdKeyboardBindings]
  };

  var DEFAULT_CONFIG = {
    moveSpeed: 50,
    moveSpeedAccelerated: 200
  };
  /**
   * A feature that allows users to move the canvas using the keyboard.
   *
   * @param {Object} config
   * @param {number} [config.moveSpeed=50]
   * @param {number} [config.moveSpeedAccelerated=200]
   * @param {Keyboard} keyboard
   * @param {Canvas} canvas
   */

  function KeyboardMove(config, keyboard, canvas) {
    var self = this;
    this._config = assign({}, DEFAULT_CONFIG, config || {});
    keyboard.addListener(arrowsListener);

    function arrowsListener(context) {
      var event = context.keyEvent,
          config = self._config;

      if (!keyboard.isCmd(event)) {
        return;
      }

      if (keyboard.isKey(['ArrowLeft', 'Left', 'ArrowUp', 'Up', 'ArrowDown', 'Down', 'ArrowRight', 'Right'], event)) {
        var speed = keyboard.isShift(event) ? config.moveSpeedAccelerated : config.moveSpeed;
        var direction;

        switch (event.key) {
          case 'ArrowLeft':
          case 'Left':
            direction = 'left';
            break;

          case 'ArrowUp':
          case 'Up':
            direction = 'up';
            break;

          case 'ArrowRight':
          case 'Right':
            direction = 'right';
            break;

          case 'ArrowDown':
          case 'Down':
            direction = 'down';
            break;
        }

        self.moveCanvas({
          speed: speed,
          direction: direction
        });
        return true;
      }
    }

    this.moveCanvas = function (opts) {
      var dx = 0,
          dy = 0,
          speed = opts.speed;
      var actualSpeed = speed / Math.min(Math.sqrt(canvas.viewbox().scale), 1);

      switch (opts.direction) {
        case 'left':
          // Left
          dx = actualSpeed;
          break;

        case 'up':
          // Up
          dy = actualSpeed;
          break;

        case 'right':
          // Right
          dx = -actualSpeed;
          break;

        case 'down':
          // Down
          dy = -actualSpeed;
          break;
      }

      canvas.scroll({
        dx: dx,
        dy: dy
      });
    };
  }
  KeyboardMove.$inject = ['config.keyboardMove', 'keyboard', 'canvas'];

  var KeyboardMoveModule = {
    __depends__: [KeyboardModule],
    __init__: ['keyboardMove'],
    keyboardMove: ['type', KeyboardMove]
  };

  var DEFAULT_CONFIG$1 = {
    moveSpeed: 1,
    moveSpeedAccelerated: 10
  };
  var HIGHER_PRIORITY = 1500;
  var LEFT = 'left';
  var UP = 'up';
  var RIGHT = 'right';
  var DOWN = 'down';
  var KEY_TO_DIRECTION = {
    ArrowLeft: LEFT,
    Left: LEFT,
    ArrowUp: UP,
    Up: UP,
    ArrowRight: RIGHT,
    Right: RIGHT,
    ArrowDown: DOWN,
    Down: DOWN
  };
  var DIRECTIONS_DELTA = {
    left: function left(speed) {
      return {
        x: -speed,
        y: 0
      };
    },
    up: function up(speed) {
      return {
        x: 0,
        y: -speed
      };
    },
    right: function right(speed) {
      return {
        x: speed,
        y: 0
      };
    },
    down: function down(speed) {
      return {
        x: 0,
        y: speed
      };
    }
  };
  /**
   * Enables to move selection with keyboard arrows.
   * Use with Shift for modified speed (default=1, with Shift=10).
   * Pressed Cmd/Ctrl turns the feature off.
   *
   * @param {Object} config
   * @param {number} [config.moveSpeed=1]
   * @param {number} [config.moveSpeedAccelerated=10]
   * @param {Keyboard} keyboard
   * @param {Modeling} modeling
   * @param {Selection} selection
   */

  function KeyboardMoveSelection(config, keyboard, modeling, rules, selection) {
    var self = this;
    this._config = assign({}, DEFAULT_CONFIG$1, config || {});
    keyboard.addListener(HIGHER_PRIORITY, function (event) {
      var keyEvent = event.keyEvent;
      var direction = KEY_TO_DIRECTION[keyEvent.key];

      if (!direction) {
        return;
      }

      if (keyboard.isCmd(keyEvent)) {
        return;
      }

      var accelerated = keyboard.isShift(keyEvent);
      self.moveSelection(direction, accelerated);
      return true;
    });
    /**
     * Move selected elements in the given direction,
     * optionally specifying accelerated movement.
     *
     * @param {string} direction
     * @param {boolean} [accelerated=false]
     */

    this.moveSelection = function (direction, accelerated) {
      var selectedElements = selection.get();

      if (!selectedElements.length) {
        return;
      }

      var speed = this._config[accelerated ? 'moveSpeedAccelerated' : 'moveSpeed'];
      var delta = DIRECTIONS_DELTA[direction](speed);
      var canMove = rules.allowed('elements.move', {
        shapes: selectedElements
      });

      if (canMove) {
        modeling.moveElements(selectedElements, delta);
      }
    };
  }
  KeyboardMoveSelection.$inject = ['config.keyboardMoveSelection', 'keyboard', 'modeling', 'rules', 'selection'];

  var KeyboardMoveSelectionModule = {
    __depends__: [KeyboardModule, SelectionModule],
    __init__: ['keyboardMoveSelection'],
    keyboardMoveSelection: ['type', KeyboardMoveSelection]
  };

  /**
   * A service that offers un- and redoable execution of commands.
   *
   * The command stack is responsible for executing modeling actions
   * in a un- and redoable manner. To do this it delegates the actual
   * command execution to {@link CommandHandler}s.
   *
   * Command handlers provide {@link CommandHandler#execute(ctx)} and
   * {@link CommandHandler#revert(ctx)} methods to un- and redo a command
   * identified by a command context.
   *
   *
   * ## Life-Cycle events
   *
   * In the process the command stack fires a number of life-cycle events
   * that other components to participate in the command execution.
   *
   *    * preExecute
   *    * preExecuted
   *    * execute
   *    * executed
   *    * postExecute
   *    * postExecuted
   *    * revert
   *    * reverted
   *
   * A special event is used for validating, whether a command can be
   * performed prior to its execution.
   *
   *    * canExecute
   *
   * Each of the events is fired as `commandStack.{eventName}` and
   * `commandStack.{commandName}.{eventName}`, respectively. This gives
   * components fine grained control on where to hook into.
   *
   * The event object fired transports `command`, the name of the
   * command and `context`, the command context.
   *
   *
   * ## Creating Command Handlers
   *
   * Command handlers should provide the {@link CommandHandler#execute(ctx)}
   * and {@link CommandHandler#revert(ctx)} methods to implement
   * redoing and undoing of a command.
   *
   * A command handler _must_ ensure undo is performed properly in order
   * not to break the undo chain. It must also return the shapes that
   * got changed during the `execute` and `revert` operations.
   *
   * Command handlers may execute other modeling operations (and thus
   * commands) in their `preExecute` and `postExecute` phases. The command
   * stack will properly group all commands together into a logical unit
   * that may be re- and undone atomically.
   *
   * Command handlers must not execute other commands from within their
   * core implementation (`execute`, `revert`).
   *
   *
   * ## Change Tracking
   *
   * During the execution of the CommandStack it will keep track of all
   * elements that have been touched during the command's execution.
   *
   * At the end of the CommandStack execution it will notify interested
   * components via an 'elements.changed' event with all the dirty
   * elements.
   *
   * The event can be picked up by components that are interested in the fact
   * that elements have been changed. One use case for this is updating
   * their graphical representation after moving / resizing or deletion.
   *
   * @see CommandHandler
   *
   * @param {EventBus} eventBus
   * @param {Injector} injector
   */

  function CommandStack(eventBus, injector) {
    /**
     * A map of all registered command handlers.
     *
     * @type {Object}
     */
    this._handlerMap = {};
    /**
     * A stack containing all re/undoable actions on the diagram
     *
     * @type {Array<Object>}
     */

    this._stack = [];
    /**
     * The current index on the stack
     *
     * @type {number}
     */

    this._stackIdx = -1;
    /**
     * Current active commandStack execution
     *
     * @type {Object}
     */

    this._currentExecution = {
      actions: [],
      dirty: []
    };
    this._injector = injector;
    this._eventBus = eventBus;
    this._uid = 1;
    eventBus.on(['diagram.destroy', 'diagram.clear'], function () {
      this.clear(false);
    }, this);
  }
  CommandStack.$inject = ['eventBus', 'injector'];
  /**
   * Execute a command
   *
   * @param {string} command the command to execute
   * @param {Object} context the environment to execute the command in
   */

  CommandStack.prototype.execute = function (command, context) {
    if (!command) {
      throw new Error('command required');
    }

    var action = {
      command: command,
      context: context
    };

    this._pushAction(action);

    this._internalExecute(action);

    this._popAction(action);
  };
  /**
   * Ask whether a given command can be executed.
   *
   * Implementors may hook into the mechanism on two ways:
   *
   *   * in event listeners:
   *
   *     Users may prevent the execution via an event listener.
   *     It must prevent the default action for `commandStack.(<command>.)canExecute` events.
   *
   *   * in command handlers:
   *
   *     If the method {@link CommandHandler#canExecute} is implemented in a handler
   *     it will be called to figure out whether the execution is allowed.
   *
   * @param  {string} command the command to execute
   * @param  {Object} context the environment to execute the command in
   *
   * @return {boolean} true if the command can be executed
   */


  CommandStack.prototype.canExecute = function (command, context) {
    var action = {
      command: command,
      context: context
    };

    var handler = this._getHandler(command);

    var result = this._fire(command, 'canExecute', action); // handler#canExecute will only be called if no listener
    // decided on a result already


    if (result === undefined) {
      if (!handler) {
        return false;
      }

      if (handler.canExecute) {
        result = handler.canExecute(context);
      }
    }

    return result;
  };
  /**
   * Clear the command stack, erasing all undo / redo history
   */


  CommandStack.prototype.clear = function (emit) {
    this._stack.length = 0;
    this._stackIdx = -1;

    if (emit !== false) {
      this._fire('changed');
    }
  };
  /**
   * Undo last command(s)
   */


  CommandStack.prototype.undo = function () {
    var action = this._getUndoAction(),
        next;

    if (action) {
      this._pushAction(action);

      while (action) {
        this._internalUndo(action);

        next = this._getUndoAction();

        if (!next || next.id !== action.id) {
          break;
        }

        action = next;
      }

      this._popAction();
    }
  };
  /**
   * Redo last command(s)
   */


  CommandStack.prototype.redo = function () {
    var action = this._getRedoAction(),
        next;

    if (action) {
      this._pushAction(action);

      while (action) {
        this._internalExecute(action, true);

        next = this._getRedoAction();

        if (!next || next.id !== action.id) {
          break;
        }

        action = next;
      }

      this._popAction();
    }
  };
  /**
   * Register a handler instance with the command stack
   *
   * @param {string} command
   * @param {CommandHandler} handler
   */


  CommandStack.prototype.register = function (command, handler) {
    this._setHandler(command, handler);
  };
  /**
   * Register a handler type with the command stack
   * by instantiating it and injecting its dependencies.
   *
   * @param {string} command
   * @param {Function} a constructor for a {@link CommandHandler}
   */


  CommandStack.prototype.registerHandler = function (command, handlerCls) {
    if (!command || !handlerCls) {
      throw new Error('command and handlerCls must be defined');
    }

    var handler = this._injector.instantiate(handlerCls);

    this.register(command, handler);
  };

  CommandStack.prototype.canUndo = function () {
    return !!this._getUndoAction();
  };

  CommandStack.prototype.canRedo = function () {
    return !!this._getRedoAction();
  }; // stack access  //////////////////////


  CommandStack.prototype._getRedoAction = function () {
    return this._stack[this._stackIdx + 1];
  };

  CommandStack.prototype._getUndoAction = function () {
    return this._stack[this._stackIdx];
  }; // internal functionality //////////////////////


  CommandStack.prototype._internalUndo = function (action) {
    var self = this;
    var command = action.command,
        context = action.context;

    var handler = this._getHandler(command); // guard against illegal nested command stack invocations


    this._atomicDo(function () {
      self._fire(command, 'revert', action);

      if (handler.revert) {
        self._markDirty(handler.revert(context));
      }

      self._revertedAction(action);

      self._fire(command, 'reverted', action);
    });
  };

  CommandStack.prototype._fire = function (command, qualifier, event) {
    if (arguments.length < 3) {
      event = qualifier;
      qualifier = null;
    }

    var names = qualifier ? [command + '.' + qualifier, qualifier] : [command],
        i,
        name,
        result;
    event = this._eventBus.createEvent(event);

    for (i = 0; name = names[i]; i++) {
      result = this._eventBus.fire('commandStack.' + name, event);

      if (event.cancelBubble) {
        break;
      }
    }

    return result;
  };

  CommandStack.prototype._createId = function () {
    return this._uid++;
  };

  CommandStack.prototype._atomicDo = function (fn) {
    var execution = this._currentExecution;
    execution.atomic = true;

    try {
      fn();
    } finally {
      execution.atomic = false;
    }
  };

  CommandStack.prototype._internalExecute = function (action, redo) {
    var self = this;
    var command = action.command,
        context = action.context;

    var handler = this._getHandler(command);

    if (!handler) {
      throw new Error('no command handler registered for <' + command + '>');
    }

    this._pushAction(action);

    if (!redo) {
      this._fire(command, 'preExecute', action);

      if (handler.preExecute) {
        handler.preExecute(context);
      }

      this._fire(command, 'preExecuted', action);
    } // guard against illegal nested command stack invocations


    this._atomicDo(function () {
      self._fire(command, 'execute', action);

      if (handler.execute) {
        // actual execute + mark return results as dirty
        self._markDirty(handler.execute(context));
      } // log to stack


      self._executedAction(action, redo);

      self._fire(command, 'executed', action);
    });

    if (!redo) {
      this._fire(command, 'postExecute', action);

      if (handler.postExecute) {
        handler.postExecute(context);
      }

      this._fire(command, 'postExecuted', action);
    }

    this._popAction(action);
  };

  CommandStack.prototype._pushAction = function (action) {
    var execution = this._currentExecution,
        actions = execution.actions;
    var baseAction = actions[0];

    if (execution.atomic) {
      throw new Error('illegal invocation in <execute> or <revert> phase (action: ' + action.command + ')');
    }

    if (!action.id) {
      action.id = baseAction && baseAction.id || this._createId();
    }

    actions.push(action);
  };

  CommandStack.prototype._popAction = function () {
    var execution = this._currentExecution,
        actions = execution.actions,
        dirty = execution.dirty;
    actions.pop();

    if (!actions.length) {
      this._eventBus.fire('elements.changed', {
        elements: uniqueBy('id', dirty.reverse())
      });

      dirty.length = 0;

      this._fire('changed');
    }
  };

  CommandStack.prototype._markDirty = function (elements) {
    var execution = this._currentExecution;

    if (!elements) {
      return;
    }

    elements = isArray(elements) ? elements : [elements];
    execution.dirty = execution.dirty.concat(elements);
  };

  CommandStack.prototype._executedAction = function (action, redo) {
    var stackIdx = ++this._stackIdx;

    if (!redo) {
      this._stack.splice(stackIdx, this._stack.length, action);
    }
  };

  CommandStack.prototype._revertedAction = function (action) {
    this._stackIdx--;
  };

  CommandStack.prototype._getHandler = function (command) {
    return this._handlerMap[command];
  };

  CommandStack.prototype._setHandler = function (command, handler) {
    if (!command || !handler) {
      throw new Error('command and handler required');
    }

    if (this._handlerMap[command]) {
      throw new Error('overriding handler for command <' + command + '>');
    }

    this._handlerMap[command] = handler;
  };

  var CommandStack$1 = {
    commandStack: ['type', CommandStack]
  };

  /**
   * Adds change support to the diagram, including
   *
   * <ul>
   *   <li>redrawing shapes and connections on change</li>
   * </ul>
   *
   * @param {EventBus} eventBus
   * @param {Canvas} canvas
   * @param {ElementRegistry} elementRegistry
   * @param {GraphicsFactory} graphicsFactory
   */

  function ChangeSupport(eventBus, canvas, elementRegistry, graphicsFactory) {
    // redraw shapes / connections on change
    eventBus.on('element.changed', function (event) {
      var element = event.element; // element might have been deleted and replaced by new element with same ID
      // thus check for parent of element except for root element

      if (element.parent || element === canvas.getRootElement()) {
        event.gfx = elementRegistry.getGraphics(element);
      } // shape + gfx may have been deleted


      if (!event.gfx) {
        return;
      }

      eventBus.fire(getType(element) + '.changed', event);
    });
    eventBus.on('elements.changed', function (event) {
      var elements = event.elements;
      elements.forEach(function (e) {
        eventBus.fire('element.changed', {
          element: e
        });
      });
      graphicsFactory.updateContainments(elements);
    });
    eventBus.on('shape.changed', function (event) {
      graphicsFactory.update('shape', event.element, event.gfx);
    });
    eventBus.on('connection.changed', function (event) {
      graphicsFactory.update('connection', event.element, event.gfx);
    });
  }
  ChangeSupport.$inject = ['eventBus', 'canvas', 'elementRegistry', 'graphicsFactory'];

  var DiagramChangeSupport = {
    __init__: ['changeSupport'],
    changeSupport: ['type', ChangeSupport]
  };

  var min = Math.min,
      max$1 = Math.max;

  function preventDefault$1(e) {
    e.preventDefault();
  }

  function stopPropagation$1(e) {
    e.stopPropagation();
  }

  function isTextNode(node) {
    return node.nodeType === Node.TEXT_NODE;
  }

  function toArray(nodeList) {
    return [].slice.call(nodeList);
  }
  /**
   * Initializes a container for a content editable div.
   *
   * Structure:
   *
   * container
   *   parent
   *     content
   *     resize-handle
   *
   * @param {object} options
   * @param {DOMElement} options.container The DOM element to append the contentContainer to
   * @param {Function} options.keyHandler Handler for key events
   * @param {Function} options.resizeHandler Handler for resize events
   */


  function TextBox(options) {
    this.container = options.container;
    this.parent = domify('<div class="djs-direct-editing-parent">' + '<div class="djs-direct-editing-content" contenteditable="true"></div>' + '</div>');
    this.content = query('[contenteditable]', this.parent);

    this.keyHandler = options.keyHandler || function () {};

    this.resizeHandler = options.resizeHandler || function () {};

    this.autoResize = bind(this.autoResize, this);
    this.handlePaste = bind(this.handlePaste, this);
  }
  /**
   * Create a text box with the given position, size, style and text content
   *
   * @param {Object} bounds
   * @param {Number} bounds.x absolute x position
   * @param {Number} bounds.y absolute y position
   * @param {Number} [bounds.width] fixed width value
   * @param {Number} [bounds.height] fixed height value
   * @param {Number} [bounds.maxWidth] maximum width value
   * @param {Number} [bounds.maxHeight] maximum height value
   * @param {Number} [bounds.minWidth] minimum width value
   * @param {Number} [bounds.minHeight] minimum height value
   * @param {Object} [style]
   * @param {String} value text content
   *
   * @return {DOMElement} The created content DOM element
   */

  TextBox.prototype.create = function (bounds, style, value, options) {
    var self = this;
    var parent = this.parent,
        content = this.content,
        container = this.container;
    options = this.options = options || {};
    style = this.style = style || {};
    var parentStyle = pick(style, ['width', 'height', 'maxWidth', 'maxHeight', 'minWidth', 'minHeight', 'left', 'top', 'backgroundColor', 'position', 'overflow', 'border', 'wordWrap', 'textAlign', 'outline', 'transform']);
    assign(parent.style, {
      width: bounds.width + 'px',
      height: bounds.height + 'px',
      maxWidth: bounds.maxWidth + 'px',
      maxHeight: bounds.maxHeight + 'px',
      minWidth: bounds.minWidth + 'px',
      minHeight: bounds.minHeight + 'px',
      left: bounds.x + 'px',
      top: bounds.y + 'px',
      backgroundColor: '#ffffff',
      position: 'absolute',
      overflow: 'visible',
      border: '1px solid #ccc',
      boxSizing: 'border-box',
      wordWrap: 'normal',
      textAlign: 'center',
      outline: 'none'
    }, parentStyle);
    var contentStyle = pick(style, ['fontFamily', 'fontSize', 'fontWeight', 'lineHeight', 'padding', 'paddingTop', 'paddingRight', 'paddingBottom', 'paddingLeft']);
    assign(content.style, {
      boxSizing: 'border-box',
      width: '100%',
      outline: 'none',
      wordWrap: 'break-word'
    }, contentStyle);

    if (options.centerVertically) {
      assign(content.style, {
        position: 'absolute',
        top: '50%',
        transform: 'translate(0, -50%)'
      }, contentStyle);
    }

    content.innerText = value;
    componentEvent.bind(content, 'keydown', this.keyHandler);
    componentEvent.bind(content, 'mousedown', stopPropagation$1);
    componentEvent.bind(content, 'paste', self.handlePaste);

    if (options.autoResize) {
      componentEvent.bind(content, 'input', this.autoResize);
    }

    if (options.resizable) {
      this.resizable(style);
    }

    container.appendChild(parent); // set selection to end of text

    this.setSelection(content.lastChild, content.lastChild && content.lastChild.length);
    return parent;
  };
  /**
   * Intercept paste events to remove formatting from pasted text.
   */


  TextBox.prototype.handlePaste = function (e) {
    var options = this.options,
        style = this.style;
    e.preventDefault();
    var text;

    if (e.clipboardData) {
      // Chrome, Firefox, Safari
      text = e.clipboardData.getData('text/plain');
    } else {
      // Internet Explorer
      text = window.clipboardData.getData('Text');
    }

    this.insertText(text);

    if (options.autoResize) {
      var hasResized = this.autoResize(style);

      if (hasResized) {
        this.resizeHandler(hasResized);
      }
    }
  };

  TextBox.prototype.insertText = function (text) {
    // insertText command not supported by Internet Explorer
    var success = document.execCommand('insertText', false, text);

    if (success) {
      return;
    }

    this._insertTextIE(text);
  };

  TextBox.prototype._insertTextIE = function (text) {
    // Internet Explorer
    var range = this.getSelection(),
        startContainer = range.startContainer,
        endContainer = range.endContainer,
        startOffset = range.startOffset,
        endOffset = range.endOffset,
        commonAncestorContainer = range.commonAncestorContainer;
    var childNodesArray = toArray(commonAncestorContainer.childNodes);
    var container, offset;

    if (isTextNode(commonAncestorContainer)) {
      var containerTextContent = startContainer.textContent;
      startContainer.textContent = containerTextContent.substring(0, startOffset) + text + containerTextContent.substring(endOffset);
      container = startContainer;
      offset = startOffset + text.length;
    } else if (startContainer === this.content && endContainer === this.content) {
      var textNode = document.createTextNode(text);
      this.content.insertBefore(textNode, childNodesArray[startOffset]);
      container = textNode;
      offset = textNode.textContent.length;
    } else {
      var startContainerChildIndex = childNodesArray.indexOf(startContainer),
          endContainerChildIndex = childNodesArray.indexOf(endContainer);
      childNodesArray.forEach(function (childNode, index) {
        if (index === startContainerChildIndex) {
          childNode.textContent = startContainer.textContent.substring(0, startOffset) + text + endContainer.textContent.substring(endOffset);
        } else if (index > startContainerChildIndex && index <= endContainerChildIndex) {
          remove(childNode);
        }
      });
      container = startContainer;
      offset = startOffset + text.length;
    }

    if (container && offset !== undefined) {
      // is necessary in Internet Explorer
      setTimeout(function () {
        self.setSelection(container, offset);
      });
    }
  };
  /**
   * Automatically resize element vertically to fit its content.
   */


  TextBox.prototype.autoResize = function () {
    var parent = this.parent,
        content = this.content;
    var fontSize = parseInt(this.style.fontSize) || 12;

    if (content.scrollHeight > parent.offsetHeight || content.scrollHeight < parent.offsetHeight - fontSize) {
      var bounds = parent.getBoundingClientRect();
      var height = content.scrollHeight;
      parent.style.height = height + 'px';
      this.resizeHandler({
        width: bounds.width,
        height: bounds.height,
        dx: 0,
        dy: height - bounds.height
      });
    }
  };
  /**
   * Make an element resizable by adding a resize handle.
   */


  TextBox.prototype.resizable = function () {
    var self = this;
    var parent = this.parent,
        resizeHandle = this.resizeHandle;
    var minWidth = parseInt(this.style.minWidth) || 0,
        minHeight = parseInt(this.style.minHeight) || 0,
        maxWidth = parseInt(this.style.maxWidth) || Infinity,
        maxHeight = parseInt(this.style.maxHeight) || Infinity;

    if (!resizeHandle) {
      resizeHandle = this.resizeHandle = domify('<div class="djs-direct-editing-resize-handle"></div>');
      var startX, startY, startWidth, startHeight;

      var onMouseDown = function onMouseDown(e) {
        preventDefault$1(e);
        stopPropagation$1(e);
        startX = e.clientX;
        startY = e.clientY;
        var bounds = parent.getBoundingClientRect();
        startWidth = bounds.width;
        startHeight = bounds.height;
        componentEvent.bind(document, 'mousemove', onMouseMove);
        componentEvent.bind(document, 'mouseup', onMouseUp);
      };

      var onMouseMove = function onMouseMove(e) {
        preventDefault$1(e);
        stopPropagation$1(e);
        var newWidth = min(max$1(startWidth + e.clientX - startX, minWidth), maxWidth);
        var newHeight = min(max$1(startHeight + e.clientY - startY, minHeight), maxHeight);
        parent.style.width = newWidth + 'px';
        parent.style.height = newHeight + 'px';
        self.resizeHandler({
          width: startWidth,
          height: startHeight,
          dx: e.clientX - startX,
          dy: e.clientY - startY
        });
      };

      var onMouseUp = function onMouseUp(e) {
        preventDefault$1(e);
        stopPropagation$1(e);
        componentEvent.unbind(document, 'mousemove', onMouseMove, false);
        componentEvent.unbind(document, 'mouseup', onMouseUp, false);
      };

      componentEvent.bind(resizeHandle, 'mousedown', onMouseDown);
    }

    assign(resizeHandle.style, {
      position: 'absolute',
      bottom: '0px',
      right: '0px',
      cursor: 'nwse-resize',
      width: '0',
      height: '0',
      borderTop: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid transparent',
      borderRight: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid #ccc',
      borderBottom: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid #ccc',
      borderLeft: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid transparent'
    });
    parent.appendChild(resizeHandle);
  };
  /**
   * Clear content and style of the textbox, unbind listeners and
   * reset CSS style.
   */


  TextBox.prototype.destroy = function () {
    var parent = this.parent,
        content = this.content,
        resizeHandle = this.resizeHandle; // clear content

    content.innerText = ''; // clear styles

    parent.removeAttribute('style');
    content.removeAttribute('style');
    componentEvent.unbind(content, 'keydown', this.keyHandler);
    componentEvent.unbind(content, 'mousedown', stopPropagation$1);
    componentEvent.unbind(content, 'input', this.autoResize);
    componentEvent.unbind(content, 'paste', this.handlePaste);

    if (resizeHandle) {
      resizeHandle.removeAttribute('style');
      remove(resizeHandle);
    }

    remove(parent);
  };

  TextBox.prototype.getValue = function () {
    return this.content.innerText.trim();
  };

  TextBox.prototype.getSelection = function () {
    var selection = window.getSelection(),
        range = selection.getRangeAt(0);
    return range;
  };

  TextBox.prototype.setSelection = function (container, offset) {
    var range = document.createRange();

    if (container === null) {
      range.selectNodeContents(this.content);
    } else {
      range.setStart(container, offset);
      range.setEnd(container, offset);
    }

    var selection = window.getSelection();
    selection.removeAllRanges();
    selection.addRange(range);
  };

  /**
   * A direct editing component that allows users
   * to edit an elements text directly in the diagram
   *
   * @param {EventBus} eventBus the event bus
   */

  function DirectEditing(eventBus, canvas) {
    this._eventBus = eventBus;
    this._providers = [];
    this._textbox = new TextBox({
      container: canvas.getContainer(),
      keyHandler: bind(this._handleKey, this),
      resizeHandler: bind(this._handleResize, this)
    });
  }
  DirectEditing.$inject = ['eventBus', 'canvas'];
  /**
   * Register a direct editing provider

   * @param {Object} provider the provider, must expose an #activate(element) method that returns
   *                          an activation context ({ bounds: {x, y, width, height }, text }) if
   *                          direct editing is available for the given element.
   *                          Additionally the provider must expose a #update(element, value) method
   *                          to receive direct editing updates.
   */

  DirectEditing.prototype.registerProvider = function (provider) {
    this._providers.push(provider);
  };
  /**
   * Returns true if direct editing is currently active
   *
   * @return {Boolean}
   */


  DirectEditing.prototype.isActive = function () {
    return !!this._active;
  };
  /**
   * Cancel direct editing, if it is currently active
   */


  DirectEditing.prototype.cancel = function () {
    if (!this._active) {
      return;
    }

    this._fire('cancel');

    this.close();
  };

  DirectEditing.prototype._fire = function (event, context) {
    this._eventBus.fire('directEditing.' + event, context || {
      active: this._active
    });
  };

  DirectEditing.prototype.close = function () {
    this._textbox.destroy();

    this._fire('deactivate');

    this._active = null;
    this.resizable = undefined;
  };

  DirectEditing.prototype.complete = function () {
    var active = this._active;

    if (!active) {
      return;
    }

    var containerBounds,
        previousBounds = active.context.bounds,
        newBounds = this.$textbox.getBoundingClientRect(),
        newText = this.getValue(),
        previousText = active.context.text;

    if (newText !== previousText || newBounds.height !== previousBounds.height || newBounds.width !== previousBounds.width) {
      containerBounds = this._textbox.container.getBoundingClientRect();
      active.provider.update(active.element, newText, active.context.text, {
        x: newBounds.left - containerBounds.left,
        y: newBounds.top - containerBounds.top,
        width: newBounds.width,
        height: newBounds.height
      });
    }

    this._fire('complete');

    this.close();
  };

  DirectEditing.prototype.getValue = function () {
    return this._textbox.getValue();
  };

  DirectEditing.prototype._handleKey = function (e) {
    // stop bubble
    e.stopPropagation();
    var key = e.keyCode || e.charCode; // ESC

    if (key === 27) {
      e.preventDefault();
      return this.cancel();
    } // Enter


    if (key === 13 && !e.shiftKey) {
      e.preventDefault();
      return this.complete();
    }
  };

  DirectEditing.prototype._handleResize = function (event) {
    this._fire('resize', event);
  };
  /**
   * Activate direct editing on the given element
   *
   * @param {Object} ElementDescriptor the descriptor for a shape or connection
   * @return {Boolean} true if the activation was possible
   */


  DirectEditing.prototype.activate = function (element) {
    if (this.isActive()) {
      this.cancel();
    } // the direct editing context


    var context;
    var provider = find(this._providers, function (p) {
      return (context = p.activate(element)) ? p : null;
    }); // check if activation took place

    if (context) {
      this.$textbox = this._textbox.create(context.bounds, context.style, context.text, context.options);
      this._active = {
        element: element,
        context: context,
        provider: provider
      };

      if (context.options && context.options.resizable) {
        this.resizable = true;
      }

      this._fire('activate');
    }

    return !!context;
  };

  var DiagramDirectEditing = {
    __depends__: [InteractionEventsModule],
    __init__: ['directEditing'],
    directEditing: ['type', DirectEditing]
  };

  function getLabelAttr(semantic) {
    if (is(semantic, 'dmn:Decision') || is(semantic, 'dmn:BusinessKnowledgeModel') || is(semantic, 'dmn:InputData') || is(semantic, 'dmn:KnowledgeSource')) {
      return 'name';
    }

    if (is(semantic, 'dmn:TextAnnotation')) {
      return 'text';
    }
  }

  function getLabel(element) {
    var semantic = element.businessObject,
        attr = getLabelAttr(semantic);

    if (attr) {
      return semantic[attr] || '';
    }
  }
  function setLabel(element, text, isExternal) {
    var semantic = element.businessObject,
        attr = getLabelAttr(semantic);

    if (attr) {
      semantic[attr] = text;
    } // show external label if not empty


    if (isExternal) {
      element.hidden = !text;
    }

    return element;
  }

  function LabelEditingProvider(canvas, directEditing, eventBus, modeling, textRenderer) {
    this._canvas = canvas;
    this._modeling = modeling;
    this._textRenderer = textRenderer;
    directEditing.registerProvider(this); // listen to dblclick on non-root elements

    eventBus.on('element.dblclick', function (event) {
      directEditing.activate(event.element);
    }); // complete on followup canvas operation

    eventBus.on(['autoPlace.start', 'canvas.viewbox.changing', 'drag.init', 'drillDown.click', 'element.mousedown', 'popupMenu.open'], function () {
      directEditing.complete();
    }); // cancel on command stack changes

    eventBus.on(['commandStack.changed'], function () {
      directEditing.cancel();
    });
    eventBus.on('create.end', 500, function (e) {
      var element = e.shape;

      if (is(element, 'dmn:Decision') || is(element, 'dmn:InputData') || is(element, 'dmn:BusinessKnowledgeModel') || is(element, 'dmn:KnowledgeSource') || is(element, 'dmn:TextAnnotation')) {
        directEditing.activate(element);
      }
    });
    eventBus.on('autoPlace.end', 500, function (event) {
      directEditing.activate(event.shape);
    });
  }
  LabelEditingProvider.$inject = ['canvas', 'directEditing', 'eventBus', 'modeling', 'textRenderer'];
  /**
   * Activate direct editing for drgs and text annotations.
   *
   * @param  {djs.model.Base} element
   *
   * @return {Object} an object with properties bounds (position and size) and text
   */

  LabelEditingProvider.prototype.activate = function (element) {
    var text = getLabel(element);

    if (!isDefined(text)) {
      return;
    }

    var context = {
      text: text
    };
    var editingBBox = this.getEditingBBox(element);
    assign(context, editingBBox);
    var options = {}; // DRG elements

    if (is(element, 'dmn:DRGElement')) {
      assign(options, {
        centerVertically: true
      });
    } // text annotations


    if (is(element, 'dmn:TextAnnotation')) {
      assign(options, {
        resizable: true
      });
    }

    assign(context, {
      options: options
    });
    return context;
  };
  /**
   * Get the editing bounding box based on the element's size and position
   *
   * @param  {djs.model.Base} element
   *
   * @return {Object}
   *         an object containing information about position and
   *         size (fixed or minimum and/or maximum)
   */


  LabelEditingProvider.prototype.getEditingBBox = function (element) {
    var canvas = this._canvas;
    var target = element.label || element;
    var bbox = canvas.getAbsoluteBBox(target); // default position

    var bounds = {
      x: bbox.x,
      y: bbox.y
    };
    var zoom = canvas.zoom();

    var defaultStyle = this._textRenderer.getDefaultStyle(); // take zoom into account


    var defaultFontSize = defaultStyle.fontSize * zoom,
        defaultLineHeight = defaultStyle.lineHeight;
    var style = {
      fontFamily: this._textRenderer.getDefaultStyle().fontFamily,
      fontWeight: this._textRenderer.getDefaultStyle().fontWeight
    }; // DRG elements

    if (is(element, 'dmn:DRGElement')) {
      assign(bounds, {
        width: bbox.width,
        height: bbox.height
      });
      assign(style, {
        fontSize: defaultFontSize + 'px',
        lineHeight: defaultLineHeight,
        paddingTop: 7 * zoom + 'px',
        paddingBottom: 7 * zoom + 'px',
        paddingLeft: 5 * zoom + 'px',
        paddingRight: 5 * zoom + 'px'
      });
    } // text annotations


    if (is(element, 'dmn:TextAnnotation')) {
      assign(bounds, {
        width: bbox.width,
        height: bbox.height,
        minWidth: 30 * zoom,
        minHeight: 10 * zoom
      });
      assign(style, {
        textAlign: 'left',
        paddingTop: 5 * zoom + 'px',
        paddingBottom: 7 * zoom + 'px',
        paddingLeft: 7 * zoom + 'px',
        paddingRight: 5 * zoom + 'px',
        fontSize: defaultFontSize + 'px',
        lineHeight: defaultLineHeight
      });
    }

    return {
      bounds: bounds,
      style: style
    };
  };

  LabelEditingProvider.prototype.update = function (element, newLabel, activeContextText, bounds) {
    var newBounds, bbox;

    if (is(element, 'dmn:TextAnnotation')) {
      bbox = this._canvas.getAbsoluteBBox(element);
      newBounds = {
        x: element.x,
        y: element.y,
        width: element.width / bbox.width * bounds.width,
        height: element.height / bbox.height * bounds.height
      };
    }

    if (isEmptyText(newLabel)) {
      newLabel = null;
    }

    this._modeling.updateLabel(element, newLabel, newBounds);
  }; // helpers //////////


  function isEmptyText(label) {
    return !label || !label.trim();
  }

  var LabelEditingModule = {
    __depends__: [CommandStack$1, DiagramChangeSupport, DiagramDirectEditing],
    __init__: ['labelEditingProvider'],
    labelEditingProvider: ['type', LabelEditingProvider]
  };

  /**
   * Creates DMN-specific refs for new connection.
   *
   * @param {DrdFactory} drdFactory
   * @param {Injector} injector
   */

  function CreateConnectionBehavior(drdFactory, injector) {
    injector.invoke(CommandInterceptor, this);
    this.preExecute('connection.create', function (context) {
      var connection = context.connection,
          connectionBo = connection.businessObject,
          source = context.source,
          target = context.target,
          elementRef,
          sourceRef,
          targetRef;

      if (is(connection, 'dmn:Association')) {
        sourceRef = connectionBo.sourceRef = drdFactory.create('dmn:DMNElementReference', {
          href: '#' + source.id
        });
        sourceRef.$parent = connectionBo;
        targetRef = connectionBo.targetRef = drdFactory.create('dmn:DMNElementReference', {
          href: '#' + target.id
        });
        targetRef.$parent = connectionBo;
      } else {
        elementRef = connectionBo['required' + getRequirementType(source)] = drdFactory.create('dmn:DMNElementReference', {
          href: '#' + source.id
        });
        elementRef.$parent = connectionBo;
      }
    }, true);
  }
  CreateConnectionBehavior.$inject = ['drdFactory', 'injector'];
  inherits_browser(CreateConnectionBehavior, CommandInterceptor); // helpers //////////

  function getRequirementType(source) {
    if (is(source, 'dmn:BusinessKnowledgeModel')) {
      return 'Knowledge';
    } else if (is(source, 'dmn:Decision')) {
      return 'Decision';
    } else if (is(source, 'dmn:InputData')) {
      return 'Input';
    } else if (is(source, 'dmn:KnowledgeSource')) {
      return 'Authority';
    }
  }

  var LOW_PRIORITY$8 = 500;
  function LayoutConnectionBehavior(injector, layouter, modeling, rules) {
    injector.invoke(CommandInterceptor, this); // specify connection start and end on connection create

    this.preExecute(['connection.create', 'connection.reconnect'], function (context) {
      var connection = context.connection,
          source = context.newSource || context.source,
          target = context.newTarget || context.target;

      if (is(connection, 'dmn:InformationRequirement') && !rules.allowed('connection.connect', {
        connection: connection,
        source: source,
        target: target
      })) {
        return;
      }

      if (!is(connection, 'dmn:InformationRequirement')) {
        return;
      }

      var orientation = getOrientation(source, target);

      if (!context.hints) {
        context.hints = {};
      }

      assign(context.hints, getConnectionHints(source, target, orientation));
    }, true);
    /**
     * Update incoming information requirements.
     *
     * @param {djs.model.Shape} target
     * @param {Array<djs.model.Connection>} [informationRequirements]
     * @param {string} [orientation]
     */

    function updateInformationRequirements(target, informationRequirements, orientation) {
      // (1) get information requirements
      if (!informationRequirements) {
        informationRequirements = target.incoming.filter(function (incoming) {
          return is(incoming, 'dmn:InformationRequirement');
        });
      }

      var incomingInformationRequirementsByOrientation = {}; // (2) get information requirements per orientation

      if (orientation) {
        incomingInformationRequirementsByOrientation[orientation] = informationRequirements;
      } else {
        incomingInformationRequirementsByOrientation = getInformationRequirementsByOrientation(target, informationRequirements);
      } // (3) update information requirements per orientation


      forEach(incomingInformationRequirementsByOrientation, function (informationRequirements, orientation) {
        // (3.1) sort information requirements
        informationRequirements = sortInformationRequirements(informationRequirements, orientation); // (3.2) get new connection start and end

        var connectionStartEnd = getConnectionsStartEnd(informationRequirements, target, orientation); // (3.3) update information requirements

        informationRequirements.forEach(function (informationRequirement, index) {
          var connectionStart = connectionStartEnd[index].start,
              connectionEnd = connectionStartEnd[index].end;
          var waypoints = layouter.layoutConnection(informationRequirement, {
            connectionStart: connectionStart,
            connectionEnd: connectionEnd
          });
          modeling.updateWaypoints(informationRequirement, waypoints);
        });
      });
    } // update information requirements on connection create and delete
    // update information requirements of new target on connection reconnect


    this.postExecuted(['connection.create', 'connection.delete', 'connection.reconnect'], function (context) {
      var connection = context.connection,
          source = connection.source || context.source,
          target = connection.target || context.target;

      if (!is(connection, 'dmn:InformationRequirement')) {
        return;
      }

      var orientation = getOrientation(source, target); // update all information requirements with same orientation

      var informationRequirements = target.incoming.filter(function (incoming) {
        var incomingOrientation = getOrientation(incoming.source, incoming.target);
        return is(incoming, 'dmn:InformationRequirement') && isSameOrientation(incomingOrientation, orientation);
      });

      if (!informationRequirements.length) {
        return;
      }

      updateInformationRequirements(target, informationRequirements, orientation);
    }, true); // update information requirements of old target on connection reconnect

    this.preExecute('connection.reconnect', function (context) {
      var connection = context.connection,
          source = connection.source,
          target = connection.target;

      if (!is(connection, 'dmn:InformationRequirement')) {
        return;
      }

      var orientation = getOrientation(source, target); // update all information requirements with same orientation except reconnected

      var informationRequirements = target.incoming.filter(function (incoming) {
        var incomingOrientation = getOrientation(incoming.source, incoming.target);
        return incoming !== connection && is(incoming, 'dmn:InformationRequirement') && isSameOrientation(incomingOrientation, orientation);
      });

      if (!informationRequirements.length) {
        return;
      }

      updateInformationRequirements(target, informationRequirements, orientation);
    }, true); // update information requirements on elements move

    this.postExecuted('elements.move', LOW_PRIORITY$8, function (context) {
      var shapes = context.shapes,
          closure = context.closure,
          enclosedConnections = closure.enclosedConnections;
      shapes.forEach(function (shape) {
        if (!isAny(shape, ['dmn:Decision', 'dmn:InputData'])) {
          return;
        } // (1) update incoming information requirements


        var incomingInformationRequirements = shape.incoming.filter(function (incoming) {
          return is(incoming, 'dmn:InformationRequirement') && !enclosedConnections[incoming.id];
        });

        if (incomingInformationRequirements.length) {
          updateInformationRequirements(shape, incomingInformationRequirements);
        } // (2) update outgoing information requirements


        shape.outgoing.forEach(function (outgoing) {
          if (!is(outgoing, 'dmn:InformationRequirement') || enclosedConnections[outgoing.id]) {
            return;
          }

          updateInformationRequirements(outgoing.target);
        });
      });
    }, true);
  }
  LayoutConnectionBehavior.$inject = ['injector', 'layouter', 'modeling', 'rules'];
  inherits_browser(LayoutConnectionBehavior, CommandInterceptor); // helpers //////////

  function getConnectionHints(source, target, orientation) {
    var connectionStart = getMid(source),
        connectionEnd = getMid(target);

    if (orientation.includes('bottom')) {
      connectionStart.y = source.y;
      connectionEnd.y = target.y + target.height;
    } else if (orientation.includes('top')) {
      connectionStart.y = source.y + source.height;
      connectionEnd.y = target.y;
    } else if (orientation.includes('right')) {
      connectionStart.x = source.x;
      connectionEnd.x = target.x + target.width;
    } else {
      connectionStart.x = source.x + source.width;
      connectionEnd.x = target.x;
    }

    return {
      connectionStart: connectionStart,
      connectionEnd: connectionEnd
    };
  }
  /**
   * Get connections start and end based on number of information requirements and
   * orientation.
   *
   * @param {Array<djs.model.Connection>} informationRequirements
   * @param {djs.model.Shape} target
   * @param {string} orientation
   *
   * @returns {Array<Object>}
   */


  function getConnectionsStartEnd(informationRequirements, target, orientation) {
    return informationRequirements.map(function (informationRequirement, index) {
      var source = informationRequirement.source,
          sourceMid = getMid(source),
          sourceTrbl = asTRBL(source),
          targetTrbl = asTRBL(target);
      var length = informationRequirements.length;

      if (orientation.includes('bottom')) {
        return {
          start: {
            x: sourceMid.x,
            y: sourceTrbl.top
          },
          end: {
            x: targetTrbl.left + target.width / (length + 1) * (index + 1),
            y: targetTrbl.bottom
          }
        };
      } else if (orientation.includes('top')) {
        return {
          start: {
            x: sourceMid.x,
            y: sourceTrbl.bottom
          },
          end: {
            x: targetTrbl.left + target.width / (length + 1) * (index + 1),
            y: targetTrbl.top
          }
        };
      } else if (orientation.includes('right')) {
        return {
          start: {
            x: sourceTrbl.left,
            y: sourceMid.y
          },
          end: {
            x: targetTrbl.right,
            y: targetTrbl.top + target.height / (length + 1) * (index + 1)
          }
        };
      } else {
        return {
          start: {
            x: sourceTrbl.right,
            y: sourceMid.y
          },
          end: {
            x: targetTrbl.left,
            y: targetTrbl.top + target.height / (length + 1) * (index + 1)
          }
        };
      }
    });
  }
  /**
   * Get information requirements by orientation.
   *
   * @param {djs.model.shape} target
   * @param {Array<djs.model.Connection>} informationRequirements
   *
   * @returns {Object}
   */


  function getInformationRequirementsByOrientation(target, informationRequirements) {
    var incomingInformationRequirementsByOrientation = {};
    informationRequirements.forEach(function (incoming) {
      var orientation = getOrientation(incoming.source, target).split('-').shift();

      if (!incomingInformationRequirementsByOrientation[orientation]) {
        incomingInformationRequirementsByOrientation[orientation] = [];
      }

      incomingInformationRequirementsByOrientation[orientation].push(incoming);
    });
    return incomingInformationRequirementsByOrientation;
  }

  function isSameOrientation(orientationA, orientationB) {
    return orientationA && orientationB && orientationA.split('-').shift() === orientationB.split('-').shift();
  }

  function sortInformationRequirements(informationRequirements, orientation) {
    var axis;

    if (orientation.includes('top') || orientation.includes('bottom')) {
      axis = 'x';
    } else {
      axis = 'y';
    }

    return informationRequirements.sort(function (a, b) {
      return getMid(a.source)[axis] - getMid(b.source)[axis];
    });
  }

  function ReplaceConnectionBehavior(injector, modeling, rules) {
    injector.invoke(CommandInterceptor, this);
    this.preExecute('connection.reconnect', function (context) {
      var connection = context.connection,
          source = context.newSource || connection.source,
          target = context.newTarget || connection.target,
          waypoints = connection.waypoints.slice();
      var allowed = rules.allowed('connection.reconnect', {
        connection: connection,
        source: source,
        target: target
      });

      if (!allowed || allowed.type === connection.type) {
        return;
      }

      context.connection = modeling.connect(source, target, {
        type: allowed.type,
        waypoints: waypoints
      });
      modeling.removeConnection(connection);
    }, true);
  }
  inherits_browser(ReplaceConnectionBehavior, CommandInterceptor);
  ReplaceConnectionBehavior.$inject = ['injector', 'modeling', 'rules'];

  /**
   * Defines the behaviour of what happens to the elements inside a container
   * that morphs into another DRD element
   */

  function ReplaceElementBehaviour(eventBus, modeling) {
    CommandInterceptor.call(this, eventBus);
    this._modeling = modeling;
    this.postExecuted(['shape.replace'], 1500, function (e) {
      var context = e.context,
          oldShape = context.oldShape,
          newShape = context.newShape;
      modeling.unclaimId(oldShape.businessObject.id, oldShape.businessObject);
      modeling.updateProperties(newShape, {
        id: oldShape.id
      });
    });
  }
  inherits_browser(ReplaceElementBehaviour, CommandInterceptor);
  ReplaceElementBehaviour.$inject = ['eventBus', 'modeling'];

  function _typeof$3(obj) {
    if (typeof Symbol === "function" && _typeof(Symbol.iterator) === "symbol") {
      _typeof$3 = function _typeof$1(obj) {
        return _typeof(obj);
      };
    } else {
      _typeof$3 = function _typeof$1(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof(obj);
      };
    }

    return _typeof$3(obj);
  }

  function _classCallCheck$4(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$4(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$4(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$4(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$4(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$2(self, call) {
    if (call && (_typeof$3(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$2(self);
  }

  function _getPrototypeOf$2(o) {
    _getPrototypeOf$2 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$2(o);
  }

  function _assertThisInitialized$2(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _inherits$2(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$2(subClass, superClass);
  }

  function _setPrototypeOf$2(o, p) {
    _setPrototypeOf$2 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$2(o, p);
  }
  var ID = 'id';

  var IdChangeBehavior =
  /*#__PURE__*/
  function (_CommandInterceptor) {
    _inherits$2(IdChangeBehavior, _CommandInterceptor);

    function IdChangeBehavior(eventBus) {
      var _this;

      _classCallCheck$4(this, IdChangeBehavior);

      _this = _possibleConstructorReturn$2(this, _getPrototypeOf$2(IdChangeBehavior).call(this, eventBus));

      _this.executed('element.updateProperties', _this.updateIds.bind(_assertThisInitialized$2(_this)));

      return _this;
    }

    _createClass$4(IdChangeBehavior, [{
      key: "updateIds",
      value: function updateIds(_ref) {
        var context = _ref.context;
        var element = context.element,
            oldProperties = context.oldProperties,
            properties = context.properties;
        var bo = getBusinessObject(element);

        if (this.shouldSkipUpdate(bo, oldProperties, properties)) {
          return;
        }

        var definitions = getDefinitions(bo);
        var drgElements = definitions.get('drgElement');
        drgElements.forEach(function (drgElement) {
          updateElementReferences(drgElement, oldProperties.id, properties.id);
        });
        var artifacts = definitions.get('artifact');
        artifacts.forEach(function (artifact) {
          updateAssociationReferences(artifact, oldProperties.id, properties.id);
        });
      }
    }, {
      key: "shouldSkipUpdate",
      value: function shouldSkipUpdate(bo, oldProperties, newProperties) {
        return !isIdChange(oldProperties, newProperties) || !is(bo, 'dmn:DRGElement') && !is(bo, 'dmn:TextAnnotation');
      }
    }]);

    return IdChangeBehavior;
  }(CommandInterceptor);
  IdChangeBehavior.$inject = ['eventBus']; // helpers //////////////////////

  function isIdChange(oldProperties, properties) {
    return ID in oldProperties && ID in properties;
  }
  /**
   * Walk up the tree until at the root to get to dmn:Definitions.
   *
   * @param {ModdleElement} element
   */


  function getDefinitions(element) {
    var definitions = element;

    while (!is(definitions, 'dmn:Definitions')) {
      definitions = definitions.$parent;
    }

    return definitions;
  }

  function updateElementReferences(element, oldId, id) {
    var handlers = {
      authorityRequirement: function authorityRequirement() {
        element.authorityRequirement.forEach(function (authorityRequirement) {
          var requiredAuthority = authorityRequirement.requiredAuthority,
              requiredDecision = authorityRequirement.requiredDecision,
              requiredInput = authorityRequirement.requiredInput;

          if (requiredAuthority && requiredAuthority.href === "#".concat(oldId)) {
            requiredAuthority.href = "#".concat(id);
          }

          if (requiredDecision && requiredDecision.href === "#".concat(oldId)) {
            requiredDecision.href = "#".concat(id);
          }

          if (requiredInput && requiredInput.href === "#".concat(oldId)) {
            requiredInput.href = "#".concat(id);
          }
        });
      },
      informationRequirement: function informationRequirement() {
        element.informationRequirement.forEach(function (informationRequirement) {
          var requiredDecision = informationRequirement.requiredDecision,
              requiredInput = informationRequirement.requiredInput;

          if (requiredDecision && requiredDecision.href === "#".concat(oldId)) {
            requiredDecision.href = "#".concat(id);
          }

          if (requiredInput && requiredInput.href === "#".concat(oldId)) {
            requiredInput.href = "#".concat(id);
          }
        });
      },
      knowledgeRequirement: function knowledgeRequirement() {
        element.knowledgeRequirement.forEach(function (knowledgeRequirement) {
          var requiredKnowledge = knowledgeRequirement.requiredKnowledge;

          if (requiredKnowledge && requiredKnowledge.href === "#".concat(oldId)) {
            requiredKnowledge.href = "#".concat(id);
          }
        });
      }
    };
    forEach(handlers, function (handler, key) {
      if (element[key]) {
        handler();
      }
    });
  }

  function updateAssociationReferences(element, oldId, id) {
    var handlers = {
      sourceRef: function sourceRef() {
        var sourceRef = element.sourceRef;

        if (sourceRef.href === "#".concat(oldId)) {
          sourceRef.href = "#".concat(id);
        }
      },
      targetRef: function targetRef() {
        var targetRef = element.targetRef;

        if (targetRef.href === "#".concat(oldId)) {
          targetRef.href = "#".concat(id);
        }
      }
    };
    forEach(handlers, function (handler, key) {
      if (element[key]) {
        handler();
      }
    });
  }

  var ModelingBehavior = {
    __init__: ['createConnectionBehavior', 'idChangeBehavior', 'layoutConnectionBehavior', 'replaceConnectionBehavior', 'replaceElementBehavior'],
    createConnectionBehavior: ['type', CreateConnectionBehavior],
    idChangeBehavior: ['type', IdChangeBehavior],
    layoutConnectionBehavior: ['type', LayoutConnectionBehavior],
    replaceConnectionBehavior: ['type', ReplaceConnectionBehavior],
    replaceElementBehavior: ['type', ReplaceElementBehaviour]
  };

  /**
   * A basic provider that may be extended to implement modeling rules.
   *
   * Extensions should implement the init method to actually add their custom
   * modeling checks. Checks may be added via the #addRule(action, fn) method.
   *
   * @param {EventBus} eventBus
   */

  function RuleProvider(eventBus) {
    CommandInterceptor.call(this, eventBus);
    this.init();
  }
  RuleProvider.$inject = ['eventBus'];
  inherits_browser$1(RuleProvider, CommandInterceptor);
  /**
   * Adds a modeling rule for the given action, implemented through
   * a callback function.
   *
   * The function will receive the modeling specific action context
   * to perform its check. It must return `false` to disallow the
   * action from happening or `true` to allow the action.
   *
   * A rule provider may pass over the evaluation to lower priority
   * rules by returning return nothing (or <code>undefined</code>).
   *
   * @example
   *
   * ResizableRules.prototype.init = function() {
   *
   *   \/**
   *    * Return `true`, `false` or nothing to denote
   *    * _allowed_, _not allowed_ and _continue evaluating_.
   *    *\/
   *   this.addRule('shape.resize', function(context) {
   *
   *     var shape = context.shape;
   *
   *     if (!context.newBounds) {
   *       // check general resizability
   *       if (!shape.resizable) {
   *         return false;
   *       }
   *
   *       // not returning anything (read: undefined)
   *       // will continue the evaluation of other rules
   *       // (with lower priority)
   *       return;
   *     } else {
   *       // element must have minimum size of 10*10 points
   *       return context.newBounds.width > 10 && context.newBounds.height > 10;
   *     }
   *   });
   * };
   *
   * @param {string|Array<string>} actions the identifier for the modeling action to check
   * @param {number} [priority] the priority at which this rule is being applied
   * @param {Function} fn the callback function that performs the actual check
   */

  RuleProvider.prototype.addRule = function (actions, priority, fn) {
    var self = this;

    if (typeof actions === 'string') {
      actions = [actions];
    }

    actions.forEach(function (action) {
      self.canExecute(action, priority, function (context, action, event) {
        return fn(context);
      }, true);
    });
  };
  /**
   * Implement this method to add new rules during provider initialization.
   */


  RuleProvider.prototype.init = function () {};

  /**
   * DRD modeling rules.
   */

  function DrdRules(injector) {
    injector.invoke(RuleProvider, this);
  }
  inherits_browser(DrdRules, RuleProvider);
  DrdRules.$inject = ['injector'];

  DrdRules.prototype.init = function () {
    this.addRule('connection.create', function (context) {
      var source = context.source,
          target = context.target;
      return canConnect(source, target);
    });
    this.addRule('connection.reconnect', function (context) {
      var connection = context.connection,
          source = context.source,
          target = context.target;
      return canConnect(source, target);
    });
    this.addRule('connection.updateWaypoints', function (context) {
      var connection = context.connection;
      return {
        type: connection.type,
        businessObject: connection.businessObject
      };
    });
    this.addRule('elements.move', function (context) {
      var target = context.target,
          shapes = context.shapes,
          position = context.position;
      return canMove(shapes, target);
    });
    this.addRule('shape.create', function (context) {
      var shape = context.shape,
          target = context.target;
      return canCreate(shape, target);
    });
    this.addRule('shape.resize', function (context) {
      var shape = context.shape;
      return is(shape, 'dmn:TextAnnotation');
    });
  };

  DrdRules.prototype.canConnect = canConnect;
  DrdRules.prototype.canCreate = canCreate;
  DrdRules.prototype.canMove = canMove;

  function canConnect(source, target) {
    if (!source || isLabel$1(source) || !target || isLabel$1(target)) {
      return null;
    }

    if (source === target) {
      return false;
    }

    if (is(source, 'dmn:BusinessKnowledgeModel') && isAny(target, ['dmn:BusinessKnowledgeModel', 'dmn:Decision'])) {
      return {
        type: 'dmn:KnowledgeRequirement'
      };
    }

    if (is(source, 'dmn:Decision')) {
      if (is(target, 'dmn:Decision')) {
        return {
          type: 'dmn:InformationRequirement'
        };
      }

      if (is(target, 'dmn:KnowledgeSource')) {
        return {
          type: 'dmn:AuthorityRequirement'
        };
      }
    }

    if (is(source, 'dmn:Definitions') || is(target, 'dmn:Definitions')) {
      return false;
    }

    if (is(source, 'dmn:InputData')) {
      if (is(target, 'dmn:Decision')) {
        return {
          type: 'dmn:InformationRequirement'
        };
      }

      if (is(target, 'dmn:KnowledgeSource')) {
        return {
          type: 'dmn:AuthorityRequirement'
        };
      }
    }

    if (is(source, 'dmn:KnowledgeSource') && isAny(target, ['dmn:BusinessKnowledgeModel', 'dmn:Decision', 'dmn:KnowledgeSource'])) {
      return {
        type: 'dmn:AuthorityRequirement'
      };
    }

    if (is(source, 'dmn:TextAnnotation') && !is(target, 'dmn:TextAnnotation') || !is(source, 'dmn:TextAnnotation') && is(target, 'dmn:TextAnnotation')) {
      return {
        type: 'dmn:Association'
      };
    }

    return false;
  }

  function canCreate(shape, target) {
    return isAny(shape, ['dmn:BusinessKnowledgeModel', 'dmn:Decision', 'dmn:InputData', 'dmn:KnowledgeSource', 'dmn:TextAnnotation']) && is(target, 'dmn:Definitions');
  }

  function canMove(elements, target) {
    if (!isArray(elements)) {
      elements = [elements];
    } // allow default move check to start move operation


    if (!target) {
      return true;
    }

    if (every(elements, function (element) {
      return isAny(element, ['dmn:BusinessKnowledgeModel', 'dmn:Decision', 'dmn:InputData', 'dmn:KnowledgeSource', 'dmn:TextAnnotation', 'dmn:InformationRequirement', 'dmn:AuthorityRequirement', 'dmn:KnowledgeRequirement', 'dmn:Association']);
    }) && is(target, 'dmn:Definitions')) {
      return true;
    }

    return false;
  }

  function isLabel$1(element) {
    return !!element.labelTarget;
  }

  var Rules$2 = {
    __depends__: [Rules$1],
    __init__: ['drdRules'],
    drdRules: ['type', DrdRules]
  };

  function DrdFactory(moddle) {
    this._model = moddle;
  }
  DrdFactory.$inject = ['moddle'];

  DrdFactory.prototype._needsId = function (element) {
    return isAny(element, ['dmn:Artifact', 'dmn:DMNElement', 'dmn:DRGElement', 'dmndi:DMNDiagram', 'dmndi:DMNDiagramElement']);
  };

  DrdFactory.prototype._ensureId = function (element) {
    var prefix = (element.$type || '').replace(/^[^:]*:/g, '') + '_';

    if (!element.id && this._needsId(element)) {
      element.id = this._model.ids.nextPrefixed(prefix, element);
    }
  };

  DrdFactory.prototype.create = function (type, attrs) {
    var element = this._model.create(type, attrs || {});

    this._ensureId(element);

    return element;
  };

  DrdFactory.prototype.createDiShape = function (semantic, bounds, attrs) {
    return this.create('dmndi:DMNShape', assign({
      dmnElementRef: semantic,
      bounds: this.createDiBounds(bounds)
    }, attrs));
  };

  DrdFactory.prototype.createDiBounds = function (bounds) {
    return this.create('dc:Bounds', bounds);
  };

  DrdFactory.prototype.createDiEdge = function (semantic, waypoints, attrs) {
    return this.create('dmndi:DMNEdge', {
      dmnElementRef: semantic,
      waypoint: this.createDiWaypoints(waypoints)
    }, attrs);
  };

  DrdFactory.prototype.createDiWaypoints = function (waypoints) {
    var self = this;
    return waypoints.map(function (waypoint) {
      return self.createDiWaypoint(waypoint);
    });
  };

  DrdFactory.prototype.createDiWaypoint = function (waypoint) {
    return this.create('dc:Point', pick(waypoint, ['x', 'y']));
  };

  DrdFactory.prototype.createExtensionElements = function () {
    return this.create('dmn:ExtensionElements', {
      values: []
    });
  };

  /**
   * Update DMN 1.3 information.
   */

  function DrdUpdater(connectionDocking, definitionPropertiesView, drdFactory, drdRules, injector) {
    injector.invoke(CommandInterceptor, this);
    this._definitionPropertiesView = definitionPropertiesView;
    this._drdFactory = drdFactory;
    this._drdRules = drdRules;
    var self = this;

    function cropConnection(context) {
      var connection = context.connection,
          cropped = context.cropped;

      if (!cropped) {
        connection.waypoints = connectionDocking.getCroppedWaypoints(connection);
        context.cropped = true;
      }
    }

    this.executed(['connection.create', 'connection.layout'], cropConnection, true);
    this.reverted(['connection.layout'], function (context) {
      delete context.cropped;
    }, true);

    function updateParent(context) {
      var connection = context.connection,
          parent = context.parent,
          shape = context.shape;

      if (connection && !is(connection, 'dmn:Association')) {
        parent = connection.target;
      }

      self.updateParent(shape || connection, parent);
    }

    function reverseUpdateParent(context) {
      var connection = context.connection,
          shape = context.shape;
      var oldParent = context.parent || context.newParent;

      if (connection && !is(connection, 'dmn:Association')) {
        oldParent = connection.target;
      }

      self.updateParent(shape || connection, oldParent);
    }

    this.executed(['connection.create', 'connection.delete', 'connection.move', 'shape.create', 'shape.delete'], updateParent, true);
    this.reverted(['connection.create', 'connection.delete', 'connection.move', 'shape.create', 'shape.delete'], reverseUpdateParent, true);

    function updateBounds(context) {
      var shape = context.shape;

      if (!(is(shape, 'dmn:DRGElement') || is(shape, 'dmn:TextAnnotation'))) {
        return;
      }

      self.updateBounds(shape);
    }

    this.executed(['shape.create', 'shape.move', 'shape.resize'], updateBounds, true);
    this.reverted(['shape.create', 'shape.move', 'shape.resize'], updateBounds, true);

    function updateConnectionWaypoints(context) {
      self.updateConnectionWaypoints(context);
    }

    this.executed(['connection.create', 'connection.layout', 'connection.move', 'connection.updateWaypoints'], updateConnectionWaypoints, true);
    this.reverted(['connection.create', 'connection.layout', 'connection.move', 'connection.updateWaypoints'], updateConnectionWaypoints, true);
    this.executed('connection.create', function (context) {
      var connection = context.connection,
          connectionBo = connection.businessObject,
          target = context.target,
          targetBo = target.businessObject;

      if (is(connection, 'dmn:Association')) {
        updateParent(context);
      } else {
        // parent is target
        self.updateSemanticParent(connectionBo, targetBo);
      }
    }, true);
    this.reverted('connection.create', function (context) {
      reverseUpdateParent(context);
    }, true);
    this.executed('connection.reconnect', function (context) {
      var connection = context.connection,
          connectionBo = connection.businessObject,
          newTarget = context.newTarget,
          newTargetBo = newTarget.businessObject;
      self.updateSemanticParent(connectionBo, newTargetBo);
    }, true);
    this.reverted('connection.reconnect', function (context) {
      var connection = context.connection,
          connectionBo = connection.businessObject,
          oldTarget = context.oldTarget,
          oldTargetBo = oldTarget.businessObject;
      self.updateSemanticParent(connectionBo, oldTargetBo);
    }, true);
    this.executed('element.updateProperties', function (context) {
      definitionPropertiesView.update();
    }, true);
    this.reverted('element.updateProperties', function (context) {
      definitionPropertiesView.update();
    }, true);
  }
  inherits_browser(DrdUpdater, CommandInterceptor);
  DrdUpdater.$inject = ['connectionDocking', 'definitionPropertiesView', 'drdFactory', 'drdRules', 'injector'];

  DrdUpdater.prototype.updateBounds = function (shape) {
    var businessObject = shape.businessObject,
        bounds = businessObject.di.bounds; // update bounds

    assign(bounds, {
      x: shape.x,
      y: shape.y,
      width: shape.width,
      height: shape.height
    });
  };

  DrdUpdater.prototype.updateConnectionWaypoints = function (context) {
    var drdFactory = this._drdFactory;
    var connection = context.connection,
        businessObject = connection.businessObject,
        edge = businessObject.di;
    edge.waypoint = drdFactory.createDiWaypoints(connection.waypoints).map(function (waypoint) {
      waypoint.$parent = edge;
      return waypoint;
    });
  };

  DrdUpdater.prototype.updateParent = function (element, oldParent) {
    var parent = element.parent;

    if (!is(element, 'dmn:DRGElement') && !is(element, 'dmn:Artifact')) {
      parent = oldParent;
    }

    var businessObject = element.businessObject,
        parentBo = parent && parent.businessObject;
    this.updateSemanticParent(businessObject, parentBo);
    this.updateDiParent(businessObject.di, parentBo && parentBo.di);
  };

  DrdUpdater.prototype.updateSemanticParent = function (businessObject, parent) {
    var children, containment;

    if (businessObject.$parent === parent) {
      return;
    }

    if (is(businessObject, 'dmn:DRGElement')) {
      containment = 'drgElement';
    } else if (is(businessObject, 'dmn:Artifact')) {
      containment = 'artifact';
    } else if (is(businessObject, 'dmn:InformationRequirement')) {
      containment = 'informationRequirement';
    } else if (is(businessObject, 'dmn:AuthorityRequirement')) {
      containment = 'authorityRequirement';
    } else if (is(businessObject, 'dmn:KnowledgeRequirement')) {
      containment = 'knowledgeRequirement';
    }

    if (businessObject.$parent) {
      // remove from old parent
      children = businessObject.$parent.get(containment);
      remove$2(children, businessObject);
    }

    if (parent) {
      // add to new parent
      children = parent.get(containment);

      if (children) {
        children.push(businessObject);
        businessObject.$parent = parent;
      }
    } else {
      businessObject.$parent = null;
    }
  };

  DrdUpdater.prototype.updateDiParent = function (di, parentDi) {
    if (di.$parent === parentDi) {
      return;
    }

    if (isAny(di, ['dmndi:DMNEdge', 'dmndi:DMNShape'])) {
      var diagram = parentDi || di;

      while (!is(diagram, 'dmndi:DMNDiagram')) {
        diagram = diagram.$parent;
      }

      var diagramElements = diagram.get('diagramElements');

      if (parentDi) {
        di.$parent = diagram;
        add$1(diagramElements, di);
      } else {
        di.$parent = null;
        remove$2(diagramElements, di);
      }
    } else {
      throw new Error('unsupported');
    }
  };

  /**
   * A handler that align elements in a certain way.
   *
   */

  function AlignElements$1(modeling, canvas) {
    this._modeling = modeling;
    this._canvas = canvas;
  }
  AlignElements$1.$inject = ['modeling', 'canvas'];

  AlignElements$1.prototype.preExecute = function (context) {
    var modeling = this._modeling;
    var elements = context.elements,
        alignment = context.alignment;
    forEach(elements, function (element) {
      var delta = {
        x: 0,
        y: 0
      };

      if (alignment.left) {
        delta.x = alignment.left - element.x;
      } else if (alignment.right) {
        delta.x = alignment.right - element.width - element.x;
      } else if (alignment.center) {
        delta.x = alignment.center - Math.round(element.width / 2) - element.x;
      } else if (alignment.top) {
        delta.y = alignment.top - element.y;
      } else if (alignment.bottom) {
        delta.y = alignment.bottom - element.height - element.y;
      } else if (alignment.middle) {
        delta.y = alignment.middle - Math.round(element.height / 2) - element.y;
      }

      modeling.moveElements([element], delta, element.parent);
    });
  };

  AlignElements$1.prototype.postExecute = function (context) {};

  /**
   * A handler that implements reversible appending of shapes
   * to a source shape.
   *
   * @param {canvas} Canvas
   * @param {elementFactory} ElementFactory
   * @param {modeling} Modeling
   */

  function AppendShapeHandler(modeling) {
    this._modeling = modeling;
  }
  AppendShapeHandler.$inject = ['modeling']; // api //////////////////////

  /**
   * Creates a new shape
   *
   * @param {Object} context
   * @param {ElementDescriptor} context.shape the new shape
   * @param {ElementDescriptor} context.source the source object
   * @param {ElementDescriptor} context.parent the parent object
   * @param {Point} context.position position of the new element
   */

  AppendShapeHandler.prototype.preExecute = function (context) {
    var source = context.source;

    if (!source) {
      throw new Error('source required');
    }

    var target = context.target || source.parent,
        shape = context.shape,
        hints = context.hints || {};
    shape = context.shape = this._modeling.createShape(shape, context.position, target, {
      attach: hints.attach
    });
    context.shape = shape;
  };

  AppendShapeHandler.prototype.postExecute = function (context) {
    var hints = context.hints || {};

    if (!existsConnection(context.source, context.shape)) {
      // create connection
      if (hints.connectionTarget === context.source) {
        this._modeling.connect(context.shape, context.source, context.connection);
      } else {
        this._modeling.connect(context.source, context.shape, context.connection);
      }
    }
  };

  function existsConnection(source, target) {
    return some(source.outgoing, function (c) {
      return c.target === target;
    });
  }

  function CreateConnectionHandler(canvas, layouter) {
    this._canvas = canvas;
    this._layouter = layouter;
  }
  CreateConnectionHandler.$inject = ['canvas', 'layouter']; // api //////////////////////

  /**
   * Appends a shape to a target shape
   *
   * @param {Object} context
   * @param {djs.element.Base} context.source the source object
   * @param {djs.element.Base} context.target the parent object
   * @param {Point} context.position position of the new element
   */

  CreateConnectionHandler.prototype.execute = function (context) {
    var connection = context.connection,
        source = context.source,
        target = context.target,
        parent = context.parent,
        parentIndex = context.parentIndex,
        hints = context.hints;

    if (!source || !target) {
      throw new Error('source and target required');
    }

    if (!parent) {
      throw new Error('parent required');
    }

    connection.source = source;
    connection.target = target;

    if (!connection.waypoints) {
      connection.waypoints = this._layouter.layoutConnection(connection, hints);
    } // add connection


    this._canvas.addConnection(connection, parent, parentIndex);

    return connection;
  };

  CreateConnectionHandler.prototype.revert = function (context) {
    var connection = context.connection;

    this._canvas.removeConnection(connection);

    connection.source = null;
    connection.target = null;
    return connection;
  };

  var round$7 = Math.round;
  function CreateElementsHandler(modeling) {
    this._modeling = modeling;
  }
  CreateElementsHandler.$inject = ['modeling'];

  CreateElementsHandler.prototype.preExecute = function (context) {
    var elements = context.elements,
        parent = context.parent,
        parentIndex = context.parentIndex,
        position = context.position,
        hints = context.hints;
    var modeling = this._modeling; // make sure each element has x and y

    forEach(elements, function (element) {
      if (!isNumber(element.x)) {
        element.x = 0;
      }

      if (!isNumber(element.y)) {
        element.y = 0;
      }
    });
    var bbox = getBBox(elements); // center elements around position

    forEach(elements, function (element) {
      if (isConnection$1(element)) {
        element.waypoints = map(element.waypoints, function (waypoint) {
          return {
            x: round$7(waypoint.x - bbox.x - bbox.width / 2 + position.x),
            y: round$7(waypoint.y - bbox.y - bbox.height / 2 + position.y)
          };
        });
      }

      assign(element, {
        x: round$7(element.x - bbox.x - bbox.width / 2 + position.x),
        y: round$7(element.y - bbox.y - bbox.height / 2 + position.y)
      });
    });
    var parents = getParents(elements);
    var cache = {};
    forEach(elements, function (element) {
      if (isConnection$1(element)) {
        cache[element.id] = isNumber(parentIndex) ? modeling.createConnection(cache[element.source.id], cache[element.target.id], parentIndex, element, element.parent || parent, hints) : modeling.createConnection(cache[element.source.id], cache[element.target.id], element, element.parent || parent, hints);
        return;
      }

      var createShapeHints = assign({}, hints);

      if (parents.indexOf(element) === -1) {
        createShapeHints.autoResize = false;
      }

      cache[element.id] = isNumber(parentIndex) ? modeling.createShape(element, pick(element, ['x', 'y', 'width', 'height']), element.parent || parent, parentIndex, createShapeHints) : modeling.createShape(element, pick(element, ['x', 'y', 'width', 'height']), element.parent || parent, createShapeHints);
    });
    context.elements = values(cache);
  }; // helpers //////////


  function isConnection$1(element) {
    return !!element.waypoints;
  }

  var round$8 = Math.round;
  /**
   * A handler that implements reversible addition of shapes.
   *
   * @param {canvas} Canvas
   */

  function CreateShapeHandler(canvas) {
    this._canvas = canvas;
  }
  CreateShapeHandler.$inject = ['canvas']; // api //////////////////////

  /**
   * Appends a shape to a target shape
   *
   * @param {Object} context
   * @param {djs.model.Base} context.parent the parent object
   * @param {Point} context.position position of the new element
   */

  CreateShapeHandler.prototype.execute = function (context) {
    var shape = context.shape,
        positionOrBounds = context.position,
        parent = context.parent,
        parentIndex = context.parentIndex;

    if (!parent) {
      throw new Error('parent required');
    }

    if (!positionOrBounds) {
      throw new Error('position required');
    } // (1) add at event center position _or_ at given bounds


    if (positionOrBounds.width !== undefined) {
      assign(shape, positionOrBounds);
    } else {
      assign(shape, {
        x: positionOrBounds.x - round$8(shape.width / 2),
        y: positionOrBounds.y - round$8(shape.height / 2)
      });
    } // (2) add to canvas


    this._canvas.addShape(shape, parent, parentIndex);

    return shape;
  };
  /**
   * Undo append by removing the shape
   */


  CreateShapeHandler.prototype.revert = function (context) {
    var shape = context.shape; // (3) remove form canvas

    this._canvas.removeShape(shape);

    return shape;
  };

  /**
   * A handler that attaches a label to a given target shape.
   *
   * @param {Canvas} canvas
   */

  function CreateLabelHandler(canvas) {
    CreateShapeHandler.call(this, canvas);
  }
  inherits_browser$1(CreateLabelHandler, CreateShapeHandler);
  CreateLabelHandler.$inject = ['canvas']; // api //////////////////////

  var originalExecute = CreateShapeHandler.prototype.execute;
  /**
   * Appends a label to a target shape.
   *
   * @method CreateLabelHandler#execute
   *
   * @param {Object} context
   * @param {ElementDescriptor} context.target the element the label is attached to
   * @param {ElementDescriptor} context.parent the parent object
   * @param {Point} context.position position of the new element
   */

  CreateLabelHandler.prototype.execute = function (context) {
    var label = context.shape;
    ensureValidDimensions(label);
    label.labelTarget = context.labelTarget;
    return originalExecute.call(this, context);
  };

  var originalRevert = CreateShapeHandler.prototype.revert;
  /**
   * Undo append by removing the shape
   */

  CreateLabelHandler.prototype.revert = function (context) {
    context.shape.labelTarget = null;
    return originalRevert.call(this, context);
  }; // helpers //////////////////////


  function ensureValidDimensions(label) {
    // make sure a label has valid { width, height } dimensions
    ['width', 'height'].forEach(function (prop) {
      if (typeof label[prop] === 'undefined') {
        label[prop] = 0;
      }
    });
  }

  /**
   * A handler that implements reversible deletion of Connections.
   */

  function DeleteConnectionHandler(canvas, modeling) {
    this._canvas = canvas;
    this._modeling = modeling;
  }
  DeleteConnectionHandler.$inject = ['canvas', 'modeling'];

  DeleteConnectionHandler.prototype.execute = function (context) {
    var connection = context.connection,
        parent = connection.parent;
    context.parent = parent; // remember containment

    context.parentIndex = indexOf$1(parent.children, connection);
    context.source = connection.source;
    context.target = connection.target;

    this._canvas.removeConnection(connection);

    connection.source = null;
    connection.target = null;
    return connection;
  };
  /**
   * Command revert implementation.
   */


  DeleteConnectionHandler.prototype.revert = function (context) {
    var connection = context.connection,
        parent = context.parent,
        parentIndex = context.parentIndex;
    connection.source = context.source;
    connection.target = context.target; // restore containment

    add$1(parent.children, connection, parentIndex);

    this._canvas.addConnection(connection, parent);

    return connection;
  };

  function DeleteElementsHandler(modeling, elementRegistry) {
    this._modeling = modeling;
    this._elementRegistry = elementRegistry;
  }
  DeleteElementsHandler.$inject = ['modeling', 'elementRegistry'];

  DeleteElementsHandler.prototype.postExecute = function (context) {
    var modeling = this._modeling,
        elementRegistry = this._elementRegistry,
        elements = context.elements;
    forEach(elements, function (element) {
      // element may have been removed with previous
      // remove operations already (e.g. in case of nesting)
      if (!elementRegistry.get(element.id)) {
        return;
      }

      if (element.waypoints) {
        modeling.removeConnection(element);
      } else {
        modeling.removeShape(element);
      }
    });
  };

  /**
   * Remove from the beginning of a collection until it is empty.
   *
   * This is a null-safe operation that ensures elements
   * are being removed from the given collection until the
   * collection is empty.
   *
   * The implementation deals with the fact that a remove operation
   * may touch, i.e. remove multiple elements in the collection
   * at a time.
   *
   * @param {Array<Object>} [collection]
   * @param {Function} removeFn
   *
   * @return {Array<Object>} the cleared collection
   */
  function saveClear(collection, removeFn) {
    if (typeof removeFn !== 'function') {
      throw new Error('removeFn iterator must be a function');
    }

    if (!collection) {
      return;
    }

    var e;

    while (e = collection[0]) {
      removeFn(e);
    }

    return collection;
  }

  /**
   * A handler that implements reversible deletion of shapes.
   *
   */

  function DeleteShapeHandler(canvas, modeling) {
    this._canvas = canvas;
    this._modeling = modeling;
  }
  DeleteShapeHandler.$inject = ['canvas', 'modeling'];
  /**
   * - Remove connections
   * - Remove all direct children
   */

  DeleteShapeHandler.prototype.preExecute = function (context) {
    var modeling = this._modeling;
    var shape = context.shape; // remove connections

    saveClear(shape.incoming, function (connection) {
      // To make sure that the connection isn't removed twice
      // For example if a container is removed
      modeling.removeConnection(connection, {
        nested: true
      });
    });
    saveClear(shape.outgoing, function (connection) {
      modeling.removeConnection(connection, {
        nested: true
      });
    }); // remove child shapes and connections

    saveClear(shape.children, function (child) {
      if (isConnection$2(child)) {
        modeling.removeConnection(child, {
          nested: true
        });
      } else {
        modeling.removeShape(child, {
          nested: true
        });
      }
    });
  };
  /**
   * Remove shape and remember the parent
   */


  DeleteShapeHandler.prototype.execute = function (context) {
    var canvas = this._canvas;
    var shape = context.shape,
        oldParent = shape.parent;
    context.oldParent = oldParent; // remove containment

    context.oldParentIndex = indexOf$1(oldParent.children, shape); // remove shape

    canvas.removeShape(shape);
    return shape;
  };
  /**
   * Command revert implementation
   */


  DeleteShapeHandler.prototype.revert = function (context) {
    var canvas = this._canvas;
    var shape = context.shape,
        oldParent = context.oldParent,
        oldParentIndex = context.oldParentIndex; // restore containment

    add$1(oldParent.children, shape, oldParentIndex);
    canvas.addShape(shape, oldParent);
    return shape;
  };

  function isConnection$2(element) {
    return element.waypoints;
  }

  /**
   * A handler that distributes elements evenly.
   */

  function DistributeElements$1(modeling) {
    this._modeling = modeling;
  }
  DistributeElements$1.$inject = ['modeling'];
  var OFF_AXIS = {
    x: 'y',
    y: 'x'
  };

  DistributeElements$1.prototype.preExecute = function (context) {
    var modeling = this._modeling;
    var groups = context.groups,
        axis = context.axis,
        dimension = context.dimension;

    function updateRange(group, element) {
      group.range.min = Math.min(element[axis], group.range.min);
      group.range.max = Math.max(element[axis] + element[dimension], group.range.max);
    }

    function center(element) {
      return element[axis] + element[dimension] / 2;
    }

    function lastIdx(arr) {
      return arr.length - 1;
    }

    function rangeDiff(range) {
      return range.max - range.min;
    }

    function centerElement(refCenter, element) {
      var delta = {
        y: 0
      };
      delta[axis] = refCenter - center(element);

      if (delta[axis]) {
        delta[OFF_AXIS[axis]] = 0;
        modeling.moveElements([element], delta, element.parent);
      }
    }

    var firstGroup = groups[0],
        lastGroupIdx = lastIdx(groups),
        lastGroup = groups[lastGroupIdx];
    var margin,
        spaceInBetween,
        groupsSize = 0; // the size of each range

    forEach(groups, function (group, idx) {
      var sortedElements, refElem, refCenter;

      if (group.elements.length < 2) {
        if (idx && idx !== groups.length - 1) {
          updateRange(group, group.elements[0]);
          groupsSize += rangeDiff(group.range);
        }

        return;
      }

      sortedElements = sortBy(group.elements, axis);
      refElem = sortedElements[0];

      if (idx === lastGroupIdx) {
        refElem = sortedElements[lastIdx(sortedElements)];
      }

      refCenter = center(refElem); // wanna update the ranges after the shapes have been centered

      group.range = null;
      forEach(sortedElements, function (element) {
        centerElement(refCenter, element);

        if (group.range === null) {
          group.range = {
            min: element[axis],
            max: element[axis] + element[dimension]
          };
          return;
        } // update group's range after centering the range elements


        updateRange(group, element);
      });

      if (idx && idx !== groups.length - 1) {
        groupsSize += rangeDiff(group.range);
      }
    });
    spaceInBetween = Math.abs(lastGroup.range.min - firstGroup.range.max);
    margin = Math.round((spaceInBetween - groupsSize) / (groups.length - 1));

    if (margin < groups.length - 1) {
      return;
    }

    forEach(groups, function (group, groupIdx) {
      var delta = {},
          prevGroup;

      if (group === firstGroup || group === lastGroup) {
        return;
      }

      prevGroup = groups[groupIdx - 1];
      group.range.max = 0;
      forEach(group.elements, function (element, idx) {
        delta[OFF_AXIS[axis]] = 0;
        delta[axis] = prevGroup.range.max - element[axis] + margin;

        if (group.range.min !== element[axis]) {
          delta[axis] += element[axis] - group.range.min;
        }

        if (delta[axis]) {
          modeling.moveElements([element], delta, element.parent);
        }

        group.range.max = Math.max(element[axis] + element[dimension], idx ? group.range.max : 0);
      });
    });
  };

  DistributeElements$1.prototype.postExecute = function (context) {};

  /**
   * A handler that implements reversible moving of shapes.
   */

  function LayoutConnectionHandler(layouter, canvas) {
    this._layouter = layouter;
    this._canvas = canvas;
  }
  LayoutConnectionHandler.$inject = ['layouter', 'canvas'];

  LayoutConnectionHandler.prototype.execute = function (context) {
    var connection = context.connection;
    var oldWaypoints = connection.waypoints;
    assign(context, {
      oldWaypoints: oldWaypoints
    });
    connection.waypoints = this._layouter.layoutConnection(connection, context.hints);
    return connection;
  };

  LayoutConnectionHandler.prototype.revert = function (context) {
    var connection = context.connection;
    connection.waypoints = context.oldWaypoints;
    return connection;
  };

  /**
   * A handler that implements reversible moving of connections.
   *
   * The handler differs from the layout connection handler in a sense
   * that it preserves the connection layout.
   */

  function MoveConnectionHandler() {}

  MoveConnectionHandler.prototype.execute = function (context) {
    var connection = context.connection,
        delta = context.delta;
    var newParent = context.newParent || connection.parent,
        newParentIndex = context.newParentIndex,
        oldParent = connection.parent; // save old parent in context

    context.oldParent = oldParent;
    context.oldParentIndex = remove$2(oldParent.children, connection); // add to new parent at position

    add$1(newParent.children, connection, newParentIndex); // update parent

    connection.parent = newParent; // update waypoint positions

    forEach(connection.waypoints, function (p) {
      p.x += delta.x;
      p.y += delta.y;

      if (p.original) {
        p.original.x += delta.x;
        p.original.y += delta.y;
      }
    });
    return connection;
  };

  MoveConnectionHandler.prototype.revert = function (context) {
    var connection = context.connection,
        newParent = connection.parent,
        oldParent = context.oldParent,
        oldParentIndex = context.oldParentIndex,
        delta = context.delta; // remove from newParent

    remove$2(newParent.children, connection); // restore previous location in old parent

    add$1(oldParent.children, connection, oldParentIndex); // restore parent

    connection.parent = oldParent; // revert to old waypoint positions

    forEach(connection.waypoints, function (p) {
      p.x -= delta.x;
      p.y -= delta.y;

      if (p.original) {
        p.original.x -= delta.x;
        p.original.y -= delta.y;
      }
    });
    return connection;
  };

  /**
   * Calculates the absolute point relative to the new element's position
   *
   * @param {point} point [absolute]
   * @param {bounds} oldBounds
   * @param {bounds} newBounds
   *
   * @return {point} point [absolute]
   */

  function getNewAttachPoint(point, oldBounds, newBounds) {
    var oldCenter = center(oldBounds),
        newCenter = center(newBounds),
        oldDelta = delta(point, oldCenter);
    var newDelta = {
      x: oldDelta.x * (newBounds.width / oldBounds.width),
      y: oldDelta.y * (newBounds.height / oldBounds.height)
    };
    return roundPoint({
      x: newCenter.x + newDelta.x,
      y: newCenter.y + newDelta.y
    });
  }

  function getResizedSourceAnchor(connection, shape, oldBounds) {
    var waypoints = safeGetWaypoints(connection),
        waypointsInsideNewBounds = getWaypointsInsideBounds(waypoints, shape),
        oldAnchor = waypoints[0]; // new anchor is the last waypoint enclosed be resized source

    if (waypointsInsideNewBounds.length) {
      return waypointsInsideNewBounds[waypointsInsideNewBounds.length - 1];
    }

    return getNewAttachPoint(oldAnchor.original || oldAnchor, oldBounds, shape);
  }
  function getResizedTargetAnchor(connection, shape, oldBounds) {
    var waypoints = safeGetWaypoints(connection),
        waypointsInsideNewBounds = getWaypointsInsideBounds(waypoints, shape),
        oldAnchor = waypoints[waypoints.length - 1]; // new anchor is the first waypoint enclosed be resized target

    if (waypointsInsideNewBounds.length) {
      return waypointsInsideNewBounds[0];
    }

    return getNewAttachPoint(oldAnchor.original || oldAnchor, oldBounds, shape);
  }
  function getMovedSourceAnchor(connection, source, moveDelta) {
    var waypoints = safeGetWaypoints(connection),
        oldBounds = subtract(source, moveDelta),
        oldAnchor = waypoints[0];
    return getNewAttachPoint(oldAnchor.original || oldAnchor, oldBounds, source);
  }
  function getMovedTargetAnchor(connection, target, moveDelta) {
    var waypoints = safeGetWaypoints(connection),
        oldBounds = subtract(target, moveDelta),
        oldAnchor = waypoints[waypoints.length - 1];
    return getNewAttachPoint(oldAnchor.original || oldAnchor, oldBounds, target);
  } // helpers //////////////////////

  function subtract(bounds, delta) {
    return {
      x: bounds.x - delta.x,
      y: bounds.y - delta.y,
      width: bounds.width,
      height: bounds.height
    };
  }
  /**
   * Return waypoints of given connection; throw if non exists (should not happen!!).
   *
   * @param {Connection} connection
   *
   * @return {Array<Point>}
   */


  function safeGetWaypoints(connection) {
    var waypoints = connection.waypoints;

    if (!waypoints.length) {
      throw new Error('connection#' + connection.id + ': no waypoints');
    }

    return waypoints;
  }

  function getWaypointsInsideBounds(waypoints, bounds) {
    var originalWaypoints = map(waypoints, getOriginal$1);
    return filter(originalWaypoints, function (waypoint) {
      return isInsideBounds(waypoint, bounds);
    });
  }
  /**
   * Checks if point is inside bounds, incl. edges.
   *
   * @param {Point} point
   * @param {Bounds} bounds
   */


  function isInsideBounds(point, bounds) {
    return getOrientation(bounds, point, 1) === 'intersect';
  }

  function getOriginal$1(point) {
    return point.original || point;
  }

  function MoveClosure() {
    this.allShapes = {};
    this.allConnections = {};
    this.enclosedElements = {};
    this.enclosedConnections = {};
    this.topLevel = {};
  }

  MoveClosure.prototype.add = function (element, isTopLevel) {
    return this.addAll([element], isTopLevel);
  };

  MoveClosure.prototype.addAll = function (elements, isTopLevel) {
    var newClosure = getClosure(elements, !!isTopLevel, this);
    assign(this, newClosure);
    return this;
  };

  /**
   * A helper that is able to carry out serialized move
   * operations on multiple elements.
   *
   * @param {Modeling} modeling
   */

  function MoveHelper(modeling) {
    this._modeling = modeling;
  }
  /**
   * Move the specified elements and all children by the given delta.
   *
   * This moves all enclosed connections, too and layouts all affected
   * external connections.
   *
   * @param  {Array<djs.model.Base>} elements
   * @param  {Point} delta
   * @param  {djs.model.Base} newParent applied to the first level of shapes
   *
   * @return {Array<djs.model.Base>} list of touched elements
   */

  MoveHelper.prototype.moveRecursive = function (elements, delta, newParent) {
    if (!elements) {
      return [];
    } else {
      return this.moveClosure(this.getClosure(elements), delta, newParent);
    }
  };
  /**
   * Move the given closure of elmements.
   *
   * @param {Object} closure
   * @param {Point} delta
   * @param {djs.model.Base} [newParent]
   * @param {djs.model.Base} [newHost]
   */


  MoveHelper.prototype.moveClosure = function (closure, delta, newParent, newHost, primaryShape) {
    var modeling = this._modeling;
    var allShapes = closure.allShapes,
        allConnections = closure.allConnections,
        enclosedConnections = closure.enclosedConnections,
        topLevel = closure.topLevel,
        keepParent = false;

    if (primaryShape && primaryShape.parent === newParent) {
      keepParent = true;
    } // move all shapes


    forEach(allShapes, function (shape) {
      // move the element according to the given delta
      modeling.moveShape(shape, delta, topLevel[shape.id] && !keepParent && newParent, {
        recurse: false,
        layout: false
      });
    }); // move all child connections / layout external connections

    forEach(allConnections, function (c) {
      var sourceMoved = !!allShapes[c.source.id],
          targetMoved = !!allShapes[c.target.id];

      if (enclosedConnections[c.id] && sourceMoved && targetMoved) {
        modeling.moveConnection(c, delta, topLevel[c.id] && !keepParent && newParent);
      } else {
        modeling.layoutConnection(c, {
          connectionStart: sourceMoved && getMovedSourceAnchor(c, c.source, delta),
          connectionEnd: targetMoved && getMovedTargetAnchor(c, c.target, delta)
        });
      }
    });
  };
  /**
   * Returns the closure for the selected elements
   *
   * @param  {Array<djs.model.Base>} elements
   * @return {MoveClosure} closure
   */


  MoveHelper.prototype.getClosure = function (elements) {
    return new MoveClosure().addAll(elements, true);
  };

  /**
   * A handler that implements reversible moving of shapes.
   */

  function MoveElementsHandler(modeling) {
    this._helper = new MoveHelper(modeling);
  }
  MoveElementsHandler.$inject = ['modeling'];

  MoveElementsHandler.prototype.preExecute = function (context) {
    context.closure = this._helper.getClosure(context.shapes);
  };

  MoveElementsHandler.prototype.postExecute = function (context) {
    var hints = context.hints,
        primaryShape;

    if (hints && hints.primaryShape) {
      primaryShape = hints.primaryShape;
      hints.oldParent = primaryShape.parent;
    }

    this._helper.moveClosure(context.closure, context.delta, context.newParent, context.newHost, primaryShape);
  };

  /**
   * A handler that implements reversible moving of shapes.
   */

  function MoveShapeHandler(modeling) {
    this._modeling = modeling;
    this._helper = new MoveHelper(modeling);
  }
  MoveShapeHandler.$inject = ['modeling'];

  MoveShapeHandler.prototype.execute = function (context) {
    var shape = context.shape,
        delta = context.delta,
        newParent = context.newParent || shape.parent,
        newParentIndex = context.newParentIndex,
        oldParent = shape.parent;
    context.oldBounds = pick(shape, ['x', 'y', 'width', 'height']); // save old parent in context

    context.oldParent = oldParent;
    context.oldParentIndex = remove$2(oldParent.children, shape); // add to new parent at position

    add$1(newParent.children, shape, newParentIndex); // update shape parent + position

    assign(shape, {
      parent: newParent,
      x: shape.x + delta.x,
      y: shape.y + delta.y
    });
    return shape;
  };

  MoveShapeHandler.prototype.postExecute = function (context) {
    var shape = context.shape,
        delta = context.delta,
        hints = context.hints;
    var modeling = this._modeling;

    if (hints.layout !== false) {
      forEach(shape.incoming, function (c) {
        modeling.layoutConnection(c, {
          connectionEnd: getMovedTargetAnchor(c, shape, delta)
        });
      });
      forEach(shape.outgoing, function (c) {
        modeling.layoutConnection(c, {
          connectionStart: getMovedSourceAnchor(c, shape, delta)
        });
      });
    }

    if (hints.recurse !== false) {
      this.moveChildren(context);
    }
  };

  MoveShapeHandler.prototype.revert = function (context) {
    var shape = context.shape,
        oldParent = context.oldParent,
        oldParentIndex = context.oldParentIndex,
        delta = context.delta; // restore previous location in old parent

    add$1(oldParent.children, shape, oldParentIndex); // revert to old position and parent

    assign(shape, {
      parent: oldParent,
      x: shape.x - delta.x,
      y: shape.y - delta.y
    });
    return shape;
  };

  MoveShapeHandler.prototype.moveChildren = function (context) {
    var delta = context.delta,
        shape = context.shape;

    this._helper.moveRecursive(shape.children, delta, null);
  };

  MoveShapeHandler.prototype.getNewParent = function (context) {
    return context.newParent || context.shape.parent;
  };

  /**
   * Reconnect connection handler
   */

  function ReconnectConnectionHandler(modeling) {
    this._modeling = modeling;
  }
  ReconnectConnectionHandler.$inject = ['modeling'];

  ReconnectConnectionHandler.prototype.execute = function (context) {
    var newSource = context.newSource,
        newTarget = context.newTarget,
        connection = context.connection,
        dockingOrPoints = context.dockingOrPoints;

    if (!newSource && !newTarget) {
      throw new Error('newSource or newTarget required');
    }

    if (isArray(dockingOrPoints)) {
      context.oldWaypoints = connection.waypoints;
      connection.waypoints = dockingOrPoints;
    }

    if (newSource) {
      context.oldSource = connection.source;
      connection.source = newSource;
    }

    if (newTarget) {
      context.oldTarget = connection.target;
      connection.target = newTarget;
    }

    return connection;
  };

  ReconnectConnectionHandler.prototype.postExecute = function (context) {
    var connection = context.connection,
        newSource = context.newSource,
        newTarget = context.newTarget,
        dockingOrPoints = context.dockingOrPoints,
        hints = context.hints || {};
    var layoutConnectionHints = {};

    if (hints.connectionStart) {
      layoutConnectionHints.connectionStart = hints.connectionStart;
    }

    if (hints.connectionEnd) {
      layoutConnectionHints.connectionEnd = hints.connectionEnd;
    }

    if (hints.layoutConnection === false) {
      return;
    }

    if (newSource && (!newTarget || hints.docking === 'source')) {
      layoutConnectionHints.connectionStart = layoutConnectionHints.connectionStart || getDocking$1(isArray(dockingOrPoints) ? dockingOrPoints[0] : dockingOrPoints);
    }

    if (newTarget && (!newSource || hints.docking === 'target')) {
      layoutConnectionHints.connectionEnd = layoutConnectionHints.connectionEnd || getDocking$1(isArray(dockingOrPoints) ? dockingOrPoints[dockingOrPoints.length - 1] : dockingOrPoints);
    }

    if (hints.newWaypoints) {
      layoutConnectionHints.waypoints = hints.newWaypoints;
    }

    this._modeling.layoutConnection(connection, layoutConnectionHints);
  };

  ReconnectConnectionHandler.prototype.revert = function (context) {
    var oldSource = context.oldSource,
        oldTarget = context.oldTarget,
        oldWaypoints = context.oldWaypoints,
        connection = context.connection;

    if (oldSource) {
      connection.source = oldSource;
    }

    if (oldTarget) {
      connection.target = oldTarget;
    }

    if (oldWaypoints) {
      connection.waypoints = oldWaypoints;
    }

    return connection;
  }; // helpers //////////


  function getDocking$1(point) {
    return point.original || point;
  }

  /**
   * Replace shape by adding new shape and removing old shape. Incoming and outgoing connections will
   * be kept if possible.
   *
   * @class
   * @constructor
   *
   * @param {Modeling} modeling
   * @param {Rules} rules
   */

  function ReplaceShapeHandler(modeling, rules) {
    this._modeling = modeling;
    this._rules = rules;
  }
  ReplaceShapeHandler.$inject = ['modeling', 'rules'];
  /**
   * Add new shape.
   *
   * @param {Object} context
   * @param {djs.model.Shape} context.oldShape
   * @param {Object} context.newData
   * @param {string} context.newData.type
   * @param {number} context.newData.x
   * @param {number} context.newData.y
   * @param {Object} [hints]
   */

  ReplaceShapeHandler.prototype.preExecute = function (context) {
    var self = this,
        modeling = this._modeling,
        rules = this._rules;
    var oldShape = context.oldShape,
        newData = context.newData,
        hints = context.hints || {},
        newShape;

    function canReconnect(source, target, connection) {
      return rules.allowed('connection.reconnect', {
        connection: connection,
        source: source,
        target: target
      });
    } // (1) add new shape at given position


    var position = {
      x: newData.x,
      y: newData.y
    };
    var oldBounds = {
      x: oldShape.x,
      y: oldShape.y,
      width: oldShape.width,
      height: oldShape.height
    };
    newShape = context.newShape = context.newShape || self.createShape(newData, position, oldShape.parent, hints); // (2) update host

    if (oldShape.host) {
      modeling.updateAttachment(newShape, oldShape.host);
    } // (3) adopt all children from old shape


    var children;

    if (hints.moveChildren !== false) {
      children = oldShape.children.slice();
      modeling.moveElements(children, {
        x: 0,
        y: 0
      }, newShape, hints);
    } // (4) reconnect connections to new shape if possible


    var incoming = oldShape.incoming.slice(),
        outgoing = oldShape.outgoing.slice();
    forEach(incoming, function (connection) {
      var source = connection.source,
          allowed = canReconnect(source, newShape, connection);

      if (allowed) {
        self.reconnectEnd(connection, newShape, getResizedTargetAnchor(connection, newShape, oldBounds), hints);
      }
    });
    forEach(outgoing, function (connection) {
      var target = connection.target,
          allowed = canReconnect(newShape, target, connection);

      if (allowed) {
        self.reconnectStart(connection, newShape, getResizedSourceAnchor(connection, newShape, oldBounds), hints);
      }
    });
  };
  /**
   * Remove old shape.
   */


  ReplaceShapeHandler.prototype.postExecute = function (context) {
    var oldShape = context.oldShape;

    this._modeling.removeShape(oldShape);
  };

  ReplaceShapeHandler.prototype.execute = function (context) {};

  ReplaceShapeHandler.prototype.revert = function (context) {};

  ReplaceShapeHandler.prototype.createShape = function (shape, position, target, hints) {
    return this._modeling.createShape(shape, position, target, hints);
  };

  ReplaceShapeHandler.prototype.reconnectStart = function (connection, newSource, dockingPoint, hints) {
    this._modeling.reconnectStart(connection, newSource, dockingPoint, hints);
  };

  ReplaceShapeHandler.prototype.reconnectEnd = function (connection, newTarget, dockingPoint, hints) {
    this._modeling.reconnectEnd(connection, newTarget, dockingPoint, hints);
  };

  /**
   * A handler that implements reversible resizing of shapes.
   *
   * @param {Modeling} modeling
   */

  function ResizeShapeHandler(modeling) {
    this._modeling = modeling;
  }
  ResizeShapeHandler.$inject = ['modeling'];
  /**
   * {
   *   shape: {....}
   *   newBounds: {
   *     width:  20,
   *     height: 40,
   *     x:       5,
   *     y:      10
   *   }
   *
   * }
   */

  ResizeShapeHandler.prototype.execute = function (context) {
    var shape = context.shape,
        newBounds = context.newBounds,
        minBounds = context.minBounds;

    if (newBounds.x === undefined || newBounds.y === undefined || newBounds.width === undefined || newBounds.height === undefined) {
      throw new Error('newBounds must have {x, y, width, height} properties');
    }

    if (minBounds && (newBounds.width < minBounds.width || newBounds.height < minBounds.height)) {
      throw new Error('width and height cannot be less than minimum height and width');
    } else if (!minBounds && newBounds.width < 10 || newBounds.height < 10) {
      throw new Error('width and height cannot be less than 10px');
    } // save old bbox in context


    context.oldBounds = {
      width: shape.width,
      height: shape.height,
      x: shape.x,
      y: shape.y
    }; // update shape

    assign(shape, {
      width: newBounds.width,
      height: newBounds.height,
      x: newBounds.x,
      y: newBounds.y
    });
    return shape;
  };

  ResizeShapeHandler.prototype.postExecute = function (context) {
    var modeling = this._modeling;
    var shape = context.shape,
        oldBounds = context.oldBounds,
        hints = context.hints || {};

    if (hints.layout === false) {
      return;
    }

    forEach(shape.incoming, function (c) {
      modeling.layoutConnection(c, {
        connectionEnd: getResizedTargetAnchor(c, shape, oldBounds)
      });
    });
    forEach(shape.outgoing, function (c) {
      modeling.layoutConnection(c, {
        connectionStart: getResizedSourceAnchor(c, shape, oldBounds)
      });
    });
  };

  ResizeShapeHandler.prototype.revert = function (context) {
    var shape = context.shape,
        oldBounds = context.oldBounds; // restore previous bbox

    assign(shape, {
      width: oldBounds.width,
      height: oldBounds.height,
      x: oldBounds.x,
      y: oldBounds.y
    });
    return shape;
  };

  /**
   * Returns connections whose waypoints are to be updated. Waypoints are to be updated if start
   * or end is to be moved or resized.
   *
   * @param {Array<djs.model.Shape} movingShapes
   * @param {Array<djs.model.Shape} resizingShapes
   *
   * @returns {Array<djs.model.Connection>}
   */

  function getWaypointsUpdatingConnections(movingShapes, resizingShapes) {
    var waypointsUpdatingConnections = [];
    forEach(movingShapes.concat(resizingShapes), function (shape) {
      var incoming = shape.incoming,
          outgoing = shape.outgoing;
      forEach(incoming.concat(outgoing), function (connection) {
        var source = connection.source,
            target = connection.target;

        if (includes(movingShapes, source) || includes(movingShapes, target) || includes(resizingShapes, source) || includes(resizingShapes, target)) {
          if (!includes(waypointsUpdatingConnections, connection)) {
            waypointsUpdatingConnections.push(connection);
          }
        }
      });
    });
    return waypointsUpdatingConnections;
  }

  function includes(array, item) {
    return array.indexOf(item) !== -1;
  }
  /**
   * Resize bounds.
   *
   * @param {Object} bounds
   * @param {number} bounds.x
   * @param {number} bounds.y
   * @param {number} bounds.width
   * @param {number} bounds.height
   * @param {string} direction
   * @param {Object} delta
   * @param {number} delta.x
   * @param {number} delta.y
   *
   * @return {Object}
   */


  function resizeBounds(bounds, direction, delta) {
    var x = bounds.x,
        y = bounds.y,
        width = bounds.width,
        height = bounds.height,
        dx = delta.x,
        dy = delta.y;

    switch (direction) {
      case 'n':
        return {
          x: x,
          y: y + dy,
          width: width,
          height: height - dy
        };

      case 's':
        return {
          x: x,
          y: y,
          width: width,
          height: height + dy
        };

      case 'w':
        return {
          x: x + dx,
          y: y,
          width: width - dx,
          height: height
        };

      case 'e':
        return {
          x: x,
          y: y,
          width: width + dx,
          height: height
        };

      default:
        throw new Error('unknown direction: ' + direction);
    }
  }

  /**
   * Add or remove space by moving and resizing shapes and updating connection waypoints.
   */

  function SpaceToolHandler(modeling) {
    this._modeling = modeling;
  }
  SpaceToolHandler.$inject = ['modeling'];

  SpaceToolHandler.prototype.preExecute = function (context) {
    var delta = context.delta,
        direction = context.direction,
        movingShapes = context.movingShapes,
        resizingShapes = context.resizingShapes,
        start = context.start,
        oldBounds = {}; // (1) move shapes

    this.moveShapes(movingShapes, delta); // (2a) save old bounds of resized shapes

    forEach(resizingShapes, function (shape) {
      oldBounds[shape.id] = getBounds(shape);
    }); // (2b) resize shapes

    this.resizeShapes(resizingShapes, delta, direction); // (3) update connection waypoints

    this.updateConnectionWaypoints(getWaypointsUpdatingConnections(movingShapes, resizingShapes), delta, direction, start, movingShapes, resizingShapes, oldBounds);
  };

  SpaceToolHandler.prototype.execute = function () {};

  SpaceToolHandler.prototype.revert = function () {};

  SpaceToolHandler.prototype.moveShapes = function (shapes, delta) {
    var self = this;
    forEach(shapes, function (element) {
      self._modeling.moveShape(element, delta, null, {
        autoResize: false,
        layout: false,
        recurse: false
      });
    });
  };

  SpaceToolHandler.prototype.resizeShapes = function (shapes, delta, direction) {
    var self = this;
    forEach(shapes, function (shape) {
      var newBounds = resizeBounds(shape, direction, delta);

      self._modeling.resizeShape(shape, newBounds, null, {
        attachSupport: false,
        autoResize: false,
        layout: false
      });
    });
  };
  /**
   * Update connections waypoints according to the rules:
   *   1. Both source and target are moved/resized => move waypoints by the delta
   *   2. Only one of source and target is moved/resized => re-layout connection with moved start/end
   */


  SpaceToolHandler.prototype.updateConnectionWaypoints = function (connections, delta, direction, start, movingShapes, resizingShapes, oldBounds) {
    var self = this,
        affectedShapes = movingShapes.concat(resizingShapes);
    forEach(connections, function (connection) {
      var source = connection.source,
          target = connection.target,
          waypoints = copyWaypoints(connection),
          axis = getAxisFromDirection(direction),
          layoutHints = {
        labelBehavior: false
      };

      if (includes$1(affectedShapes, source) && includes$1(affectedShapes, target)) {
        // move waypoints
        waypoints = map(waypoints, function (waypoint) {
          if (shouldMoveWaypoint(waypoint, start, direction)) {
            // move waypoint
            waypoint[axis] = waypoint[axis] + delta[axis];
          }

          if (waypoint.original && shouldMoveWaypoint(waypoint.original, start, direction)) {
            // move waypoint original
            waypoint.original[axis] = waypoint.original[axis] + delta[axis];
          }

          return waypoint;
        });

        self._modeling.updateWaypoints(connection, waypoints, {
          labelBehavior: false
        });
      } else if (includes$1(affectedShapes, source) || includes$1(affectedShapes, target)) {
        // re-layout connection with moved start/end
        if (includes$1(movingShapes, source)) {
          layoutHints.connectionStart = getMovedSourceAnchor(connection, source, delta);
        } else if (includes$1(movingShapes, target)) {
          layoutHints.connectionEnd = getMovedTargetAnchor(connection, target, delta);
        } else if (includes$1(resizingShapes, source)) {
          layoutHints.connectionStart = getResizedSourceAnchor(connection, source, oldBounds[source.id]);
        } else if (includes$1(resizingShapes, target)) {
          layoutHints.connectionEnd = getResizedTargetAnchor(connection, target, oldBounds[target.id]);
        }

        self._modeling.layoutConnection(connection, layoutHints);
      }
    });
  }; // helpers //////////


  function copyWaypoint(waypoint) {
    return assign({}, waypoint);
  }

  function copyWaypoints(connection) {
    return map(connection.waypoints, function (waypoint) {
      waypoint = copyWaypoint(waypoint);

      if (waypoint.original) {
        waypoint.original = copyWaypoint(waypoint.original);
      }

      return waypoint;
    });
  }

  function getAxisFromDirection(direction) {
    switch (direction) {
      case 'n':
        return 'y';

      case 'w':
        return 'x';

      case 's':
        return 'y';

      case 'e':
        return 'x';
    }
  }

  function shouldMoveWaypoint(waypoint, start, direction) {
    var relevantAxis = getAxisFromDirection(direction);

    if (/e|s/.test(direction)) {
      return waypoint[relevantAxis] > start;
    } else if (/n|w/.test(direction)) {
      return waypoint[relevantAxis] < start;
    }
  }

  function includes$1(array, item) {
    return array.indexOf(item) !== -1;
  }

  function getBounds(shape) {
    return {
      x: shape.x,
      y: shape.y,
      height: shape.height,
      width: shape.width
    };
  }

  /**
   * A handler that toggles the collapsed state of an element
   * and the visibility of all its children.
   *
   * @param {Modeling} modeling
   */

  function ToggleShapeCollapseHandler(modeling) {
    this._modeling = modeling;
  }
  ToggleShapeCollapseHandler.$inject = ['modeling'];

  ToggleShapeCollapseHandler.prototype.execute = function (context) {
    var shape = context.shape,
        children = shape.children; // recursively remember previous visibility of children

    context.oldChildrenVisibility = getElementsVisibilityRecursive(children); // toggle state

    shape.collapsed = !shape.collapsed; // recursively hide/show children

    var result = setHiddenRecursive(children, shape.collapsed);
    return [shape].concat(result);
  };

  ToggleShapeCollapseHandler.prototype.revert = function (context) {
    var shape = context.shape,
        oldChildrenVisibility = context.oldChildrenVisibility;
    var children = shape.children; // recursively set old visability of children

    var result = restoreVisibilityRecursive(children, oldChildrenVisibility); // retoggle state

    shape.collapsed = !shape.collapsed;
    return [shape].concat(result);
  }; // helpers //////////////////////

  /**
   * Return a map { elementId -> hiddenState}.
   *
   * @param {Array<djs.model.Shape>} elements
   *
   * @return {Object}
   */


  function getElementsVisibilityRecursive(elements) {
    var result = {};
    forEach(elements, function (element) {
      result[element.id] = element.hidden;

      if (element.children) {
        result = assign({}, result, getElementsVisibilityRecursive(element.children));
      }
    });
    return result;
  }

  function setHiddenRecursive(elements, newHidden) {
    var result = [];
    forEach(elements, function (element) {
      element.hidden = newHidden;
      result = result.concat(element);

      if (element.children) {
        result = result.concat(setHiddenRecursive(element.children, element.collapsed || newHidden));
      }
    });
    return result;
  }

  function restoreVisibilityRecursive(elements, lastState) {
    var result = [];
    forEach(elements, function (element) {
      element.hidden = lastState[element.id];
      result = result.concat(element);

      if (element.children) {
        result = result.concat(restoreVisibilityRecursive(element.children, lastState));
      }
    });
    return result;
  }

  /**
   * A handler that implements reversible attaching/detaching of shapes.
   */

  function UpdateAttachmentHandler(modeling) {
    this._modeling = modeling;
  }
  UpdateAttachmentHandler.$inject = ['modeling'];

  UpdateAttachmentHandler.prototype.execute = function (context) {
    var shape = context.shape,
        newHost = context.newHost,
        oldHost = shape.host; // (0) detach from old host

    context.oldHost = oldHost;
    context.attacherIdx = removeAttacher(oldHost, shape); // (1) attach to new host

    addAttacher(newHost, shape); // (2) update host

    shape.host = newHost;
    return shape;
  };

  UpdateAttachmentHandler.prototype.revert = function (context) {
    var shape = context.shape,
        newHost = context.newHost,
        oldHost = context.oldHost,
        attacherIdx = context.attacherIdx; // (2) update host

    shape.host = oldHost; // (1) attach to new host

    removeAttacher(newHost, shape); // (0) detach from old host

    addAttacher(oldHost, shape, attacherIdx);
    return shape;
  };

  function removeAttacher(host, attacher) {
    // remove attacher from host
    return remove$2(host && host.attachers, attacher);
  }

  function addAttacher(host, attacher, idx) {
    if (!host) {
      return;
    }

    var attachers = host.attachers;

    if (!attachers) {
      host.attachers = attachers = [];
    }

    add$1(attachers, attacher, idx);
  }

  function UpdateWaypointsHandler() {}

  UpdateWaypointsHandler.prototype.execute = function (context) {
    var connection = context.connection,
        newWaypoints = context.newWaypoints;
    context.oldWaypoints = connection.waypoints;
    connection.waypoints = newWaypoints;
    return connection;
  };

  UpdateWaypointsHandler.prototype.revert = function (context) {
    var connection = context.connection,
        oldWaypoints = context.oldWaypoints;
    connection.waypoints = oldWaypoints;
    return connection;
  };

  /**
   * The basic modeling entry point.
   *
   * @param {EventBus} eventBus
   * @param {ElementFactory} elementFactory
   * @param {CommandStack} commandStack
   */

  function Modeling(eventBus, elementFactory, commandStack) {
    this._eventBus = eventBus;
    this._elementFactory = elementFactory;
    this._commandStack = commandStack;
    var self = this;
    eventBus.on('diagram.init', function () {
      // register modeling handlers
      self.registerHandlers(commandStack);
    });
  }
  Modeling.$inject = ['eventBus', 'elementFactory', 'commandStack'];

  Modeling.prototype.getHandlers = function () {
    return {
      'shape.append': AppendShapeHandler,
      'shape.create': CreateShapeHandler,
      'shape.delete': DeleteShapeHandler,
      'shape.move': MoveShapeHandler,
      'shape.resize': ResizeShapeHandler,
      'shape.replace': ReplaceShapeHandler,
      'shape.toggleCollapse': ToggleShapeCollapseHandler,
      'spaceTool': SpaceToolHandler,
      'label.create': CreateLabelHandler,
      'connection.create': CreateConnectionHandler,
      'connection.delete': DeleteConnectionHandler,
      'connection.move': MoveConnectionHandler,
      'connection.layout': LayoutConnectionHandler,
      'connection.updateWaypoints': UpdateWaypointsHandler,
      'connection.reconnect': ReconnectConnectionHandler,
      'elements.create': CreateElementsHandler,
      'elements.move': MoveElementsHandler,
      'elements.delete': DeleteElementsHandler,
      'elements.distribute': DistributeElements$1,
      'elements.align': AlignElements$1,
      'element.updateAttachment': UpdateAttachmentHandler
    };
  };
  /**
   * Register handlers with the command stack
   *
   * @param {CommandStack} commandStack
   */


  Modeling.prototype.registerHandlers = function (commandStack) {
    forEach(this.getHandlers(), function (handler, id) {
      commandStack.registerHandler(id, handler);
    });
  }; // modeling helpers //////////////////////


  Modeling.prototype.moveShape = function (shape, delta, newParent, newParentIndex, hints) {
    if (_typeof(newParentIndex) === 'object') {
      hints = newParentIndex;
      newParentIndex = null;
    }

    var context = {
      shape: shape,
      delta: delta,
      newParent: newParent,
      newParentIndex: newParentIndex,
      hints: hints || {}
    };

    this._commandStack.execute('shape.move', context);
  };
  /**
   * Update the attachment of the given shape.
   *
   * @param {djs.mode.Base} shape
   * @param {djs.model.Base} [newHost]
   */


  Modeling.prototype.updateAttachment = function (shape, newHost) {
    var context = {
      shape: shape,
      newHost: newHost
    };

    this._commandStack.execute('element.updateAttachment', context);
  };
  /**
   * Move a number of shapes to a new target, either setting it as
   * the new parent or attaching it.
   *
   * @param {Array<djs.mode.Base>} shapes
   * @param {Point} delta
   * @param {djs.model.Base} [target]
   * @param {Object} [hints]
   * @param {boolean} [hints.attach=false]
   */


  Modeling.prototype.moveElements = function (shapes, delta, target, hints) {
    hints = hints || {};
    var attach = hints.attach;
    var newParent = target,
        newHost;

    if (attach === true) {
      newHost = target;
      newParent = target.parent;
    } else if (attach === false) {
      newHost = null;
    }

    var context = {
      shapes: shapes,
      delta: delta,
      newParent: newParent,
      newHost: newHost,
      hints: hints
    };

    this._commandStack.execute('elements.move', context);
  };

  Modeling.prototype.moveConnection = function (connection, delta, newParent, newParentIndex, hints) {
    if (_typeof(newParentIndex) === 'object') {
      hints = newParentIndex;
      newParentIndex = undefined;
    }

    var context = {
      connection: connection,
      delta: delta,
      newParent: newParent,
      newParentIndex: newParentIndex,
      hints: hints || {}
    };

    this._commandStack.execute('connection.move', context);
  };

  Modeling.prototype.layoutConnection = function (connection, hints) {
    var context = {
      connection: connection,
      hints: hints || {}
    };

    this._commandStack.execute('connection.layout', context);
  };
  /**
   * Create connection.
   *
   * @param {djs.model.Base} source
   * @param {djs.model.Base} target
   * @param {number} [parentIndex]
   * @param {Object|djs.model.Connection} connection
   * @param {djs.model.Base} parent
   * @param {Object} hints
   *
   * @return {djs.model.Connection} the created connection.
   */


  Modeling.prototype.createConnection = function (source, target, parentIndex, connection, parent, hints) {
    if (_typeof(parentIndex) === 'object') {
      hints = parent;
      parent = connection;
      connection = parentIndex;
      parentIndex = undefined;
    }

    connection = this._create('connection', connection);
    var context = {
      source: source,
      target: target,
      parent: parent,
      parentIndex: parentIndex,
      connection: connection,
      hints: hints
    };

    this._commandStack.execute('connection.create', context);

    return context.connection;
  };
  /**
   * Create a shape at the specified position.
   *
   * @param {djs.model.Shape|Object} shape
   * @param {Point} position
   * @param {djs.model.Shape|djs.model.Root} target
   * @param {number} [parentIndex] position in parents children list
   * @param {Object} [hints]
   * @param {boolean} [hints.attach] whether to attach to target or become a child
   *
   * @return {djs.model.Shape} the created shape
   */


  Modeling.prototype.createShape = function (shape, position, target, parentIndex, hints) {
    if (typeof parentIndex !== 'number') {
      hints = parentIndex;
      parentIndex = undefined;
    }

    hints = hints || {};
    var attach = hints.attach,
        parent,
        host;
    shape = this._create('shape', shape);

    if (attach) {
      parent = target.parent;
      host = target;
    } else {
      parent = target;
    }

    var context = {
      position: position,
      shape: shape,
      parent: parent,
      parentIndex: parentIndex,
      host: host,
      hints: hints
    };

    this._commandStack.execute('shape.create', context);

    return context.shape;
  };

  Modeling.prototype.createElements = function (elements, position, parent, parentIndex, hints) {
    if (!isArray(elements)) {
      elements = [elements];
    }

    if (typeof parentIndex !== 'number') {
      hints = parentIndex;
      parentIndex = undefined;
    }

    hints = hints || {};
    var context = {
      position: position,
      elements: elements,
      parent: parent,
      parentIndex: parentIndex,
      hints: hints
    };

    this._commandStack.execute('elements.create', context);

    return context.elements;
  };

  Modeling.prototype.createLabel = function (labelTarget, position, label, parent) {
    label = this._create('label', label);
    var context = {
      labelTarget: labelTarget,
      position: position,
      parent: parent || labelTarget.parent,
      shape: label
    };

    this._commandStack.execute('label.create', context);

    return context.shape;
  };
  /**
   * Append shape to given source, drawing a connection
   * between source and the newly created shape.
   *
   * @param {djs.model.Shape} source
   * @param {djs.model.Shape|Object} shape
   * @param {Point} position
   * @param {djs.model.Shape} target
   * @param {Object} [hints]
   * @param {boolean} [hints.attach]
   * @param {djs.model.Connection|Object} [hints.connection]
   * @param {djs.model.Base} [hints.connectionParent]
   *
   * @return {djs.model.Shape} the newly created shape
   */


  Modeling.prototype.appendShape = function (source, shape, position, target, hints) {
    hints = hints || {};
    shape = this._create('shape', shape);
    var context = {
      source: source,
      position: position,
      target: target,
      shape: shape,
      connection: hints.connection,
      connectionParent: hints.connectionParent,
      hints: hints
    };

    this._commandStack.execute('shape.append', context);

    return context.shape;
  };

  Modeling.prototype.removeElements = function (elements) {
    var context = {
      elements: elements
    };

    this._commandStack.execute('elements.delete', context);
  };

  Modeling.prototype.distributeElements = function (groups, axis, dimension) {
    var context = {
      groups: groups,
      axis: axis,
      dimension: dimension
    };

    this._commandStack.execute('elements.distribute', context);
  };

  Modeling.prototype.removeShape = function (shape, hints) {
    var context = {
      shape: shape,
      hints: hints || {}
    };

    this._commandStack.execute('shape.delete', context);
  };

  Modeling.prototype.removeConnection = function (connection, hints) {
    var context = {
      connection: connection,
      hints: hints || {}
    };

    this._commandStack.execute('connection.delete', context);
  };

  Modeling.prototype.replaceShape = function (oldShape, newShape, hints) {
    var context = {
      oldShape: oldShape,
      newData: newShape,
      hints: hints || {}
    };

    this._commandStack.execute('shape.replace', context);

    return context.newShape;
  };

  Modeling.prototype.alignElements = function (elements, alignment) {
    var context = {
      elements: elements,
      alignment: alignment
    };

    this._commandStack.execute('elements.align', context);
  };

  Modeling.prototype.resizeShape = function (shape, newBounds, minBounds, hints) {
    var context = {
      shape: shape,
      newBounds: newBounds,
      minBounds: minBounds,
      hints: hints
    };

    this._commandStack.execute('shape.resize', context);
  };

  Modeling.prototype.createSpace = function (movingShapes, resizingShapes, delta, direction, start) {
    var context = {
      delta: delta,
      direction: direction,
      movingShapes: movingShapes,
      resizingShapes: resizingShapes,
      start: start
    };

    this._commandStack.execute('spaceTool', context);
  };

  Modeling.prototype.updateWaypoints = function (connection, newWaypoints, hints) {
    var context = {
      connection: connection,
      newWaypoints: newWaypoints,
      hints: hints || {}
    };

    this._commandStack.execute('connection.updateWaypoints', context);
  };

  Modeling.prototype.reconnect = function (connection, source, target, dockingOrPoints, hints) {
    var context = {
      connection: connection,
      newSource: source,
      newTarget: target,
      dockingOrPoints: dockingOrPoints,
      hints: hints || {}
    };

    this._commandStack.execute('connection.reconnect', context);
  };

  Modeling.prototype.reconnectStart = function (connection, newSource, dockingOrPoints, hints) {
    if (!hints) {
      hints = {};
    }

    this.reconnect(connection, newSource, connection.target, dockingOrPoints, assign(hints, {
      docking: 'source'
    }));
  };

  Modeling.prototype.reconnectEnd = function (connection, newTarget, dockingOrPoints, hints) {
    if (!hints) {
      hints = {};
    }

    this.reconnect(connection, connection.source, newTarget, dockingOrPoints, assign(hints, {
      docking: 'target'
    }));
  };

  Modeling.prototype.connect = function (source, target, attrs, hints) {
    return this.createConnection(source, target, attrs || {}, source.parent, hints);
  };

  Modeling.prototype._create = function (type, attrs) {
    if (attrs instanceof Base$1) {
      return attrs;
    } else {
      return this._elementFactory.create(type, attrs);
    }
  };

  Modeling.prototype.toggleCollapse = function (shape, hints) {
    var context = {
      shape: shape,
      hints: hints || {}
    };

    this._commandStack.execute('shape.toggleCollapse', context);
  };

  function IdClaimHandler(moddle) {
    this._moddle = moddle;
  }
  IdClaimHandler.$inject = ['moddle'];

  IdClaimHandler.prototype.execute = function (context) {
    var ids = this._moddle.ids,
        id = context.id,
        element = context.element,
        claiming = context.claiming;

    if (claiming) {
      ids.claim(id, element);
    } else {
      ids.unclaim(id);
    }
  };
  /**
   * Command revert implementation.
   */


  IdClaimHandler.prototype.revert = function (context) {
    var ids = this._moddle.ids,
        id = context.id,
        element = context.element,
        claiming = context.claiming;

    if (claiming) {
      ids.unclaim(id);
    } else {
      ids.claim(id, element);
    }
  };

  /**
   * A handler that updates the name of a DMN element.
   */

  function UpdateLabelHandler() {
    /**
     * Set the label and return the changed elements.
     *
     * Element parameter can be label itself or connection (i.e. sequence flow).
     *
     * @param {djs.model.Base} element
     * @param {string} text
     */
    function setText(element, text) {
      // external label if present
      var label = element.label || element;
      var labelTarget = element.labelTarget || element;
      setLabel(label, text, labelTarget !== label);
      return [label, labelTarget];
    }

    function execute(ctx) {
      ctx.oldLabel = getLabel(ctx.element);
      return setText(ctx.element, ctx.newLabel);
    }

    function revert(ctx) {
      return setText(ctx.element, ctx.oldLabel);
    } // API


    this.execute = execute;
    this.revert = revert;
  }

  var NAME = 'name',
      ID$1 = 'id';
  /**
   * A handler that implements a DMN property update.
   *
   * This should be used to set simple properties on elements with
   * an underlying DMN business object.
   *
   * Use respective diagram-js provided handlers if you would
   * like to perform automated modeling.
   */

  function UpdatePropertiesHandler(elementRegistry, moddle) {
    this._elementRegistry = elementRegistry;
    this._moddle = moddle;
  }
  UpdatePropertiesHandler.$inject = ['elementRegistry', 'moddle'];
  /**
   * Updates a DMN element with a list of new properties
   *
   * @param {Object} context
   * @param {djs.model.Base} context.element the element to update
   * @param {Object} context.properties a list of properties to set on the element's
   *                                    businessObject (the DMN model element)
   *
   * @return {Array<djs.model.Base>} the updated element
   */

  UpdatePropertiesHandler.prototype.execute = function (context) {
    var element = context.element,
        changed = [element];

    if (!element) {
      throw new Error('element required');
    }

    var elementRegistry = this._elementRegistry,
        ids = this._moddle.ids;
    var businessObject = element.businessObject,
        properties = context.properties,
        oldProperties = context.oldProperties || getProperties(businessObject, keys(properties));

    if (isIdChange$1(properties, businessObject)) {
      ids.unclaim(businessObject[ID$1]);
      elementRegistry.updateId(element, properties[ID$1]);
      ids.claim(properties[ID$1], businessObject);
    }

    if (NAME in properties && element.label) {
      changed.push(element.label);
    } // update properties


    setProperties(businessObject, properties); // store old values

    context.oldProperties = oldProperties;
    context.changed = changed; // indicate changed on objects affected by the update

    return changed;
  };
  /**
   * Reverts the update on a DMN elements properties.
   *
   * @param  {Object} context
   *
   * @return {djs.model.Base} the updated element
   */


  UpdatePropertiesHandler.prototype.revert = function (context) {
    var element = context.element,
        properties = context.properties,
        oldProperties = context.oldProperties,
        businessObject = element.businessObject,
        elementRegistry = this._elementRegistry,
        ids = this._moddle.ids; // update properties

    setProperties(businessObject, oldProperties);

    if (isIdChange$1(properties, businessObject)) {
      ids.unclaim(properties[ID$1]);
      elementRegistry.updateId(element, oldProperties[ID$1]);
      ids.claim(oldProperties[ID$1], businessObject);
    }

    return context.changed;
  };

  function isIdChange$1(properties, businessObject) {
    return ID$1 in properties && properties[ID$1] !== businessObject[ID$1];
  }

  function getProperties(businessObject, propertyNames) {
    return reduce(propertyNames, function (result, key) {
      result[key] = businessObject.get(key);
      return result;
    }, {});
  }

  function setProperties(businessObject, properties) {
    forEach(properties, function (value, key) {
      businessObject.set(key, value);
    });
  }

  /**
   * DMN modeling.
   *
   * @param {Canvas} canvas
   * @param {CommandStack} commandStack
   * @param {DrdRules} drdRules
   * @param {ElementFactory} elementFactory
   * @param {EventBus} eventBus
   */

  function Modeling$1(canvas, drdRules, injector) {
    this._canvas = canvas;
    this._drdRules = drdRules;
    injector.invoke(Modeling, this);
  }
  inherits_browser(Modeling$1, Modeling);
  Modeling$1.$inject = ['canvas', 'drdRules', 'injector'];

  Modeling$1.prototype.claimId = function (id, moddleElement) {
    this._commandStack.execute('id.updateClaim', {
      id: id,
      element: moddleElement,
      claiming: true
    });
  };

  Modeling$1.prototype.connect = function (source, target, attrs, hints) {
    var drdRules = this._drdRules,
        rootElement = this._canvas.getRootElement();

    if (!attrs) {
      attrs = drdRules.canConnect(source, target) || {
        type: 'dmn:Association'
      };
    }

    return this.createConnection(source, target, attrs, rootElement, hints);
  };

  Modeling$1.prototype.getHandlers = function () {
    var handlers = Modeling.prototype.getHandlers.call(this);
    handlers['id.updateClaim'] = IdClaimHandler;
    handlers['element.updateLabel'] = UpdateLabelHandler;
    handlers['element.updateProperties'] = UpdatePropertiesHandler;
    return handlers;
  };

  Modeling$1.prototype.unclaimId = function (id, moddleElement) {
    this._commandStack.execute('id.updateClaim', {
      id: id,
      element: moddleElement
    });
  };

  Modeling$1.prototype.updateProperties = function (element, properties) {
    this._commandStack.execute('element.updateProperties', {
      element: element,
      properties: properties
    });
  };

  Modeling$1.prototype.updateLabel = function (element, newLabel, newBounds, hints) {
    this._commandStack.execute('element.updateLabel', {
      element: element,
      newLabel: newLabel,
      newBounds: newBounds,
      hints: hints || {}
    });
  };

  /**
   * A base connection layouter implementation
   * that layouts the connection by directly connecting
   * mid(source) + mid(target).
   */

  function BaseLayouter() {}
  /**
   * Return the new layouted waypoints for the given connection.
   *
   * The connection passed is still unchanged; you may figure out about
   * the new connection start / end via the layout hints provided.
   *
   * @param {djs.model.Connection} connection
   * @param {Object} [hints]
   * @param {Point} [hints.connectionStart]
   * @param {Point} [hints.connectionEnd]
   * @param {Point} [hints.source]
   * @param {Point} [hints.target]
   *
   * @return {Array<Point>} the layouted connection waypoints
   */

  BaseLayouter.prototype.layoutConnection = function (connection, hints) {
    hints = hints || {};
    return [hints.connectionStart || getMid(hints.source || connection.source), hints.connectionEnd || getMid(hints.target || connection.target)];
  };

  var ADDITIONAL_WAYPOINT_DISTANCE = 20;
  function DrdLayouter(connectionDocking) {
    this._connectionDocking = connectionDocking;
  }
  inherits_browser(DrdLayouter, BaseLayouter);
  DrdLayouter.$inject = ['connectionDocking'];

  DrdLayouter.prototype.layoutConnection = function (connection, hints) {
    var connectionDocking = this._connectionDocking;

    if (!hints) {
      hints = {};
    }

    var source = hints.source || connection.source,
        target = hints.target || connection.target,
        waypoints = hints.waypoints || connection.waypoints || [],
        connectionStart = hints.connectionStart,
        connectionEnd = hints.connectionEnd,
        orientation = getOrientation(source, target);

    if (!connectionStart) {
      connectionStart = getConnectionDocking(waypoints[0], source);
    }

    if (!connectionEnd) {
      connectionEnd = getConnectionDocking(waypoints[waypoints.length - 1], target);
    }

    if (is(connection, 'dmn:InformationRequirement')) {
      waypoints = [connectionStart, connectionEnd];
      var croppedWaypoints = connectionDocking.getCroppedWaypoints(assign({}, connection, {
        waypoints: waypoints
      }), source, target);
      connectionEnd = croppedWaypoints.pop();
      var additionalWaypoint = {
        x: connectionEnd.x,
        y: connectionEnd.y
      };

      if (orientation.includes('bottom')) {
        additionalWaypoint.y += ADDITIONAL_WAYPOINT_DISTANCE;
      } else if (orientation.includes('top')) {
        additionalWaypoint.y -= ADDITIONAL_WAYPOINT_DISTANCE;
      } else if (orientation.includes('right')) {
        additionalWaypoint.x += ADDITIONAL_WAYPOINT_DISTANCE;
      } else {
        additionalWaypoint.x -= ADDITIONAL_WAYPOINT_DISTANCE;
      }

      waypoints = croppedWaypoints.concat([additionalWaypoint, connectionEnd]);
      return waypoints;
    }

    return [connectionStart, connectionEnd];
  };

  function getConnectionDocking(point, shape) {
    return point ? point.original || point : getMid(shape);
  }

  function dockingToPoint(docking) {
    // use the dockings actual point and
    // retain the original docking
    return assign({
      original: docking.point.original || docking.point
    }, docking.actual);
  }
  /**
   * A {@link ConnectionDocking} that crops connection waypoints based on
   * the path(s) of the connection source and target.
   *
   * @param {djs.core.ElementRegistry} elementRegistry
   */


  function CroppingConnectionDocking(elementRegistry, graphicsFactory) {
    this._elementRegistry = elementRegistry;
    this._graphicsFactory = graphicsFactory;
  }
  CroppingConnectionDocking.$inject = ['elementRegistry', 'graphicsFactory'];
  /**
   * @inheritDoc ConnectionDocking#getCroppedWaypoints
   */

  CroppingConnectionDocking.prototype.getCroppedWaypoints = function (connection, source, target) {
    source = source || connection.source;
    target = target || connection.target;
    var sourceDocking = this.getDockingPoint(connection, source, true),
        targetDocking = this.getDockingPoint(connection, target);
    var croppedWaypoints = connection.waypoints.slice(sourceDocking.idx + 1, targetDocking.idx);
    croppedWaypoints.unshift(dockingToPoint(sourceDocking));
    croppedWaypoints.push(dockingToPoint(targetDocking));
    return croppedWaypoints;
  };
  /**
   * Return the connection docking point on the specified shape
   *
   * @inheritDoc ConnectionDocking#getDockingPoint
   */


  CroppingConnectionDocking.prototype.getDockingPoint = function (connection, shape, dockStart) {
    var waypoints = connection.waypoints,
        dockingIdx,
        dockingPoint,
        croppedPoint;
    dockingIdx = dockStart ? 0 : waypoints.length - 1;
    dockingPoint = waypoints[dockingIdx];
    croppedPoint = this._getIntersection(shape, connection, dockStart);
    return {
      point: dockingPoint,
      actual: croppedPoint || dockingPoint,
      idx: dockingIdx
    };
  }; // helpers //////////////////////


  CroppingConnectionDocking.prototype._getIntersection = function (shape, connection, takeFirst) {
    var shapePath = this._getShapePath(shape),
        connectionPath = this._getConnectionPath(connection);

    return getElementLineIntersection(shapePath, connectionPath, takeFirst);
  };

  CroppingConnectionDocking.prototype._getConnectionPath = function (connection) {
    return this._graphicsFactory.getConnectionPath(connection);
  };

  CroppingConnectionDocking.prototype._getShapePath = function (shape) {
    return this._graphicsFactory.getShapePath(shape);
  };

  CroppingConnectionDocking.prototype._getGfx = function (element) {
    return this._elementRegistry.getGraphics(element);
  };

  var ModelingModule = {
    __init__: ['modeling', 'drdUpdater'],
    __depends__: [ModelingBehavior, Rules$2, DefinitionPropertiesViewer, CommandStack$1, SelectionModule, DiagramChangeSupport],
    drdFactory: ['type', DrdFactory],
    drdUpdater: ['type', DrdUpdater],
    elementFactory: ['type', ElementFactory$1],
    modeling: ['type', Modeling$1],
    layouter: ['type', DrdLayouter],
    connectionDocking: ['type', CroppingConnectionDocking]
  };

  var LOW_PRIORITY$9 = 500,
      MEDIUM_PRIORITY = 1250,
      HIGH_PRIORITY$5 = 1500;
  var round$9 = Math.round;

  function mid$1(element) {
    return {
      x: element.x + round$9(element.width / 2),
      y: element.y + round$9(element.height / 2)
    };
  }
  /**
   * A plugin that makes shapes draggable / droppable.
   *
   * @param {EventBus} eventBus
   * @param {Dragging} dragging
   * @param {Modeling} modeling
   * @param {Selection} selection
   * @param {Rules} rules
   */


  function MoveEvents(eventBus, dragging, modeling, selection, rules) {
    // rules
    function canMove(shapes, delta, position, target) {
      return rules.allowed('elements.move', {
        shapes: shapes,
        delta: delta,
        position: position,
        target: target
      });
    } // move events
    // assign a high priority to this handler to setup the environment
    // others may hook up later, e.g. at default priority and modify
    // the move environment.
    //
    // This sets up the context with
    //
    // * shape: the primary shape being moved
    // * shapes: a list of shapes to be moved
    // * validatedShapes: a list of shapes that are being checked
    //                    against the rules before and during move
    //


    eventBus.on('shape.move.start', HIGH_PRIORITY$5, function (event) {
      var context = event.context,
          shape = event.shape,
          shapes = selection.get().slice(); // move only single shape if the dragged element
      // is not part of the current selection

      if (shapes.indexOf(shape) === -1) {
        shapes = [shape];
      } // ensure we remove nested elements in the collection
      // and add attachers for a proper dragger


      shapes = removeNested(shapes); // attach shapes to drag context

      assign(context, {
        shapes: shapes,
        validatedShapes: shapes,
        shape: shape
      });
    }); // assign a high priority to this handler to setup the environment
    // others may hook up later, e.g. at default priority and modify
    // the move environment
    //

    eventBus.on('shape.move.start', MEDIUM_PRIORITY, function (event) {
      var context = event.context,
          validatedShapes = context.validatedShapes,
          canExecute;
      canExecute = context.canExecute = canMove(validatedShapes); // check if we can move the elements

      if (!canExecute) {
        return false;
      }
    }); // assign a low priority to this handler
    // to let others modify the move event before we update
    // the context
    //

    eventBus.on('shape.move.move', LOW_PRIORITY$9, function (event) {
      var context = event.context,
          validatedShapes = context.validatedShapes,
          hover = event.hover,
          delta = {
        x: event.dx,
        y: event.dy
      },
          position = {
        x: event.x,
        y: event.y
      },
          canExecute; // check if we can move the elements

      canExecute = canMove(validatedShapes, delta, position, hover);
      context.delta = delta;
      context.canExecute = canExecute; // simply ignore move over

      if (canExecute === null) {
        context.target = null;
        return;
      }

      context.target = hover;
    });
    eventBus.on('shape.move.end', function (event) {
      var context = event.context;
      var delta = context.delta,
          canExecute = context.canExecute,
          isAttach = canExecute === 'attach',
          shapes = context.shapes;

      if (canExecute === false) {
        return false;
      } // ensure we have actual pixel values deltas
      // (important when zoom level was > 1 during move)


      delta.x = round$9(delta.x);
      delta.y = round$9(delta.y);

      if (delta.x === 0 && delta.y === 0) {
        // didn't move
        return;
      }

      modeling.moveElements(shapes, delta, context.target, {
        primaryShape: context.shape,
        attach: isAttach
      });
    }); // move activation

    eventBus.on('element.mousedown', function (event) {
      if (!isPrimaryButton(event)) {
        return;
      }

      var originalEvent = getOriginal(event);

      if (!originalEvent) {
        throw new Error('must supply DOM mousedown event');
      }

      return start(originalEvent, event.element);
    });
    /**
     * Start move.
     *
     * @param {MouseEvent} event
     * @param {djs.model.Shape} shape
     * @param {boolean} [activate]
     * @param {Object} [context]
     */

    function start(event, element, activate, context) {
      if (isObject(activate)) {
        context = activate;
        activate = false;
      } // do not move connections or the root element


      if (element.waypoints || !element.parent) {
        return;
      }

      var referencePoint = mid$1(element);
      dragging.init(event, referencePoint, 'shape.move', {
        cursor: 'grabbing',
        autoActivate: activate,
        data: {
          shape: element,
          context: context || {}
        }
      }); // we've handled the event

      return true;
    } // API


    this.start = start;
  }
  MoveEvents.$inject = ['eventBus', 'dragging', 'modeling', 'selection', 'rules'];
  /**
   * Return a filtered list of elements that do not contain
   * those nested into others.
   *
   * @param  {Array<djs.model.Base>} elements
   *
   * @return {Array<djs.model.Base>} filtered
   */

  function removeNested(elements) {
    var ids = groupBy(elements, 'id');
    return filter(elements, function (element) {
      while (element = element.parent) {
        // parent in selection
        if (ids[element.id]) {
          return false;
        }
      }

      return true;
    });
  }

  var LOW_PRIORITY$a = 499;
  var MARKER_DRAGGING = 'djs-dragging',
      MARKER_OK$3 = 'drop-ok',
      MARKER_NOT_OK$3 = 'drop-not-ok',
      MARKER_NEW_PARENT$1 = 'new-parent',
      MARKER_ATTACH$1 = 'attach-ok';
  /**
   * Provides previews for moving shapes when moving.
   *
   * @param {EventBus} eventBus
   * @param {ElementRegistry} elementRegistry
   * @param {Canvas} canvas
   * @param {Styles} styles
   */

  function MovePreview(eventBus, canvas, styles, previewSupport) {
    function getVisualDragShapes(shapes) {
      var elements = getAllDraggedElements(shapes);
      var filteredElements = removeEdges(elements);
      return filteredElements;
    }

    function getAllDraggedElements(shapes) {
      var allShapes = selfAndAllChildren(shapes, true);
      var allConnections = map(allShapes, function (shape) {
        return (shape.incoming || []).concat(shape.outgoing || []);
      });
      return flatten(allShapes.concat(allConnections));
    }
    /**
     * Sets drop marker on an element.
     */


    function setMarker(element, marker) {
      [MARKER_ATTACH$1, MARKER_OK$3, MARKER_NOT_OK$3, MARKER_NEW_PARENT$1].forEach(function (m) {
        if (m === marker) {
          canvas.addMarker(element, m);
        } else {
          canvas.removeMarker(element, m);
        }
      });
    }
    /**
     * Make an element draggable.
     *
     * @param {Object} context
     * @param {djs.model.Base} element
     * @param {boolean} addMarker
     */


    function makeDraggable(context, element, addMarker) {
      previewSupport.addDragger(element, context.dragGroup);

      if (addMarker) {
        canvas.addMarker(element, MARKER_DRAGGING);
      }

      if (context.allDraggedElements) {
        context.allDraggedElements.push(element);
      } else {
        context.allDraggedElements = [element];
      }
    } // assign a low priority to this handler
    // to let others modify the move context before
    // we draw things


    eventBus.on('shape.move.start', LOW_PRIORITY$a, function (event) {
      var context = event.context,
          dragShapes = context.shapes,
          allDraggedElements = context.allDraggedElements;
      var visuallyDraggedShapes = getVisualDragShapes(dragShapes);

      if (!context.dragGroup) {
        var dragGroup = create('g');
        attr$1(dragGroup, styles.cls('djs-drag-group', ['no-events']));
        var defaultLayer = canvas.getDefaultLayer();
        append(defaultLayer, dragGroup);
        context.dragGroup = dragGroup;
      } // add previews


      visuallyDraggedShapes.forEach(function (shape) {
        previewSupport.addDragger(shape, context.dragGroup);
      }); // cache all dragged elements / gfx
      // so that we can quickly undo their state changes later

      if (!allDraggedElements) {
        allDraggedElements = getAllDraggedElements(dragShapes);
      } else {
        allDraggedElements = flatten([allDraggedElements, getAllDraggedElements(dragShapes)]);
      } // add dragging marker


      forEach(allDraggedElements, function (e) {
        canvas.addMarker(e, MARKER_DRAGGING);
      });
      context.allDraggedElements = allDraggedElements; // determine, if any of the dragged elements have different parents

      context.differentParents = haveDifferentParents(dragShapes);
    }); // update previews

    eventBus.on('shape.move.move', LOW_PRIORITY$a, function (event) {
      var context = event.context,
          dragGroup = context.dragGroup,
          target = context.target,
          parent = context.shape.parent,
          canExecute = context.canExecute;

      if (target) {
        if (canExecute === 'attach') {
          setMarker(target, MARKER_ATTACH$1);
        } else if (context.canExecute && target && target.id !== parent.id) {
          setMarker(target, MARKER_NEW_PARENT$1);
        } else {
          setMarker(target, context.canExecute ? MARKER_OK$3 : MARKER_NOT_OK$3);
        }
      }

      translate(dragGroup, event.dx, event.dy);
    });
    eventBus.on(['shape.move.out', 'shape.move.cleanup'], function (event) {
      var context = event.context,
          target = context.target;

      if (target) {
        setMarker(target, null);
      }
    }); // remove previews

    eventBus.on('shape.move.cleanup', function (event) {
      var context = event.context,
          allDraggedElements = context.allDraggedElements,
          dragGroup = context.dragGroup; // remove dragging marker

      forEach(allDraggedElements, function (e) {
        canvas.removeMarker(e, MARKER_DRAGGING);
      });

      if (dragGroup) {
        remove$1(dragGroup);
      }
    }); // API //////////////////////

    /**
     * Make an element draggable.
     *
     * @param {Object} context
     * @param {djs.model.Base} element
     * @param {boolean} addMarker
     */

    this.makeDraggable = makeDraggable;
  }
  MovePreview.$inject = ['eventBus', 'canvas', 'styles', 'previewSupport']; // helpers //////////////////////

  /**
   * returns elements minus all connections
   * where source or target is not elements
   */

  function removeEdges(elements) {
    var filteredElements = filter(elements, function (element) {
      if (!isConnection$3(element)) {
        return true;
      } else {
        return find(elements, matchPattern({
          id: element.source.id
        })) && find(elements, matchPattern({
          id: element.target.id
        }));
      }
    });
    return filteredElements;
  }

  function haveDifferentParents(elements) {
    return size(groupBy(elements, function (e) {
      return e.parent && e.parent.id;
    })) !== 1;
  }
  /**
   * Checks if an element is a connection.
   */


  function isConnection$3(element) {
    return element.waypoints;
  }

  var MoveModule = {
    __depends__: [InteractionEventsModule, SelectionModule, OutlineModule, Rules$1, DraggingModule, PreviewSupportModule],
    __init__: ['move', 'movePreview'],
    move: ['type', MoveEvents],
    movePreview: ['type', MovePreview]
  };

  var TOGGLE_SELECTOR = '.djs-palette-toggle',
      ENTRY_SELECTOR = '.entry',
      ELEMENT_SELECTOR = TOGGLE_SELECTOR + ', ' + ENTRY_SELECTOR;
  var PALETTE_OPEN_CLS = 'open',
      PALETTE_TWO_COLUMN_CLS = 'two-column';
  var DEFAULT_PRIORITY$5 = 1000;
  /**
   * A palette containing modeling elements.
   */

  function Palette(eventBus, canvas) {
    this._eventBus = eventBus;
    this._canvas = canvas;
    var self = this;
    eventBus.on('tool-manager.update', function (event) {
      var tool = event.tool;
      self.updateToolHighlight(tool);
    });
    eventBus.on('i18n.changed', function () {
      self._update();
    });
    eventBus.on('diagram.init', function () {
      self._diagramInitialized = true;

      self._rebuild();
    });
  }
  Palette.$inject = ['eventBus', 'canvas'];
  /**
   * Register a provider with the palette
   *
   * @param  {number} [priority=1000]
   * @param  {PaletteProvider} provider
   *
   * @example
   * const paletteProvider = {
   *   getPaletteEntries: function() {
   *     return function(entries) {
   *       return {
   *         ...entries,
   *         'entry-1': {
   *           label: 'My Entry',
   *           action: function() { alert("I have been clicked!"); }
   *         }
   *       };
   *     }
   *   }
   * };
   *
   * palette.registerProvider(800, paletteProvider);
   */

  Palette.prototype.registerProvider = function (priority, provider) {
    if (!provider) {
      provider = priority;
      priority = DEFAULT_PRIORITY$5;
    }

    this._eventBus.on('palette.getProviders', priority, function (event) {
      event.providers.push(provider);
    });

    this._rebuild();
  };
  /**
   * Returns the palette entries
   *
   * @return {Object<string, PaletteEntryDescriptor>} map of entries
   */


  Palette.prototype.getEntries = function () {
    var providers = this._getProviders();

    return providers.reduce(addPaletteEntries, {});
  };

  Palette.prototype._rebuild = function () {
    if (!this._diagramInitialized) {
      return;
    }

    var providers = this._getProviders();

    if (!providers.length) {
      return;
    }

    if (!this._container) {
      this._init();
    }

    this._update();
  };
  /**
   * Initialize
   */


  Palette.prototype._init = function () {
    var self = this;
    var eventBus = this._eventBus;

    var parentContainer = this._getParentContainer();

    var container = this._container = domify(Palette.HTML_MARKUP);
    parentContainer.appendChild(container);
    delegate.bind(container, ELEMENT_SELECTOR, 'click', function (event) {
      var target = event.delegateTarget;

      if (matchesSelector(target, TOGGLE_SELECTOR)) {
        return self.toggle();
      }

      self.trigger('click', event);
    }); // prevent drag propagation

    componentEvent.bind(container, 'mousedown', function (event) {
      event.stopPropagation();
    }); // prevent drag propagation

    delegate.bind(container, ENTRY_SELECTOR, 'dragstart', function (event) {
      self.trigger('dragstart', event);
    });
    eventBus.on('canvas.resized', this._layoutChanged, this);
    eventBus.fire('palette.create', {
      container: container
    });
  };

  Palette.prototype._getProviders = function (id) {
    var event = this._eventBus.createEvent({
      type: 'palette.getProviders',
      providers: []
    });

    this._eventBus.fire(event);

    return event.providers;
  };
  /**
   * Update palette state.
   *
   * @param  {Object} [state] { open, twoColumn }
   */


  Palette.prototype._toggleState = function (state) {
    state = state || {};

    var parent = this._getParentContainer(),
        container = this._container;

    var eventBus = this._eventBus;
    var twoColumn;
    var cls = classes(container);

    if ('twoColumn' in state) {
      twoColumn = state.twoColumn;
    } else {
      twoColumn = this._needsCollapse(parent.clientHeight, this._entries || {});
    } // always update two column


    cls.toggle(PALETTE_TWO_COLUMN_CLS, twoColumn);

    if ('open' in state) {
      cls.toggle(PALETTE_OPEN_CLS, state.open);
    }

    eventBus.fire('palette.changed', {
      twoColumn: twoColumn,
      open: this.isOpen()
    });
  };

  Palette.prototype._update = function () {
    var entriesContainer = query('.djs-palette-entries', this._container),
        entries = this._entries = this.getEntries();
    clear(entriesContainer);
    forEach(entries, function (entry, id) {
      var grouping = entry.group || 'default';
      var container = query('[data-group=' + grouping + ']', entriesContainer);

      if (!container) {
        container = domify('<div class="group" data-group="' + grouping + '"></div>');
        entriesContainer.appendChild(container);
      }

      var html = entry.html || (entry.separator ? '<hr class="separator" />' : '<div class="entry" draggable="true"></div>');
      var control = domify(html);
      container.appendChild(control);

      if (!entry.separator) {
        attr(control, 'data-action', id);

        if (entry.title) {
          attr(control, 'title', entry.title);
        }

        if (entry.className) {
          addClasses$1(control, entry.className);
        }

        if (entry.imageUrl) {
          control.appendChild(domify('<img src="' + entry.imageUrl + '">'));
        }
      }
    }); // open after update

    this.open();
  };
  /**
   * Trigger an action available on the palette
   *
   * @param  {string} action
   * @param  {Event} event
   */


  Palette.prototype.trigger = function (action, event, autoActivate) {
    var entries = this._entries,
        entry,
        handler,
        originalEvent,
        button = event.delegateTarget || event.target;

    if (!button) {
      return event.preventDefault();
    }

    entry = entries[attr(button, 'data-action')]; // when user clicks on the palette and not on an action

    if (!entry) {
      return;
    }

    handler = entry.action;
    originalEvent = event.originalEvent || event; // simple action (via callback function)

    if (isFunction(handler)) {
      if (action === 'click') {
        handler(originalEvent, autoActivate);
      }
    } else {
      if (handler[action]) {
        handler[action](originalEvent, autoActivate);
      }
    } // silence other actions


    event.preventDefault();
  };

  Palette.prototype._layoutChanged = function () {
    this._toggleState({});
  };
  /**
   * Do we need to collapse to two columns?
   *
   * @param {number} availableHeight
   * @param {Object} entries
   *
   * @return {boolean}
   */


  Palette.prototype._needsCollapse = function (availableHeight, entries) {
    // top margin + bottom toggle + bottom margin
    // implementors must override this method if they
    // change the palette styles
    var margin = 20 + 10 + 20;
    var entriesHeight = Object.keys(entries).length * 46;
    return availableHeight < entriesHeight + margin;
  };
  /**
   * Close the palette
   */


  Palette.prototype.close = function () {
    this._toggleState({
      open: false,
      twoColumn: false
    });
  };
  /**
   * Open the palette
   */


  Palette.prototype.open = function () {
    this._toggleState({
      open: true
    });
  };

  Palette.prototype.toggle = function (open) {
    if (this.isOpen()) {
      this.close();
    } else {
      this.open();
    }
  };

  Palette.prototype.isActiveTool = function (tool) {
    return tool && this._activeTool === tool;
  };

  Palette.prototype.updateToolHighlight = function (name) {
    var entriesContainer, toolsContainer;

    if (!this._toolsContainer) {
      entriesContainer = query('.djs-palette-entries', this._container);
      this._toolsContainer = query('[data-group=tools]', entriesContainer);
    }

    toolsContainer = this._toolsContainer;
    forEach(toolsContainer.children, function (tool) {
      var actionName = tool.getAttribute('data-action');

      if (!actionName) {
        return;
      }

      var toolClasses = classes(tool);
      actionName = actionName.replace('-tool', '');

      if (toolClasses.contains('entry') && actionName === name) {
        toolClasses.add('highlighted-entry');
      } else {
        toolClasses.remove('highlighted-entry');
      }
    });
  };
  /**
   * Return true if the palette is opened.
   *
   * @example
   *
   * palette.open();
   *
   * if (palette.isOpen()) {
   *   // yes, we are open
   * }
   *
   * @return {boolean} true if palette is opened
   */


  Palette.prototype.isOpen = function () {
    return classes(this._container).has(PALETTE_OPEN_CLS);
  };
  /**
   * Get container the palette lives in.
   *
   * @return {Element}
   */


  Palette.prototype._getParentContainer = function () {
    return this._canvas.getContainer();
  };
  /* markup definition */


  Palette.HTML_MARKUP = '<div class="djs-palette">' + '<div class="djs-palette-entries"></div>' + '<div class="djs-palette-toggle"></div>' + '</div>'; // helpers //////////////////////

  function addClasses$1(element, classNames) {
    var classes$1 = classes(element);
    var actualClassNames = isArray(classNames) ? classNames : classNames.split(/\s+/g);
    actualClassNames.forEach(function (cls) {
      classes$1.add(cls);
    });
  }

  function addPaletteEntries(entries, provider) {
    var entriesOrUpdater = provider.getPaletteEntries();

    if (isFunction(entriesOrUpdater)) {
      return entriesOrUpdater(entries);
    }

    forEach(entriesOrUpdater, function (entry, id) {
      entries[id] = entry;
    });
    return entries;
  }

  var DiagramPalette = {
    __init__: ['palette'],
    palette: ['type', Palette]
  };

  var LOW_PRIORITY$b = 250;
  /**
   * The tool manager acts as middle-man between the available tool's and the Palette,
   * it takes care of making sure that the correct active state is set.
   *
   * @param  {Object}    eventBus
   * @param  {Object}    dragging
   */

  function ToolManager(eventBus, dragging) {
    this._eventBus = eventBus;
    this._dragging = dragging;
    this._tools = [];
    this._active = null;
  }
  ToolManager.$inject = ['eventBus', 'dragging'];

  ToolManager.prototype.registerTool = function (name, events) {
    var tools = this._tools;

    if (!events) {
      throw new Error('A tool has to be registered with it\'s "events"');
    }

    tools.push(name);
    this.bindEvents(name, events);
  };

  ToolManager.prototype.isActive = function (tool) {
    return tool && this._active === tool;
  };

  ToolManager.prototype.length = function (tool) {
    return this._tools.length;
  };

  ToolManager.prototype.setActive = function (tool) {
    var eventBus = this._eventBus;

    if (this._active !== tool) {
      this._active = tool;
      eventBus.fire('tool-manager.update', {
        tool: tool
      });
    }
  };

  ToolManager.prototype.bindEvents = function (name, events) {
    var eventBus = this._eventBus,
        dragging = this._dragging;
    var eventsToRegister = [];
    eventBus.on(events.tool + '.init', function (event) {
      var context = event.context; // Active tools that want to reactivate themselves must do this explicitly

      if (!context.reactivate && this.isActive(name)) {
        this.setActive(null);
        dragging.cancel();
        return;
      }

      this.setActive(name);
    }, this); // Todo[ricardo]: add test cases

    forEach(events, function (event) {
      eventsToRegister.push(event + '.ended');
      eventsToRegister.push(event + '.canceled');
    });
    eventBus.on(eventsToRegister, LOW_PRIORITY$b, function (event) {
      // We defer the de-activation of the tool to the .activate phase,
      // so we're able to check if we want to toggle off the current
      // active tool or switch to a new one
      if (!this._active) {
        return;
      }

      if (isPaletteClick(event)) {
        return;
      }

      this.setActive(null);
    }, this);
  }; // helpers ///////////////

  /**
   * Check if a given event is a palette click event.
   *
   * @param {EventBus.Event} event
   *
   * @return {boolean}
   */


  function isPaletteClick(event) {
    var target = event.originalEvent && event.originalEvent.target;
    return target && closest(target, '.group[data-group="tools"]');
  }

  var ToolManagerModule = {
    __depends__: [DraggingModule],
    __init__: ['toolManager'],
    toolManager: ['type', ToolManager]
  };

  function Mouse(eventBus) {
    var self = this;
    this._lastMoveEvent = null;

    function setLastMoveEvent(mousemoveEvent) {
      self._lastMoveEvent = mousemoveEvent;
    }

    eventBus.on('canvas.init', function (context) {
      var svg = self._svg = context.svg;
      svg.addEventListener('mousemove', setLastMoveEvent);
    });
    eventBus.on('canvas.destroy', function () {
      self._lastMouseEvent = null;

      self._svg.removeEventListener('mousemove', setLastMoveEvent);
    });
  }
  Mouse.$inject = ['eventBus'];

  Mouse.prototype.getLastMoveEvent = function () {
    return this._lastMoveEvent || createMoveEvent(0, 0);
  }; // helpers //////////


  function createMoveEvent(x, y) {
    var event = document.createEvent('MouseEvent');
    var screenX = x,
        screenY = y,
        clientX = x,
        clientY = y;

    if (event.initMouseEvent) {
      event.initMouseEvent('mousemove', true, true, window, 0, screenX, screenY, clientX, clientY, false, false, false, false, 0, null);
    }

    return event;
  }

  var MouseModule = {
    __init__: ['mouse'],
    mouse: ['type', Mouse]
  };

  var LASSO_TOOL_CURSOR = 'crosshair';
  function LassoTool(eventBus, canvas, dragging, elementRegistry, selection, toolManager, mouse) {
    this._selection = selection;
    this._dragging = dragging;
    this._mouse = mouse;
    var self = this; // lasso visuals implementation

    /**
    * A helper that realizes the selection box visual
    */

    var visuals = {
      create: function create$1(context) {
        var container = canvas.getDefaultLayer(),
            frame;
        frame = context.frame = create('rect');
        attr$1(frame, {
          "class": 'djs-lasso-overlay',
          width: 1,
          height: 1,
          x: 0,
          y: 0
        });
        append(container, frame);
      },
      update: function update(context) {
        var frame = context.frame,
            bbox = context.bbox;
        attr$1(frame, {
          x: bbox.x,
          y: bbox.y,
          width: bbox.width,
          height: bbox.height
        });
      },
      remove: function remove(context) {
        if (context.frame) {
          remove$1(context.frame);
        }
      }
    };
    toolManager.registerTool('lasso', {
      tool: 'lasso.selection',
      dragging: 'lasso'
    });
    eventBus.on('lasso.selection.end', function (event) {
      var target = event.originalEvent.target; // only reactive on diagram click
      // on some occasions, event.hover is not set and we have to check if the target is an svg

      if (!event.hover && !(target instanceof SVGElement)) {
        return;
      }

      eventBus.once('lasso.selection.ended', function () {
        self.activateLasso(event.originalEvent, true);
      });
    }); // lasso interaction implementation

    eventBus.on('lasso.end', function (event) {
      var bbox = toBBox(event);
      var elements = elementRegistry.filter(function (element) {
        return element;
      });
      self.select(elements, bbox);
    });
    eventBus.on('lasso.start', function (event) {
      var context = event.context;
      context.bbox = toBBox(event);
      visuals.create(context);
    });
    eventBus.on('lasso.move', function (event) {
      var context = event.context;
      context.bbox = toBBox(event);
      visuals.update(context);
    });
    eventBus.on('lasso.cleanup', function (event) {
      var context = event.context;
      visuals.remove(context);
    }); // event integration

    eventBus.on('element.mousedown', 1500, function (event) {
      if (!hasSecondaryModifier(event)) {
        return;
      }

      self.activateLasso(event.originalEvent); // we've handled the event

      return true;
    });
  }
  LassoTool.$inject = ['eventBus', 'canvas', 'dragging', 'elementRegistry', 'selection', 'toolManager', 'mouse'];

  LassoTool.prototype.activateLasso = function (event, autoActivate) {
    this._dragging.init(event, 'lasso', {
      autoActivate: autoActivate,
      cursor: LASSO_TOOL_CURSOR,
      data: {
        context: {}
      }
    });
  };

  LassoTool.prototype.activateSelection = function (event, autoActivate) {
    this._dragging.init(event, 'lasso.selection', {
      trapClick: false,
      autoActivate: autoActivate,
      cursor: LASSO_TOOL_CURSOR,
      data: {
        context: {}
      }
    });
  };

  LassoTool.prototype.select = function (elements, bbox) {
    var selectedElements = getEnclosedElements(elements, bbox);

    this._selection.select(values(selectedElements));
  };

  LassoTool.prototype.toggle = function () {
    if (this.isActive()) {
      return this._dragging.cancel();
    }

    var mouseEvent = this._mouse.getLastMoveEvent();

    this.activateSelection(mouseEvent, !!mouseEvent);
  };

  LassoTool.prototype.isActive = function () {
    var context = this._dragging.context();

    return context && /^lasso/.test(context.prefix);
  };

  function toBBox(event) {
    var start = {
      x: event.x - event.dx,
      y: event.y - event.dy
    };
    var end = {
      x: event.x,
      y: event.y
    };
    var bbox;

    if (start.x <= end.x && start.y < end.y || start.x < end.x && start.y <= end.y) {
      bbox = {
        x: start.x,
        y: start.y,
        width: end.x - start.x,
        height: end.y - start.y
      };
    } else if (start.x >= end.x && start.y < end.y || start.x > end.x && start.y <= end.y) {
      bbox = {
        x: end.x,
        y: start.y,
        width: start.x - end.x,
        height: end.y - start.y
      };
    } else if (start.x <= end.x && start.y > end.y || start.x < end.x && start.y >= end.y) {
      bbox = {
        x: start.x,
        y: end.y,
        width: end.x - start.x,
        height: start.y - end.y
      };
    } else if (start.x >= end.x && start.y > end.y || start.x > end.x && start.y >= end.y) {
      bbox = {
        x: end.x,
        y: end.y,
        width: start.x - end.x,
        height: start.y - end.y
      };
    } else {
      bbox = {
        x: end.x,
        y: end.y,
        width: 0,
        height: 0
      };
    }

    return bbox;
  }

  var DiagramLasso = {
    __depends__: [ToolManagerModule, MouseModule],
    __init__: ['lassoTool'],
    lassoTool: ['type', LassoTool]
  };

  /**
   * A palette provider for DMN elements.
   */

  function PaletteProvider(palette, create, elementFactory, lassoTool, translate) {
    this._palette = palette;
    this._create = create;
    this._elementFactory = elementFactory;
    this._lassoTool = lassoTool;
    this._translate = translate;
    palette.registerProvider(this);
  }
  PaletteProvider.$inject = ['palette', 'create', 'elementFactory', 'lassoTool', 'translate'];

  PaletteProvider.prototype.getPaletteEntries = function (element) {
    var actions = {},
        create = this._create,
        elementFactory = this._elementFactory,
        lassoTool = this._lassoTool,
        translate = this._translate;

    function createAction(type, group, className, title, options) {
      function createListener(event) {
        var shape = elementFactory.createShape(assign({
          type: type
        }, options));
        create.start(event, shape);
      }

      return {
        group: group,
        className: className,
        title: title,
        action: {
          dragstart: createListener,
          click: createListener
        }
      };
    }

    assign(actions, {
      'lasso-tool': {
        group: 'tools',
        className: 'dmn-icon-lasso-tool',
        title: translate('Activate the lasso tool'),
        action: {
          click: function click(event) {
            lassoTool.activateSelection(event);
          }
        }
      },
      'tool-separator': {
        group: 'tools',
        separator: true
      },
      'create.decision': createAction('dmn:Decision', 'drd', 'dmn-icon-decision', translate('Create Decision')),
      'create.input-data': createAction('dmn:InputData', 'drd', 'dmn-icon-input-data', translate('Create Input Data')),
      'create.knowledge-source': createAction('dmn:KnowledgeSource', 'drd', 'dmn-icon-knowledge-source', translate('Create Knowledge Source')),
      'create.business-knowledge-model': createAction('dmn:BusinessKnowledgeModel', 'drd', 'dmn-icon-business-knowledge', translate('Create Knowledge Model'))
    });
    return actions;
  };

  var PaletteModule = {
    __depends__: [TranslateModule, DiagramPalette, DiagramCreate, DiagramLasso],
    __init__: ['paletteProvider'],
    paletteProvider: ['type', PaletteProvider]
  };

  var max$2 = Math.max,
      min$1 = Math.min;
  var DEFAULT_CHILD_BOX_PADDING = 20;
  /**
   * Resize the given bounds by the specified delta from a given anchor point.
   *
   * @param {Bounds} bounds the bounding box that should be resized
   * @param {string} direction in which the element is resized (nw, ne, se, sw)
   * @param {Point} delta of the resize operation
   *
   * @return {Bounds} resized bounding box
   */

  function resizeBounds$1(bounds, direction, delta) {
    var dx = delta.x,
        dy = delta.y;
    var newBounds = {
      x: bounds.x,
      y: bounds.y,
      width: bounds.width,
      height: bounds.height
    };

    if (direction.indexOf('n') !== -1) {
      newBounds.y = bounds.y + dy;
      newBounds.height = bounds.height - dy;
    } else if (direction.indexOf('s') !== -1) {
      newBounds.height = bounds.height + dy;
    }

    if (direction.indexOf('e') !== -1) {
      newBounds.width = bounds.width + dx;
    } else if (direction.indexOf('w') !== -1) {
      newBounds.x = bounds.x + dx;
      newBounds.width = bounds.width - dx;
    }

    return newBounds;
  }

  function applyConstraints(attr, trbl, resizeConstraints) {
    var value = trbl[attr],
        minValue = resizeConstraints.min && resizeConstraints.min[attr],
        maxValue = resizeConstraints.max && resizeConstraints.max[attr];

    if (isNumber(minValue)) {
      value = (/top|left/.test(attr) ? min$1 : max$2)(value, minValue);
    }

    if (isNumber(maxValue)) {
      value = (/top|left/.test(attr) ? max$2 : min$1)(value, maxValue);
    }

    return value;
  }

  function ensureConstraints$1(currentBounds, resizeConstraints) {
    if (!resizeConstraints) {
      return currentBounds;
    }

    var currentTrbl = asTRBL(currentBounds);
    return asBounds({
      top: applyConstraints('top', currentTrbl, resizeConstraints),
      right: applyConstraints('right', currentTrbl, resizeConstraints),
      bottom: applyConstraints('bottom', currentTrbl, resizeConstraints),
      left: applyConstraints('left', currentTrbl, resizeConstraints)
    });
  }
  function getMinResizeBounds(direction, currentBounds, minDimensions, childrenBounds) {
    var currentBox = asTRBL(currentBounds);
    var minBox = {
      top: /n/.test(direction) ? currentBox.bottom - minDimensions.height : currentBox.top,
      left: /w/.test(direction) ? currentBox.right - minDimensions.width : currentBox.left,
      bottom: /s/.test(direction) ? currentBox.top + minDimensions.height : currentBox.bottom,
      right: /e/.test(direction) ? currentBox.left + minDimensions.width : currentBox.right
    };
    var childrenBox = childrenBounds ? asTRBL(childrenBounds) : minBox;
    var combinedBox = {
      top: min$1(minBox.top, childrenBox.top),
      left: min$1(minBox.left, childrenBox.left),
      bottom: max$2(minBox.bottom, childrenBox.bottom),
      right: max$2(minBox.right, childrenBox.right)
    };
    return asBounds(combinedBox);
  }

  function asPadding(mayBePadding, defaultValue) {
    if (typeof mayBePadding !== 'undefined') {
      return mayBePadding;
    } else {
      return DEFAULT_CHILD_BOX_PADDING;
    }
  }

  function addPadding(bbox, padding) {
    var left, right, top, bottom;

    if (_typeof(padding) === 'object') {
      left = asPadding(padding.left);
      right = asPadding(padding.right);
      top = asPadding(padding.top);
      bottom = asPadding(padding.bottom);
    } else {
      left = right = top = bottom = asPadding(padding);
    }

    return {
      x: bbox.x - left,
      y: bbox.y - top,
      width: bbox.width + left + right,
      height: bbox.height + top + bottom
    };
  }
  /**
   * Is the given element part of the resize
   * targets min boundary box?
   *
   * This is the default implementation which excludes
   * connections and labels.
   *
   * @param {djs.model.Base} element
   */

  function isBBoxChild(element) {
    // exclude connections
    if (element.waypoints) {
      return false;
    } // exclude labels


    if (element.type === 'label') {
      return false;
    }

    return true;
  }
  /**
   * Return children bounding computed from a shapes children
   * or a list of prefiltered children.
   *
   * @param  {djs.model.Shape|Array<djs.model.Shape>} shapeOrChildren
   * @param  {number|Object} padding
   *
   * @return {Bounds}
   */


  function computeChildrenBBox(shapeOrChildren, padding) {
    var elements; // compute based on shape

    if (shapeOrChildren.length === undefined) {
      // grab all the children that are part of the
      // parents children box
      elements = filter(shapeOrChildren.children, isBBoxChild);
    } else {
      elements = shapeOrChildren;
    }

    if (elements.length) {
      return addPadding(getBBox(elements), padding);
    }
  }

  var DEFAULT_MIN_WIDTH = 10;
  /**
   * A component that provides resizing of shapes on the canvas.
   *
   * The following components are part of shape resize:
   *
   *  * adding resize handles,
   *  * creating a visual during resize
   *  * checking resize rules
   *  * committing a change once finished
   *
   *
   * ## Customizing
   *
   * It's possible to customize the resizing behaviour by intercepting 'resize.start'
   * and providing the following parameters through the 'context':
   *
   *   * minDimensions ({ width, height }): minimum shape dimensions
   *
   *   * childrenBoxPadding ({ left, top, bottom, right } || number):
   *     gap between the minimum bounding box and the container
   *
   * f.ex:
   *
   * ```javascript
   * eventBus.on('resize.start', 1500, function(event) {
   *   var context = event.context,
   *
   *  context.minDimensions = { width: 140, height: 120 };
   *
   *  // Passing general padding
   *  context.childrenBoxPadding = 30;
   *
   *  // Passing padding to a specific side
   *  context.childrenBoxPadding.left = 20;
   * });
   * ```
   */

  function Resize(eventBus, rules, modeling, dragging) {
    this._dragging = dragging;
    this._rules = rules;
    var self = this;
    /**
     * Handle resize move by specified delta.
     *
     * @param {Object} context
     * @param {Point} delta
     */

    function handleMove(context, delta) {
      var shape = context.shape,
          direction = context.direction,
          resizeConstraints = context.resizeConstraints,
          newBounds;
      context.delta = delta;
      newBounds = resizeBounds$1(shape, direction, delta); // ensure constraints during resize

      context.newBounds = ensureConstraints$1(newBounds, resizeConstraints); // update + cache executable state

      context.canExecute = self.canResize(context);
    }
    /**
     * Handle resize start.
     *
     * @param  {Object} context
     */


    function handleStart(context) {
      var resizeConstraints = context.resizeConstraints,
          // evaluate minBounds for backwards compatibility
      minBounds = context.minBounds;

      if (resizeConstraints !== undefined) {
        return;
      }

      if (minBounds === undefined) {
        minBounds = self.computeMinResizeBox(context);
      }

      context.resizeConstraints = {
        min: asTRBL(minBounds)
      };
    }
    /**
     * Handle resize end.
     *
     * @param  {Object} context
     */


    function handleEnd(context) {
      var shape = context.shape,
          canExecute = context.canExecute,
          newBounds = context.newBounds;

      if (canExecute) {
        // ensure we have actual pixel values for new bounds
        // (important when zoom level was > 1 during move)
        newBounds = roundBounds(newBounds);

        if (!boundsChanged(shape, newBounds)) {
          // no resize necessary
          return;
        } // perform the actual resize


        modeling.resizeShape(shape, newBounds);
      }
    }

    eventBus.on('resize.start', function (event) {
      handleStart(event.context);
    });
    eventBus.on('resize.move', function (event) {
      var delta = {
        x: event.dx,
        y: event.dy
      };
      handleMove(event.context, delta);
    });
    eventBus.on('resize.end', function (event) {
      handleEnd(event.context);
    });
  }

  Resize.prototype.canResize = function (context) {
    var rules = this._rules;
    var ctx = pick(context, ['newBounds', 'shape', 'delta', 'direction']);
    return rules.allowed('shape.resize', ctx);
  };
  /**
   * Activate a resize operation.
   *
   * You may specify additional contextual information and must specify a
   * resize direction during activation of the resize event.
   *
   * @param {MouseEvent} event
   * @param {djs.model.Shape} shape
   * @param {Object|string} contextOrDirection
   */


  Resize.prototype.activate = function (event, shape, contextOrDirection) {
    var dragging = this._dragging,
        context,
        direction;

    if (typeof contextOrDirection === 'string') {
      contextOrDirection = {
        direction: contextOrDirection
      };
    }

    context = assign({
      shape: shape
    }, contextOrDirection);
    direction = context.direction;

    if (!direction) {
      throw new Error('must provide a direction (n|w|s|e|nw|se|ne|sw)');
    }

    dragging.init(event, getReferencePoint(shape, direction), 'resize', {
      autoActivate: true,
      cursor: getCursor(direction),
      data: {
        shape: shape,
        context: context
      }
    });
  };

  Resize.prototype.computeMinResizeBox = function (context) {
    var shape = context.shape,
        direction = context.direction,
        minDimensions,
        childrenBounds;
    minDimensions = context.minDimensions || {
      width: DEFAULT_MIN_WIDTH,
      height: DEFAULT_MIN_WIDTH
    }; // get children bounds

    childrenBounds = computeChildrenBBox(shape, context.childrenBoxPadding); // get correct minimum bounds from given resize direction
    // basically ensures that the minBounds is max(childrenBounds, minDimensions)

    return getMinResizeBounds(direction, shape, minDimensions, childrenBounds);
  };

  Resize.$inject = ['eventBus', 'rules', 'modeling', 'dragging']; // helpers //////////

  function boundsChanged(shape, newBounds) {
    return shape.x !== newBounds.x || shape.y !== newBounds.y || shape.width !== newBounds.width || shape.height !== newBounds.height;
  }

  function getReferencePoint(shape, direction) {
    var mid = getMid(shape),
        trbl = asTRBL(shape);
    var referencePoint = {
      x: mid.x,
      y: mid.y
    };

    if (direction.indexOf('n') !== -1) {
      referencePoint.y = trbl.top;
    } else if (direction.indexOf('s') !== -1) {
      referencePoint.y = trbl.bottom;
    }

    if (direction.indexOf('e') !== -1) {
      referencePoint.x = trbl.right;
    } else if (direction.indexOf('w') !== -1) {
      referencePoint.x = trbl.left;
    }

    return referencePoint;
  }

  function getCursor(direction) {
    var prefix = 'resize-';

    if (direction === 'n' || direction === 's') {
      return prefix + 'ns';
    } else if (direction === 'e' || direction === 'w') {
      return prefix + 'ew';
    } else if (direction === 'nw' || direction === 'se') {
      return prefix + 'nwse';
    } else {
      return prefix + 'nesw';
    }
  }

  var MARKER_RESIZING = 'djs-resizing',
      MARKER_RESIZE_NOT_OK = 'resize-not-ok';
  var LOW_PRIORITY$c = 500;
  /**
   * Provides previews for resizing shapes when resizing.
   *
   * @param {EventBus} eventBus
   * @param {Canvas} canvas
   * @param {PreviewSupport} previewSupport
   */

  function ResizePreview(eventBus, canvas, previewSupport) {
    /**
     * Update resizer frame.
     *
     * @param {Object} context
     */
    function updateFrame(context) {
      var shape = context.shape,
          bounds = context.newBounds,
          frame = context.frame;

      if (!frame) {
        frame = context.frame = previewSupport.addFrame(shape, canvas.getDefaultLayer());
        canvas.addMarker(shape, MARKER_RESIZING);
      }

      if (bounds.width > 5) {
        attr$1(frame, {
          x: bounds.x,
          width: bounds.width
        });
      }

      if (bounds.height > 5) {
        attr$1(frame, {
          y: bounds.y,
          height: bounds.height
        });
      }

      if (context.canExecute) {
        classes$1(frame).remove(MARKER_RESIZE_NOT_OK);
      } else {
        classes$1(frame).add(MARKER_RESIZE_NOT_OK);
      }
    }
    /**
     * Remove resizer frame.
     *
     * @param {Object} context
     */


    function removeFrame(context) {
      var shape = context.shape,
          frame = context.frame;

      if (frame) {
        remove$1(context.frame);
      }

      canvas.removeMarker(shape, MARKER_RESIZING);
    } // add and update previews


    eventBus.on('resize.move', LOW_PRIORITY$c, function (event) {
      updateFrame(event.context);
    }); // remove previews

    eventBus.on('resize.cleanup', function (event) {
      removeFrame(event.context);
    });
  }
  ResizePreview.$inject = ['eventBus', 'canvas', 'previewSupport'];

  var HANDLE_OFFSET = -6,
      HANDLE_SIZE = 4,
      HANDLE_HIT_SIZE = 20;
  var CLS_RESIZER = 'djs-resizer';
  var directions = ['n', 'w', 's', 'e', 'nw', 'ne', 'se', 'sw'];
  /**
   * This component is responsible for adding resize handles.
   *
   * @param {EventBus} eventBus
   * @param {Canvas} canvas
   * @param {Selection} selection
   * @param {Resize} resize
   */

  function ResizeHandles(eventBus, canvas, selection, resize) {
    this._resize = resize;
    this._canvas = canvas;
    var self = this;
    eventBus.on('selection.changed', function (e) {
      var newSelection = e.newSelection; // remove old selection markers

      self.removeResizers(); // add new selection markers ONLY if single selection

      if (newSelection.length === 1) {
        forEach(newSelection, bind(self.addResizer, self));
      }
    });
    eventBus.on('shape.changed', function (e) {
      var shape = e.element;

      if (selection.isSelected(shape)) {
        self.removeResizers();
        self.addResizer(shape);
      }
    });
  }

  ResizeHandles.prototype.makeDraggable = function (element, gfx, direction) {
    var resize = this._resize;

    function startResize(event) {
      // only trigger on left mouse button
      if (isPrimaryButton(event)) {
        resize.activate(event, element, direction);
      }
    }

    componentEvent.bind(gfx, 'mousedown', startResize);
    componentEvent.bind(gfx, 'touchstart', startResize);
  };

  ResizeHandles.prototype._createResizer = function (element, x, y, direction) {
    var resizersParent = this._getResizersParent();

    var offset = getHandleOffset(direction);
    var group = create('g');
    classes$1(group).add(CLS_RESIZER);
    classes$1(group).add(CLS_RESIZER + '-' + element.id);
    classes$1(group).add(CLS_RESIZER + '-' + direction);
    append(resizersParent, group);
    var visual = create('rect');
    attr$1(visual, {
      x: -HANDLE_SIZE / 2 + offset.x,
      y: -HANDLE_SIZE / 2 + offset.y,
      width: HANDLE_SIZE,
      height: HANDLE_SIZE
    });
    classes$1(visual).add(CLS_RESIZER + '-visual');
    append(group, visual);
    var hit = create('rect');
    attr$1(hit, {
      x: -HANDLE_HIT_SIZE / 2 + offset.x,
      y: -HANDLE_HIT_SIZE / 2 + offset.y,
      width: HANDLE_HIT_SIZE,
      height: HANDLE_HIT_SIZE
    });
    classes$1(hit).add(CLS_RESIZER + '-hit');
    append(group, hit);
    transform$1(group, x, y);
    return group;
  };

  ResizeHandles.prototype.createResizer = function (element, direction) {
    var point = getReferencePoint(element, direction);

    var resizer = this._createResizer(element, point.x, point.y, direction);

    this.makeDraggable(element, resizer, direction);
  }; // resize handles implementation ///////////////////////////////

  /**
   * Add resizers for a given element.
   *
   * @param {djs.model.Shape} shape
   */


  ResizeHandles.prototype.addResizer = function (shape) {
    var self = this;
    var resize = this._resize;

    if (!resize.canResize({
      shape: shape
    })) {
      return;
    }

    forEach(directions, function (direction) {
      self.createResizer(shape, direction);
    });
  };
  /**
   * Remove all resizers
   */


  ResizeHandles.prototype.removeResizers = function () {
    var resizersParent = this._getResizersParent();

    clear$1(resizersParent);
  };

  ResizeHandles.prototype._getResizersParent = function () {
    return this._canvas.getLayer('resizers');
  };

  ResizeHandles.$inject = ['eventBus', 'canvas', 'selection', 'resize']; // helpers //////////

  function getHandleOffset(direction) {
    var offset = {
      x: 0,
      y: 0
    };

    if (direction.indexOf('e') !== -1) {
      offset.x = -HANDLE_OFFSET;
    } else if (direction.indexOf('w') !== -1) {
      offset.x = HANDLE_OFFSET;
    }

    if (direction.indexOf('s') !== -1) {
      offset.y = -HANDLE_OFFSET;
    } else if (direction.indexOf('n') !== -1) {
      offset.y = HANDLE_OFFSET;
    }

    return offset;
  }

  var ResizeModule = {
    __depends__: [Rules$1, DraggingModule, PreviewSupportModule],
    __init__: ['resize', 'resizePreview', 'resizeHandles'],
    resize: ['type', Resize],
    resizePreview: ['type', ResizePreview],
    resizeHandles: ['type', ResizeHandles]
  };

  var RECONNECT_START$2 = 'reconnectStart',
      RECONNECT_END$2 = 'reconnectEnd';
  var HIGH_PRIORITY$6 = 2000;
  function DrdBendpointSnapping(eventBus) {
    eventBus.on(['bendpoint.move.move', 'bendpoint.move.end'], HIGH_PRIORITY$6, function (event) {
      var context = event.context,
          allowed = context.allowed,
          hover = context.hover,
          source = context.source,
          target = context.target,
          type = context.type;

      if (!context.hints) {
        context.hints = {};
      }

      delete context.hints.connectionStart;
      delete context.hints.connectionEnd;

      if (allowed && allowed.type !== 'dmn:InformationRequirement') {
        return;
      }

      if (!hover || !isAny(hover, ['dmn:Decision', 'dmn:InputData'])) {
        return;
      }

      if (source === target) {
        return;
      }

      var reconnect = type === RECONNECT_START$2 || type === RECONNECT_END$2;
      var orientation = getOrientation(source, target);

      if (reconnect && hover === source) {
        // (1) snap event to source
        snapToSource(event, orientation); // (2) set connection end to target

        context.hints.connectionEnd = getConnectionEnd(target, orientation);
      } else if (reconnect && hover === target) {
        // (1) set connection start to source
        context.hints.connectionStart = getConnectionStart(source, orientation); // (2) snap event to target

        snapToTarget(event, orientation);
      }
    });
  }
  DrdBendpointSnapping.$inject = ['eventBus']; // helpers //////////

  function getConnectionStart(source, orientation) {
    var sourceTrbl = asTRBL(source);
    var connectionStart = getMid(source);

    if (orientation.includes('bottom')) {
      connectionStart.y = sourceTrbl.top;
    } else if (orientation.includes('top')) {
      connectionStart.y = sourceTrbl.bottom;
    } else if (orientation.includes('right')) {
      connectionStart.x = sourceTrbl.left;
    } else {
      connectionStart.x = sourceTrbl.right;
    }

    return connectionStart;
  }

  function getConnectionEnd(target, orientation) {
    var targetTrbl = asTRBL(target);
    var connectionEnd = getMid(target);

    if (orientation.includes('bottom')) {
      connectionEnd.y = targetTrbl.bottom;
    } else if (orientation.includes('top')) {
      connectionEnd.y = targetTrbl.top;
    } else if (orientation.includes('right')) {
      connectionEnd.x = targetTrbl.right;
    } else {
      connectionEnd.x = targetTrbl.left;
    }

    return connectionEnd;
  }

  function snapToSource(event, orientation) {
    var context = event.context,
        source = context.source;
    var connectionStart = getConnectionStart(source, orientation);
    var dx = event.x - connectionStart.x,
        dy = event.y - connectionStart.y;
    event.x -= dx;
    event.y -= dy;
    event.dx -= dx;
    event.dy -= dy;
  }

  function snapToTarget(event, orientation) {
    var context = event.context,
        target = context.target;
    var connectionEnd = getConnectionEnd(target, orientation);
    var dx = 0,
        dy = 0;

    if (orientation.includes('top') || orientation.includes('bottom')) {
      dy = event.y - connectionEnd.y;
    } else {
      dx = event.x - connectionEnd.x;
    }

    event.x -= dx;
    event.y -= dy;
    event.dx -= dx;
    event.dy -= dy;
  }

  var LOW_PRIORITY$d = 250;
  function DrdConnectSnapping(eventBus) {
    eventBus.on(['connect.hover', 'connect.move', 'connect.end'], LOW_PRIORITY$d, function (event) {
      var context = event.context,
          canExecute = context.canExecute,
          hover = context.hover,
          source = context.source,
          target = context.target;

      if (canExecute && canExecute.type === 'dmn:InformationRequirement') {
        var orientation = getOrientation(source, target); // snap source

        context.connectionStart = getMid(source); // snap target

        if (hover === source) {
          context.connectionEnd = getMid(target);
        } else {
          context.connectionEnd = {
            x: event.x,
            y: event.y
          };
        }

        if (orientation.includes('bottom')) {
          context.connectionStart.y = asTRBL(source).top;
          context.connectionEnd.y = asTRBL(target).bottom;
        } else if (orientation.includes('top')) {
          context.connectionStart.y = asTRBL(source).bottom;
          context.connectionEnd.y = asTRBL(target).top;
        } else if (orientation.includes('right')) {
          context.connectionStart.x = asTRBL(source).left;
          context.connectionEnd.x = asTRBL(target).right;
        } else {
          context.connectionStart.x = asTRBL(source).right;
          context.connectionEnd.x = asTRBL(target).left;
        }
      } else {
        delete context.connectionStart;
        delete context.connectionEnd;
      }
    });
  }
  DrdConnectSnapping.$inject = ['eventBus'];

  /**
   * A snap context, containing the (possibly incomplete)
   * mappings of drop targets (to identify the snapping)
   * to computed snap points.
   */

  function SnapContext() {
    /**
     * Map<String, SnapPoints> mapping drop targets to
     * a list of possible snappings.
     *
     * @type {Object}
     */
    this._targets = {};
    /**
     * Map<String, Point> initial positioning of element
     * regarding various snap directions.
     *
     * @type {Object}
     */

    this._snapOrigins = {};
    /**
     * List of snap locations
     *
     * @type {Array<string>}
     */

    this._snapLocations = [];
    /**
     * Map<String, Array<Point>> of default snapping locations
     *
     * @type {Object}
     */

    this._defaultSnaps = {};
  }

  SnapContext.prototype.getSnapOrigin = function (snapLocation) {
    return this._snapOrigins[snapLocation];
  };

  SnapContext.prototype.setSnapOrigin = function (snapLocation, initialValue) {
    this._snapOrigins[snapLocation] = initialValue;

    if (this._snapLocations.indexOf(snapLocation) === -1) {
      this._snapLocations.push(snapLocation);
    }
  };

  SnapContext.prototype.addDefaultSnap = function (type, point) {
    var snapValues = this._defaultSnaps[type];

    if (!snapValues) {
      snapValues = this._defaultSnaps[type] = [];
    }

    snapValues.push(point);
  };
  /**
   * Return a number of initialized snaps, i.e. snap locations such as
   * top-left, mid, bottom-right and so forth.
   *
   * @return {Array<string>} snapLocations
   */


  SnapContext.prototype.getSnapLocations = function () {
    return this._snapLocations;
  };
  /**
   * Set the snap locations for this context.
   *
   * The order of locations determines precedence.
   *
   * @param {Array<string>} snapLocations
   */


  SnapContext.prototype.setSnapLocations = function (snapLocations) {
    this._snapLocations = snapLocations;
  };
  /**
   * Get snap points for a given target
   *
   * @param {Element|string} target
   */


  SnapContext.prototype.pointsForTarget = function (target) {
    var targetId = target.id || target;
    var snapPoints = this._targets[targetId];

    if (!snapPoints) {
      snapPoints = this._targets[targetId] = new SnapPoints();
      snapPoints.initDefaults(this._defaultSnaps);
    }

    return snapPoints;
  };
  /**
   * Creates the snap points and initializes them with the
   * given default values.
   *
   * @param {Object<string, Array<Point>>} [defaultPoints]
   */


  function SnapPoints(defaultSnaps) {
    /**
     * Map<String, Map<(x|y), Array<number>>> mapping snap locations,
     * i.e. top-left, bottom-right, center to actual snap values.
     *
     * @type {Object}
     */
    this._snapValues = {};
  }

  SnapPoints.prototype.add = function (snapLocation, point) {
    var snapValues = this._snapValues[snapLocation];

    if (!snapValues) {
      snapValues = this._snapValues[snapLocation] = {
        x: [],
        y: []
      };
    }

    if (snapValues.x.indexOf(point.x) === -1) {
      snapValues.x.push(point.x);
    }

    if (snapValues.y.indexOf(point.y) === -1) {
      snapValues.y.push(point.y);
    }
  };

  SnapPoints.prototype.snap = function (point, snapLocation, axis, tolerance) {
    var snappingValues = this._snapValues[snapLocation];
    return snappingValues && snapTo(point[axis], snappingValues[axis], tolerance);
  };
  /**
   * Initialize a number of default snapping points.
   *
   * @param  {Object} defaultSnaps
   */


  SnapPoints.prototype.initDefaults = function (defaultSnaps) {
    var self = this;
    forEach(defaultSnaps || {}, function (snapPoints, snapLocation) {
      forEach(snapPoints, function (point) {
        self.add(snapLocation, point);
      });
    });
  };

  var HIGHER_PRIORITY$1 = 1250;
  /**
   * Snap during create and move.
   *
   * @param {EventBus} elementRegistry
   * @param {EventBus} eventBus
   * @param {Snapping} snapping
   */

  function CreateMoveSnapping(elementRegistry, eventBus, snapping) {
    var self = this;
    this._elementRegistry = elementRegistry;
    eventBus.on(['create.start', 'shape.move.start'], function (event) {
      self.initSnap(event);
    });
    eventBus.on(['create.move', 'create.end', 'shape.move.move', 'shape.move.end'], HIGHER_PRIORITY$1, function (event) {
      var context = event.context,
          shape = context.shape,
          snapContext = context.snapContext,
          target = context.target;

      if (event.originalEvent && isCmd(event.originalEvent)) {
        return;
      }

      if (isSnapped(event) || !target) {
        return;
      }

      var snapPoints = snapContext.pointsForTarget(target);

      if (!snapPoints.initialized) {
        snapPoints = self.addSnapTargetPoints(snapPoints, shape, target);
        snapPoints.initialized = true;
      }

      snapping.snap(event, snapPoints);
    });
    eventBus.on(['create.cleanup', 'shape.move.cleanup'], function () {
      snapping.hide();
    });
  }
  CreateMoveSnapping.$inject = ['elementRegistry', 'eventBus', 'snapping'];

  CreateMoveSnapping.prototype.initSnap = function (event) {
    var elementRegistry = this._elementRegistry;
    var context = event.context,
        shape = context.shape,
        snapContext = context.snapContext;

    if (!snapContext) {
      snapContext = context.snapContext = new SnapContext();
    }

    var shapeMid;

    if (elementRegistry.get(shape.id)) {
      // move
      shapeMid = mid(shape, event);
    } else {
      // create
      shapeMid = {
        x: event.x + mid(shape).x,
        y: event.y + mid(shape).y
      };
    }

    var shapeTopLeft = {
      x: shapeMid.x - shape.width / 2,
      y: shapeMid.y - shape.height / 2
    },
        shapeBottomRight = {
      x: shapeMid.x + shape.width / 2,
      y: shapeMid.y + shape.height / 2
    };
    snapContext.setSnapOrigin('mid', {
      x: shapeMid.x - event.x,
      y: shapeMid.y - event.y
    }); // snap labels to mid only

    if (isLabel$2(shape)) {
      return snapContext;
    }

    snapContext.setSnapOrigin('top-left', {
      x: shapeTopLeft.x - event.x,
      y: shapeTopLeft.y - event.y
    });
    snapContext.setSnapOrigin('bottom-right', {
      x: shapeBottomRight.x - event.x,
      y: shapeBottomRight.y - event.y
    });
    return snapContext;
  };

  CreateMoveSnapping.prototype.addSnapTargetPoints = function (snapPoints, shape, target) {
    var snapTargets = this.getSnapTargets(shape, target);
    forEach(snapTargets, function (snapTarget) {
      // handle labels
      if (isLabel$2(snapTarget)) {
        if (isLabel$2(shape)) {
          snapPoints.add('mid', mid(snapTarget));
        }

        return;
      } // handle connections


      if (isConnection$4(snapTarget)) {
        // ignore single segment connections
        if (snapTarget.waypoints.length < 3) {
          return;
        } // ignore first and last waypoint


        var waypoints = snapTarget.waypoints.slice(1, -1);
        forEach(waypoints, function (waypoint) {
          snapPoints.add('mid', waypoint);
        });
        return;
      } // handle shapes


      snapPoints.add('mid', mid(snapTarget));
    });

    if (!isNumber(shape.x) || !isNumber(shape.y)) {
      return snapPoints;
    } // snap to original position when moving


    if (this._elementRegistry.get(shape.id)) {
      snapPoints.add('mid', mid(shape));
    }

    return snapPoints;
  };

  CreateMoveSnapping.prototype.getSnapTargets = function (shape, target) {
    return getChildren$1(target).filter(function (child) {
      return !isHidden(child);
    });
  }; // helpers //////////


  function isConnection$4(element) {
    return !!element.waypoints;
  }

  function isHidden(element) {
    return !!element.hidden;
  }

  function isLabel$2(element) {
    return !!element.labelTarget;
  }

  var HIGHER_PRIORITY$2 = 1250;
  /**
   * Snap during resize.
   *
   * @param {EventBus} eventBus
   * @param {Snapping} snapping
   */

  function ResizeSnapping(eventBus, snapping) {
    var self = this;
    eventBus.on(['resize.start'], function (event) {
      self.initSnap(event);
    });
    eventBus.on(['resize.move', 'resize.end'], HIGHER_PRIORITY$2, function (event) {
      var context = event.context,
          shape = context.shape,
          parent = shape.parent,
          direction = context.direction,
          snapContext = context.snapContext;

      if (event.originalEvent && isCmd(event.originalEvent)) {
        return;
      }

      if (isSnapped(event)) {
        return;
      }

      var snapPoints = snapContext.pointsForTarget(parent);

      if (!snapPoints.initialized) {
        snapPoints = self.addSnapTargetPoints(snapPoints, shape, parent, direction);
        snapPoints.initialized = true;
      }

      if (isHorizontal$1(direction)) {
        setSnapped(event, 'x', event.x);
      }

      if (isVertical(direction)) {
        setSnapped(event, 'y', event.y);
      }

      snapping.snap(event, snapPoints);
    });
    eventBus.on(['resize.cleanup'], function () {
      snapping.hide();
    });
  }

  ResizeSnapping.prototype.initSnap = function (event) {
    var context = event.context,
        shape = context.shape,
        direction = context.direction,
        snapContext = context.snapContext;

    if (!snapContext) {
      snapContext = context.snapContext = new SnapContext();
    }

    var snapOrigin = getSnapOrigin(shape, direction);
    snapContext.setSnapOrigin('corner', {
      x: snapOrigin.x - event.x,
      y: snapOrigin.y - event.y
    });
    return snapContext;
  };

  ResizeSnapping.prototype.addSnapTargetPoints = function (snapPoints, shape, target, direction) {
    var snapTargets = this.getSnapTargets(shape, target);
    forEach(snapTargets, function (snapTarget) {
      snapPoints.add('corner', bottomRight(snapTarget));
      snapPoints.add('corner', topLeft(snapTarget));
    });
    snapPoints.add('corner', getSnapOrigin(shape, direction));
    return snapPoints;
  };

  ResizeSnapping.$inject = ['eventBus', 'snapping'];

  ResizeSnapping.prototype.getSnapTargets = function (shape, target) {
    return getChildren$1(target).filter(function (child) {
      return !isAttached(child, shape) && !isConnection$5(child) && !isHidden$1(child) && !isLabel$3(child);
    });
  }; // helpers //////////


  function getSnapOrigin(shape, direction) {
    var mid = getMid(shape),
        trbl = asTRBL(shape);
    var snapOrigin = {
      x: mid.x,
      y: mid.y
    };

    if (direction.indexOf('n') !== -1) {
      snapOrigin.y = trbl.top;
    } else if (direction.indexOf('s') !== -1) {
      snapOrigin.y = trbl.bottom;
    }

    if (direction.indexOf('e') !== -1) {
      snapOrigin.x = trbl.right;
    } else if (direction.indexOf('w') !== -1) {
      snapOrigin.x = trbl.left;
    }

    return snapOrigin;
  }

  function isAttached(element, host) {
    return element.host === host;
  }

  function isConnection$5(element) {
    return !!element.waypoints;
  }

  function isHidden$1(element) {
    return !!element.hidden;
  }

  function isLabel$3(element) {
    return !!element.labelTarget;
  }

  function isHorizontal$1(direction) {
    return direction === 'n' || direction === 's';
  }

  function isVertical(direction) {
    return direction === 'e' || direction === 'w';
  }

  var SNAP_TOLERANCE = 7;
  var SNAP_LINE_HIDE_DELAY = 1000;
  /**
   * Generic snapping feature.
   *
   * @param {EventBus} eventBus
   * @param {Canvas} canvas
   */

  function Snapping(canvas) {
    this._canvas = canvas; // delay hide by 1000 seconds since last snap

    this._asyncHide = debounce(bind(this.hide, this), SNAP_LINE_HIDE_DELAY);
  }
  Snapping.$inject = ['canvas'];
  /**
   * Snap an event to given snap points.
   *
   * @param {Event} event
   * @param {SnapPoints} snapPoints
   */

  Snapping.prototype.snap = function (event, snapPoints) {
    var context = event.context,
        snapContext = context.snapContext,
        snapLocations = snapContext.getSnapLocations();
    var snapping = {
      x: isSnapped(event, 'x'),
      y: isSnapped(event, 'y')
    };
    forEach(snapLocations, function (location) {
      var snapOrigin = snapContext.getSnapOrigin(location);
      var snapCurrent = {
        x: event.x + snapOrigin.x,
        y: event.y + snapOrigin.y
      }; // snap both axis if not snapped already

      forEach(['x', 'y'], function (axis) {
        var locationSnapping;

        if (!snapping[axis]) {
          locationSnapping = snapPoints.snap(snapCurrent, location, axis, SNAP_TOLERANCE);

          if (locationSnapping !== undefined) {
            snapping[axis] = {
              value: locationSnapping,
              originValue: locationSnapping - snapOrigin[axis]
            };
          }
        }
      }); // no need to continue snapping

      if (snapping.x && snapping.y) {
        return false;
      }
    }); // show snap lines

    this.showSnapLine('vertical', snapping.x && snapping.x.value);
    this.showSnapLine('horizontal', snapping.y && snapping.y.value); // snap event

    forEach(['x', 'y'], function (axis) {
      var axisSnapping = snapping[axis];

      if (isObject(axisSnapping)) {
        setSnapped(event, axis, axisSnapping.originValue);
      }
    });
  };

  Snapping.prototype._createLine = function (orientation) {
    var root = this._canvas.getLayer('snap');

    var line = create('path');
    attr$1(line, {
      d: 'M0,0 L0,0'
    });
    classes$1(line).add('djs-snap-line');
    append(root, line);
    return {
      update: function update(position) {
        if (!isNumber(position)) {
          attr$1(line, {
            display: 'none'
          });
        } else {
          if (orientation === 'horizontal') {
            attr$1(line, {
              d: 'M-100000,' + position + ' L+100000,' + position,
              display: ''
            });
          } else {
            attr$1(line, {
              d: 'M ' + position + ',-100000 L ' + position + ', +100000',
              display: ''
            });
          }
        }
      }
    };
  };

  Snapping.prototype._createSnapLines = function () {
    this._snapLines = {
      horizontal: this._createLine('horizontal'),
      vertical: this._createLine('vertical')
    };
  };

  Snapping.prototype.showSnapLine = function (orientation, position) {
    var line = this.getSnapLine(orientation);

    if (line) {
      line.update(position);
    }

    this._asyncHide();
  };

  Snapping.prototype.getSnapLine = function (orientation) {
    if (!this._snapLines) {
      this._createSnapLines();
    }

    return this._snapLines[orientation];
  };

  Snapping.prototype.hide = function () {
    forEach(this._snapLines, function (snapLine) {
      snapLine.update();
    });
  };

  var SnappingModule = {
    __init__: ['createMoveSnapping', 'resizeSnapping', 'snapping'],
    createMoveSnapping: ['type', CreateMoveSnapping],
    resizeSnapping: ['type', ResizeSnapping],
    snapping: ['type', Snapping]
  };

  var SnappingModule$1 = {
    __depends__: [SnappingModule],
    __init__: ['bendpointSnapping', 'connectSnapping'],
    bendpointSnapping: ['type', DrdBendpointSnapping],
    connectSnapping: ['type', DrdConnectSnapping]
  };

  /**
   * A modeler for DMN tables.
   *
   *
   * ## Extending the Modeler
   *
   * In order to extend the viewer pass extension modules to bootstrap via the
   * `additionalModules` option. An extension module is an object that exposes
   * named services.
   *
   * The following example depicts the integration of a simple
   * logging component that integrates with interaction events:
   *
   *
   * ```javascript
   *
   * // logging component
   * function InteractionLogger(eventBus) {
   *   eventBus.on('element.hover', function(event) {
   *     console.log()
   *   })
   * }
   *
   * InteractionLogger.$inject = [ 'eventBus' ]; // minification save
   *
   * // extension module
   * var extensionModule = {
   *   __init__: [ 'interactionLogger' ],
   *   interactionLogger: [ 'type', InteractionLogger ]
   * };
   *
   * // extend the viewer
   * var dmnModeler = new Modeler({ additionalModules: [ extensionModule ] });
   * dmnModeler.importXML(...);
   * ```
   *
   *
   * ## Customizing / Replacing Components
   *
   * You can replace individual table components by redefining them in override modules.
   * This works for all components, including those defined in the core.
   *
   * Pass in override modules via the `options.additionalModules` flag like this:
   *
   * ```javascript
   * function CustomContextPadProvider(contextPad) {
   *
   *   contextPad.registerProvider(this);
   *
   *   this.getContextPadEntries = function(element) {
   *     // no entries, effectively disable the context pad
   *     return {};
   *   };
   * }
   *
   * CustomContextPadProvider.$inject = [ 'contextPad' ];
   *
   * var overrideModule = {
   *   contextPadProvider: [ 'type', CustomContextPadProvider ]
   * };
   *
   * var dmnModeler = new Modeler({ additionalModules: [ overrideModule ]});
   * ```
   *
   * @param {Object} [options] configuration options to pass to the viewer
   * @param {DOMElement} [options.container]
   *        the container to render the viewer in, defaults to body.
   * @param {string|number} [options.width] the width of the viewer
   * @param {string|number} [options.height] the height of the viewer
   * @param {Object} [options.moddleExtensions]
   *        extension packages to provide
   * @param {Array<didi.Module>} [options.modules]
   *        a list of modules to override the default modules
   * @param {Array<didi.Module>} [options.additionalModules]
   *        a list of modules to use with the default modules
   */

  function Modeler(options) {
    NavigatedViewer.call(this, options);
  }
  inherits_browser(Modeler, NavigatedViewer); // modules the modeler is composed of
  //
  // - viewer + navigation modules
  // - modeling modules

  Modeler.prototype._modelingModules = [// modeling components
  AlignElementsModule, AutoPlaceModule$1, AutoScrollModule, BendpointsModule, ContextPadModule, ConnectPreviewModule, DefinitionPropertiesModule, DistributeElementsModule$1, EditorActionsModule$1, GenerateDiModule, GridSnappingModule, KeyboardModule$1, KeyboardMoveModule, KeyboardMoveSelectionModule, LabelEditingModule, ModelingModule, MoveModule, PaletteModule, ResizeModule, SnappingModule$1];
  Modeler.prototype._modules = [].concat(Modeler.prototype._modules, Modeler.prototype._modelingModules);

  var CLASS_PATTERN$1 = /^class /;

  function isClass$1(fn) {
    return CLASS_PATTERN$1.test(fn.toString());
  }

  function isArray$3(obj) {
    return Object.prototype.toString.call(obj) === '[object Array]';
  }

  function hasOwnProp$1(obj, prop) {
    return Object.prototype.hasOwnProperty.call(obj, prop);
  }

  function annotate$1() {
    var args = Array.prototype.slice.call(arguments);

    if (args.length === 1 && isArray$3(args[0])) {
      args = args[0];
    }

    var fn = args.pop();
    fn.$inject = args;
    return fn;
  } // Current limitations:
  // - can't put into "function arg" comments
  // function /* (no parenthesis like this) */ (){}
  // function abc( /* xx (no parenthesis like this) */ a, b) {}
  //
  // Just put the comment before function or inside:
  // /* (((this is fine))) */ function(a, b) {}
  // function abc(a) { /* (((this is fine))) */}
  //
  // - can't reliably auto-annotate constructor; we'll match the
  // first constructor(...) pattern found which may be the one
  // of a nested class, too.


  var CONSTRUCTOR_ARGS$1 = /constructor\s*[^(]*\(\s*([^)]*)\)/m;
  var FN_ARGS$1 = /^(?:async )?(?:function\s*)?[^(]*\(\s*([^)]*)\)/m;
  var FN_ARG$1 = /\/\*([^*]*)\*\//m;

  function parseAnnotations$1(fn) {
    if (typeof fn !== 'function') {
      throw new Error('Cannot annotate "' + fn + '". Expected a function!');
    }

    var match = fn.toString().match(isClass$1(fn) ? CONSTRUCTOR_ARGS$1 : FN_ARGS$1); // may parse class without constructor

    if (!match) {
      return [];
    }

    return match[1] && match[1].split(',').map(function (arg) {
      match = arg.match(FN_ARG$1);
      return match ? match[1].trim() : arg.trim();
    }) || [];
  }

  function Module$1() {
    var providers = [];

    this.factory = function (name, factory) {
      providers.push([name, 'factory', factory]);
      return this;
    };

    this.value = function (name, value) {
      providers.push([name, 'value', value]);
      return this;
    };

    this.type = function (name, type) {
      providers.push([name, 'type', type]);
      return this;
    };

    this.forEach = function (iterator) {
      providers.forEach(iterator);
    };
  }

  function Injector$1(modules, parent) {
    parent = parent || {
      get: function get(name, strict) {
        currentlyResolving.push(name);

        if (strict === false) {
          return null;
        } else {
          throw error('No provider for "' + name + '"!');
        }
      }
    };
    var currentlyResolving = [];
    var providers = this._providers = Object.create(parent._providers || null);
    var instances = this._instances = Object.create(null);
    var self = instances.injector = this;

    var error = function error(msg) {
      var stack = currentlyResolving.join(' -> ');
      currentlyResolving.length = 0;
      return new Error(stack ? msg + ' (Resolving: ' + stack + ')' : msg);
    };
    /**
     * Return a named service.
     *
     * @param {String} name
     * @param {Boolean} [strict=true] if false, resolve missing services to null
     *
     * @return {Object}
     */


    var get = function get(name, strict) {
      if (!providers[name] && name.indexOf('.') !== -1) {
        var parts = name.split('.');
        var pivot = get(parts.shift());

        while (parts.length) {
          pivot = pivot[parts.shift()];
        }

        return pivot;
      }

      if (hasOwnProp$1(instances, name)) {
        return instances[name];
      }

      if (hasOwnProp$1(providers, name)) {
        if (currentlyResolving.indexOf(name) !== -1) {
          currentlyResolving.push(name);
          throw error('Cannot resolve circular dependency!');
        }

        currentlyResolving.push(name);
        instances[name] = providers[name][0](providers[name][1]);
        currentlyResolving.pop();
        return instances[name];
      }

      return parent.get(name, strict);
    };

    var fnDef = function fnDef(fn, locals) {
      if (typeof locals === 'undefined') {
        locals = {};
      }

      if (typeof fn !== 'function') {
        if (isArray$3(fn)) {
          fn = annotate$1(fn.slice());
        } else {
          throw new Error('Cannot invoke "' + fn + '". Expected a function!');
        }
      }

      var inject = fn.$inject || parseAnnotations$1(fn);
      var dependencies = inject.map(function (dep) {
        if (hasOwnProp$1(locals, dep)) {
          return locals[dep];
        } else {
          return get(dep);
        }
      });
      return {
        fn: fn,
        dependencies: dependencies
      };
    };

    var instantiate = function instantiate(Type) {
      var def = fnDef(Type);
      var fn = def.fn,
          dependencies = def.dependencies; // instantiate var args constructor

      var Constructor = Function.prototype.bind.apply(fn, [null].concat(dependencies));
      return new Constructor();
    };

    var invoke = function invoke(func, context, locals) {
      var def = fnDef(func, locals);
      var fn = def.fn,
          dependencies = def.dependencies;
      return fn.apply(context, dependencies);
    };

    var createPrivateInjectorFactory = function createPrivateInjectorFactory(privateChildInjector) {
      return annotate$1(function (key) {
        return privateChildInjector.get(key);
      });
    };

    var createChild = function createChild(modules, forceNewInstances) {
      if (forceNewInstances && forceNewInstances.length) {
        var fromParentModule = Object.create(null);
        var matchedScopes = Object.create(null);
        var privateInjectorsCache = [];
        var privateChildInjectors = [];
        var privateChildFactories = [];
        var provider;
        var cacheIdx;
        var privateChildInjector;
        var privateChildInjectorFactory;

        for (var name in providers) {
          provider = providers[name];

          if (forceNewInstances.indexOf(name) !== -1) {
            if (provider[2] === 'private') {
              cacheIdx = privateInjectorsCache.indexOf(provider[3]);

              if (cacheIdx === -1) {
                privateChildInjector = provider[3].createChild([], forceNewInstances);
                privateChildInjectorFactory = createPrivateInjectorFactory(privateChildInjector);
                privateInjectorsCache.push(provider[3]);
                privateChildInjectors.push(privateChildInjector);
                privateChildFactories.push(privateChildInjectorFactory);
                fromParentModule[name] = [privateChildInjectorFactory, name, 'private', privateChildInjector];
              } else {
                fromParentModule[name] = [privateChildFactories[cacheIdx], name, 'private', privateChildInjectors[cacheIdx]];
              }
            } else {
              fromParentModule[name] = [provider[2], provider[1]];
            }

            matchedScopes[name] = true;
          }

          if ((provider[2] === 'factory' || provider[2] === 'type') && provider[1].$scope) {
            /* jshint -W083 */
            forceNewInstances.forEach(function (scope) {
              if (provider[1].$scope.indexOf(scope) !== -1) {
                fromParentModule[name] = [provider[2], provider[1]];
                matchedScopes[scope] = true;
              }
            });
          }
        }

        forceNewInstances.forEach(function (scope) {
          if (!matchedScopes[scope]) {
            throw new Error('No provider for "' + scope + '". Cannot use provider from the parent!');
          }
        });
        modules.unshift(fromParentModule);
      }

      return new Injector$1(modules, self);
    };

    var factoryMap = {
      factory: invoke,
      type: instantiate,
      value: function value(_value) {
        return _value;
      }
    };
    modules.forEach(function (module) {
      function arrayUnwrap(type, value) {
        if (type !== 'value' && isArray$3(value)) {
          value = annotate$1(value.slice());
        }

        return value;
      } // TODO(vojta): handle wrong inputs (modules)


      if (module instanceof Module$1) {
        module.forEach(function (provider) {
          var name = provider[0];
          var type = provider[1];
          var value = provider[2];
          providers[name] = [factoryMap[type], arrayUnwrap(type, value), type];
        });
      } else if (_typeof(module) === 'object') {
        if (module.__exports__) {
          var clonedModule = Object.keys(module).reduce(function (m, key) {
            if (key.substring(0, 2) !== '__') {
              m[key] = module[key];
            }

            return m;
          }, Object.create(null));
          var privateInjector = new Injector$1((module.__modules__ || []).concat([clonedModule]), self);
          var getFromPrivateInjector = annotate$1(function (key) {
            return privateInjector.get(key);
          });

          module.__exports__.forEach(function (key) {
            providers[key] = [getFromPrivateInjector, key, 'private', privateInjector];
          });
        } else {
          Object.keys(module).forEach(function (name) {
            if (module[name][2] === 'private') {
              providers[name] = module[name];
              return;
            }

            var type = module[name][0];
            var value = module[name][1];
            providers[name] = [factoryMap[type], arrayUnwrap(type, value), type];
          });
        }
      }
    }); // public API

    this.get = get;
    this.invoke = invoke;
    this.instantiate = instantiate;
    this.createChild = createChild;
  }

  function _typeof$4(obj) {
    if (typeof Symbol === "function" && _typeof(Symbol.iterator) === "symbol") {
      _typeof$4 = function _typeof$1(obj) {
        return _typeof(obj);
      };
    } else {
      _typeof$4 = function _typeof$1(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof(obj);
      };
    }

    return _typeof$4(obj);
  }

  function _possibleConstructorReturn$3(self, call) {
    if (call && (_typeof$4(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$3(self);
  }

  function _getPrototypeOf$3(o) {
    _getPrototypeOf$3 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$3(o);
  }

  function _assertThisInitialized$3(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _inherits$3(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$3(subClass, superClass);
  }

  function _setPrototypeOf$3(o, p) {
    _setPrototypeOf$3 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$3(o, p);
  }

  function _classCallCheck$5(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }
  var Base$2 = function Base(attrs) {
    _classCallCheck$5(this, Base);

    assign(this, attrs);
    /**
     * The object that backs up the shape
     *
     * @name Base#businessObject
     * @type Object
     */

    defineProperty$2(this, 'businessObject', {
      writable: true
    });
  };
  var Root$1 =
  /*#__PURE__*/
  function (_Base) {
    _inherits$3(Root, _Base);

    function Root(attrs) {
      var _this;

      _classCallCheck$5(this, Root);

      _this = _possibleConstructorReturn$3(this, _getPrototypeOf$3(Root).call(this, attrs));
      /**
       * The tables rows
       *
       * @name Root#rows
       * @type Row
       */

      defineProperty$2(_assertThisInitialized$3(_this), 'rows', {
        enumerable: true,
        value: _this.rows || []
      });
      /**
       * The tables columns
       *
       * @name Root#cols
       * @type Col
       */

      defineProperty$2(_assertThisInitialized$3(_this), 'cols', {
        enumerable: true,
        value: _this.cols || []
      });
      return _this;
    }

    return Root;
  }(Base$2);
  var Row =
  /*#__PURE__*/
  function (_Base2) {
    _inherits$3(Row, _Base2);

    function Row(attrs) {
      var _this2;

      _classCallCheck$5(this, Row);

      _this2 = _possibleConstructorReturn$3(this, _getPrototypeOf$3(Row).call(this, attrs));
      /**
       * Reference to the table
       *
       * @name Row#root
       * @type Root
       */

      defineProperty$2(_assertThisInitialized$3(_this2), 'root', {
        writable: true
      });
      /**
       * Reference to contained cells
       *
       * @name Row#cells
       * @type Cell
       */

      defineProperty$2(_assertThisInitialized$3(_this2), 'cells', {
        enumerable: true,
        value: _this2.cells || []
      });
      return _this2;
    }

    return Row;
  }(Base$2);
  var Col =
  /*#__PURE__*/
  function (_Base3) {
    _inherits$3(Col, _Base3);

    function Col(attrs) {
      var _this3;

      _classCallCheck$5(this, Col);

      _this3 = _possibleConstructorReturn$3(this, _getPrototypeOf$3(Col).call(this, attrs));
      /**
       * Reference to the table
       *
       * @name Col#table
       * @type Root
       */

      defineProperty$2(_assertThisInitialized$3(_this3), 'root', {
        writable: true
      });
      /**
       * Reference to contained cells
       *
       * @name Row#cells
       * @type Cell
       */

      defineProperty$2(_assertThisInitialized$3(_this3), 'cells', {
        enumerable: true,
        value: _this3.cells || []
      });
      return _this3;
    }

    return Col;
  }(Base$2);
  var Cell =
  /*#__PURE__*/
  function (_Base4) {
    _inherits$3(Cell, _Base4);

    function Cell(attrs) {
      var _this4;

      _classCallCheck$5(this, Cell);

      _this4 = _possibleConstructorReturn$3(this, _getPrototypeOf$3(Cell).call(this, attrs));
      /**
       * Reference to the row
       *
       * @name Cell#row
       * @type Row
       */

      defineProperty$2(_assertThisInitialized$3(_this4), 'row', {
        writable: true
      });
      /**
       * Reference to the col
       *
       * @name Cell#col
       * @type Col
       */

      defineProperty$2(_assertThisInitialized$3(_this4), 'col', {
        writable: true
      });
      return _this4;
    }

    return Cell;
  }(Base$2);
  var TYPES = {
    root: Root$1,
    row: Row,
    col: Col,
    cell: Cell
  };
  function create$2(type, attrs) {
    var Type = TYPES[type];

    if (!Type) {
      throw new Error('unknown type ' + type);
    }

    return new Type(attrs);
  } // helpers /////////////

  function defineProperty$2(el, prop, options) {
    Object.defineProperty(el, prop, options);
  }

  function _classCallCheck$6(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$5(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$5(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$5(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$5(Constructor, staticProps);
    return Constructor;
  }

  var ElementFactory$2 =
  /*#__PURE__*/
  function () {
    function ElementFactory() {
      _classCallCheck$6(this, ElementFactory);

      this._uid = 12;
    }

    _createClass$5(ElementFactory, [{
      key: "create",
      value: function create(type) {
        var attrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        if (!attrs.id) {
          attrs.id = type + '_' + this._uid++;
        }

        return create$2(type, attrs);
      }
    }, {
      key: "createRoot",
      value: function createRoot(attrs) {
        return this.create('root', attrs);
      }
    }, {
      key: "createRow",
      value: function createRow(attrs) {
        return this.create('row', attrs);
      }
    }, {
      key: "createCol",
      value: function createCol(attrs) {
        return this.create('col', attrs);
      }
    }, {
      key: "createCell",
      value: function createCell(attrs) {
        return this.create('cell', attrs);
      }
    }]);

    return ElementFactory;
  }();

  function _classCallCheck$7(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$6(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$6(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$6(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$6(Constructor, staticProps);
    return Constructor;
  }

  var ElementRegistry$1 =
  /*#__PURE__*/
  function () {
    function ElementRegistry(eventBus) {
      _classCallCheck$7(this, ElementRegistry);

      this._eventBus = eventBus;
      this._elements = {};
      eventBus.on('table.clear', this.clear.bind(this));
    }

    _createClass$6(ElementRegistry, [{
      key: "add",
      value: function add(element, type) {
        var id = element.id;
        this._elements[id] = element;
      }
    }, {
      key: "remove",
      value: function remove(element) {
        var id = element.id || element;
        delete this._elements[id];
      }
    }, {
      key: "get",
      value: function get(id) {
        return this._elements[id];
      }
    }, {
      key: "getAll",
      value: function getAll() {
        return values$1(this._elements);
      }
    }, {
      key: "forEach",
      value: function forEach(fn) {
        values$1(this._elements).forEach(function (element) {
          return fn(element);
        });
      }
    }, {
      key: "filter",
      value: function filter(fn) {
        return values$1(this._elements).filter(function (element) {
          return fn(element);
        });
      }
    }, {
      key: "clear",
      value: function clear() {
        this._elements = {};
      }
    }, {
      key: "updateId",
      value: function updateId(element, newId) {
        this._validateId(newId);

        if (typeof element === 'string') {
          element = this.get(element);
        }

        this._eventBus.fire('element.updateId', {
          element: element,
          newId: newId
        });

        this.remove(element);
        element.id = newId;
        this.add(element);
      }
      /**
      * Validate the suitability of the given id and signals a problem
      * with an exception.
      *
      * @param {String} id
      *
      * @throws {Error} if id is empty or already assigned
      */

    }, {
      key: "_validateId",
      value: function _validateId(id) {
        if (!id) {
          throw new Error('element must have an id');
        }

        if (this._elements[id]) {
          throw new Error('element with id ' + id + ' already added');
        }
      }
    }]);

    return ElementRegistry;
  }();
  ElementRegistry$1.$inject = ['eventBus']; // helpers

  function values$1(obj) {
    return Object.keys(obj).map(function (k) {
      return obj[k];
    });
  }

  function _classCallCheck$8(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$7(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$7(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$7(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$7(Constructor, staticProps);
    return Constructor;
  }

  var ChangeSupport$1 =
  /*#__PURE__*/
  function () {
    function ChangeSupport(eventBus) {
      var _this = this;

      _classCallCheck$8(this, ChangeSupport);

      this._listeners = {};
      eventBus.on('elements.changed', function (_ref) {
        var elements = _ref.elements;

        _this.elementsChanged(elements);
      });
      eventBus.on('root.remove', function (context) {
        var oldRootId = context.root.id;

        if (_this._listeners[oldRootId]) {
          eventBus.once('root.add', function (context) {
            var newRootId = context.root.id;

            _this.updateId(oldRootId, newRootId);
          });
        }
      });
      eventBus.on('element.updateId', function (_ref2) {
        var element = _ref2.element,
            newId = _ref2.newId;

        _this.updateId(element.id, newId);
      });
    }

    _createClass$7(ChangeSupport, [{
      key: "elementsChanged",
      value: function elementsChanged(elements) {
        var invoked = {};
        var elementsLength = elements.length;

        for (var i = 0; i < elementsLength; i++) {
          var id = elements[i].id;

          if (invoked[id]) {
            return;
          }

          invoked[id] = true;
          var listenersLength = this._listeners[id] && this._listeners[id].length;

          if (listenersLength) {
            for (var j = 0; j < listenersLength; j++) {
              // listeners might remove themselves before they get called
              this._listeners[id][j] && this._listeners[id][j]();
            }
          }
        }
      }
    }, {
      key: "onElementsChanged",
      value: function onElementsChanged(id, listener) {
        if (!this._listeners[id]) {
          this._listeners[id] = [];
        } // avoid push for better performance


        this._listeners[id][this._listeners[id].length] = listener;
      }
    }, {
      key: "offElementsChanged",
      value: function offElementsChanged(id, listener) {
        if (!this._listeners[id]) {
          return;
        }

        if (listener) {
          var idx = this._listeners[id].indexOf(listener);

          if (idx !== -1) {
            this._listeners[id].splice(idx, 1);
          }
        } else {
          this._listeners[id].length = 0;
        }
      }
    }, {
      key: "updateId",
      value: function updateId(oldId, newId) {
        if (this._listeners[oldId]) {
          this._listeners[newId] = this._listeners[oldId];
          delete this._listeners[oldId];
        }
      }
    }]);

    return ChangeSupport;
  }();
  ChangeSupport$1.$inject = ['eventBus'];

  function _classCallCheck$9(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$8(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$8(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$8(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$8(Constructor, staticProps);
    return Constructor;
  }
  var DEFAULT_PRIORITY$6 = 1000;

  var Components =
  /*#__PURE__*/
  function () {
    function Components() {
      _classCallCheck$9(this, Components);

      this._listeners = {};
    }

    _createClass$8(Components, [{
      key: "getComponent",
      value: function getComponent(type, context) {
        var listeners = this._listeners[type];

        if (!listeners) {
          return;
        }

        var component;

        for (var i = 0; i < listeners.length; i++) {
          component = listeners[i].callback(context);

          if (component) {
            break;
          }
        }

        return component;
      }
    }, {
      key: "getComponents",
      value: function getComponents(type, context) {
        var listeners = this._listeners[type];
        var components = [];

        if (!listeners) {
          return components;
        }

        for (var i = 0; i < listeners.length; i++) {
          var component = listeners[i].callback(context);

          if (component) {
            components.push(component);
          }
        }

        if (!components.length) {
          return components;
        }

        return components;
      }
    }, {
      key: "onGetComponent",
      value: function onGetComponent(type, priority, callback) {
        if (isFunction(priority)) {
          callback = priority;
          priority = DEFAULT_PRIORITY$6;
        }

        if (!isNumber(priority)) {
          throw new Error('priority must be a number');
        }

        var listeners = this._getListeners(type);

        var existingListener, idx;
        var newListener = {
          priority: priority,
          callback: callback
        };

        for (idx = 0; existingListener = listeners[idx]; idx++) {
          if (existingListener.priority < priority) {
            // prepend newListener at before existingListener
            listeners.splice(idx, 0, newListener);
            return;
          }
        }

        listeners.push(newListener);
      }
    }, {
      key: "offGetComponent",
      value: function offGetComponent(type, callback) {
        var listeners = this._getListeners(type);

        var listener, listenerCallback, idx;

        if (callback) {
          // move through listeners from back to front
          // and remove matching listeners
          for (idx = listeners.length - 1; listener = listeners[idx]; idx--) {
            listenerCallback = listener.callback;

            if (listenerCallback === callback) {
              listeners.splice(idx, 1);
            }
          }
        } else {
          // clear listeners
          listeners.length = 0;
        }
      }
    }, {
      key: "_getListeners",
      value: function _getListeners(type) {
        var listeners = this._listeners[type];

        if (!listeners) {
          this._listeners[type] = listeners = [];
        }

        return listeners;
      }
    }]);

    return Components;
  }();

  var NO_OP = '$NO_OP';
  var ERROR_MSG = 'a runtime error occured! Use Inferno in development environment to find the error.'; // This should be boolean and not reference to window.document
  // in Node 7 and the later versions of V8, slower in older versions though

  var isArray$4 = Array.isArray;

  function isStringOrNumber(o) {
    var type = _typeof(o);

    return type === 'string' || type === 'number';
  }

  function isNullOrUndef(o) {
    return isUndefined$2(o) || isNull(o);
  }

  function isInvalid(o) {
    return isNull(o) || o === false || isTrue(o) || isUndefined$2(o);
  }

  function isFunction$1(o) {
    return typeof o === 'function';
  }

  function isString$1(o) {
    return typeof o === 'string';
  }

  function isNumber$1(o) {
    return typeof o === 'number';
  }

  function isNull(o) {
    return o === null;
  }

  function isTrue(o) {
    return o === true;
  }

  function isUndefined$2(o) {
    return o === void 0;
  }

  function isObject$1(o) {
    return _typeof(o) === 'object';
  }

  function throwError(message) {
    if (!message) {
      message = ERROR_MSG;
    }

    throw new Error("Inferno Error: " + message);
  }

  function combineFrom(first, second) {
    var out = {};

    if (first) {
      for (var key in first) {
        out[key] = first[key];
      }
    }

    if (second) {
      for (var key$1 in second) {
        out[key$1] = second[key$1];
      }
    }

    return out;
  }

  var keyPrefix = '$';

  function getVNode(childFlags, children, className, flags, key, props, ref, type) {
    return {
      childFlags: childFlags,
      children: children,
      className: className,
      dom: null,
      flags: flags,
      key: key === void 0 ? null : key,
      parentVNode: null,
      props: props === void 0 ? null : props,
      ref: ref === void 0 ? null : ref,
      type: type
    };
  }

  function createVNode(flags, type, className, children, childFlags, props, key, ref) {
    var childFlag = childFlags === void 0 ? 1
    /* HasInvalidChildren */
    : childFlags;
    var vNode = getVNode(childFlag, children, className, flags, key, props, ref, type);

    if (childFlag === 0
    /* UnknownChildren */
    ) {
        normalizeChildren(vNode, vNode.children);
      }

    return vNode;
  }

  function createComponentVNode(flags, type, props, key, ref) {
    if ((flags & 2
    /* ComponentUnknown */
    ) > 0) {
      flags = type.prototype && isFunction$1(type.prototype.render) ? 4
      /* ComponentClass */
      : 8
      /* ComponentFunction */
      ;
    } // set default props


    var defaultProps = type.defaultProps;

    if (!isNullOrUndef(defaultProps)) {
      if (!props) {
        props = {}; // Props can be referenced and modified at application level so always create new object
      }

      for (var prop in defaultProps) {
        if (isUndefined$2(props[prop])) {
          props[prop] = defaultProps[prop];
        }
      }
    }

    if ((flags & 8
    /* ComponentFunction */
    ) > 0) {
      var defaultHooks = type.defaultHooks;

      if (!isNullOrUndef(defaultHooks)) {
        if (!ref) {
          // As ref cannot be referenced from application level, we can use the same refs object
          ref = defaultHooks;
        } else {
          for (var prop$1 in defaultHooks) {
            if (isUndefined$2(ref[prop$1])) {
              ref[prop$1] = defaultHooks[prop$1];
            }
          }
        }
      }
    }

    var vNode = getVNode(1
    /* HasInvalidChildren */
    , null, null, flags, key, props, ref, type);
    var optsVNode = options.createVNode;

    if (isFunction$1(optsVNode)) {
      optsVNode(vNode);
    }

    return vNode;
  }

  function createTextVNode(text, key) {
    return getVNode(1
    /* HasInvalidChildren */
    , isNullOrUndef(text) ? '' : text, null, 16
    /* Text */
    , key, null, null, null);
  }

  function normalizeProps(vNode) {
    var props = vNode.props;

    if (props) {
      var flags = vNode.flags;

      if (flags & 481
      /* Element */
      ) {
          if (props.children !== void 0 && isNullOrUndef(vNode.children)) {
            normalizeChildren(vNode, props.children);
          }

          if (props.className !== void 0) {
            vNode.className = props.className || null;
            props.className = undefined;
          }
        }

      if (props.key !== void 0) {
        vNode.key = props.key;
        props.key = undefined;
      }

      if (props.ref !== void 0) {
        if (flags & 8
        /* ComponentFunction */
        ) {
            vNode.ref = combineFrom(vNode.ref, props.ref);
          } else {
          vNode.ref = props.ref;
        }

        props.ref = undefined;
      }
    }

    return vNode;
  }

  function directClone(vNodeToClone) {
    var newVNode;
    var flags = vNodeToClone.flags;

    if (flags & 14
    /* Component */
    ) {
        var props;
        var propsToClone = vNodeToClone.props;

        if (!isNull(propsToClone)) {
          props = {};

          for (var key in propsToClone) {
            props[key] = propsToClone[key];
          }
        }

        newVNode = createComponentVNode(flags, vNodeToClone.type, props, vNodeToClone.key, vNodeToClone.ref);
      } else if (flags & 481
    /* Element */
    ) {
        var children = vNodeToClone.children;
        newVNode = createVNode(flags, vNodeToClone.type, vNodeToClone.className, children, vNodeToClone.childFlags, vNodeToClone.props, vNodeToClone.key, vNodeToClone.ref);
      } else if (flags & 16
    /* Text */
    ) {
        newVNode = createTextVNode(vNodeToClone.children, vNodeToClone.key);
      } else if (flags & 1024
    /* Portal */
    ) {
        newVNode = vNodeToClone;
      }

    return newVNode;
  }

  function createVoidVNode() {
    return createTextVNode('', null);
  }

  function _normalizeVNodes(nodes, result, index, currentKey) {
    for (var len = nodes.length; index < len; index++) {
      var n = nodes[index];

      if (!isInvalid(n)) {
        var newKey = currentKey + keyPrefix + index;

        if (isArray$4(n)) {
          _normalizeVNodes(n, result, 0, newKey);
        } else {
          if (isStringOrNumber(n)) {
            n = createTextVNode(n, newKey);
          } else {
            var oldKey = n.key;
            var isPrefixedKey = isString$1(oldKey) && oldKey[0] === keyPrefix;

            if (!isNull(n.dom) || isPrefixedKey) {
              n = directClone(n);
            }

            if (isNull(oldKey) || isPrefixedKey) {
              n.key = newKey;
            } else {
              n.key = currentKey + oldKey;
            }
          }

          result.push(n);
        }
      }
    }
  }

  function normalizeChildren(vNode, children) {
    var newChildren;
    var newChildFlags = 1
    /* HasInvalidChildren */
    ; // Don't change children to match strict equal (===) true in patching

    if (isInvalid(children)) {
      newChildren = children;
    } else if (isString$1(children)) {
      newChildFlags = 2
      /* HasVNodeChildren */
      ;
      newChildren = createTextVNode(children);
    } else if (isNumber$1(children)) {
      newChildFlags = 2
      /* HasVNodeChildren */
      ;
      newChildren = createTextVNode(children + '');
    } else if (isArray$4(children)) {
      var len = children.length;

      if (len === 0) {
        newChildren = null;
        newChildFlags = 1
        /* HasInvalidChildren */
        ;
      } else {
        // we assign $ which basically means we've flagged this array for future note
        // if it comes back again, we need to clone it, as people are using it
        // in an immutable way
        // tslint:disable-next-line
        if (Object.isFrozen(children) || children['$'] === true) {
          children = children.slice();
        }

        newChildFlags = 8
        /* HasKeyedChildren */
        ;

        for (var i = 0; i < len; i++) {
          var n = children[i];

          if (isInvalid(n) || isArray$4(n)) {
            newChildren = newChildren || children.slice(0, i);

            _normalizeVNodes(children, newChildren, i, '');

            break;
          } else if (isStringOrNumber(n)) {
            newChildren = newChildren || children.slice(0, i);
            newChildren.push(createTextVNode(n, keyPrefix + i));
          } else {
            var key = n.key;
            var isNullDom = isNull(n.dom);
            var isNullKey = isNull(key);
            var isPrefixed = !isNullKey && key[0] === keyPrefix;

            if (!isNullDom || isNullKey || isPrefixed) {
              newChildren = newChildren || children.slice(0, i);

              if (!isNullDom || isPrefixed) {
                n = directClone(n);
              }

              if (isNullKey || isPrefixed) {
                n.key = keyPrefix + i;
              }

              newChildren.push(n);
            } else if (newChildren) {
              newChildren.push(n);
            }
          }
        }

        newChildren = newChildren || children;
        newChildren.$ = true;
      }
    } else {
      newChildren = children;

      if (!isNull(children.dom)) {
        newChildren = directClone(children);
      }

      newChildFlags = 2
      /* HasVNodeChildren */
      ;
    }

    vNode.children = newChildren;
    vNode.childFlags = newChildFlags;
    return vNode;
  }

  var options = {
    afterMount: null,
    afterRender: null,
    afterUpdate: null,
    beforeRender: null,
    beforeUnmount: null,
    createVNode: null,
    roots: []
  };

  var xlinkNS = 'http://www.w3.org/1999/xlink';
  var xmlNS = 'http://www.w3.org/XML/1998/namespace';
  var svgNS = 'http://www.w3.org/2000/svg';
  var namespaces = {
    'xlink:actuate': xlinkNS,
    'xlink:arcrole': xlinkNS,
    'xlink:href': xlinkNS,
    'xlink:role': xlinkNS,
    'xlink:show': xlinkNS,
    'xlink:title': xlinkNS,
    'xlink:type': xlinkNS,
    'xml:base': xmlNS,
    'xml:lang': xmlNS,
    'xml:space': xmlNS
  }; // We need EMPTY_OBJ defined in one place.
  // Its used for comparison so we cant inline it into shared

  var EMPTY_OBJ = {};
  var LIFECYCLE = [];

  function appendChild(parentDom, dom) {
    parentDom.appendChild(dom);
  }

  function insertOrAppend(parentDom, newNode, nextNode) {
    if (isNullOrUndef(nextNode)) {
      appendChild(parentDom, newNode);
    } else {
      parentDom.insertBefore(newNode, nextNode);
    }
  }

  function documentCreateElement(tag, isSVG) {
    if (isSVG === true) {
      return document.createElementNS(svgNS, tag);
    }

    return document.createElement(tag);
  }

  function replaceChild(parentDom, newDom, lastDom) {
    parentDom.replaceChild(newDom, lastDom);
  }

  function removeChild(parentDom, dom) {
    parentDom.removeChild(dom);
  }

  function callAll(arrayFn) {
    var listener;

    while ((listener = arrayFn.shift()) !== undefined) {
      listener();
    }
  }

  var attachedEventCounts = {};
  var attachedEvents = {};

  function handleEvent(name, nextEvent, dom) {
    var eventsLeft = attachedEventCounts[name];
    var eventsObject = dom.$EV;

    if (nextEvent) {
      if (!eventsLeft) {
        attachedEvents[name] = attachEventToDocument(name);
        attachedEventCounts[name] = 0;
      }

      if (!eventsObject) {
        eventsObject = dom.$EV = {};
      }

      if (!eventsObject[name]) {
        attachedEventCounts[name]++;
      }

      eventsObject[name] = nextEvent;
    } else if (eventsObject && eventsObject[name]) {
      attachedEventCounts[name]--;

      if (eventsLeft === 1) {
        document.removeEventListener(normalizeEventName(name), attachedEvents[name]);
        attachedEvents[name] = null;
      }

      eventsObject[name] = nextEvent;
    }
  }

  function dispatchEvents(event, target, isClick, name, eventData) {
    var dom = target;

    while (!isNull(dom)) {
      // Html Nodes can be nested fe: span inside button in that scenario browser does not handle disabled attribute on parent,
      // because the event listener is on document.body
      // Don't process clicks on disabled elements
      if (isClick && dom.disabled) {
        return;
      }

      var eventsObject = dom.$EV;

      if (eventsObject) {
        var currentEvent = eventsObject[name];

        if (currentEvent) {
          // linkEvent object
          eventData.dom = dom;

          if (currentEvent.event) {
            currentEvent.event(currentEvent.data, event);
          } else {
            currentEvent(event);
          }

          if (event.cancelBubble) {
            return;
          }
        }
      }

      dom = dom.parentNode;
    }
  }

  function normalizeEventName(name) {
    return name.substr(2).toLowerCase();
  }

  function stopPropagation$2() {
    this.cancelBubble = true;

    if (!this.immediatePropagationStopped) {
      this.stopImmediatePropagation();
    }
  }

  function attachEventToDocument(name) {
    var docEvent = function docEvent(event) {
      var type = event.type;
      var isClick = type === 'click' || type === 'dblclick';

      if (isClick && event.button !== 0) {
        // Firefox incorrectly triggers click event for mid/right mouse buttons.
        // This bug has been active for 12 years.
        // https://bugzilla.mozilla.org/show_bug.cgi?id=184051
        event.preventDefault();
        event.stopPropagation();
        return false;
      }

      event.stopPropagation = stopPropagation$2; // Event data needs to be object to save reference to currentTarget getter

      var eventData = {
        dom: document
      };
      Object.defineProperty(event, 'currentTarget', {
        configurable: true,
        get: function get() {
          return eventData.dom;
        }
      });
      dispatchEvents(event, event.target, isClick, name, eventData);
      return;
    };

    document.addEventListener(normalizeEventName(name), docEvent);
    return docEvent;
  }

  function isSameInnerHTML(dom, innerHTML) {
    var tempdom = document.createElement('i');
    tempdom.innerHTML = innerHTML;
    return tempdom.innerHTML === dom.innerHTML;
  }

  function isSamePropsInnerHTML(dom, props) {
    return Boolean(props && props.dangerouslySetInnerHTML && props.dangerouslySetInnerHTML.__html && isSameInnerHTML(dom, props.dangerouslySetInnerHTML.__html));
  }

  function triggerEventListener(props, methodName, e) {
    if (props[methodName]) {
      var listener = props[methodName];

      if (listener.event) {
        listener.event(listener.data, e);
      } else {
        listener(e);
      }
    } else {
      var nativeListenerName = methodName.toLowerCase();

      if (props[nativeListenerName]) {
        props[nativeListenerName](e);
      }
    }
  }

  function createWrappedFunction(methodName, applyValue) {
    var fnMethod = function fnMethod(e) {
      e.stopPropagation();
      var vNode = this.$V; // If vNode is gone by the time event fires, no-op

      if (!vNode) {
        return;
      }

      var props = vNode.props || EMPTY_OBJ;
      var dom = vNode.dom;

      if (isString$1(methodName)) {
        triggerEventListener(props, methodName, e);
      } else {
        for (var i = 0; i < methodName.length; i++) {
          triggerEventListener(props, methodName[i], e);
        }
      }

      if (isFunction$1(applyValue)) {
        var newVNode = this.$V;
        var newProps = newVNode.props || EMPTY_OBJ;
        applyValue(newProps, dom, false, newVNode);
      }
    };

    Object.defineProperty(fnMethod, 'wrapped', {
      configurable: false,
      enumerable: false,
      value: true,
      writable: false
    });
    return fnMethod;
  }

  function isCheckedType(type) {
    return type === 'checkbox' || type === 'radio';
  }

  var onTextInputChange = createWrappedFunction('onInput', applyValueInput);
  var wrappedOnChange = createWrappedFunction(['onClick', 'onChange'], applyValueInput);
  /* tslint:disable-next-line:no-empty */

  function emptywrapper(event) {
    event.stopPropagation();
  }

  emptywrapper.wrapped = true;

  function inputEvents(dom, nextPropsOrEmpty) {
    if (isCheckedType(nextPropsOrEmpty.type)) {
      dom.onchange = wrappedOnChange;
      dom.onclick = emptywrapper;
    } else {
      dom.oninput = onTextInputChange;
    }
  }

  function applyValueInput(nextPropsOrEmpty, dom) {
    var type = nextPropsOrEmpty.type;
    var value = nextPropsOrEmpty.value;
    var checked = nextPropsOrEmpty.checked;
    var multiple = nextPropsOrEmpty.multiple;
    var defaultValue = nextPropsOrEmpty.defaultValue;
    var hasValue = !isNullOrUndef(value);

    if (type && type !== dom.type) {
      dom.setAttribute('type', type);
    }

    if (!isNullOrUndef(multiple) && multiple !== dom.multiple) {
      dom.multiple = multiple;
    }

    if (!isNullOrUndef(defaultValue) && !hasValue) {
      dom.defaultValue = defaultValue + '';
    }

    if (isCheckedType(type)) {
      if (hasValue) {
        dom.value = value;
      }

      if (!isNullOrUndef(checked)) {
        dom.checked = checked;
      }
    } else {
      if (hasValue && dom.value !== value) {
        dom.defaultValue = value;
        dom.value = value;
      } else if (!isNullOrUndef(checked)) {
        dom.checked = checked;
      }
    }
  }

  function updateChildOptionGroup(vNode, value) {
    var type = vNode.type;

    if (type === 'optgroup') {
      var children = vNode.children;
      var childFlags = vNode.childFlags;

      if (childFlags & 12
      /* MultipleChildren */
      ) {
          for (var i = 0, len = children.length; i < len; i++) {
            updateChildOption(children[i], value);
          }
        } else if (childFlags === 2
      /* HasVNodeChildren */
      ) {
          updateChildOption(children, value);
        }
    } else {
      updateChildOption(vNode, value);
    }
  }

  function updateChildOption(vNode, value) {
    var props = vNode.props || EMPTY_OBJ;
    var dom = vNode.dom; // we do this as multiple may have changed

    dom.value = props.value;

    if (isArray$4(value) && value.indexOf(props.value) !== -1 || props.value === value) {
      dom.selected = true;
    } else if (!isNullOrUndef(value) || !isNullOrUndef(props.selected)) {
      dom.selected = props.selected || false;
    }
  }

  var onSelectChange = createWrappedFunction('onChange', applyValueSelect);

  function selectEvents(dom) {
    dom.onchange = onSelectChange;
  }

  function applyValueSelect(nextPropsOrEmpty, dom, mounting, vNode) {
    var multiplePropInBoolean = Boolean(nextPropsOrEmpty.multiple);

    if (!isNullOrUndef(nextPropsOrEmpty.multiple) && multiplePropInBoolean !== dom.multiple) {
      dom.multiple = multiplePropInBoolean;
    }

    var childFlags = vNode.childFlags;

    if ((childFlags & 1
    /* HasInvalidChildren */
    ) === 0) {
      var children = vNode.children;
      var value = nextPropsOrEmpty.value;

      if (mounting && isNullOrUndef(value)) {
        value = nextPropsOrEmpty.defaultValue;
      }

      if (childFlags & 12
      /* MultipleChildren */
      ) {
          for (var i = 0, len = children.length; i < len; i++) {
            updateChildOptionGroup(children[i], value);
          }
        } else if (childFlags === 2
      /* HasVNodeChildren */
      ) {
          updateChildOptionGroup(children, value);
        }
    }
  }

  var onTextareaInputChange = createWrappedFunction('onInput', applyValueTextArea);
  var wrappedOnChange$1 = createWrappedFunction('onChange');

  function textAreaEvents(dom, nextPropsOrEmpty) {
    dom.oninput = onTextareaInputChange;

    if (nextPropsOrEmpty.onChange) {
      dom.onchange = wrappedOnChange$1;
    }
  }

  function applyValueTextArea(nextPropsOrEmpty, dom, mounting) {
    var value = nextPropsOrEmpty.value;
    var domValue = dom.value;

    if (isNullOrUndef(value)) {
      if (mounting) {
        var defaultValue = nextPropsOrEmpty.defaultValue;

        if (!isNullOrUndef(defaultValue) && defaultValue !== domValue) {
          dom.defaultValue = defaultValue;
          dom.value = defaultValue;
        }
      }
    } else if (domValue !== value) {
      /* There is value so keep it controlled */
      dom.defaultValue = value;
      dom.value = value;
    }
  }
  /**
   * There is currently no support for switching same input between controlled and nonControlled
   * If that ever becomes a real issue, then re design controlled elements
   * Currently user must choose either controlled or non-controlled and stick with that
   */


  function processElement(flags, vNode, dom, nextPropsOrEmpty, mounting, isControlled) {
    if (flags & 64
    /* InputElement */
    ) {
        applyValueInput(nextPropsOrEmpty, dom);
      } else if (flags & 256
    /* SelectElement */
    ) {
        applyValueSelect(nextPropsOrEmpty, dom, mounting, vNode);
      } else if (flags & 128
    /* TextareaElement */
    ) {
        applyValueTextArea(nextPropsOrEmpty, dom, mounting);
      }

    if (isControlled) {
      dom.$V = vNode;
    }
  }

  function addFormElementEventHandlers(flags, dom, nextPropsOrEmpty) {
    if (flags & 64
    /* InputElement */
    ) {
        inputEvents(dom, nextPropsOrEmpty);
      } else if (flags & 256
    /* SelectElement */
    ) {
        selectEvents(dom);
      } else if (flags & 128
    /* TextareaElement */
    ) {
        textAreaEvents(dom, nextPropsOrEmpty);
      }
  }

  function isControlledFormElement(nextPropsOrEmpty) {
    return nextPropsOrEmpty.type && isCheckedType(nextPropsOrEmpty.type) ? !isNullOrUndef(nextPropsOrEmpty.checked) : !isNullOrUndef(nextPropsOrEmpty.value);
  }

  function remove$3(vNode, parentDom) {
    unmount(vNode);

    if (!isNull(parentDom)) {
      removeChild(parentDom, vNode.dom); // Let carbage collector free memory

      vNode.dom = null;
    }
  }

  function unmount(vNode) {
    var flags = vNode.flags;

    if (flags & 481
    /* Element */
    ) {
        var ref = vNode.ref;
        var props = vNode.props;

        if (isFunction$1(ref)) {
          ref(null);
        }

        var children = vNode.children;
        var childFlags = vNode.childFlags;

        if (childFlags & 12
        /* MultipleChildren */
        ) {
            unmountAllChildren(children);
          } else if (childFlags === 2
        /* HasVNodeChildren */
        ) {
            unmount(children);
          }

        if (!isNull(props)) {
          for (var name in props) {
            switch (name) {
              case 'onClick':
              case 'onDblClick':
              case 'onFocusIn':
              case 'onFocusOut':
              case 'onKeyDown':
              case 'onKeyPress':
              case 'onKeyUp':
              case 'onMouseDown':
              case 'onMouseMove':
              case 'onMouseUp':
              case 'onSubmit':
              case 'onTouchEnd':
              case 'onTouchMove':
              case 'onTouchStart':
                handleEvent(name, null, vNode.dom);
                break;
            }
          }
        }
      } else if (flags & 14
    /* Component */
    ) {
        var instance = vNode.children;
        var ref$1 = vNode.ref;

        if (flags & 4
        /* ComponentClass */
        ) {
            if (isFunction$1(options.beforeUnmount)) {
              options.beforeUnmount(vNode);
            }

            if (isFunction$1(instance.componentWillUnmount)) {
              instance.componentWillUnmount();
            }

            if (isFunction$1(ref$1)) {
              ref$1(null);
            }

            instance.$UN = true;
            unmount(instance.$LI);
          } else {
          if (!isNullOrUndef(ref$1) && isFunction$1(ref$1.onComponentWillUnmount)) {
            ref$1.onComponentWillUnmount(vNode.dom, vNode.props || EMPTY_OBJ);
          }

          unmount(instance);
        }
      } else if (flags & 1024
    /* Portal */
    ) {
        var children$1 = vNode.children;

        if (!isNull(children$1) && isObject$1(children$1)) {
          remove$3(children$1, vNode.type);
        }
      }
  }

  function unmountAllChildren(children) {
    for (var i = 0, len = children.length; i < len; i++) {
      unmount(children[i]);
    }
  }

  function removeAllChildren(dom, children) {
    unmountAllChildren(children);
    dom.textContent = '';
  }

  function createLinkEvent(linkEvent, nextValue) {
    return function (e) {
      linkEvent(nextValue.data, e);
    };
  }

  function patchEvent(name, lastValue, nextValue, dom) {
    var nameLowerCase = name.toLowerCase();

    if (!isFunction$1(nextValue) && !isNullOrUndef(nextValue)) {
      var linkEvent = nextValue.event;

      if (linkEvent && isFunction$1(linkEvent)) {
        dom[nameLowerCase] = createLinkEvent(linkEvent, nextValue);
      }
    } else {
      var domEvent = dom[nameLowerCase]; // if the function is wrapped, that means it's been controlled by a wrapper

      if (!domEvent || !domEvent.wrapped) {
        dom[nameLowerCase] = nextValue;
      }
    }
  }

  function getNumberStyleValue(style, value) {
    switch (style) {
      case 'animationIterationCount':
      case 'borderImageOutset':
      case 'borderImageSlice':
      case 'borderImageWidth':
      case 'boxFlex':
      case 'boxFlexGroup':
      case 'boxOrdinalGroup':
      case 'columnCount':
      case 'fillOpacity':
      case 'flex':
      case 'flexGrow':
      case 'flexNegative':
      case 'flexOrder':
      case 'flexPositive':
      case 'flexShrink':
      case 'floodOpacity':
      case 'fontWeight':
      case 'gridColumn':
      case 'gridRow':
      case 'lineClamp':
      case 'lineHeight':
      case 'opacity':
      case 'order':
      case 'orphans':
      case 'stopOpacity':
      case 'strokeDasharray':
      case 'strokeDashoffset':
      case 'strokeMiterlimit':
      case 'strokeOpacity':
      case 'strokeWidth':
      case 'tabSize':
      case 'widows':
      case 'zIndex':
      case 'zoom':
        return value;

      default:
        return value + 'px';
    }
  } // We are assuming here that we come from patchProp routine
  // -nextAttrValue cannot be null or undefined


  function patchStyle(lastAttrValue, nextAttrValue, dom) {
    var domStyle = dom.style;
    var style;
    var value;

    if (isString$1(nextAttrValue)) {
      domStyle.cssText = nextAttrValue;
      return;
    }

    if (!isNullOrUndef(lastAttrValue) && !isString$1(lastAttrValue)) {
      for (style in nextAttrValue) {
        // do not add a hasOwnProperty check here, it affects performance
        value = nextAttrValue[style];

        if (value !== lastAttrValue[style]) {
          domStyle[style] = isNumber$1(value) ? getNumberStyleValue(style, value) : value;
        }
      }

      for (style in lastAttrValue) {
        if (isNullOrUndef(nextAttrValue[style])) {
          domStyle[style] = '';
        }
      }
    } else {
      for (style in nextAttrValue) {
        value = nextAttrValue[style];
        domStyle[style] = isNumber$1(value) ? getNumberStyleValue(style, value) : value;
      }
    }
  }

  function patchProp(prop, lastValue, nextValue, dom, isSVG, hasControlledValue, lastVNode) {
    switch (prop) {
      case 'onClick':
      case 'onDblClick':
      case 'onFocusIn':
      case 'onFocusOut':
      case 'onKeyDown':
      case 'onKeyPress':
      case 'onKeyUp':
      case 'onMouseDown':
      case 'onMouseMove':
      case 'onMouseUp':
      case 'onSubmit':
      case 'onTouchEnd':
      case 'onTouchMove':
      case 'onTouchStart':
        handleEvent(prop, nextValue, dom);
        break;

      case 'children':
      case 'childrenType':
      case 'className':
      case 'defaultValue':
      case 'key':
      case 'multiple':
      case 'ref':
        return;

      case 'allowfullscreen':
      case 'autoFocus':
      case 'autoplay':
      case 'capture':
      case 'checked':
      case 'controls':
      case 'default':
      case 'disabled':
      case 'hidden':
      case 'indeterminate':
      case 'loop':
      case 'muted':
      case 'novalidate':
      case 'open':
      case 'readOnly':
      case 'required':
      case 'reversed':
      case 'scoped':
      case 'seamless':
      case 'selected':
        prop = prop === 'autoFocus' ? prop.toLowerCase() : prop;
        dom[prop] = !!nextValue;
        break;

      case 'defaultChecked':
      case 'value':
      case 'volume':
        if (hasControlledValue && prop === 'value') {
          return;
        }

        var value = isNullOrUndef(nextValue) ? '' : nextValue;

        if (dom[prop] !== value) {
          dom[prop] = value;
        }

        break;

      case 'dangerouslySetInnerHTML':
        var lastHtml = lastValue && lastValue.__html || '';
        var nextHtml = nextValue && nextValue.__html || '';

        if (lastHtml !== nextHtml) {
          if (!isNullOrUndef(nextHtml) && !isSameInnerHTML(dom, nextHtml)) {
            if (!isNull(lastVNode)) {
              if (lastVNode.childFlags & 12
              /* MultipleChildren */
              ) {
                  unmountAllChildren(lastVNode.children);
                } else if (lastVNode.childFlags === 2
              /* HasVNodeChildren */
              ) {
                  unmount(lastVNode.children);
                }

              lastVNode.children = null;
              lastVNode.childFlags = 1
              /* HasInvalidChildren */
              ;
            }

            dom.innerHTML = nextHtml;
          }
        }

        break;

      default:
        if (prop[0] === 'o' && prop[1] === 'n') {
          patchEvent(prop, lastValue, nextValue, dom);
        } else if (isNullOrUndef(nextValue)) {
          dom.removeAttribute(prop);
        } else if (prop === 'style') {
          patchStyle(lastValue, nextValue, dom);
        } else if (isSVG && namespaces[prop]) {
          // We optimize for NS being boolean. Its 99.9% time false
          // If we end up in this path we can read property again
          dom.setAttributeNS(namespaces[prop], prop, nextValue);
        } else {
          dom.setAttribute(prop, nextValue);
        }

        break;
    }
  }

  function mountProps(vNode, flags, props, dom, isSVG) {
    var hasControlledValue = false;
    var isFormElement = (flags & 448
    /* FormElement */
    ) > 0;

    if (isFormElement) {
      hasControlledValue = isControlledFormElement(props);

      if (hasControlledValue) {
        addFormElementEventHandlers(flags, dom, props);
      }
    }

    for (var prop in props) {
      // do not add a hasOwnProperty check here, it affects performance
      patchProp(prop, null, props[prop], dom, isSVG, hasControlledValue, null);
    }

    if (isFormElement) {
      processElement(flags, vNode, dom, props, true, hasControlledValue);
    }
  }

  function createClassComponentInstance(vNode, Component, props, context) {
    var instance = new Component(props, context);
    vNode.children = instance;
    instance.$V = vNode;
    instance.$BS = false;
    instance.context = context;

    if (instance.props === EMPTY_OBJ) {
      instance.props = props;
    }

    instance.$UN = false;

    if (isFunction$1(instance.componentWillMount)) {
      instance.$BR = true;
      instance.componentWillMount();

      if (instance.$PSS) {
        var state = instance.state;
        var pending = instance.$PS;

        if (isNull(state)) {
          instance.state = pending;
        } else {
          for (var key in pending) {
            state[key] = pending[key];
          }
        }

        instance.$PSS = false;
        instance.$PS = null;
      }

      instance.$BR = false;
    }

    if (isFunction$1(options.beforeRender)) {
      options.beforeRender(instance);
    }

    var input = handleComponentInput(instance.render(props, instance.state, context), vNode);
    var childContext;

    if (isFunction$1(instance.getChildContext)) {
      childContext = instance.getChildContext();
    }

    if (isNull