'use strict';

var _interopRequireWildcard = function (obj) { return obj && obj.__esModule ? obj : { 'default': obj }; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } };

exports.__esModule = true;

var _Flux = require('./Flux');

var _Flux2 = _interopRequireWildcard(_Flux);

var _DragDropMonitor = require('./DragDropMonitor');

var _DragDropMonitor2 = _interopRequireWildcard(_DragDropMonitor);

var _HandlerRegistry = require('./utils/HandlerRegistry');

var _HandlerRegistry2 = _interopRequireWildcard(_HandlerRegistry);

var DragDropManager = (function () {
  function DragDropManager(createBackend) {
    _classCallCheck(this, DragDropManager);

    var flux = new _Flux2['default'](this);

    this.flux = flux;
    this.registry = new _HandlerRegistry2['default'](flux.registryActions);
    this.monitor = new _DragDropMonitor2['default'](flux, this.registry);
    this.backend = createBackend(this);

    flux.refCountStore.addListener('change', this.handleRefCountChange, this);
  }

  DragDropManager.prototype.handleRefCountChange = function handleRefCountChange() {
    var shouldSetUp = this.flux.refCountStore.hasRefs();
    if (shouldSetUp && !this.isSetUp) {
      this.backend.setup();
      this.isSetUp = true;
    } else if (!shouldSetUp && this.isSetUp) {
      this.backend.teardown();
      this.isSetUp = false;
    }
  };

  DragDropManager.prototype.getMonitor = function getMonitor() {
    return this.monitor;
  };

  DragDropManager.prototype.getBackend = function getBackend() {
    return this.backend;
  };

  DragDropManager.prototype.getRegistry = function getRegistry() {
    return this.registry;
  };

  DragDropManager.prototype.getActions = function getActions() {
    return this.flux.dragDropActions;
  };

  return DragDropManager;
})();

exports['default'] = DragDropManager;
module.exports = exports['default'];