'use strict';

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

exports.__esModule = true;

var _DropTarget6 = require('..');

var NormalTarget = (function (_DropTarget) {
  function NormalTarget(dropResult) {
    _classCallCheck(this, NormalTarget);

    _DropTarget.call(this);
    this.didCallDrop = false;
    this.didCallHover = false;
    this.dropResult = dropResult || { foo: 'bar' };
  }

  _inherits(NormalTarget, _DropTarget);

  NormalTarget.prototype.hover = function hover() {
    this.didCallHover = true;
  };

  NormalTarget.prototype.drop = function drop() {
    this.didCallDrop = true;
    return this.dropResult;
  };

  return NormalTarget;
})(_DropTarget6.DropTarget);

exports.NormalTarget = NormalTarget;

var NonDroppableTarget = (function (_DropTarget2) {
  function NonDroppableTarget() {
    _classCallCheck(this, NonDroppableTarget);

    _DropTarget2.call(this);
    this.didCallDrop = false;
    this.didCallHover = false;
  }

  _inherits(NonDroppableTarget, _DropTarget2);

  NonDroppableTarget.prototype.canDrop = function canDrop() {
    return false;
  };

  NonDroppableTarget.prototype.hover = function hover() {
    this.didCallHover = true;
  };

  NonDroppableTarget.prototype.drop = function drop() {
    this.didCallDrop = true;
  };

  return NonDroppableTarget;
})(_DropTarget6.DropTarget);

exports.NonDroppableTarget = NonDroppableTarget;

var TargetWithNoDropResult = (function (_DropTarget3) {
  function TargetWithNoDropResult() {
    _classCallCheck(this, TargetWithNoDropResult);

    _DropTarget3.call(this);
    this.didCallDrop = false;
    this.didCallHover = false;
  }

  _inherits(TargetWithNoDropResult, _DropTarget3);

  TargetWithNoDropResult.prototype.hover = function hover() {
    this.didCallHover = true;
  };

  TargetWithNoDropResult.prototype.drop = function drop() {
    this.didCallDrop = true;
  };

  return TargetWithNoDropResult;
})(_DropTarget6.DropTarget);

exports.TargetWithNoDropResult = TargetWithNoDropResult;

var BadResultTarget = (function (_DropTarget4) {
  function BadResultTarget() {
    _classCallCheck(this, BadResultTarget);

    if (_DropTarget4 != null) {
      _DropTarget4.apply(this, arguments);
    }
  }

  _inherits(BadResultTarget, _DropTarget4);

  BadResultTarget.prototype.drop = function drop() {
    return 42;
  };

  return BadResultTarget;
})(_DropTarget6.DropTarget);

exports.BadResultTarget = BadResultTarget;

var TransformResultTarget = (function (_DropTarget5) {
  function TransformResultTarget(transform) {
    _classCallCheck(this, TransformResultTarget);

    _DropTarget5.call(this);
    this.transform = transform;
    this.didCallDrop = false;
    this.didCallHover = false;
  }

  _inherits(TransformResultTarget, _DropTarget5);

  TransformResultTarget.prototype.hover = function hover() {
    this.didCallHover = true;
  };

  TransformResultTarget.prototype.drop = function drop(monitor) {
    this.didCallDrop = true;
    var dropResult = monitor.getDropResult();
    return this.transform(dropResult);
  };

  return TransformResultTarget;
})(_DropTarget6.DropTarget);

exports.TransformResultTarget = TransformResultTarget;