"use strict";

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

exports.__esModule = true;

var TestBackend = (function () {
  function TestBackend(actions) {
    _classCallCheck(this, TestBackend);

    this.actions = actions;
  }

  TestBackend.prototype.setup = function setup() {
    this.didCallSetup = true;
  };

  TestBackend.prototype.teardown = function teardown() {
    this.didCallTeardown = true;
  };

  TestBackend.prototype.simulateBeginDrag = function simulateBeginDrag(sourceIds, publishSource) {
    this.actions.beginDrag(sourceIds, publishSource);
  };

  TestBackend.prototype.simulatePublishDragSource = function simulatePublishDragSource() {
    this.actions.publishDragSource();
  };

  TestBackend.prototype.simulateHover = function simulateHover(targetIds) {
    this.actions.hover(targetIds);
  };

  TestBackend.prototype.simulateDrop = function simulateDrop() {
    this.actions.drop();
  };

  TestBackend.prototype.simulateEndDrag = function simulateEndDrag() {
    this.actions.endDrag();
  };

  return TestBackend;
})();

exports["default"] = TestBackend;
module.exports = exports["default"];