'use strict';

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

exports.__esModule = true;

var _Store2 = require('flummox');

var DragSourceStore = (function (_Store) {
  function DragSourceStore(flux, sourceId) {
    _classCallCheck(this, DragSourceStore);

    _Store.call(this);
    this.sourceId = sourceId;

    var dragDropActionIds = flux.dragDropActionIds;

    this.register(dragDropActionIds.beginDrag, this.handleBeginDrag);
    this.register(dragDropActionIds.publishDragSource, this.handlePublishDragSource);
    this.register(dragDropActionIds.endDrag, this.handleEndDrag);
    this.register(dragDropActionIds.drop, this.handleDrop);
  }

  _inherits(DragSourceStore, _Store);

  DragSourceStore.prototype.handleBeginDrag = function handleBeginDrag() {
    this.forceUpdate();
  };

  DragSourceStore.prototype.handlePublishDragSource = function handlePublishDragSource() {
    this.forceUpdate();
  };

  DragSourceStore.prototype.handleDrop = function handleDrop() {
    this.forceUpdate();
  };

  DragSourceStore.prototype.handleEndDrag = function handleEndDrag() {
    this.forceUpdate();
  };

  return DragSourceStore;
})(_Store2.Store);

exports['default'] = DragSourceStore;
module.exports = exports['default'];